/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import chemaxon.marvin.paint.internal.AromatiCalc;
import chemaxon.marvin.paint.internal.ColorCollection;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.paint.internal.Shades;
import chemaxon.marvin.paint.internal.ZigZagStroke;
import chemaxon.marvin.paint.internal.util.DrawingUtil;
import chemaxon.marvin.paint.internal.util.GraphicsUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.graphics.MPolyline;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class LinePainter {
    private static final boolean MACJAVA115;
    private MolPainterCommon common;
    private ColorCollection colorCollection;
    private double lineThickness;
    private int lineThicknessAsInt;
    private Color[] endColors = new Color[2];
    private double[] linePolyX = new double[4];
    private double[] linePolyY = new double[4];
    private double[] tmpPolyX = new double[1];
    private double[] tmpPolyY = new double[1];

    public double getLineThickness() {
        return this.lineThickness;
    }

    public int getLineThicknessAsInt() {
        return this.lineThicknessAsInt;
    }

    public void setLineThicknessAsInt(int lineThicknessAsInt) {
        this.lineThicknessAsInt = lineThicknessAsInt;
    }

    public void paintWavyLine(Graphics2D g, Point e1, Point e2) {
        Stroke old = g.getStroke();
        g.setStroke(new ZigZagStroke(this.lineThicknessAsInt));
        g.drawLine(e1.x, e1.y, e2.x, e2.y);
        g.setStroke(old);
    }

    public LinePainter(MolPainterCommon c, ColorCollection colors, double fthickness, int ithickness) {
        this.common = c;
        this.colorCollection = colors;
        this.lineThickness = fthickness;
        this.lineThicknessAsInt = ithickness;
    }

    public void setEndColors(Color c0, Color c1) {
        this.endColors[0] = c0;
        this.endColors[1] = c1;
    }

    public void setLineThickness(double t) {
        this.lineThickness = t;
    }

    public void drawLine(Graphics2D g, double x1, double y1, double z1, double x2, double y2, double z2, Shades shades, boolean front) {
        this.drawLine(g, x1, y1, z1, x2, y2, z2, shades, front, null);
    }

    private static void drawSegmentedLine(Graphics2D g, double x1, double y1, double x2, double y2, DPoint3[][] cpoints) {
        if (cpoints == null || cpoints.length == 0) {
            GraphicsUtil.drawLine(g, x1, y1, x2, y2);
        } else {
            double d = 0.0;
            ArrayList<Line2D.Double> segments = new ArrayList<Line2D.Double>();
            for (int j = 0; j < cpoints.length; ++j) {
                Line2D.Double intersection = DrawingUtil.intersect2DSegPoly(x1, y1, x2, y2, cpoints[j]);
                if (intersection == null) continue;
                segments.add(intersection);
            }
            segments.add(new Line2D.Double(x1, y1, x1, y1));
            segments.add(new Line2D.Double(x2, y2, x2, y2));
            Collections.sort(segments, new SegmentComparator(x1, y1));
            Line2D.Double actualSegment = null;
            for (int s = 0; s < segments.size(); ++s) {
                Line2D.Double segment = (Line2D.Double)segments.get(s);
                if (actualSegment == null || !DrawingUtil.containsPoint(actualSegment, segment.getP1())) {
                    actualSegment = segment;
                    continue;
                }
                if (!DrawingUtil.containsPoint(actualSegment, segment.getP1())) continue;
                if (!DrawingUtil.containsPoint(actualSegment, segment.getP2())) {
                    actualSegment.x2 = segment.x2;
                    actualSegment.y2 = segment.y2;
                }
                segments.remove(s);
                --s;
            }
            for (int i = 0; i < segments.size() - 1; ++i) {
                Point2D p1 = ((Line2D.Double)segments.get(i)).getP2();
                Point2D p2 = ((Line2D.Double)segments.get(i + 1)).getP1();
                GraphicsUtil.drawLine(g, p1.getX(), p1.getY(), p2.getX(), p2.getY());
            }
        }
    }

    public void drawLine(Graphics2D g, double x1, double y1, double z1, double x2, double y2, double z2, Shades shades, boolean front, DPoint3[][] cpoints) {
        this.drawLine(g, x1, y1, z1, x2, y2, z2, shades, front, cpoints, true);
    }

    private void drawLine(Graphics2D g, double x1, double y1, double z1, double x2, double y2, double z2, Shades shades, boolean front, DPoint3[][] cpoints, boolean decorate) {
        if (Double.isNaN(y2)) {
            y2 = y1;
        }
        if (Double.isNaN(x2) && !Double.isNaN(x1)) {
            x2 = x1;
        } else if (Double.isNaN(x1) && !Double.isNaN(x2)) {
            x1 = x2;
        }
        double fw = this.lineThickness;
        int style = this.common.getRenderingStyle();
        if (fw < 1.5 || style <= 131072 || shades == null || MACJAVA115) {
            Stroke old = LinePainter.setStroke(g, fw, decorate);
            if (this.endColors[0] == null) {
                LinePainter.drawSegmentedLine(g, x1, y1, x2, y2, cpoints);
            } else {
                double x = (x1 + x2) / 2.0;
                double y = (y1 + y2) / 2.0;
                g.setColor(this.endColors[0]);
                LinePainter.drawSegmentedLine(g, x1, y1, x, y, cpoints);
                g.setColor(this.endColors[1]);
                LinePainter.drawSegmentedLine(g, x, y, 2.0 * x - x1, 2.0 * y - y1, cpoints);
            }
            g.setStroke(old);
        } else {
            double deltay;
            double deltax;
            double deltaxy;
            if (z1 > z2 && this.endColors[0] == null) {
                double t = x1;
                x1 = x2;
                x2 = t;
                t = y1;
                y1 = y2;
                y2 = t;
                t = z1;
                z1 = z2;
                z2 = t;
            }
            if ((deltaxy = Math.sqrt((deltax = this.endColors[0] != null ? (x2 - x1) / 2.0 : x2 - x1) * deltax + (deltay = this.endColors[0] != null ? (y2 - y1) / 2.0 : y2 - y1) * deltay)) != 0.0) {
                int w = (int)(fw + 0.5);
                if (w == 0) {
                    w = 1;
                }
                double lz = z2 - z1;
                double lr = Math.sqrt(deltaxy * deltaxy + lz * lz);
                double lx = deltax / lr;
                double ly = deltay / lr;
                double lxy = Math.sqrt(lx * lx + ly * ly);
                double tx = ly / lxy;
                double ty = -lx / lxy;
                double ex = (lz /= lr) * lx / lxy;
                double ey = lz * ly / lxy;
                Color prevColor = g.getColor();
                if (front && this.tmpPolyX.length < 2 * w) {
                    this.tmpPolyX = new double[2 * w];
                    this.tmpPolyY = new double[2 * w];
                }
                for (int i = 1; i < w - 1; ++i) {
                    if (i == w / 2) continue;
                    this.drawLine0(i, w, x1, y1, deltax, deltay, lz, tx, ty, ex, ey, shades, g, false, front);
                }
                if (w > 2) {
                    this.drawLine0(w / 2, w, x1, y1, deltax, deltay, lz, tx, ty, ex, ey, shades, g, false, front);
                }
                this.drawLine0(0, w, x1, y1, deltax, deltay, lz, tx, ty, ex, ey, shades, g, true, front);
                if (w > 1) {
                    this.drawLine0(w - 1, w, x1, y1, deltax, deltay, lz, tx, ty, ex, ey, shades, g, true, front);
                }
                if (front) {
                    double f = lz;
                    if ((f = 0.2 + 0.8 * f) < 0.0) {
                        f = 0.0;
                    }
                    Color color = shades.getColor(f);
                    g.setColor(color);
                    LinePainter.fillPolygon(g, this.tmpPolyX, this.tmpPolyY, 2 * w);
                }
                g.setColor(prevColor);
            }
        }
    }

    public void draw2or3Line(Graphics2D g, double x1, double y1, double x2, double y2, double d, double w, int lines, DPoint3[][] cpoints) {
        double x12 = x2 - x1;
        double y12 = y2 - y1;
        double r12 = Math.sqrt(x12 * x12 + y12 * y12);
        double ex = x12 / r12;
        double ey = y12 / r12;
        if (lines == 2) {
            d /= 2.0;
        }
        double dx1 = d * ey;
        double dy1 = -d * ex;
        double x1p = x1 + dx1;
        double y1p = y1 + dy1;
        double dx2 = x2 - x1;
        double dy2 = y2 - y1;
        if (lines == 3) {
            this.draw3Lines(g, x1, y1, x2, y2, x1p, y1p, x1p + dx2, y1p + dy2, x1 + (x1 - x1p), y1 + (y1 - y1p), x1 + (x1 - x1p) + dx2, y1 + (y1 - y1p) + dy2, w, cpoints);
        } else {
            this.draw2Lines(g, x1p, y1p, x1p + dx2, y1p + dy2, x1 + (x1 - x1p), y1 + (y1 - y1p), x1 + (x1 - x1p) + dx2, y1 + (y1 - y1p) + dy2, w, cpoints);
        }
    }

    private void drawParallelLines(Graphics2D g, double x1a, double y1a, double x2a, double y2a, double x1b, double y1b, double x2b, double y2b, DPoint3[][] cpoints) {
        if (cpoints == null || cpoints.length == 0) {
            this.draw2ParallelLines(g, x1a, y1a, x2a, y2a, x1b, y1b, x2b, y2b);
        } else {
            LinePainter.drawSegmentedLine(g, x1a, y1a, x2a, y2a, cpoints);
            LinePainter.drawSegmentedLine(g, x1b, y1b, x2b, y2b, cpoints);
        }
    }

    private void draw2ParallelLines(Graphics2D g, double x1a, double y1a, double x2a, double y2a, double x1b, double y1b, double x2b, double y2b) {
        if (Double.isNaN(x1a) || Double.isNaN(y1a) || Double.isNaN(x2a) || Double.isNaN(y2a) || Double.isNaN(x1b) || Double.isNaN(y1b) || Double.isNaN(x2b) || Double.isNaN(y2b)) {
            return;
        }
        Object oldsc = GraphicsUtil.beginPureStrokeControl(g);
        g.draw(new Line2D.Double(x1a, y1a, x2a, y2a));
        g.draw(new Line2D.Double(x1b, y1b, x2b, y2b));
        GraphicsUtil.endPureStrokeControl(g, oldsc);
    }

    private void drawParallelLines(Graphics2D g, double x1a, double y1a, double x2a, double y2a, double x1b, double y1b, double x2b, double y2b, double x1c, double y1c, double x2c, double y2c, DPoint3[][] cpoints) {
        if (cpoints == null || cpoints.length == 0) {
            this.draw3ParallelLines(g, x1a, y1a, x2a, y2a, x1b, y1b, x2b, y2b, x1c, y1c, x2c, y2c);
        } else {
            LinePainter.drawSegmentedLine(g, x1a, y1a, x2a, y2a, cpoints);
            LinePainter.drawSegmentedLine(g, x1b, y1b, x2b, y2b, cpoints);
            LinePainter.drawSegmentedLine(g, x1c, y1c, x2c, y2c, cpoints);
        }
    }

    private void draw3ParallelLines(Graphics2D g, double x1a, double y1a, double x2a, double y2a, double x1b, double y1b, double x2b, double y2b, double x1c, double y1c, double x2c, double y2c) {
        if (Double.isNaN(x1a) || Double.isNaN(y1a) || Double.isNaN(x2a) || Double.isNaN(y2a) || Double.isNaN(x1b) || Double.isNaN(y1b) || Double.isNaN(x2b) || Double.isNaN(y2b) || Double.isNaN(x1c) || Double.isNaN(y1c) || Double.isNaN(x2c) || Double.isNaN(y2c)) {
            return;
        }
        Object oldsc = GraphicsUtil.beginPureStrokeControl(g);
        g.draw(new Line2D.Double(x1a, y1a, x2a, y2a));
        g.draw(new Line2D.Double(x1b, y1b, x2b, y2b));
        g.draw(new Line2D.Double(x1c, y1c, x2c, y2c));
        GraphicsUtil.endPureStrokeControl(g, oldsc);
    }

    public void drawLine(Graphics2D g, double x1a, double y1a, double x2a, double y2a, double w) {
        if (Double.isNaN(x1a) || Double.isNaN(y1a) || Double.isNaN(x2a) || Double.isNaN(y2a)) {
            return;
        }
        Stroke old = LinePainter.setStroke(g, w, false);
        if (this.endColors[0] == null) {
            Object oldsc = GraphicsUtil.beginPureStrokeControl(g);
            g.draw(new Line2D.Double(x1a, y1a, x2a, y2a));
            GraphicsUtil.endPureStrokeControl(g, oldsc);
        } else {
            double xca = (x1a + x2a) / 2.0;
            double yca = (y1a + y2a) / 2.0;
            g.setColor(this.endColors[0]);
            Object oldsc = GraphicsUtil.beginPureStrokeControl(g);
            g.draw(new Line2D.Double(x1a, y1a, xca, yca));
            g.setColor(this.endColors[1]);
            g.draw(new Line2D.Double(xca, yca, x2a, y2a));
            GraphicsUtil.endPureStrokeControl(g, oldsc);
        }
        g.setStroke(old);
    }

    public void draw2Lines(Graphics2D g, double x1a, double y1a, double x2a, double y2a, double x1b, double y1b, double x2b, double y2b, double w, DPoint3[][] cpoints) {
        Stroke old = LinePainter.setStroke(g, w);
        if (this.endColors[0] == null) {
            this.drawParallelLines(g, x1a, y1a, x2a, y2a, x1b, y1b, x2b, y2b, cpoints);
        } else {
            double xca = (x1a + x2a) / 2.0;
            double yca = (y1a + y2a) / 2.0;
            double xcb = (x1b + x2b) / 2.0;
            double ycb = (y1b + y2b) / 2.0;
            g.setColor(this.endColors[0]);
            this.drawParallelLines(g, x1a, y1a, xca, yca, x1b, y1b, xcb, ycb, cpoints);
            g.setColor(this.endColors[1]);
            this.drawParallelLines(g, xca, yca, x2a, y2a, xcb, ycb, x2b, y2b, cpoints);
        }
        g.setStroke(old);
    }

    private void draw3Lines(Graphics2D g, double x1a, double y1a, double x2a, double y2a, double x1b, double y1b, double x2b, double y2b, double x1c, double y1c, double x2c, double y2c, double w, DPoint3[][] cpoints) {
        Stroke old = LinePainter.setStroke(g, w);
        if (this.endColors[0] == null) {
            this.drawParallelLines(g, x1a, y1a, x2a, y2a, x1b, y1b, x2b, y2b, x1c, y1c, x2c, y2c, cpoints);
        } else {
            double xca = (x1a + x2a) / 2.0;
            double yca = (y1a + y2a) / 2.0;
            double xcb = (x1b + x2b) / 2.0;
            double ycb = (y1b + y2b) / 2.0;
            double xcc = (x1c + x2c) / 2.0;
            double ycc = (y1c + y2c) / 2.0;
            g.setColor(this.endColors[0]);
            this.drawParallelLines(g, x1a, y1a, xca, yca, x1b, y1b, xcb, ycb, x1c, y1c, xcc, ycc, cpoints);
            g.setColor(this.endColors[1]);
            this.drawParallelLines(g, xca, yca, x2a, y2a, xcb, ycb, x2b, y2b, xcc, ycc, x2c, y2c, cpoints);
        }
        g.setStroke(old);
    }

    public void dashedLine(double x1, double y1, double z1, double x2, double y2, double z2, int lp, int ld, Graphics2D g, Shades shades) {
        this.dashedLine(x1, y1, z1, x2, y2, z2, lp, ld, g, shades, true);
    }

    public void dashedLine(double x1, double y1, double z1, double x2, double y2, double z2, int lp, int ld, Graphics2D g, Shades shades, boolean decorate) {
        if (z1 > z2) {
            double t = x1;
            x1 = x2;
            x2 = t;
            t = y1;
            y1 = y2;
            y2 = t;
            t = z1;
            z1 = z2;
            z2 = t;
        }
        if (ld == Integer.MAX_VALUE) {
            this.drawLine(g, x1, y1, z1, x2, y2, z2, shades, true, null, decorate);
            return;
        }
        lp *= this.lineThicknessAsInt;
        ld = (ld + 1) * this.lineThicknessAsInt - 1;
        double deltax = x2 - x1;
        double deltay = y2 - y1;
        double deltaz = z2 - z1;
        double rxy2 = deltax * deltax + deltay * deltay;
        if (rxy2 == 0.0) {
            return;
        }
        double r = Math.sqrt(rxy2 + deltaz * deltaz);
        double qx = deltax / r;
        double qy = deltay / r;
        double qz = deltaz / r;
        double px = (double)lp * qx;
        double py = (double)lp * qy;
        double pz = (double)lp * qz;
        double dx = (double)ld * qx;
        double dy = (double)ld * qy;
        double dz = (double)ld * qz;
        int n = (int)(r / (double)lp);
        double m = r - (double)(n * lp);
        for (int i = 0; i < n; ++i) {
            double x = x1 + px * (double)i;
            double y = y1 + py * (double)i;
            double z = z1 + pz * (double)i;
            this.drawLine(g, x, y, z, x + dx, y + dy, z + dz, shades, true, null, decorate);
        }
        double x = x1 + px * (double)n;
        double y = y1 + py * (double)n;
        double z = z1 + pz * (double)n;
        if (m >= (double)ld) {
            this.drawLine(g, x, y, z, x + dx, y + dy, z + dz, shades, true, null, decorate);
        } else {
            this.drawLine(g, x, y, z, x + m * qx, y + m * qy, z + dz, shades, true, null, decorate);
        }
    }

    public void drawArrow(Graphics2D g, DPoint3 p1, DPoint3 p2, boolean front, int type, DPoint3[][] cpoints) {
        double lx = p2.x - p1.x;
        double ly = p2.y - p1.y;
        double lz = p2.z - p1.z;
        double l = Math.sqrt(lx * lx + ly * ly + lz * lz);
        double r = this.lineThickness / l;
        if (l == 0.0) {
            return;
        }
        this.common.setAntialiasing(g, true);
        Shades shades = this.common.getShades((MolAtom)null, null, this.colorCollection);
        switch (type) {
            case 0: 
            case 1: {
                double ct = 0.2222222222222222;
                double cl = 9.0 * r;
                DPoint3 q2 = new DPoint3(p2.x - lx * cl, p2.y - ly * cl, p2.z - lz * cl);
                DPoint3 q1 = p1;
                if (type == 1) {
                    q1 = new DPoint3(p1.x + lx * cl, p1.y + ly * cl, p1.z + lz * cl);
                }
                this.drawLine(g, q1.x, q1.y, q1.z, q2.x, q2.y, q2.z, shades, front, cpoints);
                LinePainter.drawArrowHead(g, q2, p2, ct, this.linePolyX, this.linePolyY, 0);
                if (type != 1) break;
                LinePainter.drawArrowHead(g, q1, p1, ct, this.linePolyX, this.linePolyY, 0);
                break;
            }
            case 2: 
            case 3: {
                double dw = 1.6 * r;
                double ct = 8.0 * r;
                double cl = 12.0 * r;
                double cm = 2.0 * dw * cl / ct;
                DPoint3 pl1 = new DPoint3(p1.x + ly * dw, p1.y - lx * dw, p1.z);
                DPoint3 pl2 = new DPoint3(p2.x + ly * dw, p2.y - lx * dw, p2.z);
                DPoint3 pl = type == 2 ? p2 : pl2;
                DPoint3 plb = new DPoint3(pl.x - lx * cl + ly * ct, pl.y - ly * cl - lx * ct, pl.z - lz * cl);
                DPoint3 plm = type == 2 ? new DPoint3(pl2.x - lx * cm, pl2.y - ly * cm, pl2.z - lz * cm) : pl2;
                this.drawLine(g, pl1.x, pl1.y, pl1.z, plm.x, plm.y, plm.z, shades, front);
                this.drawLine(g, plb.x, plb.y, plb.z, pl.x, pl.y, pl.z, shades, front);
                DPoint3 pr1 = new DPoint3(p1.x - ly * dw, p1.y + lx * dw, p1.z);
                DPoint3 pr2 = new DPoint3(p2.x - ly * dw, p2.y + lx * dw, p2.z);
                DPoint3 pr = type == 2 ? p2 : pr1;
                DPoint3 prb = type == 2 ? new DPoint3(pr.x - lx * cl - ly * ct, pr.y - ly * cl + lx * ct, pr.z - lz * cl) : new DPoint3(pr.x + lx * cl - ly * ct, pr.y + ly * cl + lx * ct, pr.z + lz * cl);
                DPoint3 prm = type == 2 ? new DPoint3(pr2.x - lx * cm, pr2.y - ly * cm, pr2.z - lz * cm) : pr2;
                this.drawLine(g, pr1.x, pr1.y, pr1.z, prm.x, prm.y, prm.z, shades, front);
                this.drawLine(g, prb.x, prb.y, prb.z, pr.x, pr.y, pr.z, shades, front);
            }
        }
        this.common.setAntialiasing(g, false);
    }

    public static double[][] drawArrowHead(Graphics2D g, DPoint3 p1, DPoint3 p2, double ct, double[] pxtmp, double[] pytmp, int flags, boolean full) {
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double dz = p2.z - p1.z;
        double xm = p2.x;
        double ym = p2.y;
        double zm = p2.z;
        double x0 = p1.x;
        double y0 = p1.y;
        double z0 = p1.z;
        double drxy = Math.sqrt(dx * dx + dy * dy);
        if (drxy != 0.0) {
            ct *= Math.sqrt(dx * dx + dy * dy + dz * dz) / drxy;
        }
        double xa = x0 - dy * ct;
        double ya = y0 + dx * ct;
        double xb = x0 + dy * ct;
        double yb = y0 - dx * ct;
        int half = flags & MPolyline.ARROW_HALF_MASK;
        pxtmp[0] = pxtmp[3] = xm;
        pytmp[0] = pytmp[3] = ym;
        if (half == MPolyline.ARROW_HALF_LEFT || half == 0) {
            pxtmp[1] = xb;
            pytmp[1] = yb;
        } else {
            pxtmp[1] = x0;
            pytmp[1] = y0;
        }
        if (half == MPolyline.ARROW_HALF_RIGHT || half == 0) {
            pxtmp[2] = xa;
            pytmp[2] = ya;
        } else {
            pxtmp[2] = x0;
            pytmp[2] = y0;
        }
        LinePainter.drawPolygon(g, pxtmp, pytmp);
        double[][] p = new double[][]{pxtmp, pytmp};
        return p;
    }

    public static void calculateArrowHead(DPoint3 p1, DPoint3 p2, double ct, double[] pxtmp, double[] pytmp, int flags) {
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double dz = p2.z - p1.z;
        double xm = p2.x;
        double ym = p2.y;
        double zm = p2.z;
        double x0 = p1.x;
        double y0 = p1.y;
        double z0 = p1.z;
        double drxy = Math.sqrt(dx * dx + dy * dy);
        if (drxy != 0.0) {
            ct *= Math.sqrt(dx * dx + dy * dy + dz * dz) / drxy;
        }
        double xa = x0 - dy * ct;
        double ya = y0 + dx * ct;
        double xb = x0 + dy * ct;
        double yb = y0 - dx * ct;
        int half = flags & MPolyline.ARROW_HALF_MASK;
        pxtmp[0] = pxtmp[3] = xm;
        pytmp[0] = pytmp[3] = ym;
        if (half == MPolyline.ARROW_HALF_LEFT || half == 0) {
            pxtmp[1] = xb;
            pytmp[1] = yb;
        } else {
            pxtmp[1] = x0;
            pytmp[1] = y0;
        }
        if (half == MPolyline.ARROW_HALF_RIGHT || half == 0) {
            pxtmp[2] = xa;
            pytmp[2] = ya;
        } else {
            pxtmp[2] = x0;
            pytmp[2] = y0;
        }
    }

    public static void drawArrowHead(Graphics2D g, DPoint3 p1, DPoint3 p2, double ct, double[] pxtmp, double[] pytmp, int flags) {
        LinePainter.calculateArrowHead(p1, p2, ct, pxtmp, pytmp, flags);
        LinePainter.fillPolygon(g, pxtmp, pytmp, 3);
        LinePainter.drawPolygon(g, pxtmp, pytmp);
    }

    public void paintBondUp(Graphics2D g, DPoint3 p1, double x2p, double y2p, double x2m, double y2m) {
        int[] px = new int[3];
        int[] py = new int[3];
        px[0] = (int)Math.round(p1.x);
        py[0] = (int)Math.round(p1.y);
        px[1] = (int)Math.round(x2p);
        py[1] = (int)Math.round(y2p);
        px[2] = (int)Math.round(x2m);
        py[2] = (int)Math.round(y2m);
        Color c0 = this.endColors[0];
        if (c0 != null) {
            Color oldcolor = g.getColor();
            g.setColor(c0);
            g.fillPolygon(px, py, 3);
            g.setColor(oldcolor);
        } else {
            g.fillPolygon(px, py, 3);
        }
    }

    public void paintBondDown(Graphics2D g, LinePainter lpainter, Shades shades, boolean front, int halves, boolean daylight, DPoint3 p1, double x12, double y12, double r12, double dx, double dy) {
        int iR = (int)Math.round(r12);
        int di = Math.max((int)Math.round(2.5 * this.lineThickness + 0.5), 2);
        for (int i = iR; i >= 0; i -= di) {
            double ql = (double)i / r12;
            double qt = daylight ? 1.0 - ql : ql;
            double x = p1.x + x12 * ql;
            double y = p1.y + y12 * ql;
            double dxq = dx * qt;
            double dyq = dy * qt;
            lpainter.drawLine(g, x + dxq, y + dyq, 0.0, x - dxq, y - dyq, 0.0, shades, front);
        }
    }

    public void paintBondHashed(Graphics2D g, Shades shades, boolean front, double scale, DPoint3 p1, DPoint3 p2) {
        Color saved_endcolor0 = this.endColors[0];
        Color saved_endcolor1 = this.endColors[1];
        Color oldColor = g.getColor();
        this.endColors[0] = null;
        this.endColors[1] = null;
        double x12 = p2.x - p1.x;
        double y12 = p2.y - p1.y;
        double r12 = Math.sqrt(x12 * x12 + y12 * y12);
        int iR = (int)Math.round(r12);
        int hiR = iR / 2;
        double dxq = scale * (y12 / r12) * ((double)(iR / 5) / r12);
        double dyq = -scale * (x12 / r12) * ((double)(iR / 5) / r12);
        int di = Math.max((int)Math.round(2.5 * this.lineThickness + 0.5), 2);
        if (saved_endcolor1 != null) {
            g.setColor(saved_endcolor1);
        }
        for (int i = iR; i >= 0; i -= di) {
            double ql = (double)i / r12;
            double x = p1.x + x12 * ql;
            double y = p1.y + y12 * ql;
            if (i <= hiR && saved_endcolor0 != null) {
                g.setColor(saved_endcolor0);
            }
            this.drawLine(g, x + dxq, y + dyq, 0.0, x - dxq, y - dyq, 0.0, shades, front);
        }
        this.endColors[0] = saved_endcolor0;
        this.endColors[1] = saved_endcolor1;
        g.setColor(oldColor);
    }

    public void paintBondEither(Graphics2D g, LinePainter lpainter, Shades shades, boolean front, int halves, DPoint3 p1, double d, double x12, double y12, double r12, double dx, double dy) {
        int iR = (int)(r12 + 0.5);
        Object pc = null;
        int di = (int)(0.75 * d + 0.5);
        if (di < 1) {
            di = 1;
        }
        double xc = 0.0;
        double yc = 0.0;
        for (int i = iR; i >= di; i -= 2 * di) {
            double qa = (double)i / r12;
            double qb = (double)(i - di) / r12;
            double xa = p1.x + (x12 + dx) * qa;
            double ya = p1.y + (y12 + dy) * qa;
            double xb = p1.x + (x12 - dx) * qb;
            double yb = p1.y + (y12 - dy) * qb;
            this.drawLine(g, xa, ya, 0.0, xb, yb, 0.0, shades, front);
            if (i < iR) {
                this.drawLine(g, xc, yc, 0.0, xa, ya, 0.0, shades, front);
            }
            xc = xb;
            yc = yb;
        }
    }

    private void drawLine0(int i, int w, double x1, double y1, double deltax, double deltay, double lz, double tx, double ty, double ex, double ey, Shades shades, Graphics2D g, boolean antialias, boolean front) {
        double uw = (double)i + 0.5 - 0.5 * (double)w;
        double uwl = uw - 0.5;
        double uwr = uw + 0.5;
        double vwl = 0.25 * (double)w * (double)w - uwl * uwl;
        double vwr = 0.25 * (double)w * (double)w - uwr * uwr;
        vwl = vwl > 0.0 ? Math.sqrt(vwl) : 0.0;
        vwr = vwr > 0.0 ? Math.sqrt(vwr) : 0.0;
        double xl = x1 - uwl * tx - vwl * ex;
        double yl = y1 - uwl * ty - vwl * ey;
        double xr = x1 - uwr * tx - vwr * ex;
        double yr = y1 - uwr * ty - vwr * ey;
        double u = 2.0 * uw / (double)w;
        double u1 = Math.sqrt(1.0 - u * u);
        double nz = -u1 * (1.0 - lz * lz);
        double f = -nz;
        if ((f = 0.2 + 0.8 * f) < 0.0) {
            f = 0.0;
        }
        Color color = shades.getColor(f);
        g.setColor(color);
        double[] px = this.linePolyX;
        double[] py = this.linePolyY;
        px[0] = xl;
        py[0] = yl;
        px[1] = xl + deltax;
        py[1] = yl + deltay;
        px[2] = xr + deltax;
        py[2] = yr + deltay;
        px[3] = xr;
        py[3] = yr;
        if (antialias) {
            this.common.setAntialiasing(g, antialias);
        }
        GraphicsUtil.fillPolygon(g, px, py);
        LinePainter.drawPolygon(g, px, py);
        if (front) {
            this.tmpPolyX[i] = px[1];
            this.tmpPolyY[i] = py[1];
            this.tmpPolyX[w + i] = x1 + deltax + (x1 - xl);
            this.tmpPolyY[w + i] = y1 + deltay + (y1 - yl);
        }
    }

    public void drawReactingCenter(Graphics2D g, double x1, double y1, double z1, double x2, double y2, double z2, Shades shades, boolean front, int rcFlag) {
        double ratio = 4.5;
        double srx = (x2 - x1) / ratio;
        double sry = (y2 - y1) / ratio;
        double mx = (x1 + x2) / 2.0;
        double my = (y1 + y2) / 2.0;
        double ax = mx + sry;
        double ay = my - srx;
        double bx = mx - sry;
        double by = my + srx;
        double mbShift = 0.8;
        double lx = (x1 + mbShift * x2) / (1.0 + mbShift);
        double ly = (y1 + mbShift * y2) / (1.0 + mbShift);
        double mcShift = 0.7;
        double mclx = (x1 + mcShift * x2) / (1.0 + mcShift);
        double mcly = (y1 + mcShift * y2) / (1.0 + mcShift);
        double rx = (x1 + 1.0 / mcShift * x2) / (1.0 + 1.0 / mcShift);
        double ry = (y1 + 1.0 / mcShift * y2) / (1.0 + 1.0 / mcShift);
        if (rcFlag > 0) {
            switch (rcFlag) {
                case 12288: {
                    this.drawLine(g, ax, ay, z1, bx, by, z2, shades, front);
                    break;
                }
                case 8192: {
                    this.drawLine(g, lx + sry, ly - srx, z1, lx - sry, ly + srx, z2, shades, front);
                    this.drawLine(g, rx + sry, ry - srx, z1, rx - sry, ry + srx, z2, shades, front);
                    break;
                }
                case 16384: {
                    this.drawLine(g, mclx + sry, mcly - srx, z1, mclx - sry, mcly + srx, z2, shades, front);
                    this.drawLine(g, rx + sry, ry - srx, z1, rx - sry, ry + srx, z2, shades, front);
                    this.drawLine(g, ax, ay, z1, bx, by, z2, shades, front);
                    break;
                }
                case 20480: {
                    this.drawLine(g, lx + sry, ly - srx, z1, rx - sry, ry + srx, z2, shades, front);
                    this.drawLine(g, rx + sry, ry - srx, z1, lx - sry, ly + srx, z2, shades, front);
                    break;
                }
                case 4096: {
                    this.drawLine(g, ax, ay, z1, mclx - sry, mcly + srx, z2, shades, front);
                    this.drawLine(g, rx + sry, ry - srx, z1, bx, by, z2, shades, front);
                    this.drawLine(g, mclx + sry / 2.0, mcly - srx / 2.0, z1, rx + sry / 2.0, ry - srx / 2.0, z2, shades, front);
                    this.drawLine(g, mclx - sry / 2.0, mcly + srx / 2.0, z1, rx - sry / 2.0, ry + srx / 2.0, z2, shades, front);
                    break;
                }
            }
        }
    }

    private void paintBondByPoints(Graphics2D g, ArrayList<Double> pxs, ArrayList<Double> pys) {
        Color c0 = this.endColors[0];
        if (c0 != null) {
            Color oldcolor = g.getColor();
            g.setColor(c0);
            LinePainter.fillPolygon(g, pxs, pys);
            g.setColor(oldcolor);
        } else {
            LinePainter.fillPolygon(g, pxs, pys);
        }
    }

    public void drawAromaticRing(Graphics2D g, MDocument doc, MolBond b, MolAtom a2, double[] ringCoords, boolean[] ringColors) {
        Color c;
        Stroke old = LinePainter.setStroke(g, this.lineThickness);
        Color oldcolor = g.getColor();
        int setNo = b.getSetSeq();
        int scheme = this.common.getDispopts() & 0xC0;
        Color color = c = scheme == 128 ? this.colorCollection.getResidueTypeColor(a2.getResidueType()) : this.colorCollection.getForeground();
        if (ringColors[0]) {
            g.setColor(this.colorCollection.getSelectionColor());
        } else if (this.common.isSetColoringEnabled() && doc != null) {
            if (!ringColors[3] || doc.getBondSetColor(setNo) == null && !ringColors[2] || doc.getAtomSetColor(a2.getSetSeq()) == null && !ringColors[1] && scheme != 128) {
                g.setColor(c);
            } else if (a2.isSelected()) {
                c = this.calcRingColor(doc, this.colorCollection, a2, setNo);
                g.setColor(c);
            }
        } else if (!ringColors[1]) {
            g.setColor(c);
        } else if (a2.isSelected()) {
            c = this.calcRingColor(doc, this.colorCollection, a2, setNo);
            g.setColor(c);
        }
        Point center = new Point((int)Math.round(ringCoords[0]), (int)Math.round(ringCoords[1]));
        double angle = ringCoords[5];
        if (angle != 0.0) {
            g.rotate(angle, center.x, center.y);
        }
        int ry = (int)(ringCoords[4] + 0.5);
        int rx = ringCoords[3] == ringCoords[4] ? ry : (int)(ringCoords[3] - 0.5);
        g.draw(new Ellipse2D.Double(center.x - rx, center.y - ry, 2 * rx, 2 * ry));
        if (angle != 0.0) {
            g.rotate(-angle, center.x, center.y);
        }
        g.setColor(oldcolor);
        g.setStroke(old);
    }

    private Color calcRingColor(MDocument doc, ColorCollection colors, MolAtom a2, int setNo) {
        int dispopts;
        Color c = null;
        if (this.common.isSetColoringEnabled() && doc != null && doc.getBondSetColor(setNo) != null) {
            c = this.common.getBondSetColor(setNo, doc, colors);
        } else if (a2.getSetSeq() == 0 || a2.getSetSeq() != 0 && doc != null) {
            c = this.common.getColor(a2, doc, this.colorCollection);
        }
        if (c == null) {
            c = colors.getForeground();
        }
        if (((dispopts = this.common.getDispopts()) & 0x40000000) != 0) {
            c = GraphicsUtil.applyFog(c, this.colorCollection.getBackground(), 0.5);
        }
        return c;
    }

    private static void drawPolygon(Graphics2D g, double[] pxs, double[] pys) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)pxs[0], (float)pys[0]);
        for (int i = 1; i < 4; ++i) {
            gp.lineTo((float)pxs[i], (float)pys[i]);
        }
    }

    private static void fillPolygon(Graphics2D g, double[] pxs, double[] pys, int flags) {
        Object oldsc = GraphicsUtil.beginPureStrokeControl(g);
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)pxs[0], (float)pys[0]);
        for (int i = 1; i < flags; ++i) {
            gp.lineTo((float)pxs[i], (float)pys[i]);
        }
        g.fill(gp);
        GraphicsUtil.endPureStrokeControl(g, oldsc);
    }

    private static void fillPolygon(Graphics2D g, ArrayList<Double> pxs, ArrayList<Double> pys) {
        Object oldsc = GraphicsUtil.beginPureStrokeControl(g);
        int n = pxs.size() == pys.size() ? pxs.size() : 0;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(pxs.get(0).floatValue(), pys.get(0).floatValue());
        for (int i = 1; i < n; ++i) {
            gp.lineTo(pxs.get(i).floatValue(), pys.get(i).floatValue());
        }
        g.fill(gp);
        GraphicsUtil.endPureStrokeControl(g, oldsc);
    }

    public static Stroke setStroke(Graphics2D g, double w) {
        Stroke old = g.getStroke();
        BasicStroke s = new BasicStroke((float)w, 2, 2);
        g.setStroke(s);
        return old;
    }

    public static Stroke setStroke(Graphics2D g, double w, boolean decorate) {
        Stroke old = g.getStroke();
        BasicStroke s = new BasicStroke((float)w, decorate ? 2 : 0, 2);
        g.setStroke(s);
        return old;
    }

    public void paintBondUp(Graphics2D g, MoleculeGraph mol, MolBond b, MolAtom a1, MolAtom a2, DPoint3 p1, DPoint3 p2, int lab1, int lab2, DPoint3[] screenCoords, double x1p, double y1p, double x1m, double y1m, double x2p, double y2p, double x2m, double y2m, double ex, double ey, double d) {
        double[] coords;
        int j;
        ArrayList<Double> xcoords = new ArrayList<Double>();
        ArrayList<Double> ycoords = new ArrayList<Double>();
        boolean corrected = false;
        if (lab1 == 0) {
            int bna1 = a1.getBondCount();
            for (j = 0; j < bna1 && !corrected; ++j) {
                MolBond ba1 = a1.getBond(j);
                int ba1flags = ba1.getFlags();
                int ba1stereo = ba1flags & 0x30;
                if (ba1.equals(b) || !ba1.isBold() && ba1stereo != 16 || (coords = this.correctBondUpVertexCoordinates(mol, p2, p1, screenCoords, a1, ba1, d)) == null) continue;
                x1p = x1m = coords[0];
                xcoords.add(x1m);
                y1p = y1m = coords[1];
                ycoords.add(y1m);
                corrected = true;
            }
        }
        if (!corrected) {
            double dist = p1.distance2D(p2);
            if (dist < 2.0 * d) {
                x1p = x1m = p1.x;
                xcoords.add(x1m);
                y1p = y1m = p1.y;
                ycoords.add(y1m);
            } else {
                double lt = this.lineThickness / 2.0;
                double ltx = lt * ey;
                double lty = -lt * ex;
                x1p = p1.x + ltx;
                xcoords.add(x1p);
                y1p = p1.y + lty;
                ycoords.add(y1p);
                x1m = p1.x - ltx;
                xcoords.add(x1m);
                y1m = p1.y - lty;
                ycoords.add(y1m);
            }
        }
        corrected = false;
        if (lab2 == 0) {
            int bna2 = a2.getBondCount();
            for (j = 0; j < bna2 && !corrected; ++j) {
                MolBond ba2 = a2.getBond(j);
                int ba2flags = ba2.getFlags();
                int ba2stereo = ba2flags & 0x30;
                if (ba2.equals(b) || !ba2.isBold() && ba2stereo != 16 || (coords = this.correctBondUpLineCoordinates(mol, p1, p2, screenCoords, x1p, y1p, x1m, y1m, x2p, y2p, x2m, y2m, a2, ba2, d)) == null) continue;
                xcoords.add(coords[2]);
                ycoords.add(coords[3]);
                xcoords.add(coords[0]);
                ycoords.add(coords[1]);
                corrected = true;
            }
            if (!corrected && bna2 > 1) {
                DPoint3[] p3s = this.findClosestBonds(mol, b, a2, bna2, screenCoords, p1, p2, ex, ey, d, false);
                double[] ipp1 = new double[2];
                double[] ipp2 = new double[2];
                if (p3s[1] != null) {
                    double[] lmbp = this.calcSideLineOfBondByPoints(-1, p2, p3s[1]);
                    ipp1 = DrawingUtil.calcIntersectPointOf2Lines(lmbp[0], lmbp[1], lmbp[2], lmbp[3], x1p, y1p, x2p, y2p);
                    ipp2 = DrawingUtil.calcIntersectPointOf2Lines(lmbp[0], lmbp[1], lmbp[2], lmbp[3], x1m, y1m, x2m, y2m);
                    xcoords.add(ipp2[0]);
                    ycoords.add(ipp2[1]);
                    xcoords.add(ipp1[0]);
                    ycoords.add(ipp1[1]);
                    corrected = true;
                }
                if (p3s[0] != null) {
                    double[] lpbm = this.calcSideLineOfBondByPoints(1, p2, p3s[0]);
                    double[] ipm1 = DrawingUtil.calcIntersectPointOf2Lines(lpbm[0], lpbm[1], lpbm[2], lpbm[3], x1p, y1p, x2p, y2p);
                    double[] ipm2 = DrawingUtil.calcIntersectPointOf2Lines(lpbm[0], lpbm[1], lpbm[2], lpbm[3], x1m, y1m, x2m, y2m);
                    if (corrected) {
                        double[] ip = DrawingUtil.calcIntersectPointOf2Lines(ipm1[0], ipm1[1], ipm2[0], ipm2[1], ipp1[0], ipp1[1], ipp2[0], ipp2[1]);
                        xcoords.remove(ipp1[0]);
                        ycoords.remove(ipp1[1]);
                        xcoords.remove(ipp2[0]);
                        ycoords.remove(ipp2[1]);
                        xcoords.add(ipm2[0]);
                        ycoords.add(ipm2[1]);
                        xcoords.add(ip[0]);
                        ycoords.add(ip[1]);
                        xcoords.add(ipp1[0]);
                        ycoords.add(ipp1[1]);
                    } else {
                        xcoords.add(ipm2[0]);
                        ycoords.add(ipm2[1]);
                        xcoords.add(ipm1[0]);
                        ycoords.add(ipm1[1]);
                        corrected = true;
                    }
                }
            }
        }
        if (!corrected) {
            xcoords.add(x2m);
            ycoords.add(y2m);
            xcoords.add(x2p);
            ycoords.add(y2p);
        }
        this.paintBondByPoints(g, xcoords, ycoords);
    }

    private DPoint3[] findClosestBonds(MoleculeGraph mol, MolBond b, MolAtom a, int bna, DPoint3[] screenCoords, DPoint3 p1, DPoint3 p2, double ex, double ey, double d, boolean turnedPoints) {
        DPoint3[] p3s = new DPoint3[2];
        double minanglem = 2.8797932657906435;
        double minanglep = 2.8797932657906435;
        for (int j = 0; j < bna; ++j) {
            int[][] sssrIdx;
            int[][] sssr;
            AromatiCalc ac;
            int sidedness;
            MolBond ba2 = a.getBond(j);
            int ba2f = ba2.getFlags();
            if (ba2.equals(b) || ba2f <= 0 || ba2f >= 8 || ba2f == 5) continue;
            MolAtom a3 = ba2.getOtherAtom(a);
            int i3 = mol.indexOf(a3);
            DPoint3 p3 = screenCoords[i3];
            if (ba2f == 2 && (sidedness = (ac = new AromatiCalc(screenCoords, mol)).calcDoubleBondSidedness(ba2, a, a3, p2, p3, sssr = mol.getSSSR(), sssrIdx = mol.getSSSRIdxesForAtoms())) == 0) continue;
            double angle = !turnedPoints ? DrawingUtil.calculateAngle2D(p1, p3, p2) : DrawingUtil.calculateAngle2D(p2, p3, p1);
            double[] T = DrawingUtil.calcIntersectPointOf2Lines(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p3.x + d * ey, p3.y - d * ex);
            int side = Math.abs(ey) < 0.01 && (p1.x < p2.x && p3.y < p1.y || p1.x > p2.x && p3.y > p1.y) || Math.abs(ex) < 0.01 && (p1.y > p2.y && p3.x < p1.x || p1.y < p2.y && p3.x > p1.x) || (p3.x - T[0]) / ey > 0.0 && (T[1] - p3.y) / ex > 0.0 ? 1 : -1;
            if (side == 1 && angle < minanglep && angle > 0.2617993877991494) {
                minanglep = angle;
                p3s[1] = p3;
                continue;
            }
            if (side != -1 || !(angle < minanglem) || !(angle > 0.2617993877991494)) continue;
            minanglem = angle;
            p3s[0] = p3;
        }
        return p3s;
    }

    private double[] calcSideLineOfBondByPoints(int side, DPoint3 p2, DPoint3 p3s) {
        double[] lsb = new double[4];
        double x23 = 0.0;
        int x23i = (int)(Math.round(p3s.x) - Math.round(p2.x));
        if (x23i != 0) {
            x23 = p3s.x - p2.x;
        }
        double y23 = p3s.y - p2.y;
        double r23 = Math.sqrt(x23 * x23 + y23 * y23);
        double ex23 = 0.0;
        double ey23 = 0.0;
        if (r23 != 0.0) {
            ex23 = x23 / r23;
            ey23 = y23 / r23;
        }
        double lt = this.lineThickness / 2.0;
        double ltx = lt * ey23;
        double lty = -lt * ex23;
        lsb[0] = p2.x + (double)side * ltx;
        lsb[1] = p2.y + (double)side * lty;
        lsb[2] = p3s.x + (double)side * ltx;
        lsb[3] = p3s.y + (double)side * lty;
        return lsb;
    }

    private double[] correctBondUpVertexCoordinates(MoleculeGraph mol, DPoint3 p1, DPoint3 p2, DPoint3[] screenCoords, MolAtom a2, MolBond b2, double d) {
        double beta;
        DPoint3 p3;
        double[] bcoords = new double[2];
        MolAtom a21 = b2.getAtom1();
        MolAtom a22 = b2.getAtom2();
        int i3 = 0;
        boolean isturnedb2 = false;
        if (a21.equals(a2)) {
            i3 = mol.indexOf(a22);
        }
        if (a22.equals(a2)) {
            i3 = mol.indexOf(a21);
            isturnedb2 = true;
        }
        DPoint3 dPoint3 = p3 = i3 >= 0 ? screenCoords[i3] : null;
        if (p3 == null) {
            return null;
        }
        double alpha = p2.angle2D(p1.x, p1.y);
        if (alpha < 0.0) {
            alpha += Math.PI * 2;
        }
        if ((beta = p2.angle2D(p3.x, p3.y)) < 0.0) {
            beta += Math.PI * 2;
        }
        double bondsan = beta - alpha;
        double baa = Math.abs(bondsan);
        double dist12 = p1.distance2D(p2);
        double dist23 = p2.distance2D(p3);
        double dif = Math.abs(Math.PI - baa);
        int b2stereo = b2.getFlags() & 0x30;
        if (b2stereo == 16 && !isturnedb2 || dif < 0.5235987755982988 && (dif * dist12 < d * 3.0 || dif * dist23 < d * 3.0) || baa < 1.5707963267948966 && (baa * dist12 < d * 3.0 || baa * dist23 < d * 3.0) || Math.PI * 2 - baa < 1.5707963267948966 && ((Math.PI * 2 - baa) * dist12 < d * 3.0 || (Math.PI * 2 - baa) * dist23 < d * 3.0) || dist12 < 2.0 * d || dist23 < 2.0 * d) {
            return null;
        }
        double[] coords23 = new double[4];
        if (bondsan < -Math.PI || bondsan > 0.0 && bondsan < Math.PI) {
            coords23 = this.calcOneSideOfaBond(b2, p2, p3, d, false, isturnedb2);
        } else if (bondsan < 0.0 && bondsan > -Math.PI || bondsan > Math.PI) {
            coords23 = this.calcOneSideOfaBond(b2, p2, p3, d, true, isturnedb2);
        }
        bcoords[0] = coords23[0];
        bcoords[1] = coords23[1];
        return bcoords;
    }

    private double[] correctBondUpLineCoordinates(MoleculeGraph mol, DPoint3 p1, DPoint3 p2, DPoint3[] screenCoords, double x1p, double y1p, double x1m, double y1m, double x2p, double y2p, double x2m, double y2m, MolAtom a2, MolBond b2, double d) {
        boolean overlap;
        double beta;
        DPoint3 p3;
        double[] bcoords = new double[4];
        MolAtom a21 = b2.getAtom1();
        MolAtom a22 = b2.getAtom2();
        int i3 = 0;
        boolean isturnedb2 = false;
        if (a21.equals(a2)) {
            i3 = mol.indexOf(a22);
        }
        if (a22.equals(a2)) {
            i3 = mol.indexOf(a21);
            isturnedb2 = true;
        }
        DPoint3 dPoint3 = p3 = i3 >= 0 ? screenCoords[i3] : null;
        if (p3 == null) {
            return null;
        }
        double alpha = p2.angle2D(p1.x, p1.y);
        if (alpha < 0.0) {
            alpha += Math.PI * 2;
        }
        if ((beta = p2.angle2D(p3.x, p3.y)) < 0.0) {
            beta += Math.PI * 2;
        }
        double bondsan = beta - alpha;
        double baa = Math.abs(bondsan);
        double dist12 = p1.distance2D(p2);
        double dist23 = p2.distance2D(p3);
        double dif = Math.abs(Math.PI - baa);
        boolean inline = dif < 0.5235987755982988 && (dif * dist12 < d * 3.0 || dif * dist23 < d * 3.0);
        int b2stereo = b2.getFlags() & 0x30;
        boolean bl = overlap = baa < 1.5707963267948966 && (baa * dist12 < d * 3.0 || baa * dist23 < d * 3.0) || Math.PI * 2 - baa < 1.5707963267948966 && ((Math.PI * 2 - baa) * dist12 < d * 3.0 || (Math.PI * 2 - baa) * dist23 < d * 3.0);
        if (baa > 2.941592653589793 && baa < 3.3415926535897933 && dist12 > d * 3.4 && dist23 > d * 3.4 || !isturnedb2 && b2stereo == 16 && (inline || dist12 < 2.0 * d || dist23 < 2.0 * d || overlap)) {
            return null;
        }
        double[] coords12 = new double[4];
        if (overlap) {
            double[] coords23 = this.calcOneEndpointOfaBond(p2, p3, d);
            if (!b2.isBold()) {
                bcoords[0] = (coords23[2] + x2p) / 2.0;
                bcoords[1] = (coords23[3] + y2p) / 2.0;
                bcoords[2] = (coords23[0] + x2m) / 2.0;
                bcoords[3] = (coords23[1] + y2m) / 2.0;
            } else {
                bcoords[0] = coords23[2];
                bcoords[1] = coords23[3];
                bcoords[2] = coords23[0];
                bcoords[3] = coords23[1];
            }
        } else if (dist12 < 2.0 * d || dist23 < 2.0 * d) {
            double[] coords23 = this.calcOneEndpointOfaBond(p2, p3, d);
            if (!b2.isBold()) {
                bcoords[0] = (coords23[0] + x2p) / 2.0;
                bcoords[1] = (coords23[1] + y2p) / 2.0;
                bcoords[2] = (coords23[2] + x2m) / 2.0;
                bcoords[3] = (coords23[3] + y2m) / 2.0;
            } else {
                bcoords[0] = coords23[0];
                bcoords[1] = coords23[1];
                bcoords[2] = coords23[2];
                bcoords[3] = coords23[3];
            }
        } else if (bondsan < -Math.PI || bondsan > 0.0 && bondsan < Math.PI) {
            double[] coords23 = this.calcOneSideOfaBond(b2, p2, p3, d, false, isturnedb2);
            if (!isturnedb2 && !b2.isBold()) {
                coords12[0] = x1p;
                coords12[1] = y1p;
                coords12[2] = x2p;
                coords12[3] = y2p;
                coords23[0] = x2m;
                coords23[1] = y2m;
                double[] ip1 = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                bcoords[0] = ip1[0];
                bcoords[1] = ip1[1];
                bcoords[2] = x2m;
                bcoords[3] = y2m;
            } else {
                double[] ip;
                coords12[0] = x1m;
                coords12[1] = y1m;
                coords12[2] = x2m;
                coords12[3] = y2m;
                if (DrawingUtil.areLinesParallel(coords12, coords23)) {
                    bcoords[2] = x2m;
                    bcoords[3] = y2m;
                } else {
                    ip = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                    bcoords[2] = ip[0];
                    bcoords[3] = ip[1];
                }
                coords12[0] = x1p;
                coords12[1] = y1p;
                coords12[2] = x2p;
                coords12[3] = y2p;
                coords23 = this.calcOneSideOfaBond(b2, p2, p3, d, true, isturnedb2);
                if (inline || DrawingUtil.areLinesParallel(coords12, coords23)) {
                    bcoords[0] = x2p;
                    bcoords[1] = y2p;
                } else {
                    ip = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                    bcoords[0] = ip[0];
                    bcoords[1] = ip[1];
                }
            }
        } else if (bondsan < 0.0 && bondsan > -Math.PI || bondsan > Math.PI) {
            double[] coords23 = this.calcOneSideOfaBond(b2, p2, p3, d, true, isturnedb2);
            if (!isturnedb2 && !b2.isBold()) {
                coords12[0] = x1m;
                coords12[1] = y1m;
                coords12[2] = x2m;
                coords12[3] = y2m;
                coords23[0] = x2p;
                coords23[1] = y2p;
                double[] ip1 = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                bcoords[0] = x2p;
                bcoords[1] = y2p;
                bcoords[2] = ip1[0];
                bcoords[3] = ip1[1];
            } else {
                coords12[0] = x1p;
                coords12[1] = y1p;
                coords12[2] = x2p;
                coords12[3] = y2p;
                double[] ip = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                bcoords[0] = ip[0];
                bcoords[1] = ip[1];
                coords12[0] = x1m;
                coords12[1] = y1m;
                coords12[2] = x2m;
                coords12[3] = y2m;
                coords23 = this.calcOneSideOfaBond(b2, p2, p3, d, false, isturnedb2);
                if (inline || DrawingUtil.areLinesParallel(coords12, coords23)) {
                    bcoords[2] = x2m;
                    bcoords[3] = y2m;
                } else {
                    ip = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                    bcoords[2] = ip[0];
                    bcoords[3] = ip[1];
                }
            }
        }
        return bcoords;
    }

    private double[] calcOneEndpointOfaBond(DPoint3 p2, DPoint3 p3, double d) {
        double[] coords23 = new double[4];
        double x23 = p3.x - p2.x;
        double y23 = p3.y - p2.y;
        double r23 = Math.sqrt(x23 * x23 + y23 * y23);
        double ex = x23 / r23;
        double ey = y23 / r23;
        double dx = d * ey;
        double dy = -d * ex;
        coords23[0] = p2.x + dx;
        coords23[1] = p2.y + dy;
        coords23[2] = p2.x - dx;
        coords23[3] = p2.y - dy;
        return coords23;
    }

    private double[] calcOneSideOfaBond(MolBond b2, DPoint3 p2, DPoint3 p3, double d, boolean isleft, boolean isturnedb2) {
        double[] coords23 = new double[4];
        double x23 = p3.x - p2.x;
        double y23 = p3.y - p2.y;
        double r23 = Math.sqrt(x23 * x23 + y23 * y23);
        double ex = x23 / r23;
        double ey = y23 / r23;
        double dx = d * ey;
        double dy = -d * ex;
        int b2flags = b2.getFlags();
        int b2stereo = b2flags & 0x30;
        if (b2.isBold() && isleft) {
            coords23[0] = p2.x + dx;
            coords23[1] = p2.y + dy;
            coords23[2] = p3.x + dx;
            coords23[3] = p3.y + dy;
        } else if (b2.isBold() && !isleft) {
            coords23[0] = p2.x - dx;
            coords23[1] = p2.y - dy;
            coords23[2] = p3.x - dx;
            coords23[3] = p3.y - dy;
        } else if (b2stereo == 16) {
            if (isturnedb2) {
                coords23[2] = p3.x;
                coords23[3] = p3.y;
                if (isleft) {
                    coords23[0] = p2.x + dx;
                    coords23[1] = p2.y + dy;
                } else {
                    coords23[0] = p2.x - dx;
                    coords23[1] = p2.y - dy;
                }
            } else {
                coords23[0] = p2.x;
                coords23[1] = p2.y;
                if (isleft) {
                    coords23[2] = p3.x - dx;
                    coords23[3] = p3.y - dy;
                } else {
                    coords23[2] = p3.x + dx;
                    coords23[3] = p3.y + dy;
                }
            }
        }
        return coords23;
    }

    public void paintBoldBond(Graphics2D g, MoleculeGraph mol, MolBond b, MolAtom a1, MolAtom a2, DPoint3 p1, DPoint3 p2, int lab1, int lab2, DPoint3[] screenCoords, double x1p, double y1p, double x1m, double y1m, double x2p, double y2p, double x2m, double y2m, double ex, double ey, double d) {
        double[] ip;
        double[] ipm2;
        double[] ipm1;
        double[] ipp1;
        double[] coords;
        int j;
        ArrayList<Double> xcoords = new ArrayList<Double>();
        ArrayList<Double> ycoords = new ArrayList<Double>();
        boolean corrected = false;
        if (lab1 == 0) {
            int bna1 = a1.getBondCount();
            for (j = 0; j < bna1 && !corrected; ++j) {
                MolBond ba1 = a1.getBond(j);
                int ba1flags = ba1.getFlags();
                int ba1stereo = ba1flags & 0x30;
                if (ba1.equals(b) || !ba1.isBold() && ba1stereo != 16 || (coords = this.correctBoldBondLineCoordinates(mol, p2, p1, screenCoords, x2m, y2m, x2p, y2p, x1m, y1m, x1p, y1p, a1, ba1, d)) == null) continue;
                x1p = coords[2];
                xcoords.add(x1p);
                y1p = coords[3];
                ycoords.add(y1p);
                x1m = coords[0];
                xcoords.add(x1m);
                y1m = coords[1];
                ycoords.add(y1m);
                corrected = true;
            }
            if (!corrected && bna1 > 1) {
                DPoint3[] p3s = Math.abs(ex) < 0.01 || Math.abs(ey) < 0.01 ? this.findClosestBonds(mol, b, a1, bna1, screenCoords, p1, p2, ex, ey, d, true) : this.findClosestBonds(mol, b, a1, bna1, screenCoords, p2, p1, ex, ey, d, false);
                ipp1 = new double[2];
                double[] ipp2 = new double[2];
                if (p3s[1] != null) {
                    double[] lmbp = this.calcSideLineOfBondByPoints(1, p1, p3s[1]);
                    ipp1 = DrawingUtil.calcIntersectPointOf2Lines(lmbp[0], lmbp[1], lmbp[2], lmbp[3], x1m, y1m, x2m, y2m);
                    ipp2 = DrawingUtil.calcIntersectPointOf2Lines(lmbp[0], lmbp[1], lmbp[2], lmbp[3], x1p, y1p, x2p, y2p);
                    xcoords.add(ipp2[0]);
                    ycoords.add(ipp2[1]);
                    xcoords.add(ipp1[0]);
                    ycoords.add(ipp1[1]);
                    corrected = true;
                }
                if (p3s[0] != null) {
                    double[] lpbm = this.calcSideLineOfBondByPoints(-1, p1, p3s[0]);
                    ipm1 = DrawingUtil.calcIntersectPointOf2Lines(lpbm[0], lpbm[1], lpbm[2], lpbm[3], x1m, y1m, x2m, y2m);
                    ipm2 = DrawingUtil.calcIntersectPointOf2Lines(lpbm[0], lpbm[1], lpbm[2], lpbm[3], x1p, y1p, x2p, y2p);
                    if (corrected) {
                        ip = DrawingUtil.calcIntersectPointOf2Lines(ipm1[0], ipm1[1], ipm2[0], ipm2[1], ipp1[0], ipp1[1], ipp2[0], ipp2[1]);
                        if (xcoords.size() > 1 && ycoords.size() > 1) {
                            xcoords.remove(xcoords.size() - 1);
                            ycoords.remove(ycoords.size() - 1);
                            xcoords.remove(xcoords.size() - 1);
                            ycoords.remove(ycoords.size() - 1);
                        }
                        xcoords.add(ipp2[0]);
                        ycoords.add(ipp2[1]);
                        xcoords.add(ip[0]);
                        ycoords.add(ip[1]);
                        xcoords.add(ipm1[0]);
                        ycoords.add(ipm1[1]);
                    } else {
                        xcoords.add(ipm2[0]);
                        ycoords.add(ipm2[1]);
                        xcoords.add(ipm1[0]);
                        ycoords.add(ipm1[1]);
                        corrected = true;
                    }
                }
            }
        }
        if (!corrected) {
            xcoords.add(x1p);
            ycoords.add(y1p);
            xcoords.add(x1m);
            ycoords.add(y1m);
        }
        corrected = false;
        if (lab2 == 0) {
            int bna2 = a2.getBondCount();
            for (j = 0; j < bna2 && !corrected; ++j) {
                MolBond ba2 = a2.getBond(j);
                int ba2flags = ba2.getFlags();
                int ba2stereo = ba2flags & 0x30;
                if (ba2.equals(b) || !ba2.isBold() && ba2stereo != 16 || (coords = this.correctBoldBondLineCoordinates(mol, p1, p2, screenCoords, x1p, y1p, x1m, y1m, x2p, y2p, x2m, y2m, a2, ba2, d)) == null) continue;
                x2m = coords[2];
                xcoords.add(x2m);
                y2m = coords[3];
                ycoords.add(y2m);
                x2p = coords[0];
                xcoords.add(x2p);
                y2p = coords[1];
                ycoords.add(y2p);
                corrected = true;
            }
            if (!corrected && bna2 > 1) {
                DPoint3[] p3s = this.findClosestBonds(mol, b, a2, bna2, screenCoords, p1, p2, ex, ey, d, false);
                ipp1 = new double[2];
                double[] ipp2 = new double[2];
                if (p3s[1] != null) {
                    double[] lmbp = this.calcSideLineOfBondByPoints(-1, p2, p3s[1]);
                    ipp1 = DrawingUtil.calcIntersectPointOf2Lines(lmbp[0], lmbp[1], lmbp[2], lmbp[3], x1p, y1p, x2p, y2p);
                    ipp2 = DrawingUtil.calcIntersectPointOf2Lines(lmbp[0], lmbp[1], lmbp[2], lmbp[3], x1m, y1m, x2m, y2m);
                    xcoords.add(ipp2[0]);
                    ycoords.add(ipp2[1]);
                    xcoords.add(ipp1[0]);
                    ycoords.add(ipp1[1]);
                    corrected = true;
                }
                if (p3s[0] != null) {
                    double[] lpbm = this.calcSideLineOfBondByPoints(1, p2, p3s[0]);
                    ipm1 = DrawingUtil.calcIntersectPointOf2Lines(lpbm[0], lpbm[1], lpbm[2], lpbm[3], x1p, y1p, x2p, y2p);
                    ipm2 = DrawingUtil.calcIntersectPointOf2Lines(lpbm[0], lpbm[1], lpbm[2], lpbm[3], x1m, y1m, x2m, y2m);
                    if (corrected) {
                        ip = DrawingUtil.calcIntersectPointOf2Lines(ipm1[0], ipm1[1], ipm2[0], ipm2[1], ipp1[0], ipp1[1], ipp2[0], ipp2[1]);
                        if (xcoords.size() > 1 && ycoords.size() > 1) {
                            xcoords.remove(xcoords.size() - 1);
                            ycoords.remove(ycoords.size() - 1);
                            xcoords.remove(xcoords.size() - 1);
                            ycoords.remove(ycoords.size() - 1);
                        }
                        xcoords.add(ipm2[0]);
                        ycoords.add(ipm2[1]);
                        xcoords.add(ip[0]);
                        ycoords.add(ip[1]);
                        xcoords.add(ipp1[0]);
                        ycoords.add(ipp1[1]);
                    } else {
                        xcoords.add(ipm2[0]);
                        ycoords.add(ipm2[1]);
                        xcoords.add(ipm1[0]);
                        ycoords.add(ipm1[1]);
                        corrected = true;
                    }
                }
            }
        }
        if (!corrected) {
            xcoords.add(x2m);
            ycoords.add(y2m);
            xcoords.add(x2p);
            ycoords.add(y2p);
        }
        this.paintBondByPoints(g, xcoords, ycoords);
    }

    private double[] correctBoldBondLineCoordinates(MoleculeGraph mol, DPoint3 p1, DPoint3 p2, DPoint3[] screenCoords, double x1p, double y1p, double x1m, double y1m, double x2p, double y2p, double x2m, double y2m, MolAtom a2, MolBond b2, double d) {
        boolean inline;
        double beta;
        DPoint3 p3;
        double[] bcoords = new double[4];
        MolAtom a21 = b2.getAtom1();
        MolAtom a22 = b2.getAtom2();
        int i3 = 0;
        boolean isturnedb2 = false;
        int b2stereo = b2.getFlags() & 0x30;
        if (a21.equals(a2)) {
            i3 = mol.indexOf(a22);
        }
        if (a22.equals(a2)) {
            i3 = mol.indexOf(a21);
            isturnedb2 = true;
        }
        DPoint3 dPoint3 = p3 = i3 >= 0 ? screenCoords[i3] : null;
        if (p3 == null) {
            return null;
        }
        double alpha = p2.angle2D(p1.x, p1.y);
        if (alpha < 0.0) {
            alpha += Math.PI * 2;
        }
        if ((beta = p2.angle2D(p3.x, p3.y)) < 0.0) {
            beta += Math.PI * 2;
        }
        double bondsan = beta - alpha;
        double aba = Math.abs(bondsan);
        double dist12 = p1.distance2D(p2);
        double dist23 = p2.distance2D(p3);
        double dif = Math.abs(Math.PI - aba);
        boolean bl = inline = dif < 0.5235987755982988 && (dif * dist12 < d * 3.0 || dif * dist23 < d * 3.0);
        if (!b2.isBold() && (dist12 < 2.0 * d || dist23 < 2.0 * d) || inline || aba < 1.5707963267948966 && (aba * dist12 < d * 3.0 || aba * dist23 < d * 3.0) || Math.PI * 2 - aba < 1.5707963267948966 && ((Math.PI * 2 - aba) * dist12 < d * 3.0 || (Math.PI * 2 - aba) * dist23 < d * 3.0)) {
            return null;
        }
        double[] coords12 = new double[4];
        if (bondsan < -Math.PI || bondsan > 0.0 && bondsan < Math.PI) {
            double[] coords23 = this.calcOneSideOfaBond(b2, p2, p3, d, false, isturnedb2);
            if (!isturnedb2 && b2stereo == 16) {
                coords12[0] = x1p;
                coords12[1] = y1p;
                coords12[2] = x2p;
                coords12[3] = y2p;
                coords23[0] = x2m;
                coords23[1] = y2m;
                double[] ip1 = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                bcoords[0] = ip1[0];
                bcoords[1] = ip1[1];
                bcoords[2] = x2m;
                bcoords[3] = y2m;
            } else {
                if (aba > 2.941592653589793 && aba < 3.3415926535897933) {
                    bcoords[0] = x2p;
                    bcoords[1] = y2p;
                    bcoords[2] = coords23[0];
                    bcoords[3] = coords23[1];
                    return bcoords;
                }
                coords12[0] = x1m;
                coords12[1] = y1m;
                coords12[2] = x2m;
                coords12[3] = y2m;
                double[] ip = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                bcoords[2] = ip[0];
                bcoords[3] = ip[1];
                coords12[0] = x1p;
                coords12[1] = y1p;
                coords12[2] = x2p;
                coords12[3] = y2p;
                coords23 = this.calcOneSideOfaBond(b2, p2, p3, d, true, isturnedb2);
                if (inline || DrawingUtil.areLinesParallel(coords12, coords23)) {
                    bcoords[0] = x2p;
                    bcoords[1] = y2p;
                } else {
                    ip = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                    bcoords[0] = ip[0];
                    bcoords[1] = ip[1];
                }
            }
        } else if (bondsan < 0.0 && bondsan > -Math.PI || bondsan > Math.PI) {
            double[] coords23 = this.calcOneSideOfaBond(b2, p2, p3, d, true, isturnedb2);
            if (!isturnedb2 && b2stereo == 16) {
                coords12[0] = x1m;
                coords12[1] = y1m;
                coords12[2] = x2m;
                coords12[3] = y2m;
                coords23[0] = x2p;
                coords23[1] = y2p;
                double[] ip1 = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                bcoords[0] = x2p;
                bcoords[1] = y2p;
                bcoords[2] = ip1[0];
                bcoords[3] = ip1[1];
            } else {
                double[] ip;
                if (aba > 2.941592653589793 && aba < 3.3415926535897933) {
                    bcoords[0] = coords23[0];
                    bcoords[1] = coords23[1];
                    bcoords[2] = x2m;
                    bcoords[3] = y2m;
                    return bcoords;
                }
                coords12[0] = x1p;
                coords12[1] = y1p;
                coords12[2] = x2p;
                coords12[3] = y2p;
                if (DrawingUtil.areLinesParallel(coords12, coords23)) {
                    bcoords[0] = x2p;
                    bcoords[1] = y2p;
                } else {
                    ip = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                    bcoords[0] = ip[0];
                    bcoords[1] = ip[1];
                }
                coords12[0] = x1m;
                coords12[1] = y1m;
                coords12[2] = x2m;
                coords12[3] = y2m;
                coords23 = this.calcOneSideOfaBond(b2, p2, p3, d, false, isturnedb2);
                if (inline || DrawingUtil.areLinesParallel(coords12, coords23)) {
                    bcoords[2] = x2m;
                    bcoords[3] = y2m;
                } else {
                    ip = DrawingUtil.calcIntersectPointOf2Lines(coords12, coords23);
                    bcoords[2] = ip[0];
                    bcoords[3] = ip[1];
                }
            }
        }
        return bcoords;
    }

    public static void gDrawLine(Graphics2D g, int x1, int y1, int x2, int y2) {
        try {
            g.drawLine(x1, y1, x2, y2);
        }
        catch (Throwable ex) {
            System.err.println("Graphics.drawLine bug " + x1 + " " + y1 + " " + x2 + " " + y2 + " " + ex.getMessage());
        }
    }

    static {
        String jver = System.getProperty("java.version");
        String vendor = System.getProperty("java.vendor");
        String os = System.getProperty("os.name");
        MACJAVA115 = vendor.equals("Netscape Communications Corporation") && os.equals("Mac OS") && jver.equals("1.1.5");
    }

    private static class SegmentComparator
    implements Comparator {
        Point2D.Double point = null;

        public SegmentComparator(double x, double y) {
            this.point = new Point2D.Double(x, y);
        }

        public int compare(Object o1, Object o2) {
            Line2D segment1 = (Line2D)o1;
            Line2D segment2 = (Line2D)o2;
            return (int)Math.ceil(this.point.distance(segment1.getX1(), segment1.getY1()) - this.point.distance(segment2.getX1(), segment2.getY1()));
        }
    }
}

