/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import chemaxon.common.util.text.SimpleTeX;
import chemaxon.core.util.GeomUtil;
import chemaxon.marvin.io.formats.OleGraphics2DIface;
import chemaxon.marvin.modules.LonePairPainter;
import chemaxon.marvin.paint.DispOptConsts;
import chemaxon.marvin.paint.internal.AromatiCalc;
import chemaxon.marvin.paint.internal.AtomLabeller;
import chemaxon.marvin.paint.internal.ColorCollection;
import chemaxon.marvin.paint.internal.FontMaker;
import chemaxon.marvin.paint.internal.GraphicsPainter;
import chemaxon.marvin.paint.internal.GraphicsPresentationChooser;
import chemaxon.marvin.paint.internal.LinePainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.paint.internal.Shades;
import chemaxon.marvin.paint.internal.TextGraphics;
import chemaxon.marvin.paint.internal.util.DrawingUtil;
import chemaxon.marvin.paint.internal.util.GraphicsUtil;
import chemaxon.marvin.paint.internal.util.clip.QuadTree;
import chemaxon.marvin.sketch.GroupUtil;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.MolImageSize;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MObjectContainer;
import chemaxon.struc.MPoint;
import chemaxon.struc.MProp;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PageSettings;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RgMoleculeGraphIface;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.graphics.MAssigner;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.graphics.MEFlow;
import chemaxon.struc.graphics.MMidPoint;
import chemaxon.struc.graphics.MMoleculeMovie;
import chemaxon.struc.graphics.MNameTextBox;
import chemaxon.struc.graphics.MRArrow;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.prop.MDoubleArrayProp;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MolPainter
implements DispOptConsts,
StereoConstants,
Serializable {
    private static final long serialVersionUID = 6671219186650256734L;
    public static final double DEFAULT_ATOM_SIZE = 0.4;
    private static final int HALIGN_LEFT = 0;
    private static final int HALIGN_CENTER = 1;
    private static final int VALIGN_CENTER = 2;
    private static String os = System.getProperty("os.name");
    private static final String ABS_STEREO_LABEL = "Absolute";
    private MolPainterCommon common;
    private MolImageSize imageSize = new MolImageSize(0, 0, 0.0);
    private double trax = 0.0;
    private double tray = 0.0;
    private boolean centralized = false;
    private boolean fixbounds = false;
    private double[] boundsXYRR = new double[4];
    private double mag0;
    private double atomSize = 0.4;
    private transient Font normalFont = null;
    private transient Font italicFont = null;
    private transient Font boldFont = null;
    private transient Font smallFont;
    private transient Font labelFont = null;
    private transient Font bigBoldFont = null;
    private transient FontMetrics normalFontMetrics = null;
    private transient FontMetrics italicFontMetrics = null;
    private transient FontMetrics boldFontMetrics = null;
    private transient FontMetrics smallFontMetrics = null;
    private transient FontMetrics labelFontMetrics = null;
    private transient FontMetrics bigBoldFontMetrics = null;
    private transient DPoint3[] screenCoords;
    private ArrayList<RoundRectangle2D> coveringLabels = new ArrayList();
    private CTransform3D transformMatrix = new CTransform3D();
    private CTransform3D invTransform = new CTransform3D();
    private CTransform3D preTransform = new CTransform3D();
    private CTransform3D invPreTransform = new CTransform3D();
    private Point corner = new Point(0, 0);
    private Map<Integer, ArrayList<Integer>> ringBondIndexes = new HashMap<Integer, ArrayList<Integer>>();
    private int atomMinx;
    private int atomMiny;
    private double minScreenZ;
    private double maxScreenZ;
    private boolean anyBondIsSolidLine = false;
    private transient MarvinModule spacefiller = null;
    private ColorCollection theColors;
    private boolean isTransparent = false;
    private boolean isClipping = true;
    boolean wasDragged = false;
    double zPhi;
    int prevAxis;
    private final GraphicsPresentationChooser grPres;
    private boolean isFogApplicable;
    private double[][] atomCoordsOffVect;

    public MolPainter(MolPainterCommon common) {
        this.imageSize.scale = -1.0;
        this.mag0 = -1.0;
        this.common = common;
        this.theColors = common.reuseColorCollection(Color.white);
        this.grPres = new GraphicsPresentationChooser();
    }

    public MolPainter(MolPainterCommon common, double x, double y, double rx, double ry) {
        this(common);
        this.fixbounds = true;
        this.setBoundsXYRR(x, y, rx, ry);
        this.setScale(24.0);
        this.updateTransform();
    }

    public void resetMolPainter() {
        this.setScale(24.0);
        this.setIdentityTransform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorner(Point p) {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            this.corner.x = p.x;
            this.corner.y = p.y;
            this.updateTransform();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getCorner() {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            return new Point(this.corner.x, this.corner.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAtomSize() {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            return this.atomSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomSize(double l) {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            this.atomSize = l;
            this.resetFonts0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLineThickness() {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            double w = MolPainter.getLineThickness(this.imageSize.scale / 1.54, this.common.getWireThickness(), this.common.getStickThickness(), this.common.getDispopts());
            return w;
        }
    }

    public int getLineThicknessAsInt() {
        int w = (int)Math.round(this.getLineThickness());
        return w > 1 ? w : 1;
    }

    public static MolPainter createBondPainter() {
        MolPainterCommon common = new MolPainterCommon();
        MolPainter p = new MolPainter(common, 0.0, 0.0, 0.8470000000000001, 0.385);
        p.setScale(24.0);
        return p;
    }

    private static double getLineThickness(double mag, double wirew, double stickw, int opts) {
        double w;
        int style = opts & 0xE0000;
        double d = w = style <= 131072 ? wirew * mag : stickw * mag;
        if (w < 1.0 && (opts & 0x800000) != 0) {
            double a = 0.85;
            w = (8.0 * a - 3.0 + (8.0 - 16.0 * a) * w + (8.0 * a - 4.0) * w * w) * w;
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getScale() {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            return this.mag0 * 1.54;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(double z) {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            if (this.mag0 != (z /= 1.54)) {
                this.mag0 = z;
                this.setCentralized(this.centralized);
                this.resetFonts0();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrinterScale(double z) {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            if (this.mag0 != z) {
                this.mag0 = z;
                this.setCentralized(this.centralized);
                this.resetFonts0();
            }
        }
    }

    public Color getBackground() {
        return this.theColors.getBackground();
    }

    public void setBackground(Color bg) {
        if (!bg.equals(this.theColors.getBackground())) {
            this.getCommon().freeColorCollection(this.theColors);
            this.theColors = this.common.reuseColorCollection(bg);
        }
    }

    public Color getColor(MolAtom a, MDocument doc) {
        return this.common.getColor(a, doc, this.getColors());
    }

    public Shades getShades(MolAtom a, MDocument doc) {
        return this.common.getShades(a, doc, this.getColors());
    }

    public Shades getShades(MolBond b, MDocument doc) {
        return this.common.getShades(b, doc, this.getColors());
    }

    public Color getShadowColor() {
        ColorCollection colors = this.getColors();
        return colors.isLight() ? ColorCollection.LIGHT_GRAY : Color.darkGray;
    }

    private Color getMultipageColor() {
        ColorCollection colors = this.getColors();
        return colors.isLight() ? Color.black : Color.white;
    }

    public Color getMultipageSelectionColor() {
        ColorCollection colors = this.getColors();
        return colors.isLight() ? Color.black : Color.white;
    }

    private void spacefill(double mag) {
        int style = this.common.getRenderingStyle();
        ColorCollection colors = this.getColors();
        this.spacefiller = (MarvinModule)MarvinModule.load("Spacefill", null);
        Object[] args = new Object[]{colors.getBackground(), colors.getForeground(), this, new Double(style == 393216 ? this.common.getBallRadius() * mag : mag)};
        this.spacefiller.modfunc(args);
    }

    private Image getBallImage(MolAtom a, MoleculeGraph molg, double mag) {
        if (System.getProperty("java.version").equals("1.4.1_01") && System.getProperty("os.name").indexOf("Windows") != -1) {
            this.spacefill(mag);
        }
        if (this.spacefiller != null) {
            Object[] args = new Object[]{a, molg};
            return (Image)this.spacefiller.getSomething(args);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DPoint3 calcMolP(int x, int y) {
        DPoint3 p = new DPoint3(x, y, 0.0);
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            CTransform3D inv = this.invTransform;
            inv.transform(p);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcGP(DPoint3 p) {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            CTransform3D t = this.transformMatrix;
            t.transform(p);
        }
    }

    public Point calcGP(double x, double y, double z) {
        DPoint3 p = new DPoint3(x, y, z);
        this.calcGP(p);
        return new Point((int)Math.round(p.x), (int)Math.round(p.y));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(CTransform3D l, boolean rescale) {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            l.mul(this.preTransform);
            this.setRTransform(l, rescale);
        }
    }

    public CTransform3D getTransformMatrix() {
        return this.transformMatrix;
    }

    public CTransform3D getRTransform() {
        return this.getRTransform(null);
    }

    public CTransform3D getInvRTransform() {
        return this.getInvRTransform(null);
    }

    public CTransform3D getRTransformRef() {
        return this.preTransform;
    }

    public CTransform3D getInvRTransformRef() {
        return this.invPreTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTransform3D getRTransform(CTransform3D t) {
        if (t == null) {
            t = new CTransform3D();
        }
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            t.set(this.preTransform);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTransform3D getInvRTransform(CTransform3D t) {
        if (t == null) {
            t = new CTransform3D();
        }
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            t.set(this.invPreTransform);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentityTransform() {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            this.preTransform.setIdentity();
            this.invPreTransform.setIdentity();
            this.updateTransform();
        }
    }

    public void setRTransform(CTransform3D t) {
        this.setRTransform(t, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRTransform(CTransform3D t, boolean rescale) {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            this.preTransform.set(t);
            double c = 1.0;
            if (rescale) {
                c = t.getScale();
                this.preTransform.setScale(1.0);
                this.preTransform.m03 /= c;
                this.preTransform.m13 /= c;
                this.preTransform.m23 /= c;
            }
            this.invPreTransform.set(this.preTransform);
            this.invPreTransform.invert();
            if (rescale) {
                this.mag0 *= c;
            }
            this.updateTransform();
        }
    }

    public void setRTransformFromDocument(MDocument doc) {
        MProp o = doc.properties().get("viewEulerAngles");
        if (o != null && o instanceof MDoubleArrayProp) {
            CTransform3D t = new CTransform3D();
            double[] x = ((MDoubleArrayProp)o).getDoubleArray();
            t.setEuler(x[0], x[1], x[2]);
            this.setRTransform(t);
        }
    }

    public void storeRTransformInDocument(MDocument doc) {
        double[] x;
        double[] o = null;
        if (doc.getMainMoleculeGraph().getDim() == 3 && (x = this.getRTransform().getEuler())[0] * x[0] + x[1] * x[1] + x[2] * x[2] > 1.0E-18) {
            o = x;
        }
        doc.properties().setObject("viewEulerAngles", o);
    }

    private void updateTransform() {
        double c;
        CTransform3D t = this.transformMatrix;
        t.setIdentity();
        t.m00 = c = this.mag0;
        t.m11 = -c;
        t.m22 = c;
        t.setTranslation((this.trax - (this.boundsXYRR[0] - this.boundsXYRR[2])) * c - (double)this.corner.x, (this.tray + (this.boundsXYRR[1] + this.boundsXYRR[3])) * c - (double)this.corner.y, 0.0);
        t.mul(this.preTransform);
        double oldScale = this.imageSize.scale;
        this.imageSize.scale = Math.abs(t.getScale()) * 1.54;
        this.invTransform.set(t);
        this.invTransform.invert();
        if (oldScale != this.imageSize.scale) {
            this.resetFonts0();
        }
    }

    public void paintDocument(Graphics2D g, MDocument doc, MDocument sel) throws SecurityException {
        this.paintDocument(g, doc, null, sel);
    }

    public void paintMolecule(Graphics2D g, MoleculeGraph molg) throws SecurityException {
        MDocument doc = molg.getDocument();
        if (doc != null) {
            this.paintDocument(g, doc, molg, null);
        } else {
            this.paintDocument(g, null, molg, null);
        }
    }

    private void paintDocument(Graphics2D g, MDocument doc, MoleculeGraph molg, MDocument sel) throws SecurityException {
        Molecule mm;
        MDocument pntdoc;
        MoleculeGraph umol;
        List<MolAtom[]> incipientBonds;
        this.isClipping = MolPainter.isClippingSupported(g);
        Font originalFont = g.getFont();
        int dispopts = this.common.getDispopts();
        int style = dispopts & 0xE0000;
        boolean enableRgroups = (dispopts & 0x4000000) != 0;
        List<MolAtom[]> list = incipientBonds = doc != null ? MolPainter.findIncipientBonds(doc) : null;
        if (style == 393216 || style == 524288) {
            this.spacefill(this.imageSize.scale / 1.54);
        }
        ColorCollection colors = this.getColors();
        LinePainter lpainter = new LinePainter(this.common, colors, this.getLineThickness(), this.getLineThicknessAsInt());
        int nobjs = doc != null ? this.countObjects(doc, incipientBonds) : this.countObjects(molg);
        Object[] objs = new Object[nobjs];
        int n = nobjs = doc != null ? this.fillObjectArray(objs, doc, incipientBonds) : this.fillObjectArray(objs, molg, null, 0);
        if (molg == null) {
            molg = MolPainter.getMainMoleculeGraph(doc);
        }
        if (molg instanceof RgMoleculeGraphIface && !enableRgroups) {
            umol = ((RgMoleculeGraphIface)((Object)molg)).getRootG();
            pntdoc = umol.getParent().getDocument();
        } else {
            umol = molg.getGraphUnion();
            pntdoc = doc;
        }
        if (molg instanceof Molecule && (mm = (Molecule)molg).getSgroupCount() > 0) {
            this.paintSgroupShadow(g, mm);
        }
        if (pntdoc != null) {
            this.paintCheckerReport(g, pntdoc);
        }
        RgMoleculeGraphIface rgmol = null;
        if (molg instanceof RgMoleculeGraphIface) {
            rgmol = (RgMoleculeGraphIface)((Object)molg);
        }
        boolean isReal3D = this.recalcScreenCoords(umol);
        if (this.normalFont == null) {
            this.initFonts(g);
        }
        boolean is3d = this.getDim(molg, dispopts) == 3;
        this.setZInterval();
        boolean bl = this.isFogApplicable = molg.getDim() == 3 && isReal3D || Math.abs(this.minScreenZ - this.maxScreenZ) > 3.0 && this.preTransform.is3d();
        if (is3d) {
            this.common.zsort(umol, this.screenCoords, nobjs, objs, this.transformMatrix);
        }
        boolean[][] showChiral = this.createShowChiral(rgmol);
        if (doc == null) {
            this.paintRgSgRxn(g, molg);
            this.paintBondLabels(g, molg);
        }
        this.paintObjects(g, lpainter, nobjs, objs, umol, molg, rgmol, showChiral, pntdoc, this.grPres);
        int n2 = sel != null ? sel.getObjectCount() : 0;
        Color c = colors.getSelectionColor();
        int flags = this.common.getDispQuality() > 0 ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            MObject o = sel.getObject(i);
            if (!o.isInternalSelectable() || o instanceof MChemicalStruct || o instanceof MMoleculeMovie) continue;
            flags &= 0xFFFFFFFD;
            if (doc.getFocus() == o) {
                flags |= 2;
            }
            GraphicsPainter gp = this.grPres.getGraphicsPainter(o.getClass());
            gp.paint(o, g, this.transformMatrix, flags, c, colors.getSelectionColor(), o instanceof MTextBox ? colors.getTextBoxColor() : colors.getAtomHighlightColor());
        }
        g.setFont(originalFont);
    }

    private void setZInterval() {
        this.minScreenZ = Double.MAX_VALUE;
        this.maxScreenZ = -1.7976931348623157E308;
        for (int i = 0; i < this.screenCoords.length; ++i) {
            if (this.screenCoords[i].z < this.minScreenZ) {
                this.minScreenZ = this.screenCoords[i].z;
            }
            if (!(this.screenCoords[i].z > this.maxScreenZ)) continue;
            this.maxScreenZ = this.screenCoords[i].z;
        }
    }

    private void paintAttachmentShadow(Graphics2D g, MoleculeGraph molecule, LinePainter lpainter, MDocument doc) {
        MolAtom[] atoms;
        for (MolAtom atom : atoms = molecule.getAtomArray()) {
            if (atom.getAtno() == 138 && atom.getRgroupAttachmentPointOrder() == -1) {
                this.paintAttachmentPointInHand(g, lpainter, atom);
                continue;
            }
            if (atom.getAtno() != 138 || atom.getRgroupAttachmentPointOrder() <= 0 || atom.getBondCount() <= 0) continue;
            this.paintAttachmentPointOnCanvas(g, lpainter, doc, atom);
        }
    }

    private void paintAttachmentPointOnCanvas(Graphics2D g, LinePainter lpainter, MDocument doc, MolAtom atom) {
        MolBond bond = atom.getBond(0);
        DPoint3 endPoint1 = atom.getLocation();
        DPoint3 endPoint2 = bond.getOtherAtom(atom).getLocation();
        double distance = endPoint2.distance(atom.getLocation());
        DPoint3 p1 = CleanUtil.calcDividingPoint(atom.getLocation(), endPoint2, 0.65 / distance);
        float[] coords1 = GroupUtil.getNextDirection(endPoint1, p1, 1, 1, 1.5707963267948966);
        float[] coords2 = GroupUtil.getNextDirection(endPoint1, p1, 1, -1, 1.5707963267948966);
        float[] coords3 = GroupUtil.getNextDirection(endPoint1, p1, 1, -1, 0.7479982508547126);
        Point e1 = this.calcGP(coords1[0], coords1[1], 0.0);
        Point e2 = this.calcGP(coords2[0], coords2[1], 0.0);
        g.setColor(this.getColor(atom, doc));
        if (atom.isSelected()) {
            g.setColor(Color.GREEN);
            int oldSickness = lpainter.getLineThicknessAsInt();
            lpainter.setLineThicknessAsInt(oldSickness * 2);
            lpainter.paintWavyLine(g, e1, e2);
            lpainter.setLineThicknessAsInt(oldSickness);
        } else {
            lpainter.paintWavyLine(g, e1, e2);
        }
        if (atom.getRgroupAttachmentPointOrder() > 1) {
            DPoint3 e3 = new DPoint3(coords3[0], coords3[1], 0.0);
            this.calcGP(e3);
            this.paintOrderSymbol(g, atom.getRgroupAttachmentPointOrder(), ColorCollection.DARK_SHADOW_BLUE, Color.LIGHT_GRAY, Color.BLACK, e3);
        }
    }

    private void paintAttachmentPointInHand(Graphics2D g, LinePainter lpainter, MolAtom atom) {
        DPoint3 location = atom.getLocation();
        double diff = 0.77 * Math.cos(0.7853981633974483);
        DPoint3 endPoint1 = new DPoint3(location.x + diff, location.y + diff, location.z);
        DPoint3 endPoint2 = new DPoint3(location.x - diff, location.y - diff, location.z);
        this.calcGP(endPoint1);
        this.calcGP(endPoint2);
        g.setColor(Color.BLACK);
        lpainter.paintWavyLine(g, new Point((int)endPoint1.x, (int)endPoint1.y), new Point((int)endPoint2.x, (int)endPoint2.y));
    }

    private static MoleculeGraph getMainMoleculeGraph(MDocument doc) {
        int n = doc.getObjectCount();
        MoleculeGraph main = null;
        for (int j = 0; j < n; ++j) {
            MoleculeGraph molg;
            MObject o = doc.getObject(j);
            if (o instanceof MChemicalStruct) {
                MChemicalStruct mcs = (MChemicalStruct)o;
                molg = mcs.getMoleculeGraph();
                if (main != null && molg.isEmpty()) continue;
                main = molg;
                continue;
            }
            if (!(o instanceof MMoleculeMovie)) continue;
            MMoleculeMovie mmm = (MMoleculeMovie)o;
            molg = mmm.getCurrentMolecule();
            if (main != null && molg.isEmpty()) continue;
            main = molg;
        }
        return main;
    }

    public static boolean isClippingSupported(Graphics2D g) {
        if (g instanceof OleGraphics2DIface) {
            return false;
        }
        String gname = g.getClass().getName();
        if (gname.equals("org.freehep.graphicsio.pdf.PDFGraphics2D")) {
            return false;
        }
        if (gname.equals("org.freehep.graphicsio.emf.EMFGraphics2D")) {
            return Environment.JAVA16_COMPATIBLE;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintRgSgRxn(Graphics2D g, MoleculeGraph molg) throws SecurityException {
        ColorCollection colors = this.getColors();
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            int j;
            int i;
            boolean showRgroups = this.common.isRgDefinitionVisible();
            RxnMolecule rxmol = null;
            RgMoleculeGraphIface rgmol = null;
            if (molg instanceof RxnMolecule) {
                rxmol = (RxnMolecule)molg;
            } else if (molg instanceof RgMoleculeGraphIface) {
                MoleculeGraph m;
                rgmol = (RgMoleculeGraphIface)((Object)molg);
                boolean[][] showChiral = this.createShowChiral(rgmol);
                if (this.boldFont != null) {
                    g.setFont(this.boldFont);
                    g.setColor(colors.getForeground());
                    FontMetrics fm = this.boldFontMetrics;
                    if (this.common.isAbsLabelVisible()) {
                        this.showAbsStereoLabel(g, rgmol.getRootG(), fm);
                        if (showRgroups) {
                            for (i = 0; i < rgmol.getRgroupCount(); ++i) {
                                for (j = 0; j < rgmol.getRgroupMemberCount(i); ++j) {
                                    MoleculeGraph m2 = rgmol.getRgroupMemberG(i, j);
                                    if (!m2.isAbsStereo() || !MolPainter.isChiral(m2)) continue;
                                    this.showAbsStereoLabel0(g, m2, fm);
                                }
                            }
                        }
                    }
                    if (showRgroups) {
                        this.showRgroupLabels(g, rgmol, showChiral, fm);
                    }
                }
                if ((m = rgmol.getRootG()) instanceof RxnMolecule) {
                    rxmol = (RxnMolecule)m;
                }
                if (this.common.isRLogicVisible() && this.normalFontMetrics != null) {
                    this.showRLogic(g, molg, this.normalFontMetrics);
                }
            }
            if (this.common.isAbsLabelVisible() && MolPainter.isChiral(molg) && this.boldFont != null) {
                g.setFont(this.boldFont);
                g.setColor(colors.getForeground());
                FontMetrics fm = this.boldFontMetrics;
                if (rxmol != null) {
                    this.showAbsStereoLabelForReaction(g, rxmol, fm);
                } else if (rgmol == null && molg.isAbsStereo()) {
                    this.showAbsStereoLabel0(g, molg, fm);
                }
            }
            if (rxmol != null) {
                this.paintReaction(g, rxmol);
            }
            if (molg instanceof Molecule) {
                Molecule mm = (Molecule)molg;
                if (mm instanceof RgMolecule) {
                    RgMolecule rmm = (RgMolecule)mm;
                    if (showRgroups) {
                        for (i = rmm.getRgroupCount() - 1; i >= 0; --i) {
                            for (j = rmm.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                                Molecule molecule;
                                MoleculeGraph mg = rmm.getRgroupMemberG(i, j);
                                if (!(mg instanceof Molecule) || (molecule = (Molecule)mg).getSgroupCount() < 0) continue;
                                this.paintSgroupBrackets(g, molecule);
                            }
                        }
                    }
                    if (rmm.getRoot().getSgroupCount() >= 0) {
                        this.paintSgroupBrackets(g, rmm.getRoot());
                    }
                } else if (mm.getSgroupCount() > 0) {
                    this.paintSgroupBrackets(g, mm);
                }
                String[] s = MolPainter.decodeRegno(mm);
                if (s != null && this.normalFontMetrics != null) {
                    int ascent = this.normalFontMetrics.getAscent();
                    int fh = this.normalFontMetrics.getHeight();
                    g.setColor(colors.getForeground());
                    g.setFont(this.normalFont);
                    for (int i2 = 0; i2 < s.length; ++i2) {
                        g.drawString(s[i2], 0, ascent + i2 * fh);
                    }
                }
            }
        }
    }

    private static boolean isChiral(MoleculeGraph mol) {
        int na = mol.getAtomCount();
        for (int j = 0; j < na; ++j) {
            int ch = mol.getChirality(j);
            if (ch == 0) continue;
            return true;
        }
        return false;
    }

    private void showAbsStereoLabel(Graphics2D g, MoleculeGraph mol, FontMetrics fm) {
        RxnMolecule rxmol = RxnMolecule.getReaction(mol);
        if (rxmol != null) {
            this.showAbsStereoLabelForReaction(g, rxmol, fm);
        } else if (!mol.isEmpty() && mol.isAbsStereo() && MolPainter.isChiral(mol)) {
            this.showAbsStereoLabel0(g, mol, fm);
        }
    }

    private void showAbsStereoLabelForReaction(Graphics2D g, RxnMolecule rxmol, FontMetrics fm) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < rxmol.getComponentCount(i); ++j) {
                Molecule m = rxmol.getComponent(i, j);
                if (m.isEmpty() || !m.isAbsStereo() || !MolPainter.isChiral(m)) continue;
                this.showAbsStereoLabel0(g, m, fm);
            }
        }
    }

    private void showAbsStereoLabel0(Graphics2D g, MoleculeGraph mol, FontMetrics fm) {
        MoleculeGraph[] molarr = new MoleculeGraph[]{mol};
        int w = fm.stringWidth(ABS_STEREO_LABEL);
        Rectangle r = this.getBoundsFor(molarr, this.imageSize.scale);
        g.drawString(ABS_STEREO_LABEL, r.x + r.width - w, r.y + fm.getHeight() / 2);
    }

    private void showRLogic(Graphics2D g, MoleculeGraph mol, FontMetrics fm) {
        MoleculeGraph[] molarr = new MoleculeGraph[]{mol};
        RgMoleculeGraphIface rgmol = null;
        if (!(mol instanceof RgMoleculeGraphIface)) {
            return;
        }
        rgmol = (RgMoleculeGraphIface)((Object)mol);
        int rgnum = rgmol.getRgroupCount();
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < rgnum; ++j) {
            int rj = rgmol.getRlogic(j);
            String rsj = rgmol.getRlogicRange(j);
            int RGnum = rj & Short.MAX_VALUE;
            if ((rj & 0x7FFF0000) != 0) {
                int otherRGnum = (rj & 0x7FFF0000) >> 16;
                String otherRGRange = rgmol.getRlogicRange(otherRGnum - 1);
                sb.append("if R" + RGnum + " " + rsj + " then R" + otherRGnum + " " + otherRGRange);
                if ((rj & Integer.MIN_VALUE) != 0) {
                    sb.append(", restH");
                }
                sb.append(":");
                continue;
            }
            if (rsj.equals(">0")) {
                if ((rj & Integer.MIN_VALUE) == 0) continue;
                sb.append("R" + RGnum + " " + rsj);
                sb.append(", restH");
                sb.append(":");
                continue;
            }
            sb.append("R" + RGnum + " " + rsj);
            if ((rj & Integer.MIN_VALUE) != 0) {
                sb.append(", restH");
            }
            sb.append(":");
        }
        Rectangle r = this.getBoundsFor(molarr, 1.0);
        String s = sb.toString();
        int j = 0;
        int maxW = 0;
        int i = s.indexOf(":", 0);
        while (i > 0) {
            int w = fm.stringWidth(s.substring(j, i));
            maxW = w > maxW ? w : maxW;
            j = i;
            i = s.indexOf(":", i + 1);
        }
        j = 0;
        int line = 0;
        int i2 = s.indexOf(":", 0);
        while (i2 > 0) {
            int h = fm.getHeight();
            g.drawString(s.substring(j == 0 ? j : j + 1, i2), r.x - maxW - 8, r.y + h * line + h);
            j = i2;
            ++line;
            i2 = s.indexOf(":", i2 + 1);
        }
    }

    private void showRgroupLabels(Graphics2D g, RgMoleculeGraphIface rgmol, boolean[][] showChiral, FontMetrics fm) {
        int ng = rgmol.getRgroupCount();
        MoleculeGraph[] molarr = new MoleculeGraph[1];
        for (int i = 0; i < ng; ++i) {
            int minx = Integer.MAX_VALUE;
            int miny = Integer.MAX_VALUE;
            int maxy = Integer.MIN_VALUE;
            int nmembers = rgmol.getRgroupMemberCount(i);
            for (int j = 0; j < nmembers; ++j) {
                MoleculeGraph rgroup;
                molarr[0] = rgroup = rgmol.getRgroupMemberG(i, j);
                Rectangle r = this.getBoundsFor(molarr, this.imageSize.scale);
                if (r.x < minx) {
                    minx = r.x;
                }
                if (r.y < miny) {
                    miny = r.y;
                }
                if (r.y + r.height <= maxy) continue;
                maxy = r.y + r.height;
            }
            if (minx == Integer.MAX_VALUE) continue;
            int rgid = rgmol.getRgroupId(i);
            String s = rgid != 0 ? "R" + rgid + " = " : "R = ";
            int w = fm.stringWidth(s);
            g.drawString(s, minx - w, (miny + maxy) / 2 + fm.getDescent());
        }
    }

    private boolean[][] createShowChiral(RgMoleculeGraphIface rgmol) {
        if (rgmol == null) {
            return null;
        }
        int dispopts = this.common.getDispopts();
        int enableRgroups = dispopts & 0x4000000;
        int k = enableRgroups == 0 ? 0 : rgmol.getRgroupCount();
        boolean[][] showChiral = new boolean[k][];
        for (int i = 0; i < k; ++i) {
            int nmembers = rgmol.getRgroupMemberCount(i);
            showChiral[i] = new boolean[nmembers];
            for (int j = 0; j < nmembers; ++j) {
                MoleculeGraph rgroup = rgmol.getRgroupMemberG(i, j);
                showChiral[i][j] = false;
                if (!rgroup.isAbsStereo()) continue;
                int atno = rgroup.getAtomCount();
                for (int m = 0; m < atno; ++m) {
                    int ch = rgroup.getChirality(m);
                    if (ch == 0) continue;
                    showChiral[i][j] = true;
                }
            }
        }
        return showChiral;
    }

    private int fillObjectArray(Object[] objs, MDocument doc, List<MolAtom[]> allIncipientBonds) {
        int j;
        int i = 0;
        List<MObject> list = doc.getAllObjects();
        int n = list.size();
        for (j = 0; j < n; ++j) {
            MoleculeGraph molg;
            MObject o = list.get(j);
            if (o instanceof MChemicalStruct) {
                MChemicalStruct mcs = (MChemicalStruct)o;
                molg = mcs.getMoleculeGraph();
                if (this.isTransparent()) {
                    objs[i++] = molg;
                    i = this.fillObjectArray(objs, molg, allIncipientBonds, i);
                    continue;
                }
                i = this.fillObjectArray(objs, molg, allIncipientBonds, i);
                objs[i++] = molg;
                continue;
            }
            if (o instanceof MMoleculeMovie) {
                MMoleculeMovie mmm = (MMoleculeMovie)o;
                molg = mmm.getCurrentMolecule();
                if (this.isTransparent()) {
                    objs[i++] = molg;
                    i = this.fillObjectArray(objs, molg, allIncipientBonds, i);
                    continue;
                }
                i = this.fillObjectArray(objs, molg, allIncipientBonds, i);
                objs[i++] = molg;
                continue;
            }
            if (!MolPainter.isVisibleObject(this.common, o, doc)) continue;
            objs[i++] = o;
        }
        if (allIncipientBonds != null) {
            for (j = 0; j < allIncipientBonds.size(); ++j) {
                objs[i++] = allIncipientBonds.get(j);
            }
        }
        return i;
    }

    private int fillAtoms(MoleculeGraph umol, Object[] objs, int nobjs) {
        int na = umol.getAtomCount();
        for (int i = 0; i < na; ++i) {
            MolAtom a = umol.getAtom(i);
            if (!this.common.isSetVisible(a.getSetSeq())) continue;
            objs[nobjs++] = a;
        }
        return nobjs;
    }

    private int fillObjectArray(Object[] objs, MoleculeGraph molg, List<MolAtom[]> allIncipientBonds, int nobjs) {
        int dispopts = this.common.getDispopts();
        int style = dispopts & 0xE0000;
        int enableRgroups = dispopts & 0x4000000;
        MoleculeGraph umol = molg instanceof RgMoleculeGraphIface && enableRgroups == 0 ? ((RgMoleculeGraphIface)((Object)molg)).getRootG() : molg.getGraphUnion();
        if (this.isTransparent()) {
            nobjs = this.fillAtoms(umol, objs, nobjs);
        }
        int nb = style == 524288 ? 0 : umol.getBondCount();
        for (int i = 0; i < nb; ++i) {
            MolBond b = umol.getBond(i);
            int g1 = b.getAtom1().getSetSeq();
            int g2 = b.getAtom2().getSetSeq();
            if (!this.common.isSetVisible(g1) || !this.common.isSetVisible(g2)) continue;
            objs[nobjs++] = umol.getBond(i);
        }
        List<MolAtom[]> incb = MolPainter.findIncipientBondsInMol(allIncipientBonds, molg);
        int nincb = incb != null ? incb.size() : 0;
        for (int i = nincb - 1; i >= 0; --i) {
            MolAtom[] atoms = incb.get(i);
            int g1 = atoms[0].getSetSeq();
            int g2 = atoms[1].getSetSeq();
            if (!this.common.isSetVisible(g1) || !this.common.isSetVisible(g2)) continue;
            objs[nobjs++] = atoms;
        }
        if (!this.isTransparent()) {
            nobjs = this.fillAtoms(umol, objs, nobjs);
        }
        return nobjs;
    }

    private int countObjects(MDocument doc, List<MolAtom[]> allIncipientBonds) {
        int nobjs = allIncipientBonds != null ? allIncipientBonds.size() : 0;
        List<MObject> list = doc.getAllObjects();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MObject o = list.get(i);
            if (o instanceof MChemicalStruct) {
                MChemicalStruct mcs = (MChemicalStruct)o;
                nobjs += this.countObjects(mcs.getMoleculeGraph()) + 1;
                continue;
            }
            if (o instanceof MMoleculeMovie) {
                MMoleculeMovie mm = (MMoleculeMovie)o;
                nobjs += this.countObjects(mm.getCurrentMolecule()) + 1;
                continue;
            }
            if (!MolPainter.isVisibleObject(this.common, o, doc)) continue;
            ++nobjs;
        }
        return nobjs;
    }

    private int countObjects(MoleculeGraph molg) {
        int dispopts = this.common.getDispopts();
        int style = dispopts & 0xE0000;
        int enableRgroups = dispopts & 0x4000000;
        MoleculeGraph umol = molg instanceof RgMoleculeGraphIface && enableRgroups == 0 ? ((RgMoleculeGraphIface)((Object)molg)).getRootG() : molg.getGraphUnion();
        int na = umol.getAtomCount();
        int nb = style == 524288 ? 0 : umol.getBondCount();
        return na + nb;
    }

    public void paintMultipage(Graphics2D g, MDocument doc) {
        int i;
        DPoint3 p1 = new DPoint3();
        DPoint3 p2 = new DPoint3();
        g.setColor(this.getMultipageColor());
        if (doc == null) {
            return;
        }
        PageSettings ps = doc.getPageSettings();
        if (!ps.isMultiPageEnabled()) {
            return;
        }
        for (i = 0; i < ps.getColumnCount() + 1; ++i) {
            p1.x = ps.getUpperLeftPoint().x + (double)i * ps.getWidth();
            p1.y = ps.getUpperLeftPoint().y;
            p1.z = ps.getUpperLeftPoint().z;
            p2.x = ps.getUpperLeftPoint().x + (double)i * ps.getWidth();
            p2.y = ps.getUpperLeftPoint().y + ps.getHeight() * (double)ps.getRowCount();
            p2.z = ps.getUpperLeftPoint().z;
            this.calcGP(p1);
            this.calcGP(p2);
            g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y), (int)Math.ceil(p2.x), (int)Math.ceil(p2.y));
        }
        for (i = 0; i < ps.getRowCount() + 1; ++i) {
            p1.x = ps.getUpperLeftPoint().x;
            p1.y = ps.getUpperLeftPoint().y + (double)i * ps.getHeight();
            p1.z = ps.getUpperLeftPoint().z;
            p2.x = ps.getUpperLeftPoint().x + ps.getWidth() * (double)ps.getColumnCount();
            p2.y = ps.getUpperLeftPoint().y + (double)i * ps.getHeight();
            p2.z = ps.getUpperLeftPoint().z;
            this.calcGP(p1);
            this.calcGP(p2);
            g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y), (int)Math.ceil(p2.x), (int)Math.ceil(p2.y));
        }
        this.paintMargin(g, ps);
        this.paintSelectedPage(g, doc);
    }

    private void paintMargin(Graphics2D g, PageSettings ps) {
        DPoint3 upperLeft = (DPoint3)ps.getUpperLeftPoint().clone();
        this.calcGP(upperLeft);
        DPoint3 p1 = (DPoint3)ps.getUpperLeftPoint().clone();
        DPoint3 p2 = (DPoint3)ps.getUpperLeftPoint().clone();
        DPoint3 p3 = (DPoint3)ps.getUpperLeftPoint().clone();
        DPoint3 p4 = (DPoint3)ps.getUpperLeftPoint().clone();
        for (int column = 0; column < ps.getColumnCount(); ++column) {
            for (int row = 0; row < ps.getRowCount(); ++row) {
                p1.x = ps.getUpperLeftPoint().x + (double)column * ps.getWidth() + ps.getLeftMargin();
                p1.y = ps.getUpperLeftPoint().y + (double)row * ps.getHeight() + ps.getTopMargin();
                p2.x = ps.getUpperLeftPoint().x + (double)(column + 1) * ps.getWidth() - ps.getRightMargin();
                p2.y = ps.getUpperLeftPoint().y + (double)row * ps.getHeight() + ps.getTopMargin();
                p3.x = ps.getUpperLeftPoint().x + (double)column * ps.getWidth() + ps.getLeftMargin();
                p3.y = ps.getUpperLeftPoint().y + (double)(row + 1) * ps.getHeight() - ps.getBottomMargin();
                p4.x = ps.getUpperLeftPoint().x + (double)(column + 1) * ps.getWidth() - ps.getRightMargin();
                p4.y = ps.getUpperLeftPoint().y + (double)(row + 1) * ps.getHeight() - ps.getBottomMargin();
                p3.z = p4.z = ps.getUpperLeftPoint().z;
                p2.z = p4.z;
                p1.z = p4.z;
                this.calcGP(p1);
                this.calcGP(p2);
                this.calcGP(p3);
                this.calcGP(p4);
                g.setColor(this.getCommon().getMultipageMarginColor());
                g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y), (int)Math.ceil(p2.x), (int)Math.ceil(p2.y));
                g.drawLine((int)Math.ceil(p2.x), (int)Math.ceil(p2.y), (int)Math.ceil(p4.x), (int)Math.ceil(p4.y));
                g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y), (int)Math.ceil(p3.x), (int)Math.ceil(p3.y));
                g.drawLine((int)Math.ceil(p3.x), (int)Math.ceil(p3.y), (int)Math.ceil(p4.x), (int)Math.ceil(p4.y));
            }
        }
    }

    private void paintSelectedPage(Graphics2D g, MDocument doc) {
        DPoint3 p1 = new DPoint3();
        DPoint3 p2 = new DPoint3();
        PageSettings ps = doc.getPageSettings();
        g.setColor(this.getMultipageSelectionColor());
        int column = ps.getSelectedPage() % ps.getColumnCount();
        int row = ps.getSelectedPage() / ps.getColumnCount();
        p1.x = ps.getUpperLeftPoint().x + (double)column * ps.getWidth();
        p1.y = ps.getUpperLeftPoint().y + (double)row * ps.getHeight();
        p2.x = ps.getUpperLeftPoint().x + (double)(column + 1) * ps.getWidth();
        p2.y = ps.getUpperLeftPoint().y + (double)row * ps.getHeight();
        p1.z = p2.z = ps.getUpperLeftPoint().z;
        this.calcGP(p1);
        this.calcGP(p2);
        g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y), (int)Math.ceil(p2.x), (int)Math.ceil(p2.y));
        g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y) + 1, (int)Math.ceil(p2.x), (int)Math.ceil(p2.y) + 1);
        p1.x = ps.getUpperLeftPoint().x + (double)(column + 1) * ps.getWidth();
        p1.y = ps.getUpperLeftPoint().y + (double)row * ps.getHeight();
        p2.x = ps.getUpperLeftPoint().x + (double)(column + 1) * ps.getWidth();
        p2.y = ps.getUpperLeftPoint().y + (double)(row + 1) * ps.getHeight();
        p1.z = p2.z = ps.getUpperLeftPoint().z;
        this.calcGP(p1);
        this.calcGP(p2);
        g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y), (int)Math.ceil(p2.x), (int)Math.ceil(p2.y));
        g.drawLine((int)Math.ceil(p1.x) - 1, (int)Math.ceil(p1.y), (int)Math.ceil(p2.x) - 1, (int)Math.ceil(p2.y));
        p1.x = ps.getUpperLeftPoint().x + (double)(column + 1) * ps.getWidth();
        p1.y = ps.getUpperLeftPoint().y + (double)(row + 1) * ps.getHeight();
        p2.x = ps.getUpperLeftPoint().x + (double)column * ps.getWidth();
        p2.y = ps.getUpperLeftPoint().y + (double)(row + 1) * ps.getHeight();
        p1.z = p2.z = ps.getUpperLeftPoint().z;
        this.calcGP(p1);
        this.calcGP(p2);
        g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y), (int)Math.ceil(p2.x), (int)Math.ceil(p2.y));
        g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y) - 1, (int)Math.ceil(p2.x), (int)Math.ceil(p2.y) - 1);
        p1.x = ps.getUpperLeftPoint().x + (double)column * ps.getWidth();
        p1.y = ps.getUpperLeftPoint().y + (double)(row + 1) * ps.getHeight();
        p2.x = ps.getUpperLeftPoint().x + (double)column * ps.getWidth();
        p2.y = ps.getUpperLeftPoint().y + (double)row * ps.getHeight();
        p1.z = p2.z = ps.getUpperLeftPoint().z;
        this.calcGP(p1);
        this.calcGP(p2);
        g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y), (int)Math.ceil(p2.x), (int)Math.ceil(p2.y));
        g.drawLine((int)Math.ceil(p1.x) + 1, (int)Math.ceil(p1.y), (int)Math.ceil(p2.x) + 1, (int)Math.ceil(p2.y));
    }

    public void paintMultipageHeader(Graphics2D g, MDocument doc) {
        DPoint3 p1 = new DPoint3();
        DPoint3 p2 = new DPoint3();
        g.setColor(this.getMultipageColor());
        if (doc == null) {
            return;
        }
        PageSettings ps = doc.getPageSettings();
        if (!ps.isMultiPageEnabled()) {
            return;
        }
        Font originalFont = g.getFont();
        if (this.normalFont == null) {
            this.initFonts(g);
            if (this.normalFont == null) {
                return;
            }
        }
        g.setFont(this.normalFont);
        int allPages = ps.getRowCount() * ps.getColumnCount();
        for (int j = 0; j < ps.getColumnCount(); ++j) {
            for (int i = 0; i < ps.getRowCount(); ++i) {
                p1.x = ps.getUpperLeftPoint().x + (double)j * ps.getWidth();
                p1.y = ps.getUpperLeftPoint().y + (double)i * ps.getHeight();
                p1.z = ps.getUpperLeftPoint().z;
                p2.x = ps.getUpperLeftPoint().x + (double)(j + 1) * ps.getWidth();
                p2.y = ps.getUpperLeftPoint().y + (double)i * ps.getHeight();
                p2.z = ps.getUpperLeftPoint().z;
                this.calcGP(p1);
                this.calcGP(p2);
                String title = "";
                MoleculeGraph m = doc.getMainMoleculeGraph();
                if (m instanceof Molecule) {
                    title = "        " + ((Molecule)m).getName();
                }
                g.drawString(title, (int)Math.ceil(p1.x), (int)Math.ceil(p1.y + (double)(2 * this.normalFontMetrics.getHeight())));
                String pageNumbering = "Page " + Integer.toString(i * ps.getColumnCount() + j + 1) + " of " + Integer.toString(allPages) + "        ";
                g.drawString(pageNumbering, (int)Math.ceil(p2.x - (double)this.normalFontMetrics.stringWidth(pageNumbering)), (int)Math.ceil(p2.y + (double)(2 * this.normalFontMetrics.getHeight())));
            }
        }
        g.setFont(originalFont);
    }

    private static List<MolAtom[]> findIncipientBonds(MDocument doc) {
        ArrayList<MolAtom[]> v = null;
        for (int i = 0; i < doc.getObjectCount(); ++i) {
            Object sink;
            MObject o = doc.getObject(i);
            if (!(o instanceof MEFlow) || (sink = ((MEFlow)o).getMolObject(1)) == null || !(sink instanceof MolAtom[])) continue;
            MolAtom[] atoms = (MolAtom[])sink;
            if (v == null) {
                v = new ArrayList<MolAtom[]>();
            }
            v.add(atoms);
        }
        return v;
    }

    private static List<MolAtom[]> findIncipientBondsInMol(List<MolAtom[]> u, MoleculeGraph m) {
        ArrayList<MolAtom[]> v = null;
        if (u != null) {
            for (int i = 0; i < u.size(); ++i) {
                MolAtom[] atoms = u.get(i);
                if (!m.contains(atoms[0])) continue;
                if (v == null) {
                    v = new ArrayList<MolAtom[]>();
                }
                v.add(atoms);
                u.remove(i);
                --i;
            }
        }
        return v;
    }

    private static String[] decodeRegno(MoleculeGraph mg) {
        Molecule m = mg instanceof Molecule ? (Molecule)mg : null;
        String s = m != null ? m.getProperty("$REGNO") : null;
        boolean reac = false;
        if (s != null && s.length() > 2) {
            char a = s.charAt(0);
            char b = s.charAt(1);
            if (!(a != 'M' && a != 'R' || b != 'I' && b != 'E')) {
                boolean bl = reac = a == 'R';
                if (m.isEmpty() || m.isReaction() != reac) {
                    String[] r = new String[2];
                    r[0] = b == 'I' ? "Internal" : "External";
                    r[0] = r[0] + (reac ? " reaction" : " molecule");
                    r[1] = "regno = " + s.substring(2);
                    return r;
                }
                return null;
            }
            String[] r = new String[]{"Invalid regno:", s};
            return r;
        }
        return null;
    }

    public boolean recalcScreenCoords(MoleculeGraph mol) {
        mol = mol.getGraphUnion();
        int na = mol.getAtomCount();
        if (this.screenCoords == null || this.screenCoords.length != na) {
            this.screenCoords = new DPoint3[na];
            this.coveringLabels.clear();
            for (int i = 0; i < na; ++i) {
                this.screenCoords[i] = new DPoint3();
                this.calcGP(this.screenCoords[i]);
            }
        }
        double maxz = -1.7976931348623157E308;
        double minz = Double.MAX_VALUE;
        for (int i = 0; i < na; ++i) {
            DPoint3 p = this.screenCoords[i];
            mol.getAtom(i).getLocation(p);
            if (maxz < p.z) {
                maxz = p.z;
            }
            if (minz > p.z) {
                minz = p.z;
            }
            this.calcGP(p);
        }
        return maxz - minz > 0.1;
    }

    public void ringAround(DPoint3 p1, DPoint3 p2, double r, Graphics2D g) {
        this.common.setAntialiasing(g, true);
        DPoint3 q1 = (DPoint3)p1.clone();
        DPoint3 q2 = (DPoint3)p2.clone();
        this.calcGP(q1);
        this.calcGP(q2);
        int w = (int)(2.0 * (r *= this.imageSize.scale / 1.54) + 0.5);
        double dx = q2.x - q1.x;
        double dy = q2.y - q1.y;
        double epsilon = 1.5400000000000001E-12;
        int f = 0;
        if (dx * dx + dy * dy > epsilon * epsilon) {
            f = (int)(180.5 + Math.atan2(-dy, dx) * 180.0 / Math.PI) % 360;
        }
        g.drawArc((int)(q1.x - r), (int)(q1.y - r), w, w, f - 90, 180);
        g.drawArc((int)(q2.x - r), (int)(q2.y - r), w, w, f + 90, 180);
        this.common.setAntialiasing(g, false);
    }

    public void hilitAtom(Molecule mol, MolAtom a, double r, Graphics2D g) {
        String chargeString = null;
        if (!LonePairPainter.isChargeVisible(a) && a.getCharge() != 0) {
            chargeString = LonePairPainter.getChargeString(a.getCharge());
        }
        int atom_index = mol.indexOf(a);
        if (this.atomCoordsOffVect != null && atom_index > -1 && this.atomCoordsOffVect.length > atom_index) {
            this.hilitPoint(a.getLocation(), this.atomCoordsOffVect[atom_index], r, g, chargeString);
        } else {
            this.hilitPoint(a.getLocation(), new double[2], r, g, chargeString);
        }
    }

    private void hilitPoint(DPoint3 p, double[] offsetVect, double r, Graphics2D g, String chargeString) {
        this.common.setAntialiasing(g, true);
        this.hilitPoint0(new DPoint3(p), offsetVect, r, g, chargeString);
        this.common.setAntialiasing(g, false);
    }

    public void hilitPoint(DPoint3 p, double r, Graphics2D g, String chargeString) {
        this.common.setAntialiasing(g, true);
        this.hilitPoint0(new DPoint3(p), new double[2], r, g, chargeString);
        this.common.setAntialiasing(g, false);
    }

    private void hilitPoint0(DPoint3 p, double[] offsetVect, double r, Graphics2D g, String chargeString) {
        g.setColor(this.getColors().getAtomHighlightColor());
        this.calcGP(p);
        p.x += offsetVect[0];
        p.y += offsetVect[1];
        int w = (int)(2.0 * (r *= this.imageSize.scale / 1.54) + 0.5);
        g.drawOval((int)(p.x - r), (int)(p.y - r), w, w);
        if (chargeString != null) {
            int x = (int)(p.x + r + 0.5);
            int y = (int)(p.y - r - 0.5);
            this.drawText(g, this.normalFont, this.normalFontMetrics, this.italicFont, this.italicFontMetrics, this.smallFont, this.smallFontMetrics, x, y - this.normalFontMetrics.getAscent(), 0, null, chargeString, true);
        }
    }

    private void hilitMulticenter(MolAtom a, MoleculeGraph molg, Graphics2D g) {
        Molecule molecule;
        MulticenterSgroup sg;
        if (a.getAtno() == 137 && molg instanceof Molecule && (sg = (molecule = (Molecule)molg).findContainingMulticenterSgroup(a)) != null) {
            this.hilitSgroup(molecule, sg, g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hilitBond(MoleculeGraph mol, MolBond b, double r, Graphics2D g) {
        if (b.getAtom1().getAtno() == 137) {
            this.hilitMulticenter(b.getAtom1(), mol, g);
        }
        if (b.getAtom2().getAtno() == 137) {
            this.hilitMulticenter(b.getAtom2(), mol, g);
        }
        this.hilitAtomPair(b.getAtom1(), b.getAtom2(), r, g);
        this.common.setAntialiasing(g, true);
        Object[] objs = new Object[]{b};
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            if (this.normalFont == null) {
                this.initFonts(g);
            }
            this.setBondOptions(mol);
            AtomLabeller alabeller = new AtomLabeller(this.common);
            alabeller.setMol(mol);
            LinePainter lpainter = new LinePainter(this.common, this.getColors(), this.getLineThickness(), this.getLineThicknessAsInt());
            this.paintBond(g, lpainter, objs, 0, mol.getGraphUnion(), alabeller, mol.getDocument());
        }
        this.common.setAntialiasing(g, false);
    }

    public void hilitAtomPair(MolAtom a1, MolAtom a2, double r, Graphics2D g) {
        this.common.setAntialiasing(g, true);
        g.setColor(this.getColors().getAtomHighlightColor());
        DPoint3 p1 = a1.getLocation();
        DPoint3 p2 = a2.getLocation();
        this.ringAround(p1, p2, r, g);
        this.common.setAntialiasing(g, false);
    }

    public void hilitObject(MDocument doc, MObject o, Graphics2D g) {
        MoleculeGraph molg;
        int flags;
        ColorCollection colors = this.getColors();
        this.common.setAntialiasing(g, true);
        Color c = o.getColor();
        if (c == null) {
            c = colors.getForeground();
        }
        int n = flags = this.common.getDispQuality() > 0 ? 1 : 0;
        if (doc.getFocus() == o) {
            flags |= 2;
        }
        if ((molg = doc.getMainMoleculeGraph()) instanceof RgMolecule) {
            molg = ((RgMolecule)molg).getRoot();
        }
        GraphicsPainter gp = this.grPres.getGraphicsPainter(o.getClass());
        if (MolPainter.isReactionArrowPoint(molg, o)) {
            if (!(o instanceof MMidPoint)) {
                gp.paint(o, g, this.transformMatrix, flags, c, colors.getSelectionColor(), colors.getAtomHighlightColor());
            }
        } else {
            gp.paint(o, g, this.transformMatrix, flags, c, colors.getSelectionColor(), o instanceof MTextBox ? colors.getTextBoxColor() : colors.getAtomHighlightColor());
        }
        this.common.setAntialiasing(g, false);
    }

    private static boolean isReactionArrowPoint(MoleculeGraph molg, MObject o) {
        boolean isEndPoint = false;
        if (o instanceof MPoint && molg instanceof RxnMolecule) {
            MRArrow arrow = ((RxnMolecule)molg).getItsArrow();
            isEndPoint = arrow != null && o.isChildOf(arrow);
        }
        return isEndPoint;
    }

    private void highlightRelatedObject(Sgroup sg, Graphics2D g, MoleculeGraph mol, MoleculeGraph m) {
        this.paintSgroupBrackets(g, sg, m, false);
        if (sg.getBracketCount() == 0 || sg.getType() == 1 && sg.getXState() == 1) {
            return;
        }
        ArrayList<MBracket> objects = sg.getBrackets();
        Color c = null;
        for (int i = 0; i < objects.size(); ++i) {
            MObject object = objects.get(i);
            c = object.getColor();
            object.setColor(this.getColors().getAtomHighlightColor());
            this.hilitObject(mol.getDocument(), object, g);
            object.setColor(c);
        }
    }

    public void hilitSgroup(MoleculeGraph mol, Sgroup sg, Graphics2D g) {
        MulticenterSgroup msg;
        this.common.setAntialiasing(g, true);
        SelectionMolecule m = new SelectionMolecule();
        g.setColor(this.getColors().getAtomHighlightColor());
        this.highlightRelatedObject(sg, g, mol, m);
        double sr = this.getAtomSize() * 0.5;
        for (int i = 0; i < sg.getAtomCount(); ++i) {
            this.hilitPoint(sg.getAtom(i).getLocation(), sr, g, null);
        }
        if (sg instanceof MulticenterSgroup && (msg = (MulticenterSgroup)sg).getCentralAtom() != null) {
            this.hilitPoint(msg.getCentralAtom().getLocation(), sr, g, null);
        }
        if (sg instanceof DataSgroup) {
            if (sg.getAtomCount() == 0 && sg.getParentSgroup() != null) {
                this.highlightRelatedObject(sg.getParentSgroup(), g, mol, m);
            }
            this.hilitDataSgroup((DataSgroup)sg, g);
        }
        this.common.setAntialiasing(g, false);
    }

    private void hilitDataSgroup(DataSgroup dsg, Graphics2D g) {
        Rectangle r = MolPainter.getDataLabelBounds(dsg, this.normalFontMetrics);
        if (dsg.getFieldType() == 4) {
            Color originalColor = g.getColor();
            g.setColor(Color.BLUE);
            this.paintDataSgroup(g, dsg);
            g.setColor(originalColor);
        }
        if (dsg.isDataDetached()) {
            DPoint3 p1 = dsg.getAbsoluteXY();
            this.calcGP(p1);
            g.drawRect((int)p1.x + r.x, (int)p1.y + r.y, r.width, r.height);
        } else {
            DPoint3 p1 = new DPoint3();
            p1.z = 0.0;
            for (int i = 0; i < dsg.getAtomCount(); ++i) {
                MolAtom atom = dsg.getAtom(i);
                p1.x = atom.getX();
                p1.y = atom.getY();
                this.calcGP(p1);
                g.drawRect((int)p1.x + r.x, (int)p1.y + r.y, r.width, r.height);
            }
        }
    }

    public void movPic(DPoint3 p0, double r, Graphics2D g) {
        this.common.setAntialiasing(g, true);
        DPoint3 p = (DPoint3)p0.clone();
        this.calcGP(p);
        int w = (int)(2.0 * (r *= this.imageSize.scale / 1.54) + 0.5);
        g.setColor(this.getColors().getAtomHighlightColor());
        g.drawRect((int)(p.x - r), (int)(p.y - r), w, w);
        this.common.setAntialiasing(g, false);
    }

    public void rot2dPic(DPoint3 p, double r, double phi, Graphics2D g, boolean dragged) {
        DPoint3 q = (DPoint3)p.clone();
        this.calcGP(q);
        if (!dragged) {
            this.wasDragged = false;
            this.zPhi = 0.0;
        }
        if (!this.wasDragged && dragged) {
            this.wasDragged = true;
            this.zPhi = phi;
        }
        if (dragged) {
            this.rotStr(phi, g);
        }
        this.rotPic(q, r, phi, null, 6, true, g);
    }

    public void rot3dPic(DPoint3 p, double r, double xphi, double yphi, double phi, Graphics2D g, boolean dragged, int rotateDirection) {
        boolean paintString;
        DPoint3 q = (DPoint3)p.clone();
        this.calcGP(q);
        CTransform3D t = new CTransform3D();
        if (xphi == 0.0 && yphi == 0.0) {
            xphi = 1.0;
        }
        t.setRotation(-yphi, xphi, 0.0, 1.5707963267948966);
        t.setRotationCenter(q);
        boolean bl = paintString = dragged && rotateDirection != 0;
        if (rotateDirection != this.prevAxis) {
            this.zPhi = phi;
            this.prevAxis = rotateDirection;
        }
        if (!dragged) {
            this.prevAxis = 0;
            this.wasDragged = false;
            this.zPhi = 0.0;
        }
        if (!this.wasDragged && dragged) {
            this.wasDragged = true;
            this.zPhi = phi;
        }
        if (paintString) {
            this.rotStr(phi, g);
        }
        this.rotPic(q, r, phi, t, 9, false, g);
    }

    private void rotStr(double phi, Graphics2D g) {
        double phiC;
        g.setColor(this.getColors().getForeground());
        FontMetrics fm = g.getFontMetrics();
        for (phiC = Math.toDegrees(phi - this.zPhi); phiC > 360.0; phiC -= 360.0) {
        }
        while (phiC < -360.0) {
            phiC += 360.0;
        }
        if (phiC < -180.0) {
            phiC += 360.0;
        }
        if (phiC > 180.0) {
            phiC -= 360.0;
        }
        String phiS = String.format("%2.2f\u00b0", phiC);
        int phiW = fm.stringWidth(phiS) + 1;
        this.drawStringToCanvas(phiS, g, g.getClipBounds().x + g.getClipBounds().width - phiW, g.getClipBounds().y + fm.getHeight());
    }

    private void rotPic(DPoint3 q, double r, double phi, CTransform3D t, int n, boolean saw, Graphics2D g) {
        int i;
        this.common.setAntialiasing(g, true);
        double d = (r *= this.imageSize.scale / 1.54) / 3.0;
        g.setColor(this.getColors().getAtomHighlightColor());
        LinePainter lpainter = new LinePainter(this.common, this.getColors(), this.getLineThickness(), this.getLineThicknessAsInt());
        DPoint3[] pts1 = new DPoint3[saw ? 2 * n : n];
        DPoint3[] pts2 = new DPoint3[saw ? 2 * n : n];
        double dz = r / 3.0;
        for (i = 0; i < n; ++i) {
            double f = phi + Math.PI * 2 * (double)i / (double)n;
            double c = Math.cos(f);
            double s = Math.sin(f);
            int k = saw ? 2 * i : i;
            pts1[k] = new DPoint3(q.x + r * c, q.y - r * s, q.z + dz);
            pts2[k] = new DPoint3(pts1[k].x, pts1[k].y, q.z - dz);
            if (!saw) continue;
            pts1[k + 1] = new DPoint3(q.x + (r + d) * c, q.y - (r + d) * s, q.z + dz);
            pts2[k + 1] = new DPoint3(pts1[k + 1].x, pts1[k + 1].y, q.z - dz);
        }
        if (t != null) {
            for (i = 0; i < pts1.length; ++i) {
                t.transform(pts1[i]);
                t.transform(pts2[i]);
            }
        }
        for (i = 0; i < pts1.length; ++i) {
            int k = (i + 1) % pts1.length;
            if (pts1[i].z < q.z && pts1[k].z < q.z) {
                lpainter.drawLine(g, pts1[i].x, pts1[i].y, 0.0, pts1[k].x, pts1[k].y, 0.0, null, false);
            }
            if (pts2[i].z < q.z && pts2[k].z < q.z) {
                lpainter.drawLine(g, pts2[i].x, pts2[i].y, 0.0, pts2[k].x, pts2[k].y, 0.0, null, false);
            }
            if (!(pts1[i].z < q.z) && !(pts2[k].z < q.z)) continue;
            lpainter.drawLine(g, pts1[i].x, pts1[i].y, 0.0, pts2[i].x, pts2[i].y, 0.0, null, false);
        }
        this.common.setAntialiasing(g, false);
    }

    private void drawStringToCanvas(String str, Graphics2D g, int x, int y) {
        int w = g.getFontMetrics().stringWidth(str);
        int h = g.getFontMetrics().getHeight();
        if (x > g.getClipBounds().x + g.getClipBounds().width - w - 1) {
            x = g.getClipBounds().width - w - 1;
        } else if (x < g.getClipBounds().x + 1) {
            x = g.getClipBounds().x + 1;
        }
        if (y < g.getClipBounds().y + h) {
            y = g.getClipBounds().y + h;
        } else if (y > g.getClipBounds().y + g.getClipBounds().height) {
            y = g.getClipBounds().y + g.getClipBounds().height;
        }
        g.drawString(str, x, y);
    }

    public void setScreen(Dimension d) {
        if (this.imageSize.width != d.width || this.imageSize.height != d.height) {
            this.imageSize.width = d.width;
            this.imageSize.height = d.height;
            this.setCentralized(this.centralized);
        }
    }

    public MolImageSize getImageSize() {
        return (MolImageSize)this.imageSize.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areBoundsSet() {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            return this.boundsXYRR != null && this.boundsXYRR[2] != 0.0 && this.boundsXYRR[3] != 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double maxScale(Dimension d) {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            double m1 = (double)d.width / (2.0 * this.boundsXYRR[2]);
            double m2 = (double)d.height / (2.0 * this.boundsXYRR[3]);
            double m = m1 > m2 ? m2 : m1;
            return m * 1.54;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCentralized(boolean v) {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            this.centralized = v;
            if (v) {
                this.trax = (double)this.imageSize.width / (2.0 * this.mag0) - this.boundsXYRR[2];
                this.tray = (double)this.imageSize.height / (2.0 * this.mag0) - this.boundsXYRR[3];
            }
            this.updateTransform();
        }
    }

    public double[] preCalcBounds(MoleculeGraph m) {
        return this.preCalcBounds(m, false, false);
    }

    private double[] preCalcBounds(MoleculeGraph m, boolean templ, boolean issg) {
        double[] bnds = new double[6];
        MoleculeGraph[] mols = new MoleculeGraph[]{m};
        MolPainter.calcBounds(this.common, mols, this.atomSize, this.common.getBondSpacing(), templ, !issg, bnds, this.preTransform, 1.0 / Math.abs(this.preTransform.getScale()), this.imageSize);
        this.transformBounds(bnds);
        return bnds;
    }

    private void transformBounds(double[] bnds) {
        DPoint3 p1 = new DPoint3(bnds[0] - bnds[2], bnds[1] + bnds[3], 0.0);
        DPoint3 p2 = new DPoint3(bnds[0] + bnds[2], bnds[1] - bnds[3], 0.0);
        this.invPreTransform.transform(p1);
        bnds[0] = p1.x;
        bnds[1] = p1.y;
        bnds[2] = p1.z;
        this.invPreTransform.transform(p2);
        bnds[3] = p2.x;
        bnds[4] = p2.y;
        bnds[5] = p2.z;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            Point p = this.calcGP(this.boundsXYRR[0] - this.boundsXYRR[2], this.boundsXYRR[1] + this.boundsXYRR[3], 0.0);
            return new Rectangle(p.x, p.y, (int)(2.0 * this.boundsXYRR[2] * this.mag0 + 0.5), (int)(2.0 * this.boundsXYRR[3] * this.mag0 + 0.5));
        }
    }

    public Rectangle getBoundsFor(MoleculeGraph[] mols, double mag) {
        double[] xyrr = new double[4];
        MolImageSize imSize = new MolImageSize(this.imageSize);
        imSize.scale = mag;
        MolPainter.calcBounds(this.common, mols, this.atomSize * Math.abs(this.transformMatrix.getScale()), this.common.getBondSpacing(), false, false, xyrr, this.transformMatrix, 1.0, imSize);
        return new Rectangle((int)Math.round(xyrr[0] - xyrr[2] - 1.0), (int)Math.round(xyrr[1] - xyrr[3] - 1.0), (int)(2.0 * xyrr[2] + 0.5) + 1, (int)(2.0 * xyrr[3] + 0.5) + 1);
    }

    public Rectangle getBoundsFor(MDocument doc, double mag) {
        MoleculeGraph[] mols = doc.getAllMolecules();
        return this.getBoundsFor(mols, mag);
    }

    public FontMetrics getNormalFontMetrics() {
        return this.normalFontMetrics;
    }

    public static Rectangle getDataLabelBounds(DataSgroup dsg, FontMetrics fm) {
        int height = 16;
        int asc = 12;
        int desc = 3;
        if (fm != null) {
            height = fm.getHeight();
            asc = fm.getAscent();
            desc = fm.getDescent();
        }
        int lineCount = dsg.getDataLineCount();
        int displayedLines = dsg.getDisplayedLines();
        double minx = 0.0;
        double miny = 0 - asc;
        double maxx = minx;
        double maxy = miny;
        if (displayedLines != 0 && lineCount > displayedLines) {
            lineCount = displayedLines;
        }
        for (int i = 0; i < lineCount; ++i) {
            String line = dsg.getLineOnScreen(i);
            maxy += (double)height;
            int lineWidth = fm != null ? fm.stringWidth(line) : height * line.length() / 3;
            if (!(minx + (double)lineWidth > maxx)) continue;
            maxx = minx + (double)lineWidth;
        }
        return new Rectangle((int)(minx -= (double)desc), (int)(miny -= (double)desc), (int)((maxx += (double)desc) - minx), (int)((maxy += (double)desc) - miny));
    }

    public void setBoundsFor(Molecule m, boolean istmpl, boolean calcHighlight) {
        this.setBoundsFor(m, istmpl, false, calcHighlight);
    }

    public void setBoundsFor(Molecule m, boolean istmpl, boolean inToolbar, boolean calcHightlight) {
        if (!this.fixbounds && m != null) {
            MoleculeGraph[] mols = new Molecule[]{m};
            MolPainter.calcBounds(this.common, mols, this.atomSize, this.common.getBondSpacing(), istmpl, inToolbar, true, this.boundsXYRR, this.preTransform, 1.0 / Math.abs(this.preTransform.getScale()), this.imageSize, true, calcHightlight);
            this.setCentralized(this.centralized);
        }
    }

    public void setBoundsFor(Molecule[] mols) {
        if (!this.fixbounds && mols != null && mols.length > 0) {
            MolPainter.calcBounds(this.common, mols, this.atomSize, this.common.getBondSpacing(), false, true, this.boundsXYRR, this.preTransform, 1.0 / Math.abs(this.preTransform.getScale()), this.imageSize);
            this.setCentralized(this.centralized);
        }
    }

    public void setBoundsFor(MoleculeGraph[] moleculeGraph) {
        if (moleculeGraph != null) {
            MolPainter.calcBounds(this.common, moleculeGraph, this.atomSize, this.common.getBondSpacing(), false, true, this.boundsXYRR, this.preTransform, 1.0 / Math.abs(this.preTransform.getScale()), this.imageSize);
            this.setCentralized(this.centralized);
        }
    }

    public void setBoundsFor(MDocument doc) {
        if (doc != null) {
            Molecule[] mols = doc.getAllMolecules();
            this.setBoundsFor(mols);
        }
    }

    public void setBoundsXYRR(double x, double y, double rx, double ry) {
        this.boundsXYRR[0] = x;
        this.boundsXYRR[1] = y;
        this.boundsXYRR[2] = rx;
        this.boundsXYRR[3] = ry;
    }

    public MolPainterCommon getCommon() {
        return this.common;
    }

    public ColorCollection getColors() {
        return this.theColors;
    }

    private void setBondOptions(MoleculeGraph m) {
        int f = this.common.getDispopts() & 0x600000;
        if (f == 0) {
            this.anyBondIsSolidLine = false;
            for (MoleculeGraph p = m; p != null && p instanceof Molecule; p = p.getParent()) {
                String s = ((Molecule)p).getProperty("anyBondsFromCoords");
                if (s == null) continue;
                this.anyBondIsSolidLine = s.equals("true");
                break;
            }
        } else {
            this.anyBondIsSolidLine = f == 0x400000;
        }
    }

    private void paintReaction(Graphics2D g, RxnMolecule rxmol) {
        Map<MRArrow, RxnMolecule> msLogic = rxmol.getMSLogic();
        if (msLogic != null) {
            ArrayList<RxnMolecule> steps = rxmol.getReactionSteps();
            Iterator<RxnMolecule> iter = steps.iterator();
            while (iter.hasNext()) {
                this.paintReactionPlusSign(g, iter.next());
            }
        } else {
            this.paintReactionPlusSign(g, rxmol);
        }
        this.common.setAntialiasing(g, true);
    }

    private void paintReactionPlusSign(Graphics2D g, RxnMolecule rxmol) {
        int i;
        Color oldColor = g.getColor();
        g.setColor(this.getColors().getForeground());
        this.common.setAntialiasing(g, true);
        DPoint3[][] centers = new DPoint3[2][];
        CTransform3D trf = this.transformMatrix;
        for (i = 0; i < centers.length; ++i) {
            int n = rxmol.getComponentCount(i);
            centers[i] = new DPoint3[n];
            for (int j = 0; j < n; ++j) {
                DPoint3 p = rxmol.getCenter(i, j);
                trf.transform(p);
                centers[i][j] = p;
            }
        }
        for (i = 0; i < centers.length; ++i) {
            for (int j = 0; j < centers[i].length; ++j) {
                DPoint3 oj = centers[i][j];
                int kmin = -1;
                double rmin = 0.0;
                for (int k = 0; k < centers[i].length; ++k) {
                    if (j == k) continue;
                    DPoint3 ok = centers[i][k];
                    double dx = ok.x - oj.x;
                    double dy = ok.y - oj.y;
                    double dz = ok.z - oj.z;
                    if (!(dx <= 0.0)) continue;
                    double r = dx * dx + dy * dy + dz * dz;
                    if (kmin >= 0 && !(r < rmin)) continue;
                    kmin = k;
                    rmin = r;
                }
                if (kmin < 0 || this.bigBoldFont == null) continue;
                Molecule mj = rxmol.getComponent(i, j);
                Molecule mk = rxmol.getComponent(i, kmin);
                DPoint3 ok = centers[i][kmin];
                double uj = this.calcUMaxOrMin(oj, ok, mj, 0);
                double uk = this.calcUMaxOrMin(oj, ok, mk, 1);
                double u = (uj + uk) / 2.0;
                double x = oj.x + u * (ok.x - oj.x);
                double y = oj.y + u * (ok.y - oj.y);
                int w = this.bigBoldFontMetrics.stringWidth("+");
                int h = this.bigBoldFontMetrics.getHeight();
                g.setFont(this.bigBoldFont);
                g.drawString("+", (float)(x - (double)(w / 2)), (float)(y + (double)(7 * h / 24)));
            }
        }
        g.setColor(oldColor);
        this.common.setAntialiasing(g, false);
    }

    private double calcUMaxOrMin(DPoint3 o1, DPoint3 o2, Molecule m, int type) {
        double dx = o2.x - o1.x;
        double dy = o2.y - o1.y;
        double dz = o2.z - o1.z;
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (d == 0.0) {
            return 0.0;
        }
        double fx = dx / d / d;
        double fy = dy / d / d;
        double fz = dz / d / d;
        double umax = 0.0;
        double sign = 1 - 2 * type;
        int n = 0;
        CTransform3D trf = this.transformMatrix;
        for (int k = m.getAtomCount() - 1; k >= 0; --k) {
            DPoint3 p = m.getAtom(k).getLocation();
            trf.transform(p);
            double u = sign * (fx * (p.x - o1.x) + fy * (p.y - o1.y) + fz * (p.z - o1.z));
            if (n == 0 || u > umax) {
                umax = u;
            }
            ++n;
        }
        return umax *= sign;
    }

    private void paintCheckerReport(Graphics2D g, MDocument doc) {
        MDocument.CheckerMark[] marks = doc.getCheckerMarks();
        if (marks != null) {
            for (int i = 0; i < marks.length; ++i) {
                MolBond[] bonds;
                MolAtom[] atoms = marks[i].getAtoms();
                if (atoms != null) {
                    for (MolAtom atom : atoms) {
                        if (atom == null) continue;
                        this.paintAtomShadow(g, atom, marks[i].getColor());
                    }
                }
                if ((bonds = marks[i].getBonds()) == null) continue;
                for (MolBond bond : bonds) {
                    this.paintBondShadow(g, bond, marks[i].getColor());
                }
            }
        }
    }

    private double getRadius(double scale) {
        double sr = this.getAtomSize();
        sr *= this.imageSize.scale / 1.54;
        return sr *= scale;
    }

    public DPoint3 paintAtomShadow(Graphics2D g, MolAtom atom, Color color) {
        DPoint3 location = atom.getLocation();
        this.calcGP(location);
        this.paintAtomShadow(g, location, color, color, 1.0);
        return location;
    }

    public DPoint3 paintAtomShadow(Graphics2D g, DPoint3 point, Color fillColor, Color borderColor, double scale) {
        Graphics2D g2 = (Graphics2D)g.create();
        this.common.setAntialiasing(g2, true);
        double sr = this.getRadius(scale);
        int w = (int)(2.0 * sr + 0.5);
        if (fillColor != null) {
            g2.setColor(fillColor);
            g2.fillOval((int)(point.x - sr), (int)(point.y - sr), w, w);
        }
        if (borderColor != null) {
            g2.setColor(borderColor);
            g2.drawOval((int)(point.x - sr), (int)(point.y - sr), w, w);
        }
        g2.dispose();
        return new DPoint3(point.x - 0.6 * sr, point.y + 0.65 * sr, 0.0);
    }

    public void paintBondShadow(Graphics2D g, MolBond bond, Color color) {
        double yd;
        double xd;
        Graphics2D g2 = (Graphics2D)g.create();
        this.common.setAntialiasing(g2, true);
        g2.setColor(color);
        double sr = this.getAtomSize();
        int w = (int)(2.0 * (sr *= this.imageSize.scale / 1.54) + 0.5);
        DPoint3 p1 = bond.getAtom1().getLocation();
        this.calcGP(p1);
        DPoint3 p2 = bond.getAtom2().getLocation();
        this.calcGP(p2);
        g2.drawOval((int)(p1.x - sr), (int)(p1.y - sr), w, w);
        g2.fillOval((int)(p1.x - sr), (int)(p1.y - sr), w, w);
        g2.drawOval((int)(p2.x - sr), (int)(p2.y - sr), w, w);
        g2.fillOval((int)(p2.x - sr), (int)(p2.y - sr), w, w);
        if (p2.x != p1.x) {
            double m = (p2.y - p1.y) / (p2.x - p1.x);
            double phi = Math.atan(m);
            xd = sr * Math.sin(phi);
            yd = sr * Math.cos(phi);
        } else {
            xd = sr;
            yd = 0.0;
        }
        int[] x = new int[4];
        int[] y = new int[4];
        x[0] = (int)(p1.x + (xd += 0.25));
        y[0] = (int)(p1.y - (yd += 0.25));
        x[1] = (int)(p1.x - xd);
        y[1] = (int)(p1.y + yd);
        x[2] = (int)(p2.x - xd);
        y[2] = (int)(p2.y + yd);
        x[3] = (int)(p2.x + xd);
        y[3] = (int)(p2.y - yd);
        g2.drawPolygon(x, y, x.length);
        g2.fillPolygon(x, y, x.length);
        g2.dispose();
    }

    private void paintSgroupShadow(Graphics2D g, Molecule mm) {
        int nsg = mm.getSgroupCount();
        if (nsg > 0) {
            for (int i = 0; i < nsg; ++i) {
                MulticenterSgroup msg;
                Sgroup sg = mm.getSgroup(i);
                if (!(sg instanceof MulticenterSgroup) || !(msg = (MulticenterSgroup)sg).hasNonCoordinateBond()) continue;
                this.paintShadow(g, msg);
            }
        }
    }

    private void paintSgroupBrackets(Graphics2D g, Molecule mm) {
        int nsg = mm.getSgroupCount();
        if (nsg > 0) {
            SelectionMolecule m = new SelectionMolecule();
            g.setColor(this.getColors().getForeground());
            for (int i = 0; i < nsg; ++i) {
                Sgroup sg = mm.getSgroup(i);
                if (sg.isBracketVisible()) {
                    this.paintSgroupBrackets(g, sg, m, false);
                }
                if (!(sg instanceof DataSgroup)) continue;
                this.paintDataSgroup(g, (DataSgroup)sg);
            }
        }
    }

    private void paintShadow(Graphics2D g, MulticenterSgroup sg) {
        Color oldColor = g.getColor();
        g.setColor(this.getShadowColor());
        this.common.setAntialiasing(g, true);
        double sr = this.getAtomSize();
        int w = (int)(2.0 * (sr *= this.imageSize.scale / 1.54) + 0.5);
        for (int i = 0; i < sg.getAtomCount(); ++i) {
            MolAtom atom = sg.getAtom(i);
            DPoint3 p1 = atom.getLocation();
            this.calcGP(p1);
            g.drawOval((int)(p1.x - sr), (int)(p1.y - sr), w, w);
            g.fillOval((int)(p1.x - sr), (int)(p1.y - sr), w, w);
            for (int j = 0; j < atom.getBondCount(); ++j) {
                double yd;
                double xd;
                MolAtom otherAtom = atom.getBond(j).getOtherAtom(atom);
                if (sg.indexOf(otherAtom) < 0) continue;
                DPoint3 p2 = otherAtom.getLocation();
                this.calcGP(p2);
                if (p2.x != p1.x) {
                    double m = (p2.y - p1.y) / (p2.x - p1.x);
                    double phi = Math.atan(m);
                    xd = sr * Math.sin(phi);
                    yd = sr * Math.cos(phi);
                } else {
                    xd = sr;
                    yd = 0.0;
                }
                int[] x = new int[4];
                int[] y = new int[4];
                x[0] = (int)(p1.x + (xd += 0.25));
                y[0] = (int)(p1.y - (yd += 0.25));
                x[1] = (int)(p1.x - xd);
                y[1] = (int)(p1.y + yd);
                x[2] = (int)(p2.x - xd);
                y[2] = (int)(p2.y + yd);
                x[3] = (int)(p2.x + xd);
                y[3] = (int)(p2.y - yd);
                g.drawPolygon(x, y, x.length);
                g.fillPolygon(x, y, x.length);
            }
        }
        g.setColor(oldColor);
        this.common.setAntialiasing(g, false);
    }

    private void paintDataSgroup(Graphics2D g, DataSgroup dsg) {
        DataSgroup sgroup;
        DPoint3 loc = new DPoint3();
        Sgroup sgroup2 = sgroup = dsg.getAtomCount() == 0 && dsg.getParentSgroup() != null ? dsg.getParentSgroup() : dsg;
        if (dsg.isDataDetached()) {
            loc = MolPainter.calcDataLocation(dsg);
            this.drawDataSgroupData(g, loc, dsg);
        } else if (sgroup.getBracketCount() != 0) {
            loc = sgroup.getBrackets().get(0).getPoint(1).getLocation();
            loc.x += 0.154;
            loc.y -= 0.308;
            this.drawDataSgroupData(g, loc, dsg);
        } else if (dsg.isVisible()) {
            for (int i = 0; i < sgroup.getAtomCount(); ++i) {
                MolAtom atom = sgroup.getAtom(i);
                loc.x = atom.getX() + 0.154;
                loc.y = atom.getY() + 0.154;
                this.drawDataSgroupData(g, loc, dsg);
            }
        } else {
            loc = MolPainter.getParentDataLocation(dsg);
            if (loc != null) {
                this.drawDataSgroupData(g, loc, dsg);
            }
        }
    }

    private static DPoint3 calcDataLocation(DataSgroup dsg) {
        DPoint3 loc = null;
        loc = dsg.isVisible() || dsg.isAbsolutePlacement() ? dsg.getAbsoluteXY() : MolPainter.getParentDataLocation(dsg);
        return loc;
    }

    private static DPoint3 getParentDataLocation(DataSgroup dsg) {
        DPoint3 loc = null;
        Sgroup parent = dsg.getParentSgroup();
        if (parent.getType() == 0) {
            loc = ((SuperatomSgroup)parent).getSuperAtom().getLocation();
            loc.x += 0.154;
            loc.y += 0.154;
        }
        return loc;
    }

    private void drawDataSgroupData(Graphics2D g, DPoint3 loc, DataSgroup dsg) {
        Font originalFont = g.getFont();
        if (this.normalFont == null) {
            this.initFonts(g);
            if (this.normalFont == null) {
                return;
            }
        }
        g.setFont(this.normalFont);
        int height = this.normalFontMetrics.getHeight();
        this.calcGP(loc);
        int lineCount = dsg.getDataLineCount();
        int displayedLines = dsg.getDisplayedLines();
        if (displayedLines != 0 && lineCount > displayedLines) {
            lineCount = displayedLines;
        }
        for (int i = 0; i < lineCount; ++i) {
            String line = dsg.getLineOnScreen(i);
            if (line.length() > 0) {
                g.drawString(line, (float)loc.x, (float)loc.y);
            }
            loc.y += (double)height;
        }
        g.setFont(originalFont);
    }

    private Point[] preCalcBoundsOfSgroupFromChildren(Graphics2D g, MoleculeGraph m, Sgroup sg, boolean templ) {
        SuperatomSgroup ssg;
        double d = 0.385 * this.getScale();
        if (sg instanceof SuperatomSgroup && !(ssg = (SuperatomSgroup)sg).isExpanded()) {
            return null;
        }
        if (sg instanceof DataSgroup) {
            DataSgroup dsg = (DataSgroup)sg;
            Sgroup parent = dsg.getParentSgroup();
            if (dsg.getAtomCount() == 0 && parent != null) {
                double[] pbnds = this.preCalcBoundsOfSgroup(m, parent, templ);
                Point[] p = new Point[]{this.calcGP(pbnds[0], pbnds[1], pbnds[2]), this.calcGP(pbnds[3], pbnds[4], pbnds[5])};
                Rectangle subScriptBounds = this.getTextBounds(g, DrawingUtil.removeCaret(SimpleTeX.convertShort2TeX(parent.getSubscript(), 0)));
                p[1].x = (int)((double)p[1].x + subScriptBounds.getWidth());
                return p;
            }
        }
        double[] bnds = this.preCalcBoundsOfSgroup(m, sg, templ);
        Point[] p = new Point[]{this.calcGP(bnds[0], bnds[1], bnds[2]), this.calcGP(bnds[3], bnds[4], bnds[5])};
        if (sg.getChildSgroupCount() != 0) {
            for (int i = 0; i < sg.getChildSgroupCount(); ++i) {
                Sgroup csg = sg.getChildSgroup(i);
                Point[] childBnds = this.preCalcBoundsOfSgroupFromChildren(g, m, csg, templ);
                if (csg instanceof SuperatomSgroup) {
                    if (!((SuperatomSgroup)csg).isExpanded()) continue;
                    childBnds[0].y = (int)((double)childBnds[0].y - d);
                    childBnds[1].y = (int)((double)childBnds[1].y + d);
                } else {
                    if (this.smallFont != null) {
                        g.setFont(this.smallFont);
                        Rectangle subScriptBounds = this.getTextBounds(g, DrawingUtil.removeCaret(SimpleTeX.convertShort2TeX(csg.getSubscript(), 0)));
                        Rectangle2D superScriptBounds = this.smallFontMetrics.getStringBounds(MolPainter.getSuperScript(csg), g);
                        childBnds[1].x = (int)((double)childBnds[1].x + Math.max(subScriptBounds.getWidth(), superScriptBounds.getWidth()));
                        childBnds[1].x = (int)((double)childBnds[1].x + d);
                        childBnds[0].y = (int)((double)childBnds[0].y - d);
                        childBnds[1].y = (int)((double)childBnds[1].y + d);
                    }
                    if (csg.getType() != 1) {
                        childBnds[0].x = (int)((double)childBnds[0].x - d);
                        childBnds[1].x = (int)((double)childBnds[1].x + d);
                    }
                }
                if (p == null) {
                    p = childBnds;
                    continue;
                }
                p[0].x = Math.min(p[0].x, childBnds[0].x);
                p[0].y = Math.min(p[0].y, childBnds[0].y);
                p[1].x = Math.max(p[1].x, childBnds[1].x);
                p[1].y = Math.max(p[1].y, childBnds[1].y);
            }
        }
        return p;
    }

    private void paintSgroupBrackets(Graphics2D g, Sgroup sg, MoleculeGraph m, boolean templ) {
        if (!sg.hasBrackets()) {
            return;
        }
        if (sg instanceof RepeatingUnitSgroup && sg.isVisible()) {
            this.paintSruScript(g, (RepeatingUnitSgroup)sg);
            return;
        }
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (sg.getBracketCount() == 0 || sg.getType() == 1 && sg.getXState() == 1) {
            Point[] p = this.preCalcBoundsOfSgroupFromChildren(g, m, sg, templ);
            if (p == null) {
                return;
            }
            x1 = p[0].x;
            y1 = p[0].y;
            x2 = p[1].x;
            y2 = p[1].y;
            if (sg.getAtomCount() != 0) {
                int dx = (int)Math.round(this.atomSize * this.imageSize.scale / 1.54 * 0.5);
                LinePainter.gDrawLine(g, (x1 -= 2) + dx, --y1, x1, y1);
                LinePainter.gDrawLine(g, x1, y1, x1, ++y2);
                LinePainter.gDrawLine(g, x1, y2, x1 + dx, y2);
                LinePainter.gDrawLine(g, ++x2 - dx, y1, x2, y1);
                LinePainter.gDrawLine(g, x2, y1, x2, y2);
                LinePainter.gDrawLine(g, x2, y2, x2 - dx, y2);
            }
        } else {
            DPoint3 subp = DrawingUtil.getSubScriptPosition(sg);
            DPoint3 superp = DrawingUtil.getSuperscriptPosition(sg);
            if (subp != null) {
                this.calcGP(subp);
                x2 = (int)subp.x + 2;
                y2 = (int)subp.y + 1;
            }
            if (superp != null) {
                this.calcGP(superp);
                y1 = (int)superp.y - 1;
            }
        }
        if (this.smallFont != null) {
            g.setFont(this.smallFont);
            if (!(sg instanceof SuperatomSgroup) && MolPainter.getSuperScript(sg).length() != 0 && sg.isVisible()) {
                FontMetrics fontMetrics;
                Font font;
                if (sg.getChargeLocation() == 2) {
                    font = this.boldFont;
                    fontMetrics = this.boldFontMetrics;
                } else {
                    font = this.normalFont;
                    fontMetrics = this.normalFontMetrics;
                }
                this.drawText(g, font, fontMetrics, this.italicFont, this.italicFontMetrics, this.smallFont, this.smallFontMetrics, x2 + 1, y1 + 1, 0, null, MolPainter.getSuperScript(sg), true);
            }
            if (DrawingUtil.removeCaret(sg.getSubscript()).length() != 0 && sg.isVisible()) {
                this.drawText(g, this.normalFont, this.normalFontMetrics, this.italicFont, this.italicFontMetrics, this.smallFont, this.smallFontMetrics, x2 + 1, y2 - 1 - this.normalFontMetrics.getAscent(), 0, null, sg.getType() == 0 ? DrawingUtil.removeCaret(SimpleTeX.convertShort2TeX(sg.getSubscript(), 0)) : DrawingUtil.removeCaret(sg.getSubscript()), true);
            }
        }
    }

    private void paintSruScript(Graphics2D g, RepeatingUnitSgroup sg) {
        DPoint3[] maxsc = null;
        ArrayList<MBracket> brackets = sg.getBrackets();
        for (int j = brackets.size() - 1; j >= 0; --j) {
            DPoint3[] sc = null;
            sc = this.calcScriptPositions(g, brackets.get(j), sg);
            if (maxsc == null) {
                maxsc = sc;
                continue;
            }
            if (sc == null || !(sc[0].x + sc[0].y > maxsc[0].x + maxsc[0].y)) continue;
            maxsc = sc;
        }
        if (maxsc != null) {
            if (this.normalFont == null) {
                this.initFonts(g);
                if (this.normalFont == null) {
                    return;
                }
            }
            this.drawText(g, this.normalFont, this.normalFontMetrics, this.italicFont, this.italicFontMetrics, this.smallFont, this.smallFontMetrics, maxsc[0].x + 2.0, maxsc[0].y, 0, null, DrawingUtil.removeCaret(sg.getSubscript()), false);
            this.drawText(g, this.normalFont, this.normalFontMetrics, this.italicFont, this.italicFontMetrics, this.smallFont, this.smallFontMetrics, maxsc[1].x + 2.0, maxsc[1].y, 0, null, MolPainter.getSuperScript(sg), false);
        }
    }

    private DPoint3[] calcScriptPositions(Graphics2D g, MBracket b, RepeatingUnitSgroup sg) {
        DPoint3[] u = new DPoint3[4];
        MPoint[] points = b.getPoints();
        if (b.getBracketOrientation() == 5) {
            u[0] = points[1].getLocation();
            u[1] = points[2].getLocation();
            u[2] = points[0].getLocation();
            u[3] = points[3].getLocation();
        } else {
            u[0] = points[0].getLocation();
            u[1] = points[3].getLocation();
            u[2] = points[1].getLocation();
            u[3] = points[2].getLocation();
        }
        for (int i = 0; i < points.length; ++i) {
            this.calcGP(u[i]);
        }
        return this.calcScriptPositions(sg, g, u);
    }

    private double[] preCalcBoundsOfSgroup(MoleculeGraph m, Sgroup sg, boolean templ) {
        m.removeAll();
        for (int j = 0; j < sg.getAtomCount(); ++j) {
            MolAtom a = sg.getAtom(j);
            m.add(a);
        }
        double[] bnds = new double[6];
        MoleculeGraph[] mols = new MoleculeGraph[]{m};
        MolPainter.calcBounds(this.common, mols, this.atomSize, this.common.getBondSpacing(), templ, false, bnds, this.preTransform, 1.0, this.imageSize);
        this.transformBounds(bnds);
        return bnds;
    }

    private void paintObjects(Graphics2D g, LinePainter lpainter, int nobjs, Object[] objs, MoleculeGraph umol, MoleculeGraph molg, RgMoleculeGraphIface rgmol, boolean[][] showChiral, MDocument doc, GraphicsPresentationChooser grPres) {
        boolean isRealRgMol;
        ColorCollection colors = this.getColors();
        MObject focusedMObject = doc != null ? doc.getFocus() : null;
        MObject draggedMObject = doc != null ? doc.getDraggedObject() : null;
        int mobjflags = this.common.getDispQuality() > 0 ? 1 : 0;
        this.atomMinx = Integer.MAX_VALUE;
        this.atomMiny = Integer.MAX_VALUE;
        Font font0 = g.getFont();
        double[] bwght = this.common.tmpBondWeights;
        List<MolAtom> attachpts = this.common.tmpAttachpts;
        this.common.setAntialiasing(g, true);
        boolean antialias_on = true;
        this.setBondOptions(molg);
        AtomLabeller alabeller = new AtomLabeller(this.common);
        alabeller.setMol(umol);
        int paintedAtoms = 0;
        int totalAtomCount = umol.getAtomCount();
        this.atomCoordsOffVect = new double[totalAtomCount][2];
        this.ringBondIndexes.clear();
        for (int i = 0; i < nobjs; ++i) {
            Color c;
            Object obj = objs[i];
            if (obj instanceof MolBond) {
                if (!antialias_on) {
                    this.common.setAntialiasing(g, true);
                    antialias_on = true;
                }
                this.paintBond(g, lpainter, objs, i, umol, alabeller, doc);
                continue;
            }
            if (obj instanceof MolAtom) {
                if (!antialias_on) {
                    this.common.setAntialiasing(g, true);
                    antialias_on = true;
                }
                this.paintAtom(g, lpainter, (MolAtom)obj, umol, molg, rgmol, showChiral, alabeller, attachpts, bwght, doc);
                if (!this.isClipping || !this.isTransparent() || ++paintedAtoms != totalAtomCount) continue;
                this.setExtraClips(g);
                continue;
            }
            if (obj instanceof MoleculeGraph) {
                Molecule m = (Molecule)obj;
                if (!antialias_on) {
                    this.common.setAntialiasing(g, true);
                    antialias_on = true;
                }
                this.paintRgSgRxn(g, m);
                this.paintBondLabels(g, m);
                continue;
            }
            if (!(obj instanceof MObject)) continue;
            MObject o = (MObject)obj;
            mobjflags &= 0xFFFFFFFD;
            if (doc.getFocus() == o) {
                mobjflags |= 2;
            }
            if ((c = o.getColor()) == null) {
                c = colors.getForeground();
            }
            boolean highlighted = doc.isHighlighted(o) || o == focusedMObject || o == draggedMObject || draggedMObject != null && draggedMObject.isChildOf(o);
            Color highlightColor = o instanceof MTextBox ? colors.getTextBoxColor() : colors.getAtomHighlightColor();
            Font oldFont = g.getFont();
            if (o instanceof MAssigner) {
                g.setFont(this.normalFont);
            }
            GraphicsPainter gp = grPres.getGraphicsPainter(o.getClass());
            gp.paint(o, g, this.transformMatrix, mobjflags, c, colors.getSelectionColor(), highlighted ? highlightColor : null);
            antialias_on = false;
            g.setFont(oldFont);
        }
        if (this.common.getLigandOrderVisibility() != "off") {
            this.paintAttachmentPointInformation(g, molg);
        }
        boolean bl = molg instanceof RgMolecule ? ((RgMolecule)molg).getRgroupCount() > 0 : (isRealRgMol = false);
        if (this.common.isRgDefinitionVisible() || !isRealRgMol) {
            this.paintAttachmentShadow(g, molg, lpainter, doc);
        }
        if (this.isClipping && this.isTransparent()) {
            this.removeExtraClips(g);
        }
        if (!antialias_on) {
            this.common.setAntialiasing(g, true);
            antialias_on = true;
        }
        if (attachpts.size() != 0 && this.normalFont != null) {
            g.setColor(colors.getForeground());
            g.setFont(this.normalFont);
            FontMetrics bfm = this.boldFontMetrics;
            for (int i = attachpts.size() - 1; i >= 0; --i) {
                MolAtom a = attachpts.get(i);
                DPoint3 p = (DPoint3)this.screenCoords[umol.indexOf(a)].clone();
                String s = MolPainter.prepareDrawAttach(a, this.preTransform, this.imageSize.scale, p, bwght);
                double x = p.x - 0.5 * (double)bfm.stringWidth(s);
                int asc = bfm.getAscent();
                double y = p.y + ((double)asc - 0.5 * (double)(asc + bfm.getDescent()));
                g.drawString(s, (float)x, (float)y);
            }
        }
        g.setFont(font0);
        attachpts.clear();
        this.common.setAntialiasing(g, false);
    }

    private void paintAttachmentPointInformation(Graphics2D g, MoleculeGraph graph) {
        MoleculeGraph molg = graph instanceof RgMolecule ? (this.common.isRgDefinitionVisible() ? graph.getGraphUnion() : ((RgMolecule)graph).getRoot()) : graph;
        for (int j = 0; j < molg.getAtomCount(); ++j) {
            MolAtom atom = molg.getAtom(j);
            if (atom.getAtno() != 134 || atom.getBondCount() <= 1) continue;
            this.paintLigandOrder(g, graph, atom);
        }
    }

    private void paintLigandOrder(Graphics2D g, MoleculeGraph graph, MolAtom atom) {
        boolean skipOrderDrawing;
        int rgroups = 0;
        int order = 0;
        if (graph instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)graph;
            int rgindex = rgmol.findRgroupIndex(atom.getRgroup());
            rgroups = rgindex == -1 ? 0 : rgmol.getRgroupMemberCount(rgindex);
            order = rgmol.getMaxAttachmentPointOrder(atom.getRgroup());
        }
        boolean bl = skipOrderDrawing = this.common.getLigandOrderVisibility() == "showOnlyWithDefinition" && rgroups == 0;
        if (!skipOrderDrawing) {
            int i;
            int count = Math.min(order, atom.getBondCount());
            for (i = 0; i < count; ++i) {
                this.paintBondOrder(g, atom.getBond(i), i + 1, atom, Color.white, Color.GRAY, Color.BLACK);
            }
            for (i = count; i < atom.getBondCount(); ++i) {
                if (this.common.isLigandErrorVisible()) {
                    this.paintBondOrder(g, atom.getBond(i), i + 1, atom, Color.white, ColorCollection.PINK, ColorCollection.RED);
                    continue;
                }
                this.paintBondOrder(g, atom.getBond(i), i + 1, atom, Color.white, Color.GRAY, Color.BLACK);
            }
        }
    }

    private void removeExtraClips(Graphics2D g) {
        Area clip = new Area(g.getClip());
        Rectangle2D bounds = clip.getBounds2D();
        g.setClip(bounds);
        this.coveringLabels.clear();
    }

    private void setExtraClips(Graphics2D g) {
        if (this.coveringLabels.size() < 50) {
            Area clip = new Area();
            for (RoundRectangle2D current : this.coveringLabels) {
                clip.add(new Area(current));
            }
            Area result = new Area(g.getClip());
            result.subtract(clip);
            g.setClip(result);
        } else {
            QuadTree tree = new QuadTree(g.getClip().getBounds2D());
            for (RoundRectangle2D current : this.coveringLabels) {
                tree.add(current);
            }
            g.setClip(tree.calculate(g.getClip()));
        }
    }

    public void paintIncipientBond(Graphics2D g, MolAtom[] atoms, MDocument doc) {
        LinePainter lpainter = new LinePainter(this.common, this.getColors(), this.getLineThickness(), this.getLineThicknessAsInt());
        this.paintIncipientBond(g, lpainter, atoms, doc);
    }

    private void paintIncipientBond(Graphics2D g, LinePainter lpainter, MolAtom[] atoms, MDocument doc) {
        Shades shades;
        MolAtom a1 = atoms[0];
        MolAtom a2 = atoms[1];
        DPoint3 p1 = a1.getLocation();
        DPoint3 p2 = a2.getLocation();
        this.calcGP(p1);
        this.calcGP(p2);
        if (a1.isSelected() && a2.isSelected()) {
            ColorCollection colors = this.getColors();
            shades = new Shades(colors.getSelectionColor());
            g.setColor(colors.getSelectionColor());
            lpainter.setEndColors(null, null);
        } else {
            shades = this.getShades(atoms[0], doc);
            lpainter.setEndColors(this.getColor(a1, doc), this.getColor(a2, doc));
        }
        lpainter.dashedLine(p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, 8, 3, g, shades);
        lpainter.setEndColors(null, null);
    }

    private static String prepareDrawAttach(MolAtom a, CTransform3D t, double scale, DPoint3 p, double[] bwght) {
        String s = "*?";
        switch (a.getAttach()) {
            case 1: {
                s = "*";
                break;
            }
            case 2: {
                s = "*\"";
                break;
            }
            case 3: {
                s = "* *'";
            }
        }
        a.bondweights(bwght, t);
        double r = Math.sqrt(bwght[0] * bwght[0] + bwght[1] * bwght[1] + bwght[2] * bwght[2]);
        if (r <= 0.0015400000000000001) {
            bwght[0] = 0.0;
            bwght[1] = -0.5 * scale;
            bwght[2] = 0.0;
        } else {
            double c = -0.5 * scale / r;
            bwght[0] = bwght[0] * c;
            bwght[1] = bwght[1] * c;
            bwght[2] = bwght[2] * c;
        }
        p.x += bwght[0];
        p.y -= bwght[1];
        return s;
    }

    private static void calcBounds(MolPainterCommon common, MoleculeGraph[] mols, double atsiz, double bw, boolean templ, boolean enlargeFor3dRot, double[] xyrr, CTransform3D pretrf, double scale, MolImageSize imSize) {
        MolPainter.calcBounds(common, mols, atsiz, bw, templ, false, enlargeFor3dRot, xyrr, pretrf, scale, imSize, true, false);
    }

    private static void calcBounds(MolPainterCommon common, MoleculeGraph[] mols, double atsiz, double bw, boolean templ, boolean inToolbar, boolean enlargeFor3dRot, double[] xyrr, CTransform3D pretrf, double scale, MolImageSize imSize, boolean calcDoc, boolean calcHighlight) {
        String[] s;
        double maxdescent;
        double maxascent;
        double[] xyminm = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308};
        atsiz *= 1.54;
        bw *= 1.54;
        Toolkit tk = Toolkit.getDefaultToolkit();
        FontMetrics rfm = tk.getFontMetrics(common.getBaseFont());
        FontMetrics sfm = tk.getFontMetrics(common.getBaseSmallFont());
        int[] lcenter = new int[7];
        double onept = atsiz / 12.0;
        double ascent = (double)rfm.getAscent() * onept;
        double descent = (double)rfm.getDescent() * onept;
        double h = ascent + descent;
        if (templ) {
            maxascent = ascent;
            maxdescent = descent;
        } else {
            maxascent = (double)sfm.getAscent() * onept * 3.0 / 2.0;
            maxdescent = (double)(sfm.getAscent() / 2 + sfm.getDescent()) * onept;
        }
        if (ascent > maxascent) {
            maxascent = ascent;
        }
        if (descent > maxdescent) {
            maxdescent = descent;
        }
        double[] bwght = new double[3];
        double[] sgds = new double[]{0.0, 0.0, 0.0, 0.0};
        AtomLabeller alabeller = new AtomLabeller(common);
        for (int imol = 0; imol < mols.length; ++imol) {
            MoleculeGraph graph = mols[imol];
            alabeller.setMol(graph);
            MolPainter.calcMolBounds(graph, onept, xyminm, h, templ, enlargeFor3dRot, common, alabeller, pretrf, lcenter, bw, bwght, maxascent, sgds, maxdescent, imSize, calcHighlight);
            MDocument doc = graph.getDocument();
            if (doc != null && calcDoc) {
                MolPainter.calcDocBounds(doc, xyminm, pretrf, null, common);
                continue;
            }
            if (graph == null || !(graph instanceof MObjectContainer)) continue;
            MolPainter.calcDocBounds(doc, xyminm, pretrf, graph, common);
        }
        String[] stringArray = s = mols != null && mols.length != 0 ? MolPainter.decodeRegno(mols[0]) : null;
        if (s != null) {
            if (xyminm[0] == Double.MAX_VALUE) {
                xyminm[0] = Math.min(xyminm[0], 0.0);
                for (int i = 0; i < s.length; ++i) {
                    xyminm[2] = Math.max(xyminm[2], onept * (double)rfm.stringWidth(s[i]));
                }
                xyminm[1] = Math.min(xyminm[1], onept * (double)rfm.getDescent());
                xyminm[3] = Math.max(xyminm[3], onept * (double)(rfm.getAscent() + rfm.getHeight() * (s.length - 1)));
            } else {
                xyminm[3] = xyminm[3] + onept * (double)rfm.getAscent();
            }
        }
        xyminm[0] = xyminm[0] + sgds[0];
        xyminm[2] = xyminm[2] + sgds[2];
        xyminm[1] = xyminm[1] + sgds[3];
        xyminm[3] = xyminm[3] + sgds[1];
        if (xyminm[0] > xyminm[2] || xyminm[1] > xyminm[3]) {
            xyminm[0] = 0.0;
            xyminm[1] = 0.0;
            xyminm[2] = 0.0;
            xyminm[3] = 0.0;
        }
        xyminm[0] = xyminm[0] - onept;
        xyminm[2] = xyminm[2] + onept;
        xyminm[1] = xyminm[1] - onept;
        xyminm[3] = xyminm[3] + onept;
        double xcenter = (xyminm[2] + xyminm[0]) / 2.0;
        double ycenter = (xyminm[3] + xyminm[1]) / 2.0;
        xyrr[0] = xcenter;
        xyrr[1] = ycenter;
        xyrr[2] = 0.5 * scale * (xyminm[2] - xyminm[0]);
        xyrr[3] = 0.5 * scale * (xyminm[3] - xyminm[1]);
        if (templ && inToolbar) {
            xyrr[2] = xyrr[2] - 3.5 * onept;
            xyrr[3] = xyrr[3] - 3.5 * onept;
        }
        if (xyrr[2] < 5.0E-5) {
            if (xyrr[3] < 5.0E-5) {
                xyrr[1] = 0.0;
                xyrr[0] = 0.0;
                xyrr[3] = 0.5;
                xyrr[2] = 0.5;
            } else {
                xyrr[2] = 5.0E-5;
            }
        }
        if (xyrr[3] < 5.0E-5) {
            xyrr[3] = 5.0E-5;
        }
    }

    private static void calcAtomBounds(MolAtom a, int atomIndex, int dim, MDocument doc, List<Object> rgdef, DPoint3 center, double onept, double[] xyminm, double h, boolean templ, boolean enlargeFor3dRot, MolPainterCommon common, AtomLabeller alabeller, CTransform3D pretrf, int[] lcenter, double bw, double[] bwght, Toolkit tk, FontMetrics rfm, FontMetrics ifm, FontMetrics bfm, FontMetrics sfm, double ascent, double descent, double maxascent, double maxdescent, MolImageSize imSize) {
        boolean isImplLonePairVisible;
        for (int j = 0; j < lcenter.length; ++j) {
            lcenter[j] = 0;
        }
        double rgw = 0.0;
        if (!rgdef.isEmpty()) {
            int rgindex = -1;
            for (int g = 0; g < rgdef.size() && rgdef.get(g) instanceof Molecule && rgindex == -1; g += 2) {
                rgindex = ((Molecule)rgdef.get(g)).indexOf(a) != -1 ? (Integer)rgdef.get(g + 1) : -1;
            }
            if (rgindex != -1) {
                String rgs = "R" + rgindex + " = ";
                rgw = onept * (double)(rfm.stringWidth(rgs) & 0xFFFF);
                double thickness = MolPainter.getLineThickness(1.0, common.getWireThickness(), common.getStickThickness(), common.getDispopts());
                rgw += 2.0 * thickness;
            }
        }
        double extraWidth = 0.0;
        boolean isExplLonePairVisible = common.areLonePairsVisible() && !common.areLonePairsAutoCalc() && a.getElectronProp() > 0;
        boolean bl = isImplLonePairVisible = common.areLonePairsVisible() && common.areLonePairsAutoCalc() && a.getLonePairCount() > 0;
        if (a.getRadical() > 0 || a.getCharge() != 0 || isExplLonePairVisible || isImplLonePairVisible) {
            char radicalChar = MolAtom.RADICAL_CHAR;
            extraWidth = onept * (double)(rfm.charWidth(radicalChar) & 0xFFFF);
            double thickness = MolPainter.getLineThickness(1.0, common.getWireThickness(), common.getStickThickness(), common.getDispopts());
            extraWidth += 2.0 * thickness;
        }
        DPoint3 p = a.getLocation();
        pretrf.transform(p);
        double stw = 0.0;
        if (a.getAttach() != 0 && MolPainter.isAttachVisible(a, common)) {
            DPoint3 pp = (DPoint3)p.clone();
            String st = MolPainter.prepareDrawAttach(a, pretrf, imSize.scale, pp, bwght);
            stw = 2.0 * onept * (double)(bfm.stringWidth(st) & 0xFFFF);
        }
        Font newFont = common.getAtomSetFont(a.getSetSeq(), doc);
        Font itf = null;
        Font sf = null;
        if (newFont != null && !newFont.equals(common.getBaseFont())) {
            double n = newFont.getSize();
            itf = FontMaker.makeFont(2, (int)n, newFont);
            sf = FontMaker.makeFont(newFont.getStyle(), (int)n, newFont);
            rfm = tk.getFontMetrics(newFont);
            ifm = tk.getFontMetrics(itf);
            sfm = tk.getFontMetrics(sf);
            ascent = (double)rfm.getAscent() * onept;
            descent = (double)rfm.getDescent() * onept;
            maxascent = (double)sfm.getAscent() * onept * 3.0 / 2.0;
            maxdescent = (double)(sfm.getAscent() / 2 + sfm.getDescent()) * onept;
            if (ascent > maxascent) {
                maxascent = ascent;
            }
            if (descent > maxdescent) {
                maxdescent = descent;
            }
        }
        int labelit = alabeller.getLabelVisibility(a, a.getBondCount(), dim);
        boolean hydrit = !templ && a.getImplicitHcount() > 0 && (labelit & 4) != 0;
        String s = MolPainter.getAtomSymbol(a, hydrit, false, lcenter, pretrf);
        if (lcenter[0] <= 0 && lcenter[1] <= 0) {
            MolPainter.findAtomSymbol(a, s, lcenter, pretrf);
        }
        int vertdir = lcenter[2];
        double w = bw;
        int wl = 0;
        lcenter[5] = -1;
        double sldy = 0.0;
        double relx = 0.0;
        MolPainter.bondweights(a, bwght, s, pretrf);
        if (!templ || a.getAtno() != 6) {
            String sel = alabeller.getLabels(a, atomIndex);
            TextGraphics txtg = new TextGraphics(s, lcenter);
            boolean hasRightNameLabel = a instanceof SgroupAtom && ((SgroupAtom)a).hasAlternativeName() && ((SgroupAtom)a).getRightName() != null;
            int sldim = txtg.draw(0, 0, 0, null, newFont, rfm, itf, ifm, sf, sfm, lcenter, hasRightNameLabel, null, null);
            w = onept * (double)(sldim & 0xFFFF);
            sldy = onept * (double)(sldim >> 16);
            if (!sel.equals("")) {
                txtg = new TextGraphics(sel, null);
                int seldim = txtg.draw(0, 0, 0, null, common.getBaseFont(), rfm, common.getBaseItalicFont(), ifm, common.getBaseSmallFont(), sfm, null, hasRightNameLabel, null, null);
                wl = seldim & 0xFFFF;
                int[] dims = new int[]{wl, 0};
                Point pl = MolPainter.getLabelsP(a, 0, 0, (int)Math.ceil(w), dims, null, null, sfm, rfm, 0);
                relx += onept * (double)pl.x;
                sldy += onept * (double)Math.abs(pl.y) * 2.0;
            }
        }
        if (lcenter[5] >= 0 && lcenter[6] > 0 && s.charAt(0) != '[') {
            SgroupAtom sa;
            int k;
            relx = a instanceof SgroupAtom ? ((k = (sa = (SgroupAtom)a).getLabelCenter()) != 0 || sa.hasAlternativeName() ? (relx += -0.5 * onept * (double)(2 * lcenter[5] + lcenter[6])) : (relx += -0.5 * w * (bwght[0] + 1.0))) : (relx += -0.5 * onept * (double)(2 * lcenter[5] + lcenter[6]));
        }
        w += onept * (double)wl;
        if (dim == 3 && enlargeFor3dRot) {
            double d;
            double dx = p.x - center.x;
            double dz = p.z - center.z;
            double r = Math.sqrt(dx * dx + dz * dz);
            double xl = center.x - r + relx;
            if (xl - rgw < xyminm[0]) {
                xyminm[0] = xl - rgw;
            }
            xl = center.x + r + relx + w;
            if (d > xyminm[2]) {
                xyminm[2] = xl + w;
            }
        } else {
            double x = p.x;
            double xl = x + relx;
            double extraw = Math.max(rgw, extraWidth);
            if (xl - extraw < xyminm[0]) {
                xyminm[0] = xl - extraw;
            }
            if (xl + w + extraWidth + stw > xyminm[2]) {
                xyminm[2] = xl + w + extraWidth + stw;
            }
        }
        double aw = 0.0;
        Molecule aparent = (Molecule)a.getParent();
        if (aparent != null && aparent.isAbsStereo()) {
            aw = onept * (double)(bfm.getHeight() & 0xFFFF);
        }
        double yl = p.y - ascent / 2.0;
        if (vertdir > 0) {
            yl += sldy;
        } else if (vertdir == 0) {
            yl += sldy / 2.0;
        }
        double y = yl - maxdescent - sldy - extraWidth - stw;
        if (y < xyminm[1]) {
            xyminm[1] = y;
        }
        if ((y = yl + maxascent + extraWidth + aw + stw) > xyminm[3]) {
            xyminm[3] = y;
        }
        if (a.getAttach() != 0 && MolPainter.isAttachVisible(a, common)) {
            s = MolPainter.prepareDrawAttach(a, pretrf, 1.54, p, bwght);
            double sw = onept * (double)rfm.stringWidth(s);
            DPoint3 q = new DPoint3(p.x - sw / 2.0, p.y - (ascent - (ascent + descent) / 2.0), 0.0);
            MolPainter.addToBounds(q, xyminm, h, sw);
        }
        MolPainter.caclRgroupAttachmentBounds(a, xyminm, pretrf);
    }

    private static void caclRgroupAttachmentBounds(MolAtom a, double[] xyminm, CTransform3D pretrf) {
        if (a.getAtno() == 138 && a.getBondCount() > 0) {
            MolBond bond = a.getBond(0);
            DPoint3 otherAtomLocation = bond.getOtherAtom(a).getLocation();
            DPoint3 atomLocation = a.getLocation();
            pretrf.transform(otherAtomLocation);
            pretrf.transform(atomLocation);
            double distance = otherAtomLocation.distance(atomLocation);
            DPoint3 p1 = CleanUtil.calcDividingPoint(atomLocation, otherAtomLocation, 0.65 / distance);
            float[] coords1 = GroupUtil.getNextDirection(atomLocation, p1, 1, 1, 1.5707963267948966);
            float[] coords2 = GroupUtil.getNextDirection(atomLocation, p1, 1, -1, 1.5707963267948966);
            MolPainter.addToBounds(new DPoint3(coords1[0], coords1[1], 0.0), xyminm, 0.0, 0.0);
            MolPainter.addToBounds(new DPoint3(coords2[0], coords2[1], 0.0), xyminm, 0.0, 0.0);
        }
    }

    private static void calcMolBounds(MoleculeGraph graph, double onept, double[] xyminm, double h, boolean templ, boolean enlargeFor3dRot, MolPainterCommon common, AtomLabeller alabeller, CTransform3D pretrf, int[] lcenter, double bw, double[] bwght, double maxascent, double[] sgds, double maxdescent, MolImageSize imSize, boolean calcHighlight) {
        int dispopts = common.getDispopts();
        Toolkit tk = Toolkit.getDefaultToolkit();
        FontMetrics rfm = tk.getFontMetrics(common.getBaseFont());
        FontMetrics ifm = tk.getFontMetrics(common.getBaseItalicFont());
        FontMetrics sfm = tk.getFontMetrics(common.getBaseSmallFont());
        FontMetrics bfm = tk.getFontMetrics(common.getBaseBoldFont());
        FontMetrics lfm = tk.getFontMetrics(common.getBaseBigBoldFont());
        double ascent = (double)rfm.getAscent() * onept;
        double descent = (double)rfm.getDescent() * onept;
        ArrayList<Object> rgdef = new ArrayList<Object>();
        if (graph instanceof Molecule) {
            Molecule mol = (Molecule)graph;
            MolPainter.calcSgroupBounds(mol, calcHighlight, sgds, onept, bfm, sfm, xyminm, lfm, pretrf, common);
            if (mol instanceof RgMoleculeGraphIface) {
                RgMoleculeGraphIface rgmol = (RgMoleculeGraphIface)((Object)mol);
                int rgcount = rgmol.getRgroupCount();
                int members = 0;
                for (int k = 0; k < rgcount; ++k) {
                    members = (dispopts & 0x4000000) == 0 ? 0 : rgmol.getRgroupMemberCount(k);
                    for (int l = 0; l < members; ++l) {
                        rgdef.add(rgmol.getRgroupMemberG(k, l));
                        rgdef.add(new Integer(rgmol.getRgroupId(k)));
                    }
                }
            }
            graph = mol instanceof RgMoleculeGraphIface && (dispopts & 0x4000000) == 0 ? ((RgMoleculeGraphIface)((Object)mol)).getRootG() : mol.getGraphUnion();
        }
        h = graph.isAtom() ? 0.0 : ascent + descent;
        DPoint3 center = graph.calcCenter();
        for (int i = 0; i < graph.getAtomCount(); ++i) {
            MolAtom a = graph.getAtom(i);
            MolPainter.calcAtomBounds(a, i, graph.getDim(), graph.getDocument(), rgdef, center, onept, xyminm, h, templ, enlargeFor3dRot, common, alabeller, pretrf, lcenter, bw, bwght, tk, rfm, ifm, bfm, sfm, ascent, descent, maxascent, maxdescent, imSize);
        }
    }

    private static void calcSgroupBounds(Molecule molecule, boolean calcHighlight, double[] sgds, double onept, FontMetrics bfm, FontMetrics sfm, double[] xyminm, FontMetrics lfm, CTransform3D pretrf, MolPainterCommon common) {
        Molecule mol = molecule instanceof RgMolecule && !common.isRgDefinitionVisible() ? ((RgMolecule)molecule).getRoot() : molecule;
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            DPoint3 dap1;
            Sgroup sg = mol.getSgroup(i);
            if (sg.getType() == 0) continue;
            if (sg.getType() != 10 || calcHighlight) {
                int wsub;
                sgds[1] = onept * (double)(bfm.getHeight() + 1);
                sgds[3] = -onept * (double)(sfm.getDescent() + 1);
                sgds[0] = -7.0 * onept;
                int ws = 0;
                String sup = MolPainter.getSuperScript(sg);
                String sub = DrawingUtil.removeCaret(sg.getSubscript());
                int wsup = sfm.stringWidth(sup);
                ws = wsup > (wsub = bfm.stringWidth(sub)) ? wsup : wsub;
                double d = onept * (double)(7 + ws);
                if (d > sgds[2]) {
                    sgds[2] = d;
                }
            }
            if (sg.getType() != 10) continue;
            DataSgroup dsg = (DataSgroup)sg;
            Rectangle r = MolPainter.getDataLabelBounds(dsg, lfm);
            if (dsg.isDataDetached()) {
                dap1 = MolPainter.calcDataLocation(dsg);
                if (dap1 == null) continue;
                pretrf.transform(dap1);
                dap1.y += onept * (double)r.y;
                dap1.x += onept * (double)r.x;
                MolPainter.addToBounds(dap1, xyminm, onept * (double)r.height, onept * (double)r.width);
                continue;
            }
            if (dsg.isVisible()) {
                for (int m = 0; m < dsg.getAtomCount(); ++m) {
                    DPoint3 dap12 = dsg.getAtom(m).getLocation();
                    pretrf.transform(dap12);
                    dap12.y += onept * (double)r.y + 0.154;
                    dap12.x += onept * (double)r.x + 0.154;
                    MolPainter.addToBounds(dap12, xyminm, onept * (double)r.height, onept * (double)r.width);
                }
                continue;
            }
            dap1 = MolPainter.getParentDataLocation(dsg);
            if (dap1 == null) continue;
            pretrf.transform(dap1);
            MolPainter.addToBounds(dap1, xyminm, onept * (double)r.height, onept * (double)r.width);
        }
    }

    private static void addToBounds(DPoint3 q, double[] xyminm, double h, double w) {
        if (q.x < xyminm[0]) {
            xyminm[0] = q.x;
        }
        if (q.y < xyminm[1]) {
            xyminm[1] = q.y;
        }
        q.x += w;
        if (q.x > xyminm[2]) {
            xyminm[2] = q.x;
        }
        q.y += h;
        if (q.y > xyminm[3]) {
            xyminm[3] = q.y;
        }
    }

    private static void calcDocBounds(MDocument doc, double[] xyminm, CTransform3D pretrf, MoleculeGraph molg, MolPainterCommon common) {
        List<MObject> list = molg != null && molg instanceof MObjectContainer ? ((MObjectContainer)((Object)molg)).getAllObjects() : doc.getAllObjects();
        int n = list.size();
        for (int j = 0; j < n; ++j) {
            MObject mo = list.get(j);
            if (!MolPainter.isVisibleObject(common, mo, doc)) continue;
            mo.updateBoundingRect(xyminm, pretrf);
        }
    }

    public static boolean isVisibleObject(MolPainterCommon common, MObject mo, MDocument doc) {
        if (doc == null) {
            return true;
        }
        MoleculeGraph moleculeGraph = doc.getMainMoleculeGraph();
        if (doc.isExtraObject(mo) && moleculeGraph instanceof RgMolecule && !common.isRgDefinitionVisible()) {
            Molecule root = ((RgMolecule)moleculeGraph).getRoot();
            return root.getAllObjects().contains(mo);
        }
        return true;
    }

    private static boolean isAttachVisible(MolAtom a, MolPainterCommon common) {
        Molecule m;
        Sgroup sg;
        if (!common.areAttachmentPointsVisible()) {
            return false;
        }
        MoleculeGraph g = a.getParent();
        if (g != null && g instanceof Molecule && (sg = (m = (Molecule)g).findSmallestSgroupContaining(a)) != null) {
            for (int i = 0; i < a.getBondCount(); ++i) {
                MolAtom aa = a.getLigand(i);
                if (m.findSmallestSgroupContaining(aa) == sg) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bondLine(Graphics2D g, LinePainter lpainter, MoleculeGraph mol, MolBond b, int halves, AtomLabeller alabeller, MDocument doc, int index, Object[] objs) {
        MolPainterCommon molPainterCommon = this.common;
        synchronized (molPainterCommon) {
            DPoint3 p20;
            DPoint3 p10;
            DPoint3[] tmpPoints = this.common.tmpPoints;
            DPoint3 p1 = tmpPoints[0];
            DPoint3 p2 = tmpPoints[1];
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            int i1 = mol.indexOf(a1);
            int i2 = mol.indexOf(a2);
            int style = this.common.getRenderingStyle();
            int lab1 = 0;
            int lab2 = 0;
            if (i1 >= 0 && i2 >= 0 && style <= 262144) {
                p10 = this.screenCoords[i1];
                p20 = this.screenCoords[i2];
                lab1 = this.getLabelVisibility(a1, alabeller, p10, mol) & 1;
                lab2 = this.getLabelVisibility(a2, alabeller, p20, mol) & 1;
                FontMetrics fm = this.normalFontMetrics;
                if ((lab1 > 0 || lab2 > 0) && fm != null) {
                    DPoint3 p;
                    double dx = p20.x - p10.x;
                    double dy = p20.y - p10.y;
                    double dz = p20.z - p10.z;
                    double r = Math.sqrt(dx * dx + dy * dy);
                    int ascent = fm.getAscent();
                    double q = (double)ascent / (r * Math.sqrt(2.0));
                    if (q > 0.5) {
                        q = 0.5;
                    }
                    dx *= q;
                    dy *= q;
                    dz *= q;
                    if (lab1 > 0) {
                        p = tmpPoints[3];
                        p.x = p10.x + dx;
                        p.y = p10.y + dy;
                        p.z = p10.z + dz;
                        p10 = p;
                    }
                    if (lab2 > 0) {
                        p = tmpPoints[4];
                        p.x = p20.x - dx;
                        p.y = p20.y - dy;
                        p.z = p20.z - dz;
                        p20 = p;
                    }
                }
            } else {
                double dz;
                double dy;
                double dx;
                double r;
                p10 = a1.getLocation();
                p20 = a2.getLocation();
                if (style == 393216 && (r = Math.sqrt((dx = p20.x - p10.x) * dx + (dy = p20.y - p10.y) * dy + (dz = p20.z - p10.z) * dz)) > 0.0) {
                    double f = this.common.getBallRadius();
                    double rr = f * MolAtom.covalentRadiusOf(a1.getAtno(), 1);
                    p10.x += (dx /= r) * rr;
                    p10.y += (dy /= r) * rr;
                    p10.z += (dz /= r) * rr;
                    rr = f * MolAtom.covalentRadiusOf(a2.getAtno(), 1);
                    p20.x -= dx * rr;
                    p20.y -= dy * rr;
                    p20.z -= dz * rr;
                }
                this.calcGP(p10);
                this.calcGP(p20);
            }
            int[] types = new int[2];
            int n = 5;
            int flags = b.getFlags();
            if ((flags & 0x200) != 0) {
                DPoint3 p = tmpPoints[2];
                p.x = (p10.x + p20.x) / 2.0;
                p.y = (p10.y + p20.y) / 2.0;
                p.z = (p10.z + p20.z) / 2.0;
                int r = (int)(this.imageSize.scale * this.common.getBondSpacing() + 0.5);
                g.drawRect((int)(p.x - (double)r), (int)(p.y - (double)r), 2 * r, 2 * r);
            }
            if (a1.isLinkNode() && MolPainter.isOuterBondOfLinkNode(a1, a2)) {
                this.drawLinkNodeBracket(g, a1, p10, p20);
            }
            if (a2.isLinkNode() && MolPainter.isOuterBondOfLinkNode(a2, a1)) {
                this.drawLinkNodeBracket(g, a2, p20, p10);
            }
            switch (flags & 0xF) {
                case 5: {
                    types[0] = 1;
                    types[1] = 2;
                }
            }
            if (types[0] != 0) {
                double dx = (p20.x - p10.x) / (double)n;
                double dy = (p20.y - p10.y) / (double)n;
                double dz = (p20.z - p10.z) / (double)n;
                for (int i = 0; i < n; ++i) {
                    p1.x = p10.x + dx * (double)i;
                    p1.y = p10.y + dy * (double)i;
                    p1.z = p10.z + dz * (double)i;
                    p2.x = p1.x + dx;
                    p2.y = p1.y + dy;
                    p2.z = p1.z + dz;
                    this.bondLine(g, lpainter, mol, b, p1, lab1, p2, lab2, types[i & 1], halves, true, doc, objs, index, a1, a2, i1, i2);
                }
            } else {
                p1.x = p10.x;
                p1.y = p10.y;
                p1.z = p10.z;
                p2.x = p20.x;
                p2.y = p20.y;
                p2.z = p20.z;
                this.bondLine(g, lpainter, mol, b, p1, lab1, p2, lab2, flags, halves, false, doc, objs, index, a1, a2, i1, i2);
            }
        }
    }

    private Shape coverCrossingBonds(Graphics2D g, MoleculeGraph umol, Object[] objs, MolBond b, int i, MolAtom a1, MolAtom a2, int index1, int index2) {
        Area clip = null;
        Shape savedClip = null;
        int thickness = this.getLineThicknessAsInt();
        int w = 4 * thickness;
        for (int j = i + 1; j < objs.length; ++j) {
            DPoint3 p;
            MolBond bb;
            if (!(objs[j] instanceof MolBond) || (bb = (MolBond)objs[j]).getParent() != b.getParent() || (p = MolPainter.crossing(umol, bb, a1, a2, index1, index2, this.screenCoords)) == null) continue;
            if (bb.getType() == 3) {
                w = 7 * thickness;
            } else if (bb.getType() == 2) {
                w = 4 * thickness;
            } else if (bb.getType() == 1) {
                w = 2 * thickness;
            }
            DPoint3[] polylinePoints = DrawingUtil.getBondBounds(w, this.screenCoords[umol.indexOf(bb.getAtom1())], this.screenCoords[umol.indexOf(bb.getAtom2())]);
            GeneralPath polyline = new GeneralPath(0, polylinePoints.length);
            polyline.moveTo(Math.round(polylinePoints[0].x), Math.round(polylinePoints[0].y));
            polyline.quadTo(Math.round(polylinePoints[1].x), Math.round(polylinePoints[1].y), Math.round(polylinePoints[2].x), Math.round(polylinePoints[2].y));
            polyline.lineTo(Math.round(polylinePoints[3].x), Math.round(polylinePoints[3].y));
            polyline.quadTo(Math.round(polylinePoints[4].x), Math.round(polylinePoints[4].y), Math.round(polylinePoints[5].x), Math.round(polylinePoints[5].y));
            polyline.closePath();
            Area area = new Area(polyline);
            if (clip == null) {
                savedClip = g.getClip();
                clip = new Area(g.getClip());
            }
            clip.subtract(area);
        }
        if (clip != null) {
            g.setClip(clip);
        }
        return savedClip;
    }

    private DPoint3[][] getCoveringPolygons(MoleculeGraph umol, Object[] objs, MolBond b, int i, MolAtom a1, MolAtom a2, int index1, int index2) {
        ArrayList<DPoint3[]> polygonPoints = new ArrayList<DPoint3[]>();
        int thickness = this.getLineThicknessAsInt();
        int w = 4 * thickness;
        for (int j = i + 1; j < objs.length; ++j) {
            DPoint3 p;
            MolBond bb;
            if (!(objs[j] instanceof MolBond) || (bb = (MolBond)objs[j]).getParent() != b.getParent() || (p = MolPainter.crossing(umol, bb, a1, a2, index1, index2, this.screenCoords)) == null) continue;
            if (bb.getType() == 3) {
                w = 7 * thickness;
            } else if (bb.getType() == 2) {
                w = 4 * thickness;
            } else if (bb.getType() == 1) {
                w = 2 * thickness;
            }
            polygonPoints.add(DrawingUtil.getBondBounds(w, this.screenCoords[umol.indexOf(bb.getAtom1())], this.screenCoords[umol.indexOf(bb.getAtom2())]));
        }
        DPoint3[][] ppoints = new DPoint3[polygonPoints.size()][];
        polygonPoints.toArray((T[])ppoints);
        return ppoints;
    }

    private static String getSuperScript(Sgroup sg) {
        String superScript = sg.getSuperscript();
        if (sg.getChargeLocation() == 2 && sg.getTotalCharge() != 0) {
            superScript = superScript + LonePairPainter.getChargeString(sg.getTotalCharge());
        }
        if (sg instanceof RepeatingUnitSgroup) {
            RepeatingUnitSgroup rsg = (RepeatingUnitSgroup)sg;
            if (sg.getConnectivity() == 2 && !rsg.isFlipped() || sg.findCrossingBonds().length == 1) {
                return new String("");
            }
        }
        return superScript;
    }

    private DPoint3[] calcScriptPositions(Sgroup sg, Graphics2D g, DPoint3[] q) {
        DPoint3[] sc = null;
        if (sg != null) {
            Rectangle subScriptBounds = this.getTextBounds(g, DrawingUtil.removeCaret(sg.getSubscript()));
            Rectangle superScriptBounds = this.getTextBounds(g, MolPainter.getSuperScript(sg));
            sc = DrawingUtil.calcScriptPosition(subScriptBounds, superScriptBounds, q);
        }
        return sc;
    }

    private static final boolean isOuterBondOfLinkNode(MolAtom a1, MolAtom a2) {
        int outer1 = a1.getLinkNodeOuterAtom(0);
        int outer2 = a1.getLinkNodeOuterAtom(1);
        return outer1 != -1 && a1.getLigand(outer1) == a2 || outer2 != -1 && a1.getLigand(outer2) == a2;
    }

    private void drawLinkNodeBracket(Graphics2D g, MolAtom a, DPoint3 p1, DPoint3 p2) {
        double r;
        int max = a.getMaxRepetitions();
        if (max > 1 && (r = p1.distance(p2)) > 0.0) {
            double c = this.imageSize.scale * 1.54 / 4.0;
            double ex = (p1.x - p2.x) / r;
            double ey = (p1.y - p2.y) / r;
            double x0 = (2.0 * p1.x + p2.x) / 3.0;
            double y0 = (2.0 * p1.y + p2.y) / 3.0;
            double fx = -ey;
            double fy = ex;
            double dx = fx * c;
            double dy = fy * c;
            double x1 = x0 - dx;
            double y1 = y0 - dy;
            double x2 = x0 + dx;
            double y2 = y0 + dy;
            int[] x = new int[4];
            int[] y = new int[4];
            x[0] = (int)Math.round(x1 + (ex - fx) * c / 3.0);
            y[0] = (int)Math.round(y1 + (ey - fy) * c / 3.0);
            x[1] = (int)Math.round(x1);
            y[1] = (int)Math.round(y1);
            x[2] = (int)Math.round(x2);
            y[2] = (int)Math.round(y2);
            x[3] = (int)Math.round(x2 - (ey - fy) * c / 3.0);
            y[3] = (int)Math.round(y2 + (ex - fx) * c / 3.0);
            for (int i = 0; i < 3; ++i) {
                g.drawLine(x[i], y[i], x[i + 1], y[i + 1]);
            }
        }
    }

    private void bondLine(Graphics2D g, LinePainter lpainter, MoleculeGraph mol, MolBond b, DPoint3 p1, int lab1, DPoint3 p2, int lab2, int flags, int halves, boolean chain, MDocument doc, Object[] objs, int index, MolAtom a1, MolAtom a2, int index1, int index2) {
        boolean near1;
        Shades shades;
        int dispopts = this.common.getDispopts();
        int style = dispopts & 0xE0000;
        int t = flags & 0xF;
        int stereo1 = flags & 0x30;
        int stereo2 = flags & 0x1C0;
        int setNo = b.getSetSeq();
        double oldThickness = this.common.getWireThickness();
        double oldlpThickness = this.getLineThickness();
        if (doc != null && doc.getBondSetThickness(setNo) != 0.0) {
            double thickness = doc.getBondSetThickness(setNo);
            this.common.setWireThickness(thickness);
            lpainter.setLineThickness(this.getLineThickness());
        }
        if (halves == 3) {
            shades = this.getShades(b, doc);
            if (p2.z < p1.z) {
                near1 = a1.getBondCount() == 1;
            } else {
                boolean bl = near1 = a2.getBondCount() == 1;
            }
            if (a1.getAtno() == 137) {
                p1 = a1.getLocation();
                this.calcGP(p1);
            }
            if (a2.getAtno() == 137) {
                p2 = a2.getLocation();
                this.calcGP(p2);
            }
        } else if (halves < 3) {
            double x = (p1.x + p2.x) / 2.0;
            double y = (p1.y + p2.y) / 2.0;
            double z = (p1.z + p2.z) / 2.0;
            if (halves == 1) {
                near1 = p2.z < p1.z && a1.getBondCount() == 1;
                p2.x = x;
                p2.y = y;
                p2.z = z;
                shades = this.getShades(a1, doc);
                if (a1.getAtno() == 137) {
                    p1 = a1.getLocation();
                    this.calcGP(p1);
                }
            } else {
                near1 = p1.z < p2.z && a2.getBondCount() == 1;
                p1.x = x;
                p1.y = y;
                p1.z = z;
                shades = this.getShades(a2, doc);
                if (a2.getAtno() == 137) {
                    p2 = a2.getLocation();
                    this.calcGP(p2);
                }
            }
        } else {
            shades = null;
            near1 = false;
        }
        if (t == 0 && this.anyBondIsSolidLine) {
            t = 1;
        }
        Shape savedClip = null;
        if (objs != null && style <= 131072 && mol.getBondCount() < 300 && this.isClipping) {
            savedClip = this.coverCrossingBonds(g, mol, objs, b, index, a1, a2, index1, index2);
        }
        DPoint3[][] cpoints = this.isClipping || objs == null ? (DPoint3[][])null : this.getCoveringPolygons(mol, objs, b, index, a1, a2, index1, index2);
        boolean front = t < 1 || t > 3 || style == 262144 && near1;
        int aromdash = -1;
        int sidedness = 0;
        switch (t) {
            case 2: {
                int[][] sssrIdx;
                int[][] sssr;
                AromatiCalc ac;
                if (chain || stereo2 == 192 || style > 131072 || (sidedness = (ac = new AromatiCalc(this.screenCoords, mol)).calcDoubleBondSidedness(b, a1, a2, p1, p2, lab1, lab2, sssr = mol.getSSSR(), sssrIdx = mol.getSSSRIdxesForAtoms())) == 0) break;
                aromdash = Integer.MAX_VALUE;
                break;
            }
            case 1: {
                if (b.isHashed()) {
                    lpainter.paintBondHashed(g, shades, front, this.imageSize.scale * this.common.getBondSpacing(), p1, p2);
                    break;
                }
                if (stereo1 != 0 || b.isBold()) break;
                lpainter.drawLine(g, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, shades, front, cpoints);
                break;
            }
            case 3: {
                if (stereo1 != 0 || style <= 131072) break;
                lpainter.drawLine(g, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, shades, front);
                break;
            }
            case 0: {
                lpainter.dashedLine(p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, 4, 0, g, shades);
                break;
            }
            case 9: {
                if (a1.getAtno() == 137 || a2.getAtno() == 137) {
                    if (this.common.getCoordinateBondStyleAtMulticenter() == "hashed") {
                        lpainter.paintBondHashed(g, shades, front, this.imageSize.scale * this.common.getBondSpacing(), p1, p2);
                        break;
                    }
                    lpainter.drawLine(g, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, shades, front, cpoints);
                    break;
                }
                if (this.common.getCoordinateBondStyle() == "arrow") {
                    lpainter.drawArrow(g, p1, p2, true, 0, cpoints);
                    this.common.setAntialiasing(g, true);
                    break;
                }
                lpainter.drawLine(g, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, shades, front, cpoints);
                break;
            }
            case 4: {
                aromdash = 3;
                if (b.isBold()) {
                    aromdash = 4;
                }
            }
            case 6: {
                if (aromdash == -1) {
                    aromdash = 1;
                }
            }
            case 7: {
                ArrayList<Integer> rings;
                if (aromdash == -1) {
                    aromdash = 4;
                }
                AromatiCalc ac = new AromatiCalc(this.screenCoords, mol);
                int idx = mol.indexOf(b);
                int ringtodraw = -1;
                boolean dashtodraw = true;
                int[][] sssr = mol.getSSSR();
                int[][] sssrIdx = mol.getSSSRIdxesForAtoms();
                if (mol.isRingBond(idx) && (rings = ac.getRingsContainingBond(b, sssrIdx)).size() > 0) {
                    boolean[] ringColors;
                    double[] ringCoords;
                    ArrayList<ArrayList<Integer>> aromrings = ac.getAromaticRings(rings, sssr);
                    if (aromrings.size() > 0) {
                        ringCoords = new double[6];
                        ringColors = new boolean[4];
                        ringtodraw = ac.calculateRingCoords(b, a2, aromrings.get(0), ringCoords, ringColors, this.ringBondIndexes, this.imageSize.scale, this.imageSize.scale * this.common.getBondSpacing() / 2.0);
                        if (ringtodraw > 0) {
                            lpainter.drawAromaticRing(g, doc, b, a2, ringCoords, ringColors);
                        }
                        boolean bl = dashtodraw = ringtodraw < 0;
                    }
                    if (aromrings.size() > 1) {
                        ringCoords = new double[6];
                        ringColors = new boolean[4];
                        ringtodraw = ac.calculateRingCoords(b, a2, aromrings.get(1), ringCoords, ringColors, this.ringBondIndexes, this.imageSize.scale, this.imageSize.scale * this.common.getBondSpacing() / 2.0);
                        if (ringtodraw > 0) {
                            lpainter.drawAromaticRing(g, doc, b, a2, ringCoords, ringColors);
                        }
                        dashtodraw &= ringtodraw < 0;
                    }
                }
                if (dashtodraw) {
                    sidedness = ac.calcAromaticBondSidedness(b, a1, a2, p1, p2, sssr, sssrIdx);
                }
                if (b.isBold() || stereo1 != 0) break;
                lpainter.drawLine(g, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, shades, front);
            }
        }
        int rcFlag = flags & 0xF000;
        if (rcFlag > 0) {
            lpainter.drawReactingCenter(g, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, shades, front, rcFlag);
        }
        if (t == 0 || t >= 2 && t <= 7 || t == 1 && (stereo1 != 0 || b.isBold())) {
            double x12 = 0.0;
            int x12i = (int)(Math.round(p2.x) - Math.round(p1.x));
            if (x12i != 0) {
                x12 = p2.x - p1.x;
            }
            double y12 = p2.y - p1.y;
            double r12 = Math.sqrt(x12 * x12 + y12 * y12);
            double ex = 0.0;
            double ey = 0.0;
            if (r12 != 0.0) {
                ex = x12 / r12;
                ey = y12 / r12;
            }
            if (t != 0) {
                double d = this.imageSize.scale * this.common.getBondSpacing();
                if (t == 2 && !b.isBold() && stereo1 == 0) {
                    if (aromdash < 0) {
                        d *= 0.3333333333333333;
                    }
                } else if (!(t != 1 && t != 2 && t != 4 || stereo1 == 0 && !b.isBold() || this.common.isOnButton())) {
                    d = this.imageSize.scale * this.common.getWireThickness() * 1.25;
                }
                double dx = d * ey;
                double dy = -d * ex;
                double x1p = p1.x + dx;
                double y1p = p1.y + dy;
                double x1m = p1.x - dx;
                double y1m = p1.y - dy;
                double x2p = p2.x + dx;
                double y2p = p2.y + dy;
                double x2m = p2.x - dx;
                double y2m = p2.y - dy;
                if (b.isBold()) {
                    lpainter.paintBoldBond(g, mol, b, a1, a2, p1, p2, lab1, lab2, this.screenCoords, x1p, y1p, x1m, y1m, x2p, y2p, x2m, y2m, ex, ey, d);
                } else if (stereo1 == 16) {
                    lpainter.paintBondUp(g, mol, b, a1, a2, p1, p2, lab1, lab2, this.screenCoords, x1p, y1p, x1m, y1m, x2p, y2p, x2m, y2m, ex, ey, d);
                }
                if (aromdash >= 1) {
                    double d2;
                    double d1;
                    d = this.imageSize.scale * this.common.getBondSpacing();
                    AromatiCalc ac = new AromatiCalc(this.screenCoords, mol);
                    if (sidedness == 1) {
                        d1 = 0.0;
                        d2 = 0.0;
                        if ((halves & 1) == 1 && lab1 == 0) {
                            d1 = d * ac.calcLineEnd(b, a1, 1.0);
                        }
                        if ((halves & 2) == 2 && lab2 == 0) {
                            d2 = d * ac.calcLineEnd(b, a2, -1.0);
                        }
                        if (Double.isNaN(ex)) {
                            ex = x12 / Math.sqrt(x12 * x12 + y12 * y12);
                        }
                        if (Double.isNaN(ey)) {
                            ey = y12 / Math.sqrt(x12 * x12 + y12 * y12);
                        }
                        double ax1p = x1p + d1 * ex;
                        double ay1p = y1p + d1 * ey;
                        double ax2p = x2p - d2 * ex;
                        double ay2p = y2p - d2 * ey;
                        dx = (d - this.getLineThickness()) * ey;
                        dy = -(d - this.getLineThickness()) * ex;
                        if (t == 2 && !b.isBold() && stereo1 == 0) {
                            lpainter.draw2Lines(g, p1.x, p1.y, p2.x, p2.y, ax1p, ay1p, ax2p, ay2p, this.getLineThickness(), cpoints);
                        } else if (!b.isBold() && stereo1 == 0) {
                            lpainter.dashedLine(ax1p, ay1p, 0.0, ax2p, ay2p, 0.0, 7, aromdash, g, shades);
                        } else if (t == 2 && (b.isBold() || stereo1 != 0)) {
                            lpainter.drawLine(g, ax1p + dx, ay1p + dy, ax2p + dx, ay2p + dy, this.getLineThickness());
                        } else if (t == 4 && (b.isBold() || stereo1 != 0)) {
                            lpainter.dashedLine(ax1p + dx, ay1p + dy, 0.0, ax2p + dx, ay2p + dy, 0.0, 7, aromdash, g, shades, false);
                        }
                        if (a1.getBondCount() == 1 && this.atomCoordsOffVect != null && this.atomCoordsOffVect.length > index1 && index1 > -1) {
                            this.atomCoordsOffVect[index1][0] = (ax1p - p1.x) / 2.0;
                            this.atomCoordsOffVect[index1][1] = (ay1p - p1.y) / 2.0;
                        } else if (a2.getBondCount() == 1 && this.atomCoordsOffVect != null && this.atomCoordsOffVect.length > index2 && index2 > -1) {
                            this.atomCoordsOffVect[index2][0] = (ax2p - p2.x) / 2.0;
                            this.atomCoordsOffVect[index2][1] = (ay2p - p2.y) / 2.0;
                        }
                    }
                    if (sidedness == -1) {
                        d1 = 0.0;
                        d2 = 0.0;
                        if ((halves & 1) == 1 && lab1 == 0) {
                            d1 = d * ac.calcLineEnd(b, a1, -1.0);
                        }
                        if ((halves & 2) == 2 && lab2 == 0) {
                            d2 = d * ac.calcLineEnd(b, a2, 1.0);
                        }
                        if (Double.isNaN(ex)) {
                            ex = x12 / Math.sqrt(x12 * x12 + y12 * y12);
                        }
                        if (Double.isNaN(ey)) {
                            ey = y12 / Math.sqrt(x12 * x12 + y12 * y12);
                        }
                        double ax1m = x1m + d1 * ex;
                        double ay1m = y1m + d1 * ey;
                        double ax2m = x2m - d2 * ex;
                        double ay2m = y2m - d2 * ey;
                        dx = (d - this.getLineThickness()) * ey;
                        dy = -(d - this.getLineThickness()) * ex;
                        if (t == 2 && !b.isBold() && stereo1 == 0) {
                            lpainter.draw2Lines(g, p1.x, p1.y, p2.x, p2.y, ax1m, ay1m, ax2m, ay2m, this.getLineThickness(), cpoints);
                        } else if (!b.isBold() && stereo1 == 0) {
                            lpainter.dashedLine(ax1m, ay1m, 0.0, ax2m, ay2m, 0.0, 7, aromdash, g, shades);
                        } else if (t == 2 && (b.isBold() || stereo1 != 0)) {
                            lpainter.drawLine(g, ax1m - dx, ay1m - dy, ax2m - dx, ay2m - dy, this.getLineThickness());
                        } else if (t == 4 && (b.isBold() || stereo1 != 0)) {
                            lpainter.dashedLine(ax1m - dx, ay1m - dy, 0.0, ax2m - dx, ay2m - dy, 0.0, 7, aromdash, g, shades, false);
                        }
                        if (a1.getBondCount() == 1 && this.atomCoordsOffVect != null && this.atomCoordsOffVect.length > index1 && index1 > -1) {
                            this.atomCoordsOffVect[index1][0] = (ax1m - p1.x) / 2.0;
                            this.atomCoordsOffVect[index1][1] = (ay1m - p1.y) / 2.0;
                        } else if (a2.getBondCount() == 1 && this.atomCoordsOffVect != null && this.atomCoordsOffVect.length > index2 && index2 > -1) {
                            this.atomCoordsOffVect[index2][0] = (ax2m - p2.x) / 2.0;
                            this.atomCoordsOffVect[index2][1] = (ay2m - p2.y) / 2.0;
                        }
                    }
                } else if (stereo2 == 192) {
                    lpainter.drawLine(g, x1p, y1p, 0.0, x2m, y2m, 0.0, shades, front);
                    lpainter.drawLine(g, x1m, y1m, 0.0, x2p, y2p, 0.0, shades, front);
                } else if (stereo1 == 32) {
                    lpainter.paintBondDown(g, lpainter, shades, front, halves, (dispopts & 0x100000) != 0, p1, x12, y12, r12, dx, dy);
                } else if (stereo1 == 48) {
                    lpainter.paintBondEither(g, lpainter, shades, front, halves, p1, d, x12, y12, r12, dx, dy);
                } else if (!b.isBold() && stereo1 == 0) {
                    if (style <= 131072) {
                        lpainter.draw2or3Line(g, p1.x, p1.y, p2.x, p2.y, this.imageSize.scale * this.common.getBondSpacing(), this.getLineThickness(), t, cpoints);
                    } else {
                        if (halves < 3) {
                            x1p = p1.x + dx;
                            y1p = p1.y + dy;
                            x1m = p1.x - dx;
                            y1m = p1.y - dy;
                            x2p = p2.x + dx;
                            y2p = p2.y + dy;
                            x2m = p2.x - dx;
                            y2m = p2.y - dy;
                        }
                        lpainter.drawLine(g, x1p, y1p, 0.0, x2p, y2p, 0.0, shades, front);
                        lpainter.drawLine(g, x1m, y1m, 0.0, x2m, y2m, 0.0, shades, front);
                    }
                }
            }
        }
        if (savedClip != null) {
            g.setClip(savedClip);
        }
        this.common.setWireThickness(oldThickness);
        lpainter.setLineThickness(oldlpThickness);
    }

    private void paintAtom(Graphics2D g, LinePainter lpainter, MolAtom a, MoleculeGraph umol, MoleculeGraph molg, RgMoleculeGraphIface rgmol, boolean[][] showChiral, AtomLabeller alabeller, List<MolAtom> attachpts, double[] bwght, MDocument doc) {
        boolean showRadical;
        Image img;
        boolean hydrit;
        a.storeTemporaryObject("negativeChargeCoords", null);
        int dispopts = this.common.getDispopts();
        boolean showRS = this.imageSize.scale >= 5.0 && this.checkShowRS(a, umol, molg, rgmol, showChiral);
        int atomIndex = umol.indexOf(a);
        DPoint3 p = this.screenCoords[atomIndex];
        int intpx = (int)Math.round(p.x);
        int intpy = (int)Math.round(p.y);
        if (intpx < this.atomMinx) {
            this.atomMinx = intpx;
        }
        if (intpy < this.atomMiny) {
            this.atomMiny = intpy;
        }
        if (a.getAttach() != 0 && MolPainter.isAttachVisible(a, this.common)) {
            attachpts.add(a);
        }
        int style = this.common.getRenderingStyle();
        int ballR = 0;
        int labelit = this.getLabelVisibility(a, alabeller, p, umol);
        boolean bl = hydrit = (labelit & 4) != 0;
        if ((style == 393216 || style == 524288) && (img = this.getBallImage(a, molg, this.imageSize.scale / 1.54)) != null) {
            double covr = MolAtom.covalentRadiusOf(a.getAtno(), 1);
            double r = covr * this.imageSize.scale / 1.54;
            if (style == 393216) {
                r *= this.common.getBallRadius();
            }
            ballR = (int)Math.round(r);
            int w = (int)(2.0 * r + 0.5);
            int x = (int)Math.round(p.x - r);
            int y = (int)Math.round(p.y - r);
            g.drawImage(img, x, y, w, w, null);
            if (x < this.atomMinx) {
                this.atomMinx = x;
            }
            if (y < this.atomMiny) {
                this.atomMiny = y;
            }
        }
        boolean showLonePairs = a.getElectronProp() != 0 && a.getElectronProp() > -3;
        boolean bl2 = showRadical = a.getRadical() > 0;
        if ((labelit != 0 || showRS && atomIndex >= 0 || showLonePairs || showRadical) && this.normalFontMetrics != null) {
            int rs;
            int[] lcenter = new int[7];
            StringBuffer sym = new StringBuffer();
            String lab = "";
            int lp = 0;
            boolean lppaint = (dispopts & 0x1000000) != 0;
            boolean autocalc = (dispopts & 0x8000000) != 0;
            lp = autocalc && lppaint ? molg.getLonePairCount(atomIndex) : a.getElectronProp();
            if (lp == -1) {
                lp = 1;
            } else if (lp == -2 || lp == -3 || lp == -4) {
                lp = 0;
            }
            if (a.getRadical() != 0) {
                if (!lppaint) {
                    lp = 0;
                }
                lppaint = true;
            }
            if ((labelit & 1) != 0) {
                lcenter[5] = -1;
                int aamap = a.getAtomMap();
                int atno = a.getAtno();
                if (atno == 209 || atno == 210) {
                    sym.append(aamap == 0 ? "Unmap" : "Map:" + aamap);
                    labelit = 1;
                } else {
                    String s = MolPainter.getAtomSymbol(a, hydrit, lppaint, lcenter, this.preTransform);
                    if (lcenter[0] <= 0 && lcenter[1] <= 0) {
                        MolPainter.findAtomSymbol(a, s, lcenter, this.preTransform);
                    }
                    if (style <= 262144 || !s.equals("H") || a.isSelected()) {
                        sym.append(s);
                    }
                }
            }
            if ((labelit & 2) != 0) {
                lab = alabeller.getLabels(a, atomIndex);
            }
            if (showRS && (rs = umol.getChirality(atomIndex)) != 0) {
                MolPainter.appendRS(sym, rs, lcenter);
            }
            boolean chargePainted = false;
            if (sym.length() != 0 || lab.length() != 0) {
                this.paintAtomLabel(g, lpainter, a, atomIndex, sym.toString(), lab, p, lcenter, bwght, ballR, style, doc);
                boolean bl3 = chargePainted = LonePairPainter.getEFlowFrom(a) == null || LonePairPainter.getEFlowFrom(a).getNumElectrons() != 2 || !LonePairPainter.isChargeVisible(a) || a.getCharge() >= 0;
            }
            if (lppaint) {
                Color color = this.getColor(a, doc);
                GraphicsUtil.setColor(g, color, this.getBackground(), this.screenCoords[atomIndex].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
                this.paintLonePairs(g, a, atomIndex, lp, hydrit);
                chargePainted = true;
            } else {
                a.storeTemporaryObject("lonePairCoords", null);
                a.storeTemporaryObject("radicalCoords", null);
            }
            if (!chargePainted) {
                if (this.atomCoordsOffVect != null && this.atomCoordsOffVect.length > atomIndex && atomIndex > -1) {
                    LonePairPainter.paintCharge(g, a, 0.4 * this.mag0 * 1.54, this.transformMatrix, this.smallFont, this.atomCoordsOffVect[atomIndex]);
                } else {
                    LonePairPainter.paintCharge(g, a, 0.4 * this.mag0 * 1.54, this.transformMatrix, this.smallFont, new double[2]);
                }
            }
        } else {
            if (style == 131072) {
                Color color = this.getColor(a, doc);
                GraphicsUtil.setColor(g, color, this.getBackground(), this.screenCoords[atomIndex].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
                int w = this.getLineThicknessAsInt();
                g.fillRect((int)Math.round(p.x - (double)w), (int)Math.round(p.y - (double)w), 2 * w + 1, 2 * w + 1);
            }
            a.setCorners(0.0, 0.0, 0.0, 0.0);
            if (this.atomCoordsOffVect != null && this.atomCoordsOffVect.length > atomIndex && atomIndex > -1) {
                LonePairPainter.paintCharge(g, a, 0.4 * this.mag0 * 1.54, this.transformMatrix, this.smallFont, this.atomCoordsOffVect[atomIndex]);
            } else {
                LonePairPainter.paintCharge(g, a, 0.4 * this.mag0 * 1.54, this.transformMatrix, this.smallFont, new double[2]);
            }
            a.storeTemporaryObject("lonePairCoords", null);
            a.storeTemporaryObject("radicalCoords", null);
        }
    }

    private static void appendRS(StringBuffer sym, int rs, int[] lcenter) {
        String unspec;
        String string = unspec = (rs & 4) == 4 ? "?" : "";
        String s = (rs & 8) == 8 ? "\\italic{(R" + unspec + ")}" : ((rs & 0x10) == 16 ? "\\italic{(S" + unspec + ")}" : ((rs & 0x20) == 32 ? "\\italic{(r" + unspec + ")}" : ((rs & 0x40) == 64 ? "\\italic{(s" + unspec + ")}" : ((rs & 0x100) == 256 ? "\\italic{(M" + unspec + ")}" : ((rs & 0x80) == 128 ? "\\italic{(P" + unspec + ")}" : "")))));
        if (sym.length() == 0 && s.length() != 0) {
            lcenter[1] = 3;
        }
        sym.append(s);
    }

    private boolean checkShowRS(MolAtom a, MoleculeGraph umol, MoleculeGraph molg, RgMoleculeGraphIface rgmol, boolean[][] showChiral) {
        int dispopts = this.common.getDispopts();
        int chiralitySupport = (dispopts & 0xC000) >> 14;
        boolean showRS = false;
        if (rgmol != null && rgmol.getRgroupCount() > 0) {
            if (molg.indexOf(a) >= 0) {
                if (rgmol.getRootG().isAbsStereo()) {
                    showRS = true;
                }
            } else {
                int mindex;
                int rgindex;
                long id = rgmol.getRgroupMemberID(a);
                if (id != -1L && showChiral[rgindex = rgmol.getRgroupIndex(id)][mindex = rgmol.getRgroupMemberIndex(id)]) {
                    showRS = true;
                }
            }
            showRS = showRS && (chiralitySupport == 2 || chiralitySupport == 1);
        } else {
            showRS = chiralitySupport == 2 || chiralitySupport == 1 && (umol.isAbsStereo() || a.getStereoGroupType() == 1);
        }
        return showRS;
    }

    private void paintAtomLabel(Graphics2D g, LinePainter lpainter, MolAtom a, int atom_index, String sym, String lab, DPoint3 p, int[] lcenter, double[] bwght, int ballR, int style, MDocument doc) {
        boolean valenceerr;
        ColorCollection colors = this.getColors();
        TextGraphics symtxt = new TextGraphics(sym, lcenter);
        Font oldNormal = this.normalFont;
        Font oldItalic = this.italicFont;
        Font oldSmall = this.smallFont;
        Font oldLabel = this.labelFont;
        Font newFont = this.common.getAtomSetFont(a.getSetSeq(), doc);
        if (newFont != null) {
            double newSize = newFont.getSize() * (int)(this.imageSize.scale * 0.4 + 0.5) / 12;
            this.normalFont = FontMaker.makeFont(newFont.getStyle(), (int)newSize, newFont);
            this.italicFont = FontMaker.makeFont(2, (int)newSize, newFont);
            this.smallFont = FontMaker.makeFont(newFont.getStyle(), (int)(newSize / 1.3), newFont);
            this.labelFont = FontMaker.makeFont(newFont.getStyle(), (int)(newSize / 1.3), newFont);
        }
        int dispopts = this.common.getDispopts();
        FontMetrics fontm = MolPainter.getFontMetrics(this.normalFont, g);
        FontMetrics ifontm = MolPainter.getFontMetrics(this.italicFont, g);
        FontMetrics sfontm = MolPainter.getFontMetrics(this.smallFont, g);
        FontMetrics lfontm = MolPainter.getFontMetrics(this.labelFont, g);
        boolean hasRightNameLabel = a instanceof SgroupAtom && ((SgroupAtom)a).hasAlternativeName() && ((SgroupAtom)a).getRightName() != null;
        int symdim = symtxt.draw(0, 0, 0, null, this.normalFont, fontm, this.italicFont, ifontm, this.smallFont, sfontm, lcenter, hasRightNameLabel, null, null);
        int labdim = 0;
        int caldim_1 = 0;
        int caldim_2 = 0;
        int caldim_3 = 0;
        TextGraphics labtxt = null;
        TextGraphics labcoretxt = null;
        TextGraphics caltxt1 = null;
        TextGraphics caltxt2 = null;
        TextGraphics caltxt3 = null;
        if (!lab.equals("")) {
            labcoretxt = labtxt = new TextGraphics(lab, null);
            labdim = labtxt.draw(0, 0, 0, null, this.normalFont, fontm, this.italicFont, ifontm, this.labelFont, lfontm, null, null);
            String extraLabel = a.getExtraLabel();
            if (extraLabel != null && !extraLabel.equals("")) {
                labcoretxt = new TextGraphics(lab.substring(0, lab.indexOf(extraLabel)) + "}", null);
                if (extraLabel.indexOf("|") == -1) {
                    caltxt1 = new TextGraphics("_{" + extraLabel + "}", null);
                    caldim_1 = caltxt1.draw(0, 0, 0, null, this.normalFont, fontm, this.italicFont, ifontm, this.labelFont, lfontm, null, null);
                } else {
                    int idx = extraLabel.indexOf("|");
                    caltxt1 = new TextGraphics("_{" + extraLabel.substring(0, idx) + "}", null);
                    caldim_1 = caltxt1.draw(0, 0, 0, null, this.normalFont, fontm, this.italicFont, ifontm, this.labelFont, lfontm, null, null);
                    caltxt2 = new TextGraphics("_{,}", null);
                    caldim_2 = caltxt2.draw(0, 0, 0, null, this.normalFont, fontm, this.italicFont, ifontm, this.labelFont, lfontm, null, null);
                    caltxt3 = new TextGraphics("_{" + extraLabel.substring(idx + 1) + "}", null);
                    caldim_3 = caltxt3.draw(0, 0, 0, null, this.normalFont, fontm, this.italicFont, ifontm, this.labelFont, lfontm, null, null);
                }
            }
        }
        int wsym = symdim & 0xFFFF;
        int symdy = symdim >> 16;
        int ascent = fontm.getAscent();
        int descent = fontm.getDescent();
        int h = ascent + descent;
        int vertdir = lcenter[2];
        if (style <= 262144) {
            MolPainter.bondweights(a, bwght, sym, this.preTransform);
        }
        int xl = (int)Math.round(p.x);
        int yl = (int)Math.round(p.y);
        if (sym.length() > 0) {
            if (lcenter[5] >= 0 && lcenter[6] > 0 && sym.charAt(0) != '[') {
                SgroupAtom sa = null;
                int k = 0;
                if (a instanceof SgroupAtom) {
                    sa = (SgroupAtom)a;
                    k = sa.getLabelCenter();
                }
                xl = sa != null && k == 0 && !sa.hasAlternativeName() ? (int)Math.round(p.x - (double)wsym * 0.5) : (int)Math.round(p.x - 0.5 * (double)(2 * lcenter[5] + lcenter[6]));
            } else {
                xl = (int)Math.round(p.x - 0.5 * (double)wsym * (bwght[0] + 1.0));
            }
        }
        int n = yl = os.equals("Linux") ? (int)Math.round(p.y + 0.225 * (double)fontm.getMaxAdvance()) : (int)Math.round(p.y + 0.3 * (double)fontm.getHeight());
        if (vertdir > 0) {
            yl -= symdy;
        } else if (vertdir == 0) {
            yl -= symdy / 2;
        }
        if (this.atomCoordsOffVect != null && this.atomCoordsOffVect.length > atom_index && atom_index > -1) {
            xl += (int)Math.round(this.atomCoordsOffVect[atom_index][0]);
            yl += (int)Math.round(this.atomCoordsOffVect[atom_index][1]);
        }
        boolean selected = a.isSelected();
        boolean bl = valenceerr = (this.common.isValenceErrorVisible() && this.common.isErrorVisible() || this.common.isValenceErrorVisibleInView()) && a.hasValenceError();
        Color color = selected ? (valenceerr ? Color.red : colors.getSelectionColor()) : colors.getBackground();
        GraphicsUtil.setColor(g, color, this.getBackground(), this.screenCoords[atom_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
        DPoint3 nw = this.calcMolP(xl, yl - ascent);
        DPoint3 se = this.calcMolP(xl + wsym, yl + descent);
        this.preTransform.transform(nw);
        this.preTransform.transform(se);
        a.setCorners(nw.x, nw.y, se.x, se.y);
        if (style <= 262144 && a.getBondCount() != 0 && !sym.equals("") || selected) {
            MDocument.CheckerMark[] marks;
            Molecule mol;
            Sgroup sg;
            if (wsym < (h += symdy) / 2) {
                wsym = h / 2;
            }
            MoleculeGraph molg = doc == null ? null : doc.getMainMoleculeGraph();
            int cmd = selected ? 3 : 2;
            boolean toClear = true;
            if (!selected && a.getAtno() == 138 && a.getRgroupAttachmentPointOrder() > 0) {
                toClear = false;
            }
            if (!selected && molg != null && molg instanceof Molecule && (sg = (mol = (Molecule)molg).findSmallestSgroupContaining(a)) != null && sg.getType() == 14) {
                toClear = false;
            }
            if (doc != null && (marks = doc.getCheckerMarks()) != null) {
                for (int i = 0; i < marks.length && toClear; ++i) {
                    MolBond[] bonds;
                    MolAtom[] atoms = marks[i].getAtoms();
                    if (atoms != null) {
                        for (int j = 0; j < atoms.length && toClear; ++j) {
                            if (a != molg.findAtomClone(atoms[j])) continue;
                            toClear = false;
                        }
                    }
                    if (!toClear || (bonds = marks[i].getBonds()) == null) continue;
                    for (int j = 0; j < bonds.length && toClear; ++j) {
                        MolBond bond = bonds[j];
                        if (a != molg.findAtomClone(bond.getAtom1()) && a != molg.findAtomClone(bond.getAtom2())) continue;
                        toClear = false;
                    }
                }
            }
            if (toClear) {
                symtxt.draw(cmd, xl, yl, g, this.normalFont, fontm, this.italicFont, ifontm, this.smallFont, sfontm, lcenter, hasRightNameLabel, this.coveringLabels, this.isTransparent || !this.isClipping ? null : this.getBackground());
            }
        }
        color = colors.getForeground();
        if (!selected && style <= 262144) {
            color = this.getColor(a, doc);
        }
        if ((dispopts & 0x40000000) != 0) {
            color = GraphicsUtil.applyFog(color, this.getBackground(), 0.5);
        }
        GraphicsUtil.setColor(g, color, this.getBackground(), this.screenCoords[atom_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
        symtxt.draw(1, xl, yl, g, this.normalFont, fontm, this.italicFont, ifontm, this.smallFont, sfontm, lcenter, hasRightNameLabel, null, this.getBackground());
        if (labtxt != null) {
            GraphicsUtil.setColor(g, colors.getForeground(), this.getBackground(), this.screenCoords[atom_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
            int[] dims = new int[]{labdim, 0};
            Point elp = MolPainter.getLabelsP(a, xl, yl, wsym, dims, null, lcenter, sfontm, fontm, ballR);
            GraphicsUtil.setColor(g, colors.getExtraLabelColor(), this.getBackground(), this.screenCoords[atom_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
            labcoretxt.draw(1, elp.x, elp.y, g, this.normalFont, fontm, this.italicFont, ifontm, this.labelFont, lfontm, null, this.getBackground());
            if (caltxt1 != null) {
                Color c = a.getExtraLabelColor(0) == 0 ? colors.getForeground() : new Color(a.getExtraLabelColor(0));
                GraphicsUtil.setColor(g, c, this.getBackground(), this.screenCoords[atom_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
                caltxt1.draw(1, elp.x + labdim - (caldim_1 + caldim_2 + caldim_3), elp.y, g, this.normalFont, fontm, this.italicFont, ifontm, this.labelFont, lfontm, null, this.getBackground());
                if (caltxt2 != null) {
                    GraphicsUtil.setColor(g, color, this.getBackground(), this.screenCoords[atom_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
                    caltxt2.draw(1, elp.x + labdim - (caldim_2 + caldim_3), elp.y, g, this.normalFont, fontm, this.italicFont, ifontm, this.labelFont, lfontm, null, this.getBackground());
                    c = a.getExtraLabelColor(1) == 0 ? colors.getForeground() : new Color(a.getExtraLabelColor(1));
                    GraphicsUtil.setColor(g, c, this.getBackground(), this.screenCoords[atom_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
                    caltxt3.draw(1, elp.x + labdim - caldim_3, elp.y, g, this.normalFont, fontm, this.italicFont, ifontm, this.labelFont, lfontm, null, this.getBackground());
                }
            }
            g.setColor(color);
        }
        if (xl < this.atomMinx) {
            this.atomMinx = xl;
        }
        if (yl - ascent < this.atomMiny) {
            this.atomMiny = yl - ascent;
        }
        if (valenceerr && !selected) {
            GraphicsUtil.setColor(g, Color.red, this.getBackground(), this.screenCoords[atom_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
            lpainter.drawLine(g, xl, yl + 1, 0.0, xl + wsym, yl + 1, 0.0, null, false);
        }
        this.normalFont = oldNormal;
        this.italicFont = oldItalic;
        this.smallFont = oldSmall;
        this.labelFont = oldLabel;
    }

    private void paintLonePairs(Graphics2D g, MolAtom a, int atomIndex, int lp, boolean implh) {
        MarvinModule mm = (MarvinModule)MarvinModule.load("LonePairPainter", null);
        Object[] args = this.atomCoordsOffVect != null && this.atomCoordsOffVect.length > atomIndex && atomIndex > -1 ? new Object[]{g, this.preTransform, this.transformMatrix, a, new Double(0.4 * this.mag0 * 1.54), new Integer(lp), new Boolean(implh), this.smallFont, this.atomCoordsOffVect[atomIndex]} : new Object[]{g, this.preTransform, this.transformMatrix, a, new Double(0.4 * this.mag0 * 1.54), new Integer(lp), new Boolean(implh), this.smallFont, new double[2]};
        mm.modfunc(args);
    }

    private int getLabelVisibility(MolAtom a, AtomLabeller alabeller, DPoint3 p, MoleculeGraph mol) {
        int nb = a.getBondCount();
        int ret = alabeller.getLabelVisibility(a, nb, mol.getDim());
        int style = this.common.getRenderingStyle();
        if (style == 0 && (ret & 1) == 0 && nb == 2 && a.getBond(0).getType() == a.getBond(1).getType() && mol.getDim() == 2) {
            MolBond b1 = a.getBond(0);
            MolBond b2 = a.getBond(1);
            if (nb != a.getBondCount()) {
                b1 = null;
                b2 = null;
                int j = 0;
                while (b2 == null) {
                    MolBond b;
                    MolAtom otherEnd;
                    if ((otherEnd = (b = a.getBond(j++)).getOtherAtom(a)).getAtno() == 1) continue;
                    if (b1 == null) {
                        b1 = b;
                        continue;
                    }
                    b2 = b;
                }
            }
            MolAtom a1 = b1.getOtherAtom(a);
            MolAtom a2 = b2.getOtherAtom(a);
            int i1 = mol.indexOf(a1);
            int i2 = mol.indexOf(a2);
            if (i1 >= 0 && i2 >= 0) {
                DPoint3 p1 = this.screenCoords[i1];
                DPoint3 p2 = this.screenCoords[i2];
                double dx1 = p1.x - p.x;
                double dx2 = p2.x - p.x;
                double dy1 = p1.y - p.y;
                double dy2 = p2.y - p.y;
                double c = dx1 * dx2 + dy1 * dy2;
                if (c < 0.0 && (c *= c / (dx1 * dx1 + dy1 * dy1) / (dx2 * dx2 + dy2 * dy2)) > 0.98) {
                    ret |= 1;
                    int h = a.getImplicitHcount() + a.getExplicitHcount();
                    int dispopts = this.common.getDispopts();
                    if (h != 0 && (dispopts & 3) != 0) {
                        ret |= 4;
                    }
                }
            }
        }
        if (a.getAtno() == 6 && a.getBondCount() != 0) {
            int f = this.common.getDispopts() & 0x30000000;
            if (f == 0 && !a.isSelected()) {
                ret &= 0xFFFFFFFE;
            } else if (f == 0x20000000) {
                ret |= 1;
            }
        } else if (a.getAtno() == 138) {
            ret &= 0xFFFFFFFE;
        }
        return ret;
    }

    private void paintBondLabels(Graphics2D g, MoleculeGraph mol) {
        ColorCollection colors = this.getColors();
        for (int i = 0; i < mol.getBondCount(); ++i) {
            Font f;
            FontMetrics fm;
            MolBond b = mol.getBond(i);
            String s = this.createBondLabel(b, mol, new StringBuffer());
            if (s == null) continue;
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            DPoint3 p1 = this.screenCoords[mol.indexOf(a1)];
            DPoint3 p2 = this.screenCoords[mol.indexOf(a2)];
            double dx = p2.x - p1.x;
            double dy = p2.y - p1.y;
            double dr = Math.sqrt(dx * dx + dy * dy);
            double nx = -dy / dr;
            double ny = dx / dr;
            if (nx < 0.0) {
                nx = -nx;
                ny = -ny;
            }
            double r = 2.0 * this.common.getBondSpacing() * this.getScale();
            double x0 = 0.5 * (p1.x + p2.x);
            double y0 = 0.5 * (p1.y + p2.y);
            double x = x0 + nx * r;
            double y = y0 + ny * r;
            if (s.equals("\"") || s.equals("?") || (b.getFlags() & 0xFC00) > 0 || b.isCoordinate() || b.isConjugated()) {
                fm = this.normalFontMetrics;
                f = this.normalFont;
            } else {
                fm = this.smallFontMetrics;
                f = this.smallFont;
            }
            if (fm == null) continue;
            Color c = a1.isSelected() && a2.isSelected() ? colors.getSelectionColor() : colors.getForeground();
            c = GraphicsUtil.applyFog(c, this.getBackground(), GraphicsUtil.calcFogFactor(this.screenCoords[mol.indexOf((MolAtom)a1)].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor()));
            this.drawText(g, f, fm, this.italicFont, this.italicFontMetrics, f, fm, x, y, 3, c, s, true);
        }
    }

    private void paintBond(Graphics2D g, LinePainter lpainter, Object[] objs, int i, MoleculeGraph mol, AtomLabeller alabeller, MDocument doc) {
        int dispopts = this.common.getDispopts();
        MolBond b = (MolBond)objs[i];
        int bondset = b.getSetSeq();
        int flags = b.getFlags();
        MolAtom a1 = b.getAtom1();
        MolAtom a2 = b.getAtom2();
        int style = this.common.getRenderingStyle();
        int atom1_index = mol.indexOf(a1);
        int atom2_index = mol.indexOf(a2);
        ColorCollection colors = this.getColors();
        boolean selected = a1.isSelected() && a2.isSelected();
        int stflags = flags & 0x3F0;
        if (selected || this.common.isSetColoringEnabled() && doc != null && doc.getBondSetColor(bondset) != null) {
            Color c = selected ? colors.getSelectionColor() : this.common.getBondSetColor(b.getSetSeq(), doc, colors);
            GraphicsUtil.setColor(g, c, this.getBackground(), this.screenCoords[atom1_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
            this.bondLine(g, lpainter, mol, b, 3, alabeller, doc, i, objs);
        } else if (stflags == 0 || stflags == 128 || stflags == 64) {
            Color color1 = null;
            if (a1.getSetSeq() == 0 || a1.getSetSeq() != 0 && doc != null) {
                color1 = this.getColor(a1, doc);
            }
            if (color1 == null) {
                color1 = colors.getForeground();
            }
            Color color2 = null;
            if (a2.getSetSeq() == 0 || a2.getSetSeq() != 0 && doc != null) {
                color2 = this.getColor(a2, doc);
            }
            if (color2 == null) {
                color2 = colors.getForeground();
            }
            if ((dispopts & 0x40000000) != 0) {
                color1 = GraphicsUtil.applyFog(color1, this.getBackground(), 0.5);
                color2 = GraphicsUtil.applyFog(color2, this.getBackground(), 0.5);
            }
            GraphicsUtil.setColor(g, color1, this.getBackground(), this.screenCoords[atom1_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
            if (color1 == color2) {
                this.bondLine(g, lpainter, mol, b, 3, alabeller, doc, i, objs);
            } else if (style <= 131072 || this.getLineThickness() < 1.5) {
                color1 = GraphicsUtil.applyFog(color1, this.getBackground(), GraphicsUtil.calcFogFactor(this.screenCoords[atom1_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor()));
                color2 = GraphicsUtil.applyFog(color2, this.getBackground(), GraphicsUtil.calcFogFactor(this.screenCoords[atom2_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor()));
                lpainter.setEndColors(color1, color2);
                this.bondLine(g, lpainter, mol, b, 3, alabeller, doc, i, objs);
                lpainter.setEndColors(null, null);
            } else {
                this.bondLine(g, lpainter, mol, b, 1, alabeller, doc, i, objs);
                GraphicsUtil.setColor(g, color2, this.getBackground(), this.screenCoords[atom2_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
                this.bondLine(g, lpainter, mol, b, 2, alabeller, doc, i, objs);
            }
        } else {
            Color endColor = this.getColor(a1, doc);
            Color c = (stflags == 16 || stflags == 32 || stflags == 3) && endColor != null ? endColor : colors.getForeground();
            if ((dispopts & 0x40000000) != 0) {
                c = GraphicsUtil.applyFog(c, this.getBackground(), 0.5);
            }
            GraphicsUtil.setColor(g, c, this.getBackground(), this.screenCoords[atom1_index].z, this.minScreenZ, this.maxScreenZ, this.getFogFactor());
            this.bondLine(g, lpainter, mol, b, 3, alabeller, doc, i, objs);
        }
    }

    private double getFogFactor() {
        if (!this.isFogApplicable) {
            return 0.0;
        }
        return this.getBasicFogFactor() * (double)this.common.getFogFactor() / 100.0;
    }

    private double getBasicFogFactor() {
        int atomCount = this.screenCoords.length;
        if (atomCount < 10) {
            return 0.25;
        }
        if (atomCount >= 10 && atomCount < 50) {
            return 0.5;
        }
        if (atomCount >= 50 && atomCount < 200) {
            return 0.75;
        }
        if (atomCount >= 200) {
            return 1.0;
        }
        return 0.0;
    }

    private void paintBondOrder(Graphics2D g, MolBond b, int order, MolAtom atom, Color fillColor, Color borderColor, Color atomColor) {
        DPoint3 point1 = atom.getLocation();
        this.calcGP(point1);
        DPoint3 point2 = b.getOtherAtom(atom).getLocation();
        this.calcGP(point2);
        int charCount = String.valueOf(atom.getRgroup()).length() + 1;
        double radius = this.getRadius(1.0);
        double width = radius * (double)(charCount / 2);
        double x = point1.x - width;
        double y = point1.y - radius;
        DPoint3[] V2 = new DPoint3[]{new DPoint3(x, y, 0.0), new DPoint3(x + 2.0 * width, y, 0.0), new DPoint3(x + 2.0 * width, y + 2.0 * radius, 0.0), new DPoint3(x, y + 2.0 * radius, 0.0), new DPoint3(x, y, 0.0)};
        Line2D.Double intersectionSegment = DrawingUtil.intersect2DSegPoly(point1.x, point1.y, point2.x, point2.y, V2);
        double distance1 = ((Line2D)intersectionSegment).getP1().distance(((Line2D)intersectionSegment).getP2()) + 2.0 * radius;
        double distance2 = point1.distance(point2);
        DPoint3 point = CleanUtil.calcDividingPoint(point1, point2, distance1 / distance2);
        this.paintOrderSymbol(g, order, fillColor, borderColor, atomColor, point);
    }

    private void paintOrderSymbol(Graphics2D g, int order, Color fillColor, Color borderColor, Color atomColor, DPoint3 point) {
        DPoint3 bottomLeft = this.paintAtomShadow(g, point, fillColor, borderColor, 0.6);
        if (this.smallFont != null) {
            g.setFont(this.smallFont);
            Color oldColor = g.getColor();
            g.setColor(atomColor);
            g.drawString(String.valueOf(order), (int)Math.ceil(bottomLeft.x), (int)Math.ceil(bottomLeft.y));
            g.setColor(oldColor);
        }
    }

    private Rectangle getTextBounds(Graphics2D g, String s) {
        if (this.normalFont == null) {
            this.initFonts(g);
            if (this.normalFont == null) {
                return new Rectangle(0, 0);
            }
        }
        int ascent = this.normalFontMetrics.getAscent();
        int descent = this.normalFontMetrics.getDescent();
        TextGraphics txtg = new TextGraphics(s, null);
        int sldim = txtg.draw(0, 0, 0, g, this.normalFont, this.normalFontMetrics, this.italicFont, this.italicFontMetrics, this.smallFont, this.smallFontMetrics, null, null);
        return new Rectangle(sldim, ascent + descent);
    }

    public void drawText(Graphics2D g, DPoint3 p, String s) {
        this.calcGP(p);
        this.drawText(g, this.normalFont, this.normalFontMetrics, this.italicFont, this.italicFontMetrics, this.smallFont, this.smallFontMetrics, p.x, p.y - (double)this.normalFontMetrics.getAscent(), 0, null, SimpleTeX.convertShort2TeX(s, 0), true);
    }

    public void drawTextNoSubscript(Graphics2D g, DPoint3 p, String s) {
        this.calcGP(p);
        this.drawText(g, this.normalFont, this.normalFontMetrics, this.italicFont, this.italicFontMetrics, this.smallFont, this.smallFontMetrics, p.x, p.y - (double)this.normalFontMetrics.getAscent(), 0, null, s, true);
    }

    private void drawText(Graphics2D g, Font fnt, FontMetrics fm, Font ifnt, FontMetrics ifm, Font sfnt, FontMetrics sfm, double x, double y, int align, Color color, String s, boolean clearBackground) {
        Color prevcolor = g.getColor();
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        TextGraphics txtg = new TextGraphics(s, null);
        int sldim = txtg.draw(0, 0, 0, null, fnt, fm, ifnt, ifm, sfnt, sfm, null, null);
        int w = sldim & 0xFFFF;
        int h = ascent + descent + (sldim >> 16);
        if ((align & 1) != 0) {
            x -= 0.5 * (double)w;
        }
        if ((align & 2) != 0) {
            y -= 0.5 * (double)h;
        }
        if (clearBackground) {
            txtg.draw(2, (int)Math.round(x), (int)Math.round(y + (double)ascent), g, fnt, fm, ifnt, ifm, sfnt, sfm, null, false, this.coveringLabels, this.isTransparent || !this.isClipping ? null : this.getBackground());
        }
        g.setColor(color != null ? color : prevcolor);
        txtg.draw(1, (int)Math.round(x), (int)Math.round(y + (double)ascent), g, fnt, fm, ifnt, ifm, sfnt, sfm, null, false, this.coveringLabels, this.isTransparent || !this.isClipping ? null : this.getBackground());
        g.setColor(prevcolor);
    }

    public static DPoint3 crossing(MoleculeGraph umol, MolBond b, MolBond bb) {
        MolAtom a1 = b.getAtom1();
        MolAtom a2 = b.getAtom2();
        int i1 = umol.indexOf(a1);
        int i2 = umol.indexOf(a2);
        return MolPainter.crossing(umol, bb, a1, a2, i1, i2, null);
    }

    private static DPoint3 crossing(MoleculeGraph umol, MolBond bb, MolAtom a1, MolAtom a2, int i1, int i2, DPoint3[] scrcoords) {
        MolAtom aa1 = bb.getAtom1();
        MolAtom aa2 = bb.getAtom2();
        if (a1 != aa1 && a1 != aa2 && a2 != aa1 && a2 != aa2) {
            DPoint3 q2;
            DPoint3 q1;
            DPoint3 p2;
            DPoint3 p1;
            int ii1 = umol.indexOf(aa1);
            int ii2 = umol.indexOf(aa2);
            if (i1 < 0 || i2 < 0 || ii1 < 0 || ii2 < 0) {
                return null;
            }
            if (scrcoords != null) {
                p1 = scrcoords[i1];
                p2 = scrcoords[i2];
                q1 = scrcoords[ii1];
                q2 = scrcoords[ii2];
            } else {
                p1 = a1.getLocation();
                p2 = a2.getLocation();
                q1 = aa1.getLocation();
                q2 = aa2.getLocation();
            }
            if (q2.x - q1.x == 0.0) {
                DPoint3 t1 = p1;
                DPoint3 t2 = p2;
                p1 = q1;
                p2 = q2;
                q1 = t1;
                q2 = t2;
            }
            double f = (p1.y - q1.y) * (q2.x - q1.x) - (p1.x - q1.x) * (q2.y - q1.y);
            double g = (p2.x - p1.x) * (q2.y - q1.y) - (p2.y - p1.y) * (q2.x - q1.x);
            if (g != 0.0) {
                double t = f / g;
                double d = q2.x - q1.x;
                if (t > 0.0 && t < 1.0 && d != 0.0) {
                    double tt = p1.x - q1.x + t * (p2.x - p1.x);
                    if (d < 0.0) {
                        tt = -tt;
                        d = -d;
                    }
                    if (tt > 0.0 && tt < d) {
                        return new DPoint3(p1.x + t * (p2.x - p1.x), p1.y + t * (p2.y - p1.y), p1.z + t * (p2.z - p1.z));
                    }
                }
            }
        }
        return null;
    }

    private String createBondLabel(MolBond b, MoleculeGraph mol, StringBuffer sbuf) {
        MolAtom parityatom;
        int unspecparity;
        int stereo1;
        int topology;
        sbuf.setLength(0);
        int dispopts = this.common.getDispopts();
        int flags = b.getFlags();
        int stereo2 = flags & 0x1C0;
        if ((stereo2 & 0x100) != 0) {
            sbuf.append("C/T?");
        }
        if ((topology = flags & 0xC00) != 0) {
            if (sbuf.length() != 0) {
                sbuf.append(' ');
            }
            sbuf.append(topology == 1024 ? "rng" : "chn");
        }
        if ((dispopts & 0x10000) != 0) {
            int ez;
            if (sbuf.length() != 0) {
                sbuf.append('\n');
            }
            if ((ez = mol.getStereo2(b)) != 0) {
                sbuf.append(ez == 128 ? "\\small{(Z)}" : (ez == 64 ? "\\small{(E)}" : "\\small{(?)}"));
            }
        }
        if ((dispopts & 0x2000) != 0) {
            if (sbuf.length() != 0) {
                sbuf.append(' ');
            }
            int l = (int)(100.0 * b.getLength() + 0.5);
            sbuf.append(String.valueOf(l / 100));
            sbuf.append('.');
            String s = "0" + l % 100;
            sbuf.append(s.substring(s.length() - 2, s.length()));
        }
        MolAtom a1 = b.getAtom1();
        MolAtom a2 = b.getAtom2();
        String querystr = b.getQuerystr();
        if (querystr != null) {
            sbuf.append(querystr);
        }
        if (((stereo1 = flags & 0x30) == 32 || stereo1 == 16) && (unspecparity = (parityatom = b.getStereo1(a1) == stereo1 ? a1 : a2).getFlags() & 4) == 4) {
            sbuf.append("?");
        }
        return sbuf.length() != 0 ? sbuf.toString() : null;
    }

    private void resetFonts0() {
        this.normalFont = null;
        this.normalFontMetrics = null;
        this.italicFont = null;
        this.italicFontMetrics = null;
        this.boldFont = null;
        this.boldFontMetrics = null;
        this.smallFont = null;
        this.smallFontMetrics = null;
        this.labelFont = null;
        this.labelFontMetrics = null;
        this.bigBoldFont = null;
        this.bigBoldFontMetrics = null;
    }

    public void resetFonts() {
        this.resetFonts0();
        FontMaker.staticReset();
    }

    public void initFonts(Graphics2D g) {
        Font[] fts = this.initFonts();
        this.normalFont = fts[0];
        if (this.normalFont != null) {
            this.normalFontMetrics = MolPainter.getFontMetrics(fts[0], g);
            if (g != null) {
                g.setFont(fts[0]);
            }
        }
        if ((this.italicFont = fts[1]) != null) {
            this.italicFontMetrics = MolPainter.getFontMetrics(fts[1], g);
        }
        if ((this.smallFont = fts[2]) != null) {
            this.smallFontMetrics = MolPainter.getFontMetrics(fts[2], g);
        }
        if ((this.labelFont = fts[3]) != null) {
            this.labelFontMetrics = MolPainter.getFontMetrics(fts[3], g);
        }
        if ((this.boldFont = fts[4]) != null) {
            this.boldFontMetrics = MolPainter.getFontMetrics(fts[4], g);
        }
        if ((this.bigBoldFont = fts[5]) != null) {
            this.bigBoldFontMetrics = MolPainter.getFontMetrics(fts[5], g);
        }
    }

    public Font[] initFonts() {
        Font[] fts0 = new Font[]{this.normalFont, this.italicFont, this.smallFont, this.labelFont};
        Font[] fts = FontMaker.initFonts(fts0, this.imageSize.scale, this.atomSize, this.common.getBaseFont());
        return fts;
    }

    private static int bondweights(MolAtom a, double[] w, String s, CTransform3D preTransform) {
        int dir;
        a.bondweights(w, preTransform);
        int n = w[1] < 0.0 ? 1 : (dir = w[1] > 0.0 ? -1 : 0);
        if (s != null) {
            int l = s.length();
            if (l <= 1 || l == 2 && !s.equals(s.toUpperCase())) {
                w[0] = 0.0;
            }
            if (l >= 1 && s.charAt(0) != '[') {
                w[1] = 0.0;
            }
        }
        return dir;
    }

    private static FontMetrics getFontMetrics(Font f, Graphics2D g) {
        if (g != null) {
            return g.getFontMetrics(f);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public static Font makeFont(int style, int size, MolPainterCommon common) {
        return FontMaker.makeFont(style, size, common.getBaseFont());
    }

    private int getDim(MoleculeGraph mol, int opts) {
        return MolPainter.getDim(mol, opts, this.preTransform);
    }

    private static int getDim(MoleculeGraph mol, int opts, CTransform3D t) {
        return mol.getDim() == 3 || (opts & 0x38) == 24 || t.is3d() ? 3 : 2;
    }

    public void initZoom() {
        this.preTransform.setScale(1.0);
        this.invPreTransform.setScale(1.0);
        this.updateTransform();
    }

    private static Point getLabelsP(MolAtom a0, int xl, int yl, int wsl, int[] dims, double[] angle, int[] lcenter, FontMetrics sfm, FontMetrics fm, int ballR) {
        int nb = a0.getBondCount();
        if (nb > 0) {
            int dx;
            boolean isAttached = a0.getAttach() != 0;
            double[] largest = GeomUtil.getLargestBondAngle2D(a0);
            double langle = largest[0];
            double ldiff = largest[1];
            double rangle = langle + ldiff / 2.0;
            if (nb == 1) {
                double d = rangle = langle > 0.0 ? langle - Math.PI : langle + Math.PI;
            }
            if (isAttached) {
                rangle += ldiff / 4.0;
            }
            if (Math.abs(rangle) < 1.0E-5) {
                rangle = 0.0;
            }
            int maxdx = (int)Math.round((double)dims[0] * 0.6);
            int maxdy0 = fm.getAscent();
            int maxdy = sfm.getAscent();
            int dy = -((int)Math.round(Math.tan(rangle) * (double)maxdx));
            int n = dx = rangle != 0.0 ? (int)Math.round(1.0 / Math.tan(rangle) * (double)maxdy) : 0;
            if (Math.abs(dx) > maxdx || rangle == 0.0) {
                dx = Math.cos(rangle) > 0.0 ? maxdx : -maxdx;
            } else {
                int n2 = dx = Math.cos(rangle) > 0.0 ? Math.abs(dx) : -Math.abs(dx);
            }
            dy = Math.abs(dy) > maxdy ? (Math.sin(rangle) > 0.0 ? -maxdy0 : maxdy) : (Math.sin(rangle) > 0.0 ? -Math.abs(dy) : Math.abs(dy));
            int ddx = -Math.round(dims[0] / 2) + Math.round(wsl / 2) + (int)Math.round(Math.cos(rangle) * (double)wsl / 2.0);
            int ddy = -Math.round(maxdy / 2);
            if (lcenter != null) {
                ddy += lcenter[2] == -1 ? fm.getAscent() : 0;
            }
            dims[0] = dx + ddx;
            dims[1] = Math.abs(dy + ddy);
            ddx += (int)Math.round(Math.cos(rangle) * (double)ballR);
            ddy -= (int)Math.round(Math.sin(rangle) * (double)ballR);
            if (angle != null) {
                angle[0] = rangle;
            }
            return new Point(xl + dx + ddx, yl + dy + ddy);
        }
        if (angle != null) {
            angle[0] = -2.356194490192345;
            dims[1] = 10;
        }
        return new Point(xl - 10, yl + 10);
    }

    private static void findAtomSymbol(MolAtom a, String s, int[] lcenter, CTransform3D preTr) {
        if (a instanceof SgroupAtom) {
            lcenter[0] = MolPainter.findBondCharPosition(a, s, preTr);
            lcenter[1] = 1;
        } else {
            if (s.length() == 0) {
                return;
            }
            char c = s.charAt(0);
            int i = 0;
            if (s.startsWith(": ")) {
                String ss = s;
                while (ss.startsWith(": ")) {
                    ss = ss.substring(2);
                    i += 2;
                }
                c = s.charAt(i);
            }
            if (c == '_' || c == '^') {
                int level = 0;
                if (s.charAt(++i) == '{') {
                    level = 1;
                    ++i;
                    while (level > 0 && i < s.length()) {
                        c = s.charAt(i);
                        if (c == '{') {
                            ++level;
                        } else if (c == '}') {
                            --level;
                        }
                        ++i;
                    }
                }
                if (level != 0) {
                    return;
                }
                lcenter[0] = i;
            } else {
                lcenter[0] = i;
            }
            while (s.endsWith(" :")) {
                s = s.substring(0, s.length() - 2);
            }
            while (i < s.length() && s.charAt(i) != '_' && s.charAt(i) != '^') {
                ++i;
            }
            lcenter[1] = i - lcenter[0];
        }
    }

    private static String getAtomSymbol(MolAtom a, boolean hydrit, boolean lppaint, int[] lcenter, CTransform3D pretrf) {
        int opts = 0;
        if (hydrit) {
            opts |= 2;
        }
        if (lppaint || !LonePairPainter.isChargeVisible(a)) {
            opts |= 8;
        } else if (LonePairPainter.getEFlowFrom(a) != null && a.getCharge() < 0 && LonePairPainter.getEFlowFrom(a).getNumElectrons() == 2) {
            opts |= 8;
        }
        String s = a.getAtomSymbol(opts, a.getFlags(), lcenter, pretrf);
        int atno = a.getAtno();
        if (atno == 136) {
            s = "\\italic{" + s + "}";
        } else if (atno == 135) {
            s = SimpleTeX.convertShort2TeX(s, 0);
        } else if (atno == 137 && a.getBondCount() == 0 && a.getCharge() == 0) {
            s = s.concat("*");
        } else if (atno == 138) {
            s = "";
        }
        return DrawingUtil.removeCaret(s);
    }

    public Dimension calcMolMultipageRectangle(MDocument document) {
        if (document == null) {
            return new Dimension(0, 0);
        }
        DPoint3 upperLeft = document.getPageSettings().getUpperLeftPoint();
        double width = document.getPageSettings().getWidth() * (double)document.getPageSettings().getColumnCount();
        double height = document.getPageSettings().getHeight() * (double)document.getPageSettings().getRowCount();
        Point p1 = this.calcGP(upperLeft.x, upperLeft.y, 0.0);
        Point p2 = this.calcGP(upperLeft.x + width, upperLeft.y + height, 0.0);
        DPoint3 mp1 = this.calcMolP(p1.x - this.getCorner().x, p1.y - this.getCorner().y);
        DPoint3 mp2 = this.calcMolP(p2.x - this.getCorner().x, p2.y - this.getCorner().y);
        return new Dimension((int)Math.ceil(Math.abs(mp1.x - mp2.x)), (int)Math.ceil(Math.abs(mp1.y - mp2.y)));
    }

    public Dimension calcMolMultipageBoundingRectangle(MDocument document) {
        if (document == null) {
            return new Dimension(0, 0);
        }
        DPoint3 upperLeft = document.getPageSettings().getUpperLeftPoint();
        double width = document.getPageSettings().getWidth() * (double)document.getPageSettings().getColumnCount();
        double height = document.getPageSettings().getHeight() * (double)document.getPageSettings().getRowCount();
        Rectangle r1 = this.getBounds();
        Point p1 = this.calcGP(upperLeft.x, upperLeft.y, 0.0);
        Point p2 = this.calcGP(upperLeft.x + width, upperLeft.y + height, 0.0);
        int xmin = Math.max(r1.x, p1.x - this.getCorner().x);
        int ymin = Math.max(r1.y, p1.y - this.getCorner().y);
        int xmax = Math.min(r1.x + r1.width, p2.x);
        int ymax = Math.min(r1.y + r1.height, p2.y);
        DPoint3 mp1 = this.calcMolP(xmax, ymax);
        DPoint3 mp2 = this.calcMolP(xmin, ymin);
        return new Dimension((int)Math.ceil(Math.abs(mp1.x - mp2.x)), (int)Math.ceil(Math.abs(mp1.y - mp2.y)));
    }

    public DPoint3 getSelectedMultipageCell(PageSettings ps) {
        DPoint3 upperLeft = (DPoint3)ps.getUpperLeftPoint().clone();
        int column = ps.getSelectedPage() % ps.getColumnCount();
        int row = ps.getSelectedPage() / ps.getColumnCount();
        upperLeft.x += (double)column * ps.getWidth();
        upperLeft.y += (double)row * ps.getHeight();
        this.calcGP(upperLeft);
        return upperLeft;
    }

    public Dimension getMultipageCellBounds(PageSettings ps) {
        Dimension bounds = new Dimension(0, 0);
        DPoint3 upperLeft = (DPoint3)ps.getUpperLeftPoint().clone();
        DPoint3 bottomRight = new DPoint3(upperLeft.x + ps.getWidth(), upperLeft.y + ps.getHeight(), upperLeft.z);
        this.calcGP(upperLeft);
        this.calcGP(bottomRight);
        bounds.height = (int)Math.abs(upperLeft.y - bottomRight.y);
        bounds.width = (int)Math.abs(upperLeft.x - bottomRight.x);
        return bounds;
    }

    public double getWidthFitScale(Dimension size, MDocument document) {
        PageSettings ps = document.getPageSettings();
        DPoint3 upperLeft = (DPoint3)ps.getUpperLeftPoint().clone();
        DPoint3 bottomRight = new DPoint3(upperLeft.x + ps.getWidth(), upperLeft.y + ps.getHeight(), upperLeft.z);
        this.calcGP(upperLeft);
        this.calcGP(bottomRight);
        double width = Math.abs(upperLeft.x - bottomRight.x);
        return (double)(size.width - 5) / width;
    }

    public double getHeightFitScale(Dimension size, MDocument document) {
        PageSettings ps = document.getPageSettings();
        DPoint3 upperLeft = (DPoint3)ps.getUpperLeftPoint().clone();
        DPoint3 bottomRight = new DPoint3(upperLeft.x + ps.getWidth(), upperLeft.y + ps.getHeight(), upperLeft.z);
        this.calcGP(upperLeft);
        this.calcGP(bottomRight);
        double height = Math.abs(upperLeft.y - bottomRight.y);
        return (double)(size.height - 5) / height;
    }

    public void updateMultipage(PageSettings ps, Dimension size) {
        double cx = size.width / 2;
        double cy = size.height / 2;
        DPoint3 upperLeft = (DPoint3)ps.getUpperLeftPoint().clone();
        DPoint3 bottomRight = new DPoint3(upperLeft.x + ps.getWidth(), upperLeft.y + ps.getHeight(), upperLeft.z);
        this.calcGP(upperLeft);
        this.calcGP(bottomRight);
        double width = Math.abs(upperLeft.x - bottomRight.x);
        double height = Math.abs(upperLeft.y - bottomRight.y);
        int column = (int)((cx - upperLeft.x) / width);
        int row = (int)((cy - upperLeft.y) / height);
        if (row < 0) {
            row = 0;
        }
        if (row >= ps.getRowCount()) {
            row = ps.getRowCount() - 1;
        }
        if (column < 0) {
            column = 0;
        }
        if (column >= ps.getColumnCount()) {
            column = ps.getColumnCount() - 1;
        }
        ps.setSelectedPage(row * ps.getColumnCount() + column);
    }

    private static int findBondCharPosition(MolAtom a, String sym, CTransform3D preTr) {
        int charPos = -1;
        if (sym != null) {
            if (a instanceof SgroupAtom) {
                SuperatomSgroup sa = ((SgroupAtom)a).getSgroup();
                MolAtom[] linkAtoms = sa.getAttachAtoms();
                if (linkAtoms.length > 0) {
                    String linkSym = linkAtoms[0].getSymbol();
                    int labelDir = preTr != null ? a.getPreferredLabelDir(preTr, 0) : 0;
                    charPos = labelDir == 1 && ((SgroupAtom)a).getLeftName() != null ? sym.lastIndexOf(linkSym) : sym.indexOf(linkSym);
                }
            } else {
                String linkSym = a.getSymbol();
                charPos = sym.indexOf(linkSym);
            }
        }
        return charPos;
    }

    public void paintMultipageInfo(Graphics2D g, Dimension size, String string) {
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        g.setFont(this.getCommon().getBaseFont());
        g.setColor(this.getBackground());
        g.fillRect(0, size.height - (int)((double)this.getCommon().getBaseFont().getSize() * 1.5), size.width, size.height);
        g.setColor(oldColor);
        int m = (int)((double)this.getCommon().getBaseFont().getSize() * 0.5);
        g.drawString(string, m, size.height - m);
        g.setFont(oldFont);
    }

    private double getRgroupLabelWidth(int rgid) {
        double width;
        String s;
        String string = s = rgid != 0 ? "  R" + rgid + " = " : "  R = ";
        if (this.bigBoldFontMetrics == null) {
            width = 0.5133333333333333 * (double)s.length();
        } else {
            FontMetrics fm = this.boldFontMetrics;
            width = fm.stringWidth(s);
        }
        return width;
    }

    public Rectangle fitFragment(MoleculeGraph[] molg, int id, Dimension canvasSize) {
        double labelWidth = 0.0;
        Rectangle bounds = new Rectangle(0, 0);
        MolPainter.calcBounds(this.common, molg, this.atomSize, this.common.getBondSpacing(), false, false, true, this.boundsXYRR, this.preTransform, 1.0 / Math.abs(this.preTransform.getScale()), this.imageSize, false, false);
        this.setCentralized(this.centralized);
        bounds = this.getBounds();
        double boundsx = bounds.x;
        double boundswidth = bounds.width;
        double boundsheight = bounds.height;
        if (id != 0) {
            labelWidth = this.getRgroupLabelWidth(id);
            boundsx -= labelWidth;
            boundswidth += labelWidth;
        }
        double mw = (double)canvasSize.width / boundswidth;
        double mh = (double)canvasSize.height / boundsheight;
        double m = Math.min(mw, mh);
        this.setScale(this.getScale() * m);
        bounds = this.getBounds();
        boundsx = bounds.x;
        boundswidth = bounds.width;
        boundsheight = bounds.height;
        double boundsy = bounds.y;
        if (id != 0) {
            boundsx -= (labelWidth *= m);
            boundswidth += labelWidth;
        }
        if (m == mh) {
            boundsx -= ((double)canvasSize.width - boundswidth) / 2.0;
        } else {
            boundsy -= ((double)canvasSize.height - boundsheight) / 2.0;
        }
        bounds.x = (int)Math.ceil(boundsx);
        bounds.y = (int)Math.ceil(boundsy);
        bounds.width = (int)boundswidth;
        bounds.height = (int)boundsheight;
        return bounds;
    }

    public void alignNameBox(Graphics2D g, Molecule mol, MNameTextBox textBox) {
        if (!textBox.isAutoAlign() && !textBox.isAutoResize()) {
            return;
        }
        double textBoxWidth = 0.0;
        double textBoxHeight = 0.0;
        double x = 0.0;
        double y = 0.0;
        MoleculeGraph[] mols = new MoleculeGraph[]{mol};
        double[] XYRR = new double[4];
        MolPainter.calcBounds(this.common, mols, this.atomSize, this.common.getBondSpacing(), false, false, true, XYRR, this.preTransform, 1.0 / Math.abs(this.preTransform.getScale()), this.imageSize, false, true);
        x = XYRR[0] - XYRR[2];
        y = XYRR[1] - XYRR[3];
        double boundingBoxWidth = 2.0 * XYRR[2];
        textBoxWidth = textBox.calcWidth(g, this.getScale() / 1.54);
        textBoxHeight = Math.abs(textBox.getPoint((int)0).getLocation().y - textBox.getPoint((int)2).getLocation().y);
        textBoxHeight = textBoxHeight == 0.0 ? (double)(2 * this.normalFontMetrics.getHeight()) / this.getScale() : textBoxHeight;
        double dx = Math.abs(textBoxWidth - boundingBoxWidth) / 2.0;
        x += textBoxWidth > boundingBoxWidth ? -dx : dx;
        if (!textBox.isAutoAlign()) {
            x = textBox.getPoint((int)0).getLocation().x;
            y = textBox.getPoint((int)0).getLocation().y;
        }
        if (!textBox.isAutoResize()) {
            textBoxWidth = Math.abs(textBox.getPoint((int)0).getLocation().x - textBox.getPoint((int)2).getLocation().x);
            textBoxHeight = Math.abs(textBox.getPoint((int)0).getLocation().y - textBox.getPoint((int)2).getLocation().y);
        }
        MPoint p1 = new MPoint(x, y);
        MPoint p2 = new MPoint(x + textBoxWidth, y - textBoxHeight);
        boolean oldResizingBehavior = textBox.isAutoResize();
        textBox.setCorners(p1, p2);
        textBox.setAutoResize(oldResizingBehavior);
        if (textBox.isAutoResize()) {
            textBox.setAutoHeight(true);
        }
        textBox.setAutoResize(oldResizingBehavior);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.getCommon().freeColorCollection(this.theColors);
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public void setTransparent(boolean transparency) {
        this.isTransparent = transparency;
    }
}

