/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import java.awt.Color;
import java.io.Serializable;

public class Shades
implements Serializable {
    private static final long serialVersionUID = 1261126851166546916L;
    private Color bgColor;
    private Color fgColor;
    private int numShades;
    private Color[] shades;

    public Shades(Color c, Color bg, int n) {
        this.fgColor = c;
        this.bgColor = bg;
        this.numShades = n;
    }

    public Shades(Color c) {
        this.shades = new Color[1];
        this.shades[0] = c;
    }

    public Color getColor(double z) {
        int i = (int)(z * ((double)this.numShades - 0.01));
        if (this.shades == null) {
            this.shades = new Color[this.numShades];
            Color bg = this.bgColor;
            Color fg = this.fgColor;
            int rbg = bg.getRed();
            int gbg = bg.getGreen();
            int bbg = bg.getBlue();
            int rfg = fg.getRed();
            int gfg = fg.getGreen();
            int bfg = fg.getBlue();
            int max = this.shades.length - 1;
            this.shades[0] = bg;
            this.shades[max] = fg;
            for (int j = 1; j < max; ++j) {
                double f = (double)j / (double)max;
                int r = (int)((double)rbg + (double)(rfg - rbg) * f + 0.5);
                int g = (int)((double)gbg + (double)(gfg - gbg) * f + 0.5);
                int b = (int)((double)bbg + (double)(bfg - bbg) * f + 0.5);
                this.shades[j] = new Color(r, g, b);
            }
            this.bgColor = null;
            this.fgColor = null;
        }
        return this.shades[i];
    }
}

