/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import chemaxon.common.util.text.SimpleTeX;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

public class TextGraphics {
    public static final int INIT = 0;
    public static final int DRAW = 1;
    public static final int CLEAR = 2;
    public static final int CLEARSEL = 3;
    private static final boolean[] DESCENT_IMPORTANT = new boolean[256];
    private SimpleTeX tex;

    public TextGraphics(String str, int[] lcenter) {
        this.tex = new SimpleTeX(str, lcenter != null ? lcenter[0] : -1);
        if (lcenter != null) {
            lcenter[3] = this.tex.getAlignStringIndex();
            lcenter[4] = this.tex.getAlignCharIndex();
        }
    }

    public int draw(int cmd, int x, int y0, Graphics2D g, Font rfont, FontMetrics rfm, Font ifont, FontMetrics ifm, Font smallFont, FontMetrics sfm, int[] lcenter, Color color) {
        return this.draw(cmd, x, y0, g, rfont, rfm, ifont, ifm, smallFont, sfm, lcenter, false, null, color);
    }

    public int draw(int cmd, int x, int y0, Graphics2D g, Font rfont, FontMetrics rfm, Font ifont, FontMetrics ifm, Font smallFont, FontMetrics sfm, int[] lcenter, boolean isRightName, ArrayList<RoundRectangle2D> labels, Color color) {
        int sascent2 = Math.round(sfm.getAscent() / 2);
        int m = 0;
        int[] xarr = new int[4];
        xarr[2] = 0;
        xarr[1] = 0;
        xarr[0] = 0;
        int maxx = 0;
        int maxxIndent = 0;
        int maxy = y0;
        int deltay = 0;
        int cumulativeWidth = 0;
        for (int i = 0; i < this.tex.getStringCount(); ++i) {
            int y;
            FontMetrics fm;
            Font f;
            int m3;
            String s = this.tex.getString(i);
            boolean indentLater = false;
            if (s.length() > 0 && s.charAt(0) == '\t') {
                s = s.substring(1);
                if (cmd == 0) {
                    indentLater = true;
                } else {
                    xarr[1] = xarr[2] = lcenter[5];
                    xarr[0] = xarr[2];
                }
            }
            if ((m3 = (m = this.tex.getAttributes(i)) & 3) != 0) {
                f = smallFont;
                fm = sfm;
                int n = y = m3 == 2 ? y0 - sascent2 : y0 + sascent2;
                if (y > maxy) {
                    maxy = y;
                }
            } else if ((m & 8) != 0) {
                f = ifont;
                fm = ifm;
                y = y0;
            } else if ((m & 4) != 0) {
                f = smallFont;
                fm = sfm;
                y = y0;
            } else {
                f = rfont;
                fm = rfm;
                y = y0;
            }
            int w = Math.round(fm.stringWidth(s));
            cumulativeWidth += w;
            int h = Math.round(fm.getAscent());
            if (w > 0) {
                if (cmd == 2 || cmd == 3) {
                    for (int j = 0; j < s.length(); ++j) {
                        char c = s.charAt(j);
                        if (c >= DESCENT_IMPORTANT.length || !DESCENT_IMPORTANT[c]) continue;
                        h += Math.round(fm.getDescent());
                        break;
                    }
                    y -= Math.round(fm.getAscent());
                    if (cmd == 2) {
                        if (labels != null && color == null) {
                            labels.add(new RoundRectangle2D.Double(x + xarr[m3], y, (double)w * 1.1, (double)h * 1.3, (double)w * 0.75, (double)h * 0.75));
                        } else if (color != null) {
                            this.clearRect(g, x + xarr[m3], y, w, h, color);
                        }
                    } else if (cmd == 3) {
                        g.fillRoundRect(x + xarr[m3], y, (int)Math.round((double)w * 1.1), (int)Math.round((double)h * 1.3), (int)Math.round((double)w * 0.75), (int)Math.round((double)h * 0.75));
                    }
                } else if (cmd == 1) {
                    g.setFont(f);
                    g.drawString(s, x + xarr[m3], y);
                }
            }
            if (lcenter != null && i == lcenter[3]) {
                int i0 = lcenter[4];
                int i1 = i0 + lcenter[1];
                if (i1 > s.length()) {
                    i1 = s.length();
                }
                if (i0 > 0) {
                    lcenter[6] = Math.round(fm.stringWidth(s.substring(i0, i1)));
                    lcenter[5] = isRightName ? Math.round(fm.stringWidth(s.substring(0, i0))) : cumulativeWidth - lcenter[6];
                } else {
                    lcenter[5] = xarr[0];
                    int n = lcenter[6] = i1 < s.length() ? Math.round(fm.stringWidth(s.substring(0, i1))) : w;
                }
            }
            if (m3 == 0) {
                xarr[2] = xarr[0] = xarr[0] + w;
                xarr[1] = xarr[0];
            } else {
                int n = m3;
                xarr[n] = xarr[n] + w;
                xarr[0] = Math.max(xarr[1], xarr[2]);
            }
            if (xarr[0] > maxx) {
                maxx = xarr[0];
            }
            if (indentLater && xarr[0] > maxxIndent) {
                maxxIndent = xarr[0];
            }
            if ((m & 0x30) == 0) continue;
            int dy = Math.round(rfm.getAscent());
            if ((m & 0x20) != 0) {
                dy += Math.round(rfm.getDescent());
            }
            maxy = y0 += dy;
            deltay += dy;
            xarr[2] = 0;
            xarr[1] = 0;
            xarr[0] = 0;
        }
        if (cmd == 0 && lcenter != null && (maxxIndent += lcenter[5]) > maxx) {
            maxx = maxxIndent;
        }
        return maxx | deltay << 16;
    }

    private void clearRect(Graphics2D g, int x, int y, int w, int h, Color color) {
        g.setColor(color);
        g.fillRoundRect(x, y, (int)((double)w * 1.1), (int)((double)h * 1.3), (int)((double)w * 0.75), (int)((double)h * 0.75));
    }

    static {
        String s = "fgjpq()";
        for (int i = 0; i < s.length(); ++i) {
            TextGraphics.DESCENT_IMPORTANT[s.charAt((int)i)] = true;
        }
    }
}

