/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import java.awt.geom.Point2D;

public class Vector2D {
    double x = 0.0;
    double y = 0.0;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static double dot(Vector2D v1, Vector2D v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    public static double perp(Vector2D v1, Vector2D v2) {
        return v1.x * v2.y - v1.y * v2.x;
    }

    public static void subtract(Vector2D result, Vector2D v1, Vector2D v2) {
        result.x = v1.x - v2.x;
        result.y = v1.y - v2.y;
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D subtract(Vector2D v) {
        return new Vector2D(this.x - v.x, this.y - v.y);
    }

    public Vector2D scalar(double s) {
        return new Vector2D(s * this.x, s * this.y);
    }

    public Vector2D add(Vector2D v) {
        return new Vector2D(v.x + this.x, v.y + this.y);
    }

    public Point2D toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }
}

