/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.graphics;

import chemaxon.marvin.paint.internal.GraphicsPainter;
import chemaxon.marvin.paint.internal.graphics.MPointPainter;
import chemaxon.marvin.paint.internal.util.GraphicsUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MBracket;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class MBracketPainter
implements GraphicsPainter {
    @Override
    public void paint(MObject mo, Graphics2D g, CTransform3D t, int f, Color c, Color selc, Color focusc) {
        Color lc;
        MBracket mb = (MBracket)mo;
        if ((f & 1) != 0) {
            GraphicsUtil.setAntialias(g, true);
        }
        Color color = lc = mb.isSelected() ? selc : mb.getLineColor();
        if (lc == null) {
            lc = c;
        }
        g.setColor(lc);
        double strokew = mb.getThickness() * Math.abs(t.getScale());
        boolean mirr = t.determinant2D() >= 0.0;
        DPoint3 orig = new DPoint3();
        DPoint3 ref = new DPoint3(1.54, 0.0, 0.0);
        t.transform(ref);
        t.transform(orig);
        DPoint3 p1 = new DPoint3(0.0, 0.0, 0.0);
        DPoint3 p2 = new DPoint3(0.0, 0.0, 0.0);
        if (mb.getBracketOrientation() == 5) {
            mb.getPoint(0).getLocation(p1, t);
            mb.getPoint(3).getLocation(p2, t);
            this.paintLeftOrRight(mb, g, p1, p2, strokew, mirr, 2.0 * ref.distance2D(orig));
            mb.getPoint(1).getLocation(p1, t);
            mb.getPoint(2).getLocation(p2, t);
            this.paintLeftOrRight(mb, g, p1, p2, strokew, !mirr, 2.0 * ref.distance2D(orig));
        }
        if (mb.getBracketOrientation() == 4) {
            DPoint3 p3 = new DPoint3(0.0, 0.0, 0.0);
            DPoint3 p4 = new DPoint3(0.0, 0.0, 0.0);
            mb.getPoint(0).getLocation(p1, t);
            mb.getPoint(1).getLocation(p2, t);
            mb.getPoint(2).getLocation(p3, t);
            mb.getPoint(3).getLocation(p4, t);
            this.paintHalfBracket(mb, g, p1, p2, p3, p4, strokew, mirr);
        }
        if ((f & 1) != 0) {
            GraphicsUtil.setAntialias(g, false);
        }
        this.paintHilight(mb, g, t, f, c, selc, focusc);
    }

    public void paintHilight(MBracket mb, Graphics2D g, CTransform3D t, int f, Color c, Color selc, Color focusc) {
        if (focusc != null || mb.isSelected()) {
            Color cc = mb.isSelected() ? selc : focusc;
            for (int i = 0; i < mb.getVisiblePointRefCount(); ++i) {
                MPoint mp = mb.getVisiblePointRef(i, t);
                MPointPainter mpp = new MPointPainter();
                mpp.paint(mp, g, t, f & 1, cc, selc, focusc);
            }
        }
    }

    private void paintHalfBracket(MBracket mb, Graphics2D g, DPoint3 p1, DPoint3 p2, DPoint3 p3, DPoint3 p4, double strokew, boolean mirr) {
        BasicStroke stroke = new BasicStroke((float)strokew, 2, 0);
        g.setStroke(stroke);
        if (mb.getType() == 0) {
            GraphicsUtil.drawArc(g, p1, p4, 90.0);
        } else if (mb.getType() == 1) {
            GraphicsUtil.drawLine(g, p1.x, p1.y, p4.x, p4.y);
            GraphicsUtil.drawLine(g, p1.x, p1.y, p2.x, p2.y);
            GraphicsUtil.drawLine(g, p3.x, p3.y, p4.x, p4.y);
        } else if (mb.getType() == 2) {
            DPoint3 mp1 = mb.getPoint(0).getLocation();
            DPoint3 mp2 = mb.getPoint(1).getLocation();
            DPoint3 mp4 = mb.getPoint(3).getLocation();
            boolean rightHand = Math.abs(mp1.x - mp2.x) < 1.0E-5 ? mp2.y > mp1.y && mp4.x > mp1.x || mp2.y < mp1.y && mp4.x < mp1.x : mp1.x < mp2.x && mp1.y > mp4.y || mp1.x > mp2.x && mp1.y < mp4.y;
            int rot = -1;
            if (!mirr && rightHand || mirr && !rightHand) {
                rot = 1;
            }
            DPoint3 p0 = new DPoint3((p2.x + p3.x) / 2.0, (p2.y + p3.y) / 2.0, (p2.z + p3.z) / 2.0);
            DPoint3 q1 = new DPoint3((p0.x + p1.x) / 2.0, (p0.y + p1.y) / 2.0, (p0.z + p1.z) / 2.0);
            DPoint3 q2 = new DPoint3((p0.x + p4.x) / 2.0, (p0.y + p4.y) / 2.0, (p0.z + p4.z) / 2.0);
            GraphicsUtil.drawArc(g, p0, q1, rot * 75);
            GraphicsUtil.drawArc(g, p0, q2, -rot * 75);
            GraphicsUtil.drawArc(g, q1, p1, -rot * 75);
            GraphicsUtil.drawArc(g, q2, p4, rot * 75);
        } else if (mb.getType() == 3) {
            // empty if block
        }
    }

    private void paintLeftOrRight(MBracket mb, Graphics2D g, DPoint3 p1, DPoint3 p2, double strokew, boolean right, double bondLength) {
        if (right) {
            DPoint3 q = p1;
            p1 = p2;
            p2 = q;
        }
        int type = mb.getType();
        double x12 = p2.x - p1.x;
        double y12 = p2.y - p1.y;
        Stroke oldstroke = g.getStroke();
        if (type == 0) {
            BasicStroke stroke = new BasicStroke((float)strokew, 2, 0);
            g.setStroke(stroke);
            double q = (Math.sqrt(2.0) - 1.0) / 4.0;
            double dx = q * y12;
            double dy = -q * x12;
            p1.x += dx;
            p1.y += dy;
            p2.x += dx;
            p2.y += dy;
            GraphicsUtil.drawArc(g, p1, p2, -90.0);
        } else if (type == 1) {
            BasicStroke stroke = new BasicStroke((float)strokew, 2, 0);
            g.setStroke(stroke);
            GraphicsUtil.drawLine(g, p1.x, p1.y, p2.x, p2.y);
            double xratio = 0.1;
            double yratio = -0.1;
            if (Math.abs(y12) > bondLength) {
                xratio *= Math.abs(bondLength / y12);
            }
            if (Math.abs(x12) > bondLength) {
                yratio *= Math.abs(bondLength / x12);
            }
            double dx = xratio * y12;
            double dy = yratio * x12;
            GraphicsUtil.drawLine(g, p1.x, p1.y, p1.x + dx, p1.y + dy);
            GraphicsUtil.drawLine(g, p2.x, p2.y, p2.x + dx, p2.y + dy);
        } else if (type == 2) {
            BasicStroke stroke = new BasicStroke((float)strokew, 2, 0);
            g.setStroke(stroke);
            double q = (Math.sqrt(2.0) - 1.0) / 4.0;
            double dx = q * y12;
            double dy = -q * x12;
            DPoint3 p0 = new DPoint3((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0, (p1.z + p2.z) / 2.0);
            p0.x -= dx;
            p0.y -= dy;
            p1.x += dx;
            p1.y += dy;
            p2.x += dx;
            p2.y += dy;
            DPoint3 q1 = new DPoint3((p0.x + p1.x) / 2.0, (p0.y + p1.y) / 2.0, (p0.z + p1.z) / 2.0);
            DPoint3 q2 = new DPoint3((p0.x + p2.x) / 2.0, (p0.y + p2.y) / 2.0, (p0.z + p2.z) / 2.0);
            GraphicsUtil.drawArc(g, p0, q1, -75.0);
            GraphicsUtil.drawArc(g, p0, q2, 75.0);
            GraphicsUtil.drawArc(g, q1, p1, 75.0);
            GraphicsUtil.drawArc(g, q2, p2, -75.0);
        } else if (type == 3) {
            BasicStroke stroke = new BasicStroke((float)strokew, 0, 0);
            g.setStroke(stroke);
            double dx = 0.1 * y12;
            double dy = -0.1 * x12;
            double x = (p1.x + p2.x) / 2.0 - dx;
            double y = (p1.y + p2.y) / 2.0 - dy;
            GraphicsUtil.drawLine(g, x, y, p1.x + dx, p1.y + dy);
            GraphicsUtil.drawLine(g, x, y, p2.x + dx, p2.y + dy);
        }
        g.setStroke(oldstroke);
    }
}

