/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.graphics;

import chemaxon.marvin.paint.internal.graphics.MRectanglePainter;
import chemaxon.marvin.paint.internal.util.GraphicsUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MEllipse;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;

public class MEllipsePainter
extends MRectanglePainter {
    @Override
    public void paint(MObject mo, Graphics2D g, CTransform3D t, int f, Color c, Color selc, Color focusc) {
        MEllipse me = (MEllipse)mo;
        t = this.convertTransform(me, t, true);
        Color bg = me.getBackground();
        Color oldcolor = g.getColor();
        double[] x = new double[4];
        double[] y = new double[4];
        DPoint3 p = new DPoint3(0.0, 0.0, 0.0);
        for (int i = 0; i < 4; ++i) {
            MPoint mp = me.getPoint(i);
            mp.getLocation(p, t);
            x[i] = p.x;
            y[i] = p.y;
        }
        double ox = (x[0] + x[2]) / 2.0;
        double oy = (y[0] + y[2]) / 2.0;
        if (y[0] == y[1]) {
            double rx = Math.abs(x[2] - x[0]) / 2.0;
            double ry = Math.abs(y[2] - y[0]) / 2.0;
            if (bg != null && me.hasFace()) {
                g.setColor(bg);
                g.fill(new Ellipse2D.Double(ox - rx, oy - ry, 2.0 * rx, 2.0 * ry));
            }
            if (me.hasOutline()) {
                Color lc;
                if ((f & 1) != 0) {
                    GraphicsUtil.setAntialias(g, true);
                }
                Color color = lc = me.isSelected() ? selc : me.getLineColor();
                if (lc == null) {
                    lc = c;
                }
                g.setColor(lc);
                double strokew = me.getThickness() * Math.abs(t.getScale());
                BasicStroke stroke = new BasicStroke((float)strokew, 2, 0);
                Stroke oldstroke = g.getStroke();
                g.setStroke(stroke);
                g.draw(new Ellipse2D.Double(ox - rx, oy - ry, 2.0 * rx, 2.0 * ry));
                if ((f & 1) != 0) {
                    GraphicsUtil.setAntialias(g, false);
                }
                g.setStroke(oldstroke);
            }
        } else {
            double alpha = p.angle2D(x[0], y[0]) - p.angle2D(x[2], y[2]);
            double r = 0.1 * me.getThickness();
            if (1.5707963267948966 - r <= alpha && alpha <= 1.5707963267948966 + r || -1.5707963267948966 - r <= alpha && alpha <= -1.5707963267948966 + r) {
                double rx = Math.hypot(x[1] - x[0], y[1] - y[0]) / 2.0;
                double ry = Math.hypot(x[0] - x[3], y[0] - y[3]) / 2.0;
                double px = x[3] + (x[0] - x[3]) / 2.0;
                double py = y[3] + (y[0] - y[3]) / 2.0;
                DPoint3 q = new DPoint3(px, py, 0.0);
                double phi = Math.PI + q.angle2D(ox, oy);
                g.rotate(phi, ox, oy);
                if (bg != null && me.hasFace()) {
                    g.setColor(bg);
                    g.fill(new Ellipse2D.Double(ox - rx, oy - ry, 2.0 * rx, 2.0 * ry));
                }
                if (me.hasOutline()) {
                    Color lc;
                    if ((f & 1) != 0) {
                        GraphicsUtil.setAntialias(g, true);
                    }
                    Color color = lc = me.isSelected() ? selc : me.getLineColor();
                    if (lc == null) {
                        lc = c;
                    }
                    g.setColor(lc);
                    double strokew = me.getThickness() * Math.abs(t.getScale());
                    BasicStroke stroke = new BasicStroke((float)strokew, 2, 0);
                    Stroke oldstroke = g.getStroke();
                    g.setStroke(stroke);
                    g.draw(new Ellipse2D.Double(ox - rx, oy - ry, 2.0 * rx, 2.0 * ry));
                    if ((f & 1) != 0) {
                        GraphicsUtil.setAntialias(g, false);
                    }
                    g.setStroke(oldstroke);
                }
                g.rotate(-phi, ox, oy);
            } else {
                double[] a = new double[4];
                double[] b = new double[4];
                double ymin = y[0];
                int j = 0;
                for (int i = 1; i < 4; ++i) {
                    if (!(y[i] < ymin)) continue;
                    ymin = y[i];
                    j = i;
                }
                a[0] = x[j];
                b[0] = y[j];
                a[2] = x[j + 2 & 3];
                b[2] = y[j + 2 & 3];
                if (Math.hypot(x[j] - x[j + 1 & 3], y[j] - y[j + 1 & 3]) > Math.hypot(x[j] - x[j + 3 & 3], y[j] - y[j + 3 & 3])) {
                    a[1] = x[j + 1 & 3];
                    b[1] = y[j + 1 & 3];
                    a[3] = x[j + 3 & 3];
                    b[3] = y[j + 3 & 3];
                } else {
                    a[1] = x[j + 3 & 3];
                    b[1] = y[j + 3 & 3];
                    a[3] = x[j + 1 & 3];
                    b[3] = y[j + 1 & 3];
                }
                p.x = a[0];
                p.y = b[0];
                alpha = p.angle2D(a[3], b[3]) - p.angle2D(a[1], b[1]);
                double beta = Math.PI - Math.abs(alpha);
                double rx = Math.hypot(a[2] - a[3], b[2] - b[3]) / 2.0;
                double ry = Math.sin(beta) == 0.0 ? Math.hypot(a[3] - a[0], b[3] - b[0]) / 2.0 * r : Math.hypot(a[3] - a[0], b[3] - b[0]) / 2.0 * Math.sin(beta);
                ry = Math.abs(ry);
                double phi = p.angle2D(a[1], b[1]);
                g.rotate(phi, ox, oy);
                if (bg != null && me.hasFace()) {
                    g.setColor(bg);
                    g.fill(new Ellipse2D.Double(ox - rx, oy - ry, 2.0 * rx, 2.0 * ry));
                }
                if (me.hasOutline()) {
                    Color lc;
                    if ((f & 1) != 0) {
                        GraphicsUtil.setAntialias(g, true);
                    }
                    Color color = lc = me.isSelected() ? selc : me.getLineColor();
                    if (lc == null) {
                        lc = c;
                    }
                    g.setColor(lc);
                    double strokew = me.getThickness() * Math.abs(t.getScale());
                    BasicStroke stroke = new BasicStroke((float)strokew, 2, 0);
                    Stroke oldstroke = g.getStroke();
                    g.setStroke(stroke);
                    g.draw(new Ellipse2D.Double(ox - rx, oy - ry, 2.0 * rx, 2.0 * ry));
                    if ((f & 1) != 0) {
                        GraphicsUtil.setAntialias(g, false);
                    }
                    g.setStroke(oldstroke);
                }
                g.rotate(-phi, ox, oy);
            }
        }
        this.paintHilight(me, g, t, f, c, selc, focusc);
        g.setColor(oldcolor);
    }
}

