/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.graphics;

import chemaxon.marvin.paint.internal.GraphicsPainter;
import chemaxon.marvin.paint.internal.util.GraphicsUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import java.awt.Color;
import java.awt.Graphics2D;

public class MPointPainter
implements GraphicsPainter {
    @Override
    public void paint(MObject mo, Graphics2D g, CTransform3D t, int f, Color c, Color selc, Color focusc) {
        MPoint mp = (MPoint)mo;
        if ((f & 1) != 0) {
            GraphicsUtil.setAntialias(g, true);
        }
        DPoint3 p = mp.getLocation(t);
        this.paintCircle(mp, g, p, t, f, c, selc);
        if ((f & 1) != 0) {
            GraphicsUtil.setAntialias(g, false);
        }
    }

    private void paintCircle(MPoint mp, Graphics2D g, DPoint3 p, CTransform3D t, int f, Color c, Color selc) {
        double d = 0.2 * t.getScale();
        int x1 = (int)Math.round(p.x - d);
        int y1 = (int)Math.round(p.y - d);
        int x2 = (int)Math.round(p.x + d);
        int y2 = (int)Math.round(p.y + d);
        int x = x1 < x2 ? x1 : x2;
        int y = y1 < y2 ? y1 : y2;
        int w = Math.abs(x1 - x2);
        int h = Math.abs(y1 - y2);
        Color old = g.getColor();
        g.setColor(Color.white);
        g.fillOval(x, y, w, h);
        g.setColor(mp.isSelected() ? selc : (c != null ? c : old));
        g.drawOval(x, y, w, h);
        g.setColor(old);
    }
}

