/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.graphics;

import chemaxon.marvin.paint.internal.GraphicsPainter;
import chemaxon.marvin.paint.internal.GraphicsPresentationChooser;
import chemaxon.marvin.paint.internal.LinePainter;
import chemaxon.marvin.paint.internal.graphics.MPointPainter;
import chemaxon.marvin.paint.internal.util.GraphicsUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MPolyline;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class MPolylinePainter
implements GraphicsPainter {
    @Override
    public void paint(MObject mo, Graphics2D g, CTransform3D t, int f, Color c, Color selc, Color focusc) {
        MPolyline mpl = (MPolyline)mo;
        int npoints = mo.getPointCount();
        DPoint3 p1 = new DPoint3(0.0, 0.0, 0.0);
        DPoint3 p2 = new DPoint3(0.0, 0.0, 0.0);
        Color bg = mo.getBackground();
        Color oldcolor = g.getColor();
        if (bg != null && mpl.hasFace()) {
            double[] x = new double[npoints];
            double[] y = new double[npoints];
            DPoint3 p = new DPoint3(0.0, 0.0, 0.0);
            for (int i = 0; i < npoints; ++i) {
                MPoint mp = mo.getPoint(i);
                mp.getLocation(p, t);
                x[i] = p.x;
                y[i] = p.y;
            }
            g.setColor(bg);
            GraphicsUtil.fillPolygon(g, x, y);
        }
        if (mpl.hasOutline()) {
            Color lc;
            if ((f & 1) != 0) {
                GraphicsUtil.setAntialias(g, true);
            }
            Color color = lc = mo.isSelected() ? selc : mo.getLineColor();
            if (lc == null) {
                lc = c;
            }
            g.setColor(lc);
            double strokew = mpl.getThickness() * Math.abs(t.getScale());
            BasicStroke stroke = new BasicStroke((float)strokew, 2, 0);
            Stroke oldstroke = g.getStroke();
            g.setStroke(stroke);
            for (int j = 1; j < npoints; ++j) {
                this.connect(mpl, g, t, j - 1, j, p1, p2, oldstroke, strokew);
            }
            if ((mpl.getFlags() & MPolyline.CLOSED_FLAG) != 0) {
                this.connect(mpl, g, t, npoints - 1, 0, p1, p2, oldstroke, strokew);
            }
            if ((f & 1) != 0) {
                GraphicsUtil.setAntialias(g, false);
            }
            g.setStroke(oldstroke);
        }
        this.paintHilight(mpl, g, t, f, c, selc, focusc);
        g.setColor(oldcolor);
    }

    public void paintHilight(MPolyline mo, Graphics2D g, CTransform3D t, int f, Color c, Color selc, Color focusc) {
        if (focusc != null || mo.isSelected()) {
            Color cc = mo.isSelected() ? selc : focusc;
            for (int i = 0; i < mo.getPointRefCount(); ++i) {
                MPoint mp = mo.getPointRef(i, t);
                GraphicsPresentationChooser gpc = new GraphicsPresentationChooser();
                GraphicsPainter mpp = gpc.getGraphicsPainter(mp.getClass());
                mpp.paint(mp, g, t, f & 1, cc, selc, focusc);
            }
        }
    }

    public void paintEndPointHilights(MPolyline mo, Graphics2D g, CTransform3D t, int f, Color c, Color selc, Color focusc) {
        if (focusc != null || mo.isSelected()) {
            Color cc = mo.isSelected() ? selc : focusc;
            MPoint[] endPs = mo.getPoints();
            MPointPainter mpp = new MPointPainter();
            mpp.paint(endPs[0], g, t, f & 1, cc, selc, focusc);
            mpp.paint(endPs[1], g, t, f & 1, cc, selc, focusc);
        }
    }

    protected void connect(MPolyline mo, Graphics2D g, CTransform3D t, int i1, int i2, DPoint3 p1, DPoint3 p2, Stroke arrowstroke, double strokew) {
        MPoint mp1 = mo.getPoint(i1);
        mp1.getLocation(p1, t);
        MPoint mp2 = mo.getPoint(i2);
        mp2.getLocation(p2, t);
        double[] arw = mo.isArrow() ? new double[2] : null;
        double scale = Math.abs(t.getScale());
        double[] skips = null;
        if (mo.getSkip(0) != 0.0 || mo.getSkip(1) != 0.0) {
            skips = new double[2];
            for (int i = 0; i < 2; ++i) {
                skips[i] = mo.getSkip(i) * scale;
            }
        }
        double[] ct = null;
        DPoint3[] q1 = null;
        DPoint3[] q2 = null;
        DPoint3 p1orig = p1;
        DPoint3 p2orig = p2;
        double sign = t.determinant2D() > 0.0 ? -1.0 : 1.0;
        double angle = sign * mo.getArcAngle();
        if (mo.isArrow()) {
            q1 = new DPoint3[2];
            q2 = new DPoint3[2];
            double[] angle1 = new double[1];
            ct = new double[2];
            DPoint3[] p12new = this.calcArrowHeads(mo, p1orig, p2orig, scale, angle, q1, q2, arw, angle1, ct);
            angle = angle1[0];
            p1 = p12new[0];
            p2 = p12new[1];
        }
        Stroke oldstroke = null;
        if (mo.isArrow() || skips != null) {
            double[] tmpx = new double[4];
            double[] tmpy = new double[4];
            if (mo.isArrow()) {
                oldstroke = g.getStroke();
                g.setStroke(arrowstroke);
            }
            for (int i = 0; i < 2; ++i) {
                int arf;
                DPoint3 pfront;
                DPoint3 pback = q1 != null ? q1[i] : null;
                DPoint3 dPoint3 = pfront = q2 != null ? q2[i] : null;
                if (skips != null) {
                    double d = MPolylinePainter.shiftEndPoint(mo, skips[i], p1orig, p2orig, p1, p2, i, pfront, pback, sign);
                    angle -= d;
                }
                if (!mo.isArrow() || arw[i] == 0.0) continue;
                if ((mo.getArrowFlags(i) & MPolyline.ARROW_BACK_FLAG) != 0) {
                    DPoint3 tmp = pfront;
                    pfront = pback;
                    pback = tmp;
                    arf = this.getMirroredArrowFlags(mo, i);
                } else {
                    arf = mo.getArrowFlags(i);
                }
                LinePainter.drawArrowHead(g, pback, pfront, ct[i], tmpx, tmpy, arf);
            }
            if (mo.isArrow()) {
                BasicStroke stroke = new BasicStroke((float)strokew, 0, 0);
                g.setStroke(stroke);
            }
        }
        if (angle == 0.0) {
            GraphicsUtil.drawLine(g, p1.x, p1.y, p2.x, p2.y);
        } else {
            GraphicsUtil.drawArc(g, p1, p2, angle);
        }
        if (mo.isArrow()) {
            g.setStroke(oldstroke);
        }
    }

    protected DPoint3[] calcArrowHeads(MPolyline mo, DPoint3 p1orig, DPoint3 p2orig, double scale, double angle, DPoint3[] q1, DPoint3[] q2, double[] arw, double[] angle1, double[] ct) {
        double alpha = angle * Math.PI / 180.0;
        boolean isArc = alpha != 0.0;
        for (int i = 0; i < 2; ++i) {
            arw[i] = mo.getArrowWidth(i) * scale;
        }
        double lx = p2orig.x - p1orig.x;
        double ly = p2orig.y - p1orig.y;
        double lz = p2orig.z - p1orig.z;
        double l = Math.sqrt(lx * lx + ly * ly + lz * lz);
        DPoint3 p1 = p1orig;
        DPoint3 p2 = p2orig;
        double arcR = isArc ? MPolyline.getArcRadius(p1orig, p2orig, alpha * 180.0 / Math.PI) : 0.0;
        double dalpha = 0.0;
        for (int i = 0; i < 2; ++i) {
            double arl = mo.getArrowLength(i) * scale;
            if (l != 0.0 && arl != 0.0) {
                double cl = arl / l;
                ct[i] = 0.5 * arw[i] / arl;
                double lambda = 0.0;
                double asin = arl / (2.0 * arcR);
                if (arl / (2.0 * arcR) > 1.0) {
                    asin = 1.0;
                }
                if (arl / (2.0 * arcR) < -1.0) {
                    asin = -1.0;
                }
                if (isArc) {
                    lambda = Math.asin(asin);
                    if (alpha < 0.0) {
                        lambda = -lambda;
                    }
                }
                if (i == MPolyline.HEAD) {
                    q1[i] = new DPoint3(p2orig.x - cl * lx, p2orig.y - cl * ly, p2orig.z - cl * lz);
                    q2[i] = new DPoint3(p2orig);
                } else {
                    q1[i] = new DPoint3(p1orig);
                    q2[i] = new DPoint3(p1orig.x + cl * lx, p1orig.y + cl * ly, p1orig.z + cl * lz);
                }
                if (i == MPolyline.HEAD) {
                    p2 = q1[i];
                } else {
                    p1 = q2[i];
                }
                if (isArc) {
                    double phi = alpha / 2.0 - lambda;
                    if (i == MPolyline.HEAD) {
                        MPolylinePainter.rotate(q2[i], phi, q1[i]);
                    } else {
                        MPolylinePainter.rotate(q1[i], -phi, q2[i]);
                    }
                }
                dalpha -= 2.0 * lambda;
                continue;
            }
            arw[i] = 0.0;
        }
        angle1[0] = (alpha + dalpha) * 180.0 / Math.PI;
        return new DPoint3[]{p1, p2};
    }

    protected int getMirroredArrowFlags(MPolyline mo, int i) {
        int f = mo.getArrowFlags(i);
        int half = f & MPolyline.ARROW_HALF_MASK;
        int f0 = f & ~MPolyline.ARROW_HALF_MASK;
        if (half == MPolyline.ARROW_HALF_LEFT) {
            return f0 | MPolyline.ARROW_HALF_RIGHT;
        }
        if (half == MPolyline.ARROW_HALF_RIGHT) {
            return f0 | MPolyline.ARROW_HALF_LEFT;
        }
        return f;
    }

    static void rotate(DPoint3 p0, double dphi, DPoint3 p) {
        double phi = Math.atan2(p.y - p0.y, p.x - p0.x);
        double r = p0.distance2D(p);
        p.x = p0.x + r * Math.cos(phi += dphi);
        p.y = p0.y + r * Math.sin(phi);
    }

    static double shiftEndPoint(MPolyline l, double skip, DPoint3 p1o, DPoint3 p2o, DPoint3 p1, DPoint3 p2, int i, DPoint3 pfront, DPoint3 pback, double sign) {
        double angle = sign * l.getArcAngle();
        if (angle != 0.0) {
            double dalpha;
            double phi = angle * Math.PI / 180.0;
            DPoint3 p0 = MPolyline.getArcCenter(p1o, p2o, angle);
            double r = p0.distance(p1o);
            double dphi = dalpha = phi < 0.0 ? -skip / r : skip / r;
            if (i == MPolyline.HEAD) {
                MPolyline.rotate(p0, -dphi, p2);
                dphi = -dphi;
            } else {
                MPolyline.rotate(p0, dphi, p1);
            }
            if (pfront != null && pfront != p1 && pfront != p2) {
                MPolyline.rotate(p0, dphi, pfront);
            }
            if (pback != null && pback != p1 && pback != p2) {
                MPolyline.rotate(p0, dphi, pback);
            }
            return dalpha * 180.0 / Math.PI;
        }
        double r12 = p1o.distance(p2o);
        double ex12 = (p2o.x - p1o.x) / r12;
        double ey12 = (p2o.y - p1o.y) / r12;
        double ez12 = (p2o.z - p1o.z) / r12;
        double dx = ex12 * skip;
        double dy = ey12 * skip;
        double dz = ez12 * skip;
        if (i == MPolyline.HEAD) {
            p2.x -= dx;
            p2.y -= dy;
            p2.z -= dz;
            dx = -dx;
            dy = -dy;
            dz = -dz;
        } else {
            p1.x += dx;
            p1.y += dy;
            p1.z += dz;
        }
        if (pfront != null && pfront != p1 && pfront != p2) {
            pfront.x += dx;
            pfront.y += dy;
            pfront.z += dz;
        }
        if (pback != null && pback != p1 && pback != p2) {
            pback.x += dx;
            pback.y += dy;
            pback.z += dz;
        }
        return 0.0;
    }
}

