/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.graphics;

import chemaxon.marvin.paint.internal.graphics.MPolylinePainter;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.graphics.MRectangle;
import java.awt.Color;
import java.awt.Graphics2D;

public class MRectanglePainter
extends MPolylinePainter {
    @Override
    public void paint(MObject mo, Graphics2D g, CTransform3D t, int f, Color c, Color selc, Color focusc) {
        MRectangle mr = (MRectangle)mo;
        t = this.convertTransform(mr, t, true);
        super.paint(mr, g, t, f, c, selc, focusc);
    }

    protected CTransform3D convertTransform(MRectangle mr, CTransform3D t, boolean paint) {
        if ((mr.getTOption() & 1) != 0) {
            DPoint3 p0 = new DPoint3();
            mr.calcCenter(p0, null);
            double scale = t.getScale();
            DPoint3 p = new DPoint3(p0);
            t.transform(p);
            t = new CTransform3D();
            t.setZero();
            if (paint && scale < 0.0) {
                t.m00 = -scale;
                t.m11 = scale;
                t.m22 = -scale;
                t.m03 = p.x + scale * p0.x;
                t.m13 = p.y - scale * p0.y;
                t.m23 = p.z + scale * p0.z;
            } else {
                t.m00 = scale;
                t.m11 = scale;
                t.m22 = scale;
                t.m03 = p.x - scale * p0.x;
                t.m13 = p.y - scale * p0.y;
                t.m23 = p.z - scale * p0.z;
            }
            t.m33 = 1.0;
        }
        return t;
    }
}

