/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.graphics;

import chemaxon.marvin.paint.internal.graphics.MRectanglePainter;
import chemaxon.marvin.paint.internal.util.GraphicsUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MRoundedRectangle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

public class MRoundedRectanglePainter
extends MRectanglePainter {
    @Override
    public void paint(MObject mo, Graphics2D g, CTransform3D t, int f, Color c, Color selc, Color focusc) {
        MRoundedRectangle mrr = (MRoundedRectangle)mo;
        t = this.convertTransform(mrr, t, true);
        Color bg = mrr.getBackground();
        Color oldcolor = g.getColor();
        double[] x = new double[4];
        double[] y = new double[4];
        DPoint3 p = new DPoint3(0.0, 0.0, 0.0);
        for (int i = 0; i < 4; ++i) {
            MPoint mp = mrr.getPoint(i);
            mp.getLocation(p, t);
            x[i] = p.x;
            y[i] = p.y;
        }
        double w = Math.abs(x[2] - x[0]);
        double h = Math.abs(y[2] - y[0]);
        if (y[0] == y[1]) {
            int i = 0;
            if (x[1] < x[0] && y[3] > y[0]) {
                i = 1;
            }
            if (x[1] > x[0] && y[3] < y[0]) {
                i = 3;
            }
            if (x[1] < x[0] && y[3] < y[0]) {
                i = 2;
            }
            if (bg != null && mrr.hasFace()) {
                g.setColor(bg);
                g.fill(new RoundRectangle2D.Double(x[i], y[i], w, h, mrr.getArcWidth() * 50.0, mrr.getArcHeight() * 50.0));
            }
            if (mrr.hasOutline()) {
                Color lc;
                if ((f & 1) != 0) {
                    GraphicsUtil.setAntialias(g, true);
                }
                Color color = lc = mrr.isSelected() ? selc : mrr.getLineColor();
                if (lc == null) {
                    lc = c;
                }
                g.setColor(lc);
                double strokew = mrr.getThickness() * Math.abs(t.getScale());
                BasicStroke stroke = new BasicStroke((float)strokew, 2, 0);
                Stroke oldstroke = g.getStroke();
                g.setStroke(stroke);
                g.draw(new RoundRectangle2D.Double(x[i], y[i], w, h, mrr.getArcWidth() * 50.0, mrr.getArcHeight() * 50.0));
                if ((f & 1) != 0) {
                    GraphicsUtil.setAntialias(g, false);
                }
                g.setStroke(oldstroke);
            }
        } else {
            double d;
            int i;
            double[] a = new double[4];
            double[] b = new double[4];
            double ymin = y[0];
            int mincp = 0;
            for (i = 1; i < 4; ++i) {
                if (!(y[i] < ymin)) continue;
                ymin = y[i];
                mincp = i;
            }
            for (i = 0; i < 4; ++i) {
                a[i] = x[mincp + i & 3];
                b[i] = y[mincp + i & 3];
            }
            double alpha = p.angle2D(x[0], y[0]) - p.angle2D(x[2], y[2]);
            if (alpha <= 1.5707963267948966 + (d = 0.1 * mrr.getThickness()) && alpha >= 1.5707963267948966 - d || alpha <= 4.71238898038469 + d && alpha >= 4.71238898038469 - d || alpha <= -1.5707963267948966 + d && alpha >= -1.5707963267948966 - d) {
                p.x = a[0];
                p.y = b[0];
                if (p.angle2D(a[1], b[1]) > p.angle2D(a[3], b[3])) {
                    double tx0 = x[0];
                    double ty0 = y[0];
                    x[0] = x[2];
                    y[0] = y[2];
                    x[2] = tx0;
                    y[2] = ty0;
                }
                w = Math.hypot(x[1] - x[0], y[1] - y[0]);
                h = Math.hypot(x[0] - x[3], y[0] - y[3]);
                DPoint3 q = new DPoint3(x[3] + (x[0] - x[3]) / 2.0, y[3] + (y[0] - y[3]) / 2.0, 0.0);
                double phi = q.angle2D((x[0] + x[2]) / 2.0, (y[0] + y[2]) / 2.0);
                g.rotate(phi, x[0], y[0]);
                if (bg != null && mrr.hasFace()) {
                    g.setColor(bg);
                    g.fill(new RoundRectangle2D.Double(x[0], y[0], w, h, mrr.getArcWidth() * 50.0, mrr.getArcHeight() * 50.0));
                }
                if (mrr.hasOutline()) {
                    Color lc;
                    if ((f & 1) != 0) {
                        GraphicsUtil.setAntialias(g, true);
                    }
                    Color color = lc = mrr.isSelected() ? selc : mrr.getLineColor();
                    if (lc == null) {
                        lc = c;
                    }
                    g.setColor(lc);
                    double strokew = mrr.getThickness() * Math.abs(t.getScale());
                    BasicStroke stroke = new BasicStroke((float)strokew, 2, 0);
                    Stroke oldstroke = g.getStroke();
                    g.setStroke(stroke);
                    g.draw(new RoundRectangle2D.Double(x[0], y[0], w, h, mrr.getArcWidth() * 50.0, mrr.getArcHeight() * 50.0));
                    if ((f & 1) != 0) {
                        GraphicsUtil.setAntialias(g, false);
                    }
                    g.setStroke(oldstroke);
                }
                g.rotate(-phi, x[0], y[0]);
            } else {
                double temp;
                boolean arcchanged = false;
                if (Math.hypot(x[mincp] - x[mincp + 1 & 3], y[mincp] - y[mincp + 1 & 3]) > Math.hypot(x[mincp] - x[mincp + 3 & 3], y[mincp] - y[mincp + 3 & 3])) {
                    a[1] = x[mincp + 1 & 3];
                    b[1] = y[mincp + 1 & 3];
                    a[3] = x[mincp + 3 & 3];
                    b[3] = y[mincp + 3 & 3];
                    if ((mincp & 1) == 1) {
                        arcchanged = true;
                    }
                } else {
                    a[1] = x[mincp + 3 & 3];
                    b[1] = y[mincp + 3 & 3];
                    a[3] = x[mincp + 1 & 3];
                    b[3] = y[mincp + 1 & 3];
                    if ((mincp & 1) == 0) {
                        arcchanged = true;
                    }
                }
                p.x = a[0];
                p.y = b[0];
                double d01 = Math.hypot(a[0] - a[1], b[0] - b[1]);
                double d03 = Math.hypot(a[0] - a[3], b[0] - b[3]);
                double[] beta = new double[]{Math.PI - p.angle2D(a[1], b[1]), p.angle2D(a[3], b[3])};
                int k = 1;
                int l = 1;
                if (p.angle2D(a[1], b[1]) < beta[1]) {
                    beta[0] = Math.PI - beta[0];
                    beta[1] = Math.PI - beta[1];
                    k = -1;
                    l = 0;
                }
                int u = -1;
                int v = 1;
                boolean changeback = false;
                if (mrr.getArcHeight() >= mrr.getArcWidth()) {
                    arcchanged = !arcchanged;
                    temp = mrr.getArcHeight();
                    mrr.setArcHeight(mrr.getArcWidth());
                    mrr.setArcWidth(temp);
                    changeback = true;
                }
                if (bg != null && mrr.hasFace()) {
                    g.setColor(bg);
                    MRoundedRectanglePainter.fillRoundRect3D(g, mrr.getArcWidth(), mrr.getArcHeight(), d01, d03, beta[0], beta[1], a, b, arcchanged, k, l);
                }
                if (mrr.hasOutline()) {
                    int i2;
                    Color lc;
                    if ((f & 1) != 0) {
                        GraphicsUtil.setAntialias(g, true);
                    }
                    Color color = lc = mrr.isSelected() ? selc : mrr.getLineColor();
                    if (lc == null) {
                        lc = c;
                    }
                    g.setColor(lc);
                    double strokew = mrr.getThickness() * Math.abs(t.getScale());
                    BasicStroke stroke = new BasicStroke((float)strokew, 2, 0);
                    Stroke oldstroke = g.getStroke();
                    g.setStroke(stroke);
                    double[][] P = new double[4][2];
                    double[][] Q = new double[4][2];
                    for (i2 = 0; i2 < 4; ++i2) {
                        double[] lends = this.paint3DArc(mrr, g, d01, d03, a[i2], b[i2], i2, arcchanged, k, l, u, v, beta[0], beta[1]);
                        if (lends.length == 4) {
                            if (i2 == 1 || i2 == 3) {
                                P[i2][0] = lends[0];
                                Q[i2][0] = lends[1];
                                P[i2][1] = lends[2];
                                Q[i2][1] = lends[3];
                            } else {
                                P[i2][1] = lends[0];
                                Q[i2][1] = lends[1];
                                P[i2][0] = lends[2];
                                Q[i2][0] = lends[3];
                            }
                        }
                        u = v;
                        if (i2 != 1) continue;
                        v = -1;
                    }
                    for (i2 = 0; i2 < 2; ++i2) {
                        GraphicsUtil.drawLine(g, P[i2][i2], Q[i2][i2], P[i2 + 1][i2], Q[i2 + 1][i2]);
                        GraphicsUtil.drawLine(g, P[i2 + 2][i2], Q[i2 + 2][i2], P[i2 + 3 & 3][i2], Q[i2 + 3 & 3][i2]);
                    }
                    if ((f & 1) != 0) {
                        GraphicsUtil.setAntialias(g, false);
                    }
                    g.setStroke(oldstroke);
                }
                if (changeback) {
                    temp = mrr.getArcHeight();
                    mrr.setArcHeight(mrr.getArcWidth());
                    mrr.setArcWidth(temp);
                }
            }
        }
        this.paintHilight(mrr, g, t, f, c, selc, focusc);
        g.setColor(oldcolor);
    }

    private double[] paint3DArc(MRoundedRectangle mrr, Graphics2D g, double d01, double d03, double ai, double bi, int i, boolean changed, int k, int l, int u, int v, double beta0, double beta1) {
        double ey;
        double ex;
        DPoint3 origo;
        double epsilon;
        double delta;
        double[] leps = new double[4];
        double gamma = (i & 1) == 0 ? Math.PI - (beta0 + beta1) : beta0 + beta1;
        double arh = mrr.getArcHeight() * 25.0 * (0.5 + Math.abs(Math.sin(gamma) / 2.0));
        double arw = mrr.getArcWidth() * 25.0 * (0.5 + Math.abs(Math.sin(gamma) / 2.0));
        if (d03 < 2.0 * arh && !changed) {
            arw = d03 / (arh * 2.0) * arw;
            arh = d03 / 2.0;
        }
        if (d01 < 2.0 * arw && !changed) {
            arh = d01 / (arw * 2.0) * arh;
            arw = d01 / 2.0;
        }
        if (d03 < 2.0 * arw && changed) {
            arh = d03 / (arw * 2.0) * arh;
            arw = d03 / 2.0;
        }
        if (d01 < 2.0 * arh && changed) {
            arw = d01 / (arh * 2.0) * arw;
            arh = d01 / 2.0;
        }
        double ac = arh * Math.cos(gamma);
        double as = arh * Math.sin(gamma);
        double h = Math.abs(arw * as / (arw + ac));
        double pw = (arw + arw * (arw - ac) / (arw + ac)) / 2.0;
        double s = (arh - h / Math.sin(gamma)) * Math.cos(gamma);
        double w = Math.sqrt(Math.abs(pw * pw - pw * s));
        if (changed) {
            v -= u + v;
            u += ((i & 1) - 1) * u * 2;
            beta0 = -beta1;
        }
        double d = delta = (epsilon = Math.toDegrees((origo = new DPoint3(ai + (double)(u * k) * arw, bi + (double)v * h, 0.0)).angle2D(ex = ai + (double)(u * k) * ac, ey = bi + (double)v * as))) > 0.0 ? 90.0 + (double)(u * v * k) * ((double)(((1 - u) / 2 + u * l) * 180) - epsilon) * Math.E : 90.0 - (double)(u * v * k) * ((double)(((1 - u) / 2 + u * l) * 180) + epsilon) * Math.E;
        if ((i == 0 || i == 2) && gamma < 1.1) {
            delta *= 0.89;
        }
        if ((i == 1 || i == 3) && gamma > 2.6) {
            delta *= 0.83;
        }
        if ((i == 0 || i == 2) && gamma > 2.6) {
            delta *= 0.83;
        }
        g.rotate((double)(-k) * beta0, ai, bi);
        Arc2D.Double arc0 = new Arc2D.Double(ai + (double)(u * k) * arw - w, bi + (double)(v - 1) * h, 2.0 * w, 2.0 * h, (double)(v * 90) - (double)(u * (u + v) / 2 - u * v * l) * delta, delta, 0);
        g.draw(arc0);
        g.rotate((double)k * beta0, ai, bi);
        Point2D po0 = k == 1 ? arc0.getStartPoint() : arc0.getEndPoint();
        DPoint3 dpo0 = new DPoint3(po0.getX(), po0.getY(), 0.0);
        double z = 2.0 * Math.hypot(dpo0.x - ai, dpo0.y - bi) * Math.sin(beta0 / 2.0);
        double kszi = 1.5707963267948966 - (double)k * beta0 / 2.0 - Math.PI * 2 + dpo0.angle2D(ai, bi);
        leps[0] = dpo0.x + (double)k * z * Math.cos(kszi);
        leps[1] = dpo0.y + (double)k * z * Math.sin(kszi);
        Point2D po1 = k == 1 ? arc0.getEndPoint() : arc0.getStartPoint();
        DPoint3 dpo1 = new DPoint3(po1.getX(), po1.getY(), 0.0);
        double zs = 2.0 * Math.hypot(dpo1.x - ai, dpo1.y - bi) * Math.sin(beta0 / 2.0);
        double pszi = 1.5707963267948966 - (double)k * beta0 / 2.0 - Math.PI * 2 + dpo1.angle2D(ai, bi);
        leps[2] = dpo1.x + (double)k * zs * Math.cos(pszi);
        leps[3] = dpo1.y + (double)k * zs * Math.sin(pszi);
        return leps;
    }

    public static void fillRoundRect3D(Graphics2D g, double arcWidth, double arcHeight, double d01, double d03, double beta0, double beta1, double[] a, double[] b, boolean changed, int k, int l) {
        int j;
        Object oldsc = GraphicsUtil.beginPureStrokeControl(g);
        GeneralPath gp = new GeneralPath();
        int u = -1;
        int v = 1;
        Shape[] arc = new Shape[4];
        for (int i = 0; i < 4; ++i) {
            arc[i] = MRoundedRectanglePainter.create3DArc(g, arcWidth, arcHeight, d01, d03, a[i], b[i], i, changed, k, l, u, v, beta0, beta1);
            u = v;
            if (i != 1) continue;
            v = -1;
        }
        if (k == 1) {
            for (j = 0; j < 4; ++j) {
                gp.append(arc[j], true);
            }
        } else {
            for (j = 3; j >= 0; --j) {
                gp.append(arc[j], true);
            }
        }
        gp.closePath();
        g.fill(gp);
        GraphicsUtil.endPureStrokeControl(g, oldsc);
    }

    private static Shape create3DArc(Graphics2D g, double arcWidth, double arcHeight, double d01, double d03, double ai, double bi, int i, boolean changed, int k, int l, int u, int v, double beta0, double beta1) {
        double ey;
        double ex;
        DPoint3 origo;
        double epsilon;
        double delta;
        double gamma = (i & 1) == 0 ? Math.PI - (beta0 + beta1) : beta0 + beta1;
        double arh = arcHeight * 25.0 * (0.5 + Math.abs(Math.sin(gamma) / 2.0));
        double arw = arcWidth * 25.0 * (0.5 + Math.abs(Math.sin(gamma) / 2.0));
        if (d03 < 2.0 * arh && !changed) {
            arw = d03 / (arh * 2.0) * arw;
            arh = d03 / 2.0;
        }
        if (d01 < 2.0 * arw && !changed) {
            arh = d01 / (arw * 2.0) * arh;
            arw = d01 / 2.0;
        }
        if (d03 < 2.0 * arw && changed) {
            arh = d03 / (arw * 2.0) * arh;
            arw = d03 / 2.0;
        }
        if (d01 < 2.0 * arh && changed) {
            arw = d01 / (arh * 2.0) * arw;
            arh = d01 / 2.0;
        }
        double ac = arh * Math.cos(gamma);
        double as = arh * Math.sin(gamma);
        double h = Math.abs(arw * as / (arw + ac));
        double pw = (arw + arw * (arw - ac) / (arw + ac)) / 2.0;
        double s = (arh - h / Math.sin(gamma)) * Math.cos(gamma);
        double w = Math.sqrt(Math.abs(pw * pw - pw * s));
        if (changed) {
            v -= u + v;
            u += ((i & 1) - 1) * u * 2;
            beta0 = -beta1;
        }
        double d = delta = (epsilon = Math.toDegrees((origo = new DPoint3(ai + (double)(u * k) * arw, bi + (double)v * h, 0.0)).angle2D(ex = ai + (double)(u * k) * ac, ey = bi + (double)v * as))) > 0.0 ? 90.0 + (double)(u * v * k) * ((double)(((1 - u) / 2 + u * l) * 180) - epsilon) * Math.E : 90.0 - (double)(u * v * k) * ((double)(((1 - u) / 2 + u * l) * 180) + epsilon) * Math.E;
        if ((i == 0 || i == 2) && gamma < 1.1) {
            delta *= 0.89;
        }
        if ((i == 1 || i == 3) && gamma > 2.6) {
            delta *= 0.83;
        }
        if ((i == 0 || i == 2) && gamma > 2.6) {
            delta *= 0.83;
        }
        AffineTransform at = g.getTransform();
        AffineTransform t = new AffineTransform();
        t.setToRotation((double)(-k) * beta0, ai, bi);
        at.rotate((double)(-k) * beta0, ai, bi);
        Arc2D.Double arc0 = new Arc2D.Double(ai + (double)(u * k) * arw - w, bi + (double)(v - 1) * h, 2.0 * w, 2.0 * h, (double)(v * 90) - (double)(u * (u + v) / 2 - u * v * l) * delta, delta, 0);
        return t.createTransformedShape(arc0);
    }
}

