/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.graphics;

import chemaxon.marvin.paint.internal.graphics.MRectanglePainter;
import chemaxon.marvin.paint.internal.util.GraphicsUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MNameTextBox;
import chemaxon.struc.graphics.MTextAttributes;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.graphics.MTextDocument;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class MTextBoxPainter
extends MRectanglePainter {
    @Override
    public void paint(MObject mo, Graphics2D g, CTransform3D t0, int f, Color c, Color selc, Color focusc) {
        Color bg;
        MTextBox tbox = (MTextBox)mo;
        CTransform3D t = tbox.convertTransform(t0, true);
        double absfontscale = 0.6160000000000001 * tbox.getFontScale() / 100.0;
        MPoint mp0 = tbox.getPoint(0);
        MPoint mp1 = tbox.getPoint(1);
        MPoint mp2 = tbox.getPoint(2);
        MPoint mp3 = tbox.getPoint(3);
        DPoint3 p0 = mp0.getLocation(t);
        DPoint3 p1 = mp1.getLocation(t);
        DPoint3 p2 = mp2.getLocation(t);
        DPoint3 p3 = mp3.getLocation(t);
        double rx01 = p1.x - p0.x;
        double ry01 = p1.y - p0.y;
        double rz01 = p1.z - p0.z;
        double r01 = Math.sqrt(rx01 * rx01 + ry01 * ry01 + rz01 * rz01);
        double rx03 = p3.x - p0.x;
        double ry03 = p3.y - p0.y;
        double rz03 = p3.z - p0.z;
        double r03 = Math.sqrt(rx03 * rx03 + ry03 * ry03 + rz03 * rz03);
        double rx12 = p2.x - p1.x;
        double ry12 = p2.y - p1.y;
        double rz12 = p2.z - p1.z;
        double r12 = Math.sqrt(rx12 * rx12 + ry12 * ry12 + rz12 * rz12);
        double ex01 = 1.0;
        double ey01 = 0.0;
        double ez01 = 0.0;
        double ex03 = 0.0;
        double ey03 = 1.0;
        double ez03 = 0.0;
        double ex12 = 0.0;
        double ey12 = 1.0;
        double ez12 = 0.0;
        double scale = Math.abs(t.getScale() * absfontscale);
        double epsilon = 0.1 * scale;
        if (r01 > epsilon) {
            ex01 = rx01 / r01;
            ey01 = ry01 / r01;
            ez01 = rz01 / r01;
        }
        if (r03 > epsilon) {
            ex03 = rx03 / r03;
            ey03 = ry03 / r03;
            ez03 = rz03 / r03;
        }
        if (r12 > epsilon) {
            ex12 = rx12 / r12;
            ey12 = ry12 / r12;
            ez12 = rz12 / r12;
        }
        tbox.setCurrentHeight(Math.sqrt(rx03 * rx03 + ry03 * ry03 + rz03 * rz03) / scale);
        Font oldfont = g.getFont();
        g.setFont(tbox.getBaseFont().getAWTFont());
        FontMetrics fm = g.getFontMetrics();
        MFont dmf = tbox.getBaseFont();
        tbox.setCurrentDefaultFontMetrics(fm);
        this.wrap(tbox, g, dmf, fm, p0, p1, scale);
        AffineTransform oldt = MTextBoxPainter.setAffineTransform(g, p0.x, p0.y, ex01 * scale, ey01 * scale, ex03 * scale, ey03 * scale);
        double textHeight = this.getTextHeight(tbox, g, fm);
        if (tbox.isAutoHeight() || tbox.isAutoSize()) {
            if (textHeight != tbox.getCurrentHeight() && textHeight >= tbox.getMinimumHeight() || tbox.isAutoSize()) {
                this.doAutoSize(tbox, t, mp0, p0, p1, p3, textHeight, scale, ex01, ey01, ez01, ex03, ey03, ez03, ex12, ey12, ez12);
            }
            tbox.setAutoHeight(false);
        } else if (!tbox.isMinimumHeightSet()) {
            tbox.setMinimumHeight(tbox.getCurrentHeight());
            tbox.setMinimumHeightSet(true);
        }
        g.setTransform(oldt);
        super.paint(tbox, g, t0, f, c, selc, focusc);
        Shape oldclip = g.getClip();
        if (!g.getClass().getName().equals("org.freehep.graphicsio.emf.EMFGraphics2D") && !g.getClass().getName().equals("org.freehep.graphicsio.pdf.PDFGraphics2D")) {
            if (oldclip == null) {
                g.setClip(tbox.getClip(t));
            } else {
                g.setClip(tbox.getClip(t).getBounds2D().createIntersection(oldclip.getBounds2D()));
            }
        }
        MTextBoxPainter.setAffineTransform(g, p0.x, p0.y, ex01 * scale, ey01 * scale, ex03 * scale, ey03 * scale);
        Color old = g.getColor();
        if (c != null) {
            g.setColor(c);
        }
        if ((bg = tbox.getBackground()) == null) {
            bg = new Color(~g.getColor().getRGB());
        }
        double[] sublevX = new double[256];
        if ((f & 1) != 0) {
            GraphicsUtil.setAntialias(g, true);
        }
        double y = this.alignVertically(tbox, textHeight);
        for (int i = 0; i < tbox.getLineCount(); ++i) {
            MTextDocument.Portion line = tbox.getLine(i);
            double ytop = y;
            y += line.getAscent(g, fm);
            double x = p0.x;
            if (this.isLineAligned(tbox, i)) {
                x += this.alignHorizontally(tbox, line.portionWidth(g, dmf, fm));
            }
            if (ytop < tbox.getCurrentHeight()) {
                if (line.endsWith('\n')) {
                    line = line.getPortion(0, line.length() - 1);
                }
                sublevX[0] = x;
                this.drawText(tbox, g, fm, line, i, x, p0.y + y, c, bg, sublevX);
            }
            y += line.getDescent(g, fm);
        }
        if ((f & 2) != 0 && tbox.isEditable()) {
            this.drawCursor(tbox, g, p0, dmf, fm, focusc, textHeight);
        }
        if ((f & 1) != 0) {
            GraphicsUtil.setAntialias(g, false);
        }
        g.setTransform(oldt);
        g.setClip(oldclip);
        g.setColor(old);
        g.setFont(oldfont);
    }

    private void doAutoSize(MTextBox tbox, CTransform3D t, MPoint mp0, DPoint3 p0, DPoint3 p1, DPoint3 p3, double textHeight, double scale, double ex01, double ey01, double ez01, double ex03, double ey03, double ez03, double ex12, double ey12, double ez12) {
        boolean oldResizing = false;
        if (tbox instanceof MNameTextBox) {
            oldResizing = ((MNameTextBox)tbox).isAutoResize();
        }
        CTransform3D inv = new CTransform3D(t);
        inv.invert();
        int halign = tbox.getHorizontalAlignment();
        int valign = tbox.getVerticalAlignment();
        tbox.setCurrentHeight(textHeight);
        double h = textHeight * scale;
        double w = tbox.getCurrentWidth() * scale;
        if (tbox.isAutoSize()) {
            if (halign != 0 || valign != 0) {
                if (halign == 1) {
                    double x01 = (p0.x + p1.x) / 2.0;
                    double y01 = (p0.y + p1.y) / 2.0;
                    double z01 = (p0.z + p1.z) / 2.0;
                    p0.x = x01 - 0.5 * ex01 * w;
                    p0.y = y01 - 0.5 * ey01 * w;
                    p0.z = z01 - 0.5 * ez01 * w;
                } else if (halign == 2) {
                    p0.x = p1.x - ex01 * w;
                    p0.y = p1.y - ey01 * w;
                    p0.z = p1.z - ez01 * w;
                }
                if (valign == 1) {
                    double x03 = (p0.x + p3.x) / 2.0;
                    double y03 = (p0.y + p3.y) / 2.0;
                    double z03 = (p0.z + p3.z) / 2.0;
                    p0.x = x03 - 0.5 * ex03 * h;
                    p0.y = y03 - 0.5 * ey03 * h;
                    p0.z = z03 - 0.5 * ez03 * h;
                } else if (valign == 2) {
                    p0.x = p3.x - ex03 * h;
                    p0.y = p3.y - ey03 * h;
                    p0.z = p3.z - ez03 * h;
                }
                DPoint3 p0new = new DPoint3(p0);
                inv.transform(p0new);
                mp0 = new MPoint(p0new);
            }
            p1 = new DPoint3(p0);
            p1.x += ex01 * w;
            p1.y += ey01 * w;
            p1.z += ez01 * w;
        } else {
            p1 = new DPoint3(p1);
        }
        DPoint3 q2 = new DPoint3(p1);
        DPoint3 q3 = new DPoint3(p0);
        q2.x += ex12 * h;
        q2.y += ey12 * h;
        q2.z += ez12 * h;
        q3.x += ex03 * h;
        q3.y += ey03 * h;
        q3.z += ez03 * h;
        inv.transform(p1);
        inv.transform(q2);
        inv.transform(q3);
        MPoint[] corners = new MPoint[]{mp0, new MPoint(p1), new MPoint(q2), new MPoint(q3)};
        tbox.setPoints(corners);
        if (oldResizing) {
            ((MNameTextBox)tbox).setAutoResize(true);
        }
    }

    private void drawText(MTextBox tbox, Graphics2D g, FontMetrics fm, MTextDocument.Portion line, int i, double x, double y, Color c, Color bg, double[] sublevX) {
        if (tbox.hasSelection()) {
            if (i > tbox.getSelectionStartRow() && i < tbox.getSelectionEndRow()) {
                g.setColor(bg);
                this.drawTextLine(tbox, g, fm, c, line, x, y, sublevX);
                g.setColor(c);
                return;
            }
            if (i == tbox.getSelectionStartRow()) {
                MTextDocument.Portion s = line.getPortion(0, tbox.getSelectionStartColumn());
                this.drawTextLine(tbox, g, fm, null, s, x, y, sublevX);
                g.setColor(bg);
                if (tbox.getSelectionEndRow() == tbox.getSelectionStartRow() && tbox.getSelectionEndColumn() <= line.length()) {
                    s = line.getPortion(0, tbox.getSelectionEndColumn());
                    this.drawTextLine(tbox, g, fm, c, s, tbox.getSelectionStartColumn(), x, y, sublevX);
                    g.setColor(c);
                    this.drawTextLine(tbox, g, fm, null, line, tbox.getSelectionEndColumn(), x, y, sublevX);
                } else {
                    this.drawTextLine(tbox, g, fm, c, line, tbox.getSelectionStartColumn(), x, y, sublevX);
                    g.setColor(c);
                }
                return;
            }
            if (i == tbox.getSelectionEndRow()) {
                g.setColor(bg);
                MTextDocument.Portion s = line.getPortion(0, tbox.getSelectionEndColumn());
                this.drawTextLine(tbox, g, fm, c, s, x, y, sublevX);
                g.setColor(c);
                this.drawTextLine(tbox, g, fm, null, line, tbox.getSelectionEndColumn(), x, y, sublevX);
                return;
            }
        }
        this.drawTextLine(tbox, g, fm, null, line, x, y, sublevX);
    }

    private void drawTextLine(MTextBox tbox, Graphics2D g, FontMetrics fm, Color bg, MTextDocument.Portion line, int nskip, double x, double y, double[] sublevX) {
        if (nskip > 0) {
            MFont df = tbox.getBaseFont();
            double w = line.getPortion(0, nskip).portionWidth(g, df, fm);
            line = line.getPortion(nskip, line.length());
            x += w;
        }
        this.drawTextLine(tbox, g, fm, bg, line, x, y, sublevX);
    }

    private void drawTextLine(MTextBox tbox, Graphics2D g, FontMetrics fm0, Color bg, MTextDocument.Portion line, double x, double y, double[] sublevX) {
        if (line.length() == 0) {
            return;
        }
        int starti = line.getStartPos();
        int endi = line.getEndPos();
        int startk = tbox.getTextDocument().getSectionIndexOfCharAt(starti);
        int endk = tbox.getTextDocument().getSectionIndexOfCharAt(endi);
        MTextDocument.Section sec = tbox.getTextDocument().getSection(startk);
        MTextAttributes secattrs = sec.getAttributes();
        byte sublev = secattrs.getSubLevel();
        int i0 = sec.getPosition();
        double dy = tbox.getTextDocument().getSectionShiftY(startk);
        Color oldc = g.getColor();
        if (startk == endk) {
            String s = line.getPlainText();
            x = this.drawString(tbox, g, x, y - dy, s, startk, oldc, bg);
            tbox.getTextDocument().updateSubLevel(sublevX, x, startk);
        } else {
            double dx;
            String s = sec.substring(starti - i0);
            x = this.drawString(tbox, g, x, y - dy, s, startk, oldc, bg);
            tbox.getTextDocument().updateSubLevel(sublevX, x, startk);
            for (int k = startk + 1; k < endk; ++k) {
                sec = tbox.getTextDocument().getSection(k);
                secattrs = sec.getAttributes();
                s = sec.getString();
                byte newsublev = secattrs.getSubLevel();
                if (newsublev != 0 && newsublev == -sublev) {
                    x = sublevX[Math.abs(sublev) - 1];
                }
                sublev = newsublev;
                dx = secattrs.getDx();
                dy = tbox.getTextDocument().getSectionShiftY(k);
                x = this.drawString(tbox, g, x + dx, y - dy, s, k, oldc, bg);
                tbox.getTextDocument().updateSubLevel(sublevX, x, k);
            }
            if (endk < tbox.getTextDocument().getSectionCount() && endi != (i0 = (sec = tbox.getTextDocument().getSection(endk)).getPosition())) {
                secattrs = sec.getAttributes();
                byte newsublev = secattrs.getSubLevel();
                if (newsublev != 0 && newsublev == -sublev) {
                    x = sublevX[Math.abs(sublev) - 1];
                }
                sublev = newsublev;
                s = sec.substring(0, endi - i0);
                dx = secattrs.getDx();
                dy = tbox.getTextDocument().getSectionShiftY(endk);
                x = this.drawString(tbox, g, x + dx, y - dy, s, endk, oldc, bg);
                tbox.getTextDocument().updateSubLevel(sublevX, x, endk);
            }
        }
        g.setColor(oldc);
    }

    private double drawString(MTextBox tbox, Graphics2D g, double x, double y, String s, int k, Color oldc, Color bg) {
        FontMetrics fm;
        Font ft;
        MTextDocument texdoc = tbox.getTextDocument();
        MTextDocument.Section sec = texdoc.getSection(k);
        MTextAttributes secattr = sec.getAttributes();
        MFont mft = secattr.getBaseFont();
        MFont deffnt = tbox.getBaseFont();
        double scale = secattr.getScale();
        if (mft != null) {
            ft = mft.getScaledAWTFont(Float.valueOf((float)scale));
            g.setFont(ft);
            fm = sec.getFontMetrics(g, deffnt);
        } else {
            ft = deffnt.getScaledAWTFont(Float.valueOf((float)scale));
            g.setFont(ft);
            fm = g.getFontMetrics();
        }
        Color fg = secattr.getForeground();
        g.setColor(fg != null ? fg : oldc);
        if (bg != null) {
            Color c = g.getColor();
            int ascent = fm.getAscent();
            int descent = fm.getDescent();
            int w = fm.stringWidth(s);
            g.setColor(bg);
            g.fillRect((int)Math.round(x), (int)Math.round(y - (double)ascent), w, ascent + descent);
            g.setColor(c);
        }
        g.drawString(s, (float)x, (float)y);
        return x + sec.doubleStringWidth(s, mft, fm, g);
    }

    private void drawCursor(MTextBox tbox, Graphics2D g, DPoint3 p0, MFont df, FontMetrics fm0, Color focusc, double textHeight) {
        if ((focusc != null || tbox.isSelected() && tbox.isEmpty()) && tbox.getCursorPos() >= 0) {
            FontMetrics fm;
            boolean align;
            double textWidth;
            double ascent;
            double w = 0.0;
            if (tbox.getCursorColumn() > 0 && tbox.getCursorRow() < tbox.getLineCount()) {
                MTextDocument.Portion s = tbox.getLine(tbox.getCursorRow());
                if (s.endsWith('\n')) {
                    s = s.getPortion(0, s.length() - 1);
                }
                s = s.getPortion(0, tbox.getCursorColumn());
                w = s.portionWidth(g, df, fm0);
            }
            double y = this.alignVertically(tbox, textHeight);
            for (int i = 0; i < tbox.getCursorRow(); ++i) {
                MTextDocument.Portion line = tbox.getLine(i);
                double ascent2 = line.getAscent(g, fm0);
                double descent = line.getDescent(g, fm0);
                y += ascent2 + descent;
            }
            int crspos = Math.min(Math.max(tbox.getCursorPos(), 0), Math.max(tbox.getTextDocument().length() - 1, 0));
            int k = tbox.getTextDocument().getSectionIndexOfCharAt(crspos);
            MTextDocument.Section sec = tbox.getTextDocument().getSection(k);
            if (tbox.getCursorPos() != tbox.getTextDocument().length() && sec.getPosition() == crspos && k > 0) {
                sec = tbox.getTextDocument().getSection(--k);
            }
            MTextAttributes secattr = sec.getAttributes();
            if (tbox.getLineCount() == 0) {
                ascent = fm0.getAscent();
                textWidth = 0.0;
                align = true;
            } else {
                MTextDocument.Portion line = tbox.getLine(tbox.getCursorRow());
                ascent = line.getAscent(g, fm0);
                textWidth = line.portionWidth(g, df, fm0);
                align = this.isLineAligned(tbox, tbox.getCursorRow());
            }
            double x1 = p0.x + w;
            if (align) {
                x1 += this.alignHorizontally(tbox, textWidth);
            }
            double y1 = p0.y + ascent + y;
            MTextAttributes attr = tbox.getTextAttributesAtCursor();
            MFont deffnt = tbox.getBaseFont();
            if (attr != null) {
                MFont mft = attr.getBaseFont();
                if (mft == null) {
                    mft = deffnt;
                }
                byte secl = secattr.getSubLevel();
                byte l = attr.getSubLevel();
                double scale = attr.getScale();
                double ftsz = mft.getSizeDouble() * scale;
                Font aft = mft.getAWTFont();
                Font ft = mft.getScaledAWTFont(Float.valueOf((float)scale));
                if (Math.abs(secl) < Math.abs(l)) {
                    y1 -= tbox.getTextDocument().getSectionShiftY(k) + attr.getDy() * ftsz;
                    fm = g.getFontMetrics(ft);
                } else if (l == -secl || Math.abs(secl) > Math.abs(l)) {
                    int k0 = tbox.getPreviousNormalTextSectionIndex();
                    if (k0 >= 0) {
                        y1 -= tbox.getTextDocument().getSectionShiftY(k0);
                    }
                    y1 -= attr.getDy() * ftsz;
                    fm = g.getFontMetrics(ft);
                } else {
                    fm = sec.getFontMetrics(g, deffnt);
                    y1 -= tbox.getTextDocument().getSectionShiftY(k);
                }
            } else {
                fm = sec.getFontMetrics(g, deffnt);
                y1 -= tbox.getTextDocument().getSectionShiftY(k);
            }
            if (fm == null) {
                fm = fm0;
            }
            ascent = fm.getAscent();
            double descent = fm.getDescent();
            g.drawLine((int)Math.round(x1), (int)Math.round(y1 + descent), (int)Math.round(x1), (int)Math.round(y1 - ascent));
        }
    }

    private void wrap(MTextBox tbox, Graphics2D g, MFont dmfont, FontMetrics fm, DPoint3 p0, DPoint3 p1, double scale) {
        MTextDocument.Portion s;
        double rx = p1.x - p0.x;
        double ry = p1.y - p0.y;
        double rz = p1.z - p0.z;
        if (tbox.isAutoSize()) {
            tbox.setCurrentWidth(0.0);
        } else {
            tbox.setCurrentWidth(Math.sqrt(rx * rx + ry * ry + rz * rz) / scale);
        }
        tbox.clearLines();
        int i0 = 0;
        boolean needswrap = false;
        tbox.setCursorRow(0);
        for (int i = 0; i < tbox.getTextDocument().length() && !needswrap; ++i) {
            double cw;
            char c = tbox.getTextDocument().charAt(i);
            if (c != '\n') continue;
            MTextDocument.Portion s2 = tbox.getTextDocument().getPortion(i0, i);
            double w = s2.portionWidth(g, dmfont, fm);
            if (tbox.isAutoSize() && w > tbox.getCurrentWidth()) {
                tbox.setCurrentWidth(w);
            }
            if (w <= (cw = (double)Math.round(tbox.getCurrentWidth())) || tbox.isAutoSize()) {
                tbox.addLine(tbox.getTextDocument().getPortion(i0, i + 1));
                i0 = i + 1;
                tbox.setRowAndColumn0(i0);
                continue;
            }
            needswrap = true;
        }
        if (!needswrap && (s = tbox.getTextDocument().getPortion(i0, tbox.getTextDocument().length())).length() != 0) {
            double cw;
            double w = s.portionWidth(g, dmfont, fm);
            if (tbox.isAutoSize() && w > tbox.getCurrentWidth()) {
                tbox.setCurrentWidth(w);
            }
            if (w <= (cw = (double)Math.round(tbox.getCurrentWidth())) || tbox.isAutoSize()) {
                tbox.addLine(s);
            } else {
                needswrap = true;
            }
        }
        if (needswrap) {
            MTextBoxPainter.wrap(tbox, i0, g, dmfont, fm);
        }
        if (tbox.getTextDocument().endsWith('\n')) {
            tbox.addLine(tbox.getTextDocument().getPortion(tbox.getTextDocument().length(), tbox.getTextDocument().length()));
        }
    }

    private boolean isLineAligned(MTextBox tbox, int i) {
        if (i == 0) {
            return true;
        }
        int p = tbox.getLine(i - 1).getEndPos();
        int c = p > 0 ? (int)tbox.getTextDocument().charAt(p - 1) : 0;
        return " \t\n".indexOf(c) >= 0;
    }

    private double alignHorizontally(MTextBox tbox, double w) {
        double x = 0.0;
        if (tbox.getHorizontalAlignment() != 0) {
            x = tbox.getHorizontalAlignment() == 2 ? tbox.getCurrentWidth() - w : (tbox.getCurrentWidth() - w) / 2.0;
        }
        return x;
    }

    private double alignVertically(MTextBox tbox, double h) {
        double y = 0.0;
        if (tbox.getVerticalAlignment() != 0) {
            y = tbox.getVerticalAlignment() == 2 ? tbox.getCurrentHeight() - h : (tbox.getCurrentHeight() - h) / 2.0;
        }
        return y;
    }

    private double getTextHeight(MTextBox tbox, Graphics2D g, FontMetrics fm0) {
        int nlines = tbox.getLineCount();
        double h = 0.0;
        if (nlines == 0) {
            h = fm0.getAscent() + fm0.getDescent();
        } else {
            for (int i = 0; i < nlines; ++i) {
                MTextDocument.Portion line = tbox.getLine(i);
                double ascent = line.getAscent(g, fm0);
                double descent = line.getDescent(g, fm0);
                h += ascent + descent;
            }
        }
        return h;
    }

    static void wrap(MTextBox tbox, int i0, Graphics g, MFont dmfont, FontMetrics fm) {
        MTextDocument text = tbox.getTextDocument();
        MTextDocument.Portion s1 = null;
        int i1 = -1;
        for (int i = i0; i < text.length(); ++i) {
            char c = text.charAt(i);
            MTextDocument.Portion s = text.getPortion(i0, i + 1);
            if (c == '\n') {
                tbox.addLine(s);
                i0 = i + 1;
                s1 = null;
            } else {
                double w = s.portionWidth(g, dmfont, fm);
                if (w > tbox.getCurrentWidth()) {
                    if (tbox.getBreakingChars().indexOf(c) > -1) {
                        tbox.addLine(s);
                        i0 = i + 1;
                        s1 = null;
                    } else if (s1 != null) {
                        tbox.addLine(s1);
                        i0 = i1;
                        s1 = null;
                    } else {
                        i = MTextBoxPainter.findBreakingCharacter(tbox, text, i0, i);
                        tbox.addLine(text.getPortion(i0, i));
                        i0 = i;
                    }
                } else if (tbox.getBreakingChars().indexOf(c) > -1 && i > i0) {
                    s1 = s;
                    i1 = i + 1;
                }
            }
            tbox.setRowAndColumn0(i0);
        }
        if (i0 < text.length()) {
            tbox.addLine(text.getPortion(i0, text.length()));
        }
    }

    private static int findBreakingCharacter(MTextBox tbox, MTextDocument text, int i0, int i) {
        for (int j = i; j > i0; --j) {
            if (tbox.getBreakingChars().indexOf(text.charAt(j)) > -1) {
                return j + 1;
            }
            if (tbox.getPreBreakingChars().indexOf(text.charAt(j)) <= -1) continue;
            return j;
        }
        return i;
    }

    private static AffineTransform setAffineTransform(Graphics2D g, double x, double y, double ex, double ey, double fx, double fy) {
        AffineTransform t = new AffineTransform(ex, ey, fx, fy, x - ex * x - fx * y, y - ey * x - fy * y);
        AffineTransform old = g.getTransform();
        t.preConcatenate(old);
        g.setTransform(t);
        return old;
    }
}

