/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal.util;

import chemaxon.core.util.GeomUtil;
import chemaxon.marvin.paint.internal.Vector2D;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class DrawingUtil {
    private static Pattern CARET_TO_REMOVE_PATTERN = null;

    public static void calcLadderTypePolymerBracket(DPoint3 p1, DPoint3 p2, DPoint3 p3, DPoint3 p4, DPoint3[] u) {
        DPoint3 np1 = CleanUtil.calcDividingPoint(p1, p2, 0.7);
        DPoint3 np2 = CleanUtil.calcDividingPoint(p3, p4, 0.7);
        u[0] = CleanUtil.calcDividingPoint(np1, np2, -0.25);
        u[1] = CleanUtil.calcDividingPoint(np2, np1, -0.25);
        DPoint3 p1f = new DPoint3((p1.x + p3.x) / 2.0, (p1.y + p3.y) / 2.0, (p1.z + p3.z) / 2.0);
        DPoint3[] qs = CleanUtil.calcBracketEndPoints(u, p1f, 0.385);
        u[2] = qs[0];
        u[3] = qs[1];
    }

    public static double calculateAngle2D(DPoint3 p0, DPoint3 p1, DPoint3 c) {
        double dx = p0.x - c.x;
        double dy = p0.y - c.y;
        double d0 = Math.sqrt(dx * dx + dy * dy);
        dx = p1.x - c.x;
        dy = p1.y - c.y;
        double d1 = Math.sqrt(dx * dx + dy * dy);
        if (d0 == 0.0 || d1 == 0.0) {
            return 0.0;
        }
        double p = ((p0.x - c.x) * (p1.x - c.x) + (p0.y - c.y) * (p1.y - c.y)) / (d0 * d1);
        return Math.acos(p);
    }

    public static double[][] getBracketCoords(Sgroup sg) {
        double[][] coords = new double[2][9];
        MolAtom[] atoms = sg.getAtomArray();
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        for (MolAtom atom : atoms) {
            double y;
            double x = atom.getX();
            if (x > xmax) {
                xmax = x;
            }
            if (x < xmin) {
                xmin = x;
            }
            if ((y = atom.getY()) > ymax) {
                ymax = y;
            }
            if (!(y < ymin)) continue;
            ymin = y;
        }
        double d = 0.7840000000000001;
        coords[1][0] = xmin - d;
        coords[1][1] = ymin - d;
        coords[1][2] = 0.0;
        coords[1][3] = xmin - d;
        coords[1][4] = ymax + d;
        coords[1][5] = 0.0;
        coords[0][0] = xmax + d;
        coords[0][1] = ymax + d;
        coords[0][2] = 0.0;
        coords[0][3] = xmax + d;
        coords[0][4] = ymin - d;
        coords[0][5] = 0.0;
        return coords;
    }

    public static double[][] getBracketCoordsfromChildren(Sgroup sg) {
        double[][] coords = DrawingUtil.getBracketCoords(sg);
        for (int i = 0; i < sg.getChildSgroupCount(); ++i) {
            double[][] childCoords = DrawingUtil.getBracketCoordsfromChildren(sg.getChildSgroup(i));
            int subscriptLength = DrawingUtil.removeCaret(sg.getSubscript()) == null ? 0 : DrawingUtil.removeCaret(sg.getSubscript()).length();
            int superscriptLength = sg.getSuperscript() == null ? 0 : sg.getSuperscript().length();
            double d1 = 0.5133333333333333;
            double d2 = d1 * (double)Math.max(subscriptLength, superscriptLength) + 2.0;
            double[] dArray = childCoords[1];
            dArray[1] = dArray[1] - d1;
            double[] dArray2 = childCoords[0];
            dArray2[4] = dArray2[4] - d1;
            double[] dArray3 = childCoords[1];
            dArray3[0] = dArray3[0] - d1;
            double[] dArray4 = childCoords[1];
            dArray4[3] = dArray4[3] - d1;
            double[] dArray5 = childCoords[1];
            dArray5[4] = dArray5[4] + d1;
            double[] dArray6 = childCoords[0];
            dArray6[1] = dArray6[1] + d1;
            double[] dArray7 = childCoords[0];
            dArray7[3] = dArray7[3] + d2;
            double[] dArray8 = childCoords[0];
            dArray8[0] = dArray8[0] + d2;
            if (coords == null) {
                coords = childCoords;
                continue;
            }
            coords[1][0] = Math.min(coords[1][0], childCoords[1][0]);
            coords[1][1] = Math.min(coords[1][1], childCoords[1][1]);
            coords[1][3] = Math.min(coords[1][3], childCoords[1][3]);
            coords[0][4] = Math.min(coords[0][4], childCoords[0][4]);
            coords[1][4] = Math.max(coords[1][4], childCoords[1][4]);
            coords[0][1] = Math.max(coords[0][1], childCoords[0][1]);
            coords[0][3] = Math.max(coords[0][3], childCoords[0][3]);
            coords[0][0] = Math.max(coords[0][0], childCoords[0][0]);
        }
        return coords;
    }

    public static double[][] getSimpleBracketCoords(RepeatingUnitSgroup sru) {
        MolBond[] b = sru.findCrossingBonds();
        if (b.length == 0) {
            return DrawingUtil.getBracketCoordsfromChildren(sru);
        }
        double[][] coords = new double[b.length][9];
        for (int i = 0; i < b.length; ++i) {
            DPoint3 tmp;
            MolAtom a1 = sru.indexOf(b[i].getAtom1()) >= 0 ? b[i].getAtom1() : b[i].getAtom2();
            DPoint3[] q = CleanUtil.calcSimplePolymerBracket(a1.getLocation(), b[i].getOtherAtom(a1).getLocation(), 0.7);
            if (q[0].x < q[2].x) {
                if (q[0].y > q[1].y) {
                    tmp = q[0];
                    q[0] = q[1];
                    q[1] = tmp;
                }
            } else if (q[0].y < q[1].y) {
                tmp = q[0];
                q[0] = q[1];
                q[1] = tmp;
            }
            coords[i][0] = q[0].x;
            coords[i][1] = q[0].y;
            coords[i][2] = q[0].z;
            coords[i][3] = q[1].x;
            coords[i][4] = q[1].y;
            coords[i][5] = q[1].z;
            coords[i][6] = 0.0;
            coords[i][7] = 0.0;
            coords[i][8] = 0.0;
        }
        return coords;
    }

    public static double[][] getBracketCoords(RepeatingUnitSgroup sru) {
        double[][] coords = new double[2][];
        MolBond[] b = sru.getTailCrossingBonds();
        coords[0] = DrawingUtil.getBracketCoords(b, sru);
        b = sru.getHeadCrossingBonds();
        coords[1] = DrawingUtil.getBracketCoords(b, sru);
        return coords;
    }

    public static double[] getBracketCoords(MolBond[] b, RepeatingUnitSgroup sru) {
        double[] coords = new double[9];
        MolAtom inSgroup0 = sru.indexOf(b[0].getAtom1()) > -1 ? b[0].getAtom1() : b[0].getAtom2();
        MolAtom inSgroup1 = sru.indexOf(b[1].getAtom1()) > -1 ? b[1].getAtom1() : b[1].getAtom2();
        DPoint3[] q = new DPoint3[4];
        DrawingUtil.calcLadderTypePolymerBracket(inSgroup0.getLocation(), b[0].getOtherAtom(inSgroup0).getLocation(), inSgroup1.getLocation(), b[1].getOtherAtom(inSgroup1).getLocation(), q);
        if (q[0].x < q[2].x) {
            if (q[0].y > q[1].y) {
                DPoint3 tmp = q[0];
                q[0] = q[1];
                q[1] = tmp;
            }
        } else if (q[0].y < q[1].y) {
            DPoint3 tmp = q[0];
            q[0] = q[1];
            q[1] = tmp;
        }
        coords[0] = q[0].x;
        coords[1] = q[0].y;
        coords[2] = q[0].z;
        coords[3] = q[1].x;
        coords[4] = q[1].y;
        coords[5] = q[1].z;
        coords[6] = 0.0;
        coords[7] = 0.0;
        coords[8] = 0.0;
        return coords;
    }

    private static DPoint3 divideSegment(DPoint3 q0, DPoint3 q1, int d) {
        DPoint3 position = new DPoint3();
        double r = (double)d / (q0.distance(q1) - (double)d);
        position.x = (r * q1.x + q0.x) / (1.0 + r);
        position.y = (r * q1.y + q0.y) / (1.0 + r);
        return position;
    }

    public static DPoint3[] calcScriptPosition(Rectangle subScriptBounds, Rectangle superScriptBounds, DPoint3[] q) {
        DPoint3[] sc = new DPoint3[2];
        if (q[0].distance(q[1]) == 0.0) {
            return null;
        }
        if (q[0].y < q[1].y) {
            DPoint3 tmp0 = q[0];
            q[0] = q[1];
            q[1] = tmp0;
            DPoint3 tmp2 = q[2];
            q[2] = q[3];
            q[3] = tmp2;
        }
        if (q[0].x <= q[2].x && q[0].y > q[2].y) {
            DPoint3 dPoint3 = new DPoint3(q[0].x, q[1].y, 0.0);
            if (GeomUtil.calculateAngle(dPoint3, q[0], q[1]) > 0.7853981633974483) {
                sc[1] = new DPoint3(q[1].x - (double)superScriptBounds.width - 2.0, q[1].y + 2.0, 0.0);
                sc[0] = DrawingUtil.divideSegment(q[0], q[1], subScriptBounds.height);
                sc[0].x -= (double)(subScriptBounds.width + 2);
                sc[0].y += 2.0;
            } else {
                sc[1] = DrawingUtil.divideSegment(q[1], q[0], superScriptBounds.width);
                sc[1].x -= (double)(superScriptBounds.width + 2);
                sc[1].y += 2.0;
                sc[0] = new DPoint3(q[0].x - (double)subScriptBounds.width - 2.0, q[0].y + 2.0, 0.0);
            }
        } else if (q[0].x > q[2].x && q[0].y > q[2].y) {
            DPoint3 dPoint3 = new DPoint3(q[0].x, q[1].y, 0.0);
            if (GeomUtil.calculateAngle(dPoint3, q[0], q[1]) > 0.7853981633974483) {
                sc[1] = new DPoint3(q[1].x + 2.0, q[1].y + 2.0, 0.0);
                sc[0] = DrawingUtil.divideSegment(q[0], q[1], subScriptBounds.height);
                sc[0].x += 2.0;
                sc[0].y += 2.0;
            } else {
                sc[1] = DrawingUtil.divideSegment(q[1], q[0], superScriptBounds.width);
                sc[1].x += 2.0;
                sc[1].y += 2.0;
                sc[0] = new DPoint3(q[0].x + 2.0, q[0].y + 2.0, 0.0);
            }
        } else if (q[0].x > q[2].x && q[0].y <= q[2].y) {
            double phi = GeomUtil.calculateAngle(new DPoint3(q[0].x, q[1].y, 0.0), q[0], q[1]);
            if (phi < 0.7853981633974483 && phi != 0.0) {
                sc[1] = new DPoint3(q[1].x + 2.0, q[1].y - 2.0 - (double)superScriptBounds.height, 0.0);
                sc[0] = DrawingUtil.divideSegment(q[0], q[1], subScriptBounds.width);
                sc[0].x += 2.0;
                sc[0].y -= (double)(subScriptBounds.height + 2);
            } else {
                sc[1] = DrawingUtil.divideSegment(q[1], q[0], superScriptBounds.height);
                sc[1].x += 2.0;
                sc[1].y -= (double)(superScriptBounds.height + 2);
                sc[0] = new DPoint3(q[0].x + 2.0, q[0].y - (double)subScriptBounds.height - 2.0, 0.0);
            }
        } else {
            double phi = GeomUtil.calculateAngle(new DPoint3(q[0].x, q[1].y, 0.0), q[0], q[1]);
            if (phi > 0.7853981633974483 || phi == 0.0) {
                sc[1] = DrawingUtil.divideSegment(q[0], q[1], superScriptBounds.height);
                sc[1].x -= (double)superScriptBounds.width;
                sc[1].y -= (double)superScriptBounds.height;
                sc[0] = new DPoint3(q[0].x - (double)subScriptBounds.width, q[0].y - (double)subScriptBounds.height, 0.0);
            } else {
                sc[1] = new DPoint3(q[1].x - (double)superScriptBounds.width, q[1].y - (double)superScriptBounds.height, 0.0);
                sc[0] = DrawingUtil.divideSegment(q[0], q[1], subScriptBounds.width);
                sc[0].x -= (double)subScriptBounds.width;
                sc[0].y -= (double)subScriptBounds.height;
            }
        }
        return sc;
    }

    public static DPoint3[] getBondBounds(int w, DPoint3 p1, DPoint3 p2) {
        DPoint3[] np = new DPoint3[7];
        double d = p1.distance2D(p2);
        DPoint3 dp1 = CleanUtil.calcDividingPoint(p1, p2, (double)w / d);
        DPoint3 dp2 = CleanUtil.calcDividingPoint(p2, p1, (double)w / d);
        np[0] = new DPoint3(p1.y - dp1.y + p1.x, dp1.x - p1.x + p1.y, 0.0);
        np[1] = new DPoint3(-dp1.x + 2.0 * p1.x, -dp1.y + 2.0 * p1.y, 0.0);
        np[2] = new DPoint3(dp1.y - p1.y + p1.x, p1.x - dp1.x + p1.y, 0.0);
        np[3] = new DPoint3(p2.y - dp2.y + p2.x, dp2.x - p2.x + p2.y, 0.0);
        np[4] = new DPoint3(-dp2.x + 2.0 * p2.x, -dp2.y + 2.0 * p2.y, 0.0);
        np[5] = new DPoint3(dp2.y - p2.y + p2.x, p2.x - dp2.x + p2.y, 0.0);
        np[6] = new DPoint3(p1.y - dp1.y + p1.x, dp1.x - p1.x + p1.y, 0.0);
        return np;
    }

    public static boolean containsPoint(Line2D.Double segment, Point2D point) {
        return DrawingUtil.containsPointWithDiff(segment, point, 1.0);
    }

    public static boolean containsPointWithDiff(Line2D.Double segment, Point2D point, double diff) {
        double distanceDiff = segment.getP2().distance(segment.getP1()) - point.distance(segment.getP1()) - point.distance(segment.getP2());
        return Math.abs(distanceDiff) < diff;
    }

    public static Line2D.Double intersect2DSegPoly(double x0, double y0, double x1, double y1, DPoint3[] V2) {
        int i;
        double tE = 0.0;
        double tL = 1.0;
        Vector2D sp1 = new Vector2D(x1, y1);
        Vector2D sp0 = new Vector2D(x0, y0);
        Vector2D dS = new Vector2D(0.0, 0.0);
        Vector2D.subtract(dS, sp1, sp0);
        Vector2D e = new Vector2D(0.0, 0.0);
        Vector2D[] vects = new Vector2D[V2.length];
        for (i = 0; i < V2.length; ++i) {
            vects[i] = new Vector2D(V2[i].x, V2[i].y);
        }
        for (i = 0; i < vects.length - 1; ++i) {
            e.set(V2[i + 1].x - V2[i].x, V2[i + 1].y - V2[i].y);
            double N = Vector2D.perp(e, sp0.subtract(vects[i]));
            double D = -1.0 * Vector2D.perp(e, dS);
            if (Math.abs(D) < (double)1.0E-8f) {
                if (!(N < 0.0)) continue;
                return null;
            }
            double t = N / D;
            if (!(D < 0.0 ? t > tE && (tE = t) > tL : t < tL && (tL = t) < tE)) continue;
            return null;
        }
        return new Line2D.Double(sp0.add(dS.scalar(tE)).toPoint2D(), sp0.add(dS.scalar(tL)).toPoint2D());
    }

    private static DPoint3[] calcLadderTypeCrossings(Sgroup sg, MolBond b1, MolBond b2, DPoint3[] u) {
        DPoint3[] pf = new DPoint3[2];
        DPoint3 p1 = b1.getAtom1().getLocation();
        DPoint3 p2 = b1.getAtom2().getLocation();
        DPoint3 p3 = b2.getAtom1().getLocation();
        DPoint3 p4 = b2.getAtom2().getLocation();
        DPoint3 p = sg.indexOf(b1.getAtom1()) < 0 ? p1 : p2;
        DPoint3 q = sg.indexOf(b2.getAtom1()) < 0 ? p3 : p4;
        DPoint3 s = p == p1 ? p2 : p1;
        DPoint3 t = q == p3 ? p4 : p3;
        pf[1] = new DPoint3((p.x + q.x) / 2.0, (p.y + q.y) / 2.0, (p.z + q.z) / 2.0);
        pf[0] = new DPoint3((s.x + t.x) / 2.0, (s.y + t.y) / 2.0, (s.z + t.z) / 2.0);
        DrawingUtil.calcLadderTypePolymerBracket(s, p, t, q, u);
        return pf;
    }

    public static void generateLadderBrackets(Sgroup sg, MolBond b1, MolBond b2, int btype) {
        DPoint3[] u = new DPoint3[4];
        DrawingUtil.calcLadderTypeCrossings(sg, b1, b2, u);
        CleanUtil.createBracket(sg, u, btype);
    }

    public static DPoint3 getSubScriptPosition(Sgroup sg) {
        ArrayList<MBracket> brackets = sg.getBrackets();
        if (brackets != null && brackets.size() == 1) {
            return brackets.get(0).getPoint(2).getLocation();
        }
        return null;
    }

    public static DPoint3 getSuperscriptPosition(Sgroup sg) {
        ArrayList<MBracket> brackets = sg.getBrackets();
        if (brackets != null && brackets.size() == 1) {
            return brackets.get(0).getPoint(1).getLocation();
        }
        return null;
    }

    public static boolean isRectangle(DPoint3 p0, DPoint3 p1, DPoint3 p2, DPoint3 p3) {
        boolean isRect = Math.abs(GeomUtil.calculateAngle(p0, p3, p1) - 1.5707963267948966) < GeomUtil.EPS;
        isRect &= Math.abs(GeomUtil.calculateAngle(p1, p2, p0) - 1.5707963267948966) < GeomUtil.EPS;
        isRect &= Math.abs(GeomUtil.calculateAngle(p2, p1, p3) - 1.5707963267948966) < GeomUtil.EPS;
        isRect &= Math.abs(GeomUtil.calculateAngle(p3, p0, p1) - 1.5707963267948966) < GeomUtil.EPS;
        return isRect &= Math.abs(p0.distance(p1) - p2.distance(p3)) < GeomUtil.EPS;
    }

    public static DPoint3 findTopLeft(DPoint3[] p) {
        int topleft = 0;
        for (int i = 0; i < p.length; ++i) {
            if (!(p[i].x <= p[topleft].x) || !(p[i].y >= p[topleft].y)) continue;
            topleft = i;
        }
        return p[topleft];
    }

    public static DPoint3 findBottomRight(DPoint3[] p) {
        int bottomright = 0;
        for (int i = 0; i < p.length; ++i) {
            if (!(p[i].x >= p[bottomright].x) || !(p[i].y <= p[bottomright].y)) continue;
            bottomright = i;
        }
        return p[bottomright];
    }

    public static double[] calcIntersectPointOf2Lines(double x11, double y11, double x12, double y12, double x21, double y21, double x22, double y22) {
        double[] ipcoords = new double[2];
        double m1 = x12 - x11;
        double m1i = Math.abs(m1);
        double n1 = y12 - y11;
        if (m1i < 0.001) {
            ipcoords[0] = x11;
            double m2 = x22 - x21;
            double n2 = y22 - y21;
            double d2 = n2 / m2;
            ipcoords[1] = y21 - d2 * x21 + d2 * ipcoords[0];
        } else {
            double d1 = n1 / m1;
            double m2 = x22 - x21;
            double m2i = Math.abs(m2);
            double n2 = y22 - y21;
            if (m2i < 0.001) {
                ipcoords[0] = x21;
            } else {
                double d2 = n2 / m2;
                ipcoords[0] = (y21 - x21 * d2 - y11 + x11 * d1) / (d1 - d2);
            }
            ipcoords[1] = y11 - d1 * x11 + d1 * ipcoords[0];
        }
        return ipcoords;
    }

    public static double[] calcIntersectPointOf2Lines(double[] line1, double[] line2) {
        double[] ipcoords = new double[2];
        double m1 = line1[2] - line1[0];
        double m1i = Math.abs(m1);
        double n1 = line1[3] - line1[1];
        if (m1i < 0.001) {
            ipcoords[0] = line1[0];
            double m2 = line2[2] - line2[0];
            double n2 = line2[3] - line2[1];
            double d2 = n2 / m2;
            ipcoords[1] = line2[1] - d2 * line2[0] + d2 * ipcoords[0];
        } else {
            double d1 = n1 / m1;
            double m2 = line2[2] - line2[0];
            double m2i = Math.abs(m2);
            double n2 = line2[3] - line2[1];
            if (m2i < 0.001) {
                ipcoords[0] = line2[0];
            } else {
                double d2 = n2 / m2;
                ipcoords[0] = (line2[1] - line2[0] * d2 - line1[1] + line1[0] * d1) / (d1 - d2);
            }
            ipcoords[1] = line1[1] - d1 * line1[0] + d1 * ipcoords[0];
        }
        return ipcoords;
    }

    public static DPoint3 calcIntersectPointOf2Lines(Line2D line1, Line2D line2) {
        double[] l1 = new double[4];
        double[] l2 = new double[4];
        l1[0] = line1.getX1();
        l1[1] = line1.getY1();
        l1[2] = line1.getX2();
        l1[3] = line1.getY2();
        l2[0] = line2.getX1();
        l2[1] = line2.getY1();
        l2[2] = line2.getX2();
        l2[3] = line2.getY2();
        double[] l = DrawingUtil.calcIntersectPointOf2Lines(l1, l2);
        return new DPoint3(l[0], l[1], 0.0);
    }

    public static double[] calcAngleBisectingOf2Lines(double[] line1, double[] line2) {
        double d2;
        double[] abcoords = new double[4];
        double m1 = line1[2] - line1[0];
        double m1i = Math.abs(m1);
        double n1 = line1[3] - line1[1];
        double n1i = Math.abs(n1);
        double m2 = line2[2] - line2[0];
        double m2i = Math.abs(m2);
        double n2 = line2[3] - line2[1];
        double n2i = Math.abs(n2);
        double d1 = n1i < 0.001 || m1i < 0.001 ? 0.0 : n1 / m1;
        double d = d2 = n2i < 0.001 || m2i < 0.001 ? 0.0 : n2 / m2;
        if (line1[0] == line2[0] && line1[1] == line2[1] || line1[0] == line2[2] && line1[1] == line2[3]) {
            abcoords[0] = line1[0];
            abcoords[1] = line1[1];
        } else if (line1[2] == line2[0] && line1[3] == line2[1] || line1[2] == line2[2] && line1[3] == line2[3]) {
            abcoords[0] = line1[2];
            abcoords[1] = line1[3];
        } else if (m1i < 0.001) {
            abcoords[0] = line1[0];
            abcoords[1] = line2[1] - d2 * line2[0] + d2 * abcoords[0];
        } else {
            abcoords[0] = m2i < 0.001 ? line2[0] : (Double.isNaN((line2[1] - line2[0] * d2 - line1[1] + line1[0] * d1) / (d1 - d2)) ? 0.0 : (line2[1] - line2[0] * d2 - line1[1] + line1[0] * d1) / (d1 - d2));
            abcoords[1] = line1[1] - d1 * line1[0] + d1 * abcoords[0];
        }
        double[] f1 = new double[4];
        double[] f2 = new double[4];
        double dx1 = Math.sqrt(1.0 / (1.0 + d1 * d1)) * 10.0;
        double dy1 = d1 * dx1;
        if (m1i < 0.001) {
            if (line1[1] < abcoords[1] || line1[3] < abcoords[1]) {
                f1[0] = abcoords[0];
                f1[1] = abcoords[1] - 10.0;
            } else {
                f1[0] = abcoords[0];
                f1[1] = abcoords[1] + 10.0;
            }
            f1[2] = f1[0] + 10.0;
            f1[3] = f1[1];
        } else {
            if (line1[0] < abcoords[0] || line1[2] < abcoords[0]) {
                f1[0] = abcoords[0] - dx1;
                f1[1] = abcoords[1] - dy1;
            } else {
                f1[0] = abcoords[0] + dx1;
                f1[1] = abcoords[1] + dy1;
            }
            f1[2] = n1i > 0.001 ? f1[0] + 10.0 : f1[0];
            f1[3] = n1i > 0.001 ? f1[1] - 10.0 / d1 : f1[1] + 10.0;
        }
        double dx2 = Math.sqrt(1.0 / (1.0 + d2 * d2)) * 10.0;
        double dy2 = d2 * dx2;
        if (m2i < 0.001) {
            if (line2[1] < abcoords[1] || line2[3] < abcoords[1]) {
                f2[0] = abcoords[0];
                f2[1] = abcoords[1] - 10.0;
            } else {
                f2[0] = abcoords[0];
                f2[1] = abcoords[1] + 10.0;
            }
            f2[2] = f2[0] + 10.0;
            f2[3] = f2[1];
        } else {
            if (line2[0] < abcoords[0] || line2[2] < abcoords[0]) {
                f2[0] = abcoords[0] - dx2;
                f2[1] = abcoords[1] - dy2;
            } else {
                f2[0] = abcoords[0] + dx2;
                f2[1] = abcoords[1] + dy2;
            }
            f2[2] = n2i > 0.001 ? f2[0] + 10.0 : f2[0];
            f2[3] = n2i > 0.001 ? f2[1] - 10.0 / d2 : f2[1] + 10.0;
        }
        double[] ipc = DrawingUtil.calcIntersectPointOf2Lines(f1, f2);
        abcoords[2] = ipc[0];
        abcoords[3] = ipc[1];
        return abcoords;
    }

    public static boolean arePointsCollinear(DPoint3 p1, DPoint3 p2, DPoint3 p3) {
        double d1y = p1.y - p3.y;
        double d2z = p1.z - p2.z;
        double d1z = p1.z - p3.z;
        double d2y = p1.y - p2.y;
        double d1xd2x = d1y * d2z - d1z * d2y;
        double d2x = p1.x - p2.x;
        double d1x = p1.x - p3.x;
        double d1xd2y = d1z * d2x - d1x * d2z;
        double d1xd2z = d1x * d2y - d1y * d2x;
        double d1xd2LengthSq = d1xd2x * d1xd2x + d1xd2y * d1xd2y + d1xd2z * d1xd2z;
        double d1LengthSq = d1x * d1x + d1y * d1y + d1z * d1z;
        double d2LengthSq = d2x * d2x + d2y * d2y + d2z * d2z;
        double epsilon = 0.0076;
        return d1xd2LengthSq < d1LengthSq * d2LengthSq * epsilon;
    }

    public static void sortDiffs(double[] diffs, double[] angles, int[] bi, int[] ai) {
        int n = diffs.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!(diffs[i] > diffs[j])) continue;
                double f = diffs[i];
                diffs[i] = diffs[j];
                diffs[j] = f;
                f = angles[i];
                angles[i] = angles[j];
                angles[j] = f;
                int d = bi[i];
                bi[i] = bi[j];
                bi[j] = d;
                if (ai == null) continue;
                d = ai[i];
                ai[i] = ai[j];
                ai[j] = d;
            }
        }
    }

    public static int[][] bondIndices1(MolAtom a0) {
        int i;
        int[][] bi = new int[2][];
        int n = 0;
        for (i = 0; i < a0.getBondCount(); ++i) {
            if (a0.getLigand(i).getBondCount() <= 1) continue;
            ++n;
            break;
        }
        bi[0] = new int[n * (a0.getBondCount() - 1)];
        bi[1] = new int[a0.getBondCount() - 1];
        for (i = 0; i < a0.getBondCount() - 1; ++i) {
            if (a0.getLigand(i).getBondCount() > 1) {
                if (n > 0) {
                    bi[0][i] = 1;
                }
                bi[1][i] = i;
                continue;
            }
            if (n > 0) {
                bi[0][i] = -1;
            }
            bi[1][i] = i;
        }
        return bi;
    }

    public static boolean regular(double[] diffs) {
        boolean reg = true;
        for (int i = 0; i < diffs.length - 1; ++i) {
            float f2;
            float f1 = new Double(diffs[i]).floatValue();
            if (f1 == (f2 = new Double(diffs[i + 1]).floatValue())) continue;
            reg = false;
            break;
        }
        return reg;
    }

    public static int detDesBondIndex(double[] angles, int[] bi) {
        int index = 0;
        GeomUtil.sortAngles(angles, bi, null);
        for (int i = 0; i < bi.length; ++i) {
            if (bi[i] != 1) continue;
            index = i + 1;
        }
        if (index >= bi.length) {
            index -= bi.length;
        }
        return index;
    }

    public static boolean areLinesParallel(double[] line1, double[] line2) {
        double q1 = Math.abs(line1[1] - line1[3]) > 0.001 ? (line1[0] - line1[2]) / (line1[1] - line1[3]) : 0.0;
        double q2 = Math.abs(line2[1] - line2[3]) > 0.001 ? (line2[0] - line2[2]) / (line2[1] - line2[3]) : 0.0;
        return Math.abs(q1 - q2) < 0.2;
    }

    public static String removeCaret(String subscript) {
        if (CARET_TO_REMOVE_PATTERN == null) {
            CARET_TO_REMOVE_PATTERN = Pattern.compile("\\\\{0,1}\\^{1}(\\p{Alnum}{1})");
        }
        return CARET_TO_REMOVE_PATTERN.matcher(subscript).replaceAll("$1");
    }

    public static int getBondSideToPoint(DPoint3 p1, DPoint3 p2, DPoint3 p) {
        double beta;
        double alpha = p1.angle2D(p2.x, p2.y);
        if (alpha < 0.0 && Math.abs(Math.PI + alpha) < 1.0E-4) {
            alpha += Math.PI * 2;
        }
        if (alpha - (beta = p1.angle2D(p.x, p.y)) > 0.0 && alpha - Math.PI - beta < 0.0) {
            return 1;
        }
        if (beta - alpha > 0.0 || beta - alpha + Math.PI < 0.0) {
            return -1;
        }
        return 0;
    }
}

