/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.license.LicenseManagerGUI;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.CalculatorPluginDisplay;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginFactory;
import chemaxon.marvin.plugin.gui.OptionsPane;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CalculatorPluginManager
implements CallbackIface {
    private static final String lineSep = System.getProperty("line.separator");
    private MolPanel mpan = null;
    private PluginFactory factory = null;
    private Properties parameters = new Properties();

    public CalculatorPluginManager(PluginFactory factory, MolPanel mpan) {
        this.factory = factory;
        this.mpan = mpan;
        factory.setOKActionListener(mpan);
        factory.setParentComponent(mpan);
    }

    private void error(String msg, Throwable e) {
        this.mpan.getErrorDisplay().error(msg, e);
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("runPlugin")) {
            Object[] args = (Object[])arg;
            String key = (String)args[0];
            int index = this.factory.getPluginIndex(key);
            Molecule mol = (Molecule)args[1];
            int icell = (Integer)args[2];
            String lenv = args.length > 3 ? (String)args[3] : "";
            this.runPlugin(index, mol, icell, lenv);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPlugin(int index, Molecule mol, int icell, String lenv) {
        CalculatorPluginDisplay display = null;
        OptionsPane opane = null;
        try {
            opane = this.factory.getOptionsPane(index);
            if (!(opane == null || opane.isVisible() && opane.isFocused())) {
                this.showOptionsPane(opane);
                return;
            }
        }
        catch (PluginException e) {
            this.error("Cannot get OptionsPane: " + this.factory.getKey(index), e.getException());
        }
        try {
            if (opane != null) {
                this.showOptionsPane(opane);
            }
            if (mol != null) {
                display = this.factory.getDisplay(index);
                CalculatorPlugin plugin = display.getPlugin();
                plugin.setLicenseEnvironment(lenv);
                display.setCellIndex(icell);
                if (opane != null) {
                    opane.getParameters(this.parameters);
                    opane.setActionsEnabled(false);
                }
                this.runPlugin(this.parameters, plugin, display, mol);
            }
        }
        catch (LicenseException e) {
            this.error(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            String msg = e.getMessage() != null ? lineSep + e.getMessage() : "";
            this.error("Cannot run plugin: " + this.factory.getMenu(index) + msg, e);
        }
        catch (PluginException e) {
            this.error("Cannot run plugin: " + this.factory.getMenu(index) + lineSep + e.getMessage(), e.getException());
        }
        finally {
            if (display != null) {
                display.clear();
            }
            if (opane != null) {
                opane.setActionsEnabled(true);
            }
        }
    }

    private void showOptionsPane(final OptionsPane opane) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showOptionsPaneImpl(opane);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CalculatorPluginManager.this.showOptionsPaneImpl(opane);
                }
            });
        }
    }

    private void showOptionsPaneImpl(OptionsPane opane) {
        if (!opane.isShowing()) {
            SwingUtilities.updateComponentTreeUI(opane);
            opane.pack();
        }
        opane.setVisible(true);
        opane.toFront();
    }

    private void runPlugin(Properties params, CalculatorPlugin plugin, CalculatorPluginDisplay display, Molecule mol) throws PluginException {
        if (params != null) {
            plugin.setParameters(params);
            display.setParameters(params);
        }
        MProgressMonitor pmon = display.getProgressMonitor(display.getParent());
        plugin.setProgressMonitor(pmon);
        boolean componentDisplayed = false;
        if (!plugin.handlesMultiFragmentMolecules() && mol.getFragCount() > 1) {
            if (mol.isReaction()) {
                RxnMolecule rxn = RxnMolecule.getReaction(mol);
                display.setReactionArrow(rxn.getReactionArrow());
            }
            Molecule[] frags = mol.convertToFrags();
            for (int i = 0; i < frags.length; ++i) {
                this.runPlugin(plugin, display, frags[i]);
                if (display.isMultipleDisplay()) continue;
                componentDisplayed |= this.displayResult(display, plugin.isOK(), i);
            }
            if (display.isMultipleDisplay()) {
                componentDisplayed = this.displayResult(display, true, 0);
            }
        } else {
            this.runPlugin(plugin, display, mol);
            componentDisplayed = this.displayResult(display, plugin.isOK(), 0);
        }
        if (!componentDisplayed) {
            this.displayError(display);
        }
    }

    private void runPlugin(CalculatorPlugin plugin, CalculatorPluginDisplay display, Molecule mol) throws PluginException {
        plugin.checkMolecule(mol);
        plugin.setMolecule(mol, true, false);
        if (plugin.run()) {
            display.store();
        }
        if (LicenseHandler.getInstance().isDemoModePluginOnly(plugin.getProductName())) {
            JPanel ep = LicenseManagerGUI.getLicenseEvaluationPanel(plugin.getProductName());
            JOptionPane.showMessageDialog(this.mpan, ep, "Error", 0);
        }
    }

    private void displayError(CalculatorPluginDisplay display) throws PluginException {
        this.displayResult(display.getParameterPanel().getComponent(), display.getRemark(), display.getErrorComponent(), display.getTitle(), 0);
    }

    private boolean displayResult(CalculatorPluginDisplay display, boolean ok, int d) throws PluginException {
        Component comp = null;
        if (ok) {
            comp = display.getResultComponent();
            this.displayResult(display.getParameterPanel().getComponent(), display.getRemark(), comp, display.getTitle(), d);
            display.clear();
        } else {
            display.pop();
        }
        return comp != null;
    }

    private void displayResult(Component parent, String remark, Component component, String title, int d) throws PluginException {
        if (remark != null) {
            JOptionPane.showMessageDialog(parent, remark, "Warning", 2);
        }
        if (component == null) {
            return;
        }
        if (component instanceof JOptionPane) {
            JDialog dialog = ((JOptionPane)component).createDialog(parent, title);
            dialog.setVisible(true);
            dialog.toFront();
        } else if (component instanceof JDialog || component instanceof JFrame) {
            if (d > 0) {
                Point point = component.getLocation();
                component.setLocation(point.x + d * 30, point.y + d * 30);
            }
            component.setVisible(true);
        } else {
            try {
                Frame pw;
                JDialog dialog = null;
                Dialog pd = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, parent);
                dialog = pd != null ? new JDialog(pd) : ((pw = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent)) != null ? new JDialog(pw) : new JDialog());
                dialog.setTitle(title);
                dialog.getContentPane().add(component);
                dialog.pack();
                dialog.setLocationRelativeTo(parent);
                if (d > 0) {
                    Point point = component.getLocation();
                    component.setLocation(point.x + d * 30, point.y + d * 30);
                }
                dialog.setVisible(true);
                dialog.toFront();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

