/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.calculations.MultipleMoleculeDisplay;
import chemaxon.marvin.io.PositionedInputStream;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.CalculatorPluginDisplay;
import chemaxon.marvin.plugin.ParameterPanelHandler;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.gui.OptionsPane;
import chemaxon.marvin.plugin.gui.ParameterPanelCreator;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.ExternalFileLoader;
import chemaxon.util.DotfileUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.SwingUtilities;

public class PluginFactory {
    public static final String DEFAULT_CONFIG_FILE = "plugins.properties";
    public static final String PRELOAD = "PRELOAD";
    public static final String NOPARAMS = "NOPARAMS";
    public static final String SEPARATOR = "SEPARATOR";
    private static ParameterPanelCreator ppc = null;
    private Component parent = null;
    private ActionListener okActionListener = null;
    private Properties parameters = new Properties();
    private PluginRecord[] records = null;

    public void setOKActionListener(ActionListener okActionListener) {
        this.okActionListener = okActionListener;
    }

    public void setParentComponent(Component parent) {
        this.parent = parent;
    }

    public static ParameterPanelHandler createDefaultParameterPanel(String cl, Component parent) throws PluginException {
        return PluginFactory.createDefaultParameterPanel(PluginFactory.class, cl, parent);
    }

    public static ParameterPanelHandler createDefaultParameterPanel(Class pluginClass, String cl, Component parent) throws PluginException {
        String name = cl.substring(cl.lastIndexOf(".") + 1);
        String paramFile = "/xjars/" + name + "Parameters.xml";
        InputStream is = null;
        try {
            is = BasicEnvironment.getResourceAsStream(pluginClass, paramFile);
            if (is != null) {
                Properties paramSettings = PluginFactory.readUserProperties(name + "Parameters.properties");
                if (ppc == null) {
                    ppc = new ParameterPanelCreator();
                }
                ParameterPanelHandler parameterPanelHandler = ppc.createPanel(cl, parent, new PositionedInputStream(is), paramSettings);
                return parameterPanelHandler;
            }
        }
        catch (IOException e) {
            throw new PluginException("Could not read user settings.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new PluginException(e);
                }
            }
        }
        return null;
    }

    public void load() throws PluginException {
        this.load("/xjars/plugins.properties", "plugins/plugins.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String file, String alterfile) throws PluginException {
        block10: {
            if (alterfile != null) {
                try {
                    ExternalFileLoader ppLoader = new ExternalFileLoader(alterfile);
                    String fileOutJar = ppLoader.getFileOutJar();
                    if (fileOutJar == null) break block10;
                    InputStream is = null;
                    try {
                        is = ppLoader.openFileOutJar();
                        if (is != null) {
                            this.load(this.readSystemProperties(is, alterfile));
                            return;
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Could not load properties from " + alterfile);
                }
            }
        }
        try {
            this.load(this.readSystemProperties(file));
        }
        catch (IOException e) {
            throw new PluginException("Could not read plugin properties: " + file, e);
        }
    }

    public void load(Properties props) throws PluginException {
        if (props == null) {
            throw new PluginException("'Tools' menu descriptor 'Properties' object is null.");
        }
        ArrayList<PluginRecord> recordList = new ArrayList<PluginRecord>();
        if (this.records != null) {
            recordList.addAll(Arrays.asList(this.records));
        }
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String prop = props.getProperty(key);
            char delim = prop.charAt(0);
            String[] data = new String[8];
            int len = prop.length();
            int k = 0;
            int s = 1;
            for (int i = 1; i <= len; ++i) {
                if (i != len && prop.charAt(i) != delim) continue;
                if (k >= data.length) {
                    throw new PluginException("Too many fields in configuration\nline: " + key + "=" + prop);
                }
                data[k++] = prop.substring(s, i);
                s = i + 1;
            }
            PluginRecord record = new PluginRecord(key, data[0], data[1], data[2], data[3], data[4], data[5], !NOPARAMS.equalsIgnoreCase(data[6]), SEPARATOR.equalsIgnoreCase(data[7]));
            recordList.add(record);
            if (!PRELOAD.equalsIgnoreCase(data[7])) continue;
            try {
                record.loadPlugin();
            }
            catch (PluginException e) {
                System.err.println("Could not preload plugin: " + record.key + " - " + data[1]);
                System.err.println(e);
                e.printStackTrace();
            }
        }
        this.records = new PluginRecord[recordList.size()];
        recordList.toArray(this.records);
        Arrays.sort(this.records);
        this.makeUniqueMenus();
    }

    private void makeUniqueMenus() {
        if (this.records == null) {
            return;
        }
        for (int n = 0; n < this.records.length; ++n) {
            String menu = this.records[n].menu;
            if (menu == null) continue;
            int i = 0;
            int k = 1;
            while (i < n) {
                if (menu.equals(this.records[i].menu)) {
                    menu = this.records[n].menu + " " + k;
                    ++k;
                    i = 0;
                    continue;
                }
                ++i;
            }
            this.records[n].menu = menu;
            this.records[n].key = menu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readSystemProperties(String file) throws IOException {
        InputStream is = null;
        try {
            is = BasicEnvironment.getResourceAsStream(PluginFactory.class, file);
            Properties properties = this.readSystemProperties(is, file);
            return properties;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readSystemProperties(InputStream is, String file) throws IOException {
        Properties props = new Properties();
        if (is != null) {
            try {
                props.load(new BufferedInputStream(is));
            }
            finally {
                is.close();
            }
        } else {
            System.err.println("Config file not found: " + file);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readUserProperties(String file) throws IOException {
        if (Environment.UNTRUSTED) {
            return null;
        }
        File dotFile = DotfileUtil.getDotFile(file);
        if (!dotFile.exists()) {
            return null;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(dotFile));
            props.load(is);
        }
        finally {
            is.close();
        }
        return props;
    }

    public synchronized void saveParameterSettings() {
        if (this.records == null) {
            return;
        }
        for (int i = 0; i < this.records.length; ++i) {
            this.records[i].saveParameterSettings();
        }
    }

    public int getCount() {
        return this.records != null ? this.records.length : 0;
    }

    public String getMenu(int index) {
        return this.records != null && index < this.records.length ? this.records[index].menu : null;
    }

    public String getKey(int index) {
        return this.records != null && index < this.records.length ? this.records[index].key : null;
    }

    public char getMnemonic(int index) {
        return (this.records != null && index < this.records.length ? Character.valueOf(this.records[index].mnemonic) : null).charValue();
    }

    public String getGroup(int index) {
        return this.records != null && index < this.records.length ? this.records[index].group : null;
    }

    public char getGroupMnemonic(int index) {
        return (this.records != null && index < this.records.length ? Character.valueOf(this.records[index].groupmnemonic) : null).charValue();
    }

    public boolean getSeparator(int index) {
        return this.records != null && index < this.records.length ? Boolean.valueOf(this.records[index].separator) : null;
    }

    public ParameterPanelHandler getParameterPanel(int index) throws PluginException {
        return this.records != null && index < this.records.length ? this.records[index].getParameterPanel() : null;
    }

    public OptionsPane getOptionsPane(int index) throws PluginException {
        return this.records != null && index < this.records.length ? this.records[index].getOptionsPane() : null;
    }

    public CalculatorPlugin getPlugin(int index) throws PluginException {
        return this.records != null && index < this.records.length ? this.records[index].getPlugin() : null;
    }

    public CalculatorPluginDisplay getDisplay(int index) throws PluginException {
        return this.records != null && index < this.records.length ? this.records[index].getDisplay() : null;
    }

    public boolean hasParameters(int index) {
        return this.records != null && index < this.records.length ? this.records[index].params : false;
    }

    public boolean isOptionsPaneLoaded(int index) {
        return this.records != null && index < this.records.length ? this.records[index].opane != null : false;
    }

    public int getPluginIndex(String key) {
        if (this.records == null) {
            return -1;
        }
        for (int i = 0; i < this.records.length; ++i) {
            if (!key.equals(this.records[i].key)) continue;
            return i;
        }
        return -1;
    }

    public class PluginRecord
    implements Comparable {
        String key = null;
        String cl = null;
        String jar = null;
        String menu = null;
        String group = null;
        char mnemonic = (char)32;
        char groupmnemonic = (char)32;
        boolean params = true;
        boolean separator = false;
        private CalculatorPlugin plugin = null;
        private CalculatorPluginDisplay display = null;
        private ParameterPanelHandler panel = null;
        private OptionsPane opane = null;

        PluginRecord(String key, String cl, String jar, String menu, String mnemonics, String group, String groupmnemonics, boolean params, boolean separator) throws PluginException {
            if (cl == null && jar == null) {
                throw new PluginException("Neither class name nor jar is specified for plugin key: " + key);
            }
            this.key = key;
            this.cl = cl == null || cl.length() > 0 ? cl : null;
            this.jar = jar == null || jar.length() > 0 ? jar : null;
            this.menu = menu;
            this.mnemonic = (char)(mnemonics == null || mnemonics.length() == 0 ? 32 : (int)mnemonics.charAt(0));
            this.group = group;
            this.groupmnemonic = (char)(groupmnemonics == null || groupmnemonics.length() == 0 ? 32 : (int)groupmnemonics.charAt(0));
            this.params = params;
            this.separator = separator;
        }

        public int compareTo(Object o) {
            if (this.key == null) {
                return 1;
            }
            PluginRecord record = (PluginRecord)o;
            if (record.key == null) {
                return -1;
            }
            return this.key.compareTo(record.key);
        }

        public synchronized void saveParameterSettings() {
            if (this.panel == null) {
                return;
            }
            if (Environment.UNTRUSTED) {
                return;
            }
            String name = this.cl.substring(this.cl.lastIndexOf(".") + 1);
            try {
                OutputStream os = DotfileUtil.create(name + "Parameters.properties");
                this.panel.getStoredParameters(PluginFactory.this.parameters);
                PluginFactory.this.parameters.store(os, name + " parameter settings");
                os.flush();
                os.close();
            }
            catch (IOException e) {
                System.err.println("Could not save plugin parameter settings for: " + name);
                System.err.println(e);
            }
        }

        public synchronized ParameterPanelHandler getParameterPanel() throws PluginException {
            this.loadParameterPanel();
            return this.panel;
        }

        public synchronized OptionsPane getOptionsPane() throws PluginException {
            this.loadOptionsPane();
            return this.opane;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized CalculatorPlugin getPlugin() throws PluginException {
            this.loadPlugin();
            try {
                CalculatorPlugin calculatorPlugin = this.plugin;
                return calculatorPlugin;
            }
            finally {
                if (!this.plugin.canRepeat()) {
                    this.plugin = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized CalculatorPluginDisplay getDisplay() throws PluginException {
            this.loadDisplay();
            try {
                CalculatorPluginDisplay calculatorPluginDisplay = this.display;
                return calculatorPluginDisplay;
            }
            finally {
                if (this.display instanceof MultipleMoleculeDisplay) {
                    this.display = null;
                    this.plugin = null;
                }
            }
        }

        private void loadParameterPanel() throws PluginException {
            if (!this.params) {
                return;
            }
            if (this.panel != null) {
                return;
            }
            if (this.display != null) {
                this.panel = this.display.getParameterPanel();
            } else {
                if (this.cl == null) {
                    this.cl = this.readClassName();
                }
                this.panel = PluginFactory.createDefaultParameterPanel(this.cl, PluginFactory.this.parent);
                if (this.panel == null) {
                    this.loadDisplay();
                    this.panel = this.display.getParameterPanel();
                }
            }
            if (this.panel == null) {
                throw new PluginException("Could not load parameter panel for class: " + this.cl);
            }
        }

        private void loadOptionsPane() throws PluginException {
            Frame pw;
            if (!this.params) {
                return;
            }
            if (this.opane != null && this.opane.getOwner() == SwingUtilities.getWindowAncestor(PluginFactory.this.parent)) {
                return;
            }
            this.opane = null;
            if (this.panel == null) {
                this.loadParameterPanel();
            }
            String title = this.menu != null ? this.menu : "";
            Dialog pd = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, PluginFactory.this.parent);
            this.opane = pd != null ? new OptionsPane(pd, this.key, title, this.panel, PluginFactory.this.okActionListener) : ((pw = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, PluginFactory.this.parent)) != null ? new OptionsPane(pw, this.key, title, this.panel, PluginFactory.this.okActionListener) : new OptionsPane(this.key, title, this.panel, PluginFactory.this.okActionListener));
            this.opane.setLocationRelativeTo(PluginFactory.this.parent);
        }

        private void loadPlugin() throws PluginException {
            if (this.plugin != null) {
                return;
            }
            if (this.cl == null) {
                this.cl = this.readClassName();
            }
            this.plugin = CalculatorPlugin.create(this.cl, this.jar);
        }

        private void loadDisplay() throws PluginException {
            if (this.display != null) {
                return;
            }
            this.loadPlugin();
            Class<CalculatorPluginDisplay> displayClass = this.plugin.loadClass(this.cl + "Display");
            if (displayClass == null) {
                displayClass = CalculatorPluginDisplay.class;
            }
            try {
                this.display = (CalculatorPluginDisplay)displayClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new PluginException(e);
            }
            catch (IllegalAccessException e) {
                throw new PluginException(e);
            }
            catch (SecurityException e) {
                throw new PluginException(e);
            }
            catch (ClassCastException e) {
                throw new PluginException(e);
            }
            this.display.setPlugin(this.plugin);
            this.display.setParent(PluginFactory.this.parent);
            this.display.setTitle(this.menu);
            this.display.setParameterPanel(this.panel);
        }

        private String readClassName() throws PluginException {
            if (this.jar == null) {
                throw new PluginException("No class specified for plugin: " + this.key);
            }
            String clattr = CalculatorPlugin.readAttribute("Plugin-Class", this.jar);
            if (clattr == null) {
                throw new PluginException("No class specified for plugin: " + this.key);
            }
            return clattr;
        }
    }
}

