/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.license.LicenseException;
import chemaxon.marvin.io.MDocSource;
import chemaxon.struc.MDocument;
import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;

public class PluginMDocSource
extends MDocSource {
    private Iterator iterator = null;
    private int maxCount = 0;
    private int currentCount = 0;

    public PluginMDocSource(Iterator iterator, int maxCount) {
        this.iterator = iterator;
        this.maxCount = maxCount;
    }

    public void limitRecordCount(int limit) {
        this.maxCount = this.maxCount == -1 ? limit : Math.min(this.maxCount, limit);
    }

    @Override
    public MDocument nextDoc() throws IOException {
        if (this.iterator.hasNext() && (this.maxCount == -1 || this.currentCount < this.maxCount)) {
            ++this.currentCount;
            try {
                return (MDocument)this.iterator.next();
            }
            catch (LicenseException e) {
                throw new IOException(e.getMessage());
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    @Override
    public boolean skipRecord() throws IOException {
        this.nextDoc();
        return this.iterator.hasNext();
    }

    @Override
    public boolean isRewindable() {
        return false;
    }

    @Override
    public void seekRecord(int k, MProgressMonitor pmon) throws EOFException, IOException {
    }

    @Override
    protected void seekVisitedRecord(int k) throws IOException {
    }

    @Override
    public boolean isEndReached() {
        return !this.iterator.hasNext();
    }

    @Override
    public int getRecordCount() {
        return this.currentCount;
    }

    @Override
    public int getRecordCountMax() {
        return this.maxCount;
    }

    @Override
    public int estimateNumRecords() {
        return this.maxCount;
    }
}

