/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.plugin.CalculatorPluginManager;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.PluginFactory;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.ExternalFileLoader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class PluginManager
implements CallbackIface {
    private static final String CONFIG_PARAM = "toolfiles";
    private PluginFactory factory = null;
    private CalculatorPluginManager cpm = null;
    private MolPanel mpan = null;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("init")) {
            boolean res = this.init((MolPanel)arg);
            return res ? this : null;
        }
        if (method.equals("saveParameterSettings")) {
            this.factory.saveParameterSettings();
            return null;
        }
        if (method.equals("getCount")) {
            return new Integer(this.factory.getCount());
        }
        if (method.equals("getMenu")) {
            return this.factory.getMenu((Integer)arg);
        }
        if (method.equals("getKey")) {
            return this.factory.getKey((Integer)arg);
        }
        if (method.equals("getMnemonic")) {
            return new Character(this.factory.getMnemonic((Integer)arg));
        }
        if (method.equals("getGroup")) {
            return this.factory.getGroup((Integer)arg);
        }
        if (method.equals("getGroupMnemonic")) {
            return new Character(this.factory.getGroupMnemonic((Integer)arg));
        }
        if (method.equals("getSeparator")) {
            return new Boolean(this.factory.getSeparator((Integer)arg));
        }
        if (this.cpm == null) {
            this.cpm = new CalculatorPluginManager(this.factory, this.mpan);
        }
        return this.cpm.callback(method, arg);
    }

    public boolean init(MolPanel mpan) {
        this.mpan = mpan;
        this.factory = new PluginFactory();
        String config = (String)mpan.callback("getParameter", CONFIG_PARAM);
        if (config != null) {
            StringTokenizer stc = new StringTokenizer(config, ",");
            while (stc.hasMoreTokens()) {
                Properties props;
                String filename = stc.nextToken();
                if (!filename.startsWith("/")) {
                    filename = "/" + filename;
                }
                if ((props = this.readConfig(filename)) == null) continue;
                try {
                    this.factory.load(props);
                }
                catch (PluginException e) {
                    mpan.getErrorDisplay().error("Could not load Tools menu from: " + filename, e);
                }
            }
        } else {
            try {
                this.factory.load();
            }
            catch (PluginException e) {
                mpan.getErrorDisplay().error("Could not load default Tools menu from:\n/xjars/plugins.properties", e);
            }
        }
        if (this.factory.getCount() == 0) {
            this.factory = null;
        }
        return this.factory != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readConfig(String filename) {
        Properties props;
        block15: {
            props = new Properties();
            InputStream is = null;
            ExternalFileLoader ppLoader = new ExternalFileLoader(filename);
            try {
                is = ppLoader.openFileOutJar();
                if (is == null) {
                    is = BasicEnvironment.getResourceAsStream(PluginManager.class, filename);
                }
                if (is != null) {
                    props.load(new BufferedInputStream(is));
                    break block15;
                }
                System.err.println("Config file not found: " + filename);
                Properties properties = null;
                return properties;
            }
            catch (IOException e) {
                this.mpan.getErrorDisplay().error("Could not load config file: " + filename, e);
                Properties properties = null;
                return properties;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    System.err.println("Config file can not be closed: " + filename);
                }
            }
        }
        return props;
    }
}

