/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.concurrent;

import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.CalculatorPluginCachedResults;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import chemaxon.util.concurrent.WorkUnit;
import java.util.concurrent.ExecutionException;

public abstract class PluginWorkUnit
implements WorkUnit {
    protected CalculatorPlugin plugin = null;
    protected Molecule target = null;
    private Exception inputError = null;

    public PluginWorkUnit() {
    }

    public PluginWorkUnit(CalculatorPlugin plugin) {
        this.setPlugin(plugin);
    }

    public void setPlugin(CalculatorPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void setInput(Object obj) throws ExecutionException {
        this.inputError = null;
        this.target = (Molecule)obj;
        try {
            this.plugin.checkMolecule(this.target);
            this.plugin.setMolecule(this.target);
        }
        catch (Exception e) {
            this.inputError = e;
        }
    }

    public Object call() throws Exception {
        try {
            if (this.inputError != null) {
                throw this.inputError;
            }
            if (!this.plugin.run()) {
                throw new PluginException(this.plugin.getResultMessage());
            }
            return this.getResult();
        }
        catch (Exception e) {
            return new CalculatorPluginCachedResults(this.getHeader(), null, null, null, null, null, this.getWrapperException(e), false);
        }
    }

    protected String getHeader() {
        return null;
    }

    public Exception getWrapperException(Exception e) {
        return e;
    }

    public abstract Object getResult() throws Exception;
}

