/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.marvin.plugin.gui.TextItem;
import java.util.StringTokenizer;

public class NumberItem
extends TextItem {
    static int REAL = 0;
    static int INTEGER = 1;
    int type = REAL;
    String range = null;
    double[] limits = null;

    NumberItem(String key, int type, String label, String tooltip, String text, String range, String defval) {
        super(key, label, tooltip, text, defval);
        this.type = type;
        this.range = range;
        this.setLimits();
    }

    private void setLimits() {
        String token;
        this.limits = new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        if (this.range == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.range, "[, \t]");
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            try {
                this.limits[0] = new Double(token);
            }
            catch (NumberFormatException e) {
                this.limits[0] = Double.NEGATIVE_INFINITY;
            }
        }
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            try {
                this.limits[1] = new Double(token);
            }
            catch (NumberFormatException e) {
                this.limits[1] = Double.POSITIVE_INFINITY;
            }
        }
    }

    @Override
    public String verify() {
        String text = this.textfield.getText();
        double value = 0.0;
        if (this.type == REAL) {
            try {
                value = Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                return this.label + ": not a real number : " + text;
            }
        }
        try {
            value = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return this.label + ": not an integer" + (this.range != null ? " in range " + this.range : "") + " : " + text;
        }
        if (value < this.limits[0] || value > this.limits[1]) {
            return this.label + ": value out of range " + this.range + " : " + text;
        }
        return null;
    }
}

