/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.plugin.ParameterPanelHandler;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.swing.ActionButton;
import chemaxon.marvin.swing.MAction;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class OptionsPane
extends JDialog
implements ActionListener,
WindowListener {
    private ParameterPanelHandler parameterPanel = null;
    private ActionListener okActionListener = null;
    private String key = null;
    private String title = null;
    private ActionButton ok = null;
    private ActionButton cancel = null;
    private ActionButton restoreDefaults = null;
    private static String OK_TOOLTIP_TEXT = "run the calculation and save the settings";
    private static String CANCEL_TOOLTIP_TEXT = "cancel and discard changes";
    private static String RESTORE_DEFAULTS_TOOLTIP_TEXT = "restore default settings";

    public OptionsPane(String key, String title, ParameterPanelHandler parameterPanel, ActionListener okActionListener) throws PluginException {
        this.init(key, title, parameterPanel, okActionListener);
    }

    public OptionsPane(Dialog owner, String key, String title, ParameterPanelHandler parameterPanel, ActionListener okActionListener) throws PluginException {
        super(owner);
        this.init(key, title, parameterPanel, okActionListener);
    }

    public OptionsPane(Frame owner, String key, String title, ParameterPanelHandler parameterPanel, ActionListener okActionListener) throws PluginException {
        super(owner);
        this.init(key, title, parameterPanel, okActionListener);
    }

    private void init(String key, String title, ParameterPanelHandler parameterPanel, ActionListener okActionListener) throws PluginException {
        this.title = title;
        this.setTitle(title + " Options");
        this.key = key;
        this.parameterPanel = parameterPanel;
        this.okActionListener = okActionListener;
        GridBagLayout gbl = new GridBagLayout();
        this.getContentPane().setLayout(gbl);
        JPanel panel = this.createCenterPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets.top = 5;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.insets.bottom = 5;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbl.setConstraints(panel, gbc);
        this.getContentPane().add(panel);
        this.addWindowListener(this);
        this.setResizable(false);
        this.pack();
    }

    private JPanel createCenterPanel() throws PluginException {
        JPanel center = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        center.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        ++gbc.gridy;
        center.add(this.parameterPanel.getComponent(), gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        center.add((Component)this.createButtonPanel(), gbc);
        return center;
    }

    private JPanel createButtonPanel() {
        MAction okAction = new MAction("plugin_" + this.key, MolPanel.GRESOURCES.getString("ok"));
        okAction.addActionListener(this);
        MAction cancelAction = new MAction("cancel", MolPanel.GRESOURCES.getString("cancel"));
        cancelAction.addActionListener(this);
        MAction restoreDefaultsAction = new MAction("restoreDefaults", MolPanel.GRESOURCES.getString("restoreDefaults"));
        restoreDefaultsAction.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        this.ok = new ActionButton(okAction);
        buttonPanel.add(this.ok);
        this.cancel = new ActionButton(cancelAction);
        buttonPanel.add(this.cancel);
        this.restoreDefaults = new ActionButton(restoreDefaultsAction);
        buttonPanel.add(this.restoreDefaults);
        this.ok.setToolTipText(OK_TOOLTIP_TEXT);
        this.cancel.setToolTipText(CANCEL_TOOLTIP_TEXT);
        this.restoreDefaults.setToolTipText(RESTORE_DEFAULTS_TOOLTIP_TEXT);
        this.ok.setEnabled(this.parameterPanel.isOkActionEnabled());
        this.getRootPane().setDefaultButton(this.ok);
        return buttonPanel;
    }

    public String getKey() {
        return this.key;
    }

    public void getParameters(Properties params) {
        this.parameterPanel.getParameters(params);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd;
        Object t = ev.getSource();
        if (t instanceof MAction && (cmd = ev.getActionCommand()) != null) {
            if (cmd.startsWith("plugin_")) {
                if (!this.parameterPanel.verifyParameters()) {
                    return;
                }
                this.setActionsEnabled(false);
                this.parameterPanel.saveParameters();
                if (this.okActionListener != null) {
                    this.okActionListener.actionPerformed(ev);
                }
            } else if (cmd.equals("cancel")) {
                this.close();
            } else if (cmd.equals("restoreDefaults")) {
                this.parameterPanel.restoreDefaultParameters();
            }
        }
    }

    private void close() {
        this.parameterPanel.reloadParameters();
        this.closeChilds();
        this.setVisible(false);
    }

    public void setActionsEnabled(boolean enable) {
        int cursorType = enable ? 0 : 3;
        this.setCursor(Cursor.getPredefinedCursor(cursorType));
        this.ok.setEnabled(enable);
        this.cancel.setEnabled(enable);
        this.restoreDefaults.setEnabled(enable);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.close();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private void closeChilds() {
        Window[] windows = this.getOwnedWindows();
        for (int i = 0; i < windows.length; ++i) {
            windows[i].dispose();
        }
    }

    static {
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
    }
}

