/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.marvin.plugin.gui.ParameterItemUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;

public abstract class ParameterItem
implements ActionListener {
    protected static int TOOLTIP_LINE_LENGTH = 80;
    protected String key = null;
    protected String tooltip = null;
    private int indentation = 0;
    Component[] components = null;
    Properties dependencies = null;
    ArrayList listeners = null;
    ParameterItem disabledBy = null;

    public ParameterItem(String key) {
        this.key = key;
    }

    public final void setIndentation(int indentation) {
        this.indentation = indentation;
    }

    public final int getIndentation() {
        return this.indentation;
    }

    public final String getKey() {
        return this.key;
    }

    public final Component[] getComponents() {
        return this.components;
    }

    public abstract String getValue();

    public String getTolTipText() {
        return ParameterItemUtil.convertToMultiLineHtmlString(this.tooltip);
    }

    public abstract void save();

    public abstract void reload();

    public abstract void restoreDefault();

    public String verify() {
        return null;
    }

    public boolean isValueInRange(String range) {
        return range.equals(this.getValue());
    }

    public void setDependency(String depkey, String deprange) {
        if (this.dependencies == null) {
            this.dependencies = new Properties();
        }
        this.dependencies.setProperty(depkey, deprange);
    }

    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.disabledBy == null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ParameterItem source;
        String range;
        Object o = e.getSource();
        if (o instanceof ParameterItem && (range = this.dependencies.getProperty((source = (ParameterItem)o).getKey())) != null) {
            boolean inrange = source.isValueInRange(range);
            if (inrange) {
                if (this.disabledBy == source) {
                    this.setEnabled(true);
                    this.disabledBy = null;
                }
            } else if (this.disabledBy == null) {
                this.setEnabled(false);
                this.disabledBy = source;
            }
        }
    }

    public void addActionListener(ActionListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    protected final void notifyListeners() {
        if (this.listeners != null) {
            ActionEvent e = new ActionEvent(this, 0, null);
            for (ActionListener l : this.listeners) {
                l.actionPerformed(e);
            }
        }
    }
}

