/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.marvin.plugin.ParameterPanelHandler;
import chemaxon.marvin.plugin.gui.ParameterGroup;
import chemaxon.marvin.plugin.gui.ParameterItem;
import chemaxon.marvin.plugin.gui.ParameterItemUtil;
import chemaxon.marvin.plugin.gui.ParameterTab;
import chemaxon.marvin.plugin.gui.SeparatorItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ParameterPanel
extends JPanel
implements ParameterPanelHandler {
    protected ParameterItem[] items = null;

    public ParameterPanel(ParameterTab pane, ParameterTab[] tabs) {
        this(pane, tabs, null);
    }

    public ParameterPanel(ParameterTab pane, ParameterTab[] tabs, ParameterItem[] items) {
        this.setLayout(new BorderLayout());
        ArrayList<ParameterItem> itemList = new ArrayList<ParameterItem>();
        if (items != null) {
            itemList.addAll(Arrays.asList(items));
            ParameterGroup group = null;
            ArrayList<ParameterGroup> groupList = new ArrayList<ParameterGroup>();
            if (!itemList.isEmpty()) {
                group = new ParameterGroup(null, null);
                group.setItems(new ParameterItem[itemList.size()]);
                itemList.toArray(group.getItems());
                groupList.add(group);
            }
            if (!groupList.isEmpty()) {
                pane = new ParameterTab(null, null);
                pane.setGroups(new ParameterGroup[groupList.size()]);
                groupList.toArray(pane.getGroups());
            }
        }
        if (pane != null) {
            JPanel panel = new JPanel();
            this.initTabPanel(panel, pane, itemList);
            this.add((Component)panel, tabs != null ? "South" : "Center");
        }
        if (tabs != null) {
            MTabbedPane tabbedPane = new MTabbedPane(1);
            for (int i = 0; i < tabs.length; ++i) {
                JPanel panel = new JPanel();
                this.initTabPanel(panel, tabs[i], itemList);
                tabbedPane.add(tabs[i].getTitle(), panel);
                tabbedPane.setToolTipTextAt(i, tabs[i].getToolTipText());
            }
            Dimension dim = tabbedPane.getPreferredSize();
            int width = Math.max(tabs.length * 80, dim.width);
            tabbedPane.setPreferredSize(new Dimension(width, dim.height));
            this.add((Component)tabbedPane, "Center");
        }
        if (items == null) {
            items = new ParameterItem[itemList.size()];
            itemList.toArray(items);
        }
        this.items = items;
        this.addDependencyListeners();
    }

    private void initTabPanel(JPanel panel, ParameterTab tab, ArrayList<ParameterItem> itemList) {
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        ParameterGroup[] groups = tab.getGroups();
        if (groups != null) {
            for (int i = 0; i < tab.getGroups().length; ++i) {
                itemList.addAll(Arrays.asList(tab.getGroups()[i].getItems()));
                ++gbc.gridy;
                GPanel subpanel = new GPanel();
                this.initTabPanelGroup(subpanel, tab.getGroups()[i]);
                panel.add((Component)subpanel, gbc);
            }
        } else {
            ++gbc.gridy;
            GPanel subpanel = new GPanel();
            panel.add((Component)subpanel, gbc);
        }
    }

    private void initTabPanelGroup(GPanel panel, ParameterGroup group) {
        if (group.getTitle() != null) {
            TitledBorder border = BorderFactory.createTitledBorder(group.getTitle());
            panel.setBorder(border);
        }
        if (group.getToolTipText() != null) {
            panel.setToolTipText(group.getToolTipText());
        }
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.top = 5;
        gbc.insets.right = 5;
        gbc.insets.bottom = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        ParameterItem[] items = group.getItems();
        for (int i = 0; i < items.length; ++i) {
            gbc.insets.left = 5 * (1 + items[i].getIndentation());
            Component[] components = items[i].getComponents();
            for (int j = 0; j < components.length; ++j) {
                int n = gbc.gridwidth = j == components.length - 1 ? 0 : 1;
                gbc.fill = items[i] instanceof SeparatorItem ? 2 : (components[j].getClass().isAssignableFrom(JTextField.class) ? 2 : 0);
                gbc.weightx = j;
                panel.add(components[j], gbc);
            }
        }
    }

    private void fillParameters(Properties params, boolean all) {
        params.clear();
        for (int i = 0; i < this.items.length; ++i) {
            if (!all && !this.items[i].isEnabled() || this.items[i].getKey() == null) continue;
            params.put(this.items[i].getKey(), this.items[i].getValue());
        }
    }

    private void addDependencyListeners() {
        int i;
        for (i = 0; i < this.items.length; ++i) {
            if (this.items[i].dependencies == null) continue;
            Enumeration<Object> depkeys = this.items[i].dependencies.keys();
            block1: while (depkeys.hasMoreElements()) {
                String depkey = (String)depkeys.nextElement();
                for (int j = 0; j < this.items.length; ++j) {
                    if (!depkey.equals(this.items[j].getKey())) continue;
                    this.items[j].addActionListener(this.items[i]);
                    continue block1;
                }
            }
        }
        for (i = this.items.length - 1; i >= 0; --i) {
            this.items[i].notifyListeners();
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void getParameters(Properties params) {
        this.fillParameters(params, false);
    }

    @Override
    public void getStoredParameters(Properties params) {
        this.fillParameters(params, true);
    }

    @Override
    public void saveParameters() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].save();
        }
    }

    @Override
    public void reloadParameters() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].reload();
            this.items[i].notifyListeners();
        }
    }

    @Override
    public void restoreDefaultParameters() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].restoreDefault();
            this.items[i].notifyListeners();
        }
    }

    @Override
    public boolean verifyParameters() {
        String error = null;
        for (int i = 0; i < this.items.length; ++i) {
            String vstr;
            if (!this.items[i].isEnabled() || (vstr = this.items[i].verify()) == null) continue;
            error = error == null ? vstr : error + "\n" + vstr;
        }
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, "Error", 0);
            return false;
        }
        return true;
    }

    @Override
    public boolean isOkActionEnabled() {
        return true;
    }

    private class MTabbedPane
    extends JTabbedPane {
        public MTabbedPane(int top) {
            super(top);
        }

        @Override
        public void setToolTipText(String text) {
            super.setToolTipText(ParameterItemUtil.convertToMultiLineHtmlString(text));
        }
    }

    private class GPanel
    extends JPanel {
        private GPanel() {
        }

        @Override
        public void setToolTipText(String text) {
            super.setToolTipText(ParameterItemUtil.convertToMultiLineHtmlString(text));
        }
    }
}

