/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.marvin.io.PositionedInputStream;
import chemaxon.marvin.io.formats.XmlImport;
import chemaxon.marvin.plugin.ParameterPanelHandler;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.plugin.gui.BooleanItem;
import chemaxon.marvin.plugin.gui.Choice;
import chemaxon.marvin.plugin.gui.ColorPaletteItem;
import chemaxon.marvin.plugin.gui.LabelItem;
import chemaxon.marvin.plugin.gui.MultipleSelectionItem;
import chemaxon.marvin.plugin.gui.NumberItem;
import chemaxon.marvin.plugin.gui.ParameterGroup;
import chemaxon.marvin.plugin.gui.ParameterItem;
import chemaxon.marvin.plugin.gui.ParameterPanel;
import chemaxon.marvin.plugin.gui.ParameterTab;
import chemaxon.marvin.plugin.gui.PrecisionItem;
import chemaxon.marvin.plugin.gui.RadioButtonGroupItem;
import chemaxon.marvin.plugin.gui.SeparatorItem;
import chemaxon.marvin.plugin.gui.SingleSelectionItem;
import chemaxon.marvin.plugin.gui.TextItem;
import chemaxon.marvin.util.Environment;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class ParameterPanelCreator
extends XmlImport {
    private static String PRECISION_ITEM_TOOLTIP_TEXT = "setting the number of decimal places with which the result value is given";

    public ParameterPanelHandler createPanel(String cl, Component parent, PositionedInputStream is, Properties settings) throws PluginException {
        try {
            this.initImport(is);
            ParameterPanel panel = this.createPanel(cl, parent, settings);
            is.close();
            return panel;
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    private ParameterPanel createPanel(String cl, Component parent, Properties settings) throws IOException {
        ArrayList<ParameterTab> tabList = new ArrayList<ParameterTab>();
        ArrayList<ParameterGroup> groupList = new ArrayList<ParameterGroup>();
        ArrayList<ParameterItem> itemList = new ArrayList<ParameterItem>();
        ArrayList<Choice> choiceList = new ArrayList<Choice>();
        ParameterTab pane = null;
        ParameterTab tab = null;
        ParameterGroup group = null;
        ParameterItem item = null;
        SingleSelectionItem single = null;
        MultipleSelectionItem multiple = null;
        RadioButtonGroupItem rbuttong = null;
        Choice defselectedChoice = null;
        String s = null;
        while ((s = this.readNextTag(null)) != null) {
            Choice[] choices;
            String tooltip;
            String label;
            String key;
            String tooltip2;
            String title;
            if (s.equals("Tab")) {
                if (!this.isTagClosing() || this.isTagSingle()) {
                    title = this.getTagProperty("Title");
                    tooltip2 = this.getTagProperty("Tooltip");
                    tab = new ParameterTab(title, tooltip2);
                }
                if (!this.isTagClosing()) continue;
                if (!itemList.isEmpty()) {
                    group = new ParameterGroup(null, null);
                    group.setItems(new ParameterItem[itemList.size()]);
                    itemList.toArray(group.getItems());
                    itemList.clear();
                    groupList.add(group);
                }
                tab.setGroups(new ParameterGroup[groupList.size()]);
                groupList.toArray(tab.getGroups());
                groupList.clear();
                tabList.add(tab);
                tab = null;
                continue;
            }
            if (s.equals("Group")) {
                if (!this.isTagClosing() || this.isTagSingle()) {
                    title = this.getTagProperty("Title");
                    if (title == null) {
                        title = "";
                    }
                    tooltip2 = this.getTagProperty("Tooltip");
                    group = new ParameterGroup(title, tooltip2);
                }
                if (!this.isTagClosing()) continue;
                group.setItems(new ParameterItem[itemList.size()]);
                itemList.toArray(group.getItems());
                itemList.clear();
                groupList.add(group);
                group = null;
                continue;
            }
            if (s.equals("Text")) {
                if (!this.isTagClosing() || this.isTagSingle()) {
                    key = this.getTagProperty("Key");
                    if (key == null) {
                        throw new IOException("Key attribute is mandatory for element: " + s);
                    }
                    label = this.getTagProperty("Label");
                    String defval = this.getTagProperty("Value");
                    tooltip = this.getTagProperty("Tooltip");
                    String value = ParameterPanelCreator.getValue(key, settings, defval);
                    item = new TextItem(key, label, tooltip, value, defval);
                    this.setIndentation(item);
                }
                if (!this.isTagClosing()) continue;
                itemList.add(item);
                item = null;
                continue;
            }
            if (s.equals("Boolean")) {
                if (!this.isTagClosing() || this.isTagSingle()) {
                    key = this.getTagProperty("Key");
                    if (key == null) {
                        throw new IOException("Key attribute is mandatory for element: " + s);
                    }
                    label = this.getTagProperty("Label");
                    String defval = this.getTagProperty("Value");
                    tooltip = this.getTagProperty("Tooltip");
                    boolean selected = "true".equalsIgnoreCase(ParameterPanelCreator.getValue(key, settings, defval));
                    boolean defsel = "true".equalsIgnoreCase(defval);
                    item = new BooleanItem(key, label, tooltip, selected, defsel);
                    this.setIndentation(item);
                    if (key.equals("mspace")) {
                        item.setEnabled(Environment.isMSpaceEnabled());
                    }
                }
                if (!this.isTagClosing()) continue;
                itemList.add(item);
                item = null;
                continue;
            }
            if (s.equals("Label")) {
                if (!this.isTagClosing() || this.isTagSingle()) {
                    String text = this.getTagProperty("Text");
                    if (text == null) {
                        throw new IOException("Text attribute is mandatory for element: " + s);
                    }
                    tooltip2 = this.getTagProperty("Tooltip");
                    item = new LabelItem(text, tooltip2);
                    this.setIndentation(item);
                }
                if (!this.isTagClosing()) continue;
                itemList.add(item);
                item = null;
                continue;
            }
            if (s.equals("Separator")) {
                if (!this.isTagClosing() || this.isTagSingle()) {
                    item = new SeparatorItem();
                    this.setIndentation(item);
                }
                if (!this.isTagClosing()) continue;
                itemList.add(item);
                item = null;
                continue;
            }
            if (s.equals("Number")) {
                if (!this.isTagClosing() || this.isTagSingle()) {
                    key = this.getTagProperty("Key");
                    if (key == null) {
                        throw new IOException("Key attribute is mandatory for element: " + s);
                    }
                    label = this.getTagProperty("Label");
                    int type = "int".equalsIgnoreCase(this.getTagProperty("Type")) || "integer".equalsIgnoreCase(this.getTagProperty("Type")) ? NumberItem.INTEGER : NumberItem.REAL;
                    String range = this.getTagProperty("Range");
                    String defval = this.getTagProperty("Value");
                    String tooltip3 = this.getTagProperty("Tooltip");
                    String value = ParameterPanelCreator.getValue(key, settings, defval);
                    item = new NumberItem(key, type, label, tooltip3, value, range, defval);
                    this.setIndentation(item);
                }
                if (!this.isTagClosing()) continue;
                itemList.add(item);
                item = null;
                continue;
            }
            if (s.equals("Precision")) {
                if (!this.isTagClosing() || this.isTagSingle()) {
                    key = this.getTagProperty("Key");
                    if (key == null) {
                        throw new IOException("Key attribute is mandatory for element: " + s);
                    }
                    label = this.getTagProperty("Label");
                    String defval = this.getTagProperty("Value");
                    tooltip = this.getTagProperty("Tooltip");
                    String value = ParameterPanelCreator.getValue(key, settings, defval);
                    item = new PrecisionItem(key, label, tooltip != null ? tooltip : PRECISION_ITEM_TOOLTIP_TEXT, value, defval);
                    this.setIndentation(item);
                }
                if (!this.isTagClosing()) continue;
                itemList.add(item);
                item = null;
                continue;
            }
            if (s.equals("ColorPalette")) {
                if (!this.isTagClosing() || this.isTagSingle()) {
                    key = this.getTagProperty("Key");
                    if (key == null) {
                        throw new IOException("Key attribute is mandatory for element: " + s);
                    }
                    label = this.getTagProperty("Label");
                    String defval = this.getTagProperty("Value");
                    String value = ParameterPanelCreator.getValue(key, settings, defval);
                    item = new ColorPaletteItem(key, label, value, defval);
                    this.setIndentation(item);
                    if (key.equals("mspacePalette")) {
                        item.setEnabled(Environment.isMSpaceEnabled());
                    }
                }
                if (!this.isTagClosing()) continue;
                itemList.add(item);
                item = null;
                continue;
            }
            if (s.equals("SingleSelection")) {
                String choiceListReaderJavaMethod;
                if (this.isTagSingle()) {
                    if (this.getTagProperty("ChoiceListReaderJavaMethod") != null) {
                        key = this.getTagProperty("Key");
                        if (key == null) {
                            throw new IOException("Key attribute is mandatory for element: " + s);
                        }
                        label = this.getTagProperty("Label");
                        String tooltip4 = this.getTagProperty("Tooltip");
                        choiceListReaderJavaMethod = this.getTagProperty("ChoiceListReaderJavaMethod");
                        single = new SingleSelectionItem(key, label, tooltip4, choiceListReaderJavaMethod);
                        item = single;
                        this.setIndentation(item);
                        itemList.add(single);
                        single = null;
                        continue;
                    }
                    throw new IOException("Selection element should have Item subnodes: " + s);
                }
                if (!this.isTagClosing()) {
                    key = this.getTagProperty("Key");
                    if (key == null) {
                        throw new IOException("Key attribute is mandatory for element: " + s);
                    }
                    label = this.getTagProperty("Label");
                    String tooltip5 = this.getTagProperty("Tooltip");
                    choiceListReaderJavaMethod = this.getTagProperty("ChoiceListReaderJavaMethod");
                    if (choiceListReaderJavaMethod != null) {
                        single = new SingleSelectionItem(key, label, tooltip5, choiceListReaderJavaMethod);
                        item = single;
                    } else {
                        single = new SingleSelectionItem(key, label, tooltip5);
                        item = single;
                    }
                    this.setIndentation(item);
                    continue;
                }
                if (single.getChoices() == null) {
                    single.setChoices(choiceList.toArray(new Choice[choiceList.size()]));
                    choiceList.clear();
                }
                itemList.add(single);
                single = null;
                continue;
            }
            if (s.equals("MultipleSelection")) {
                if (this.isTagSingle()) {
                    throw new IOException("Selection element should have Item subnodes: " + s);
                }
                if (!this.isTagClosing()) {
                    key = this.getTagProperty("Key");
                    if (key == null) {
                        throw new IOException("Key attribute is mandatory for element: " + s);
                    }
                    label = this.getTagProperty("Label");
                    String tooltip6 = this.getTagProperty("Tooltip");
                    multiple = new MultipleSelectionItem(key, label, tooltip6);
                    item = multiple;
                    this.setIndentation(item);
                    if (!"false".equalsIgnoreCase(this.getTagProperty("Verify"))) continue;
                    multiple.setVerifySelection(false);
                    continue;
                }
                choices = new Choice[choiceList.size()];
                choiceList.toArray(choices);
                multiple.setChoices(choices);
                choiceList.clear();
                itemList.add(multiple);
                multiple = null;
                continue;
            }
            if (s.equals("RadioButtonGroup")) {
                if (this.isTagSingle()) {
                    throw new IOException("Selection element should have Item subnodes: " + s);
                }
                if (!this.isTagClosing()) {
                    key = this.getTagProperty("Key");
                    if (key == null) {
                        throw new IOException("Key attribute is mandatory for element: " + s);
                    }
                    String title2 = this.getTagProperty("Title");
                    rbuttong = new RadioButtonGroupItem(key, title2);
                    item = rbuttong;
                    this.setIndentation(item);
                    continue;
                }
                choices = new Choice[choiceList.size()];
                choiceList.toArray(choices);
                Choice sel = null;
                for (int i = 0; i < choices.length; ++i) {
                    if (!choices[i].isSelected()) continue;
                    sel = choices[i];
                    break;
                }
                if (sel == null) {
                    defselectedChoice.setSelected(true);
                }
                rbuttong.setChoices(choices);
                choiceList.clear();
                itemList.add(rbuttong);
                rbuttong = null;
                continue;
            }
            if (s.equals("Choice")) {
                if (!this.isTagSingle()) {
                    throw new IOException("Item element should not have subnodes: " + s);
                }
                String value = this.getTagProperty("Value");
                if (value == null) {
                    throw new IOException("Value attribute is mandatory for element: " + s);
                }
                String text = this.getTagProperty("Text");
                if (text == null) {
                    throw new IOException("Text attribute is mandatory for element: " + s);
                }
                String tooltip7 = this.getTagProperty("Tooltip");
                String key2 = single != null ? single.key : (multiple != null ? multiple.key : rbuttong.key);
                boolean defselected = "true".equalsIgnoreCase(this.getTagProperty("Selected"));
                String defval = defselected ? value : null;
                boolean selected = ParameterPanelCreator.getSelected(key2, value, settings, defval);
                Choice choice = new Choice(value, text, tooltip7, selected, defselected);
                choiceList.add(choice);
                if (!defselected) continue;
                defselectedChoice = choice;
                continue;
            }
            if (s.equals("Dependencies") || !s.equals("Item")) continue;
            if (!this.isTagSingle()) {
                throw new IOException("Item element should not have subnodes: " + s);
            }
            key = this.getTagProperty("Key");
            if (key == null) {
                throw new IOException("Key attribute is mandatory for element: " + s);
            }
            String range = this.getTagProperty("Range");
            if (range == null) {
                throw new IOException("Range attribute is mandatory for element: " + s);
            }
            if (item == null) {
                throw new IOException("Dependency items should be subnodes of item elements: " + s);
            }
            item.setDependency(key, range);
        }
        if (!itemList.isEmpty()) {
            group = new ParameterGroup(null, null);
            group.setItems(new ParameterItem[itemList.size()]);
            itemList.toArray(group.getItems());
            groupList.add(group);
        }
        if (!groupList.isEmpty()) {
            pane = new ParameterTab(null, null);
            pane.setGroups(new ParameterGroup[groupList.size()]);
            groupList.toArray(pane.getGroups());
        }
        ParameterTab[] tabs = null;
        if (!tabList.isEmpty()) {
            tabs = new ParameterTab[tabList.size()];
            tabList.toArray(tabs);
        }
        return new ParameterPanel(pane, tabs);
    }

    private void setIndentation(ParameterItem item) {
        String indentProp = this.getTagProperty("Indent");
        if (indentProp != null) {
            item.setIndentation(Integer.valueOf(indentProp));
        }
    }

    private static String getValue(String key, Properties settings, String defval) {
        String value = defval;
        if (settings != null && ((value = settings.getProperty(key)) == null || value.length() == 0)) {
            value = defval;
        }
        return value;
    }

    private static boolean getSelected(String key, String value, Properties settings, String defval) {
        String setval = ParameterPanelCreator.getValue(key, settings, defval);
        if (setval == null) {
            return false;
        }
        if (setval.equals(value)) {
            return true;
        }
        char delim = ',';
        setval = delim + setval + delim;
        int k = setval.indexOf(delim + value + delim);
        return k != -1;
    }
}

