/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.marvin.plugin.gui.Choice;
import chemaxon.marvin.plugin.gui.ParameterItem;
import chemaxon.marvin.plugin.gui.ParameterItemUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioButtonGroupItem
extends ParameterItem {
    public static final char DELIMITER = ',';
    private MRadioButton[] radioButtons = null;
    ButtonGroup buttonGroup = new ButtonGroup();
    JPanel radioPanel = new JPanel(new GridLayout(0, 1));
    Choice[] choices = null;
    int index = 0;
    int defval = 0;

    RadioButtonGroupItem(String key, String title) {
        super(key);
        this.components = new Component[]{new JLabel(""), null};
    }

    void setChoices(Choice[] choices) {
        this.choices = choices;
        this.radioButtons = new MRadioButton[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            this.radioButtons[i] = new MRadioButton();
            this.radioButtons[i].setText(choices[i].getText());
            this.radioButtons[i].setToolTipText(choices[i].getToolTipText());
            this.radioButtons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RadioButtonGroupItem.this.notifyListeners();
                }
            });
            if (choices[i].isSelected()) {
                this.radioButtons[i].setSelected(true);
                this.index = i;
            }
            if (choices[i].isDefval()) {
                this.defval = i;
            }
            this.buttonGroup.add(this.radioButtons[i]);
            this.radioPanel.add(this.radioButtons[i]);
        }
        this.components[1] = this.radioPanel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.radioButtons.length; ++i) {
            this.radioButtons[i].setEnabled(enabled);
        }
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.radioButtons.length; ++i) {
            if (!this.radioButtons[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getValue() {
        int i = this.getSelectedIndex();
        return this.choices[i].getValue();
    }

    @Override
    public void save() {
        this.index = this.getSelectedIndex();
    }

    @Override
    public void reload() {
        this.radioButtons[this.index].setSelected(true);
    }

    @Override
    public void restoreDefault() {
        this.radioButtons[this.defval].setSelected(true);
    }

    @Override
    public boolean isValueInRange(String range) {
        char delim = ',';
        int k = (range = range + delim + range + delim).indexOf(delim + this.getValue() + delim);
        return k != -1;
    }

    private class MRadioButton
    extends JRadioButton {
        private MRadioButton() {
        }

        @Override
        public void setToolTipText(String text) {
            super.setToolTipText(ParameterItemUtil.convertToMultiLineHtmlString(text));
        }
    }
}

