/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.plugin.gui;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.swing.SaveImageTool;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class ResultView
extends JDialog
implements WindowListener,
ActionListener,
MouseListener,
CaretListener,
ItemListener {
    private static final long serialVersionUID = -5728800883025815500L;
    private static final Dimension VIEWPANEL_MIN_SIZE = new Dimension(240, 320);
    private static final Dimension VIEWPANEL_PREFERRED_SIZE = new Dimension(360, 360);
    private static final Dimension TOP_TEXTAREA_MIN_SIZE;
    private static final Dimension TOP_TEXTAREA_PREFERRED_SIZE;
    private static final Dimension BOTTOM_TEXTAREA_MIN_SIZE;
    private static final Dimension BOTTOM_TEXTAREA_PREFERRED_SIZE;
    private static final Dimension CHART_MIN_SIZE;
    private static final Dimension CHART_PREFERRED_SIZE;
    private MolPanel mpan = null;
    private JTextArea bottomTextArea = null;
    private JComponent bottomComponent = null;
    private JTextArea topTextArea = null;
    private JComponent topComponent = null;
    private JPanel chartPanel = null;
    private MarvinModule chart = null;
    private JMenu viewMenu = null;
    private JMenuItem copymi = null;
    private JMenuItem popupcopymi = null;
    private JMenuItem resetmi = null;
    private JPopupMenu popup = null;
    private JMenuItem detachmi = null;
    private Molecule[] viewMols = null;
    private String[] viewTexts = null;
    private ViewPanel viewPanel = null;
    private Molecule viewMol = null;
    private String viewText = null;
    private String imageFormat = null;

    public static Dimension getDim(String text) {
        int rows = 1;
        int cols = 0;
        int c = 0;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                ++rows;
                cols = Math.max(c, cols);
                c = 0;
                continue;
            }
            if (ch == '\t') {
                c += 8 - c % 8;
                continue;
            }
            ++c;
        }
        cols = Math.max(c, cols);
        return new Dimension(cols, rows);
    }

    private static JScrollPane createScrollPane(JComponent comp) {
        comp.setBackground(Color.white);
        JScrollPane sp = new JScrollPane(comp);
        comp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        return sp;
    }

    public ResultView(String title) {
        this(title, null);
    }

    public ResultView(String title, MolPanel mpan) {
        this.setTitle(title);
        this.mpan = mpan;
    }

    public ResultView(Dialog parent, String title, MolPanel mpan) {
        super(parent);
        this.setTitle(title);
        this.mpan = mpan;
    }

    public ResultView(Frame parent, String title, MolPanel mpan) {
        super(parent);
        this.setTitle(title);
        this.mpan = mpan;
    }

    public void setMenu() {
        this.setMenu(null);
    }

    public void setMenu(String[] view) {
        JMenuItem mi;
        this.popup = new JPopupMenu();
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menubar.add(menu);
        if (this.chart != null) {
            if (this.mpan != null) {
                menubar.getMenu(0).add(this.createSaveChartMenuItem());
            }
            menubar.getMenu(1).add(this.createCopyChartMenu());
        }
        StringTokenizer st = new StringTokenizer("Write to Console/wrcon/Close/close", "/");
        while (st.hasMoreTokens()) {
            mi = new JMenuItem(st.nextToken());
            menu.add(mi);
            String name = st.nextToken();
            mi.setName(name);
            mi.addActionListener(this);
        }
        menu = new JMenu("Edit");
        menubar.add(menu);
        st = new StringTokenizer("Copy/copy/Select All/selall", "/");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            mi = new JMenuItem(item);
            menu.add(mi);
            JMenuItem pmi = new JMenuItem(item);
            this.popup.add(pmi);
            String name = st.nextToken();
            mi.setName(name);
            pmi.setName("popup" + name);
            if (name.equals("copy")) {
                this.copymi = mi;
                this.popupcopymi = pmi;
                mi.setEnabled(false);
                pmi.setEnabled(false);
            }
            mi.addActionListener(this);
            pmi.addActionListener(this);
        }
        if (view != null) {
            menu = new JMenu("View");
            menubar.add(menu);
            this.resetmi = new JMenuItem(view[0]);
            menu.add(this.resetmi);
            this.resetmi.setName("reset");
            this.resetmi.setEnabled(false);
            this.resetmi.addActionListener(this);
            this.detachmi = new JMenuItem(view[1]);
            menu.add(this.detachmi);
            this.detachmi.setName("detach");
            this.detachmi.addActionListener(this);
            this.viewMenu = menu;
        }
        this.addWindowListener(this);
        this.setJMenuBar(menubar);
    }

    private JMenuItem createSaveChartMenuItem() {
        JMenuItem mi = new JMenuItem("Save Chart Image...");
        mi.setName("saveChartImage");
        mi.addActionListener(this);
        mi.setEnabled(!Environment.UNTRUSTED);
        return mi;
    }

    private JMenuItem createCopyChartMenu() {
        JMenuItem mi = new JMenuItem("Copy Chart Image...");
        mi.setName("copyimg");
        mi.addActionListener(this);
        mi.setEnabled(Environment.IMAGECOPY_ENABLED);
        return mi;
    }

    public void setBottomTextArea(String text) {
        Dimension dim = ResultView.getDim(text);
        this.bottomTextArea = new JTextArea(text, dim.height, dim.width);
        this.bottomTextArea.setEditable(false);
        this.bottomTextArea.setFont(new Font("Courier", 0, 12));
        this.bottomTextArea.addMouseListener(this);
        this.bottomTextArea.addCaretListener(this);
        this.bottomTextArea.setCaretPosition(0);
        this.bottomComponent = this.bottomTextArea;
    }

    public void setTopTextArea(String text) {
        Dimension dim = ResultView.getDim(text);
        this.topTextArea = new JTextArea(text, dim.height, dim.width);
        this.topTextArea.setEditable(false);
        this.topTextArea.setFont(new Font("Courier", 1, 12));
        this.topTextArea.addMouseListener(this);
        this.topTextArea.addCaretListener(this);
        this.topTextArea.setCaretPosition(0);
        this.topComponent = this.topTextArea;
    }

    public void setTopMolViewer(Molecule mol) {
        this.setTopMolViewer(mol, null);
    }

    public void setTopMolViewer(Molecule mol, String text) {
        this.setViewPanel(mol, text);
        this.topComponent = this.viewPanel;
        this.viewMol = mol;
    }

    private void setViewPanel(Molecule mol, String text) {
        int size = 200;
        int dim = mol.getDim();
        Color bgcolor = dim == 3 ? Color.black : Color.white;
        String bgstr = dim == 3 ? "#000000" : "#ffffff";
        String rendering = dim == 3 ? "ballstick" : "wireframe";
        Properties viewProps = new Properties();
        viewProps.put("rendering", rendering);
        viewProps.put("extrabonds", "arom,wedge");
        viewProps.put("molbg", bgstr);
        viewProps.put("viewmolbg2d", bgstr);
        viewProps.put("viewmolbg3d", bgstr);
        viewProps.put("rows", "1");
        viewProps.put("cols", "1");
        viewProps.put("layout", ":2:1:M:1:0:1:1:c:b:1:1:T:0:0:1:1:w:n:0:1");
        if (text != null) {
            viewProps.put("param", ":M:" + size + ":" + size + ":T:12b");
        } else {
            viewProps.put("param", ":M:" + size + ":" + size);
        }
        this.viewPanel = new ViewPanel(null, dim, null);
        this.viewPanel.setProperties(viewProps);
        this.viewPanel.setBorderWidth(1);
        this.viewPanel.setBackground(bgcolor);
        this.viewPanel.setMolbg(bgcolor);
        this.viewPanel.setEditable(0);
        this.setViewMol(mol);
        if (text != null) {
            this.viewPanel.setT(0, text);
        }
    }

    public void setChart(MarvinModule chart) {
        this.chart = chart;
        chart.modfunc(new Object[]{"addItemListener", this});
        this.viewMols = (Molecule[])chart.modfunc(new Object[]{"getLegendMols"});
        this.viewTexts = (String[])chart.modfunc(new Object[]{"getLegendTexts"});
        Component chartComp = (Component)chart.modfunc(new Object[]{"getChartComponent", null});
        this.chartPanel = new JPanel();
        this.chartPanel.setLayout(new BorderLayout());
        this.chartPanel.add(chartComp, "Center");
        JMenuBar menubar = this.getJMenuBar();
        if (menubar != null) {
            if (this.mpan != null) {
                menubar.getMenu(0).insert(this.createSaveChartMenuItem(), 0);
            }
            menubar.getMenu(1).insert(this.createCopyChartMenu(), 0);
        }
    }

    private void setSizes(JComponent component, Dimension minSize, Dimension prefSize) {
        component.setMinimumSize(minSize);
        component.setPreferredSize(prefSize);
    }

    private void setTopComponentSizes(JScrollPane topScrollPane) {
        if (this.viewPanel != null) {
            this.setSizes(this.viewPanel, VIEWPANEL_MIN_SIZE, VIEWPANEL_PREFERRED_SIZE);
            this.setSizes(topScrollPane, VIEWPANEL_MIN_SIZE, VIEWPANEL_PREFERRED_SIZE);
        } else if (this.topTextArea != null) {
            this.setSizes(this.topTextArea, TOP_TEXTAREA_MIN_SIZE, TOP_TEXTAREA_PREFERRED_SIZE);
            this.setSizes(topScrollPane, TOP_TEXTAREA_MIN_SIZE, TOP_TEXTAREA_PREFERRED_SIZE);
        } else {
            topScrollPane.setPreferredSize(new Dimension(160, 160));
        }
    }

    private void setBottomComponentSizes(JScrollPane bottomScrollPane) {
        this.setSizes(this.bottomComponent, BOTTOM_TEXTAREA_MIN_SIZE, BOTTOM_TEXTAREA_PREFERRED_SIZE);
        this.setSizes(bottomScrollPane, BOTTOM_TEXTAREA_MIN_SIZE, BOTTOM_TEXTAREA_PREFERRED_SIZE);
    }

    public void build() {
        JScrollPane topScrollPane;
        this.getContentPane().setLayout(new BorderLayout());
        if (this.viewMols != null) {
            String text;
            String string = text = this.viewTexts != null ? this.viewTexts[0] : null;
            if (this.viewPanel == null) {
                this.setViewPanel(this.viewMols[0], text);
            }
        }
        JComponent leftPane = null;
        if (this.topComponent != null && this.bottomComponent != null) {
            topScrollPane = ResultView.createScrollPane(this.topComponent);
            this.setTopComponentSizes(topScrollPane);
            JScrollPane bottomScrollPane = ResultView.createScrollPane(this.bottomComponent);
            this.setBottomComponentSizes(bottomScrollPane);
            JSplitPane splitPane = new JSplitPane(0, true, topScrollPane, bottomScrollPane);
            splitPane.setOneTouchExpandable(true);
            splitPane.setMinimumSize(new Dimension(240, 640));
            splitPane.setPreferredSize(new Dimension(360, 720));
            leftPane = splitPane;
        } else if (this.topComponent != null) {
            topScrollPane = ResultView.createScrollPane(this.topComponent);
            this.setTopComponentSizes(topScrollPane);
            leftPane = topScrollPane;
        } else if (this.bottomComponent != null) {
            JScrollPane bottomScrollPane = ResultView.createScrollPane(this.bottomComponent);
            this.setBottomComponentSizes(bottomScrollPane);
            leftPane = bottomScrollPane;
        }
        if (this.chartPanel != null && leftPane != null) {
            this.setSizes(this.chartPanel, CHART_MIN_SIZE, CHART_PREFERRED_SIZE);
            JSplitPane splitPane = new JSplitPane(1, true, leftPane, this.chartPanel);
            splitPane.setOneTouchExpandable(true);
            this.getContentPane().add((Component)splitPane, "Center");
        } else if (this.chartPanel != null) {
            this.setSizes(this.chartPanel, CHART_MIN_SIZE, CHART_PREFERRED_SIZE);
            this.getContentPane().add((Component)this.chartPanel, "Center");
        } else if (leftPane != null) {
            this.getContentPane().add((Component)leftPane, "Center");
        }
        if (this.detachmi != null) {
            this.detachmi.setEnabled(this.topTextArea == null);
        }
        if (this.viewPanel != null) {
            this.viewPanel.setDetachable(this.viewMenu != null);
        }
        this.pack();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.chart != null) {
            this.chart.modfunc(new Object[]{"removeItemListener", this});
            this.chart = null;
        }
        if (this.bottomTextArea != null) {
            this.bottomTextArea.removeCaretListener(this);
            this.bottomTextArea.removeMouseListener(this);
        }
        if (this.topTextArea != null) {
            this.topTextArea.removeCaretListener(this);
            this.topTextArea.removeMouseListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object t = e.getSource();
        if (t instanceof JMenuItem) {
            String name = ((JComponent)t).getName();
            if (name != null) {
                if (name.equals("wrcon")) {
                    if (this.topTextArea != null) {
                        System.out.println(this.topTextArea.getText());
                    }
                    if (this.bottomTextArea != null) {
                        System.out.println(this.bottomTextArea.getText());
                    }
                } else if (name.equals("close")) {
                    this.windowClosing(null);
                } else if (name.equals("copy")) {
                    this.copy(this.bottomTextArea);
                } else if (name.equals("popupcopy")) {
                    this.copy((JTextArea)this.popup.getInvoker());
                } else if (name.equals("selall")) {
                    this.selall(this.bottomTextArea);
                } else if (name.equals("popupselall")) {
                    this.selall((JTextArea)this.popup.getInvoker());
                } else if (name.equals("reset")) {
                    this.reset();
                } else if (name.equals("detach")) {
                    this.detach(1);
                } else if (name.equals("copyimg")) {
                    this.copyChartImage();
                } else if (name.equals("saveChartImage")) {
                    this.imageFormat = name;
                    Timer timer = new Timer(20, this);
                    timer.setRepeats(false);
                    timer.start();
                }
                return;
            }
        } else if (t instanceof Timer) {
            this.saveChartImage();
        }
    }

    private void copy(JTextArea ta) {
        ClipboardHandler.putStringToClipboard(ta.getSelectedText());
    }

    private void selall(JTextArea ta) {
        if (ta != null) {
            ta.requestFocus();
            ta.setSelectionStart(0);
            ta.setSelectionEnd(ta.getText().length());
        }
    }

    @Override
    public void caretUpdate(CaretEvent ev) {
        boolean enable = ev.getDot() != ev.getMark();
        this.copymi.setEnabled(enable);
        this.popupcopymi.setEnabled(enable);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.viewMols == null) {
            return;
        }
        Object item = e.getItem();
        int state = e.getStateChange();
        int index = (Integer)this.chart.modfunc(new Object[]{"getSeries", item});
        if (state == 1) {
            this.select(index);
        } else {
            this.reset();
        }
    }

    private void select(int index) {
        this.detach(0);
        if (this.topComponent != this.viewPanel) {
            this.topComponent = this.viewPanel;
            this.topComponent.revalidate();
            this.topComponent.repaint();
            if (this.detachmi != null) {
                this.detachmi.setEnabled(true);
            }
        }
        this.setViewMol(this.viewMols[index]);
        if (this.viewTexts != null) {
            this.setViewText(this.viewTexts[index]);
        }
        if (this.resetmi != null) {
            this.resetmi.setEnabled(true);
        }
    }

    private void reset() {
        this.detach(0);
        if (this.viewMol != null) {
            this.setViewMol(this.viewMol);
        }
        if (this.viewText != null) {
            this.setViewText(this.viewText);
        } else if (this.topTextArea != null && this.topComponent != this.topTextArea) {
            this.topComponent = this.topTextArea;
            this.topComponent.revalidate();
            this.topComponent.repaint();
            if (this.detachmi != null) {
                this.detachmi.setEnabled(false);
            }
        }
        if (this.resetmi != null) {
            this.resetmi.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detach(int mode) {
        this.viewPanel.beginHourglass();
        try {
            this.viewPanel.setWinmode(mode, 0);
        }
        finally {
            this.viewPanel.endHourglass();
        }
    }

    private void setViewMol(Molecule mol) {
        this.viewPanel.setM(0, mol);
    }

    private void setViewText(String text) {
        this.viewPanel.setT(0, text);
    }

    private void copyChartImage() {
        Dimension dim = this.chartPanel.getSize();
        Image image = (Image)this.chart.modfunc(new Object[]{"getChartImage", new Integer(dim.width), new Integer(dim.height)});
        ClipboardHandler.putImageToClipboard(image);
    }

    private void saveChartImage() {
        if (!this.mpan.showSaveImageFileChooser(3)) {
            return;
        }
        Dimension dim = this.chartPanel.getSize();
        SaveImageTool sit = this.mpan.getSaveImageTool();
        Object[] imgs = sit.createInitialImages(dim, this.chartPanel.getBackground(), 1.0, 1);
        if (imgs != null) {
            double relmag = sit.getMagnification();
            Color bgcolor = sit.getBackground();
            Graphics g = ((Image)imgs[0]).getGraphics();
            Image image = (Image)this.chart.modfunc(new Object[]{"getChartImage", new Integer(dim.width), new Integer(dim.height)});
            g.drawImage(image, 0, 0, dim.width, dim.height, bgcolor, null);
            sit.exportImage(imgs);
        }
    }

    static {
        TOP_TEXTAREA_PREFERRED_SIZE = TOP_TEXTAREA_MIN_SIZE = new Dimension(160, 100);
        BOTTOM_TEXTAREA_MIN_SIZE = VIEWPANEL_MIN_SIZE;
        BOTTOM_TEXTAREA_PREFERRED_SIZE = VIEWPANEL_PREFERRED_SIZE;
        CHART_MIN_SIZE = new Dimension(250, 250);
        CHART_PREFERRED_SIZE = new Dimension(500, 250);
    }
}

