/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services;

import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.services.ServiceDescriptorEditorProvider;
import chemaxon.marvin.services.ServiceDescriptorReader;
import chemaxon.marvin.services.ServiceDescriptorWriter;
import chemaxon.marvin.services.ServiceDialogProvider;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;

public class ServiceDescriptorTools {
    public static final String DEFAULT_SERVICE_DESCRIPTOR_READER_CLASSNAME = "chemaxon.marvin.services.config.XMLBasedServiceDescriptorReader";
    public static final String DEFAULT_SERVICE_DESCRIPTOR_WRITER_CLASSNAME = "chemaxon.marvin.services.config.XMLBasedServiceDescriptorWriter";
    public static final String DEFAULT_SERVICE_DIALOG_PROVIDER_CLASSNAME = "chemaxon.marvin.sketch.swing.modules.services.SketchBasedServiceDialogProvider";
    public static final String DEFAULT_SERVICE_DESCRIPTOR_EDITOR_PROVIDER_CLASSNAME = "chemaxon.marvin.services.ui.XMLBasedServiceDescriptorEditorProvider";
    public static final String DEFAULT_SERVICE_CONFIGURATION_PATH = "/chemaxon/marvin/services/config/resources/default.xml";
    public static final String DEFAULT_USER_SERVICE_CONFIGURATION_FILENAME = "servicesconfig.xml";

    public static ServiceDescriptorReader getDefaultServiceDescriptorReader() {
        return ServiceDescriptorTools.getServiceDescriptorReader(DEFAULT_SERVICE_DESCRIPTOR_READER_CLASSNAME);
    }

    public static ServiceDescriptorWriter getDefaultServiceDescriptorWriter() {
        return ServiceDescriptorTools.getServiceDescriptorWriter(DEFAULT_SERVICE_DESCRIPTOR_WRITER_CLASSNAME);
    }

    public static ServiceDialogProvider getDefaultServiceDialogProvider() {
        return ServiceDescriptorTools.getServiceDialogProvider(DEFAULT_SERVICE_DIALOG_PROVIDER_CLASSNAME);
    }

    public static ServiceDescriptorEditorProvider getDefaultServiceDescriptorEditorProvider() {
        return ServiceDescriptorTools.getServiceDescriptorEditorProvider(DEFAULT_SERVICE_DESCRIPTOR_EDITOR_PROVIDER_CLASSNAME);
    }

    public static InputStream getServiceDescriptorConfigurationAsStream() {
        return ServiceDescriptorTools.getServiceDescriptorConfigurationAsStream(new UserSettings());
    }

    public static InputStream getServiceDescriptorConfigurationAsStream(UserSettings settings) {
        String configPath = settings.getServicesConfigURL();
        InputStream configInputStream = null;
        if (configPath == null || "".equals(configPath)) {
            File file = DotfileUtil.getDotFile(DEFAULT_USER_SERVICE_CONFIGURATION_FILENAME);
            try {
                configInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {}
        } else {
            try {
                URL url = new URL(configPath);
                configInputStream = url.openStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (configInputStream == null) {
            configInputStream = ServiceDescriptorTools.class.getResourceAsStream(DEFAULT_SERVICE_CONFIGURATION_PATH);
        }
        return configInputStream;
    }

    public static ServiceDescriptorReader getServiceDescriptorReader(String descriptorReaderClassName) {
        ServiceDescriptorReader reader = null;
        try {
            Class<?> sdrClass = Class.forName(descriptorReaderClassName);
            reader = (ServiceDescriptorReader)sdrClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reader;
    }

    public static ServiceDescriptorWriter getServiceDescriptorWriter(String descriptorWriterClassName) {
        ServiceDescriptorWriter writer = null;
        try {
            Class<?> sdrClass = Class.forName(descriptorWriterClassName);
            writer = (ServiceDescriptorWriter)sdrClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return writer;
    }

    public static ServiceDialogProvider getServiceDialogProvider(String serviceDialogProviderClassName) {
        ServiceDialogProvider provider = null;
        try {
            Class<?> sdpClass = Class.forName(serviceDialogProviderClassName);
            provider = (ServiceDialogProvider)sdpClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return provider;
    }

    public static ServiceDescriptorEditorProvider getServiceDescriptorEditorProvider(String serviceDescriptorEditorProviderClassName) {
        ServiceDescriptorEditorProvider provider = null;
        try {
            Class<?> sdepClass = Class.forName(serviceDescriptorEditorProviderClassName);
            provider = (ServiceDescriptorEditorProvider)sdepClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return provider;
    }
}

