/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.json;

import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceDescriptorEditor;
import chemaxon.marvin.services.ServiceException;
import chemaxon.marvin.services.json.JsonProcessor;
import chemaxon.marvin.services.json.JsonServiceDescriptor;
import chemaxon.marvin.services.ui.ArgumentEditorFactory;
import chemaxon.marvin.services.ui.ServiceArgumentEditor;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;

public class JsonServiceDescriptorEditor
implements ServiceDescriptorEditor<JsonServiceDescriptor> {
    private JsonProcessor rpcDescriptor;
    private static final Set<Class<?>> supportedClasses = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Double.class, Integer.class, String.class)));
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean valid = false;
    private JPanel panel;
    private JTextField descriptorURIText;
    private JButton browseButton;
    private JFileChooser fileChooser;
    private JTextField serviceURLText = null;
    private JComboBox operationSelector = null;
    private JComboBox methodCombo = null;
    private ServiceArgumentEditor argumentEditor = null;

    @Override
    public JComponent getEditor() {
        if (this.panel == null) {
            this.rpcDescriptor = new JsonProcessor();
            CellConstraints cc = new CellConstraints();
            FormLayout layout = new FormLayout("pref, 2dlu, fill:min:grow, 4dlu, pref, 2dlu, pref", "2dlu, min, 2dlu, min, 2dlu, min, 2dlu, fill:min:grow, 2dlu");
            layout.setColumnGroups((int[][])new int[][]{{3, 5}});
            this.panel = new JPanel((LayoutManager)layout);
            this.panel.add((Component)new JLabel("Service descriptor: "), cc.xy(1, 2));
            this.panel.add((Component)this.getDescriptorURIText(), cc.xyw(3, 2, 3));
            this.panel.add((Component)this.getBrowseButton(), cc.xy(7, 2));
            this.panel.add((Component)new JLabel("Service URL: "), cc.xy(1, 4));
            this.panel.add((Component)this.getServiceURLText(), cc.xyw(3, 4, 3));
            this.panel.add((Component)this.getMethodCombo(), cc.xy(7, 4));
            this.panel.add((Component)new JLabel("Operation: "), cc.xy(1, 6));
            this.panel.add((Component)this.getOperationSelector(), cc.xyw(3, 6, 5));
            this.panel.add((Component)new JScrollPane(this.getServiceArgumentEditor().getEditor()), cc.xyw(1, 8, 7));
        }
        return this.panel;
    }

    private JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton("Browse");
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JsonServiceDescriptorEditor.this.getFileChooser().showOpenDialog(JsonServiceDescriptorEditor.this.getEditor()) == 0) {
                        JsonServiceDescriptorEditor.this.getDescriptorURIText().setText("file://localhost/" + JsonServiceDescriptorEditor.this.getFileChooser().getSelectedFile().getAbsolutePath());
                        JsonServiceDescriptorEditor.this.validateURI();
                    }
                }
            });
        }
        return this.browseButton;
    }

    private boolean validateURI() {
        try {
            this.rpcDescriptor.setURI(this.getDescriptorURIText().getText());
            this.updateOperationSelector();
            this.getServiceURLText().setText(this.rpcDescriptor.getServiceURL());
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getEditor(), "The entered descriptor is not valid!", "Descriptor error", 0);
            e.printStackTrace();
            return false;
        }
    }

    private JTextField getDescriptorURIText() {
        if (this.descriptorURIText == null) {
            this.descriptorURIText = new JTextField();
            this.descriptorURIText.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    JsonServiceDescriptorEditor.this.validateURI();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.descriptorURIText.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    JsonServiceDescriptorEditor.this.validateURI();
                }
            });
        }
        return this.descriptorURIText;
    }

    private JComboBox getMethodCombo() {
        if (this.methodCombo == null) {
            this.methodCombo = new JComboBox<Object>(new Object[]{JsonServiceDescriptor.Method.GET, JsonServiceDescriptor.Method.POST});
        }
        return this.methodCombo;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            try {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".json");
                    }

                    @Override
                    public String getDescription() {
                        return "JSON Web Service Descriptor (*.json)";
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileChooser;
    }

    private JTextField getServiceURLText() {
        if (this.serviceURLText == null) {
            this.serviceURLText = new JTextField();
            this.serviceURLText.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    JsonServiceDescriptorEditor.this.validate();
                }
            });
        }
        return this.serviceURLText;
    }

    private JComboBox getOperationSelector() {
        if (this.operationSelector == null) {
            this.operationSelector = new JComboBox();
            this.operationSelector.setEditable(true);
            this.operationSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultComboBoxModel model;
                    if (e.getActionCommand().equals("comboBoxEdited") && (model = (DefaultComboBoxModel)JsonServiceDescriptorEditor.this.operationSelector.getModel()).getIndexOf(JsonServiceDescriptorEditor.this.operationSelector.getSelectedItem()) < 0) {
                        model.insertElementAt(JsonServiceDescriptorEditor.this.operationSelector.getSelectedItem(), 0);
                    }
                    if (e.getActionCommand().equals("comboBoxChanged")) {
                        JsonServiceDescriptorEditor.this.updateArgumentEditor();
                        JsonServiceDescriptor.Method method = JsonServiceDescriptorEditor.this.rpcDescriptor.getMethod(JsonServiceDescriptorEditor.this.operationSelector.getSelectedItem().toString());
                        if (method == null) {
                            method = JsonServiceDescriptor.Method.GET;
                        }
                        JsonServiceDescriptorEditor.this.getMethodCombo().setSelectedItem((Object)method);
                        JsonServiceDescriptorEditor.this.getPropertyChangeSupport().firePropertyChange("PreferredName", null, JsonServiceDescriptorEditor.this.getOperationSelector().getSelectedItem());
                        String description = JsonServiceDescriptorEditor.this.rpcDescriptor.getDescription(JsonServiceDescriptorEditor.this.getOperationSelector().getSelectedItem().toString());
                        JsonServiceDescriptorEditor.this.getPropertyChangeSupport().firePropertyChange("PreferredDescription", null, description == null ? "" : description);
                        JsonServiceDescriptorEditor.this.validate();
                    }
                }
            });
        }
        return this.operationSelector;
    }

    private ServiceArgumentEditor getServiceArgumentEditor() {
        if (this.argumentEditor == null) {
            this.argumentEditor = ArgumentEditorFactory.createServiceArgumentEditor(true, supportedClasses);
            Component editor = this.argumentEditor.getEditor();
            if (editor instanceof JTable) {
                ((JTable)editor).getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                    }
                });
            }
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                }
            };
            this.argumentEditor.getEditor().addPropertyChangeListener("serviceArgument", listener);
        }
        return this.argumentEditor;
    }

    @Override
    public JsonServiceDescriptor getDescriptor() {
        this.validate();
        if (this.isValid()) {
            JsonServiceDescriptor descriptor = new JsonServiceDescriptor();
            descriptor.setDescriptorURI(this.getDescriptorURIText().getText());
            descriptor.setURL(this.getServiceURLText().getText());
            descriptor.setMethodName(this.getOperationSelector().getSelectedItem().toString());
            descriptor.setRequestMethod((JsonServiceDescriptor.Method)((Object)this.getMethodCombo().getSelectedItem()));
            for (ServiceArgument<?> argument : this.getServiceArgumentEditor().getServiceArguments()) {
                descriptor.addArgument(argument);
            }
            return descriptor;
        }
        return null;
    }

    @Override
    public void setDescriptor(JsonServiceDescriptor descriptor) {
        if (descriptor == null) {
            this.getDescriptorURIText().setText("");
            this.getServiceURLText().setText("");
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            this.getOperationSelector().setModel(model);
            this.getServiceArgumentEditor().setServiceArguments(new LinkedList());
            return;
        }
        if (descriptor.getDescriptorURI() == null || descriptor.getDescriptorURI().isEmpty()) {
            this.getDescriptorURIText().setText("");
            if (descriptor.getURL() != null) {
                this.getServiceURLText().setText(descriptor.getURL());
            } else {
                this.getServiceURLText().setText("");
            }
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            if (descriptor.getMethodName() != null) {
                model.addElement(descriptor.getMethodName());
            }
            this.getOperationSelector().setModel(model);
        } else {
            this.getDescriptorURIText().setText(descriptor.getDescriptorURI());
            this.validateURI();
            this.updateArgumentEditor();
        }
        this.getOperationSelector().setSelectedItem(descriptor.getMethodName());
        this.getMethodCombo().setSelectedItem((Object)descriptor.getRequestMethod());
        this.getServiceArgumentEditor().setServiceArguments(descriptor.getArguments());
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void validate() {
        boolean oldValue = this.isValid();
        this.valid = this.getServiceURLText().getText() != null && this.getServiceURLText().getText().length() != 0 && this.operationSelector.getSelectedItem() != null && this.operationSelector.getSelectedItem().toString().length() != 0;
        this.getEditor().firePropertyChange("EditorValid", oldValue, this.valid);
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    private void updateOperationSelector() {
        if (this.rpcDescriptor == null || this.rpcDescriptor.getOperations() == null || this.rpcDescriptor.getOperations().length == 0 || !this.rpcDescriptor.isValid()) {
            this.getOperationSelector().setModel(new DefaultComboBoxModel());
            this.getOperationSelector().setEditable(true);
            return;
        }
        String[] methodList = this.rpcDescriptor.getOperations();
        this.getOperationSelector().setModel(new DefaultComboBoxModel<String>(methodList));
        this.getOperationSelector().setEditable(false);
        this.getOperationSelector().setSelectedIndex(0);
    }

    private void updateArgumentEditor() {
        if (this.rpcDescriptor != null && this.rpcDescriptor.isValid() && this.getOperationSelector().getSelectedItem() != null) {
            try {
                List<String[]> parameters = this.rpcDescriptor.getParameters(this.getOperationSelector().getSelectedItem().toString());
                LinkedList arguments = new LinkedList();
                for (String[] parameter : parameters) {
                    ServiceArgument<Object> argument = ServiceArgument.createArgumentAs(null, JsonProcessor.typeMap.get(parameter[1]));
                    argument.setName(parameter[0]);
                    arguments.add(argument);
                }
                ServiceArgumentEditor editor = this.getServiceArgumentEditor();
                editor.setServiceArguments(arguments);
            }
            catch (ServiceException e) {
                JOptionPane.showMessageDialog(this.getEditor(), "Not a valid descriptor: " + e.getMessage(), "Descriptor error", 0);
            }
        }
    }
}

