/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.soap;

import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceException;
import chemaxon.marvin.services.ServiceHandler;
import chemaxon.marvin.services.soap.SoapServiceDescriptor;
import chemaxon.marvin.services.soap.WSDLProcessor;
import java.net.URL;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class SoapServiceHandler
extends ServiceHandler<SoapServiceDescriptor> {
    @Override
    public Object callService(SoapServiceDescriptor descriptor, Object ... arguments) throws ServiceException {
        try {
            return this.invokeSOAPRPCrequest(descriptor, arguments);
        }
        catch (Exception cause) {
            throw new ServiceException(cause);
        }
    }

    private Object invokeSOAPRPCrequest(SoapServiceDescriptor descriptor, Object[] arguments) throws Exception {
        SOAPConnection soapConnection = SOAPConnectionFactory.newInstance().createConnection();
        SOAPFactory soapFactory = SOAPFactory.newInstance();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        envelope.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
        envelope.getHeader().detachNode();
        SOAPBody body = envelope.getBody();
        Name babelFishRequestName = envelope.createName(descriptor.getMethodName(), "xs-req", descriptor.getNameSpace());
        SOAPBodyElement soapMethod = body.addBodyElement(babelFishRequestName);
        int index = 0;
        for (ServiceArgument<?> argument : descriptor.getArguments()) {
            soapMethod.addChildElement(soapFactory.createElement(argument.getName()).addTextNode(String.valueOf(arguments[index])));
            ++index;
        }
        soapMessage.saveChanges();
        URL endpoint = new URL(descriptor.getURL().concat("/").concat(descriptor.getMethodName()));
        SOAPMessage reply = null;
        reply = soapConnection.call(soapMessage, (Object)endpoint);
        WSDLProcessor wsdl = new WSDLProcessor(descriptor.getWsdlURI());
        Object retVal = this.normalizeResult(wsdl.getValueOf(reply));
        soapConnection.close();
        return retVal;
    }

    private Object normalizeResult(Object[] SOAPresult) {
        if (SOAPresult == null) {
            return null;
        }
        if (SOAPresult.length == 1) {
            return SOAPresult[0];
        }
        return SOAPresult;
    }
}

