/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.ui;

import chemaxon.marvin.services.ChemicalTermsArgument;
import chemaxon.marvin.services.DynamicArgument;
import chemaxon.marvin.services.MoleculeExporterArgument;
import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ui.ServiceArgumentEditor;
import chemaxon.marvin.services.ui.ServiceArgumentTableCellSupport;
import chemaxon.marvin.sketch.swing.modules.services.SketchBasedDocumentArgument;
import chemaxon.marvin.sketch.swing.modules.services.SketchBasedMoleculeArgument;
import chemaxon.marvin.sketch.swing.modules.services.SketchBasedSelectionArgument;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class ArgumentEditorFactory {
    public static ServiceArgumentEditor createServiceArgumentEditor() {
        return ArgumentEditorFactory.createServiceArgumentEditor(false, Collections.EMPTY_SET);
    }

    public static ServiceArgumentEditor createServiceArgumentEditor(boolean allowNewRow, Set<Class<?>> supportedClasses) {
        ArgumentTable argumentTable = new ArgumentTable(allowNewRow, supportedClasses);
        argumentTable.setAutoResizeMode(3);
        return argumentTable;
    }

    public static ServiceArgumentEditor createFillArgumentTable(List<ServiceArgument<?>> arguments) {
        SimpleArgumentTable argumentTable = new SimpleArgumentTable();
        argumentTable.setServiceArguments(arguments);
        argumentTable.setAutoResizeMode(3);
        return argumentTable;
    }

    private static class SimpleArgumentTable
    extends JTable
    implements ServiceArgumentEditor {
        private static final long serialVersionUID = 7327813364855158581L;
        private static final int NAME_COL_INDEX = 0;
        private static final int VALUE_COL_INDEX = 1;
        private final List<ServiceArgument<?>> arguments = new ArrayList();
        private final TableCellRenderer valueRenderer = new ServiceArgumentTableCellSupport(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof DynamicArgument && component instanceof JTextComponent) {
                    component = new JLabel(((DynamicArgument)value).getPlaceholderText());
                    ((JLabel)component).setOpaque(true);
                }
                ServiceArgumentTableCellSupport.decorateComponent(table, component, isSelected, hasFocus);
                return component;
            }
        };
        private final TableCellEditor valueEditor = new ServiceArgumentTableCellSupport();

        private SimpleArgumentTable() {
            super(new DefaultTableModel(new Object[]{"Name", "Value"}, 0));
            this.getColumnModel().getColumn(1).setCellRenderer(this.valueRenderer);
            this.getColumnModel().getColumn(1).setCellEditor(this.valueEditor);
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return null;
            }
            if (this.arguments.get(row) instanceof DynamicArgument) {
                return null;
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public void setServiceArguments(List<ServiceArgument<?>> arguments) {
            this.arguments.clear();
            this.arguments.addAll(arguments);
            ((DefaultTableModel)this.getModel()).setRowCount(0);
            ((DefaultTableModel)this.getModel()).setRowCount(arguments.size());
            for (int i = 0; i < arguments.size(); ++i) {
                this.setValueAt(arguments.get(i).getName(), i, 0);
                this.setValueAt(arguments.get(i), i, 1);
            }
        }

        @Override
        public List<ServiceArgument<?>> getServiceArguments() {
            return this.arguments;
        }

        @Override
        public boolean hasValidArguments() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, 1) != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public Component getEditor() {
            return this;
        }
    }

    private static class ArgumentTable
    extends JTable
    implements ServiceArgumentEditor {
        private static final int CLASS_COL_INDEX = 0;
        private static final int NAME_COL_INDEX = 1;
        private static final int EVAL_COL_INDEX = 2;
        private static final int VALUE_COL_INDEX = 3;
        private final TableCellEditor evaluationEditor = new DefaultCellEditor(new JComboBox());
        private final boolean allowNewRow;

        private ArgumentTable(boolean allowNewRow, Set<Class<?>> supportedClasses) {
            super(new DefaultTableModel(new Object[]{"Type", "Name", "Evaluation", "Value"}, allowNewRow ? 1 : 0));
            JComboBox<Object> classEditorCombo = new JComboBox<Object>();
            classEditorCombo.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof Class) {
                        label.setForeground(Color.BLACK);
                        label.setText(((Class)value).getSimpleName());
                    } else {
                        label.setForeground(Color.GRAY);
                    }
                    return label;
                }
            });
            final JTextField nameEditorText = new JTextField();
            nameEditorText.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    if (ArgumentTable.this.getEditingRow() != -1 && ArgumentTable.this.getValueAt(ArgumentTable.this.getEditingRow(), 3) instanceof ServiceArgument) {
                        ((ServiceArgument)ArgumentTable.this.getValueAt(ArgumentTable.this.getEditingRow(), 3)).setName(nameEditorText.getText());
                    }
                    ArgumentTable.this.firePropertyChange("serviceArgument", false, true);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
            this.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(classEditorCombo));
            this.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(nameEditorText));
            this.getColumnModel().getColumn(3).setCellEditor(new ServiceArgumentTableCellSupport());
            this.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    label.setForeground(Color.BLACK);
                    if (value instanceof Class) {
                        label.setText(((Class)value).getSimpleName());
                    } else if (value == null) {
                        label.setForeground(Color.GRAY);
                        label.setText("<Select Type>");
                    }
                    return label;
                }
            });
            this.getColumnModel().getColumn(3).setCellRenderer(new ServiceArgumentTableCellSupport());
            this.allowNewRow = allowNewRow;
            if (allowNewRow) {
                for (Class<?> supportedClass : supportedClasses) {
                    classEditorCombo.addItem(supportedClass);
                }
                String REMOVE_ITEM = "<Remove Argument>";
                classEditorCombo.addItem("<Remove Argument>");
                classEditorCombo.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1 && "<Remove Argument>".equals(e.getItem())) {
                            if (JOptionPane.showConfirmDialog(ArgumentTable.this, "Do you want to remove this argument?", "Remove argument", 0) == 0) {
                                final int row = ArgumentTable.this.getEditingRow();
                                if (ArgumentTable.this.getCellEditor() != null) {
                                    ArgumentTable.this.getCellEditor().cancelCellEditing();
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (row != -1) {
                                            if (ArgumentTable.this.getRowCount() > 1) {
                                                ((DefaultTableModel)ArgumentTable.this.getModel()).removeRow(row);
                                            } else {
                                                for (int i = 0; i < ArgumentTable.this.getColumnCount(); ++i) {
                                                    ArgumentTable.this.setValueAt(null, ArgumentTable.this.getSelectedRow(), i);
                                                }
                                            }
                                        }
                                    }
                                });
                            } else if (ArgumentTable.this.getCellEditor() != null) {
                                ArgumentTable.this.getCellEditor().cancelCellEditing();
                            }
                        }
                    }
                });
            }
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            if (this.getEditingColumn() != 3) {
                int row = this.getEditingRow();
                super.editingStopped(e);
                DynamicArgument argument = null;
                if (this.getValueAt(row, 0) instanceof Class && this.getValueAt(row, 2) instanceof EvaluationType) {
                    Class argumentClass = (Class)this.getValueAt(row, 0);
                    String value = this.getValueAt(row, 3) instanceof ServiceArgument ? String.valueOf(((ServiceArgument)this.getValueAt(row, 3)).getValue()) : "";
                    switch ((EvaluationType)((Object)this.getValueAt(row, 2))) {
                        case MANUAL: {
                            argument = ServiceArgument.createConstantFromString(value, argumentClass);
                            break;
                        }
                        case CHEMICAL_TERMS: {
                            if (this.getValueAt(row, 3) instanceof ChemicalTermsArgument) {
                                value = ((ChemicalTermsArgument)this.getValueAt(row, 3)).getExpression();
                            }
                            argument = new ChemicalTermsArgument(value);
                            ((ChemicalTermsArgument)argument).setType(argumentClass);
                            break;
                        }
                        case MOLECULE_FORMAT: {
                            if (this.getValueAt(row, 3) instanceof MoleculeExporterArgument) {
                                value = ((MoleculeExporterArgument)this.getValueAt(row, 3)).getExpression();
                            }
                            argument = new MoleculeExporterArgument();
                            break;
                        }
                        case ACTIVE_DOCUMENT: {
                            argument = new SketchBasedDocumentArgument();
                            break;
                        }
                        case ACTIVE_MOLECULE: {
                            argument = new SketchBasedMoleculeArgument();
                            break;
                        }
                        case ACTIVE_SELECTION: {
                            argument = new SketchBasedSelectionArgument();
                        }
                    }
                    if (argument != null) {
                        Object name = this.getValueAt(row, 1);
                        argument.setName(name == null ? null : String.valueOf(name));
                    }
                }
                this.setValueAt(argument, row, 3);
            } else {
                super.editingStopped(e);
            }
            if (this.allowNewRow && this.getValueAt(this.getRowCount() - 1, 0) != null) {
                ((DefaultTableModel)this.getModel()).insertRow(this.getRowCount(), new Object[]{null, null, null, null});
            }
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0 && !this.allowNewRow) {
                return null;
            }
            if (column == 2) {
                if (this.allowNewRow && this.getValueAt(row, 0) == null) {
                    return null;
                }
                JComboBox combo = (JComboBox)this.evaluationEditor.getTableCellEditorComponent(this, null, false, row, column);
                combo.removeAllItems();
                Object value = this.getValueAt(row, 0);
                if (Molecule.class.equals(value)) {
                    combo.addItem(EvaluationType.CHEMICAL_TERMS);
                    combo.addItem(EvaluationType.ACTIVE_MOLECULE);
                    combo.addItem(EvaluationType.ACTIVE_SELECTION);
                } else if (MDocument.class.equals(value)) {
                    combo.addItem(EvaluationType.ACTIVE_DOCUMENT);
                } else {
                    if (String.class.equals(value)) {
                        combo.addItem(EvaluationType.MOLECULE_FORMAT);
                    }
                    combo.addItem(EvaluationType.CHEMICAL_TERMS);
                    combo.addItem(EvaluationType.MANUAL);
                }
                return this.evaluationEditor;
            }
            if (column == 3 && (this.allowNewRow && this.getValueAt(row, 2) == null || this.getValueAt(row, 2) != EvaluationType.MANUAL && this.getValueAt(row, 2) != EvaluationType.CHEMICAL_TERMS && this.getValueAt(row, 2) != EvaluationType.MOLECULE_FORMAT)) {
                return null;
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public void setServiceArguments(List<ServiceArgument<?>> argumentList) {
            ((DefaultTableModel)this.getModel()).setRowCount(0);
            ((DefaultTableModel)this.getModel()).setRowCount(argumentList.size());
            for (int i = 0; i < argumentList.size(); ++i) {
                this.setValueAt(argumentList.get(i).getType(), i, 0);
                if (argumentList.get(i) instanceof DynamicArgument) {
                    if (argumentList.get(i) instanceof ChemicalTermsArgument) {
                        this.setValueAt((Object)EvaluationType.CHEMICAL_TERMS, i, 2);
                    } else if (argumentList.get(i) instanceof SketchBasedDocumentArgument) {
                        this.setValueAt((Object)EvaluationType.ACTIVE_DOCUMENT, i, 2);
                    } else if (argumentList.get(i) instanceof MoleculeExporterArgument) {
                        this.setValueAt((Object)EvaluationType.MOLECULE_FORMAT, i, 2);
                    } else if (argumentList.get(i) instanceof SketchBasedMoleculeArgument) {
                        this.setValueAt((Object)EvaluationType.ACTIVE_MOLECULE, i, 2);
                    } else if (argumentList.get(i) instanceof SketchBasedSelectionArgument) {
                        this.setValueAt((Object)EvaluationType.ACTIVE_SELECTION, i, 2);
                    }
                } else {
                    this.setValueAt((Object)EvaluationType.MANUAL, i, 2);
                }
                if ("Unnamed".equals(argumentList.get(i).getName())) {
                    argumentList.get(i).setName("arg" + i);
                }
                this.setValueAt(argumentList.get(i).getName(), i, 1);
                this.setValueAt(argumentList.get(i), i, 3);
            }
            if (this.allowNewRow && (this.getRowCount() == 0 || this.getValueAt(this.getRowCount() - 1, 0) != null)) {
                ((DefaultTableModel)this.getModel()).addRow(new Object[]{null, null, null, null});
            }
        }

        @Override
        public List<ServiceArgument<?>> getServiceArguments() {
            ArrayList arguments = new ArrayList();
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.getValueAt(i, 3) instanceof ServiceArgument)) continue;
                arguments.add((ServiceArgument)this.getValueAt(i, 3));
            }
            return arguments;
        }

        @Override
        public boolean hasValidArguments() {
            boolean valid = true;
            int lastRow = this.allowNewRow ? this.getRowCount() - 1 : this.getRowCount();
            HashSet<String> nameSet = new HashSet<String>();
            for (int i = 0; i < lastRow && valid; ++i) {
                if (this.getValueAt(i, 3) instanceof ServiceArgument) {
                    ServiceArgument argument = (ServiceArgument)this.getValueAt(i, 3);
                    boolean bl = valid = argument.isValid() && argument.getName() != null && argument.getName().trim().length() > 0;
                    if (!valid) continue;
                    nameSet.add(argument.getName().trim());
                    continue;
                }
                valid = false;
            }
            if (valid) {
                valid = nameSet.size() == lastRow;
            }
            return valid;
        }

        @Override
        public Component getEditor() {
            return this;
        }
    }

    private static enum EvaluationType {
        ACTIVE_DOCUMENT,
        ACTIVE_MOLECULE,
        ACTIVE_SELECTION,
        CHEMICAL_TERMS,
        MOLECULE_FORMAT,
        MANUAL;


        public String toString() {
            String base = super.toString();
            base = base.replaceAll("_", "\\ ");
            base = base.substring(0, 1).toUpperCase() + base.substring(1).toLowerCase();
            return base;
        }
    }
}

