/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.ui;

import chemaxon.marvin.services.ChemicalTermsArgument;
import chemaxon.marvin.services.DynamicArgument;
import chemaxon.marvin.services.MoleculeExporterArgument;
import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.util.codeassist.CodeAssistFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ServiceArgumentTableCellSupport
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    public static final String PROPERTY_KEY_SERVICE_ARGUMENT_CHANGED = "serviceArgument";
    private static final long serialVersionUID = -6066092925091533485L;
    private final JCheckBox booleanEditor = new JCheckBox();
    private final JTextField defaultEditor = new JTextField();
    private final JLabel nullRendererComponent = new JLabel();
    private final JLabel basicRendererComponent = new JLabel();
    private final JComboBox toFormatCombo;
    private final JTextPane ctEditor;
    private ServiceArgument<?> argument = null;
    private JTable table = null;
    private Component editor = null;

    public ServiceArgumentTableCellSupport() {
        CodeAssistFactory.CodeAssistConfiguration config = new CodeAssistFactory.CodeAssistConfiguration();
        config.setAddServices(false);
        config.setHelpText(null);
        this.ctEditor = CodeAssistFactory.createChemicalTermsTextPane(config);
        this.nullRendererComponent.setOpaque(true);
        this.basicRendererComponent.setOpaque(true);
        this.booleanEditor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ServiceArgumentTableCellSupport.this.updateValue();
            }
        });
        DocumentListener documentListener = new DocumentListener(){

            private void handleChanges(DocumentEvent e) {
                ServiceArgumentTableCellSupport.this.updateValue();
                if (ServiceArgumentTableCellSupport.this.table.getCellEditor() == ServiceArgumentTableCellSupport.this && ServiceArgumentTableCellSupport.this.editor != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int prefHeight = ServiceArgumentTableCellSupport.this.table.getRowHeight();
                            if (ServiceArgumentTableCellSupport.this.editor.getPreferredSize() != null) {
                                prefHeight = (int)ServiceArgumentTableCellSupport.this.editor.getPreferredSize().getHeight();
                            }
                            if (ServiceArgumentTableCellSupport.this.table.getRowHeight(ServiceArgumentTableCellSupport.this.table.getEditingRow()) != prefHeight) {
                                ServiceArgumentTableCellSupport.this.table.setRowHeight(ServiceArgumentTableCellSupport.this.table.getEditingRow(), prefHeight);
                            }
                        }
                    });
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleChanges(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleChanges(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleChanges(e);
            }
        };
        this.ctEditor.getDocument().addDocumentListener(documentListener);
        this.defaultEditor.getDocument().addDocumentListener(documentListener);
        this.toFormatCombo = new JComboBox<String>(new String[]{"smiles", "mrv", "sdf", "rdf"});
        this.toFormatCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceArgumentTableCellSupport.this.updateValue();
            }
        });
        this.toFormatCombo.setEditable(true);
    }

    static void decorateComponent(JTable table, Component component, boolean isSelected, boolean hasFocus) {
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            ((JComponent)component).setBorder(border);
        } else {
            ((JComponent)component).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        component.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        component.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
    }

    private void updateValue() {
        if (this.argument instanceof DynamicArgument) {
            String sValue = this.argument instanceof ChemicalTermsArgument ? this.ctEditor.getText() : (this.argument instanceof MoleculeExporterArgument ? String.valueOf(this.toFormatCombo.getSelectedItem()) : this.defaultEditor.getText());
            ((DynamicArgument)this.argument).setExpression(sValue);
        } else if (this.argument != null) {
            try {
                if (Boolean.class.equals(this.argument.getType())) {
                    this.argument.setValue(this.booleanEditor.isSelected());
                } else if (Integer.class.equals(this.argument.getType())) {
                    this.argument.setValue(Integer.valueOf(this.defaultEditor.getText()));
                } else if (Float.class.equals(this.argument.getType())) {
                    this.argument.setValue(Float.valueOf(this.defaultEditor.getText()));
                } else if (Double.class.equals(this.argument.getType())) {
                    this.argument.setValue(Double.valueOf(this.defaultEditor.getText()));
                } else if (Long.class.equals(this.argument.getType())) {
                    this.argument.setValue(Long.valueOf(this.defaultEditor.getText()));
                } else if (String.class.equals(this.argument.getType())) {
                    this.argument.setValue(this.defaultEditor.getText());
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        if (this.table != null && this.table.getCellEditor() == this) {
            this.table.firePropertyChange(PROPERTY_KEY_SERVICE_ARGUMENT_CHANGED, false, true);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.argument;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = this.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (component instanceof JComponent) {
            if (value instanceof DynamicArgument && ((DynamicArgument)value).getExpression() == null) {
                component = this.nullRendererComponent;
            } else if (!(value instanceof DynamicArgument) && value instanceof ServiceArgument && ((ServiceArgument)value).getValue() == null) {
                component = this.nullRendererComponent;
            } else if (value == null) {
                component = this.nullRendererComponent;
            }
            if (component instanceof JComboBox) {
                this.basicRendererComponent.setText(String.valueOf(((JComboBox)component).getSelectedItem()));
                component = this.basicRendererComponent;
            }
        }
        if (component != null) {
            ServiceArgumentTableCellSupport.decorateComponent(table, component, isSelected, hasFocus);
        }
        return component;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.editor = null;
        if (value instanceof ServiceArgument) {
            this.argument = (ServiceArgument)value;
            Class<?> argumentClass = this.argument.getType();
            if (argumentClass != null) {
                if (Boolean.class.equals(argumentClass)) {
                    Boolean bValue = (Boolean)this.argument.getValue();
                    this.booleanEditor.setSelected(bValue == null ? false : bValue);
                    this.editor = this.booleanEditor;
                } else {
                    String sValue;
                    String string = this.argument instanceof DynamicArgument ? ((DynamicArgument)this.argument).getExpression() : (sValue = this.argument.getValue() == null ? "" : this.argument.getValue().toString());
                    if (this.argument instanceof ChemicalTermsArgument) {
                        this.ctEditor.setText(sValue);
                        this.editor = this.ctEditor;
                    } else if (this.argument instanceof MoleculeExporterArgument) {
                        this.toFormatCombo.setSelectedItem(sValue);
                        this.editor = this.toFormatCombo;
                    } else {
                        this.defaultEditor.setText(sValue);
                        this.editor = this.defaultEditor;
                    }
                }
            }
        }
        if (this.editor != null) {
            ServiceArgumentTableCellSupport.decorateComponent(table, this.editor, isSelected, true);
        }
        return this.editor;
    }

    @Override
    protected void fireEditingCanceled() {
        this.fireEditingStopped();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

