/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.xmlrpcservice;

import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceDescriptorEditor;
import chemaxon.marvin.services.ui.ArgumentEditorFactory;
import chemaxon.marvin.services.ui.ServiceArgumentEditor;
import chemaxon.marvin.services.xmlrpcservice.XMLRPCServiceDescriptor;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class XMLRPCServiceDescriptorEditor
implements ServiceDescriptorEditor<XMLRPCServiceDescriptor> {
    private static final Set<Class<?>> supportedClasses = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Double.class, Integer.class, String.class)));
    private JPanel mainPanel = null;
    private JTextField urlText = null;
    private JTextField methodNameText = null;
    private ServiceArgumentEditor argumentEditor = null;
    private boolean valid = false;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            CellConstraints cc = new CellConstraints();
            FormLayout layout = new FormLayout("pref, 2dlu, fill:min:grow, 4dlu, fill:min:grow, 2dlu, pref", "2dlu, min, 2dlu, min, 2dlu, min, 2dlu, fill:min:grow, 2dlu");
            layout.setColumnGroups((int[][])new int[][]{{3, 5}});
            this.mainPanel = new JPanel((LayoutManager)layout);
            this.mainPanel.add((Component)new JLabel("Service URL: "), cc.xy(1, 2));
            this.mainPanel.add((Component)this.getURLText(), cc.xyw(3, 2, 5));
            this.mainPanel.add((Component)new JLabel("Service Method: "), cc.xy(1, 4));
            this.mainPanel.add((Component)this.getMethodNameText(), cc.xyw(3, 4, 5));
            this.mainPanel.add((Component)new JScrollPane(this.getArgumentEditor().getEditor()), cc.xyw(1, 8, 7));
        }
        return this.mainPanel;
    }

    private JTextField getURLText() {
        if (this.urlText == null) {
            this.urlText = new JTextField();
            this.urlText.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    XMLRPCServiceDescriptorEditor.this.validate();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
        }
        return this.urlText;
    }

    private JTextField getMethodNameText() {
        if (this.methodNameText == null) {
            this.methodNameText = new JTextField();
            this.methodNameText.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    if (XMLRPCServiceDescriptorEditor.this.methodNameText.hasFocus()) {
                        XMLRPCServiceDescriptorEditor.this.propertyChangeSupport.firePropertyChange("PreferredName", null, XMLRPCServiceDescriptorEditor.this.methodNameText.getText() + " (XML-RPC)");
                    }
                    XMLRPCServiceDescriptorEditor.this.validate();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
        }
        return this.methodNameText;
    }

    private ServiceArgumentEditor getArgumentEditor() {
        if (this.argumentEditor == null) {
            this.argumentEditor = ArgumentEditorFactory.createServiceArgumentEditor(true, supportedClasses);
            Component editor = this.argumentEditor.getEditor();
            if (editor instanceof JTable) {
                ((JTable)editor).getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        XMLRPCServiceDescriptorEditor.this.validate();
                    }
                });
            }
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    XMLRPCServiceDescriptorEditor.this.validate();
                }
            };
            this.argumentEditor.getEditor().addPropertyChangeListener("serviceArgument", listener);
        }
        return this.argumentEditor;
    }

    @Override
    public JComponent getEditor() {
        return this.getMainPanel();
    }

    private void validate() {
        boolean oldValue = this.valid;
        try {
            URL url = new URL(this.getURLText().getText());
            this.valid = url.getHost().length() > 0;
        }
        catch (MalformedURLException e) {
            this.valid = false;
        }
        if (this.getMethodNameText().getText().trim().length() < 1) {
            this.valid = false;
        }
        this.valid = this.valid && this.getArgumentEditor().hasValidArguments();
        this.getEditor().firePropertyChange("EditorValid", oldValue, this.valid);
    }

    @Override
    public void setDescriptor(XMLRPCServiceDescriptor descriptor) {
        this.getURLText().setText(descriptor == null ? "" : descriptor.getURL());
        this.getMethodNameText().setText(descriptor == null ? "" : descriptor.getMethodName());
        this.getArgumentEditor().setServiceArguments(descriptor == null ? Collections.EMPTY_LIST : descriptor.getArguments());
    }

    @Override
    public XMLRPCServiceDescriptor getDescriptor() {
        Component editor = this.getArgumentEditor().getEditor();
        if (editor instanceof JTable && ((JTable)editor).getCellEditor() != null && !((JTable)editor).getCellEditor().stopCellEditing()) {
            ((JTable)editor).getCellEditor().cancelCellEditing();
        }
        this.validate();
        if (this.isValid()) {
            XMLRPCServiceDescriptor descriptor = new XMLRPCServiceDescriptor();
            descriptor.setURL(this.getURLText().getText().trim());
            descriptor.setMethodName(this.getMethodNameText().getText().trim());
            for (ServiceArgument<?> argument : this.getArgumentEditor().getServiceArguments()) {
                descriptor.addArgument(argument);
            }
            return descriptor;
        }
        return null;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }
}

