/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.MObjectPO;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.MolJoin;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SelectUtil;
import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.graphics.MMidPoint;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRArrow;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.util.NetUtil;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSelectSM
extends SketchMode {
    private static final long serialVersionUID = -3234421161340066358L;
    protected SelectUtil selectUtil;
    protected boolean selectingText;
    protected transient MPolyline polyline = null;
    protected MObject draggedObject = null;

    public AbstractSelectSM(MolEditor e) {
        super(e);
        this.selectUtil = new SelectUtil(e);
    }

    public AbstractSelectSM(AbstractSelectSM so) {
        super(so);
        this.selectUtil = (SelectUtil)so.selectUtil.clone();
    }

    protected abstract void beginSelection();

    protected abstract boolean isSelecting();

    @Override
    public boolean isSelector() {
        return true;
    }

    @Override
    public boolean pointerDrag(int modifiers) {
        DPoint3 ptr;
        int i;
        Serializable t;
        MolEditor med = this.getEditor();
        if (this.selectingText && (t = med.getFocusedMTextBox()) != null && (i = t.determinePosition(ptr = med.getPointerPos(), true)) >= 0) {
            t.setCursorPos(i, true);
            return true;
        }
        if (med.isDataSgroupLabelMoving() && med.moveDataSgroupLabel()) {
            return true;
        }
        if (this.polyline != null) {
            PointedObject po;
            if (this.draggedObject == null && (po = med.getPointedObject()) != null && po instanceof MObjectPO) {
                this.draggedObject = ((MObjectPO)po).getMObject();
            }
            if (this.draggedObject != null && !(this.draggedObject instanceof MMidPoint)) {
                t = med.getPainter().getRTransformRef();
                MPoint[] aps = this.polyline.getPoints();
                DPoint3 o = null;
                int i2 = -1;
                if (this.draggedObject.equals(aps[1])) {
                    o = aps[0].getLocation((CTransform3D)t);
                    i2 = 1;
                } else if (this.draggedObject.equals(aps[0])) {
                    o = aps[1].getLocation((CTransform3D)t);
                    i2 = 0;
                }
                if (o != null && !this.isShiftDown(modifiers) && i2 != -1) {
                    DPoint3 pa = med.getPointerPos();
                    double dx = o.x - pa.x;
                    double dy = o.y - pa.y;
                    double f = dx != 0.0 || dy != 0.0 ? Math.atan2(dy, dx) : 0.0;
                    double df = 0.2617993877991494;
                    double phi = (double)Math.round(f / df) * df;
                    double r = Math.hypot(dx, dy);
                    DPoint3 pm = new DPoint3(o.x - r * Math.cos(phi), o.y - r * Math.sin(phi), o.z);
                    aps[i2].setLocation(pm, (CTransform3D)t);
                    ((MPoint)this.draggedObject).setLocation(pm, (CTransform3D)t);
                } else {
                    DPoint3 dpos = med.getPointerPosDiff();
                    CTransform3D T = new CTransform3D();
                    T.setTranslation(dpos);
                    this.draggedObject.transform(T, 1, (CTransform3D)t);
                    if (i2 > -1) {
                        aps[i2].setLocation(((MPoint)this.draggedObject).getLocation(), (CTransform3D)t);
                    } else if (this.draggedObject instanceof MRArrow) {
                        DPoint3 p0 = this.draggedObject.getPoint(0).getLocation();
                        DPoint3 p1 = this.draggedObject.getPoint(1).getLocation();
                        aps[0].setLocation(p0, (CTransform3D)t);
                        aps[1].setLocation(p1, (CTransform3D)t);
                    }
                }
                this.polyline.setPoints(aps);
                return true;
            }
        }
        if (med.moveOrRotateCurfrag(modifiers, true)) {
            return true;
        }
        if (this.isSelecting()) {
            boolean dirty = false;
            if (!this.isShiftDown(modifiers) && !this.getEditor().getSelectionDocument().isEmpty()) {
                this.getEditor().edit(14);
                dirty = true;
            }
            return dirty | this.selectUtil.doS();
        }
        return false;
    }

    @Override
    public boolean canPointToAtom() {
        return true;
    }

    @Override
    public boolean canPointToBond() {
        return true;
    }

    @Override
    public boolean canPointToSgroup() {
        return true;
    }

    @Override
    public boolean canPointToMObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonDown(boolean dblClick, int modifiers) {
        DPoint3 ptr;
        int i;
        MTextBox t;
        MolEditor med = this.getEditor();
        MSelectionDocument seldoc = med.getSelectionDocument();
        if (!med.isMoveModePersistent() && (t = med.getFocusedMTextBox()) != null && (i = t.determinePosition(ptr = med.getPointerPos(), false)) >= 0) {
            t.setCursorPos(i, false);
            this.selectingText = true;
            return 1;
        }
        Molecule mol = med.getMol();
        SelectionMolecule selmol = med.getSelectionMolecule();
        Object object = mol.getLock();
        synchronized (object) {
            PointedObject po = med.getPointedObject();
            if (med.isMoveModePersistent() || (med.canRotCurfrag || med.canMovCurfrag) && (po == null || !(po instanceof MObjectPO) || !((MObjectPO)po).getMObject().isInternalSelectable())) {
                if (!med.isMoveModePersistent()) {
                    med.setMoveMode(med.canRotCurfrag ? 2 : (med.canMovCurfrag ? 1 : 0), false);
                }
                selmol.regenBonds();
                med.setCurfrag(MolEditor.createSelectionDoc(med.getDocument()));
                MDocument cf = med.getCurfrag();
                selmol.clonelesscopy(cf.getMainMoleculeGraph());
                for (int i2 = 0; i2 < seldoc.getObjectCount(); ++i2) {
                    MObject o = seldoc.getObject(i2);
                    if (o instanceof MChemicalStruct) continue;
                    cf.addObject(o);
                }
            } else if (po != null) {
                if (po instanceof AtomPO) {
                    this.buttonDownOnAtom(((AtomPO)po).getAtom(), modifiers);
                } else if (po instanceof BondPO) {
                    this.buttonDownOnBond(((BondPO)po).getBond(), modifiers);
                } else if (po instanceof SgroupPO) {
                    this.buttonDownOnSgroup(((SgroupPO)po).getSgroup(), modifiers, ((SgroupPO)po).isDataLabelPointed, dblClick && !this.getEditor().isInAtomSelectionMode());
                } else if (po instanceof MObjectPO) {
                    this.buttonDownOnObject(((MObjectPO)po).getMObject(), modifiers);
                }
            } else if (!med.isInAtomSelectionMode()) {
                this.beginSelection();
                med.setRotationAxisPoint(null);
            }
            if (dblClick) {
                this.handleDoubleClick();
            }
        }
        return 0;
    }

    protected void handleDoubleClick() {
        if (this.getEditor().isInAtomSelectionMode()) {
            return;
        }
        this.selectFragment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void selectFragment() {
        MolEditor med = this.getEditor();
        MSelectionDocument seldoc = med.getSelectionDocument();
        Molecule mol = med.getMol();
        Object object = mol.getLock();
        synchronized (object) {
            MolBond[] potbonds;
            Sgroup sgroup;
            SelectionMolecule selmol = med.getSelectionMolecule();
            DPoint3 ptr = med.getPointerPos();
            double sr = med.getStickdst() * 1.54;
            MolAtom[] potatoms = mol.getAtomArray();
            CTransform3D trot = med.getPainter().getRTransform();
            DPoint3 p = (DPoint3)ptr.clone();
            trot.transform(p);
            MolAtom a = MolJoin.findNearAtom(potatoms, p.x, p.y, sr, true, trot);
            MObject pobj = null;
            boolean selectedPointingAtABond = false;
            MolBond pointedBond = null;
            if (a == null && med.getPointedObject() instanceof SgroupPO && (sgroup = (Sgroup)med.getPointedObject().getContainedObject()).getAtomCount() > 0) {
                a = sgroup.getAtom(0);
            }
            if (a == null && (pointedBond = MolJoin.findNearBond(potbonds = mol.getBondArray(), p.x, p.y, sr, trot)) != null) {
                a = pointedBond.getAtom1();
                boolean bl = selectedPointingAtABond = a != null;
            }
            if (a == null) {
                double[] dist = new double[1];
                pobj = med.findObjectAt(ptr.x, ptr.y, dist);
            }
            if (a != null || pobj != null) {
                med.canMovCurfrag = false;
                med.canRotCurfrag = false;
                med.setMoveMode(0, false);
                med.clearCurfrag();
                seldoc.selectAllObjects(false);
                this.selectUtil.selPoly = null;
                this.selectUtil.selRect = null;
                if (a != null) {
                    boolean isPointedAtomSelected;
                    SelectionMolecule frag = MolEditor.createSelectionMol(mol);
                    MoleculeGraph pmol = a.getParent();
                    pmol.findFrag(pmol.indexOf(a), frag);
                    boolean hasSelected = false;
                    if (selectedPointingAtABond && pointedBond != null) {
                        int selAtom1 = selmol.indexOf(pointedBond.getAtom1());
                        int selAtom2 = selmol.indexOf(pointedBond.getAtom2());
                        for (int i = 0; i < frag.getAtomCount() && !hasSelected; ++i) {
                            int idx = selmol.indexOf(frag.getAtom(i));
                            hasSelected = idx >= 0 && idx != selAtom1 && idx != selAtom2;
                        }
                    } else {
                        for (int i = 0; i < frag.getAtomCount() && !hasSelected; ++i) {
                            hasSelected = selmol.indexOf(frag.getAtom(i)) >= 0;
                        }
                    }
                    boolean bl = isPointedAtomSelected = selmol.indexOf(a) >= 0;
                    if (hasSelected && isPointedAtomSelected) {
                        for (int i = 0; i < frag.getAtomCount(); ++i) {
                            med.unselectAtom(frag.getAtom(i));
                        }
                    } else {
                        selmol.fuse(frag);
                    }
                    Sgroup sg = med.findContainingSgroup(frag.getAtomArray());
                    if (sg != null && sg.getBracketCount() != 0) {
                        ArrayList<MBracket> brackets = sg.getBrackets();
                        for (int k = 0; k < brackets.size(); ++k) {
                            seldoc.addObject(brackets.get(k));
                            brackets.get(k).setSelected(true);
                        }
                    }
                } else if (pobj != null && !seldoc.contains(pobj)) {
                    seldoc.addObject(pobj);
                }
                med.select();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonUp(int modifiers, boolean doHist) {
        DPoint3 ptr;
        int i;
        MolEditor med = this.getEditor();
        MDocument doc = med.getDocument();
        med.updateMolecule();
        boolean histEnabled = med.setHistorizeEnabled(false);
        doc.setDraggedObject(null);
        MTextBox t = med.getFocusedMTextBox();
        if (!med.isMoveModePersistent() && t != null && this.selectingText && (i = t.determinePosition(ptr = med.getPointerPos(), false)) >= 0) {
            t.setCursorPos(i, true);
            this.selectingText = false;
            return 1;
        }
        int ret = 0;
        Object molLock = med.getMol().getLock();
        MoleculeGraph selmol = med.getSelectionDocument().getMainMoleculeGraph();
        if (med.isDataSgroupLabelMoving()) {
            med.setDataSgroupLabelMoving(false);
            med.setDataSgroupObject(null);
            ret = 0;
        } else if (!med.isMoveModePersistent() && med.getCurfrag().isEmpty() && this.isSelecting()) {
            ret = this.endSelection(modifiers);
        } else if (!med.isInAtomSelectionMode()) {
            if (med.curfragMoved) {
                Object object = molLock;
                synchronized (object) {
                    MDocument scf = med.join(med.getCurfragJoin(), med.getCurfrag(), 9);
                    if (scf != null) {
                        med.setCurfrag(scf);
                    }
                    med.restoreNonReactionIfPossible();
                    med.rebuildReaction();
                    MDocument cf = med.getCurfrag();
                    MoleculeGraph mcf = cf.getMainMoleculeGraph();
                    if (selmol.contains(mcf)) {
                        med.setPointedObject(null);
                        med.setPntbond(null);
                        int moveMode = med.getMoveMode();
                        if (moveMode == 3) {
                            if (!med.can3DRotateStructure()) {
                                med.setMoveMode(1, false);
                            } else {
                                med.setRotationAxisPoint();
                                med.setActualRotate3dPhiX_Y(false);
                            }
                        }
                    } else {
                        if (mcf.isAtom()) {
                            MolAtom a = mcf.getAtom(0);
                            med.setPointedObject(new AtomPO(a));
                        } else {
                            med.setPointedObject(null);
                        }
                        med.setPntbond(mcf.isBond() ? mcf.getBond(0) : null);
                    }
                    med.dragged = false;
                }
                ret = 2;
            } else if (med.isMoveModePersistent()) {
                if (!med.dragged) {
                    med.setMoveMode(0, false);
                    this.handleButtonRelease(modifiers);
                }
            } else if (this.draggedObject != null) {
                ret = 2;
                this.draggedObject = null;
            } else {
                this.handleButtonRelease(modifiers);
            }
            if (!med.isMoveModePersistent()) {
                med.clearCurfrag();
            }
        }
        if (med.isInAtomSelectionMode() && med.canEndAtomSelectionMode()) {
            med.endAtomSelectionMode();
            ret = 2;
        }
        if (!med.isMoveModePersistent()) {
            med.canMovCurfrag = false;
            med.canRotCurfrag = false;
            med.setMoveMode(0, false);
        }
        med.dragged = false;
        this.polyline = null;
        med.invokeSelectionChangedEvent();
        med.setHistorizeEnabled(histEnabled);
        if (doHist && ret == 2) {
            med.historize();
        } else if (doHist && ret != 1) {
            med.setLastSelectionToPrepareHistorizing();
        } else if (doHist && med.getHistorizeUnSelection()) {
            med.historize();
            med.setHistorizeUnSelection(false);
        }
        if (ret == 1) {
            med.clearIndexesToRot();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleButtonRelease(int modifiers) {
        MolEditor med = this.getEditor();
        Object molLock = med.getMol().getLock();
        MSelectionDocument seldoc = med.getSelectionDocument();
        MoleculeGraph selmol = seldoc.getMainMoleculeGraph();
        Object object = molLock;
        synchronized (object) {
            MDocument cf = med.getCurfrag();
            for (int i = 0; i < cf.getObjectCount(); ++i) {
                MObject o = cf.getObject(i);
                if (o instanceof MChemicalStruct) {
                    int j;
                    MChemicalStruct mm = (MChemicalStruct)o;
                    MoleculeGraph m = mm.getMoleculeGraph();
                    int na = m.getAtomCount();
                    if (selmol.contains(m) && !this.isShiftDown(modifiers)) {
                        for (j = 0; j < na; ++j) {
                            MolAtom a = m.getAtom(j);
                            selmol.removeAtom(a);
                        }
                        continue;
                    }
                    if (na == 0) continue;
                    for (j = 0; j < na; ++j) {
                        MolEditor.selectAtom(m.getAtom(j), selmol);
                    }
                    this.unselectSubSelection();
                    continue;
                }
                if (!seldoc.contains(o)) {
                    ((MDocument)seldoc).addObject(o);
                    continue;
                }
                ((MDocument)seldoc).removeObject(o);
                o.setSelected(false);
            }
            med.select();
        }
    }

    protected int endSelection(int modifiers) {
        this.selectUtil.endS();
        MolEditor med = this.getEditor();
        if (!(med.isDragged() || this.isShiftDown(modifiers) || med.isInAtomSelectionMode())) {
            med.edit(14);
            return 1;
        }
        return 0;
    }

    private boolean isShiftDown(int modifiers) {
        return (modifiers & 1) != 0;
    }

    @Override
    public boolean containedObjectEquals(SketchMode o) {
        return o != null && o.getClass() == this.getClass();
    }

    @Override
    public boolean pointerCopyDrag(int mod) {
        return true;
    }

    @Override
    public boolean pointerMove(int modifiers) {
        return false;
    }

    @Override
    public void reset() {
        this.selectUtil.reset();
    }

    @Override
    public void paintTemps1(Graphics2D g) {
        this.selectUtil.paintTemps1(g);
    }

    @Override
    public void prepareMolPaint() {
        this.selectUtil.prepareMolPaint();
    }

    @Override
    public SelectUtil getSelectUtil() {
        return this.selectUtil;
    }

    @Override
    public int modkeyChange(int mod) {
        MolEditor med = this.getEditor();
        int oldmod = med.getModifiers();
        if ((mod & 1) == 0 && (oldmod & 1) != 0 && (mod & 0x10) != 0) {
            med.rotateCurrentMoleculeTo15DegreesLine();
            return 1;
        }
        if ((mod & 1) != 0 && (oldmod & 1) == 0 && med.getMoveMode() == 3) {
            med.setActualRotate3dPhiX_Y(true);
            return 1;
        }
        if ((mod & 1) == 0 && (oldmod & 1) != 0 && med.getMoveMode() == 3) {
            med.setActualRotate3dPhiX_Y(false);
            return 1;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeObject(this.selectUtil);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        this.selectUtil = (SelectUtil)ois.readObject();
    }

    protected void buttonDownOnAtom(MolAtom a, int modifiers) {
        MolEditor med = this.getEditor();
        boolean wasSelected = a.isSelected();
        if (med.isInAtomSelectionMode()) {
            med.addToAtomSelection(a);
        } else if (modifiers == 17) {
            if (wasSelected) {
                med.unselectAtom(a);
            } else {
                MolEditor.selectAtom(a, med.getSelectionMolecule());
                this.unselectSubSelection();
            }
            med.clearCurfrag();
        } else if (modifiers == 16) {
            med.unselect();
            med.setCurfrag(MolEditor.createSelectionDoc(med.getDocument()));
            MoleculeGraph mcf = med.getCurfrag().getMainMoleculeGraph();
            MolEditor.selectAtom(a, mcf);
            this.unselectSubSelection();
        }
    }

    protected void buttonDownOnBond(MolBond b, int modifiers) {
        boolean wasSelected;
        MolEditor med = this.getEditor();
        MolAtom a1 = b.getAtom1();
        MolAtom a2 = b.getAtom2();
        boolean bl = wasSelected = a1.isSelected() && a2.isSelected();
        if (med.isInAtomSelectionMode()) {
            med.addToAtomSelection(a1, a2);
        } else if (modifiers == 17) {
            if (wasSelected) {
                med.unselectAtom(a1);
                med.unselectAtom(a2);
            } else {
                MolEditor.selectAtom(a1, med.getSelectionMolecule());
                MolEditor.selectAtom(a2, med.getSelectionMolecule());
                this.unselectSubSelection();
            }
            med.clearCurfrag();
        } else if (modifiers == 16) {
            med.unselect();
            med.setCurfrag(MolEditor.createSelectionDoc(med.getDocument()));
            MoleculeGraph mcf = med.getCurfrag().getMainMoleculeGraph();
            MolEditor.selectAtom(a1, mcf);
            MolEditor.selectAtom(a2, mcf);
            this.unselectSubSelection();
        }
    }

    protected void buttonDownOnSgroup(Sgroup sg, int modifiers, boolean isDataLabelPointed, boolean dblClick) {
        int i;
        MolEditor med = this.getEditor();
        boolean wasSelected = true;
        for (i = 0; i < sg.getAtomCount(); ++i) {
            wasSelected &= sg.getAtom(i).isSelected();
        }
        if (modifiers == 17) {
            if (wasSelected) {
                for (i = 0; i < sg.getAtomCount(); ++i) {
                    MolAtom a = sg.getAtom(i);
                    med.unselectAtom(a);
                }
            } else {
                for (i = 0; i < sg.getAtomCount(); ++i) {
                    MolAtom a = sg.getAtom(i);
                    MolEditor.selectAtom(a, med.getSelectionMolecule());
                    this.unselectSubSelection();
                }
            }
            med.clearCurfrag();
        } else if (isDataLabelPointed && (modifiers == 18 || dblClick)) {
            DataSgroup dsg = (DataSgroup)sg;
            if (dsg.getFieldType() == 4) {
                NetUtil.openURL(dsg.getData());
            }
        } else if (modifiers == 16) {
            DataSgroup dsg;
            if (isDataLabelPointed && (dsg = (DataSgroup)sg).isDataDetached()) {
                med.unselect();
                med.setDataSgroupLabelMoving(true);
                med.setDataSgroupObject(dsg);
                return;
            }
            med.unselect();
            med.setCurfrag(MolEditor.createSelectionDoc(med.getDocument()));
            MoleculeGraph mcf = med.getCurfrag().getMainMoleculeGraph();
            for (int i2 = 0; i2 < sg.getAtomCount(); ++i2) {
                MolAtom a = sg.getAtom(i2);
                MolEditor.selectAtom(a, mcf);
                this.unselectSubSelection();
            }
            mcf.regenBonds();
        }
    }

    protected void buttonDownOnObject(MObject o, int modifiers) {
        block13: {
            MolEditor med;
            block12: {
                int i;
                med = this.getEditor();
                boolean wasSelected = o.isSelected();
                MSelectionDocument seldoc = med.getSelectionDocument();
                if (modifiers != 17) break block12;
                if (wasSelected) {
                    ((MDocument)seldoc).removeObject(o);
                    o.setSelected(false);
                } else {
                    boolean contains = false;
                    for (int i2 = seldoc.getObjectCount() - 1; i2 >= 0; --i2) {
                        MObject oo = seldoc.getObject(i2);
                        if (oo.isChildOf(o)) {
                            ((MDocument)seldoc).removeObject(i2);
                            continue;
                        }
                        if (o != oo && !o.isChildOf(oo)) continue;
                        contains = true;
                    }
                    if (!contains) {
                        ((MDocument)seldoc).addObject(o);
                        this.unselectSubSelection();
                    }
                }
                med.updateFocus();
                med.clearCurfrag();
                if (!(o instanceof MPoint) || med.isReactionArrowMidPoint(o)) break block13;
                MDocument doc = med.getDocument();
                List<MObject> objs = doc.getAllObjects();
                ArrayList<MObject> hobjs = new ArrayList<MObject>();
                int n = objs.size();
                for (i = 0; i < n; ++i) {
                    if (!doc.isHighlighted(objs.get(i))) continue;
                    hobjs.add(objs.get(i));
                }
                n = hobjs.size();
                for (i = 0; i < n; ++i) {
                    if (!(hobjs.get(i) instanceof MRArrow)) continue;
                    this.polyline = (MRArrow)hobjs.get(i);
                    med.setCurfrag(MolEditor.createSelectionDoc(med.getDocument()));
                    med.getCurfrag().addObject(o);
                    doc.setDraggedObject(o);
                }
                break block13;
            }
            if (modifiers == 16) {
                PointedObject po = med.getPointedObject();
                MObject mo = med.getTheSelectedMObject();
                if (po == null || mo == null || !(po instanceof MObjectPO) || !((MObjectPO)po).getMObject().isChildOf(mo)) {
                    med.unselect();
                }
                if (!med.isReactionArrowMidPoint(o)) {
                    int i;
                    med.setCurfrag(MolEditor.createSelectionDoc(med.getDocument()));
                    med.getCurfrag().addObject(o);
                    MDocument doc = med.getDocument();
                    doc.setDraggedObject(o);
                    List<MObject> objs = doc.getAllObjects();
                    ArrayList<MObject> hobjs = new ArrayList<MObject>();
                    int n = objs.size();
                    for (i = 0; i < n; ++i) {
                        if (!doc.isHighlighted(objs.get(i))) continue;
                        hobjs.add(objs.get(i));
                    }
                    n = hobjs.size();
                    for (i = 0; i < n; ++i) {
                        if (!(hobjs.get(i) instanceof MRArrow)) continue;
                        this.polyline = (MRArrow)hobjs.get(i);
                    }
                }
            }
        }
    }

    private void unselectSubSelection() {
        this.getEditor().getDocument().setObjectContainingSelection(null);
        this.getEditor().getSelectionDocument().setObjectContainingSelection(null);
    }
}

