/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.MolJoin;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.graphics.MAtomSetPoint;
import java.awt.Graphics2D;

public class AtomPairPO
implements PointedObject {
    private transient MolAtom[] atoms = new MolAtom[2];
    private double[] weights;

    public AtomPairPO(MolAtom[] a, double[] w) {
        this.atoms[0] = a[0];
        this.atoms[1] = a[1];
        this.weights = w;
    }

    @Override
    public MolJoin highlightMe(Graphics2D g, SketchMode sm, MolJoin j, MoleculeGraph piece, MolEditor med) {
        String name;
        MolPainter p = med.getPainter();
        if (sm.canPointToAtomPair()) {
            double sr = med.getStickdst() * 1.54;
            p.hilitAtomPair(this.atoms[0], this.atoms[1], sr, g);
        }
        if (sm != null && ((name = sm.getClass().getName()).equals("chemaxon.marvin.sketch.modules.EFlowSM") || name.equals("chemaxon.marvin.sketch.modules.EFlow1SM"))) {
            p.paintIncipientBond(g, this.atoms, med.getDocument());
        }
        return j;
    }

    @Override
    public Object getContainedObject() {
        return this.atoms;
    }

    @Override
    public MPoint getContainedObjectMPointerPos() {
        MAtomSetPoint p = new MAtomSetPoint(this.atoms);
        p.setWeights(this.weights);
        return p;
    }
}

