/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.MolJoin;
import chemaxon.marvin.sketch.MoleculeSM;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import chemaxon.util.NetUtil;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class AtomSM
extends SketchMode {
    private static final long serialVersionUID = -5009627643303957609L;
    private transient MolAtom atom;
    private transient BondSM bondSM = null;
    private transient boolean inBondMode = false;

    public AtomSM(MolEditor e, MolAtom a) {
        super(e);
        this.atom = a;
    }

    @Override
    public boolean containedObjectEquals(SketchMode o) {
        return o != null && o instanceof AtomSM && ((AtomSM)o).getAtom() == this.atom;
    }

    @Override
    public Object clone() {
        AtomSM so = new AtomSM(this.getEditor(), (MolAtom)this.atom.clone());
        return so;
    }

    public MolAtom getAtom() {
        return this.atom;
    }

    @Override
    public Molecule getMol() {
        MolAtom a = (MolAtom)this.atom.clone();
        DPoint3 o = a.getLocation();
        a.setXYZ(0.0, 0.0, 0.0);
        Molecule m = new Molecule(null, a);
        m.moveTo(o);
        return m;
    }

    @Override
    public boolean canPointToAtom() {
        return true;
    }

    @Override
    public boolean canPointToBond() {
        return true;
    }

    @Override
    public boolean isCurrentJoinHighlighted() {
        MolEditor med = this.getEditor();
        PointedObject po = med.getPointedObject();
        return po == null || !(po instanceof BondPO);
    }

    @Override
    public boolean canPointToSgroup() {
        return true;
    }

    @Override
    public void moveTo(DPoint3 o) {
        this.atom.setLocation(o);
    }

    @Override
    public void hilitJoins(MolJoin j, MolPainter p, double sr, Graphics2D g) {
        if (!this.willBranchAtButtonPress()) {
            super.hilitJoins(j, p, sr, g);
        }
    }

    @Override
    public boolean willBranchAtButtonPress() {
        MolEditor medit = this.getEditor();
        Molecule piece = medit.getPiece();
        if (piece.isAtom()) {
            MolAtom a = piece.getAtom(0);
            PointedObject po = medit.getPointedObject();
            if (po == null || po instanceof AtomPO) {
                MolAtom pnta;
                MolAtom molAtom = pnta = po != null ? ((AtomPO)po).getAtom() : null;
                if (a != null && a.getAtno() != 0 && (pnta == null || medit.canHaveMoreBonds(pnta) || pnta instanceof SgroupAtom)) {
                    return medit.canHaveMoreBonds(a);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonDown(boolean dblClick, int modifiers) {
        MolAtom pnta;
        MolEditor medit = this.getEditor();
        medit.edit(14);
        medit.pntAB(false);
        Molecule piece = medit.getPiece();
        MolAtom a = piece.isAtom() ? piece.getAtom(0) : null;
        PointedObject po = medit.getPointedObject();
        if (po instanceof BondPO) {
            BondSM sm = this.bondSM;
            if (sm == null) {
                this.bondSM = sm = new BondSM(medit, medit.getLastBond(null, null));
            }
            this.inBondMode = true;
            return sm.buttonDown(dblClick, modifiers);
        }
        if (po instanceof SgroupPO && ((SgroupPO)po).isDataLabelPointed) {
            DataSgroup dsg = (DataSgroup)((SgroupPO)po).getSgroup();
            if (modifiers == 18 || dblClick) {
                if (dsg.getFieldType() == 4) {
                    NetUtil.openURL(dsg.getData());
                    return 1;
                }
            } else {
                return 0;
            }
        }
        MolAtom molAtom = pnta = po != null && po instanceof AtomPO ? ((AtomPO)po).getAtom() : null;
        if (a != null && a.getAtno() != 0) {
            Object object = medit.getMol().getLock();
            synchronized (object) {
                Molecule newMol;
                Molecule m;
                MolAtom a1;
                if (pnta != null && (MolJoin.canBeSproutTo(this.atom, pnta) || (modifiers & 1) != 0 && !(this.atom instanceof SgroupAtom) && !(pnta instanceof SgroupAtom))) {
                    if (!medit.isShowMoleculeSet()) {
                        MolAtom a12 = (MolAtom)pnta.clone();
                        a12.setAtno(0);
                        MolAtom a2 = (MolAtom)this.atom.clone();
                        Molecule m2 = BondSM.createBondMol(1, a12, a2);
                        double desired = medit.getMol().getBondCount() > 0 ? medit.getMol().getDesiredLength(medit.getMol().getBond(0)) : 0.0;
                        a2.setXYZ(a12.getX() + desired, a12.getY(), a12.getZ());
                        medit.showPossibleMolecule(m2, false);
                    } else {
                        medit.setPaintOnlyShowMolecule(false);
                    }
                    medit.atomBranchPiece = null;
                    return 1;
                }
                if (pnta != null && MolJoin.canBeSpiroTo(this.atom, pnta)) {
                    medit.atomBranchPiece = null;
                    medit.setPaintOnlyShowMolecule(false);
                    return 1;
                }
                if (!(!(this.atom instanceof SgroupAtom) || pnta != null && !MolJoin.canBeReplacedBy(this.atom, pnta) || pnta != null && MolJoin.canJoinByBond(this.atom, pnta))) {
                    medit.putPiece();
                    if (medit.atomBranchPiece != null) {
                        medit.atomBranchPiece.moveTo(medit.getPointerPos());
                        medit.setPiece0(medit.atomBranchPiece, null);
                        medit.atomBranchPiece = null;
                    }
                    medit.clearShowMolecule();
                    return 1;
                }
                if (pnta != null) {
                    a1 = new MolAtom(0);
                    a1.setXYZ(0.0, 0.0, 0.0);
                } else {
                    a1 = (MolAtom)piece.getAtom(0).clone();
                    medit.setPointedObject(new AtomPO(a1));
                }
                MolAtom a2 = (MolAtom)piece.getAtom(0).clone();
                if (this.willBranchAtButtonPress()) {
                    m = BondSM.createMolFromBond(medit.getLastBond(a1, a2), a1, a2);
                    medit.atomBranchPiece = this.getMol();
                    a2.setXYZ(0.0, 0.0, 0.0);
                    newMol = (Molecule)m.clone();
                    if (piece != null) {
                        MDocument mdoc = newMol.getDocument();
                        if (mdoc == null) {
                            mdoc = new MDocument(newMol);
                        }
                        mdoc.cloneSets(piece.getDocument());
                    }
                } else {
                    return 0;
                }
                medit.setPiece0(newMol, m);
                medit.beginBondDrawing((Molecule)m.clone());
            }
        } else {
            medit.putPiece();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonUp(int modifiers, boolean doHist) {
        MolAtom patom;
        MolEditor medit = this.getEditor();
        if (medit.isMoveModePersistent()) {
            return 0;
        }
        Object molLock = medit.getMol().getLock();
        int ret = 0;
        if (this.inBondMode) {
            this.inBondMode = false;
            if (this.bondSM != null) {
                return this.bondSM.buttonUp(modifiers, doHist);
            }
        }
        MDocument cf = medit.getCurfrag();
        PointedObject po = medit.getPointedObject();
        MolAtom molAtom = patom = po != null && po instanceof AtomPO ? ((AtomPO)po).getAtom() : null;
        if (patom != null && medit.atomBranchPiece == null && medit.isShowMoleculeSet() && (MolJoin.canBeSproutTo(this.atom, patom) || MolJoin.canBeSpiroTo(this.atom, patom) || !(this.atom instanceof SgroupAtom) && !(patom instanceof SgroupAtom))) {
            ret = medit.endShowMoleculeDrawing();
            medit.command(1, modifiers);
            if (doHist && ret == 2) {
                medit.historize();
            }
            return ret;
        }
        if (patom != null && (modifiers & 1) != 0 && !(this.atom instanceof SgroupAtom) && patom instanceof SgroupAtom) {
            if (medit.atomBranchPiece != null) {
                medit.atomBranchPiece.moveTo(medit.getPointerPos());
                medit.setPiece0(medit.atomBranchPiece, null);
                medit.atomBranchPiece = null;
            }
            medit.flyingBondMol = null;
            medit.setMoveMode(0, false);
            medit.dragged = false;
            return 0;
        }
        if (!cf.isEmpty() && medit.atomBranchPiece != null && cf.getMainMoleculeGraph().getBondCount() > 0) {
            Object object = molLock;
            synchronized (object) {
                DPoint3 pa1 = medit.getScreenFromMolPos(cf.getMainMoleculeGraph().getBond(0).getAtom1().getLocation());
                DPoint3 ptr = medit.getScreenPointerPos();
                double dx = ptr.x - pa1.x;
                double dy = ptr.y - pa1.y;
                double sr = medit.getStickdst() * 1.54;
                if (patom == null || medit.isDragged() && dx * dx + dy * dy > sr * sr) {
                    if (medit.endBondOrChainDrawing()) {
                        medit.dragged = false;
                        if ((modifiers & 1) != 0 && this.atom instanceof SgroupAtom) {
                            this.changeSketchModeInCaseOfSgroup(true, true);
                            medit.command(1, modifiers);
                        }
                        return 2;
                    }
                } else {
                    medit.atomBranchPiece.moveTo(ptr);
                    if (medit.getPiece().getDocument() != null) {
                        MDocument mdoc = medit.atomBranchPiece.getDocument();
                        if (mdoc == null) {
                            mdoc = new MDocument(medit.atomBranchPiece);
                        }
                        mdoc.cloneSets(medit.getPiece().getDocument());
                    }
                    medit.setPiece0(medit.atomBranchPiece, this.getMol());
                    medit.atomBranchPiece = null;
                    medit.flyingBondMol = null;
                    if (MolJoin.canBeReplacedBy(this.atom, patom)) {
                        medit.putPiece();
                        medit.historize();
                        medit.clearCurfrag();
                        if (this.atom.getAtno() == 210) {
                            medit.setFreePieceMap();
                        }
                    }
                    return 2;
                }
                if (patom != null && !medit.isDragged()) {
                    ret = medit.branch(patom);
                }
            }
        }
        boolean cfempty = cf.isEmpty();
        Object object = molLock;
        synchronized (object) {
            MolAtom a;
            MoleculeGraph m;
            MolJoin j = medit.getCurfragJoin();
            ret = 2;
            if (medit.isDragged() && cfempty && j != null) {
                medit.join(j, cf, 0);
                medit.restoreNonReactionIfPossible();
            } else if (!medit.isDragged() && (m = cf.getMainMoleculeGraph()).isAtom() && (a = m.getAtom(0)).getBondCount() == 0 && patom != null && !MolJoin.canBeReplacedBy(a, patom)) {
                medit.getDocument().removeAtom(a);
                doHist = false;
                ret = 1;
            }
            cf.clear();
            medit.flyingBondMol = null;
            medit.setMoveMode(0, false);
            medit.jointAtom = null;
        }
        if (doHist && !cfempty) {
            medit.historize();
        }
        medit.dragged = false;
        return ret;
    }

    @Override
    public boolean pointerMove(int modifiers) {
        MolAtom pnta;
        this.inBondMode = false;
        MolEditor medit = this.getEditor();
        medit.pntAB(false);
        PointedObject po = medit.getPointedObject();
        MolAtom molAtom = pnta = po != null && po instanceof AtomPO ? ((AtomPO)po).getAtom() : null;
        if (pnta != null && medit.isBranchable(pnta) && (MolJoin.canBeSproutTo(this.atom, pnta) || (modifiers & 1) != 0 && !(this.atom instanceof SgroupAtom))) {
            MolAtom a1 = (MolAtom)pnta.clone();
            int bocopnta = pnta.getBondCount();
            int implhpnta = pnta.getImplicitHcount();
            int implha1 = implhpnta > bocopnta ? implhpnta - bocopnta : 0;
            MolAtom a2 = (MolAtom)this.atom.clone();
            Molecule m = BondSM.createBondMol(1, a1, a2);
            double desired = medit.getMol().getBondCount() > 0 ? medit.getMol().getDesiredLength(medit.getMol().getBond(0)) : 0.0;
            a2.setXYZ(a1.getX() + desired, a1.getY(), a1.getZ());
            a1.setImplicitHcount(implha1);
            medit.showPossibleMolecule(m, true);
        } else if (pnta != null && (MolJoin.canBeSpiroTo(this.atom, pnta) || this.atom instanceof SgroupAtom && MolJoin.canBeReplacedBy(this.atom, pnta))) {
            Molecule m = this.getMol();
            m.moveTo(pnta.getLocation());
            medit.showPossibleMolecule(m, true);
        } else {
            medit.clearShowMolecule();
        }
        return true;
    }

    @Override
    public boolean pointerDrag(int modifiers) {
        PointedObject po;
        MolAtom pnta;
        this.inBondMode = false;
        MolEditor med = this.getEditor();
        if (med.atomBranchPiece != null && med.atomBranchPiece.isAtom()) {
            MolAtom at = med.atomBranchPiece.getAtom(0);
            if (at.getAtno() == 209 || at.getAtno() == 210 || at.getAtno() == 0) {
                return false;
            }
        } else if (!(this.atom instanceof SgroupAtom) && med.moveOrRotateCurfrag(modifiers, false)) {
            return true;
        }
        MolAtom molAtom = pnta = (po = med.getPointedObject()) != null && po instanceof AtomPO ? ((AtomPO)po).getAtom() : null;
        if (pnta != null && (MolJoin.canBeSproutTo(this.atom, pnta) || !(this.atom instanceof SgroupAtom) && !(pnta instanceof SgroupAtom) && med.isShowMoleculeSet())) {
            return med.beginPossibleMoleculeDrawing(modifiers);
        }
        if (pnta != null && this.atom instanceof SgroupAtom && !MolJoin.canJoinByBond(this.atom, pnta)) {
            if (med.atomBranchPiece != null) {
                med.atomBranchPiece.moveTo(med.getPointerPos());
                med.setPiece0(med.atomBranchPiece, null);
                med.atomBranchPiece = null;
            }
            return false;
        }
        if (med.atomBranchPiece != null) {
            med.clearShowMolecule();
            return med.doBondDrawing(modifiers);
        }
        return false;
    }

    @Override
    public boolean pointerCopyDrag(int mod) {
        return true;
    }

    @Override
    public int modkeyChange(int mod) {
        MolEditor med = this.getEditor();
        int oldmod = med.getModifiers();
        if ((mod & 1) != 0 && (oldmod & 1) == 0) {
            if (this.atom instanceof SgroupAtom) {
                PointedObject po = this.getEditor().getPointedObject();
                if (po != null) {
                    if (po instanceof AtomPO && (mod & 0x10) == 0) {
                        this.changeSketchModeInCaseOfSgroup(true, true);
                        med.command(1, mod);
                        return 1;
                    }
                    return 0;
                }
                this.changeSketchModeInCaseOfSgroup(true, true);
                return 1;
            }
            if ((mod & 0x10) == 0) {
                this.pointerMove(mod);
                return 1;
            }
        }
        if ((mod & 1) == 0 && (oldmod & 1) != 0) {
            if ((mod & 0x10) == 0) {
                PointedObject po = this.getEditor().getPointedObject();
                if (po != null && po instanceof AtomPO) {
                    this.pointerMove(mod);
                    return 1;
                }
            } else {
                med.rotateCurrentMoleculeTo15DegreesLine();
                return 1;
            }
        }
        return 0;
    }

    private void changeSketchModeInCaseOfSgroup(boolean setloc, boolean modchanged) {
        SuperatomSgroup sg = ((SgroupAtom)this.atom).getSgroup();
        Molecule m = (Molecule)sg.getParentMolecule().clone();
        m.expandSgroups();
        m.setProperty("sgroupstate", "expand");
        if (setloc) {
            DPoint3 center = new DPoint3();
            m.calcCenter(center);
            m.setLocation(center);
            m.moveTo(this.atom.getLocation());
        }
        MoleculeSM sm = new MoleculeSM(this, m);
        this.getEditor().setSketchMode(sm, false, modchanged);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeObject(this.atom);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        this.atom = (MolAtom)ois.readObject();
    }
}

