/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.common.util.GeomCalc;
import chemaxon.core.util.GeomUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.ArrayList;

public class GroupUtil {
    public static void addMarkushBond(MulticenterSgroup msg) {
        if (msg.getCentralAtom() == null) {
            msg.addCentralAtom();
        }
        DPoint3 center = msg.recalcCentralAtom();
        GroupUtil.createMarkushBond(msg);
        if (msg.getCentralAtom().getBondCount() == 1) {
            MolAtom otherAtom = msg.getCentralAtom().getBond(0).getOtherAtom(msg.getCentralAtom());
            Object directions = new float[6][];
            float radius = 2.31f;
            DPoint3 other = new DPoint3(center.x, center.y + (double)radius, center.z);
            for (int i = 0; i < msg.getAtomCount(); ++i) {
                MolAtom atom = msg.getAtom(i);
                double phi = GeomUtil.calculateAngle(other, center, atom.getLocation());
                if (!(Math.abs(phi - Math.PI) < 0.3490658503988659)) continue;
                float[] corrected_dir = GroupUtil.getNextDirection(center, other, 1, 1, 0.5235987755982988);
                other.x = corrected_dir[0];
                other.y = corrected_dir[1];
            }
            int max = 0;
            int maxInd = -1;
            for (int i = 0; i < ((float[][])directions).length; ++i) {
                int count;
                directions[i] = GroupUtil.getNextDirection(center, other, i, 1, 1.0471975511965976);
                if (!GroupUtil.isCrossingBond(msg, directions[i]) || (count = GroupUtil.nearAtomCount(new DPoint3(directions[i][0], directions[i][1], center.z), msg.getSgroupGraph().getAtomArray(), radius)) <= max) continue;
                max = count;
                maxInd = i;
            }
            if (maxInd == -1) {
                maxInd = 0;
            }
            otherAtom.setXYZ(directions[maxInd][0], directions[maxInd][1], center.z);
            other = otherAtom.getLocation();
            float[] cw = GroupUtil.getNextDirection(center, other, 1, 1, 1.0471975511965976);
            float[] acw = GroupUtil.getNextDirection(center, other, 1, -1, 1.0471975511965976);
            int direction = 1;
            boolean cw_intersects = GroupUtil.isCrossingBond(msg, cw);
            boolean acw_intersects = GroupUtil.isCrossingBond(msg, acw);
            int cw_count = GroupUtil.nearAtomCount(new DPoint3(cw[0], cw[1], center.z), msg.getSgroupGraph().getAtomArray(), radius);
            int acw_count = GroupUtil.nearAtomCount(new DPoint3(acw[0], acw[1], center.z), msg.getSgroupGraph().getAtomArray(), radius);
            if (acw_intersects && cw_intersects || !acw_intersects && !cw_intersects) {
                int n = direction = cw_count < acw_count ? -1 : 1;
                if (cw_count == acw_count) {
                    int acwc;
                    int cwc = GroupUtil.nearAtomCount(new DPoint3(cw[0], cw[1], center.z), msg.getParentMolecule().getAtomArray(), radius);
                    direction = cwc > (acwc = GroupUtil.nearAtomCount(new DPoint3(acw[0], acw[1], center.z), msg.getParentMolecule().getAtomArray(), radius)) ? -1 : 1;
                }
            } else if (acw_intersects) {
                direction = -1;
            }
            directions = GroupUtil.getSortedDirection(msg, center, other, direction);
            for (int i = 0; i < ((float[][])directions).length && GroupUtil.findNearBond(msg, msg.getCentralAtom().getBond(0)); ++i) {
                otherAtom.setXYZ(directions[i][0], directions[i][1], center.z);
            }
        }
    }

    private static float[][] getSortedDirection(MulticenterSgroup msg, DPoint3 center, DPoint3 other, int direction) {
        float[][] directions = new float[6][];
        ArrayList<Object> directions1 = new ArrayList<Object>();
        ArrayList<float[]> directions2 = new ArrayList<float[]>();
        for (int i = 0; i < directions.length && GroupUtil.findNearBond(msg, msg.getCentralAtom().getBond(0)); ++i) {
            float[] dir = GroupUtil.getNextDirection(center, other, i, direction, 1.0471975511965976);
            if (GroupUtil.isCrossingBond(msg, dir)) {
                directions1.add(dir);
                continue;
            }
            directions2.add(dir);
        }
        directions1.addAll(directions2);
        directions1.toArray((T[])directions);
        return directions;
    }

    private static boolean isCrossingBond(MulticenterSgroup msg, float[] p) {
        DPoint3 p1 = msg.getCentralAtom().getLocation();
        DPoint3 p2 = new DPoint3(p[0], p[1], p1.z);
        MolBond[] bonds = GeomUtil.getCrossingBonds(msg.getSgroupGraph().getBondArray(), p1, p2, true);
        return bonds.length > 0;
    }

    private static boolean findNearBond(MulticenterSgroup msg, MolBond bond) {
        Molecule mol = msg.getParentMolecule();
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            MulticenterSgroup mc;
            if (mol.getSgroup(i).getType() != 14 || msg == (mc = (MulticenterSgroup)mol.getSgroup(i)) || !GroupUtil.containsSameAtoms(msg, mc)) continue;
            MolBond cbond = mc.getCentralAtom().getBond(0);
            if ((!GroupUtil.isNear(bond.getAtom1(), cbond.getAtom1()) || !GroupUtil.isNear(bond.getAtom2(), cbond.getAtom2())) && (!GroupUtil.isNear(bond.getAtom1(), cbond.getAtom2()) || !GroupUtil.isNear(bond.getAtom2(), cbond.getAtom1()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isNear(MolAtom atom1, MolAtom atom2) {
        return atom1.getLocation().distance(atom2.getLocation()) < 0.001;
    }

    private static boolean containsSameAtoms(MulticenterSgroup sgroup1, MulticenterSgroup sgroup2) {
        SelectionMolecule graph1 = sgroup1.getSgroupGraph();
        SelectionMolecule graph2 = sgroup2.getSgroupGraph();
        if (graph1.getAtomCount() != graph2.getAtomCount()) {
            return false;
        }
        for (int i = 0; i < graph1.getAtomCount(); ++i) {
            if (graph2.indexOf(graph1.getAtom(i)) != -1) continue;
            return false;
        }
        return true;
    }

    private static int nearAtomCount(DPoint3 point, MolAtom[] atomArray, float radius) {
        int count = 0;
        for (int i = atomArray.length - 1; i >= 0; --i) {
            if (!(atomArray[i].getLocation().distance(point) < (double)radius)) continue;
            ++count;
        }
        return count;
    }

    private static void createMarkushBond(MulticenterSgroup msg) {
        Molecule parent = msg.getParentMolecule();
        MolAtom otherAtom = new MolAtom(6);
        MolBond bond = GroupUtil.createBond("markush", msg.getCentralAtom(), otherAtom);
        parent.add(otherAtom);
        parent.add(bond);
        parent.valenceCheck();
    }

    public static float[] getNextDirection(DPoint3 p1, DPoint3 p2, int i, int dir, double angle) {
        float[] f = new float[]{(float)(p2.x - p1.x), (float)(p2.y - p1.y)};
        GeomCalc.rotateZ(f, (double)((float)Math.sin((double)(i * dir) * angle)), (double)((float)Math.cos((double)(i * dir) * angle)));
        f[0] = (float)((double)f[0] + p1.x);
        f[1] = (float)((double)f[1] + p1.y);
        return f;
    }

    private static MolBond createBond(String type, MolAtom a1, MolAtom a2) {
        MolBond bond = type.equals("multicenter") ? new MolBond(a1, a2, 9) : (type.equals("markush") ? new MolBond(a1, a2) : new MolBond(a1, a2));
        return bond;
    }

    private static void modifyOrders(int from, int to, int value, MoleculeGraph graph) {
        for (int i = 0; i < graph.getAtomCount(); ++i) {
            MolAtom atom = graph.getAtom(i);
            int order = atom.getRgroupAttachmentPointOrder();
            if (atom.getAtno() != 138 || order < from || order > to) continue;
            atom.setRgroupAttachmentPointOrder(order + value);
        }
    }

    public static void changeAttachmentPointOrder(MolAtom atom, int order) {
        if (order == 0) {
            MoleculeGraph molecule = atom.getParent();
            if (molecule != null) {
                molecule.removeAtom(atom);
            }
        } else {
            int oldOrder = atom.getRgroupAttachmentPointOrder();
            GroupUtil.modifyOrders(oldOrder < order ? oldOrder : order, oldOrder < order ? order : oldOrder, oldOrder < order ? -1 : 1, atom.getParent());
            atom.setRgroupAttachmentPointOrder(order);
        }
    }

    public static void changeLigandOrder(MolBond bond, MolAtom atom, int order) {
        if (order > 0) {
            MolAtom ligand = bond.getOtherAtom(atom);
            int oldOrder = atom.getLigandOrder(ligand);
            GroupUtil.modifyLigandOrders(oldOrder < order ? oldOrder : order, oldOrder < order ? order : oldOrder, oldOrder < order ? -1 : 1, atom);
            atom.setLigandOrder(order, ligand);
        }
    }

    private static void modifyLigandOrders(int from, int to, int value, MolAtom atom) {
        if (value < 0) {
            for (int i = 0; i < atom.getBondCount(); ++i) {
                int order = atom.getLigandOrder(atom.getLigand(i));
                if (atom.getAtno() != 134 || order <= from || order > to) continue;
                atom.setLigandOrder(order + value, atom.getLigand(i));
            }
        } else {
            for (int i = atom.getBondCount() - 1; i > 0; --i) {
                int order = atom.getLigandOrder(atom.getLigand(i));
                if (atom.getAtno() != 134 || order < from || order >= to) continue;
                atom.setLigandOrder(order + value, atom.getLigand(i));
            }
        }
    }
}

