/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.event.SwingPropertyChangeSupport;

public class History
implements Serializable {
    private MDocument[] molHist = new MDocument[this.molHistLen];
    private Point[] cornerHist = new Point[this.molHistLen];
    private double[] scaleHist = new double[this.molHistLen];
    private int[] autoHydrogenizeHist = new int[this.molHistLen];
    private int[][] scrollBarHist = new int[this.molHistLen][4];
    private boolean[] selectionToZoomHist = new boolean[this.molHistLen];
    private MoleculeGraph[][] molgToZoomHist = new MoleculeGraph[this.molHistLen][];
    private CTransform3D[] rotateMatrHist = new CTransform3D[this.molHistLen];
    private int molHistLen = 100;
    private int molHistCur = -1;
    private int molHistMax = -1;
    private boolean historyOverflow = false;
    private PropertyChangeSupport changeSupport;

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    private void changed() {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange("undoEnabled", null, (Object)this.isUndoable());
        this.changeSupport.firePropertyChange("redoEnabled", null, (Object)this.isRedoable());
    }

    public int getCapacity() {
        return this.molHistLen;
    }

    public void setCapacity(int l) {
        this.molHistLen = l;
        this.molHistMax = -1;
        this.molHistCur = -1;
        this.molHist = new MDocument[l];
        this.cornerHist = new Point[l];
        this.scaleHist = new double[l];
        this.autoHydrogenizeHist = new int[l];
        this.scrollBarHist = new int[l][4];
        this.selectionToZoomHist = new boolean[l];
        this.molgToZoomHist = new MoleculeGraph[l][];
        this.rotateMatrHist = new CTransform3D[l];
        this.changed();
    }

    public void clear() {
        this.setCapacity(this.getCapacity());
    }

    public boolean isEmpty() {
        return this.molHistCur == 0;
    }

    public boolean hasChanged() {
        return this.molHistCur > 0 || this.historyOverflow;
    }

    public boolean isUndoable() {
        return this.molHistCur > 0;
    }

    public synchronized boolean isRedoable() {
        return this.molHistCur < this.molHistMax;
    }

    MDocument back() {
        MDocument result = this.molHist.length != 0 ? this.molHist[--this.molHistCur].cloneDocument() : null;
        this.changed();
        return result;
    }

    MDocument forward() {
        MDocument result = this.molHist.length != 0 ? this.molHist[++this.molHistCur].cloneDocument() : null;
        this.changed();
        return result;
    }

    MDocument forwardWith(int delta) {
        if (this.molHist.length == 0) {
            this.molHistCur = -1;
            this.molHistMax = -1;
            this.changed();
            return null;
        }
        int size = this.molHist.length;
        if (this.molHistCur < size - delta) {
            this.molHistCur += delta;
            this.changed();
            return this.molHist[this.molHistCur].cloneDocument();
        }
        return null;
    }

    void historize(MDocument doc, Point corner, int autoh, double scale, CTransform3D rotationMatrix) {
        int size;
        if (this.molHist.length == 0) {
            this.molHistCur = -1;
            this.molHistMax = -1;
            this.changed();
            return;
        }
        if (this.molHistCur > 0 && this.molHist[this.molHistCur].isEmpty() && doc.isEmpty()) {
            --this.molHistCur;
        }
        if (this.molHistCur < (size = this.molHist.length) - 1) {
            this.molHist[++this.molHistCur] = doc.cloneDocument();
            this.cornerHist[this.molHistCur] = corner;
            this.scaleHist[this.molHistCur] = scale;
            this.autoHydrogenizeHist[this.molHistCur] = autoh;
            this.rotateMatrHist[this.molHistCur] = rotationMatrix;
        } else {
            System.arraycopy(this.molHist, 1, this.molHist, 0, size - 1);
            this.molHist[size - 1] = doc.cloneDocument();
            System.arraycopy(this.cornerHist, 1, this.cornerHist, 0, size - 1);
            this.cornerHist[size - 1] = corner;
            System.arraycopy(this.scaleHist, 1, this.scaleHist, 0, size - 1);
            this.scaleHist[size - 1] = scale;
            System.arraycopy(this.autoHydrogenizeHist, 1, this.autoHydrogenizeHist, 0, size - 1);
            this.autoHydrogenizeHist[size - 1] = autoh;
            System.arraycopy(this.rotateMatrHist, 1, this.rotateMatrHist, 0, size - 1);
            this.rotateMatrHist[size - 1] = rotationMatrix;
            this.historyOverflow = true;
        }
        this.molHistMax = this.molHistCur;
        this.changed();
    }

    void unhistorize() {
        if (this.molHistCur > 0) {
            --this.molHistCur;
            this.changed();
        }
    }

    MDocument getPreviousDocument(int delta) {
        return this.molHist.length != 0 && this.molHistCur >= delta ? this.molHist[this.molHistCur - delta] : null;
    }

    MDocument getDocument() {
        return this.molHist.length != 0 && this.molHistCur >= 0 ? this.molHist[this.molHistCur] : null;
    }

    Molecule getMolecule() {
        MDocument doc = this.getDocument();
        return doc != null ? (Molecule)doc.getMainMoleculeGraph() : null;
    }

    Point getCorner() {
        if (this.molHistCur < 0) {
            return null;
        }
        return this.cornerHist[this.molHistCur];
    }

    void setCorner(Point p) {
        if (this.molHistCur < 0) {
            return;
        }
        this.cornerHist[this.molHistCur] = p;
    }

    int[] getScrollBarHist() {
        if (this.molHistCur < 0) {
            return null;
        }
        return this.scrollBarHist[this.molHistCur];
    }

    void setScrollBarHist(int xmin, int xmax, int ymin, int ymax) {
        if (this.molHistCur < 0) {
            return;
        }
        int size = this.molHist.length;
        if (this.molHistCur < size) {
            this.scrollBarHist[this.molHistCur][0] = xmin;
            this.scrollBarHist[this.molHistCur][1] = xmax;
            this.scrollBarHist[this.molHistCur][2] = ymin;
            this.scrollBarHist[this.molHistCur][3] = ymax;
        } else {
            System.arraycopy(this.scrollBarHist, 1, this.scrollBarHist, 0, size - 1);
            this.scrollBarHist[size - 1][0] = xmin;
            this.scrollBarHist[size - 1][1] = xmax;
            this.scrollBarHist[size - 1][2] = ymin;
            this.scrollBarHist[size - 1][3] = ymax;
            this.historyOverflow = true;
        }
    }

    double getScale() {
        if (this.molHistCur < 0) {
            return 0.0;
        }
        return this.scaleHist[this.molHistCur];
    }

    void setScale(double scale) {
        if (this.molHistCur < 0) {
            return;
        }
        int size = this.molHist.length;
        if (this.molHistCur < size) {
            this.scaleHist[this.molHistCur] = scale;
        } else {
            System.arraycopy(this.scaleHist, 1, this.scaleHist, 0, size - 1);
            this.scaleHist[size - 1] = scale;
            this.historyOverflow = true;
        }
    }

    int getAutoHydrogenize() {
        return this.autoHydrogenizeHist[this.molHistCur];
    }

    void setAutoHydrogenize(int autoh) {
        this.autoHydrogenizeHist[this.molHistCur] = autoh;
    }

    boolean getSelectionToZoom() {
        if (this.molHistCur < 0) {
            return false;
        }
        return this.selectionToZoomHist[this.molHistCur];
    }

    void setSelectionToZoom(boolean zoomSelMol) {
        if (this.molHistCur < 0) {
            return;
        }
        int size = this.molHist.length;
        if (this.molHistCur < size) {
            this.selectionToZoomHist[this.molHistCur] = zoomSelMol;
        } else {
            System.arraycopy(this.selectionToZoomHist, 1, this.selectionToZoomHist, 0, size - 1);
            this.selectionToZoomHist[size - 1] = zoomSelMol;
            this.historyOverflow = true;
        }
    }

    MoleculeGraph[] getMolGraphToZoom() {
        if (this.molHistCur < 0) {
            return null;
        }
        return this.molgToZoomHist[this.molHistCur];
    }

    void setMolGraphToZoom(MoleculeGraph[] molGToZoom) {
        if (this.molHistCur < 0) {
            return;
        }
        int size = this.molHist.length;
        if (this.molHistCur < size) {
            this.molgToZoomHist[this.molHistCur] = molGToZoom;
        } else {
            System.arraycopy(this.molgToZoomHist, 1, this.molgToZoomHist, 0, size - 1);
            this.molgToZoomHist[size - 1] = molGToZoom;
            this.historyOverflow = true;
        }
    }

    CTransform3D getRotationMatrix() {
        if (this.molHistCur < 0) {
            return null;
        }
        return this.rotateMatrHist[this.molHistCur];
    }
}

