/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.core.util.GeomUtil;
import chemaxon.formats.MolExporter;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.edit.DirectedMerge;
import chemaxon.marvin.modelling.edit.Mirror;
import chemaxon.marvin.modelling.edit.Rotate;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.paint.internal.util.DrawingUtil;
import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.AtomPairPO;
import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.ChainSM;
import chemaxon.marvin.sketch.GroupUtil;
import chemaxon.marvin.sketch.History;
import chemaxon.marvin.sketch.MObjectPO;
import chemaxon.marvin.sketch.MObjectSM;
import chemaxon.marvin.sketch.MolJoin;
import chemaxon.marvin.sketch.MoleculeSM;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SelectUtil;
import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.modules.ArrowSM;
import chemaxon.marvin.sketch.modules.SgroupUpdate;
import chemaxon.marvin.sketch.modules.SgroupValidate;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.ColorSetUtil;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.HourglassHandler;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.MoleculeUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PageSettings;
import chemaxon.struc.QueryBond;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RgMoleculeGraphIface;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.graphics.MAssigner;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.graphics.MMidPoint;
import chemaxon.struc.graphics.MNameTextBox;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRArrow;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRectanglePoint;
import chemaxon.struc.graphics.MRoundedRectangle;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import chemaxon.util.iterator.IteratorFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class MolEditor
implements Serializable,
StereoConstants {
    private static final long serialVersionUID = 2463379690025911142L;
    public static int ARRANGE_FRONT = 0;
    public static int ARRANGE_BACK = 1;
    public static final int MOD_SHIFT = 1;
    public static final int MOD_CTRL = 2;
    public static final int MOD_ALT = 8;
    public static final int MOD_BUTTON1 = 16;
    public static final int MOV_NONE = 0;
    public static final int MOV_TRANSLATE = 1;
    public static final int MOV_ROTZ = 2;
    public static final int MOV_ROT3D = 3;
    public static final int POINTERPOS = 0;
    public static final int POINTERMOVE = 1;
    public static final int POINTERDRAG = 2;
    public static final int POINTERENTER = 3;
    public static final int POINTEREXIT = 4;
    public static final int BUTTONDOWN = 5;
    public static final int BUTTONDOWN2 = 6;
    public static final int BUTTONUP = 7;
    public static final int MODKEYCHANGE = 8;
    public static final int RESET0 = 10;
    public static final int RESET1 = 11;
    public static final int RESET = 12;
    public static final int SELECTALL = 13;
    public static final int UNSELECTALL = 14;
    public static final int UNSELECTALL_EXCEPT_SUBSELECTION = 15;
    public static final int HFLIP = 16;
    public static final int VFLIP = 17;
    public static final int HMIRROR = 18;
    public static final int VMIRROR = 19;
    public static final int DELSEL = 20;
    public static final int CLEAR = 21;
    public static final int GROUP_CONTRACT_ALL = 22;
    public static final int GROUP_EXPAND_ALL = 23;
    public static final int GROUP_UNGROUP_ALL = 24;
    public static final int MAPATOMS = 25;
    public static final int UNMAPATOMS = 26;
    public static final int MAPATOMS_COMPLETE = 27;
    public static final int MAPATOMS_CHANGING = 28;
    public static final int MAPATOMS_MATCHING = 29;
    public static final int FLIP_GROUP = 30;
    public static final int FLIP_CANVAS = 31;
    public static final int CANVASMIRROR = 32;
    public static final int GROUPMIRROR = 33;
    public static final int PLANE_3D = 34;
    public static final int DIRECTED_3D_MERGE = 35;
    public static final int HALIGN = 36;
    public static final int VALIGN = 37;
    public static final int HDISTRIBUTE = 38;
    public static final int VDISTRIBUTE = 39;
    public static final int HALIGN_AND_DISTRIBUTE = 40;
    public static final int VALIGN_AND_DISTRIBUTE = 41;
    public static final int ENDDRAG = 10;
    public static final int HYDROGENIZE = 11;
    public static final int LP_ADD_OR_REMOVE = 12;
    public static final int ABSSTEREO = 13;
    public static final int INVERT = 14;
    public static final int RMNODE = 10;
    public static final int RMEDGE = 11;
    public static final int RGROUP_APO = 12;
    public static final int HALIGNTOBOND = 13;
    public static final int VALIGNTOBOND = 14;
    public static final int RXN_GROUPFRAGS = 15;
    public static final int BRANCH = 16;
    public static final int SGROUP_CONTRACT = 17;
    public static final int SGROUP_EXPAND = 18;
    public static final int SGROUP_UNGROUP = 19;
    public static final int SGROUP_REMOVE = 20;
    public static final int AROMATIZE = 21;
    public static final int DEAROMATIZE = 22;
    public static final int RXN_GROUPSPLIT = 23;
    public static final int SETATOMSIZE = 10;
    public static final int SETBONDSPACING = 11;
    public static final int SETMERGEDST = 12;
    public static final int SETSTICKDST = 13;
    public static final int SGROUP_CREATE_SUP = 10;
    public static final int SGROUP_CREATE_MUL = 11;
    public static final int SGROUP_CREATE_DAT = 12;
    public static final int SGROUP_EDIT_DAT = 13;
    public static final int RGROUP_CREATE = 14;
    public static final int SGROUP_CREATE_COM = 15;
    public static final int SGROUP_CREATE_MIX = 16;
    public static final int SGROUP_CREATE_FOR = 17;
    public static final int SGROUP_CREATE_SRU = 18;
    public static final int SGROUP_CREATE_RSRU = 19;
    public static final int SGROUP_CREATE_ANYPOLYMER = 20;
    public static final int SGROUP_CREATE_COPOLYMER = 21;
    public static final int SGROUP_CREATE_ALTERNATING_COPOLYMER = 22;
    public static final int SGROUP_CREATE_BLOCK_COPOLYMER = 23;
    public static final int SGROUP_CREATE_RANDOM_COPOLYMER = 24;
    public static final int SGROUP_CREATE_CROSSLINK = 25;
    public static final int SGROUP_CREATE_GENERIC = 26;
    public static final int SGROUP_CREATE_GRAFT = 27;
    public static final int SGROUP_CREATE_MER = 28;
    public static final int SGROUP_CREATE_MODIFICATION = 29;
    public static final int SGROUP_CREATE_MONOMER = 30;
    public static final int SGROUP_CREATE_LSRU = 31;
    public static final int SGROUP_ATTACH_DATA = 32;
    public static final int SETMOL = 0;
    public static final int SETMOL_CLEANED = 1;
    public static final int SETSKETCHOBJ = 0;
    public static final int SELSETSKETCHOBJ = 1;
    public static final int MOVEOBJECTINSTACK = 0;
    public static final int REMOVEOBJECT = 1;
    public static final int SET_OBJECT_ARROW_HEAD_FLAGS = 2;
    public static final int SET_OBJECT_ARROW_TAIL_FLAGS = 3;
    public static final int SET_OBJECT_LINE_FLAGS = 4;
    public static final int SET_OBJECT_BASE_FONT_STYLE = 5;
    public static final int SET_RECT_TOPTION = 6;
    public static final int SET_RECT_TCENTER = 7;
    public static final int SET_OBJECT_HALIGN = 8;
    public static final int SET_OBJECT_VALIGN = 9;
    public static final int SET_OBJECT_COLOR = 0;
    public static final int SET_OBJECT_LINE_COLOR = 1;
    public static final int SET_OBJECT_BG = 2;
    public static final int SET_OBJECT_LINE_THICKNESS = 0;
    public static final int SET_OBJECT_LINE_ARC_ANGLE = 1;
    public static final int SET_OBJECT_LINE_TAIL_SKIP = 2;
    public static final int SET_OBJECT_LINE_HEAD_SKIP = 3;
    public static final int SET_OBJECT_ARROW_HEAD_LENGTH = 4;
    public static final int SET_OBJECT_ARROW_TAIL_LENGTH = 5;
    public static final int SET_OBJECT_ARROW_HEAD_WIDTH = 6;
    public static final int SET_OBJECT_ARROW_TAIL_WIDTH = 7;
    public static final int SET_OBJECT_FONT_SCALE = 8;
    public static final int SET_OBJECT_BASE_FONT_FAMILY = 0;
    public static final int ATOM_CLEAR_SET_ATNO = 20;
    public static final int ATOM_MASSNO = 21;
    public static final int ATOM_CHARGE = 22;
    public static final int ATOM_RADICAL = 23;
    public static final int ATOM_RGROUP = 24;
    public static final int ATOM_STEREO = 25;
    public static final int ATOM_MAP = 26;
    public static final int ATOM_LINKNODE_MINREP = 27;
    public static final int ATOM_LINKNODE_MAXREP = 28;
    public static final int ATOM_RXNSTEREO = 29;
    public static final int ATOM_ENHANCEDSTEREO = 30;
    public static final int ATOM_VALENCE_PROP = 31;
    public static final int ATOM_QPROP_X = 32;
    public static final int ATOM_QPROP_D = 33;
    public static final int ATOM_QPROP_H = 34;
    public static final int ATOM_QPROP_IMP_H = 35;
    public static final int ATOM_QPROP_RINGS = 36;
    public static final int ATOM_QPROP_SRS = 37;
    public static final int ATOM_QPROP_AROM = 38;
    public static final int ATOM_MDL_SUBST = 39;
    public static final int ATOM_MDL_RBCOUNT = 40;
    public static final int ATOM_MDL_UNSAT = 41;
    public static final int BOND_FLAGS = 42;
    public static final int SPEC_ISOTOPE_SYMBOL_FLAG = 4096;
    public static final int MOV_ROT3D_NONE = -1;
    public static final int MOV_ROT3D_ARBITRARY = 0;
    public static final int MOV_ROT3D_X = 1;
    public static final int MOV_ROT3D_Y = 2;
    public static final int MOV_ROT3D_Z = 3;
    public static final int MOV_ROT3D_FREE = 4;
    public static final int MOV_ROT3D_GROUP = 5;
    private static final int NO_SELECTION_MODE = 0;
    private static final int CENTER_SELECTION_MODE = 1;
    private static final int AXIS_SELECTION_MODE = 2;
    private transient PointedObject pntObject;
    public transient Sgroup[] pntSgroups;
    private int moveMode = 0;
    private boolean persistentMoveMode = false;
    private MDocument document;
    private MSelectionDocument selectionDoc;
    private static HashMap<String, List<Integer>> extraBondIdMapping = null;
    private static HashMap<String, List<Integer>> queryAtomIdMapping = null;
    private static HashMap<String, List<Integer>> atomStringIdMapping = null;
    private List<Integer> elements = null;
    private List<Integer> queryAtoms = null;
    private List<Integer> extraBonds = null;
    private List<Integer> atomStrings = null;
    private boolean reactionSupported = true;
    private int chiralitySupport = 1;
    private double atomSize;
    private double bondSpacing;
    private double stickdst;
    private double mergedst;
    boolean mouseInside;
    boolean dragged;
    private int modifiers;
    private double ptrX;
    private double ptrY;
    private double ptrZ;
    private double prevPtrX;
    private double prevPtrY;
    private double prevPtrZ;
    private transient List<Sgroup> pntSgroupsV;
    private transient int ptrHistLen;
    private transient double[] ptrHist;
    private transient double ptrPhi = 0.0;
    private transient int[] atomAtomMaps = null;
    private History history;
    private MolPainter painter;
    private CallbackIface sketchCanvas;
    private transient CTransform3D transformMatrix;
    private MDocument curfrag;
    private MDocument prevCurfrag;
    public MoleculeGraph flyingBondMol;
    boolean curfragMoved;
    boolean canRotCurfrag;
    boolean canMovCurfrag;
    private int atomSelectionMode = 0;
    private double curfragR;
    private DPoint3 rotO = new DPoint3();
    private DPoint3 rotAxisPoint;
    private boolean isAxisSet;
    private double rotateZPhi;
    private double rotatePhi = 0.0;
    private double rotate3dPhiX;
    private double rotate3dPhiY;
    private double rotate3dPhi;
    private double rotate3dx;
    private double rotate3dy;
    private int rotate3direction;
    private int indexToRot = -1;
    private int pointIndexToRot = -1;
    Molecule atomBranchPiece;
    private Molecule piece;
    private Molecule pieceOriginalObject;
    private Molecule showMolecule;
    private boolean paintOnlyShowMolecule = false;
    private SketchMode sketchMode;
    public boolean bondrawMode;
    private double thisBondlen;
    private int lastBondFlags;
    private String lastQueryBondString = null;
    boolean newSelection = true;
    MolAtom jointAtom = null;
    private MolJoin curfragJoin = null;
    private boolean bondDraggedAlong = true;
    private boolean historizeEnabled = true;
    private boolean documentEdited = false;
    private transient boolean deserializing = false;
    private boolean isDataSgroupLabelPointed = false;
    private boolean dataSgroupLabelMoving = false;
    private DataSgroup dataSgroupObject = null;
    private transient CallbackIface objectOverwriter = null;
    private boolean hadSelection = true;
    private transient double[] cachedMolBounds = null;
    private transient long cachedMolBoundsInvCC = -1L;
    private transient boolean nameTextBoxAligned = true;
    private int[] scrollBarVals = new int[4];
    private MDocument lastSelectionDoc = null;
    private Point lastSelectionCorner = null;
    private double lastSelectionScale = 0.0;
    private boolean selectionHistorized = false;
    private boolean historizeUnSelection = false;
    private boolean deleteRemovesTerminalAtoms = true;
    private int rotation3DMode = -1;
    private boolean newKeyboardMotion = true;

    public MolEditor(MolPainter p, CallbackIface c) {
        this.history = new History();
        this.setSketchCanvas(c);
        this.setPainter(p);
        this.initTransient();
        this.setMol(new RgMolecule());
        this.curfrag = new MSelectionDocument(new SelectionMolecule());
    }

    private static final void initExtraBondIdMapping() {
        if (extraBondIdMapping != null) {
            return;
        }
        extraBondIdMapping = new HashMap();
        extraBondIdMapping.put("arom", Arrays.asList(4));
        extraBondIdMapping.put("any", Arrays.asList(0));
        extraBondIdMapping.put("wedge", Arrays.asList(17, 33));
        extraBondIdMapping.put("either", Arrays.asList(49, 194));
        extraBondIdMapping.put("ctu", Arrays.asList(450));
        extraBondIdMapping.put("1or2", Arrays.asList(5));
        extraBondIdMapping.put("aromany", Arrays.asList(6, 7));
        extraBondIdMapping.put("coordinate", Arrays.asList(9));
        extraBondIdMapping.put("topology", Arrays.asList(1025, 2049));
        extraBondIdMapping.put("bold_single", Arrays.asList(0x40000001));
        extraBondIdMapping.put("bold_double", Arrays.asList(0x40000002));
        extraBondIdMapping.put("bold_aromatic", Arrays.asList(0x40000004));
        extraBondIdMapping.put("double_up", Arrays.asList(18));
        extraBondIdMapping.put("aromatic_up", Arrays.asList(20));
        extraBondIdMapping.put("hashed", Arrays.asList(-2147483647));
    }

    private static final void initQueryAtomIdMapping() {
        if (queryAtomIdMapping != null) {
            return;
        }
        queryAtomIdMapping = new HashMap();
        queryAtomIdMapping.put("any", Arrays.asList(131));
        queryAtomIdMapping.put("hetero", Arrays.asList(132));
        queryAtomIdMapping.put("list", Arrays.asList(128));
        queryAtomIdMapping.put("notlist", Arrays.asList(129));
        queryAtomIdMapping.put("Rgroup", Arrays.asList(134));
        queryAtomIdMapping.put("H", Arrays.asList(200));
        queryAtomIdMapping.put("val", Arrays.asList(201));
        queryAtomIdMapping.put("conn", Arrays.asList(202));
        queryAtomIdMapping.put("rings", Arrays.asList(203));
        queryAtomIdMapping.put("srs", Arrays.asList(204));
        queryAtomIdMapping.put("arom", Arrays.asList(205, 206));
        queryAtomIdMapping.put("mdl_subst", Arrays.asList(211));
        queryAtomIdMapping.put("mdl_rbcnt", Arrays.asList(212));
        queryAtomIdMapping.put("mdl_unsat", Arrays.asList(213));
        queryAtomIdMapping.put("imp_hs", Arrays.asList(214));
        queryAtomIdMapping.put("exp_conn", Arrays.asList(215));
    }

    private static final void initAtomStringIdMapping() {
        if (atomStringIdMapping != null) {
            return;
        }
        atomStringIdMapping = new HashMap();
        atomStringIdMapping.put("alias", Arrays.asList(208));
        atomStringIdMapping.put("pseudo", Arrays.asList(136));
        atomStringIdMapping.put("smarts", Arrays.asList(207));
        atomStringIdMapping.put("value", Arrays.asList(209));
    }

    public void initAllowedElements(String elementsStr) {
        if (elementsStr == null || this.elements != null) {
            return;
        }
        this.elements = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(elementsStr, ",-", true);
        int prevAtomNum = 0;
        boolean intervalDefinition = false;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.equals("-")) {
                intervalDefinition = true;
                continue;
            }
            if (t.equals(",")) continue;
            int atomNum = 0;
            try {
                atomNum = MolAtom.getAtomicNumber(t);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (intervalDefinition) {
                for (int i = prevAtomNum + 1; i <= atomNum; ++i) {
                    this.elements.add(i);
                }
                intervalDefinition = false;
            } else {
                this.elements.add(atomNum);
            }
            prevAtomNum = atomNum;
        }
    }

    private <T> void initSettingsListBasedOnStringAndMapping(String str, List<T> list, HashMap<String, List<T>> mapping) {
        list = new ArrayList<T>();
        for (String s : mapping.keySet()) {
            if (!str.contains(s)) continue;
            list.addAll((Collection)mapping.get(s));
        }
    }

    public void initAllowedExtraBonds(String extraBondStr) {
        if (extraBondStr == null || this.extraBonds != null) {
            return;
        }
        MolEditor.initExtraBondIdMapping();
        this.initSettingsListBasedOnStringAndMapping(extraBondStr, this.extraBonds, extraBondIdMapping);
    }

    public void initAllowedQueryAtoms(String queryAtomStr, boolean appendAnyAndHetero) {
        if (queryAtomStr == null || this.queryAtoms != null) {
            return;
        }
        if (appendAnyAndHetero) {
            queryAtomStr = "any,hetero," + queryAtomStr;
        }
        MolEditor.initQueryAtomIdMapping();
        this.initSettingsListBasedOnStringAndMapping(queryAtomStr, this.queryAtoms, queryAtomIdMapping);
    }

    public void initAllowedAtomStrings(String atomStringsStr) {
        if (atomStringsStr == null || this.atomStrings != null) {
            return;
        }
        MolEditor.initAtomStringIdMapping();
        this.initSettingsListBasedOnStringAndMapping(atomStringsStr, this.atomStrings, atomStringIdMapping);
    }

    public final boolean isAllowed(Molecule m) {
        return m != null && (m.isSgroup() || this.isAllowedAtom(m) || this.isAllowedBond(m) || ChainSM.isChain(m) || !m.isSgroup() && !m.isAtom() && !m.isBond() && !ChainSM.isChain(m));
    }

    private final boolean isAllowedBond(Molecule m) {
        if (!m.isBond()) {
            return false;
        }
        MolBond bond = m.getBond(0);
        int f = bond.getFlags();
        return f >= 1 && f <= 3 || (f & 0xF000) != 0 || (f & 0x200) != 0 || this.extraBonds == null || this.extraBonds.contains(f);
    }

    private final boolean isAllowedAtom(Molecule m) {
        if (!m.isAtom()) {
            return false;
        }
        MolAtom a = m.getAtom(0);
        int atno = this.getAtnoOf(a);
        if (atno == 0) {
            if (a.getCharge() != 0) {
                return true;
            }
            if (a.getElectronProp() != -3) {
                return true;
            }
            if (a.getRadical() == 1 || a.getRadical() == 0) {
                return true;
            }
            if (a.getStereoGroupType() != 0) {
                return true;
            }
        } else {
            if (atno == 130) {
                return true;
            }
            if (atno == 133) {
                return true;
            }
            if (atno == 138) {
                return true;
            }
            if (atno == 209) {
                return true;
            }
            if (atno == 210) {
                return true;
            }
        }
        if (atno > 0 && atno < 110) {
            return this.elements == null || this.elements.contains(atno);
        }
        if (a.getAliasstr() != null || a.getQueryString() != null || a.getExtraLabel() != null) {
            return this.atomStrings == null || this.atomStrings.contains(atno);
        }
        return this.queryAtoms == null || this.queryAtoms.contains(atno);
    }

    private final int getAtnoOf(MolAtom a) {
        int atno = a.getAtno();
        if (atno == 6 && a.getQueryString() != null) {
            return 207;
        }
        if (atno != 0) {
            return atno;
        }
        if (a.getQProp("H") != null) {
            return 200;
        }
        if (a.getValenceProp() >= 0) {
            return 201;
        }
        if (a.getQProp("X") != null) {
            return 202;
        }
        if (a.getQProp("R") != null) {
            return 203;
        }
        if (a.getQProp("r") != null) {
            return 204;
        }
        if (a.getQProp("u") != null) {
            return 213;
        }
        if (a.getQProp("s") != null) {
            return 211;
        }
        if (a.getQProp("rb") != null) {
            return 212;
        }
        if (a.getQProp("h") != null) {
            return 212;
        }
        if (a.getQProp("D") != null) {
            return 212;
        }
        if (a.getQueryAromaticity() == 2) {
            return 205;
        }
        if (a.getQueryAromaticity() == 1) {
            return 206;
        }
        if (a.getAliasstr() != null) {
            return 208;
        }
        if (a.getExtraLabel() != null) {
            return 209;
        }
        return 0;
    }

    public Point getCorner() {
        return this.getPainter().getCorner();
    }

    public void setCorner(Point p, boolean addToHist) {
        this.getPainter().setCorner(p);
        if (addToHist && this.historizeEnabled) {
            this.history.setCorner(this.getCorner());
        }
    }

    public MolPainter getPainter() {
        return this.painter;
    }

    public void setPainter(MolPainter p) {
        this.painter = p;
    }

    public void setReactionSupported(boolean r) {
        this.reactionSupported = r;
    }

    public boolean isReactionSupported() {
        return this.reactionSupported;
    }

    public void setChiralitySupport(int r) {
        this.chiralitySupport = r;
    }

    public int getChiralitySupport() {
        return this.chiralitySupport;
    }

    public int getLastBondFlags() {
        return this.lastBondFlags;
    }

    public MolBond getLastBond(MolAtom a1, MolAtom a2) {
        if (this.lastQueryBondString == null) {
            return new MolBond(a1, a2, this.getLastBondFlags());
        }
        return new QueryBond(a1, a2, this.lastQueryBondString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int indexOf(MolAtom a) {
        Molecule m = this.getMol();
        Object object = m.getLock();
        synchronized (object) {
            return m.getGraphUnion().indexOf(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int indexOf(MolBond b) {
        Molecule m = this.getMol();
        Object object = m.getLock();
        synchronized (object) {
            MoleculeGraph umol = m.getGraphUnion();
            return umol.indexOf(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean abEdit(int cmd, int index, int val) {
        Molecule mol = this.getMol();
        if (index == -1) {
            mol = this.getPiece();
            index = 0;
        }
        boolean changed = false;
        Object object = this.getMol().getLock();
        synchronized (object) {
            MoleculeGraph umol = mol.getGraphUnion();
            MolAtom atom = index < umol.getAtomCount() ? umol.getAtom(index) : null;
            MolBond bond = index < umol.getBondCount() ? umol.getBond(index) : null;
            switch (cmd) {
                case 20: {
                    if (atom == null) break;
                    atom.set(new MolAtom(val));
                    this.ungroupSgroupOf(atom, true);
                    changed = true;
                    atom.valenceCheck();
                    break;
                }
                case 21: {
                    if (atom == null) break;
                    atom.setMassno(val & 0xFFFFEFFF);
                    atom.setSpecIsotopeSymbolPreferred((val & 0x1000) != 0);
                    this.ungroupSgroupOf(atom, true);
                    changed = true;
                    break;
                }
                case 22: {
                    if (atom == null) break;
                    atom.setCharge(val);
                    atom.valenceCheck();
                    this.ungroupSgroupOf(atom, false);
                    changed = true;
                    break;
                }
                case 23: {
                    if (atom == null) break;
                    atom.setRadical(val);
                    atom.valenceCheck();
                    this.ungroupSgroupOf(atom, true);
                    changed = true;
                    break;
                }
                case 24: {
                    if (atom == null) break;
                    int lnkmin = atom.getMinRepetitions();
                    int lnkmax = atom.getMaxRepetitions();
                    atom.clear();
                    atom.setMinRepetitions(lnkmin);
                    atom.setMaxRepetitions(lnkmax);
                    atom.setAtno(134);
                    atom.setMassno(0);
                    atom.setRgroup(val);
                    atom.valenceCheck();
                    this.ungroupSgroupOf(atom, true);
                    changed = true;
                    break;
                }
                case 25: {
                    if (atom == null || val == 0) break;
                    this.ungroupSgroupOf(atom, true);
                    changed = umol.setChirality(index, val);
                    break;
                }
                case 26: {
                    if (atom == null || atom.getAtomMap() == val) break;
                    atom.setAtomMap(val);
                    changed = true;
                    break;
                }
                case 27: {
                    this.createLinkNode(cmd, index, val);
                    changed = false;
                    break;
                }
                case 28: {
                    this.createLinkNode(cmd, index, val);
                    changed = false;
                    break;
                }
                case 31: {
                    atom.setValenceProp(val);
                    atom.valenceCheck();
                    changed = true;
                    break;
                }
                case 32: {
                    atom.setQProp("X", val);
                    atom.valenceCheck();
                    changed = true;
                    break;
                }
                case 33: {
                    atom.setQProp("D", val);
                    atom.valenceCheck();
                    changed = true;
                    break;
                }
                case 34: {
                    atom.setQProp("H", val);
                    atom.valenceCheck();
                    changed = true;
                    break;
                }
                case 35: {
                    atom.setQProp("h", val);
                    atom.valenceCheck();
                    changed = true;
                    break;
                }
                case 36: {
                    atom.setQProp("R", val);
                    atom.valenceCheck();
                    changed = true;
                    break;
                }
                case 37: {
                    atom.setQProp("r", val);
                    atom.valenceCheck();
                    changed = true;
                    break;
                }
                case 38: {
                    atom.setQProp("a", val);
                    atom.valenceCheck();
                    changed = true;
                    break;
                }
                case 39: {
                    atom.setQProp("s", val);
                    atom.valenceCheck();
                    changed = true;
                    break;
                }
                case 40: {
                    atom.setQProp("rb", val);
                    atom.valenceCheck();
                    changed = true;
                    break;
                }
                case 41: {
                    atom.setQProp("u", val);
                    atom.valenceCheck();
                    changed = true;
                    break;
                }
                case 42: {
                    if (bond == null || bond.getFlags() == val) break;
                    this.ungroupSgroupOf(bond);
                    bond = this.setBondFlags(bond, val);
                    MolAtom a1 = bond.getAtom1();
                    MolAtom a2 = bond.getAtom2();
                    a1.valenceCheck();
                    a2.valenceCheck();
                    changed = true;
                    break;
                }
                case 29: {
                    if (atom == null || atom.getReactionStereo() == val) break;
                    this.ungroupSgroupOf(atom, true);
                    atom.setReactionStereo(val);
                    changed = true;
                    break;
                }
                case 30: {
                    if (atom == null) break;
                    int old = atom.getStereoGroupType() & 0xFFFF;
                    if (old == 2 || old == 3) {
                        old |= atom.getStereoGroupNumber() << 16;
                    }
                    if (old == val) break;
                    this.ungroupSgroupOf(atom, true);
                    int g = val & 0xFFFF;
                    atom.setStereoGroupType(g);
                    if (g == 2 || g == 3) {
                        atom.setStereoGroupNumber(val >> 16);
                    }
                    changed = true;
                }
            }
        }
        if (changed) {
            this.historize();
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean edit(int cmd) {
        MDocument doc = this.document;
        Molecule mol = this.getMol();
        boolean changed = false;
        Object object = mol.getLock();
        synchronized (object) {
            switch (cmd) {
                case 10: {
                    this.reset0();
                    return true;
                }
                case 11: {
                    this.clearCurfrag();
                    this.bondrawMode = false;
                    return true;
                }
                case 12: {
                    this.clearCurfrag();
                    this.bondrawMode = false;
                    this.edit(14);
                    this.reset0();
                    this.invokeSelectionChangedEvent();
                    return true;
                }
                case 30: {
                    changed = this.flipSelection();
                    break;
                }
                case 33: {
                    changed = this.mirrorSelection();
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 31: 
                case 32: {
                    if (!this.getSelectionDoc().isEmpty()) {
                        doc = this.getSelectionDoc();
                    }
                    if (doc.isEmpty()) break;
                    this.flip_Mirror_Structure(cmd);
                    changed = true;
                    break;
                }
                case 34: {
                    changed = this.plane3DFragment();
                    break;
                }
                case 35: {
                    changed = this.doDirectedMerge();
                    break;
                }
                case 21: {
                    doc.clear();
                    this.clearSelection();
                    this.restoreNonReactionIfPossible();
                    this.reset0();
                    this.setIdentityTransform();
                    changed = true;
                    this.invokeSelectionChangedEvent();
                    this.clearLastSelectionToPrepareHistorizing();
                    break;
                }
                case 13: {
                    this.clearSelection();
                    this.sketchMode.reset();
                    MoleculeGraph umol = mol.getGraphUnion();
                    this.getSelectionMoleculeGraph().fuse(umol);
                    List<MObject> list = doc.getAllObjects();
                    for (int i = list.size() - 1; i >= 0; --i) {
                        MObject o = list.get(i);
                        if (o instanceof MChemicalStruct) {
                            MChemicalStruct mcs = (MChemicalStruct)o;
                            if (mcs.getMoleculeGraph() == mol) continue;
                            this.getSelectionDoc().addObject(o);
                            continue;
                        }
                        this.getSelectionDoc().addObject(o);
                    }
                    this.select();
                    this.invokeSelectionChangedEvent();
                    this.setLastSelectionToPrepareHistorizing();
                    return true;
                }
                case 14: {
                    this.unselect();
                    this.select();
                    this.invokeSelectionChangedEvent();
                    this.clearLastSelectionToPrepareHistorizing();
                    return true;
                }
                case 15: {
                    MTextBox t = this.getTheSelectedMTextBox();
                    this.clearSelection();
                    this.getSelectionDoc().setObjectContainingSelection(this.getDocument().getObjectContainingSelection());
                    if (t != null) {
                        this.getSelectionDoc().addObject(t);
                    }
                    this.getDocument().selectAllObjects(false);
                    this.getSelectionDoc().selectAllObjects(true);
                    this.setLastSelectionToPrepareHistorizing();
                    return true;
                }
                case 20: {
                    if (!this.getSelectionDoc().isEmpty()) {
                        this.deleteSelection();
                        changed = true;
                    }
                    this.invokeSelectionChangedEvent();
                    this.clearLastSelectionToPrepareHistorizing();
                    break;
                }
                case 22: {
                    changed = this.callBoolean("SgroupUtil.contractAll", null);
                    break;
                }
                case 23: 
                case 24: {
                    changed = this.callBoolean("SgroupUtil.expandOrUngroupAll", new Integer(cmd));
                    break;
                }
                case 25: 
                case 26: {
                    changed = this.callBoolean("AtomMapper.mapAtoms", new Integer(cmd));
                    break;
                }
                case 27: 
                case 28: 
                case 29: {
                    changed = this.callBoolean("AtomMapper.atomMappingMethod", new Integer(cmd));
                    break;
                }
                case 36: 
                case 37: {
                    changed = this.alignObjects(cmd);
                    break;
                }
                case 38: 
                case 39: {
                    changed = this.distributeObjects(cmd);
                    break;
                }
                case 40: 
                case 41: {
                    changed = this.alignAndDistributeObjects(cmd);
                }
            }
        }
        if (changed) {
            this.historize();
        }
        return changed;
    }

    private void flip_Mirror_Structure(int cmd) {
        MDocument doc = this.document;
        if (!this.getSelectionDoc().isEmpty()) {
            doc = this.getSelectionDoc();
        }
        if (!doc.isEmpty()) {
            CTransform3D tr = this.getPainter().getRTransform();
            CTransform3D t = new CTransform3D();
            MoleculeGraph molg = doc.getMainMoleculeGraph();
            MoleculeGraph umol = molg.getGraphUnion();
            CTransform3D flip = new CTransform3D();
            if (cmd == 16) {
                flip.m00 = -1.0;
                flip.m22 = -1.0;
            } else if (cmd == 17) {
                flip.m11 = -1.0;
                flip.m22 = -1.0;
            } else if (cmd == 31) {
                flip.m00 = -1.0;
                flip.m11 = -1.0;
            } else if (cmd == 18) {
                flip.m00 = -1.0;
            } else if (cmd == 19) {
                flip.m11 = -1.0;
            } else if (cmd == 32) {
                flip.m22 = -1.0;
            }
            List<MolAtom> atoms = this.getStructureJoinAtoms(doc);
            int na = atoms.size();
            if (na != 1) {
                int fragC = umol.getFragCount(1);
                for (int i = 0; i < fragC; ++i) {
                    SelectionMolecule frag = new SelectionMolecule();
                    umol.findFragById(i, 1, frag);
                    DPoint3 o = frag.calcCenter();
                    tr.transform(o);
                    t.setIdentity();
                    t.setTranslation(-o.x, -o.y, -o.z);
                    CTransform3D flipi = new CTransform3D();
                    flipi.set(flip);
                    flipi.setTranslation(o);
                    flipi.mul(t);
                    flipi.mul(this.getPainter().getRTransformRef());
                    this.getPainter().getInvRTransform(t);
                    t.mul(flipi);
                    ((MoleculeGraph)frag).transform(t);
                }
            } else {
                DPoint3 o = atoms.get(0).getLocation();
                tr.transform(o);
                t.setTranslation(-o.x, -o.y, -o.z);
                flip.setTranslation(o);
                flip.mul(t);
                flip.mul(this.getPainter().getRTransformRef());
                this.getPainter().getInvRTransform(t);
                t.mul(flip);
                doc.transform(t);
            }
        }
    }

    private void deleteSelection() {
        int i;
        long rxnid;
        RxnMolecule rxn = RxnMolecule.getReaction(this.getMol());
        ArrayList<Molecule> conncomps = new ArrayList<Molecule>();
        SelectionMolecule s = this.getSelectionMolecule();
        for (int j = s.getAtomCount() - 1; j >= 0; --j) {
            Molecule m;
            MolAtom a = s.getAtom(j);
            this.removeBrokenSgroup(a);
            this.ungroupSgroupOf(a, true);
            this.updateAttachmentPointOrder(a);
            this.removeAtom(this.document, a);
            if (rxn == null || (rxnid = rxn.getComponentID(a)) == -1L || conncomps.contains(m = rxn.getComponent(rxnid))) continue;
            conncomps.add(m);
        }
        s.removeAll();
        for (i = this.getSelectionDoc().getObjectCount() - 1; i >= 0; --i) {
            MObject o = this.getSelectionDoc().getObject(i);
            if (o instanceof MChemicalStruct) continue;
            this.removeObject(this.document, o);
        }
        for (i = conncomps.size() - 1; i >= 0 && rxn != null; --i) {
            Molecule m = (Molecule)conncomps.get(i);
            rxnid = rxn.getComponentID(m);
            if (rxnid == -1L) continue;
            rxn.splitDisconnectedComponent(rxnid);
        }
        this.restoreNonReactionIfPossible();
        this.rebuildReaction();
        if (this.document.isEmpty()) {
            this.setIdentityTransform();
        }
        this.reset0();
    }

    public void updateAttachmentPointOrder(MolAtom a) {
        if (a.getRgroupAttachmentPointOrder() > 0 && a.getParent() != null && a.getParent().isMolecule()) {
            int order = a.getRgroupAttachmentPointOrder();
            IteratorFactory factory = new IteratorFactory((Molecule)a.getParent()){

                @Override
                public boolean isExcludedAtom(MolAtom atom) {
                    return atom.getAtno() != 138 && atom.getRgroupAttachmentPointOrder() == 0;
                }
            };
            IteratorFactory.AtomIterator iterator = factory.createAtomIterator();
            while (iterator.hasNext()) {
                MolAtom atom = iterator.next();
                if (atom.getRgroupAttachmentPointOrder() <= order) continue;
                atom.setRgroupAttachmentPointOrder(atom.getRgroupAttachmentPointOrder() - 1);
            }
        }
    }

    private void updateAtomObjects(MolAtom a, MDocument doc) {
        for (int i = doc.getObjectCount() - 1; i >= 0; --i) {
            MObject o = doc.getObject(i);
            if (!o.containsAtom(a) || !(o instanceof MAssigner)) continue;
            this.updateObjects(o, doc);
        }
    }

    private void updateObjects(MObject obj, MDocument doc) {
        if (obj instanceof MAssigner) {
            for (MObject object : doc.getAllObjects()) {
                MAssigner assigner;
                if (!(object instanceof MAssigner) || (assigner = (MAssigner)object) == obj || assigner.getOrder() <= 1 || assigner.getOrder() <= ((MAssigner)obj).getOrder()) continue;
                assigner.setOrder(assigner.getOrder() - 1);
            }
        }
    }

    public void removeAtom(MDocument doc, MolAtom atom) {
        this.updateAtomObjects(atom, doc);
        doc.removeAtom(atom);
    }

    public void removeObject(MDocument doc, MObject o) {
        MObject co;
        MObject obj = o;
        if (o.isInternalSelectable() && (!(co = this.getContainerMObject(o)).getClass().getName().contains("MPolyline") || ((MPolyline)co).isArrow())) {
            obj = co;
        }
        Sgroup sg = null;
        if (obj instanceof MBracket) {
            sg = this.findContainingSgroup((MBracket)obj);
        }
        doc.removeObject(obj);
        this.getSelectionDoc().removeObject(obj);
        this.updateObjects(obj, doc);
        if (sg != null) {
            if (sg.getType() == 2) {
                ((RepeatingUnitSgroup)sg).removeStarAtoms();
            }
            for (int i = 0; i < sg.getChildSgroupCount(); ++i) {
                if (sg.getChildSgroup(i).getType() != 10 || !sg.getChildSgroup(i).isEmpty()) continue;
                this.getMol().ungroupSgroup(sg.getChildSgroup(i), 0);
            }
            this.getMol().ungroupSgroup(sg, 0);
        }
        if (RxnMolecule.getReaction(this.getMol()) != null && obj instanceof MRArrow) {
            this.restoreNonReactionIfPossible();
            this.rebuildReaction();
            this.simplifyToMolecule();
        }
    }

    public void removeBrokenSgroup(MolAtom a) {
        MoleculeGraph cg = a.getParent();
        if (cg != null && cg instanceof Molecule) {
            Molecule mol = (Molecule)cg;
            if (a.getAtno() == 137) {
                MulticenterSgroup sg = mol.findContainingMulticenterSgroup(a);
                mol.ungroupSgroup(sg);
            } else {
                Sgroup sg = mol.findSmallestSgroupContaining(a);
                if (sg instanceof MulticenterSgroup && sg.getAtomCount() == 1) {
                    mol.ungroupSgroup(sg);
                }
            }
        }
    }

    public boolean hasMappedAtom() {
        boolean enable = false;
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        Molecule m = sel != null && !sel.isEmpty() ? sel : this.getMol();
        for (int i = 0; !enable && i < m.getAtomCount(); ++i) {
            if (m.getAtom(i).getAtomMap() <= 0) continue;
            enable = true;
        }
        return enable;
    }

    public boolean hasContractableOrExpandableSgroup(boolean contract) {
        boolean enable = false;
        Molecule mol = this.getMol();
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        if (mol.getSgroupCount() != 0) {
            if (sel.isEmpty()) {
                boolean cg = mol.findExpandableSgroup() != null;
                boolean xg = mol.findContractableSgroup() != null;
                enable = cg && !contract || xg && contract;
            } else {
                boolean cg = false;
                boolean xg = false;
                for (int j = 0; j < sel.getAtomCount(); ++j) {
                    MolAtom a = sel.getAtom(j);
                    if (a instanceof SgroupAtom) {
                        cg = true;
                        continue;
                    }
                    Sgroup g = mol.findSgroupContaining(a);
                    if (g == null) continue;
                    if (g instanceof Expandable) {
                        cg |= !((Expandable)((Object)g)).isExpanded();
                    }
                    if (!(g instanceof Expandable)) continue;
                    xg |= ((Expandable)((Object)g)).isExpanded();
                }
                enable = cg && !contract || xg && contract;
            }
        }
        return enable;
    }

    public boolean hasUngroupableGroup() {
        Set<MolAtom> set = this.getSetOfAllOrSelectedAtoms();
        return this.hasUngroupableGroup(set);
    }

    public boolean hasUngroupableGroup(Set<MolAtom> atoms) {
        Molecule mol = this.getMol();
        if (mol instanceof RgMolecule && ((RgMolecule)mol).hasRgroupContainedBy(atoms)) {
            return true;
        }
        for (MolAtom a : atoms) {
            if (a instanceof SgroupAtom) {
                return true;
            }
            Sgroup sg = mol.findSgroupContaining(a);
            if (sg == null || sg instanceof DataSgroup || sg instanceof MulticenterSgroup) continue;
            return true;
        }
        return false;
    }

    private ArrayList<MBracket> getBrackets() {
        List<MObject> list = this.getSelectionDoc().getAllObjects();
        ArrayList<MBracket> bcList = new ArrayList<MBracket>();
        if (list.size() != 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof MBracket) || ((MBracket)list.get(i)).getBracketOrientation() != 4) continue;
                bcList.add((MBracket)list.get(i));
            }
        }
        return bcList;
    }

    public boolean isBracketMergePossible() {
        Sgroup sg2;
        ArrayList<MBracket> bcList = this.getBrackets();
        if (bcList.size() != 2) {
            return false;
        }
        Sgroup sg1 = this.findContainingSgroup(bcList.get(0));
        return sg1 == (sg2 = this.findContainingSgroup(bcList.get(1))) && sg1.getType() == 2;
    }

    public Sgroup findContainingSgroup(MBracket connectedObject) {
        if (connectedObject == null) {
            return null;
        }
        Molecule mol = this.getMol();
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            Sgroup sg = mol.getSgroup(i);
            ArrayList<MBracket> brackets = sg.getBrackets();
            if (brackets == null) continue;
            for (int j = 0; j < brackets.size(); ++j) {
                if (!brackets.get(j).equals(connectedObject)) continue;
                return sg;
            }
        }
        return null;
    }

    public Sgroup findContainingSgroup(MolAtom[] atoms) {
        Molecule mol = this.getMol();
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            Sgroup sg = mol.getSgroup(i);
            if (sg.getAtomCount() != atoms.length) continue;
            boolean contains = true;
            for (int j = 0; j < atoms.length && contains; contains &= sg.indexOf(atoms[j]) >= 0, ++j) {
            }
            if (!contains) continue;
            return sg;
        }
        return null;
    }

    private boolean isMulticenterCreationPossible() {
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        int n = sel.getAtomCount();
        MoleculeGraph commonParent = sel.getAtom(0).getParent();
        for (int j = 1; j < n; ++j) {
            if (sel.getAtom(j).getParent() == commonParent) continue;
            return false;
        }
        return true;
    }

    public Object getDataSgroupObject(Object object) {
        MSelectionDocument selection;
        Serializable selobject = null;
        MSelectionDocument mSelectionDocument = selection = object instanceof MSelectionDocument ? (MSelectionDocument)object : null;
        if (selection.getObjectCount() == 2) {
            if (selection.getObject(1) instanceof MBracket && selection.getMainMoleculeGraph().getAtomCount() == 0 && this.findContainingSgroup((MBracket)selection.getObject(1)) != null) {
                selobject = selection.getObject(1);
            } else if (selection.getObject(1) instanceof MRectanglePoint) {
                selobject = ((MRectanglePoint)selection.getObject(1)).getParentRect();
            }
        } else if (selection.getObjectCount() == 1) {
            if (selection.getMainMoleculeGraph().getAtomCount() == 1) {
                selobject = selection.getMainMoleculeGraph().getAtom(0);
            } else if (selection.getMainMoleculeGraph().getBondCount() == 1) {
                selobject = selection.getMainMoleculeGraph().getBond(0);
            }
        }
        return selobject;
    }

    public boolean isDataSgroupCreationPossible(MSelectionDocument selection) {
        Object selobject = this.getDataSgroupObject(selection);
        if (selection == this.getSelectionDocument() && selobject == null) {
            return true;
        }
        return selobject instanceof MBracket || selobject instanceof MRectanglePoint || selobject instanceof MolAtom || selobject instanceof MolBond;
    }

    public boolean isAutoAtomMappingPossible() {
        return true;
    }

    public boolean hasDataSgroup() {
        DataSgroup dsg = this.getCurrentDataSgroup();
        return dsg != null;
    }

    public DataSgroup getCurrentDataSgroup() {
        DataSgroup result = this.getSelectedDataSgroup();
        if (result == null) {
            result = this.getPointedDataSgroup();
        }
        return result;
    }

    public DataSgroup getPointedDataSgroup() {
        Molecule mol = this.getMol();
        DPoint3 pointerPos = this.getPointerPos();
        Sgroup s = this.findSgroupAt(pointerPos.x, pointerPos.y);
        if (s instanceof DataSgroup) {
            return (DataSgroup)s;
        }
        PointedObject po = this.getPointedObject();
        if (po instanceof AtomPO) {
            AtomPO apo = (AtomPO)po;
            MolAtom ma = apo.getAtom();
            DataSgroup dsg = this.getDataSgroupOfAtom(ma, mol);
            if (dsg != null) {
                return dsg;
            }
        } else if (po instanceof SgroupPO) {
            SgroupPO sgpo = (SgroupPO)po;
            if (sgpo.getSgroup() instanceof DataSgroup) {
                return (DataSgroup)sgpo.getSgroup();
            }
        } else if (po instanceof BondPO) {
            BondPO bpo = (BondPO)po;
            DataSgroup dsg = this.getDataSgroupOfAtom(bpo.getBond().getAtom1(), mol);
            if (dsg != null) {
                return dsg;
            }
            dsg = this.getDataSgroupOfAtom(bpo.getBond().getAtom2(), mol);
            if (dsg != null) {
                return dsg;
            }
        }
        return null;
    }

    public DataSgroup getSelectedDataSgroup() {
        Molecule mol = this.getMol();
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        for (int j = 0; j < sel.getAtomCount(); ++j) {
            DataSgroup dsg = this.getDataSgroupOfAtom(sel.getAtom(j), mol);
            if (dsg == null) continue;
            return dsg;
        }
        return null;
    }

    private DataSgroup getDataSgroupOfAtom(MolAtom a, Molecule mol) {
        if (!(a instanceof SgroupAtom)) {
            for (int i = 0; i < mol.getSgroupCount(); ++i) {
                Sgroup sgroup = mol.getSgroup(i);
                if (!(sgroup instanceof DataSgroup) || sgroup.indexOf(a) == -1) continue;
                return (DataSgroup)sgroup;
            }
        }
        return null;
    }

    public boolean isLinkNodeCreationPossible() {
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        int n = sel.getAtomCount();
        return (n == 1 || n == 3) && sel.getFragCount(1) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean edit(int cmd, boolean arg) {
        Molecule mol = this.getMol();
        switch (cmd) {
            case 10: {
                this.sketchMode.buttonUp(0, arg);
                this.dragged = false;
                this.mouseInside = true;
                if (!arg) {
                    MDocument doc = this.history.getDocument().cloneDocument();
                    this.setDocument(doc, false);
                    this.sketchMode.reset();
                }
                return true;
            }
            case 11: {
                try {
                    Object doc = mol.getLock();
                    synchronized (doc) {
                        if (!this.hydrogenize(arg)) {
                            return false;
                        }
                        break;
                    }
                }
                catch (Throwable ex) {
                    this.internalError(ex);
                    return false;
                }
            }
            case 12: {
                try {
                    Object ex = mol.getLock();
                    synchronized (ex) {
                        MoleculeGraph m = mol;
                        if (this.hasSelection()) {
                            m = this.getSelectionMolecule();
                        }
                        int na = m.getAtomCount();
                        if (arg) {
                            Hydrogenize.addLonePairs(m, null);
                        } else {
                            Hydrogenize.removeLonePairs(m);
                        }
                        if (m.getAtomCount() == na) {
                            return false;
                        }
                        break;
                    }
                }
                catch (Throwable ex) {
                    this.internalError(ex);
                    return false;
                }
            }
            case 13: {
                Object object = mol.getLock();
                synchronized (object) {
                    this.setAbsStereo(mol, arg);
                    this.setToAlignNameTextBox();
                    break;
                }
            }
            case 14: {
                Object object = mol.getLock();
                synchronized (object) {
                    if (this.invertSelection(arg)) {
                        return false;
                    }
                    break;
                }
            }
            default: {
                return false;
            }
        }
        this.historize();
        return true;
    }

    private void setAbsStereo(Molecule mol, boolean abs) {
        SelectionMolecule sel = this.getSelectionMolecule();
        if (sel.isEmpty()) {
            mol.setAbsStereo(abs);
        } else {
            this.setAbsStereoInSelection(mol, sel, abs);
        }
    }

    public boolean canSetAbsStereo(boolean abs) {
        Molecule mol = this.getMol();
        SelectionMolecule sel = this.getSelectionMolecule();
        return this.canSetAbsStereoInSelection(mol, sel.isEmpty() ? null : sel, abs);
    }

    private void setAbsStereoInSelection(Molecule mol, SelectionMolecule sel, boolean abs) {
        RgMoleculeGraphIface rgmol;
        RxnMolecule rxmol = RxnMolecule.getReaction(mol);
        RgMoleculeGraphIface rgMoleculeGraphIface = rgmol = mol instanceof RgMoleculeGraphIface ? (RgMoleculeGraphIface)((Object)mol) : null;
        if (rgmol != null && rgmol.getRgroupCount() > 0) {
            MoleculeGraph rootmol = rgmol.getRootG();
            if (rxmol != null) {
                this.setAbsStereoForReactionComponent(rxmol, sel, abs);
            } else if (sel.contains(rootmol)) {
                rootmol.setAbsStereo(abs);
            }
            int n = rgmol.getRgroupCount();
            for (int i = 0; i < n; ++i) {
                int k = rgmol.getRgroupMemberCount(i);
                for (int j = 0; j < k; ++j) {
                    MoleculeGraph rgroup = rgmol.getRgroupMemberG(i, j);
                    if (!sel.contains(rgroup)) continue;
                    rgroup.setAbsStereo(abs);
                }
            }
        } else if (rxmol != null) {
            this.setAbsStereoForReactionComponent(rxmol, sel, abs);
        } else if (sel.contains(mol)) {
            mol.setAbsStereo(abs);
        }
    }

    private boolean canSetAbsStereoInSelection(Molecule mol, SelectionMolecule sel, boolean abs) {
        RgMoleculeGraphIface rgmol;
        RxnMolecule rxmol = RxnMolecule.getReaction(mol);
        RgMoleculeGraphIface rgMoleculeGraphIface = rgmol = mol instanceof RgMoleculeGraphIface ? (RgMoleculeGraphIface)((Object)mol) : null;
        if (rgmol != null && rgmol.getRgroupCount() > 0) {
            MoleculeGraph rootmol = rgmol.getRootG();
            if (rxmol != null ? this.canSetAbsStereoForReactionComponent(rxmol, sel, abs) : (sel == null || sel.contains(rootmol)) && rootmol.isAbsStereo() != abs) {
                return true;
            }
            int n = rgmol.getRgroupCount();
            for (int i = 0; i < n; ++i) {
                int k = rgmol.getRgroupMemberCount(i);
                for (int j = 0; j < k; ++j) {
                    MoleculeGraph rgroup = rgmol.getRgroupMemberG(i, j);
                    if (sel != null && !sel.contains(rgroup) || rgroup.isAbsStereo() == abs) continue;
                    return true;
                }
            }
            return false;
        }
        if (rxmol != null) {
            return this.canSetAbsStereoForReactionComponent(rxmol, sel, abs);
        }
        if (sel == null || sel.contains(mol)) {
            return mol.isAbsStereo() != abs;
        }
        return false;
    }

    private void setAbsStereoForReactionComponent(RxnMolecule rxmol, SelectionMolecule sel, boolean abs) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < rxmol.getComponentCount(i); ++j) {
                Molecule m = rxmol.getComponent(i, j);
                if (!sel.contains(m)) continue;
                m.setAbsStereo(abs);
            }
        }
    }

    private boolean canSetAbsStereoForReactionComponent(RxnMolecule rxmol, SelectionMolecule sel, boolean abs) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < rxmol.getComponentCount(i); ++j) {
                Molecule m = rxmol.getComponent(i, j);
                if (sel != null && !sel.contains(m) || m.isAbsStereo() == abs) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hydrogenize(boolean arg) {
        Molecule m = this.getMol();
        MolAtom[] atoms = null;
        if (this.hasSelection()) {
            atoms = new MolAtom[this.getSelectionMolecule().getAtomCount()];
            int j = 0;
            for (int i = 0; i < m.getAtomCount(); ++i) {
                if (!m.getAtom(i).isSelected()) continue;
                atoms[j] = m.getAtom(i);
                ++j;
            }
        } else if (this.piece != null) {
            if (arg) {
                Hydrogenize.addHAtoms(this.piece);
            } else {
                Hydrogenize.removeHAtoms(this.piece);
            }
        }
        boolean success = arg ? Hydrogenize.addHAtoms(m, atoms) : Hydrogenize.removeHAtoms(m, atoms, 33);
        m.valenceCheck();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean edit(int cmd, int arg) {
        Molecule mol = this.getMol();
        MoleculeGraph umol = mol.getGraphUnion();
        Object molLock = mol.getLock();
        switch (cmd) {
            case 10: {
                MolAtom a = umol.getAtom(arg);
                this.ungroupSgroupOf(a, true);
                if (this.callBoolean("AtomActions.remove", a)) break;
                return false;
            }
            case 11: {
                Object a = molLock;
                synchronized (a) {
                    this.removeBond(umol, arg);
                    break;
                }
            }
            case 12: {
                MolAtom a = umol.getAtom(arg);
                this.ungroupSgroupOfAPO(a, true);
                this.changeAttach(arg);
                break;
            }
            case 13: {
                this.alignToBond(arg, false);
                break;
            }
            case 14: {
                this.alignToBond(arg, true);
                break;
            }
            case 15: {
                this.rxnGroupFrags(arg, true);
                break;
            }
            case 23: {
                this.rxnGroupFrags(arg, false);
                break;
            }
            case 16: {
                if (this.branch(umol.getAtom(arg)) == 0) return false;
                return true;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                if (this.callBoolean("SgroupUtil.editSgroup", new int[]{cmd, arg})) break;
                return false;
            }
            case 21: 
            case 22: {
                try {
                    Object a = mol.getLock();
                    synchronized (a) {
                        MoleculeGraph m = mol;
                        if (this.hasSelection()) {
                            m = this.getSelectionMolecule();
                        }
                        if (cmd == 21) {
                            m.aromatize(arg);
                        } else {
                            m.aromatize(false);
                        }
                        break;
                    }
                }
                catch (Throwable ex) {
                    this.internalError(ex);
                    return false;
                }
            }
            default: {
                return false;
            }
        }
        this.historize();
        return true;
    }

    private void removeBond(MoleculeGraph umol, int arg) {
        MolBond b = umol.getBond(arg);
        RxnMolecule rxn = RxnMolecule.getReaction(this.getMol());
        long rxnid = -1L;
        if (rxn != null) {
            rxnid = rxn.getComponentID(b);
        }
        this.ungroupSgroupOf(b);
        this.getSelectionMoleculeGraph().removeBond(b);
        this.getMol().removeBond(b);
        if (rxnid != -1L && rxn != null) {
            rxn.splitDisconnectedComponent(rxnid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rxnGroupFrags(int type, boolean merge) {
        Molecule mol = this.getMol();
        Object object = mol.getLock();
        synchronized (object) {
            RxnMolecule rxmol = RxnMolecule.getReaction(mol);
            if (rxmol != null) {
                MoleculeGraph sel = this.getSelectionMoleculeGraph();
                if (merge) {
                    rxmol.mergeComponentParts(sel, type, true);
                } else {
                    rxmol.splitComponentParts(sel, type);
                }
                if (mol instanceof RgMolecule) {
                    ((RgMolecule)mol).setRoot(rxmol);
                }
                sel.removeAll();
            }
        }
    }

    private void changeAttach(int atomIndex) {
        int i;
        Molecule mol = this.getMol();
        MoleculeGraph umol = mol.getGraphUnion();
        int[] fragIds = umol.getFragIds(1);
        int fragId = fragIds[atomIndex];
        MolAtom atom = umol.getAtom(atomIndex);
        Sgroup psg = mol.findSgroupContaining(atom);
        int apo = atom.getAttach();
        ArrayList<MolAtom> tocheck = new ArrayList<MolAtom>();
        tocheck.add(atom);
        if (apo != 0) {
            apo = apo == 1 ? 3 : 0;
            atom.setAttach(apo, psg);
            for (i = fragIds.length - 1; i >= 0; --i) {
                if (fragIds[i] != fragId || i == atomIndex) continue;
                psg = mol.findSgroupContaining(atom);
                MolAtom a = umol.getAtom(i);
                int aapo = a.getAttach();
                if (aapo <= 0) continue;
                if (apo == 0) {
                    if (aapo == 2) {
                        aapo = 1;
                    }
                } else {
                    aapo = 0;
                }
                a.setAttach(aapo, psg);
                tocheck.add(a);
            }
        } else {
            MolAtom h;
            int max = 0;
            MolAtom amax = null;
            for (int i2 = fragIds.length - 1; i2 >= 0; --i2) {
                MolAtom a;
                if (fragIds[i2] != fragId || i2 == atomIndex || (apo = (a = umol.getAtom(i2)).getAttach()) <= max) continue;
                max = apo;
                amax = a;
            }
            if (atom.getImplicitHcount() == 0 && (h = MolEditor.getHLigand(atom)) != null) {
                mol.removeAtom(h);
            }
            if (max < 2) {
                atom.setAttach(max + 1, psg);
            } else if (amax != null) {
                amax.setAttach(0);
                atom.setAttach(max == 2 ? 2 : 1, psg);
                tocheck.add(amax);
            }
        }
        atom.setImplicitHcount(0);
        for (i = 0; i < tocheck.size(); ++i) {
            ((MolAtom)tocheck.get(i)).valenceCheck();
        }
    }

    private static MolAtom getHLigand(MolAtom a) {
        for (int i = a.getBondCount() - 1; i >= 0; --i) {
            MolAtom h = a.getLigand(i);
            if (!h.isImplicitizableH(0)) continue;
            return h;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alignToBond(int bondIndex, boolean vertical) {
        Molecule mol = this.getMol();
        MoleculeGraph umol = mol.getGraphUnion();
        Object object = umol.getLock();
        synchronized (object) {
            double sf;
            double cf;
            MoleculeGraph sel = this.getSelectionMoleculeGraph();
            MolBond bond = umol.getBond(bondIndex);
            MolAtom a1 = bond.getAtom1();
            MolAtom a2 = bond.getAtom2();
            SelectionMolecule frag = new SelectionMolecule();
            umol.findFrag(umol.indexOf(a1), 1, frag);
            for (int i = sel.getAtomCount() - 1; i >= 0; --i) {
                MolAtom a = sel.getAtom(i);
                umol.findFrag(umol.indexOf(a), 1, frag);
            }
            DPoint3 p1 = a1.getLocation();
            DPoint3 p2 = a2.getLocation();
            CTransform3D tinv = this.getPainter().getRTransform();
            tinv.transform(p1);
            tinv.transform(p2);
            DPoint3 o = new DPoint3((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0, (p1.z + p2.z) / 2.0);
            double dx = p2.x - p1.x;
            double dy = p2.y - p1.y;
            if (vertical) {
                if (dy > 0.0) {
                    cf = dy;
                    sf = dx;
                } else {
                    cf = -dy;
                    sf = -dx;
                }
            } else if (dx > 0.0) {
                cf = dx;
                sf = -dy;
            } else {
                cf = -dx;
                sf = dy;
            }
            double phi = Math.atan2(sf, cf);
            CTransform3D T = new CTransform3D();
            T.setRotation(0.0, 0.0, 1.0, phi);
            T.setRotationCenter(o);
            CTransform3D t2 = this.getPainter().getInvRTransform();
            t2.mul(T);
            t2.mul(this.getPainter().getRTransformRef());
            frag.transform(t2);
        }
    }

    public synchronized void edit(int cmd, double arg) {
        switch (cmd) {
            case 10: {
                this.atomSize = arg;
                break;
            }
            case 11: {
                this.bondSpacing = arg;
                break;
            }
            case 12: {
                this.mergedst = arg;
                break;
            }
            case 13: {
                this.stickdst = arg;
            }
        }
    }

    private void extendMolGraph(MoleculeGraph molGraph, Molecule molecule) {
        MoleculeGraph umol = molecule.getGraphUnion();
        for (int i = 0; i < molGraph.getAtomCount(); ++i) {
            umol.findFrag(umol.indexOf(molGraph.getAtom(i)), 1, molGraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean edit(int cmd, String arg) {
        RxnMolecule rxnMol;
        Molecule mol = this.getMol();
        Object molLock = mol.getLock();
        int type = -1;
        if (cmd == 11 || cmd >= 15 && cmd <= 31) {
            type = Integer.valueOf(arg.substring(0, 1));
            arg = arg.substring(1);
        }
        if ((rxnMol = RxnMolecule.getReaction(mol)) != null) {
            MoleculeGraph sel = this.getSelectionMoleculeGraph();
            int componentType = rxnMol.getType(sel);
            if (componentType == -1) {
                return false;
            }
            rxnMol.mergeComponentParts(sel, componentType, false);
        }
        switch (cmd) {
            case 10: {
                Object object = molLock;
                synchronized (object) {
                    this.createSuperatomSgroup(arg);
                }
                return true;
            }
            case 11: {
                Object object = molLock;
                synchronized (object) {
                    this.createMultipleSgroup(arg, type);
                }
                return true;
            }
            case 12: {
                Object object = molLock;
                synchronized (object) {
                    this.createDataSgroup(arg);
                }
                return true;
            }
            case 13: 
            case 32: {
                Object object = molLock;
                synchronized (object) {
                    return this.attachData(arg, cmd);
                }
            }
            case 14: {
                Object object = molLock;
                synchronized (object) {
                    return this.createRgroup(arg);
                }
            }
            case 15: {
                Object object = molLock;
                synchronized (object) {
                    this.createComponentSgroup(13, arg, true, type);
                }
                return true;
            }
            case 16: {
                Object object = molLock;
                synchronized (object) {
                    this.createComponentSgroup(8, arg, false, type);
                }
                return true;
            }
            case 17: {
                Object object = molLock;
                synchronized (object) {
                    this.createComponentSgroup(9, arg, false, type);
                }
                return true;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                Object object = molLock;
                synchronized (object) {
                    this.createPolymerSgroup(arg, cmd, type);
                }
                return true;
            }
            case 26: 
            case 28: 
            case 30: {
                Object object = molLock;
                synchronized (object) {
                    this.createSimpleSgroup(arg, cmd, type);
                }
                return true;
            }
        }
        return false;
    }

    private boolean createRgroup(String arg) {
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        Molecule p = (Molecule)sel.getAtom(0).getParent();
        this.extendMolGraph(sel, p);
        MolAtom a = new MolAtom(134);
        int rgid = 0;
        if (!arg.equals("R")) {
            String s = arg.startsWith("R") ? arg.substring(1) : arg;
            rgid = Integer.parseInt(s);
        }
        a.setRgroup(rgid);
        Molecule m = new Molecule(null, a);
        boolean changed = this.callBoolean("ChangeSelection.changeSelection", m);
        if (changed) {
            this.unselect();
            this.historize();
        }
        return changed;
    }

    private void createSuperatomSgroup(String arg) {
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        Molecule p = (Molecule)sel.getAtom(0).getParent();
        SuperatomSgroup sg = new SuperatomSgroup(p);
        this.addToSgroupHierarchy(p, sg, null);
        sg.setSubscript(arg);
        for (int i = 0; i < sel.getAtomCount(); ++i) {
            MolAtom a = sel.getAtom(i);
            p.setSgroupParent(a, sg, true);
        }
        this.setAttachmentPoints(sg);
        this.unselect();
        this.historize();
    }

    private void setAttachmentPoints(SuperatomSgroup sg) {
        ArrayList<MolAtom> attaches = new ArrayList<MolAtom>();
        for (int i = 0; i < sg.getAtomCount(); ++i) {
            if (sg.getAtom(i).getAttach() == 0) continue;
            attaches.add(sg.getAtom(i));
        }
        if (attaches.size() == 0) {
            MolBond[] bonds = sg.findCrossingBonds();
            MolAtom[] atoms = sg.getCrossingAtoms(bonds);
            if (bonds.length == 2 && atoms.length == 2) {
                if (atoms[0] == atoms[1]) {
                    atoms[0].setAttach(3, sg);
                } else {
                    atoms[0].setAttach(1, sg);
                    atoms[1].setAttach(2, sg);
                    sg.sortXBonds();
                }
            }
        }
    }

    private void createMultipleSgroup(String arg, int type) {
        MolAtom a;
        int i;
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        Molecule p = (Molecule)sel.getAtom(0).getParent();
        SgroupUpdate.extendSgroupSelectionToSubgraph(sel, this.getSelectionDoc(), p);
        MultipleSgroup sg = new MultipleSgroup(p, false);
        this.addToSgroupHierarchy(p, sg, null);
        sg.setSubscript(arg);
        for (i = 0; i < sel.getAtomCount(); ++i) {
            a = sel.getAtom(i);
            p.setSgroupParent(a, sg, true);
        }
        for (i = 0; i < sel.getAtomCount(); ++i) {
            a = sel.getAtom(i);
            sg.setRepeatingUnitAtom(a, true);
        }
        CleanUtil.generateBracketCoords(sg, type, !this.getPainter().getCommon().getImplicitH().equals("off"));
        this.unselect();
        this.historize();
    }

    private void createSimpleSgroup(String arg, int cmd, int type) {
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        Molecule p = (Molecule)sel.getAtom(0).getParent();
        if (cmd == 28 || cmd == 30) {
            SgroupUpdate.extendSgroupSelectionToWholeFragments(sel, this.getSelectionDoc(), p);
        } else if (cmd == 26) {
            SgroupUpdate.extendSgroupSelectionToSubgraph(sel, this.getSelectionDoc(), p);
        }
        Sgroup sg = new Sgroup(p, MolEditor.getSgroupType(cmd));
        this.addToSgroupHierarchy(p, sg, null);
        for (int i = 0; i < sel.getAtomCount(); ++i) {
            MolAtom a = sel.getAtom(i);
            p.setSgroupParent(a, sg, true);
        }
        CleanUtil.generateBracketCoords(sg, type, !this.getPainter().getCommon().getImplicitH().equals("off"));
        sg.setChargeLocation(Integer.valueOf(arg.substring(arg.length() - 1, arg.length())));
        this.unselect();
        this.historize();
    }

    private void createPolymerSgroup(String arg, int cmd, int type) {
        double[] rectangle;
        int lenght = arg.length();
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        Molecule p = (Molecule)sel.getAtom(0).getParent();
        String connectivity = arg.substring(0, 3);
        RepeatingUnitSgroup sg = new RepeatingUnitSgroup(p, connectivity, MolEditor.getSgroupType(cmd));
        this.addToSgroupHierarchy(p, sg, null);
        if (cmd == 28 || cmd == 30) {
            sg.setSubscript(arg.substring(3, lenght - 1));
        } else {
            sg.setSubscript(arg.substring(3));
        }
        for (int i = 0; i < sel.getAtomCount(); ++i) {
            MolAtom a = sel.getAtom(i);
            p.setSgroupParent(a, sg, true);
        }
        sg.addStarAtoms();
        sg.setSubType(this.getSgroupSubType(cmd));
        if ((cmd == 31 || cmd == 19) && (rectangle = this.sketchMode.getSelectUtil().getMolSelRect()) != null) {
            MolBond[] head = GeomUtil.getCrossingBonds(sg.findCrossingBonds(), new DPoint3(rectangle[0], rectangle[1], 0.0), new DPoint3(rectangle[0], rectangle[1] + rectangle[3], 0.0), true);
            MolBond[] tail = GeomUtil.getCrossingBonds(sg.findCrossingBonds(), new DPoint3(rectangle[0] + rectangle[2], rectangle[1], 0.0), new DPoint3(rectangle[0] + rectangle[2], rectangle[1] + rectangle[3], 0.0), true);
            if (head.length == 2 && tail.length == 2) {
                sg.mergeBrackets(head[0], head[1]);
                sg.mergeBrackets(tail[0], tail[1]);
            }
        }
        CleanUtil.generateBracketCoords(sg, type, !this.getPainter().getCommon().getImplicitH().equals("off"));
        if (cmd == 28 || cmd == 30) {
            sg.setChargeLocation(Integer.valueOf(arg.substring(lenght - 1, lenght)));
        }
        this.unselect();
        this.historize();
    }

    private void createDataSgroup(String arg) {
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        if (sel.getAtomCount() == 0) {
            sel = this.getMol();
        }
        if (arg.endsWith("Atom")) {
            MolAtom[] atoms = sel.getAtomArray();
            for (int i = 0; i < atoms.length; ++i) {
                SelectionMolecule mol = new SelectionMolecule();
                mol.add(atoms[i]);
                this.createSgroupForMol(arg, mol);
                sel.removeAtom(atoms[i]);
            }
        } else if (arg.endsWith("Single Bond")) {
            this.createSgroupForBonds(arg, sel, true, 1);
        } else if (arg.endsWith("Double Bond")) {
            this.createSgroupForBonds(arg, sel, true, 2);
        } else if (arg.endsWith("\u9999Bond")) {
            this.createSgroupForBonds(arg, sel, false, -1);
        } else if (arg.endsWith("Fragment")) {
            int i;
            Molecule mol = this.getMol();
            SelectionMolecule increasedSelection = new SelectionMolecule();
            MoleculeGraph[] molfrags = mol.findFrags(SelectionMolecule.class, 1);
            MoleculeGraph[] selfrags = sel.findFrags(SelectionMolecule.class, 1);
            for (i = 0; i < molfrags.length; ++i) {
                for (int j = 0; j < selfrags.length; ++j) {
                    int k;
                    MolAtom[] selFragAtoms = selfrags[j].getAtomArray();
                    if (selFragAtoms.length <= 0 || !molfrags[i].contains(selFragAtoms[0])) continue;
                    MolAtom[] atoms = molfrags[i].getAtomArray();
                    MolBond[] bonds = molfrags[i].getBondArray();
                    for (k = 0; k < atoms.length; ++k) {
                        increasedSelection.add(atoms[k]);
                    }
                    for (k = 0; k < bonds.length; ++k) {
                        increasedSelection.add(bonds[k]);
                    }
                }
            }
            selfrags = increasedSelection.findFrags(SelectionMolecule.class, 1);
            this.unselect();
            for (i = 0; i < selfrags.length; ++i) {
                int j;
                MolAtom[] atoms = selfrags[i].getAtomArray();
                MolBond[] bonds = selfrags[i].getBondArray();
                SelectionMolecule molToAddData = new SelectionMolecule();
                molToAddData.fuse(selfrags[i], false);
                this.createSgroupForMol(arg, molToAddData);
                for (j = 0; j < atoms.length; ++j) {
                    sel.removeAtom(atoms[j]);
                }
                for (j = 0; j < bonds.length; ++j) {
                    sel.removeBond(bonds[j]);
                }
            }
            sel = null;
        } else {
            this.createSgroupForMol(arg, sel);
        }
        this.unselect();
        this.historize();
    }

    private void createSgroupForBonds(String arg, MoleculeGraph sel, boolean restrict, int type) {
        int i;
        SelectionMolecule mol = new SelectionMolecule();
        mol.fuse(sel, false);
        this.unselect();
        MolBond[] bonds = mol.getBondArray();
        for (i = 0; i < bonds.length; ++i) {
            int j;
            if (!restrict || bonds[i].getType() == type) continue;
            mol.removeBond(bonds[i]);
            boolean removeable = true;
            for (j = 0; j < bonds[i].getAtom1().getBondCount() && removeable; ++j) {
                if (!mol.contains(bonds[i].getAtom1().getBond(j)) || bonds[i].getAtom1().getBond(j).getType() != type) continue;
                removeable = false;
            }
            if (removeable) {
                mol.removeAtom(bonds[i].getAtom1());
            }
            removeable = true;
            for (j = 0; j < bonds[i].getAtom2().getBondCount() && removeable; ++j) {
                if (!mol.contains(bonds[i].getAtom2().getBond(j)) || bonds[i].getAtom2().getBond(j).getType() != type) continue;
                removeable = false;
            }
            if (!removeable) continue;
            mol.removeAtom(bonds[i].getAtom2());
        }
        bonds = mol.getBondArray();
        for (i = 0; i < bonds.length; ++i) {
            if (restrict && bonds[i].getType() != type) continue;
            SelectionMolecule molToAddData = new SelectionMolecule();
            ((MoleculeGraph)molToAddData).add(bonds[i]);
            molToAddData.add(bonds[i].getAtom1());
            molToAddData.add(bonds[i].getAtom2());
            this.createSgroupForMol(arg, molToAddData);
            mol.removeBond(bonds[i]);
            mol.removeAtom(bonds[i].getAtom1());
            mol.removeAtom(bonds[i].getAtom2());
        }
    }

    private void createSgroupForMol(String arg, MoleculeGraph sel) {
        int i;
        Molecule p = (Molecule)sel.getAtom(0).getParent();
        DataSgroup sg = new DataSgroup(p);
        this.fillDataSgroupFromString(sg, arg);
        this.addToSgroupHierarchy(p, sg, sel);
        Vector<DPoint3> middles = new Vector<DPoint3>();
        for (i = 0; i < p.getSgroupCount(); ++i) {
            if (!(p.getSgroup(i) instanceof DataSgroup)) continue;
            DataSgroup dsg = (DataSgroup)p.getSgroup(i);
            DPoint3 mid = new DPoint3();
            dsg.getObjectsMiddle(mid);
            middles.add(mid);
        }
        for (i = 0; i < sel.getAtomCount(); ++i) {
            MolAtom a = sel.getAtom(i);
            p.setSgroupParent(a, sg, true);
        }
        if (sg.isDataDetached()) {
            DPoint3 middle = new DPoint3();
            sg.getObjectsMiddle(middle);
            double shift = 0.0;
            for (DPoint3 mid : middles) {
                if (!(middle.distance2D(mid) < 1.0)) continue;
                shift += 0.77;
            }
            middle.x += 0.77 + sg.getSgroupGraph().calcWidth() / 2.0;
            middle.y += 1.0 - shift;
            sg.setAbsoluteXY(middle);
        }
    }

    private boolean attachData(String arg, int cmd) {
        DataSgroup sg = this.dataSgroupObject;
        DPoint3 origPosition = null;
        boolean changed = this.fillDataSgroupFromString(sg, arg);
        if (sg.isDataDetached()) {
            origPosition = sg.getAbsoluteXY();
        }
        if (changed && sg.isDataDetached()) {
            if (origPosition == null) {
                origPosition = new DPoint3();
                sg.getObjectsMiddle(origPosition);
                origPosition.x += 0.77;
                origPosition.y += 0.77;
            }
            if (sg.getAtomCount() == 0 && sg.getParentSgroup() != null && sg.isAbsolutePlacement() && cmd == 32) {
                Sgroup parent = sg.getParentSgroup();
                int shift = -1;
                for (int i = 0; i < parent.getChildSgroupCount(); ++i) {
                    if (!(parent.getChildSgroup(i) instanceof DataSgroup)) continue;
                    ++shift;
                }
                SelectionMolecule sgraph = parent.getSgroupGraph();
                origPosition = sgraph.calcCenter();
                origPosition.x -= 0.77;
                origPosition.y -= sgraph.calcHeight() / 2.0 + 1.54 + (double)shift * 1.54 / 2.0;
            }
            sg.setAbsoluteXY(origPosition);
        }
        this.unselect();
        if (changed) {
            this.historize();
        }
        return changed;
    }

    private int getSgroupSubType(int cmd) {
        switch (cmd) {
            case 22: {
                return 1;
            }
            case 23: {
                return 3;
            }
            case 24: {
                return 2;
            }
        }
        return 0;
    }

    public static int getSgroupType(int cmd) {
        switch (cmd) {
            case 20: {
                return 11;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return 5;
            }
            case 25: {
                return 6;
            }
            case 27: {
                return 15;
            }
            case 29: {
                return 7;
            }
            case 30: {
                return 3;
            }
            case 18: 
            case 19: 
            case 31: {
                return 2;
            }
            case 28: {
                return 4;
            }
            case 26: {
                return 12;
            }
            case 15: {
                return 13;
            }
            case 11: {
                return 1;
            }
            case 17: {
                return 9;
            }
            case 10: {
                return 0;
            }
            case 16: {
                return 8;
            }
        }
        return 0;
    }

    private void createComponentSgroup(int type, String arg, boolean hasCharge, int bracketType) {
        int length = arg.length();
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        Molecule p = (Molecule)sel.getAtom(0).getParent();
        SgroupUpdate.extendSgroupSelectionToWholeFragments(sel, this.getSelectionDoc(), p);
        Sgroup sg = new Sgroup(p, type);
        this.addToSgroupHierarchy(p, sg, null);
        if (length > 0) {
            sg.setSubscript(arg.substring(0, length - 1));
        }
        if (hasCharge) {
            sg.setChargeLocation(Integer.valueOf(arg.substring(length - 1, length)));
        }
        for (int i = 0; i < sel.getAtomCount(); ++i) {
            MolAtom a = sel.getAtom(i);
            p.setSgroupParent(a, sg, true);
        }
        CleanUtil.generateBracketCoords(sg, bracketType, !this.getPainter().getCommon().getImplicitH().equals("off"));
        this.unselect();
        this.historize();
    }

    private Sgroup ungroupAncestors(Sgroup parent, Molecule molecule) {
        Sgroup ancestor = parent;
        boolean ungroupped = false;
        while (ancestor != null) {
            Sgroup ancestorParent = ancestor.getParentSgroup();
            if (ancestor.getType() == 0 || ancestor.getType() == 1 && ((MultipleSgroup)ancestor).isExpanded()) {
                if (parent == ancestor) {
                    parent = ancestorParent;
                }
                molecule.ungroupSgroup(ancestor, 0);
                ungroupped = true;
            }
            ancestor = ancestorParent;
        }
        if (ungroupped) {
            this.removeUngroupedSgroups();
        }
        return parent;
    }

    public void addToSgroupHierarchy(Molecule p, Sgroup sg, MoleculeGraph selection) {
        block6: {
            Sgroup psg;
            int i;
            int nSgroups;
            MoleculeGraph molSelection;
            block4: {
                Sgroup parent;
                block5: {
                    molSelection = selection != null ? selection : this.getSelectionMoleculeGraph();
                    nSgroups = p.getSgroupCount();
                    parent = null;
                    for (i = 0; i < nSgroups; ++i) {
                        psg = p.getSgroup(i);
                        if (!psg.isPartSelected(molSelection) || parent != null && !psg.isDescendantOf(parent)) continue;
                        parent = psg;
                    }
                    if (parent != null && SgroupValidate.isStructureChanging(sg.getType())) {
                        parent = this.ungroupAncestors(parent, p);
                    }
                    nSgroups = p.getSgroupCount();
                    if (parent == null) break block4;
                    for (i = 0; i < parent.getChildSgroupCount(); ++i) {
                        Sgroup child = parent.getChildSgroup(i);
                        if (!child.isTotalSelected(molSelection) || sg.getType() == 14 && child.getType() == 14) continue;
                        parent.removeChildSgroup(child);
                        sg.addChildSgroup(child);
                    }
                    if (sg.getType() == 14 && parent.getType() == 14) break block5;
                    parent.addChildSgroup(sg);
                    break block6;
                }
                if ((parent = parent.getParentSgroup()) == null) break block6;
                parent.addChildSgroup(sg);
                break block6;
            }
            for (i = 0; i < nSgroups; ++i) {
                Sgroup psgParent;
                psg = p.getSgroup(i);
                if (!psg.isTotalSelected(molSelection) || (psgParent = psg.getParentSgroup()) != null && psgParent.isTotalSelected(molSelection) || sg.getType() == 14 && psg.getType() == 14) continue;
                sg.addChildSgroup(psg);
            }
        }
    }

    private boolean canHaveSameBrackets(Sgroup oldSgroup, Sgroup newSgroup) {
        if (newSgroup.getType() == 0 || oldSgroup.getType() == 0) {
            return false;
        }
        if (!(newSgroup instanceof RepeatingUnitSgroup) && oldSgroup instanceof RepeatingUnitSgroup && oldSgroup.getBracketCount() != 1) {
            return false;
        }
        return !(newSgroup instanceof RepeatingUnitSgroup) || oldSgroup instanceof RepeatingUnitSgroup;
    }

    public Sgroup replaceGroup(Sgroup sgroup, int newType, int newSubType, String newSubscript, String newSuperscript, int newCharge, int newBrackets) {
        int type;
        Molecule parent = sgroup.getParentMolecule();
        boolean ungroup = false;
        if (sgroup.getType() != newType) {
            ungroup = SgroupValidate.isStructureChanging(newType) || SgroupValidate.isStructureChanging(sgroup.getType());
        } else if (sgroup.getSubType() != newSubType) {
            ungroup = SgroupValidate.isStructureChanging(sgroup.getType());
        }
        if (sgroup instanceof RepeatingUnitSgroup) {
            ((RepeatingUnitSgroup)sgroup).removeStarAtoms();
        }
        if (sgroup.getType() != newType || sgroup.getSubType() != newSubType) {
            Sgroup newSgroup = null;
            switch (newType) {
                case 0: {
                    newSgroup = new SuperatomSgroup(parent);
                    break;
                }
                case 1: {
                    newSgroup = new MultipleSgroup(parent, false);
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 15: {
                    newSgroup = new RepeatingUnitSgroup(parent, newType);
                    newSgroup.setSubType(newSubType);
                    break;
                }
                default: {
                    newSgroup = new Sgroup(parent, newType);
                }
            }
            newSgroup.setSgroupGraph(sgroup.getSgroupGraph());
            if (newSgroup.getType() == 1) {
                for (int i = 0; i < newSgroup.getAtomCount(); ++i) {
                    MolAtom a = newSgroup.getAtom(i);
                    ((MultipleSgroup)newSgroup).setRepeatingUnitAtom(a, true);
                }
            }
            if (newSgroup.getType() == 0) {
                this.setAttachmentPoints((SuperatomSgroup)newSgroup);
            }
            if (this.canHaveSameBrackets(sgroup, newSgroup)) {
                ArrayList<MBracket> list = sgroup.getBrackets();
                for (int i = 0; i < sgroup.getBracketCount(); ++i) {
                    newSgroup.addBracket(list.get(i));
                }
            } else {
                if (newSgroup instanceof RepeatingUnitSgroup) {
                    MolBond[] crossingBonds = newSgroup.findCrossingBonds();
                    DPoint3[] corners = sgroup.getSgroupGraph().getEnclosingCube();
                    DPoint3 cornerBottomLeft = corners[0];
                    DPoint3 cornerTopRight = corners[1];
                    DPoint3 cornerBottomRight = new DPoint3(cornerTopRight.x, cornerBottomLeft.y, 0.0);
                    DPoint3 cornerTopLeft = new DPoint3(cornerBottomLeft.x, cornerTopRight.y, 0.0);
                    MolBond[] head = GeomUtil.getCrossingBonds(crossingBonds, cornerBottomLeft, cornerTopLeft, true);
                    MolBond[] tail = GeomUtil.getCrossingBonds(crossingBonds, cornerBottomRight, cornerTopRight, true);
                    if (head.length == 2 && tail.length == 2) {
                        ((RepeatingUnitSgroup)newSgroup).mergeBrackets(head[0], head[1]);
                        ((RepeatingUnitSgroup)newSgroup).mergeBrackets(tail[0], tail[1]);
                    }
                }
                CleanUtil.generateBracketCoords(newSgroup, 1);
            }
            parent.replaceSgroup(sgroup, newSgroup);
            sgroup = newSgroup;
        }
        if (sgroup.getChargeLocation() != newCharge) {
            sgroup.setChargeLocation(newCharge);
            ungroup = true;
        }
        if ((type = sgroup.getType()) == 13) {
            newSubscript = "c" + (newSubscript.equals("none") ? "" : newSubscript);
        }
        if (SgroupValidate.canHaveSubScript(type) && !sgroup.getSubscript().equals(newSubscript)) {
            sgroup.setSubscript(newSubscript);
            ungroup = true;
        }
        if (sgroup instanceof RepeatingUnitSgroup) {
            ((RepeatingUnitSgroup)sgroup).addStarAtoms();
        }
        int bracketType = newBrackets;
        ArrayList<MBracket> brackets = sgroup.getBrackets();
        for (int i = 0; i < sgroup.getBracketCount(); ++i) {
            brackets.get(i).setType(bracketType);
        }
        if (SgroupValidate.canHavePolymerSuperScript(sgroup.getSgroupGraph(), sgroup.getType())) {
            String connectivity = newSuperscript;
            RepeatingUnitSgroup rsgroup = (RepeatingUnitSgroup)sgroup;
            int newConnectivity = rsgroup.getConnectivity();
            if (connectivity.startsWith("ht")) {
                newConnectivity = 2;
            } else if (connectivity.startsWith("hh")) {
                newConnectivity = 1;
            } else if (connectivity.startsWith("eu")) {
                newConnectivity = 0;
            }
            if (rsgroup.getConnectivity() != newConnectivity) {
                rsgroup.setConnectivity(newConnectivity);
                ungroup = true;
            }
            if (connectivity.endsWith("f") && !rsgroup.isFlipped()) {
                rsgroup.setFlipped(true);
                ungroup = true;
            }
            if (connectivity.endsWith("n") && rsgroup.isFlipped()) {
                rsgroup.setFlipped(false);
                ungroup = true;
            }
        }
        if (ungroup) {
            this.ungroupAncestors(sgroup.getParentSgroup(), parent);
        }
        return sgroup;
    }

    private boolean fillDataSgroupFromString(DataSgroup dsg, String arg) {
        boolean changed = false;
        StringTokenizer st = new StringTokenizer(arg, "\u9999", false);
        String nextValue = st.nextToken();
        boolean b = Boolean.parseBoolean(nextValue);
        if (dsg.isAbsolutePlacement() != b) {
            dsg.setAbsolutePlacement(b);
            changed = true;
        }
        nextValue = st.nextToken();
        if (dsg.getData() == null || !dsg.getData().equals(nextValue)) {
            dsg.setData(nextValue);
            changed = true;
            if (TextUtils.isURL(nextValue)) {
                dsg.setFieldType(4);
            }
        }
        nextValue = st.nextToken();
        b = Boolean.parseBoolean(nextValue);
        if (dsg.isDataDetached() != b) {
            dsg.setDataDetached(b);
            changed = true;
        }
        nextValue = st.nextToken();
        int i = Integer.parseInt(nextValue);
        if (dsg.getDisplayedChars() != i) {
            dsg.setDisplayedChars(i);
            changed = true;
        }
        nextValue = st.nextToken();
        i = Integer.parseInt(nextValue);
        if (dsg.getDisplayedLines() != i) {
            dsg.setDisplayedLines(i);
            changed = true;
        }
        nextValue = st.nextToken();
        if (dsg.getFieldName() == null || !dsg.getFieldName().equals(nextValue)) {
            dsg.setFieldName(nextValue);
            changed = true;
        }
        if (!((nextValue = st.nextToken()).equals("none") || dsg.getQueryCode() != null && dsg.getQueryCode().equals(nextValue))) {
            dsg.setQueryCode(nextValue);
            changed = true;
        }
        if ((nextValue = st.nextToken()).equals("none")) {
            nextValue = null;
        }
        if (dsg.getQueryOp() == null || !dsg.getQueryOp().equals(nextValue)) {
            dsg.setQueryOp(nextValue);
            changed = true;
        }
        nextValue = st.nextToken();
        if (dsg.getTag() != nextValue.charAt(0)) {
            dsg.setTag(nextValue.charAt(0));
            changed = true;
        }
        nextValue = st.nextToken();
        b = Boolean.parseBoolean(nextValue);
        if (dsg.isUnitDisplayed() != b) {
            dsg.setUnitDisplayed(b);
            changed = true;
        }
        if ((nextValue = st.nextToken()).equals("\u9998")) {
            nextValue = "";
        }
        if (dsg.getUnits() == null || !dsg.getUnits().equals(nextValue)) {
            dsg.setUnits(nextValue);
            changed = true;
        }
        if (!(nextValue = st.nextToken()).equals(dsg.getContext())) {
            dsg.setContext(nextValue);
            changed = true;
        }
        return changed;
    }

    public synchronized void setMol(Molecule mol) {
        if (mol == null) {
            mol = new RgMolecule();
        }
        if (mol.getDocument() != null) {
            this.setDocument(mol.getDocument(), false);
        } else {
            this.setDocument(new MDocument(mol), false);
        }
        this.reset0();
        this.historize();
        this.documentEdited = false;
    }

    public synchronized boolean edit(int cmd, SketchMode arg) {
        switch (cmd) {
            case 0: {
                return this.setSketchMode(arg, false);
            }
            case 1: {
                return this.setSketchMode(arg, true);
            }
        }
        return false;
    }

    public synchronized boolean edit(int cmd, MObject mo, int arg) {
        int i = this.document.indexOf(mo);
        if (cmd != 1 && i < 0) {
            return false;
        }
        if (cmd == 1) {
            this.removeObject(this.document, mo);
            this.reset0();
            if (this.document.isEmpty()) {
                this.setIdentityTransform();
            }
            this.historize();
            return true;
        }
        MObject mo1 = this.document.getConnectedObject(i);
        if (mo1 != null) {
            switch (cmd) {
                case 0: {
                    this.document.moveObject(mo1, arg);
                    break;
                }
                case 2: {
                    ((MPolyline)mo1).setArrowFlags(0, arg);
                    break;
                }
                case 3: {
                    ((MPolyline)mo1).setArrowFlags(1, arg);
                    break;
                }
                case 4: {
                    ((MPolyline)mo1).setFlags(arg);
                    break;
                }
                case 5: {
                    ((MTextBox)mo1).setBaseFontStyle(arg);
                    break;
                }
                case 6: {
                    if (!(mo1 instanceof MRectangle)) break;
                    ((MRectangle)mo1).setTOption(arg);
                    break;
                }
                case 7: {
                    if (!(mo1 instanceof MRectangle)) break;
                    ((MRectangle)mo1).setTCenter(arg);
                    break;
                }
                case 8: {
                    ((MTextBox)mo1).setHorizontalAlignment(arg);
                    break;
                }
                case 9: {
                    ((MTextBox)mo1).setVerticalAlignment(arg);
                }
            }
            this.historize();
            return true;
        }
        return false;
    }

    public synchronized boolean edit(int cmd, MObject mo, Color arg) {
        int i = this.document.indexOf(mo);
        if (i < 0) {
            return false;
        }
        MObject mo1 = this.document.getConnectedObject(i);
        if (mo1 != null) {
            switch (cmd) {
                case 0: {
                    mo1.setColor(arg);
                    break;
                }
                case 1: {
                    mo1.setLineColor(arg);
                    break;
                }
                case 2: {
                    mo1.setBackground(arg);
                }
            }
            this.historize();
            return true;
        }
        return false;
    }

    public synchronized boolean edit(int cmd, MObject mo, double arg) {
        int i = this.document.indexOf(mo);
        if (i < 0) {
            return false;
        }
        MObject mo1 = this.document.getConnectedObject(i);
        if (mo1 != null) {
            switch (cmd) {
                case 0: {
                    ((MPolyline)mo1).setThickness(arg);
                    break;
                }
                case 1: {
                    MPolyline pl;
                    if (!(mo1 instanceof MPolyline) || (pl = (MPolyline)mo1).getPointCount() != 2) break;
                    pl.setArcAngle(arg);
                    break;
                }
                case 2: 
                case 3: {
                    int j = cmd - 2;
                    ((MPolyline)mo1).setSkip(j, arg);
                    break;
                }
                case 4: 
                case 5: {
                    int j = cmd - 4;
                    ((MPolyline)mo1).setArrowLength(j, arg);
                    break;
                }
                case 6: 
                case 7: {
                    int j = cmd - 6;
                    ((MPolyline)mo1).setArrowWidth(j, arg);
                    break;
                }
                case 8: {
                    ((MTextBox)mo1).setFontScale(arg);
                }
            }
            this.historize();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void select() {
        Molecule mol = this.getMol();
        Object object = mol.getLock();
        synchronized (object) {
            this.getDocument().selectAllObjects(false);
            this.getSelectionDoc().selectAllObjects(true);
            this.rationalizeSelection();
        }
    }

    public synchronized boolean edit(int cmd, MObject mo, String arg) {
        int i = this.document.indexOf(mo);
        if (i < 0) {
            return false;
        }
        MObject mo1 = this.document.getObject(i);
        if (mo1 != null) {
            switch (cmd) {
                case 0: {
                    ((MTextBox)mo1).setBaseFontFamily(arg);
                }
            }
            this.historize();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselect() {
        Molecule mol = this.getMol();
        Object object = mol.getLock();
        synchronized (object) {
            MTextBox t = this.getTheSelectedMTextBox();
            if (t != null && t == this.document.getFocus()) {
                this.setFocus(null);
            }
            this.getSelectionDoc().selectAllObjects(false);
            this.clearSelection();
            this.document.setObjectContainingSelection(null);
        }
    }

    public void updateFocus() {
        MObject t = null;
        this.setFocus(t);
    }

    public void setFocus(MObject o) {
        MDocument doc = this.document;
        MObject old = doc.getFocus();
        if (old != null && old != o && old instanceof MTextBox && old.isEmpty()) {
            doc.removeObject(old);
            this.getSelectionDoc().removeObject(old);
            old = null;
        }
        doc.setFocus(o);
        MTextBox t = o != null && o instanceof MTextBox ? (MTextBox)o : null;
        doc.setObjectContainingSelection(t != null && t.hasSelection() ? t : null);
        if (old != null && old != o && old instanceof MTextBox) {
            String s = ((MTextBox)old).getText();
            int i = doc.indexOf(old);
            MDocument prevdoc = this.history.getPreviousDocument(1);
            if (prevdoc != null && i < prevdoc.getObjectCount() && prevdoc.getObject(i) instanceof MTextBox) {
                String prevs = ((MTextBox)prevdoc.getObject(i)).getText();
                if (!prevs.equals(s)) {
                    this.historize();
                }
            } else {
                this.historize();
            }
        }
    }

    private MTextBox getTheSelectedMTextBox() {
        MObject o = this.getTheSelectedMObject();
        return o != null && o instanceof MTextBox ? (MTextBox)o : null;
    }

    MObject getTheSelectedMObject() {
        int nm = 0;
        MObject o = null;
        for (int i = 0; i < this.getSelectionDoc().getObjectCount(); ++i) {
            MObject mo = this.getSelectionDoc().getObject(i);
            if (mo instanceof MChemicalStruct) {
                if (!mo.isEmpty()) {
                    return null;
                }
                ++nm;
                continue;
            }
            if (o == null) {
                o = mo;
                continue;
            }
            return null;
        }
        return nm < 2 ? o : null;
    }

    public MObject[] getSelectedMObjects() {
        return MolEditor.getMObjects(this.getSelectionDoc());
    }

    public MObject[] getMObjects() {
        return MolEditor.getMObjects(this.document);
    }

    public static MObject[] getMObjects(MDocument document) {
        ArrayList<MObject> v = new ArrayList<MObject>();
        List<MObject> list = document.getAllObjects();
        for (int i = list.size() - 1; i >= 0; --i) {
            MObject o = list.get(i);
            if (o instanceof MChemicalStruct || o.isInternalSelectable()) continue;
            v.add(o);
        }
        MObject[] objs = new MObject[v.size()];
        v.toArray(objs);
        return objs;
    }

    public int getSelectedPointCount() {
        MSelectionDocument seldoc = this.getSelectionDocument();
        int npoints = 0;
        for (int i = 0; i < seldoc.getObjectCount(); ++i) {
            npoints += seldoc.getObject(i).getPointCount();
        }
        return npoints;
    }

    public MDocument join(MolJoin j, MDocument gdoc, int options) {
        SelectionMolecule sg;
        MoleculeGraph g = gdoc == null ? null : gdoc.getMainMoleculeGraph();
        SelectionMolecule selectionMolecule = sg = j != null ? j.join(g, options) : null;
        if (sg == null && gdoc != null && gdoc.getObjectCount() > 1) {
            sg = new SelectionMolecule();
        }
        if (sg != null && gdoc != null) {
            MSelectionDocument doc = new MSelectionDocument(sg);
            for (int i = 0; i < gdoc.getObjectCount(); ++i) {
                MObject o = gdoc.getObject(i);
                if (o instanceof MChemicalStruct || o.isInternalSelectable()) continue;
                ((MDocument)doc).addObject(o);
            }
            MoleculeGraph sel = this.getSelectionMoleculeGraph();
            Molecule mol = this.getMol();
            for (int i = sel.getAtomCount() - 1; i >= 0; --i) {
                if (mol.contains(sel.getAtom(i))) continue;
                sel.removeAtom(i);
            }
            return doc;
        }
        return null;
    }

    void rationalizeSelection() {
        MSelectionDocument seldoc = this.getSelectionDoc();
        MoleculeGraph sel = seldoc.getMainMoleculeGraph();
        if (seldoc.getObjectCount() > 1 || !sel.isEmpty()) {
            this.getDocument().setObjectContainingSelection(null);
            this.getSelectionDoc().setObjectContainingSelection(null);
        }
        this.updateFocus();
    }

    public static void selectAtom(MolAtom node, MoleculeGraph sel) {
        if (!sel.contains(node)) {
            sel.add(node);
        }
        for (int j = 0; j < node.getBondCount(); ++j) {
            MolBond edge = node.getBond(j);
            MolAtom a = edge.getOtherAtom(node);
            if (!sel.contains(a) || sel.contains(edge)) continue;
            sel.add(edge);
        }
    }

    void unselectAtom(MolAtom a) {
        this.getSelectionDoc().removeAtomFromGraphs(a);
        a.setSelected(false);
    }

    public DPoint3 getO() {
        return this.document.getMainMoleculeGraph().getLocation();
    }

    public Object getObjectAtPointer() {
        PointedObject so = this.getPointedObject();
        return so != null ? so.getContainedObject() : null;
    }

    public MPoint getMPointerPos(boolean objectOnly) {
        PointedObject so = this.getPointedObject();
        MPoint p = so != null ? so.getContainedObjectMPointerPos() : null;
        return p != null || objectOnly ? p : new MPoint(this.getPointerPos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rgroupIdOf(MolAtom atom) {
        Molecule mol = this.getMol();
        if (mol instanceof RgMolecule && atom != null) {
            RgMolecule rmol = (RgMolecule)mol;
            Object object = mol.getLock();
            synchronized (object) {
                return rmol.rgroupIdOf(atom);
            }
        }
        return -1;
    }

    public Molecule getMol() {
        Molecule mol;
        MDocument doc = this.document;
        Molecule molecule = mol = doc != null ? (Molecule)doc.getMainMoleculeGraph() : null;
        if (!this.getPainter().getCommon().isRgDefinitionVisible() && mol instanceof RgMoleculeGraphIface) {
            mol = (Molecule)((RgMoleculeGraphIface)((Object)mol)).getRootG();
        }
        return mol;
    }

    public MDocument getDocument() {
        return this.document;
    }

    private void setDocument(MDocument doc, boolean keepView) {
        MDocument olddoc;
        if (!keepView || doc.isEmpty()) {
            this.setIdentityTransform();
        }
        if ((olddoc = this.document) != doc) {
            MSelectionDocument oldsel = this.getSelectionDoc();
            this.document = doc;
            MSelectionDocument sel = MolEditor.createSelectionDoc(doc);
            List<MObject> moList = doc.getAllObjects();
            for (MObject mo : moList) {
                if (mo instanceof MChemicalStruct || !mo.isSelected()) continue;
                sel.addObject(mo);
            }
            this.setSelectionDoc(sel);
            if (oldsel != null) {
                ((MDocument)oldsel).clear();
            }
        }
    }

    private void addExtraObjects(MDocument doc, List<MObject> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            MObject o = list.get(i);
            doc.addObject(o);
        }
    }

    private List<MObject> removeExtraObjects(MDocument doc, Molecule mol) {
        ArrayList<MObject> list = new ArrayList<MObject>();
        for (int i = doc.getObjectCount() - 1; i >= 0; --i) {
            MObject o = doc.getObject(i);
            if (!o.isReactionArrow(mol) && (!(o instanceof MBracket) || this.findContainingSgroup((MBracket)o) == null)) continue;
            doc.removeObject(i);
            list.add(o);
        }
        return list;
    }

    private void deselectReactionArrow(Molecule mol, List<MObject> list) {
        if (mol instanceof RxnMolecule) {
            RxnMolecule rxnmol = (RxnMolecule)mol;
            List<MRArrow> arrows = rxnmol.getReactionArrowList();
            for (MPolyline mPolyline : arrows) {
                if (mPolyline == null) continue;
                mPolyline.setSelected(false);
            }
        }
        for (MObject next : list) {
            if (!(next instanceof MPolyline)) continue;
            ((MPolyline)next).setSelected(false);
        }
    }

    public Molecule getMolSelection() {
        Molecule m;
        if (this.getSelectionDoc().isEmpty()) {
            return new Molecule();
        }
        Molecule mol = this.getMol();
        List<MObject> extraObjects = this.removeExtraObjects(this.getSelectionDoc(), mol);
        Molecule s = mol.cloneMolecule();
        this.removeUnselectedSgroup(s);
        MoleculeGraph us = s.getGraphUnion();
        for (int i = us.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = us.getAtom(i);
            if (a.isSelected()) {
                a.setSelected(false);
                continue;
            }
            s.removeAtom(a);
        }
        RgMolecule rgmol = null;
        RxnMolecule rxmol = null;
        if (s instanceof RgMolecule) {
            rgmol = (RgMolecule)s;
            m = rgmol.getRoot();
            if (m instanceof RxnMolecule) {
                rxmol = (RxnMolecule)m;
            }
        } else if (s instanceof RxnMolecule) {
            rxmol = (RxnMolecule)s;
        }
        if (rxmol != null) {
            rxmol.removeEmptyComponents();
            if (rxmol.isSingleStepReaction() && rxmol.getReactionArrow(false) != null && !rxmol.getReactionArrow(false).isSelected()) {
                m = new Molecule();
                Molecule mm = rxmol.simplifyToMolecule();
                mm.clonelesscopy(m);
                if (rgmol != null) {
                    rgmol.setRoot(m);
                } else {
                    s = m;
                }
            } else if (!rxmol.isSingleStepReaction()) {
                m = rxmol.simplifyToMolecule();
                if (s instanceof RgMolecule) {
                    rgmol = (RgMolecule)s;
                    if (rgmol.getRoot() instanceof RxnMolecule) {
                        rgmol.setRoot(m);
                    }
                } else if (s instanceof RxnMolecule) {
                    s = m;
                }
            } else if (rxmol.isSingleStepReaction() && rxmol.getReactionArrow(false) != null && rxmol.getReactionArrow(false).isSelected()) {
                rxmol.getReactionArrow(false).setSelected(false);
            }
        }
        MDocument sdoc = new MDocument(this.getSelectionDoc());
        ColorSetUtil.copySets(sdoc, this.document);
        sdoc.setMainMoleculeGraph(s);
        for (int i = 0; i < sdoc.getObjectCount(); ++i) {
            sdoc.getObject(i).setSelected(false);
        }
        this.deselectReactionArrow(mol, extraObjects);
        this.addExtraObjects(this.getSelectionDoc(), extraObjects);
        return s;
    }

    private void removeUnselectedSgroup(Molecule molecule) {
        if (molecule instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)molecule;
            Molecule m = rgmol.getRoot();
            this.removeSgroups(m);
            IteratorFactory.RgComponentIterator rci = new IteratorFactory(molecule).createRgComponentIterator();
            while (rci.hasNext()) {
                this.removeSgroups(rci.next());
            }
        } else {
            this.removeSgroups(molecule);
        }
    }

    private void removeSgroups(Molecule m) {
        for (int i = m.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sg = m.getSgroup(i);
            if (sg.getType() == 1 || sg.getType() == 0 || this.isSelectedSgroup(sg)) continue;
            m.ungroupSgroup(sg, 0);
        }
    }

    private boolean isSelectedSgroup(Sgroup sg) {
        MolAtom center;
        for (int i = sg.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = sg.getAtom(i);
            if (a.isSelected()) continue;
            return false;
        }
        if (sg instanceof MulticenterSgroup && (center = ((MulticenterSgroup)sg).getCentralAtom()) != null) {
            return center.isSelected();
        }
        return true;
    }

    public MSelectionDocument getSelectionDocument() {
        return this.getSelectionDoc();
    }

    public boolean isAllSelected() {
        MDocument doc = this.document;
        MSelectionDocument sel = this.getSelectionDoc();
        if (doc.getConnectedObjectCount() == sel.getObjectCount()) {
            MoleculeGraph m = doc.getMainMoleculeGraph().getGraphUnion();
            MoleculeGraph sm = sel.getMainMoleculeGraph().getGraphUnion();
            return m.getAtomCount() == sm.getAtomCount();
        }
        return false;
    }

    public void setCurfrag(MDocument doc) {
        MDocument old = this.curfrag;
        if (old != doc) {
            this.curfrag = doc;
            old.clear();
        }
    }

    public MDocument getCurfrag() {
        return this.curfrag;
    }

    public MolJoin getCurfragJoin() {
        return this.curfragJoin;
    }

    public void setCurfragJoin(MolJoin j) {
        this.curfragJoin = j;
    }

    public int getMoveMode() {
        return this.moveMode;
    }

    public void setMoveMode(int mode, boolean persistent) {
        this.moveMode = mode;
        this.persistentMoveMode = persistent;
        if (mode == 3) {
            if (this.getStructureJoinAtoms(this.getSelectionDocument()).size() == 2) {
                this.setRotationAxisPoint();
            }
            this.setActualRotate3dPhiX_Y(false);
            this.setRotate3direction(0);
        }
        if (mode == 0) {
            this.set3DRotationMode(-1, false);
        }
    }

    public boolean isMoveModePersistent() {
        return this.persistentMoveMode;
    }

    public int get3DRotationMode() {
        return this.rotation3DMode;
    }

    public void set3DRotationMode(int rot3dMode, boolean b) {
        this.rotation3DMode = rot3dMode;
        this.persistentMoveMode = b;
        switch (rot3dMode) {
            case 0: {
                List<MolAtom> jal = this.getStructureJoinAtoms(this.getSelectionDoc());
                int na = jal.size();
                if (na == 1) {
                    this.setAtomSelectionMode(2);
                    SelectionMolecule selmol = this.getSelectionMolecule();
                    MolAtom a = jal.get(0);
                    MolEditor.selectAtom(a, selmol);
                    this.rotO = a.getLocation();
                    this.setMoveMode(0, false);
                    this.rotAxisPoint = null;
                    break;
                }
                if (na == 0) {
                    this.setAtomSelectionMode(2);
                    this.setMoveMode(0, false);
                    this.rotAxisPoint = null;
                    break;
                }
                if (na != 2) break;
                this.rotO = jal.get(0).getLocation();
                this.rotAxisPoint = jal.get(1).getLocation();
                this.setActualRotate3dPhiX_Y(false);
                break;
            }
            case 1: {
                this.rotAxisPoint = null;
                this.rotate3dPhiY = 0.0;
                this.rotate3dPhiX = 1.0;
                this.rotate3direction = 1;
                break;
            }
            case 2: {
                this.rotAxisPoint = null;
                this.rotate3dPhiY = 1.0;
                this.rotate3dPhiX = 0.0;
                this.rotate3direction = -1;
                break;
            }
            case 3: {
                this.moveMode = 2;
                break;
            }
            case 4: {
                List<MolAtom> jal = this.getStructureJoinAtoms(this.getSelectionDoc());
                if (jal.size() == 1) {
                    this.rotO = jal.get(0).getLocation();
                }
                this.rotAxisPoint = null;
                break;
            }
            case 5: {
                this.setActualRotate3dPhiX_Y(false);
                this.isAxisSet = false;
                break;
            }
            case -1: {
                if (this.isAxisSet) break;
                this.rotAxisPoint = null;
            }
        }
    }

    public SelectionMolecule getSelectionMolecule() {
        return (SelectionMolecule)this.getSelectionMoleculeGraph();
    }

    private MoleculeGraph getSelectionMoleculeGraph() {
        return this.getSelectionDoc().getMainMoleculeGraph();
    }

    public Set<MolAtom> getSetOfAllOrSelectedAtoms() {
        HashSet<MolAtom> set = new HashSet<MolAtom>();
        MoleculeGraph m = this.hasSelection() ? this.getSelectionMolecule() : this.getMol().getGraphUnion();
        for (int i = 0; i < m.getAtomCount(); ++i) {
            set.add(m.getAtom(i));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] calcMolBoundsInMolCoords() {
        double[] borders;
        Molecule mol = this.getDocument().getPrimaryMolecule();
        Object object = mol.getLock();
        synchronized (object) {
            if (this.getDocument().isEmpty()) {
                return null;
            }
            borders = this.getPainter().preCalcBounds(mol);
        }
        return borders;
    }

    private synchronized void clearCachedMolBounds() {
        this.cachedMolBounds = null;
        this.cachedMolBoundsInvCC = -1L;
    }

    private synchronized double[] getCachedMolBounds() {
        if (this.cachedMolBounds != null && this.getMol() != null && this.getMol().getGrinvCC() == this.cachedMolBoundsInvCC) {
            return (double[])this.cachedMolBounds.clone();
        }
        return null;
    }

    private synchronized void setCachedMolBounds(long grinvCC, double[] bounds) {
        this.cachedMolBoundsInvCC = grinvCC;
        this.cachedMolBounds = bounds != null ? (double[])bounds.clone() : null;
    }

    public Rectangle calcMolBoundingRectangle() {
        double[] borders = this.getCachedMolBounds();
        if (borders == null) {
            borders = this.calcMolBoundsInMolCoords();
            this.setCachedMolBounds(this.getMol().getGrinvCC(), borders);
        }
        if (borders == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Point corner = this.getCorner();
        DPoint3 point1 = new DPoint3(borders[0], borders[1], borders[2]);
        DPoint3 point2 = new DPoint3(borders[3], borders[4], borders[5]);
        this.getPainter().calcGP(point1);
        this.getPainter().calcGP(point2);
        int xmin = (int)Math.round(point1.x + (double)corner.x);
        int width = (int)Math.round(point2.x - point1.x);
        int ymin = (int)Math.round(point1.y + (double)corner.y);
        int height = (int)Math.round(point2.y - point1.y);
        return new Rectangle(xmin, ymin, width, height);
    }

    private Object[] calcRotGeom(MDocument doc) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        MolAtom aa = null;
        int nrotc = 0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < doc.getObjectCount(); ++i) {
            MObject o = doc.getObject(i);
            if (o instanceof MChemicalStruct) {
                MoleculeGraph m = ((MChemicalStruct)o).getMoleculeGraph();
                MoleculeGraph u = m.getGraphUnion();
                for (int j = 0; j < u.getAtomCount(); ++j) {
                    MolAtom a = u.getAtom(j);
                    x += a.getX();
                    y += a.getY();
                    z += a.getZ();
                    for (int k = a.getBondCount() - 1; k >= 0; --k) {
                        if (u.contains(a.getLigand(k))) continue;
                        aa = a;
                        ++nrotc;
                        k = 0;
                    }
                    ++n;
                    ++n2;
                }
                continue;
            }
            DPoint3 p = new DPoint3();
            o.calcCenter(p, null);
            x += p.x;
            y += p.y;
            z += p.z;
            ++n;
            n2 += o.getPointCount();
        }
        if (n == 0) {
            return null;
        }
        x /= (double)n;
        y /= (double)n;
        z /= (double)n;
        Object[] g = new Object[n2 == 1 ? 1 : 2];
        if (nrotc == 1 && aa != null) {
            x = aa.getX();
            y = aa.getY();
            z = aa.getZ();
            g[0] = aa;
        } else {
            g[0] = new DPoint3(x, y, z);
        }
        double x2 = 0.0;
        double y2 = 0.0;
        double z2 = 0.0;
        CTransform3D trot = this.getPainter().getRTransformRef();
        CTransform3D tinvrot = this.getPainter().getInvRTransformRef();
        for (int i = 0; i < doc.getObjectCount(); ++i) {
            MObject o = doc.getObject(i);
            if (o instanceof MChemicalStruct) {
                MoleculeGraph m = ((MChemicalStruct)o).getMoleculeGraph();
                MoleculeGraph u = m.getGraphUnion();
                for (int j = 0; j < u.getAtomCount(); ++j) {
                    DPoint3 p = u.getAtom(j).getLocation();
                    double dx = p.x - x;
                    double dy = p.y - y;
                    double dz = p.z - z;
                    x2 += dx * dx;
                    y2 += dy * dy;
                    z2 += dz * dz;
                }
                continue;
            }
            for (int j = 0; j < o.getPointCount(); ++j) {
                DPoint3 p = o.getPoint(j).getLocation(trot);
                tinvrot.transform(p);
                double dx = p.x - x;
                double dy = p.y - y;
                double dz = p.z - z;
                x2 += dx * dx;
                y2 += dy * dy;
                z2 += dz * dz;
            }
        }
        if (n2 != 1) {
            g[1] = new Double(Math.sqrt((x2 + y2 + z2) / (double)n2));
        }
        return g;
    }

    DPoint3 getScreenFromMolPos(DPoint3 p) {
        this.getPainter().getRTransformRef().transform(p);
        return p;
    }

    public boolean isEmpty() {
        return this.document.isEmpty() && this.document.getObjectCount() == this.document.getConnectedObjectCount();
    }

    public boolean hasSelection() {
        return !this.getSelectionDoc().isEmpty();
    }

    public double getAtomSize() {
        return this.atomSize;
    }

    public double getBondSpacing() {
        return this.bondSpacing;
    }

    public double getMergedst() {
        return this.mergedst;
    }

    public double getStickdst() {
        return this.stickdst;
    }

    public DPoint3 getPointerPos() {
        DPoint3 p = this.getScreenPointerPos();
        this.getPainter().getInvRTransformRef().transform(p);
        return p;
    }

    public DPoint3 getScreenPointerPos() {
        return new DPoint3(this.ptrX, this.ptrY, this.ptrZ);
    }

    public DPoint3 getPrevPointerPos() {
        DPoint3 p = this.getPrevScreenPointerPos();
        this.getPainter().getInvRTransformRef().transform(p);
        return p;
    }

    private DPoint3 getPrevScreenPointerPos() {
        return new DPoint3(this.prevPtrX, this.prevPtrY, this.prevPtrZ);
    }

    public DPoint3 getPointerPosDiff() {
        DPoint3 p = this.getPointerPos();
        DPoint3 q = this.getPrevPointerPos();
        return new DPoint3(p.x - q.x, p.y - q.y, p.z - q.z);
    }

    public double getPointerAngleDiff() {
        DPoint3 o = new DPoint3(this.rotO);
        this.getPainter().getRTransformRef().transform(o);
        return Math.atan2(this.ptrY - o.y, this.ptrX - o.x) - Math.atan2(this.prevPtrY - o.y, this.prevPtrX - o.x);
    }

    public double getPointerAngleDiffBy15Degrees(boolean nojoin) {
        DPoint3 pc;
        DPoint3 pa = this.getScreenPointerPos();
        MoleculeGraph cmg = this.curfrag.getMainMoleculeGraph();
        if (nojoin && !cmg.isEmpty()) {
            MolAtom ca = this.curfrag.getMainMoleculeGraph().getAtom(this.indexToRot);
            pc = ca != null ? ca.getLocation() : new DPoint3(0.0, 0.0, 0.0);
        } else if (nojoin) {
            MObject mo = this.curfrag.getObject(this.indexToRot);
            pc = mo.getPointRef(this.pointIndexToRot, this.getPainter().getRTransform()).getLocation();
        } else {
            pc = this.curfrag.calcCenter();
        }
        this.getPainter().getRTransformRef().transform(pc);
        this.getPainter().getRTransformRef().transform(this.rotO);
        double alpha = pa.angle2D(this.rotO.x, this.rotO.y);
        double beta = pc.angle2D(this.rotO.x, this.rotO.y);
        double df = 0.2617993877991494;
        this.getPainter().getInvRTransformRef().transform(this.rotO);
        return (double)Math.round((alpha - beta) / df) * df;
    }

    public double getAngleDiffTo15Degrees() {
        DPoint3 o = new DPoint3(this.rotO);
        MoleculeGraph cmg = this.curfrag.getMainMoleculeGraph();
        if (cmg != null && cmg.getAtomCount() > 1 && cmg.contains(this.jointAtom)) {
            MolBond cb;
            MolAtom cja = cmg.findAtomClone(this.jointAtom);
            MolBond molBond = cb = cja != null && cja.getBondCount() > 0 ? cja.getBond(0) : null;
            if (cb != null) {
                DPoint3 pc = cb.getOtherAtom(cja).getLocation();
                double beta = pc.angle2D(o.x, o.y);
                return -1.0 * Math.IEEEremainder(beta, 0.2617993877991494);
            }
        }
        return 0.0;
    }

    public boolean setPointerPos(DPoint3 p) {
        DPoint3 q = this.getScreenFromMolPos(p);
        return this.setScreenPointerPos((float)q.x, (float)q.y, (float)q.z);
    }

    public synchronized boolean setScreenPointerPos(float x, float y, float z) {
        return this.setScreenPointerPos0(x, y, z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScreenPointerPos0(float x, float y, float z) {
        int i;
        System.arraycopy(this.ptrHist, 0, this.ptrHist, 2, this.ptrHist.length - 2);
        if (this.ptrHistLen < this.ptrHist.length / 2) {
            ++this.ptrHistLen;
        }
        this.ptrHist[0] = x;
        this.ptrHist[1] = y;
        this.prevPtrX = this.ptrX;
        this.prevPtrY = this.ptrY;
        this.prevPtrZ = this.ptrZ;
        this.ptrX = x;
        this.ptrY = y;
        this.ptrZ = z;
        for (i = 1; i < this.ptrHistLen; ++i) {
            double dx = this.ptrX - this.ptrHist[2 * i];
            double dy = this.ptrY - this.ptrHist[2 * i + 1];
            double r = dx * dx + dy * dy;
            if (!(r > 1.0)) continue;
            this.ptrPhi = Math.atan2(dy, dx);
            break;
        }
        if (i == this.ptrHistLen && this.ptrHistLen > 1) {
            double px = this.ptrHist[2 * this.ptrHistLen - 2] - this.ptrX;
            double py = this.ptrHist[2 * this.ptrHistLen - 1] - this.ptrY;
            if (px != 0.0 && py != 0.0) {
                this.ptrPhi = Math.atan2(py, px);
            }
        }
        Object object = this.document.getMainMoleculeGraph().getLock();
        synchronized (object) {
            return this.initAtNewPos();
        }
    }

    public boolean setPointerPos0(DPoint3 p) {
        DPoint3 q = this.getScreenFromMolPos(p);
        return this.setScreenPointerPos0((float)q.x, (float)q.y, (float)q.z);
    }

    private boolean initAtNewPos() {
        Molecule mol = this.getMol();
        MoleculeGraph mcf = this.curfrag.getMainMoleculeGraph();
        CTransform3D trot = this.getPainter().getRTransformRef();
        MolJoin molJoin = this.curfragJoin = this.curfrag.isEmpty() ? null : new MolJoin(mol, mcf, this.stickdst * 1.54, this.mergedst * 1.54, this.jointAtom, trot);
        if (this.piece == null) {
            return this.pntAB(true);
        }
        MoleculeSM.moveTo(this.getPointerPos(), this.piece);
        this.canMovCurfrag = false;
        this.canRotCurfrag = false;
        if (this.bondrawMode) {
            if (!(this.piece != null && (this.piece.isBond() || ChainSM.isChain(this.piece) || this.atomBranchPiece != null && this.atomBranchPiece.isAtom()))) {
                this.clearCurfrag();
                this.bondrawMode = false;
            } else if (this.piece.getBondCount() > 0 && this.curfrag.getMainMoleculeGraph().getBondCount() > 0) {
                int t = this.piece.getBond(0).getType();
                MolBond b = this.curfrag.getMainMoleculeGraph().getBond(0);
                if (b.getType() != t) {
                    this.flyingBondMol.getBond(0).setType(t);
                    b.setType(t);
                    return true;
                }
            }
        }
        return false;
    }

    public synchronized int command(int cmd, int mod) {
        return this.command0(cmd, mod);
    }

    private int command0(int cmd, int mod) {
        int ret = -1;
        switch (cmd) {
            case 1: {
                ret = this.pointerMove0(mod);
                break;
            }
            case 2: {
                ret = this.pointerDrag0(mod);
                break;
            }
            case 3: {
                ret = this.pointerEnterExit0(true);
                break;
            }
            case 4: {
                ret = this.pointerEnterExit0(false);
                break;
            }
            case 5: {
                ret = this.buttonDown0(false, mod);
                break;
            }
            case 6: {
                ret = this.buttonDown0(true, mod);
                break;
            }
            case 7: {
                ret = this.sketchMode.buttonUp(mod, true);
                this.dragged = false;
                break;
            }
            case 8: {
                ret = this.sketchMode.modkeyChange(mod);
                this.modifiers = mod;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pointerMove0(int mod) {
        Object object = this.document.getMainMoleculeGraph().getLock();
        synchronized (object) {
            return this.sketchMode.pointerMove(mod) ? 1 : 0;
        }
    }

    boolean moveOrRotateCurfrag(int mod, boolean isTranslate) {
        if (!this.curfrag.isEmpty() && (this.moveMode != 0 || isTranslate)) {
            DPoint3 dptr = this.getPointerPosDiff();
            if (dptr.x == 0.0 && dptr.y == 0.0) {
                return false;
            }
            CTransform3D t = this.transformMatrix;
            t.setIdentity();
            if (this.moveMode == 2) {
                this.prepareToRotateCurfrag(t, mod);
                CTransform3D t2 = this.getPainter().getInvRTransform();
                t2.mul(t);
                t2.mul(this.getPainter().getRTransformRef());
                t2.setRotationCenter(this.rotO);
                t = t2;
            } else if (this.moveMode == 3) {
                this.prepare3DRotateCurfrag(t, mod);
                Molecule m = this.getMol();
                if (m.getDim() < 3) {
                    m.setDim(3);
                }
            } else if (this.moveMode == 1 || isTranslate) {
                this.prepareToMoveCurfrag(t, dptr);
            }
            int opts = 0;
            if (this.curfrag.getObjectCount() == 2 && this.curfrag.getMainMoleculeGraph().isEmpty()) {
                opts |= 1;
            }
            for (int i = 0; i < this.curfrag.getObjectCount(); ++i) {
                if (this.curfrag.getObject(i) instanceof MRectanglePoint) {
                    if (!(((MRectanglePoint)this.curfrag.getObject(i)).getParentRect() instanceof MTextBox)) continue;
                    ((MTextBox)((MRectanglePoint)this.curfrag.getObject(i)).getParentRect()).setAutoSize(false);
                    continue;
                }
                if (!(this.curfrag.getObject(i) instanceof MTextBox)) continue;
                ((MTextBox)this.curfrag.getObject(i)).setAutoSize(false);
            }
            this.curfrag.transform(t, opts, this.getPainter().getRTransformRef());
            this.curfragMoved = true;
            return true;
        }
        return false;
    }

    public void setRotate3direction(int i) {
        this.rotate3direction = i;
    }

    public void setActualRotate3dPhiX_Y(boolean toVertical) {
        if (this.rotAxisPoint != null && !toVertical) {
            DPoint3 o = (DPoint3)this.rotO.clone();
            DPoint3 a = (DPoint3)this.rotAxisPoint.clone();
            CTransform3D tr = this.getPainter().getRTransform();
            tr.transform(o);
            tr.transform(a);
            this.rotate3dPhiX = a.x - o.x;
            this.rotate3dPhiY = -(a.y - o.y);
        } else {
            this.rotate3dPhiX = 1.0;
            this.rotate3dPhiY = 0.0;
        }
    }

    private void prepare3DRotateCurfrag(CTransform3D t, int mod) {
        double phi = 0.0;
        if ((mod & 1) == 0) {
            double xphi = (this.ptrY - this.prevPtrY) / 2.0;
            double yphi = (this.ptrX - this.prevPtrX) / 2.0;
            if (this.rotAxisPoint != null) {
                phi = this.rot3DAtomAxis();
            } else {
                switch (this.rotation3DMode) {
                    case 1: {
                        DPoint3 o = this.rotO;
                        DPoint3 a = new DPoint3(this.rotO.x - 1.0, this.rotO.y, this.rotO.z);
                        phi = xphi;
                        CTransform3D tinv = this.getPainter().getInvRTransform();
                        CTransform3D tt = new CTransform3D();
                        tt.setTranslation(-o.x, -o.y, -o.z);
                        tinv.setTranslation(o);
                        tinv.mul(tt);
                        tinv.transform(a);
                        Rotate.rotate(this.curfrag.getMainMoleculeGraph(), o, a, phi);
                        break;
                    }
                    case 2: {
                        DPoint3 o = this.rotO;
                        DPoint3 a = new DPoint3(this.rotO.x, 1.0 - this.rotO.y, this.rotO.z);
                        phi = yphi;
                        CTransform3D tinv = this.getPainter().getInvRTransform();
                        CTransform3D tt = new CTransform3D();
                        tt.setTranslation(-o.x, -o.y, -o.z);
                        tinv.setTranslation(o);
                        tinv.mul(tt);
                        tinv.transform(a);
                        Rotate.rotate(this.curfrag.getMainMoleculeGraph(), o, a, phi);
                        break;
                    }
                    case -1: 
                    case 4: 
                    case 5: {
                        phi = Math.sqrt(xphi * xphi + yphi * yphi);
                        t.setRotation(-xphi, yphi, 0.0, phi);
                        t.setRotationCenter(this.rotO);
                        this.rotate3dPhiX = this.rotate3dPhiX * 0.95 + xphi * 0.05;
                        this.rotate3dPhiY = this.rotate3dPhiY * 0.95 + yphi * 0.05;
                        this.rotate3direction = 0;
                    }
                }
            }
        } else {
            phi = this.rot3DX_YAxis();
        }
        CTransform3D t2 = this.getPainter().getInvRTransform();
        t2.mul(t);
        t2.mul(this.getPainter().getRTransformRef());
        t2.setRotationCenter(this.rotO);
        t = t2;
        this.rotate3dPhi += phi;
    }

    private double rot3DX_YAxis() {
        if (!this.hasSelection()) {
            return 0.0;
        }
        double phi = 0.0;
        if (this.rotate3direction == 0) {
            double xphi = this.ptrX - this.prevPtrX;
            double yphi = this.ptrY - this.prevPtrY;
            this.rotate3dx += xphi;
            this.rotate3dy += yphi;
            if (Math.abs(this.rotate3dy) > 0.2) {
                this.rotate3direction = 1;
            } else if (Math.abs(this.rotate3dx) > 0.2) {
                this.rotate3direction = -1;
            }
        } else {
            MSelectionDocument doc = this.getSelectionDoc();
            MoleculeGraph sel = doc.getMainMoleculeGraph();
            DPoint3 o = this.rotO;
            double yphi = this.ptrY - this.prevPtrY;
            double xphi = this.ptrX - this.prevPtrX;
            DPoint3 a = null;
            if (this.rotate3direction == -1) {
                if (Math.abs(yphi) > Math.abs(xphi)) {
                    this.rotate3dy += yphi;
                } else {
                    this.rotate3dy = 0.0;
                    a = new DPoint3(o.x, o.y - 1.0, o.z);
                    phi = -xphi;
                    this.rotate3dPhiY = this.rotate3dPhiY * 0.95 + xphi * 0.05;
                    this.rotate3dPhiX = 0.0;
                }
                if (Math.abs(this.rotate3dy) > 1.0) {
                    this.rotate3direction = 1;
                    this.rotate3dy = 0.0;
                }
            } else {
                if (Math.abs(xphi) > Math.abs(yphi)) {
                    this.rotate3dx += xphi;
                } else {
                    this.rotate3dx = 0.0;
                    a = new DPoint3(o.x - 1.0, o.y, o.z);
                    phi = yphi;
                    this.rotate3dPhiX = this.rotate3dPhiX * 0.95 + yphi * 0.05;
                    this.rotate3dPhiY = 0.0;
                }
                if (Math.abs(this.rotate3dx) > 1.0) {
                    this.rotate3direction = -1;
                    this.rotate3dx = 0.0;
                }
            }
            if (phi != 0.0) {
                CTransform3D tinv = this.getPainter().getInvRTransform();
                CTransform3D t = new CTransform3D();
                t.setTranslation(-o.x, -o.y, -o.z);
                tinv.setTranslation(o);
                tinv.mul(t);
                tinv.transform(a);
                Rotate.rotate(sel, o, a, phi);
            }
        }
        return phi;
    }

    private double rot3DAtomAxis() {
        DPoint3 o = (DPoint3)this.rotO.clone();
        DPoint3 a = (DPoint3)this.rotAxisPoint.clone();
        CTransform3D tr = this.getPainter().getRTransform();
        tr.transform(o);
        tr.transform(a);
        double yphi = this.ptrY - this.prevPtrY;
        double xphi = this.ptrX - this.prevPtrX;
        this.rotate3dPhiX = -(a.x - o.x);
        this.rotate3dPhiY = a.y - o.y;
        double df = xphi * this.rotate3dPhiY + yphi * this.rotate3dPhiX;
        Rotate.rotate(this.curfrag.getMainMoleculeGraph(), this.rotO, this.rotAxisPoint, df);
        return df;
    }

    private void prepareToMoveCurfrag(CTransform3D t, DPoint3 dptr) {
        t.setTranslation(dptr);
        DPoint3 o = this.rotO;
        o.x += dptr.x;
        o.y += dptr.y;
        o.z += dptr.z;
    }

    private void prepareToRotateCurfrag(CTransform3D t, int mod) {
        if ((mod & 1) == 0) {
            double df = this.getPointerAngleDiff();
            if (Math.abs(df) < 0.3490658503988659) {
                this.rotatePhi += df;
                double d = 0.2617993877991494;
                if (this.rotatePhi > d || this.rotatePhi < -d) {
                    df = Math.signum(this.rotatePhi);
                    t.setRotation(0.0, 0.0, 1.0, df * d);
                    t.setRotationCenter(this.rotO);
                    this.rotatePhi = 0.0;
                    this.rotateZPhi += df * d;
                }
            }
        } else {
            double r1 = this.rotO.distance(this.getPointerPos()) / 1.54;
            double r2 = this.rotO.distance(this.getPrevPointerPos()) / 1.54;
            double df = this.getPointerAngleDiff() * Math.min(r1 * r2, 1.0);
            if (Math.abs(df) < 0.3490658503988659) {
                t.setRotation(0.0, 0.0, 1.0, df);
                t.setRotationCenter(this.rotO);
                this.rotateZPhi += df;
            }
        }
    }

    public void rotateCurrentMoleculeTo15DegreesLine() {
        CTransform3D t = this.transformMatrix;
        t.setIdentity();
        if (!this.curfrag.isEmpty()) {
            if (this.flyingBondMol != null) {
                MolAtom fa = this.flyingBondMol.getAtom(1);
                MolAtom fo = this.flyingBondMol.getAtom(0);
                if (fa != null && fo != null) {
                    DPoint3 pa = fa.getLocation();
                    DPoint3 po = fo.getLocation();
                    double beta = pa.angle2D(po.x, po.y);
                    double df = -1.0 * Math.IEEEremainder(beta, 0.2617993877991494);
                    t.setRotation(0.0, 0.0, 1.0, df);
                    t.setRotationCenter(po);
                    this.flyingBondMol.transform(t);
                }
            } else {
                double df = 0.0;
                if (this.jointAtom != null) {
                    df = this.getAngleDiffTo15Degrees();
                } else if (this.moveMode == 2) {
                    df = -1.0 * Math.IEEEremainder(this.rotateZPhi, 0.2617993877991494);
                }
                t.setRotation(0.0, 0.0, 1.0, df);
                t.setRotationCenter(this.rotO);
                this.rotateZPhi += df;
                this.curfrag.transform(t);
                this.curfragMoved = true;
            }
        } else if (this.showMolecule != null) {
            DPoint3[] p = this.getPointsForRotationAngle();
            double beta = p[1].angle2D(p[0].x, p[0].y);
            double gamma = -1.0 * Math.IEEEremainder(beta, 0.2617993877991494);
            t.setRotation(0.0, 0.0, 1.0, gamma);
            t.setRotationCenter(p[0]);
            this.showMolecule.transform(t);
        }
    }

    public void clearIndexesToRot() {
        this.indexToRot = -1;
        this.pointIndexToRot = -1;
    }

    public void setIndexesToRot() {
        MoleculeGraph cmg = this.curfrag.getMainMoleculeGraph();
        int k = -1;
        boolean success = false;
        if (cmg != null && !cmg.isEmpty()) {
            MolAtom[] atoms = cmg.getAtomArray();
            double rmax = Double.MAX_VALUE;
            double min = Double.MAX_VALUE;
            for (int i = 0; i < atoms.length; ++i) {
                MolAtom a = atoms[i];
                if (a.getAtno() == 1) continue;
                DPoint3 pa = a.getLocation();
                this.getPainter().getRTransformRef().transform(pa);
                double r = Math.hypot(pa.x - this.ptrX, pa.y - this.ptrY);
                if (!(r < min)) continue;
                k = i;
                min = r;
            }
            if (min < rmax) {
                this.indexToRot = k;
                success = true;
            }
        }
        if (!success && this.curfrag.getObjectCount() > 1) {
            int[] indexes = this.findClosestObjectTo(this.curfrag, this.ptrX, this.ptrY);
            this.indexToRot = indexes[0];
            this.pointIndexToRot = indexes[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pointerDrag0(int mod) {
        MoleculeGraph mol = this.document.getMainMoleculeGraph();
        boolean dirty = false;
        Object object = mol.getLock();
        synchronized (object) {
            dirty = this.sketchMode.pointerDrag(mod);
            this.dragged = true;
        }
        return dirty ? 1 : 0;
    }

    public boolean isCopyDrag(int mod) {
        return !Environment.MACOS && (mod & 2) != 0 || Environment.MACOS && (mod & 8) != 0;
    }

    public SketchMode ctrlOptDrag(int x, int y) {
        PointedObject po = this.getPointedObject();
        Molecule mol = null;
        MDocument doc = null;
        SketchMode sm = null;
        if (!(this.hasSelection() && this.maybeDnDDrag() || po != null && po instanceof AtomPO || po != null && po instanceof BondPO || po != null && po instanceof MObjectPO)) {
            return null;
        }
        if (this.hasSelection() && this.maybeDnDDrag()) {
            mol = this.getMolSelection();
            sm = this.createSM(mol);
        } else if (po != null && po instanceof AtomPO) {
            MolAtom a = ((AtomPO)po).getAtom();
            MolAtom ma = (MolAtom)a.clone();
            ma.valenceCheck();
            mol = new Molecule(null, ma);
            sm = new MoleculeSM(this, mol);
        } else if (po != null && po instanceof BondPO) {
            MolBond pb = ((BondPO)po).getBond();
            MolAtom a1 = pb.getAtom1();
            MolAtom a2 = pb.getAtom2();
            mol = new Molecule(null, pb);
            mol.add(a1);
            mol.add(a2);
            sm = new MoleculeSM(this, mol);
        } else if (po != null && po instanceof MObjectPO) {
            MObject object = ((MObjectPO)po).getMObject();
            if (object instanceof MRectanglePoint) {
                object = ((MRectanglePoint)object).getParentRect();
            } else if (object instanceof MMidPoint) {
                object = ((MMidPoint)object).getParentLine();
            } else if (object instanceof MPoint) {
                MObject parentObject = null;
                List<MObject> list = this.document.getAllObjects();
                for (int i = 0; i < list.size() && parentObject == null; ++i) {
                    parentObject = object.isChildOf(list.get(i)) ? list.get(i) : null;
                }
                if (parentObject == null) {
                    return null;
                }
                object = parentObject;
            }
            if (this.getDocument().isExtraObject(object)) {
                return null;
            }
            this.getDocument().unhighlightAll();
            this.getDocument().setDraggedObject(null);
            this.getDocument().setFocus(null);
            MObject mo = (MObject)object.clone();
            mol = new Molecule();
            MDocument mdoc = new MDocument(mol);
            mdoc.addObject(mo);
            sm = (SketchMode)this.getSketchCanvas().callback("createMsm", mol);
        }
        MDocument mDocument = doc = mol != null ? mol.getDocument() : null;
        if (mol != null) {
            CTransform3D t = new CTransform3D();
            t.setIdentity();
            DPoint3 p = po instanceof MObjectPO ? this.getPainter().calcMolP(x, y) : (doc != null ? doc.calcCenter() : mol.calcCenter());
            mol.setLocation(p);
        }
        return sm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pointerEnterExit0(boolean enter) {
        Object object = this.document.getMainMoleculeGraph().getLock();
        synchronized (object) {
            this.mouseInside = enter;
            this.setPointedObject(null);
            this.setPntbond(null);
            this.pntSgroups = new Sgroup[0];
            if (this.piece != null && (this.piece.isBond() || ChainSM.isChain(this.piece))) {
                this.pntAB(false);
            }
        }
        return 1;
    }

    private int buttonDown0(boolean dblClick, int mod) {
        this.curfragMoved = false;
        return this.sketchMode.buttonDown(dblClick, mod);
    }

    public void rebuildReaction() {
        Molecule mol = this.getMol();
        RxnMolecule rxmol = RxnMolecule.getReaction(mol);
        if (rxmol != null) {
            rxmol.rebuildStructures();
        }
    }

    public boolean canHaveMoreBonds(MolAtom a0) {
        if (!(a0 instanceof SgroupAtom)) {
            return true;
        }
        SgroupAtom sa = (SgroupAtom)a0;
        SuperatomSgroup ss = sa.getSgroup();
        MolAtom[] free = ss.getFreeLegalAttachAtoms();
        return free.length != 0;
    }

    int branch(MolAtom a0) {
        Integer i;
        CallbackIface c = this.loadModule("AtomActions", null);
        if (c != null && (i = (Integer)c.callback("branch", a0)) != null) {
            return i;
        }
        return 0;
    }

    public boolean isBranchable(MolAtom a0) {
        if (a0 instanceof SgroupAtom) {
            return this.canHaveMoreBonds(a0);
        }
        if (a0.getImplicitHcount() == 0) {
            return false;
        }
        double x0 = a0.getX();
        double y0 = a0.getY();
        double z0 = a0.getZ();
        double epsilon = 0.0154;
        epsilon *= epsilon;
        for (int i = 0; i < a0.getBondCount(); ++i) {
            double z1;
            double dz10;
            double y1;
            double dy10;
            MolAtom a1 = a0.getLigand(i);
            double x1 = a1.getX();
            double dx10 = x1 - x0;
            if (dx10 * dx10 + (dy10 = (y1 = a1.getX()) - y0) * dy10 + (dz10 = (z1 = a1.getX()) - z0) * dz10 < epsilon) {
                return false;
            }
            for (int j = 0; j < a1.getBondCount(); ++j) {
                double z2;
                double dz20;
                double y2;
                double dy20;
                double x2;
                double dx20;
                MolAtom a2 = a1.getLigand(j);
                if (a2 == a0 || !((dx20 = (x2 = a2.getX()) - x0) * dx20 + (dy20 = (y2 = a2.getX()) - y0) * dy20 + (dz20 = (z2 = a2.getX()) - z0) * dz20 < epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public Molecule getPiece() {
        return this.piece;
    }

    public AtomPO getAtomPO() {
        AtomPO apo = this.getAtomPOForMenu();
        if (apo == null) {
            PointedObject po = this.getSelectionDoc().isEmpty() ? this.getPointedObject() : null;
            apo = po instanceof AtomPO ? (AtomPO)po : null;
        }
        return apo;
    }

    public BondPO getBondPO() {
        BondPO bpo = this.getBondPOForMenu();
        if (bpo == null) {
            PointedObject po = this.getSelectionDoc().isEmpty() ? this.getPointedObject() : null;
            bpo = po instanceof BondPO ? (BondPO)po : null;
        }
        return bpo;
    }

    private SgroupPO getSgroupPOfor(MolAtom atom) {
        return this.createPOFor(this.getMol().findSgroupOf(atom));
    }

    private SgroupPO getSgroupPOForObjects() {
        List<MObject> list = this.getSelectionDoc().getAllObjects();
        for (MObject mObject : list) {
            SgroupPO result = this.getSgroupPOFor(mObject);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private SgroupPO getSgroupPOFor(MObject mObject) {
        if (mObject instanceof MRectanglePoint) {
            return this.getSgroupPOFor(((MRectanglePoint)mObject).getParentRect());
        }
        if (mObject instanceof MBracket) {
            return this.createPOFor(this.findContainingSgroup((MBracket)mObject));
        }
        return null;
    }

    private SgroupPO createPOFor(Sgroup sg) {
        return sg != null ? new SgroupPO(sg) : null;
    }

    public SgroupPO getSgroupPOfor(BondPO bpo) {
        MolBond bond = bpo.getBond();
        SgroupPO spo = this.getSgroupPOfor(bond.getAtom1());
        if (spo == null) {
            this.getSgroupPOfor(bond.getAtom2());
        }
        return spo;
    }

    public SgroupPO getSgroupPO() {
        SgroupPO spo = this.getSgroupPOForMenu();
        if (spo == null) {
            spo = this.getPointedSgroupPO();
        }
        return spo;
    }

    private SgroupPO getPointedSgroupPO() {
        if (!this.getSelectionDoc().isEmpty()) {
            return null;
        }
        PointedObject po = this.getPointedObject();
        if (po instanceof SgroupPO) {
            return (SgroupPO)po;
        }
        if (po instanceof AtomPO) {
            return this.getSgroupPOfor(((AtomPO)po).getAtom());
        }
        if (po instanceof BondPO) {
            return this.getSgroupPOfor((BondPO)po);
        }
        if (po instanceof MObjectPO) {
            return this.getSgroupPOFor(((MObjectPO)po).getMObject());
        }
        return null;
    }

    public AtomPO getAtomPOForMenu() {
        MoleculeGraph m;
        if (this.getSelectionDoc().isSimpleMolecule() && (m = this.getSelectionMoleculeGraph()).isAtom()) {
            return new AtomPO(m.getAtom(0));
        }
        return null;
    }

    public BondPO getBondPOForMenu() {
        MoleculeGraph m;
        if (this.getSelectionDoc().isSimpleMolecule() && (m = this.getSelectionMoleculeGraph()).getAtomCount() <= 2 && m.getBondCount() == 1) {
            return new BondPO(m.getBond(0));
        }
        return null;
    }

    public SgroupPO getSgroupPOForMenu() {
        MoleculeGraph m = this.getSelectionMoleculeGraph();
        SgroupPO result = this.getSgroupPO(m);
        if (result == null) {
            result = this.getSgroupPOForObjects();
        }
        return result;
    }

    public SgroupPO getSgroupPO(MoleculeGraph m) {
        Sgroup sg = null;
        Molecule mol = this.getMol();
        for (int i = 0; i < m.getAtomCount(); ++i) {
            Sgroup g = mol.findSmallestSgroupContaining(m.getAtom(i));
            if (i == 0) {
                sg = g;
                continue;
            }
            if (sg == g) continue;
            if (g != null && sg != null && sg.isDescendantOf(g)) {
                sg = g;
                continue;
            }
            if (g != null && sg != null && g.isDescendantOf(sg)) continue;
            return null;
        }
        return sg != null ? new SgroupPO(sg) : null;
    }

    public PointedObject getObjectForMenu() {
        MSelectionDocument seldoc = this.getSelectionDoc();
        if (seldoc.isEmpty()) {
            MTextBox tbox = this.getFocusedMTextBox();
            return tbox != null ? new MObjectPO(tbox) : null;
        }
        if (seldoc.isSimpleMolecule()) {
            PointedObject po = null;
            po = this.getAtomPOForMenu();
            if (po != null) {
                return po;
            }
            po = this.getBondPOForMenu();
            if (po != null) {
                return po;
            }
            po = this.getSgroupPOForMenu();
            if (po != null) {
                return po;
            }
        } else if (seldoc.getObjectCount() == 2 && seldoc.getMainMoleculeGraph().isEmpty()) {
            for (int i = 0; i < 2; ++i) {
                MObject mo = seldoc.getObject(i);
                if (mo instanceof MChemicalStruct) continue;
                return this.createMObjectPO(mo);
            }
        }
        return null;
    }

    public PointedObject getObjectForPopup() {
        PointedObject po = this.getObjectForMenu();
        if (po != null) {
            return po;
        }
        return this.getSelectionDoc().isEmpty() ? this.getPointedObject() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Graphics2D g, Dimension d, int dispopts, boolean popvis, boolean saveImage, double relScale) {
        if (d.width <= 0 || d.height <= 0) {
            return;
        }
        MolEditor molEditor = this;
        synchronized (molEditor) {
            Point corner = this.getCorner();
            double origScale = this.getPainter().getScale();
            if (saveImage) {
                this.getPainter().setScale(origScale * relScale);
                this.getPainter().setCorner(new Point((int)((double)corner.x * relScale + 0.5), (int)((double)corner.y * relScale + 0.5)));
            } else {
                g.setColor(this.getPainter().getColors().getBackground());
                g.fillRect(0, 0, d.width, d.height);
            }
            this.sketchMode.prepareMolPaint();
            int prevdispopts = this.getPainter().getCommon().getDispopts();
            this.getPainter().getCommon().setDispopts(dispopts);
            this.alignNameTextBox(g, this.getMol().getDocument());
            if (g.getClip() == null) {
                g.setClip(0, 0, d.width, d.height);
            }
            PointedObject po = this.getPointedObject();
            if (this.isInAtomSelectionMode() && !this.prevCurfrag.isEmpty()) {
                Color c = new Color(153, 255, 102);
                this.paintShadowOnDocument(g, this.prevCurfrag, c);
            }
            if (po != null && po instanceof AtomPO && this.showMolecule != null) {
                MolAtom pnta = ((AtomPO)po).getAtom();
                if (pnta != null && pnta.getImplicitHcount() - pnta.getBondCount() <= 2) {
                    Molecule clonem = this.getMol().cloneMoleculeWithDocument();
                    MDocument mdoc = clonem.getDocument();
                    MolAtom cpnta = clonem.findAtomClone(pnta);
                    if (cpnta != null) {
                        if (cpnta instanceof SgroupAtom) {
                            cpnta.set(((Molecule)this.showMolecule.clone()).getAtom(0));
                        } else if (this.showMolecule.isSgroup()) {
                            Molecule mcf = MoleculeSM.cloneMol(this.showMolecule);
                            MolJoin j = new MolJoin(clonem, mcf, this.stickdst * 1.54, this.mergedst * 1.54, this.jointAtom, this.getPainter().getRTransformRef());
                            j.join(mcf, 32);
                        } else {
                            cpnta.setImplicitHcount(0);
                        }
                        MDocument.CheckerMark[] marks = this.getMol().getDocument().getCheckerMarks();
                        if (marks != null) {
                            for (MDocument.CheckerMark mark : marks) {
                                mdoc.addCheckerMark(mark);
                            }
                        }
                        this.getPainter().paintDocument(g, mdoc, this.getSelectionDoc());
                    } else {
                        this.getPainter().paintDocument(g, this.getMol().getDocument(), this.getSelectionDoc());
                    }
                } else {
                    this.getPainter().paintDocument(g, this.getMol().getDocument(), this.getSelectionDoc());
                }
            } else {
                this.getPainter().paintDocument(g, this.getMol().getDocument(), this.getSelectionDoc());
            }
            this.getPainter().paintMultipage(g, this.getMol().getDocument());
            this.getPainter().paintMultipageHeader(g, this.getMol().getDocument());
            if ((this.mouseInside || this.dragged) && !saveImage && (dispopts & 0x38) == 0) {
                this.getPainter().getCommon().setErrorVisible(false);
                MoleculeGraph frag = !this.curfrag.isEmpty() ? this.curfrag.getMainMoleculeGraph() : (this.piece != null ? this.piece : null);
                MoleculeGraph curfragmol = this.curfrag.getMainMoleculeGraph();
                MolJoin j = null;
                if (frag != null && this.sketchMode.isCurrentJoinHighlighted() && (this.piece == null || !this.piece.isBond() || curfragmol.isBond() || ChainSM.isChain(curfragmol))) {
                    MolAtom joint = this.moveMode == 2 || this.canRotCurfrag ? this.jointAtom : null;
                    for (int i = 0; i < frag.getAtomCount(); ++i) {
                        frag.getAtom(i).setCorners(0.0, 0.0, 0.0, 0.0);
                    }
                    j = new MolJoin(this.getMol(), frag, this.stickdst * 1.54, this.mergedst * 1.54, joint, this.getPainter().getRTransformRef());
                }
                if (po != null && (po instanceof AtomPO && ((AtomPO)po).getAtom() != null || po instanceof BondPO && ((BondPO)po).getBond() != null) && this.showMolecule != null && this.dragged) {
                    this.paintShowMoleculeWhileDrawing(g, this.showMolecule);
                } else if (this.curfrag.isEmpty()) {
                    this.paintAnythingOverSomethingElse(g, frag, j, popvis);
                } else if (this.piece != null && (this.piece.isBond() && curfragmol.isBond() || ChainSM.isChain(this.piece) && ChainSM.isChain(curfragmol) || this.atomBranchPiece != null)) {
                    this.paintBondWhileDrawing(g, frag, j, popvis);
                } else if (j != null && !popvis) {
                    this.sketchMode.hilitJoins(j, this.getPainter(), this.stickdst * 1.54, g);
                }
                this.getPainter().getCommon().setErrorVisible(true);
                if (this.sketchMode.isTemporaryObjectPaintingNeeded()) {
                    this.sketchMode.paintTemporaryObject(g);
                }
            }
            if ((this.mouseInside || this.dragged) && !saveImage && (dispopts & 0x38) == 0) {
                MObject mo = null;
                if (this.getPointedObject() != null && this.getPointedObject() instanceof MObjectPO) {
                    mo = ((MObjectPO)this.getPointedObject()).getMObject();
                }
                if (mo == null || mo != this.document.getFocus() && !mo.isInternalSelectable()) {
                    if (this.moveMode == 2 || this.moveMode == 0 && this.canRotCurfrag) {
                        this.getPainter().rot2dPic(this.rotO, this.curfragR, this.rotateZPhi, g, this.dragged);
                    } else if (this.moveMode == 3) {
                        DPoint3 o = this.rotO;
                        if (this.rotAxisPoint != null) {
                            o = new DPoint3((this.rotAxisPoint.x + this.rotO.x) / 2.0, (this.rotAxisPoint.y + this.rotO.y) / 2.0, (this.rotAxisPoint.z + this.rotO.z) / 2.0);
                        }
                        this.getPainter().rot3dPic(o, this.curfragR, this.rotate3dPhiX, this.rotate3dPhiY, this.rotate3dPhi, g, this.dragged, this.rotate3direction);
                    } else if (this.moveMode == 1 || this.moveMode == 0 && this.canMovCurfrag) {
                        this.getPainter().movPic(this.rotO, this.curfragR, g);
                    }
                }
                this.sketchMode.paintTemps1(g);
            }
            this.getPainter().getCommon().setDispopts(prevdispopts);
            if (saveImage) {
                this.getPainter().setScale(origScale);
                this.getPainter().setCorner(corner);
            }
        }
    }

    private void paintShadowOnDocument(Graphics2D g, MDocument doc, Color c) {
        MoleculeGraph molg = doc.getMainMoleculeGraph();
        MolAtom[] atoms = molg.getAtomArray();
        MolBond[] bonds = molg.getBondArray();
        if (atoms != null) {
            for (StereoConstants stereoConstants : atoms) {
                this.getPainter().paintAtomShadow(g, (MolAtom)stereoConstants, c);
            }
        }
        if (bonds != null) {
            for (StereoConstants stereoConstants : bonds) {
                this.getPainter().paintBondShadow(g, (MolBond)stereoConstants, c);
            }
        }
    }

    public void paintAnythingOverSomethingElse(Graphics2D g, MoleculeGraph frag, MolJoin j, boolean popvis) {
        Object co;
        Molecule mol = this.getMol();
        PointedObject po = this.getPointedObject();
        MolPainterCommon common = this.getPainter().getCommon();
        if (po != null && !((co = po.getContainedObject()) instanceof MObject)) {
            j = po.highlightMe(g, this.sketchMode, j, this.piece, this);
        }
        if (this.pntSgroups != null) {
            Sgroup smallest = this.pntSgroups.length > 0 ? this.pntSgroups[0] : null;
            for (int i = this.pntSgroups.length - 1; i >= 0; --i) {
                if (this.pntSgroups[i].getChildSgroupCount() != 0) continue;
                smallest = this.pntSgroups[i];
            }
            if (smallest != null && smallest.getType() != 14) {
                this.getPainter().hilitSgroup(mol, smallest, g);
            }
        }
        if (this.piece != null && po == null && !popvis) {
            MolBond bond;
            MolBond molBond = bond = this.piece.isBond() ? this.piece.getBond(0) : null;
            if (this.bondDraggedAlong) {
                if (bond != null) {
                    if (this.flyingBondMol == null) {
                        double l = 1.54;
                        this.regularize(this.piece.getAtom(0), this.piece.getAtom(1), l, this.ptrPhi + Math.PI);
                    }
                } else if (this.sketchMode instanceof ChainSM && ChainSM.isChainInHand(this.piece)) {
                    ChainSM sm = (ChainSM)this.sketchMode;
                    sm.regularizeChainInHand(this.piece, this.ptrPhi);
                }
            }
            common = this.getPainter().getCommon();
            int dispopts = common.getDispopts();
            int dispoptsExt = common.getDispoptsExt();
            int o = dispopts;
            int o2 = dispoptsExt;
            if (this.piece.isAtom() || this.piece.isBond()) {
                o &= 0xFFFFD5FF;
                o2 &= 0xFFFFFFF7;
            }
            if (this.sketchMode.isFloatingObjectPainted()) {
                common.setDispopts(o);
                common.setDispoptsExt(o2);
                MDocument piecedoc = this.piece.getDocument();
                if (piecedoc != null) {
                    this.getPainter().paintDocument(g, piecedoc, null);
                } else {
                    boolean lpvisible = common.areLonePairsVisible();
                    if (common.areLonePairsAutoCalc()) {
                        common.setLonePairsVisible(false);
                    } else {
                        common.setLonePairsVisible(true);
                    }
                    this.getPainter().paintMolecule(g, this.piece);
                    common.setLonePairsVisible(lpvisible);
                }
                common.setDispopts(dispopts);
                common.setDispoptsExt(dispoptsExt);
            }
        }
        if (j != null && !popvis) {
            double sr = this.stickdst * 1.54;
            this.sketchMode.hilitJoins(j, this.getPainter(), sr, g);
        }
    }

    private void paintBondWhileDrawing(Graphics2D g, MoleculeGraph frag, MolJoin j, boolean popvis) {
        Molecule mol = this.getMol();
        double sr = this.stickdst * 1.54;
        double mr = this.mergedst * 1.54;
        if (this.sketchMode.isCurrentJoinHighlighted() && this.flyingBondMol != null) {
            MolAtom[] p = null;
            MolJoin j2 = new MolJoin(mol, this.flyingBondMol, sr, mr, this.jointAtom, this.getPainter().getRTransformRef());
            p = j.getPrimary();
            MolAtom[] p2 = j2.getPrimary();
            if (p == null || p.length == 2 && p[1] == frag.getAtom(0)) {
                frag = this.flyingBondMol;
                j = j2;
                p = p2;
            }
        }
        MolAtom a = frag.getAtom(0);
        DPoint3 pa = a.getLocation();
        this.getPainter().getRTransformRef().transform(pa);
        double dx = this.ptrX - pa.x;
        double dy = this.ptrY - pa.y;
        if (dx * dx + dy * dy < sr * sr && frag.getAtomCount() <= 2) {
            MolAtom pnta;
            PointedObject po = this.getPointedObject();
            MolAtom molAtom = pnta = po != null && po instanceof AtomPO ? ((AtomPO)po).getAtom() : null;
            if (pnta != null) {
                this.getPainter().hilitAtom(mol, pnta, sr, g);
            } else {
                this.getPainter().hilitAtom(mol, a, sr, g);
            }
            j = null;
        } else {
            MolPainterCommon common = this.getPainter().getCommon();
            int dispopts = common.getDispopts();
            int dispoptsExt = common.getDispoptsExt();
            int o = dispopts & 0xFFFFF5FF;
            int o2 = dispoptsExt & 0xFFFFFFF7;
            common.setDispopts(o);
            common.setDispoptsExt(o2);
            this.getPainter().paintMolecule(g, frag);
            if (frag.getAtomCount() > 2 && ChainSM.isChain(frag)) {
                this.paintChainSize(g, frag);
            }
            common.setDispopts(dispopts);
            common.setDispoptsExt(dispoptsExt);
        }
        if (j != null && !popvis) {
            this.sketchMode.hilitJoins(j, this.getPainter(), sr, g);
        }
    }

    private void paintChainSize(Graphics2D g, MoleculeGraph m) {
        DPoint3 p = this.getPointerPos();
        int[] n = this.countAtomsInChain(m, this.mergedst * 1.54);
        String chainSizeString = n[1] > 0 ? new String(String.valueOf(n[0]) + "(" + String.valueOf(n[1]) + ")") : String.valueOf(n[0]);
        this.getPainter().drawTextNoSubscript(g, p, chainSizeString);
    }

    private int[] countAtomsInChain(MoleculeGraph mcf, double mr) {
        int[] chainSize = new int[2];
        chainSize[0] = mcf.getAtomCount();
        MolAtom[] atoms = mcf.getAtomArray();
        ArrayList<MolAtom> atomList = new ArrayList<MolAtom>();
        for (MolAtom atom : atoms) {
            MolAtom[] ratoms;
            if (atomList.contains(atom)) continue;
            for (MolAtom a : ratoms = mcf.getAtomArray()) {
                if (a == atom || !(a.getLocation().distance2D(atom.getLocation()) < mr)) continue;
                chainSize[0] = chainSize[0] - 1;
                atomList.add(a);
            }
        }
        chainSize[1] = atomList.size() - 1;
        return chainSize;
    }

    private void paintShowMoleculeWhileDrawing(Graphics2D g, MoleculeGraph frag) {
        MolPainterCommon common = this.getPainter().getCommon();
        common.setAttachmentPointsVisible(false);
        double sr = this.stickdst * 1.54;
        PointedObject po = this.getPointedObject();
        boolean pointtoSgroup = false;
        if (po != null) {
            if (po instanceof AtomPO && ((AtomPO)po).getAtom() != null) {
                MolAtom ha = ((AtomPO)po).getAtom();
                pointtoSgroup = ha instanceof SgroupAtom;
                pointtoSgroup = true;
                this.getPainter().hilitAtom(this.getMol(), ha, sr, g);
            } else if (po instanceof BondPO && ((BondPO)po).getBond() != null) {
                MolBond b = ((BondPO)po).getBond();
                this.getPainter().hilitBond(this.document.getMainMoleculeGraph(), b, sr, g);
            }
        }
        boolean skippainting = false;
        if (((Molecule)frag).isSgroup()) {
            boolean iscontracted = ((Molecule)frag).isGUIContracted();
            boolean bl = skippainting = iscontracted && pointtoSgroup;
        }
        if (!skippainting) {
            if (this.paintOnlyShowMolecule) {
                int dispopts = common.getDispopts();
                int o = dispopts | 0x40000000;
                common.setDispopts(o);
                this.getPainter().paintMolecule(g, frag);
                common.setDispopts(dispopts);
            } else {
                this.getPainter().paintMolecule(g, frag);
            }
        }
        common.setAttachmentPointsVisible(true);
    }

    public int getMolDim() {
        Molecule mol = this.getMol();
        int d = mol != null ? mol.getDim() : 0;
        return d >= 2 ? d : 2;
    }

    public int getUndo() {
        return this.history.getCapacity();
    }

    public void setUndo(int l) {
        this.history.setCapacity(l);
        this.historize();
    }

    public void clearHistory() {
        this.history.clear();
    }

    public void setHistory(History hist) {
        this.history = hist;
    }

    public History getHistory() {
        return this.history;
    }

    public boolean hasChanged() {
        return this.history.hasChanged();
    }

    public boolean isDocumentEdited() {
        return this.documentEdited;
    }

    public void setDocumentEdited() {
        this.documentEdited = true;
    }

    public boolean isUndoEnabled() {
        return this.history.isUndoable();
    }

    public synchronized boolean isRedoEnabled() {
        return this.history.isRedoable();
    }

    public synchronized boolean backInHistory() {
        if (this.history.isUndoable()) {
            this.history.back();
            return true;
        }
        return false;
    }

    public synchronized boolean undo() {
        MObject focusedo;
        if (!this.isNewKeyboardMotion()) {
            this.historize();
            this.setNewKeyboardMotion(true);
        }
        if ((focusedo = this.document.getFocus()) != null && focusedo instanceof MTextBox && !focusedo.isEmpty()) {
            this.historize();
        }
        Point oldCorner = this.history.getCorner();
        double oldScale = this.history.getScale();
        if (this.history.isUndoable()) {
            Molecule[] propChangeArgs = new Molecule[2];
            propChangeArgs[0] = this.history.getMolecule();
            MDocument doc = this.history.back();
            Point newCorner = this.history.getCorner();
            this.getPainter().setCorner(newCorner);
            double newScale = this.history.getScale();
            this.getPainter().setScale(newScale);
            this.setDocument(doc, true);
            this.edit(10);
            propChangeArgs[1] = this.getMol();
            this.fireMolPropertyChange(propChangeArgs);
            this.updateName(propChangeArgs[1], true);
            this.setHistorizeUnSelection(!this.getSelectionDoc().isEmpty());
            this.scrollBarVals = this.history.getScrollBarHist();
            this.getPainter().setRTransform(this.history.getRotationMatrix());
            double dist = oldCorner.distance(newCorner) / newScale;
            if (dist > 0.1 || oldScale != newScale) {
                this.setPreviousTransfMatrForUndo();
            }
            return true;
        }
        return false;
    }

    private void setPreviousTransfMatrForUndo() {
        MoleculeGraph[] molgToZoom = this.history.getMolGraphToZoom();
        boolean selectionToZoom = this.history.getSelectionToZoom();
        if (selectionToZoom || molgToZoom != null) {
            MoleculeGraph[] mg = selectionToZoom ? new MoleculeGraph[]{this.getSelectionMolecule()} : molgToZoom;
            this.getPainter().setBoundsFor(mg);
        } else {
            MDocument doc;
            boolean hadRGroupOrSelect = false;
            MoleculeGraph[] prevMolG = null;
            int countBack = 0;
            while (this.history.isUndoable() && !hadRGroupOrSelect) {
                doc = this.history.back();
                this.setDocument(doc, true);
                prevMolG = this.history.getMolGraphToZoom();
                if (this.history.getSelectionToZoom()) {
                    prevMolG = new MoleculeGraph[]{this.getSelectionMolecule()};
                }
                hadRGroupOrSelect = prevMolG != null;
                ++countBack;
            }
            if (!hadRGroupOrSelect) {
                this.getPainter().setBoundsXYRR(0.0, 0.0, 0.0, 0.0);
                this.getPainter().setIdentityTransform();
            } else {
                this.getPainter().setBoundsFor(prevMolG);
            }
            doc = this.history.forwardWith(countBack);
            this.getPainter().setRTransform(this.history.getRotationMatrix());
            this.setDocument(doc, true);
        }
    }

    public void setScrollBarValuesToHist(int xmin, int xmax, int ymin, int ymax) {
        if (this.historizeEnabled) {
            this.history.setScrollBarHist(xmin, xmax, ymin, ymax);
        }
    }

    public void saveScaleToHistory(double scale) {
        if (this.historizeEnabled) {
            this.history.setScale(scale);
        }
    }

    public int[] getScrollBarVals() {
        return this.scrollBarVals;
    }

    public MolAtom getPreviousAtom(int i, int delta) {
        MoleculeGraph m = this.history.getPreviousDocument(delta).getMainMoleculeGraph();
        m = m.getGraphUnion();
        return m.getAtom(i);
    }

    public synchronized boolean redo() {
        if (this.history.isRedoable()) {
            Point oldCorner = this.history.getCorner();
            double oldScale = this.history.getScale();
            Molecule[] propChangeArgs = new Molecule[2];
            propChangeArgs[0] = this.history.getMolecule();
            MDocument doc = this.history.forward();
            Point newCorner = this.history.getCorner();
            this.getPainter().setCorner(newCorner);
            double newScale = this.history.getScale();
            this.getPainter().setScale(newScale);
            this.scrollBarVals = this.history.getScrollBarHist();
            this.setDocument(doc, true);
            this.edit(10);
            propChangeArgs[1] = this.getMol();
            this.fireMolPropertyChange(propChangeArgs);
            this.updateName(propChangeArgs[1], true);
            this.setHistorizeUnSelection(!this.getSelectionDoc().isEmpty());
            MoleculeGraph[] molgToZoom = this.history.getMolGraphToZoom();
            boolean selectionToZoom = this.history.getSelectionToZoom();
            this.getPainter().setRTransform(this.history.getRotationMatrix());
            if (!(oldCorner.equals(newCorner) && oldScale == newScale || !selectionToZoom && molgToZoom == null)) {
                MoleculeGraph[] mg = selectionToZoom ? new MoleculeGraph[]{this.getSelectionMolecule()} : molgToZoom;
                this.getPainter().setBoundsFor(mg);
            }
            return true;
        }
        return false;
    }

    public void updateName(Molecule mol, boolean always) {
        MDocument doc = mol.getDocument();
        for (int i = doc.getObjectCount() - 1; i >= 0; --i) {
            String name;
            if (!(doc.getObject(i) instanceof MNameTextBox)) continue;
            MNameTextBox textBox = (MNameTextBox)doc.getObject(i);
            if (!always && (mol.getGrinvCC() == textBox.getGrinv() || mol.getGrinvCC() <= 0L)) continue;
            textBox.setGrinv(mol.getGrinvCC());
            try {
                name = MolExporter.exportToFormat(mol, "name");
            }
            catch (IOException e) {
                name = "A name cannot be generated for this structure";
            }
            textBox.setText(name);
            this.setToAlignNameTextBox();
        }
    }

    private void fireMolPropertyChange(Molecule[] propChangeArgs) {
        this.clearCachedMolBounds();
        this.getSketchCanvas().callback("fireMolPropertyChange", propChangeArgs);
    }

    public void internalError(Throwable ex) {
        this.setDocument(this.history.getDocument().cloneDocument(), true);
        this.getSketchCanvas().callback("internalError", ex);
    }

    public boolean setHistorizeEnabled(boolean v) {
        boolean old = this.historizeEnabled;
        this.historizeEnabled = v;
        return old;
    }

    public void historizeAfterZoom(boolean isSel, MoleculeGraph[] molg) {
        if (!this.historizeEnabled) {
            return;
        }
        this.historize();
        this.history.setSelectionToZoom(isSel);
        this.history.setMolGraphToZoom(molg);
    }

    public void clearLastSelectionToPrepareHistorizing() {
        this.lastSelectionDoc = null;
        this.lastSelectionCorner = null;
        this.lastSelectionScale = 0.0;
        this.selectionHistorized = false;
    }

    public void setLastSelectionToPrepareHistorizing() {
        if (!this.historizeEnabled) {
            return;
        }
        this.lastSelectionDoc = this.document.cloneDocument();
        this.lastSelectionCorner = this.getPainter().getCorner();
        this.lastSelectionScale = this.getPainter().getScale();
        this.selectionHistorized = this.lastSelectionDoc != null;
    }

    public void setHistorizeUnSelection(boolean histUnSel) {
        this.historizeUnSelection = histUnSel;
    }

    public boolean getHistorizeUnSelection() {
        return this.historizeUnSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void historize() {
        if (!this.historizeEnabled) {
            return;
        }
        Molecule[] propChangeArgs = new Molecule[]{this.history.getMolecule(), this.getMol()};
        MDocument doc = this.document;
        MoleculeGraph mol = doc.getMainMoleculeGraph();
        double scale = this.getPainter().getScale();
        if (this.hasSelection() && this.selectionHistorized) {
            this.history.historize(this.lastSelectionDoc, this.lastSelectionCorner, 0, this.lastSelectionScale, this.getPainter().getRTransform());
            this.history.setSelectionToZoom(false);
            this.history.setMolGraphToZoom(null);
            this.setHistorizeUnSelection(true);
        }
        this.clearLastSelectionToPrepareHistorizing();
        Object object = mol.getLock();
        synchronized (object) {
            this.history.historize(doc, this.getPainter().getCorner(), 0, scale, this.getPainter().getRTransform());
            this.history.setSelectionToZoom(false);
            this.history.setMolGraphToZoom(null);
        }
        if (!this.deserializing) {
            this.fireMolPropertyChange(propChangeArgs);
        }
        this.updateName(propChangeArgs[1], false);
        this.documentEdited = this.history.isUndoable() || this.history.isRedoable();
    }

    public void unhistorize() {
        this.history.unhistorize();
        this.setNewKeyboardMotion(true);
    }

    public void savePerformed() {
        this.documentEdited = false;
    }

    public boolean isBondDraggedAlong() {
        return this.bondDraggedAlong;
    }

    public void setBondDraggedAlong(boolean v) {
        this.bondDraggedAlong = v;
    }

    public void setDragged(boolean v) {
        this.dragged = v;
    }

    public boolean isDragged() {
        return this.dragged;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean maybeDnDDrag() {
        return (this.moveMode == 1 || this.canMovCurfrag && this.moveMode == 0) && !this.canRotCurfrag;
    }

    public SketchMode createSM(Molecule m) {
        boolean nodoc;
        MDocument doc = m.getDocument();
        boolean bl = nodoc = doc == null || doc.isSimpleMolecule();
        if (m.isAtom() && nodoc) {
            if (m.isSgroup()) {
                m = m.cloneMolecule();
                m.contractSgroups();
            }
            return new AtomSM(this, m.getAtom(0));
        }
        if (m.isBond() && nodoc) {
            return new BondSM(this, m.getBond(0));
        }
        if (ChainSM.isChain(m) && nodoc) {
            return new ChainSM(this);
        }
        return new MoleculeSM(this, m);
    }

    public SketchMode loadSM(String name, HourglassHandler hourglass) {
        SketchMode so = null;
        so = name.startsWith("chemaxon.") ? (SketchMode)MarvinModule.loadClass(name, hourglass) : (SketchMode)MarvinModule.load("sketch." + name, hourglass);
        if (so != null) {
            so.initSketchMode(this);
        }
        return so;
    }

    public MObjectSM loadSM(String name, MObject mo, HourglassHandler hourglass) {
        MObjectSM so = (MObjectSM)this.loadSM(name, hourglass);
        if (so != null) {
            so.initMObject(mo);
        }
        return so;
    }

    private CallbackIface getObjectOverwriter() {
        CallbackIface o = this.objectOverwriter;
        if (o == null) {
            this.objectOverwriter = o = this.loadModule("ObjectOverwriter", null);
        }
        return o;
    }

    private CallbackIface loadModule(String name, HourglassHandler hourglass) {
        String modname = "sketch." + name;
        CallbackIface c = (CallbackIface)MarvinModule.load(modname, hourglass);
        if (c != null) {
            c.callback("init", this);
        }
        return c;
    }

    private Object callMethod(String modmethod, Object arg) {
        int i = modmethod.lastIndexOf(46);
        String modname = modmethod.substring(0, i);
        CallbackIface mod = this.loadModule(modname, null);
        if (mod != null) {
            String method = modmethod.substring(i + 1);
            return mod.callback(method, arg);
        }
        return null;
    }

    public boolean callBoolean(String modmethod, Object arg) {
        Boolean r = (Boolean)this.callMethod(modmethod, arg);
        return r != null && r != false;
    }

    public int callInteger(String modmethod, Object arg) {
        Integer r = (Integer)this.callMethod(modmethod, arg);
        return r != null ? r : 0;
    }

    public SketchMode getSketchMode() {
        return this.sketchMode;
    }

    public boolean setSketchMode(SketchMode so, boolean changeSel) {
        return this.setSketchMode(so, changeSel, false);
    }

    public boolean setSketchMode(SketchMode so, boolean changeSel, boolean modchanged) {
        boolean changed = false;
        Molecule m = so != null ? so.getMol() : null;
        this.clearCurfrag();
        this.bondrawMode = false;
        this.atomBranchPiece = null;
        this.showMolecule = null;
        if (m != null && !m.isEmpty() || so instanceof MoleculeSM) {
            boolean[] r = this.pointToObjectAndChangeItsType(m, modchanged);
            changed |= r[1];
            if (!r[0]) {
                MDocument mdoc;
                this.sketchMode = so;
                this.setPiece0(MoleculeSM.cloneMol(m), m);
                MDocument mDocument = mdoc = m != null ? m.getDocument() : null;
                if ((mdoc == null || mdoc.isSimpleMolecule()) && ((m = this.piece).isAtom() || m.isBond())) {
                    if (m.isBond()) {
                        MolAtom a1 = this.piece.getAtom(0);
                        MolAtom a2 = this.piece.getAtom(1);
                        DPoint3 p = this.piece.getLocation();
                        a1.setXY(p.x, p.y);
                        a2.setXY(p.x + 1.54, p.y);
                        int f = m.getBond(0).getFlags();
                        if (m.getBond(0) instanceof QueryBond) {
                            this.lastQueryBondString = m.getBond(0).getQuerystr();
                        } else {
                            this.lastQueryBondString = null;
                            this.lastBondFlags = f;
                        }
                    }
                    if (changeSel && this.hasSelection()) {
                        changed = this.callBoolean("ChangeSelection.changeSelection", m);
                    }
                }
            }
        } else {
            this.sketchMode = so;
            this.setPiece0(null, null);
            int dispopts = this.getPainter().getCommon().getDispopts();
            if ((dispopts & 0x38) == 0 && so != null) {
                if (so.isRubber()) {
                    if (changeSel && !this.getSelectionDoc().isEmpty()) {
                        this.bondrawMode = false;
                        this.clearCurfrag();
                        this.edit(20);
                        return true;
                    }
                } else if (!so.isSelector()) {
                    this.unselect();
                }
            }
            this.document.unhighlightAll();
            this.setFocus(null);
        }
        this.initAtNewPos();
        if (changed) {
            this.historize();
        }
        if (this.sketchMode != null) {
            this.sketchMode.setNotifiy();
        }
        return changed;
    }

    private boolean[] pointToObjectAndChangeItsType(Molecule m, boolean modchanged) {
        MDocument mdoc = m.getDocument();
        boolean handled = false;
        boolean changed = false;
        PointedObject pnto = this.getPointedObject();
        if (pnto != null && (mdoc == null || mdoc.isSimpleMolecule())) {
            Object ret = null;
            if (m.isAtom() && m.getAtom(0) instanceof SgroupAtom && pnto instanceof AtomPO && modchanged) {
                handled = false;
                ret = false;
            } else if (m.isAtom() && pnto instanceof AtomPO) {
                ret = this.getObjectOverwriter().callback("overwriteAtom", new Object[]{pnto, m.getAtom(0)});
                handled = true;
            } else if (m.isBond() && pnto instanceof BondPO) {
                ret = this.getObjectOverwriter().callback("overwriteBond", new Object[]{pnto, m.getBond(0)});
                this.pntAB(false);
                handled = true;
            }
            if (ret != null) {
                changed = (Boolean)ret;
            }
        }
        return new boolean[]{handled, changed};
    }

    void setPiece0(Molecule p, Molecule orig) {
        if (p != null) {
            p.transform(this.getPainter().getInvRTransformRef());
        }
        this.piece = p;
        this.pieceOriginalObject = orig;
    }

    public void setPntbond(MolBond b) {
        BondPO bpo;
        PointedObject po = this.getPointedObject();
        BondPO bondPO = bpo = po instanceof BondPO ? (BondPO)po : null;
        if (b == null && bpo != null) {
            this.setPointedObject(null);
        } else if (b != null && (bpo == null || bpo.getBond() != b)) {
            this.setPointedObject(new BondPO(b));
        }
    }

    public PointedObject getPointedObject() {
        return this.pntObject;
    }

    public void setPointedObject(PointedObject po) {
        this.pntObject = po;
    }

    private void reset0() {
        this.setPointedObject(null);
        this.setPntbond(null);
        this.pntSgroups = new Sgroup[0];
        if (this.sketchMode != null) {
            this.sketchMode.reset();
        }
        this.canMovCurfrag = false;
        this.canRotCurfrag = false;
        this.setMoveMode(0, false);
        this.jointAtom = null;
        this.dragged = false;
        this.setAtomSelectionMode(0);
        if (this.prevCurfrag != null) {
            this.prevCurfrag.clear();
        }
    }

    public void clearCurfrag() {
        this.curfrag.clear();
        this.flyingBondMol = null;
        this.clearIndexesToRot();
    }

    private void convertBoardMolecule() {
        if (RxnMolecule.getReaction(this.piece) != null && RxnMolecule.getReaction(this.document.getMainMoleculeGraph()) == null) {
            RxnMolecule pieceRxn = RxnMolecule.getReaction(this.piece);
            MoleculeGraph molecule = this.document.getMainMoleculeGraph();
            if (molecule instanceof RgMolecule) {
                RgMolecule rgmol = (RgMolecule)molecule;
                Molecule m = rgmol.getRoot();
                RxnMolecule rxmol = RxnMolecule.createReaction(m, pieceRxn.getReactionArrow(), pieceRxn.getReactionArrowType());
                rgmol.setRoot(rxmol);
            } else if (molecule instanceof Molecule) {
                RxnMolecule rxmol = RxnMolecule.createReaction((Molecule)molecule, pieceRxn.getReactionArrow(), pieceRxn.getReactionArrowType());
                this.document.setMainMoleculeGraph(rxmol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putPiece() {
        this.convertBoardMolecule();
        Molecule mol = this.getMol();
        Object object = mol.getLock();
        synchronized (object) {
            int flag;
            MDocument scf;
            MolAtom a;
            int atno;
            MolJoin j;
            MDocument mcfdoc;
            if (this.piece == null) {
                return;
            }
            if (!this.piece.isEmpty()) {
                this.document.moveMainMoleculeGraphToFront();
            }
            if (this.pieceOriginalObject != null && this.pieceOriginalObject.getSgroupLigands() != null) {
                this.piece = MoleculeSM.cloneMol(this.pieceOriginalObject);
                MoleculeSM.moveTo(this.getPointerPos(), this.piece);
                ColorSetUtil.copyDefaultSetColor(this.getDocument(), this.piece);
            }
            Molecule mcf = MoleculeSM.cloneMol(this.piece);
            String sgrs = MPropHandler.convertToString(mcf.properties(), "sgroupState");
            if (this.piece.isSgroup() && sgrs != null) {
                if (sgrs.equals("expand")) {
                    mcf.expandSgroups();
                } else {
                    mcf.contractSgroups();
                }
            }
            if ((mcfdoc = mcf.getDocument()) == null) {
                mcfdoc = new MDocument(mcf);
            }
            this.setCurfrag(mcfdoc);
            this.removeSuperfluousAttachmentPoints(mcf);
            if (mol.getDocument() != null && mcf.getDocument() != null) {
                ColorSetUtil.mergeSets(mcf.getDocument(), mol.getDocument());
            }
            this.curfragJoin = j = new MolJoin(mol, mcf, this.stickdst * 1.54, this.mergedst * 1.54, this.jointAtom, this.getPainter().getRTransformRef());
            MolAtom[] pri = j.getPrimary();
            boolean isAtom = this.piece.isAtom();
            if (isAtom && ((atno = (a = this.piece.getAtom(0)).getAtno()) == 0 || atno == 209 || atno == 210 || atno == 138 && a.getRgroupAttachmentPointOrder() == -1) && pri == null) {
                this.bondrawMode = false;
                this.clearCurfrag();
                this.curfragJoin = null;
                mcf = null;
                return;
            }
            MolAtom atom = null;
            MolAtom patom = null;
            if (isAtom) {
                atom = pri != null ? pri[0] : mcf.getAtom(0);
                patom = pri != null ? pri[1] : mcf.getAtom(0);
            }
            if ((scf = this.join(j, this.curfrag, flag = this.piece.isAtom() ? 9 : 1)) != null) {
                this.setCurfrag(scf);
                this.restoreNonReactionIfPossible();
                if (patom != null && this.isAttachmentPointChanged(patom, atom)) {
                    this.addRgroupAttachment(atom);
                }
            } else if (atom != null) {
                atom.valenceCheck();
            }
            if (isAtom) {
                MolAtom pa;
                MolAtom a2 = this.document.getMainMoleculeGraph().contains(atom) ? atom : patom;
                PointedObject po = this.getPointedObject();
                if (po != null && po instanceof AtomPO && (pa = ((AtomPO)po).getAtom()) != a2 && pa.getLocation().equals(a2.getLocation())) {
                    this.setPointedObject(new AtomPO(a2));
                }
            }
            this.setMoveMode(0, false);
            Object[] g = this.calcRotGeom(this.curfrag);
            if (pri != null) {
                if (g.length > 1) {
                    boolean is3D = mol.getDim() == 3 || this.getPainter().getRTransform().is3d();
                    MolAtom[] sec = j.getSecondary();
                    if (pri.length == 2 && sec == null && !is3D) {
                        this.setMoveMode(2, false);
                        this.jointAtom = pri[1];
                        this.rotO.x = this.jointAtom.getX();
                        this.rotO.y = this.jointAtom.getY();
                        this.rotO.z = this.jointAtom.getZ();
                        this.curfragR = (Double)g[1];
                        this.rotateZPhi = 0.0;
                    } else if (is3D) {
                        this.rotO.x = pri[1].getX();
                        this.rotO.y = pri[1].getY();
                        this.rotO.z = pri[1].getZ();
                        if (pri.length == 2 && sec == null) {
                            this.setMoveMode(3, false);
                            this.setRotAxisPoint(this.curfrag, pri[1]);
                            this.setActualRotate3dPhiX_Y(false);
                            this.curfragR = (Double)g[1];
                        } else if (pri.length == 2 && sec != null && sec.length == 2) {
                            this.setMoveMode(3, false);
                            MolAtom axis = sec[1];
                            this.rotAxisPoint = new DPoint3(axis.getX(), axis.getY(), axis.getZ());
                            this.setActualRotate3dPhiX_Y(false);
                            this.curfragR = (Double)g[1];
                        }
                    }
                }
            } else if (g != null && g.length > 1) {
                this.setMoveMode(2, false);
                if (g[0] instanceof DPoint3) {
                    this.rotO = (DPoint3)g[0];
                }
                this.curfragR = (Double)g[1];
            }
        }
    }

    private boolean isAttachmentPointChanged(MolAtom patom, MolAtom atom) {
        return patom.getAtno() == 134 && this.rgroupIdOf(atom) == patom.getRgroup() || patom.getRgroupAttachmentPointOrder() == -1 && patom.getAtno() == 138;
    }

    private void removeSuperfluousAttachmentPoints(MoleculeGraph g) {
        MoleculeGraph umol = g.getGraphUnion();
        Molecule mol = g instanceof Molecule ? (Molecule)g : null;
        for (int i = 0; i < umol.getAtomCount(); ++i) {
            boolean inSg;
            MolAtom a = umol.getAtom(i);
            if (a.getAttach() == 0) continue;
            boolean bl = inSg = mol != null && mol.findSgroupContaining(a) != null;
            if (inSg) continue;
            a.setAttach(0);
            a.valenceCheck();
        }
    }

    public void setPaintOnlyShowMolecule(boolean onlyShow) {
        this.paintOnlyShowMolecule = onlyShow;
    }

    public void showPossibleMolecule(Molecule showMol, boolean onlyShow) {
        this.showPossibleMolecule(showMol, onlyShow, false);
    }

    public void showPossibleMolecule(Molecule showMol, boolean onlyShow, boolean spiroSg) {
        PointedObject po = this.getPointedObject();
        if (po instanceof AtomPO && !spiroSg) {
            MolAtom a = ((AtomPO)po).getAtom();
            MolAtom a1 = showMol.getAtom(0);
            DPoint3 pa1 = a1.getLocation();
            double phi = MolEditor.getInitialRotationAngle(a, a1);
            CTransform3D t = new CTransform3D();
            t.setRotation(0.0, 0.0, 1.0, phi);
            t.setRotationCenter(pa1);
            showMol.transform(t);
        }
        this.dragged = onlyShow;
        this.paintOnlyShowMolecule = onlyShow;
        this.showMolecule = showMol;
        this.atomBranchPiece = this.getPiece();
    }

    public boolean beginPossibleMoleculeDrawing(int mod) {
        DPoint3 pa = this.getPointerPos();
        if (this.showMolecule != null) {
            this.dragged = true;
            this.paintOnlyShowMolecule = false;
            DPoint3[] p = this.getPointsForRotationAngle();
            CTransform3D tinv = this.getPainter().getRTransform();
            CTransform3D t = new CTransform3D();
            t.setTranslation(-p[0].x, -p[0].y, -p[0].z);
            tinv.setTranslation(p[0]);
            tinv.mul(t);
            tinv.transform(pa);
            tinv.transform(p[0]);
            tinv.transform(p[1]);
            double alpha = pa.angle2D(p[0].x, p[0].y);
            double beta = p[1].angle2D(p[0].x, p[0].y);
            CTransform3D t1 = new CTransform3D();
            if ((mod & 1) != 0) {
                t1.setRotation(0.0, 0.0, 1.0, alpha - beta);
            } else {
                double df = 0.2617993877991494;
                t1.setRotation(0.0, 0.0, 1.0, (double)Math.round((alpha - beta) / df) * df);
            }
            t1.setRotationCenter(p[0]);
            CTransform3D t2 = this.getPainter().getInvRTransform();
            t2.mul(t1);
            t2.mul(this.getPainter().getRTransformRef());
            t2.setRotationCenter(p[0]);
            t1 = t2;
            this.showMolecule.transform(t1);
            return true;
        }
        return false;
    }

    private DPoint3[] getPointsForRotationAngle() {
        DPoint3[] points = new DPoint3[2];
        Molecule showMol = this.showMolecule.cloneMolecule();
        MolAtom ao = showMol.getAtom(0);
        MolAtom a = showMol.getAtom(1);
        if (showMol.getSgroupCount() > 0) {
            int sgatno = showMol.getSgroup(0).getAtomCount();
            int paratno = showMol.getSgroup(0).getParentMolecule().getAtomCount();
            if (paratno == sgatno) {
                SuperatomSgroup sg = (SuperatomSgroup)showMol.getSgroup(0);
                MolAtom[] attach = sg.getFreeLegalAttachAtoms();
                ao = attach[0];
                a = ao.getLigand(0);
            }
        }
        points[0] = ao.getLocation();
        points[1] = a.getLocation();
        return points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int endShowMoleculeDrawing() {
        if (this.showMolecule == null) {
            if (this.atomBranchPiece != null) {
                this.atomBranchPiece.moveTo(this.getPointerPos());
                this.setPiece0(this.atomBranchPiece, null);
                this.atomBranchPiece = null;
            }
            return 0;
        }
        double sr = this.stickdst * 1.54;
        double mr = this.mergedst * 1.54;
        Molecule mol = this.getMol();
        Object object = mol.getLock();
        synchronized (object) {
            CTransform3D trot = this.getPainter().getRTransformRef();
            int options = 5;
            if (this.showMolecule.getSgroupCount() > 0) {
                SuperatomSgroup sas = (SuperatomSgroup)this.showMolecule.getSgroup(0);
                if (sas.isExpanded()) {
                    MolAtom pnta;
                    PointedObject po = this.getPointedObject();
                    MolAtom molAtom = pnta = po instanceof AtomPO ? ((AtomPO)po).getAtom() : null;
                    if (pnta != null && pnta.getBondCount() == 1) {
                        if (!this.dragged) {
                            this.showMolecule.contractSgroups();
                            DPoint3 center = new DPoint3();
                            this.showMolecule.calcCenter(center);
                            this.showMolecule.setLocation(center);
                            this.showMolecule.moveTo(pnta.getLocation());
                            MolJoin j = new MolJoin(mol, this.showMolecule, sr, mr, null, trot);
                            j.join(this.showMolecule, options);
                            int sgn = mol.getSgroupCount();
                            ((SuperatomSgroup)mol.getSgroup(sgn - 1)).expand(0);
                        } else {
                            double[] savedmcoords = CleanUtil.createSavedCoordsArray(this.showMolecule);
                            CleanUtil.saveCoords(this.showMolecule, savedmcoords);
                            this.showMolecule.contractSgroups();
                            DPoint3 center = new DPoint3();
                            this.showMolecule.calcCenter(center);
                            this.showMolecule.setLocation(center);
                            this.showMolecule.moveTo(pnta.getLocation());
                            MolJoin j = new MolJoin(mol, this.showMolecule, sr, mr, null, trot);
                            j.join(this.showMolecule, options);
                            int sgn = mol.getSgroupCount();
                            ((SuperatomSgroup)mol.getSgroup(sgn - 1)).expand(0);
                            CleanUtil.restoreCoords(mol.getSgroup(sgn - 1).getSgroupGraph(), savedmcoords);
                        }
                    } else {
                        this.showMolecule.contractSgroups();
                        MolJoin j = new MolJoin(mol, this.showMolecule, sr, mr, null, trot);
                        j.join(this.showMolecule, options);
                        int sgn = mol.getSgroupCount();
                        ((SuperatomSgroup)mol.getSgroup(sgn - 1)).expand(0);
                    }
                } else {
                    MolJoin j = new MolJoin(mol, this.showMolecule, sr, mr, null, trot);
                    j.join(this.showMolecule, options);
                }
            } else {
                MolJoin j = new MolJoin(mol, this.showMolecule, sr, mr, null, trot);
                j.join(this.showMolecule, options);
            }
        }
        if (this.atomBranchPiece != null) {
            this.atomBranchPiece.moveTo(this.getPointerPos());
            this.setPiece0(this.atomBranchPiece, null);
            this.atomBranchPiece = null;
        }
        this.dragged = false;
        this.showMolecule = null;
        return 2;
    }

    public void clearShowMolecule() {
        this.showMolecule = null;
    }

    public boolean isShowMoleculeSet() {
        return this.showMolecule != null;
    }

    void beginBondDrawing(MolAtom a1, MolAtom a2) {
        this.beginBondDrawing(a1, a2, null);
    }

    void beginBondDrawing(Molecule bondMol) {
        this.beginBondDrawing(bondMol.getAtom(0), bondMol.getAtom(1), bondMol);
    }

    private void beginBondDrawing(MolAtom a1, MolAtom a2, Molecule bondMol) {
        PointedObject po;
        if (this.piece.getBondCount() < 1) {
            return;
        }
        Molecule mol = this.getMol();
        MolBond pb = this.piece.getBond(0);
        int atno2 = a2.getAtno();
        if (atno2 == 0) {
            atno2 = 6;
        }
        if ((po = this.getPointedObject()) != null && po instanceof AtomPO) {
            MolAtom a = ((AtomPO)po).getAtom();
            a1.setLocation(a.getLocation());
            this.thisBondlen = mol.getDesiredLength(a.getAtno(), atno2, pb.getType());
        } else {
            this.thisBondlen = mol.getDesiredLength(6, atno2, pb.getType());
        }
        if (bondMol == null) {
            bondMol = BondSM.createMolFromBond(pb, a1, a2);
        }
        this.setCurfrag(new MDocument(bondMol));
        this.flyingBondMol = bondMol.cloneMolecule();
        this.bondrawMode = true;
        this.doBondDrawing(0);
    }

    boolean doBondDrawing(int mod) {
        if (this.curfrag.getMainMoleculeGraph().getAtomCount() < 2) {
            return false;
        }
        MolAtom a = this.curfrag.getMainMoleculeGraph().getAtom(1);
        a.setLocation(this.getPointerPos());
        MolAtom a1 = this.flyingBondMol.getAtom(0);
        DPoint3 pa = a.getLocation();
        DPoint3 pa1 = a1.getLocation();
        if (a1.isPseudo()) {
            a.setAliasstr(a1.getAliasstr());
        }
        CTransform3D trot = this.getPainter().getRTransformRef();
        trot.transform(pa);
        trot.transform(pa1);
        double dx = pa.x - pa1.x;
        double dy = pa.y - pa1.y;
        double f = dx != 0.0 || dy != 0.0 ? Math.atan2(dy, dx) : 0.0;
        double df = 0.2617993877991494;
        double l = this.thisBondlen;
        if ((mod & 1) != 0) {
            this.regularize(a1, this.flyingBondMol.getAtom(1), l, f);
        } else {
            this.regularize(a1, this.flyingBondMol.getAtom(1), l, (double)Math.round(f / df) * df);
        }
        return this.ptrX != this.prevPtrX || this.ptrY != this.prevPtrY;
    }

    private void removeDuplicatedAtomsAndBondsInMol(MoleculeGraph mcf, double mr) {
        MolAtom[] atoms = mcf.getAtomArray();
        ArrayList<MolAtom> atomlist = new ArrayList<MolAtom>();
        for (MolAtom atom : atoms) {
            MolAtom[] ratoms;
            if (atomlist.contains(atom)) continue;
            for (MolAtom a : ratoms = mcf.getAtomArray()) {
                if (a == atom || !(a.getLocation().distance2D(atom.getLocation()) < mr)) continue;
                int bcount = a.getBondCount();
                ArrayList<MolBond> bondlista = new ArrayList<MolBond>();
                for (int i = 0; i < bcount; ++i) {
                    bondlista.add(a.getBond(i));
                }
                mcf.removeAtom(a);
                ArrayList<MolBond> bondlistatom = new ArrayList<MolBond>();
                int bn = atom.getBondCount();
                for (int i = 0; i < bn; ++i) {
                    bondlistatom.add(atom.getBond(i));
                }
                for (MolBond bond : bondlista) {
                    MolAtom othera = bond.getOtherAtom(a);
                    boolean addbond = true;
                    for (MolBond b : bondlistatom) {
                        MolAtom otheratom = b.getOtherAtom(atom);
                        if (otheratom == othera || !(otheratom.getLocation().distance2D(othera.getLocation()) < mr)) continue;
                        addbond = false;
                    }
                    if (!addbond) continue;
                    MolBond b = new MolBond(othera, atom);
                    mcf.add(b);
                }
                atomlist.add(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endBondOrChainDrawing() {
        boolean changed = false;
        double sr = this.stickdst * 1.54;
        double mr = this.mergedst * 1.54;
        Molecule mol = this.getMol();
        Object object = mol.getLock();
        synchronized (object) {
            boolean a2isjoin;
            MoleculeGraph mcf = this.curfrag.getMainMoleculeGraph();
            CTransform3D trot = this.getPainter().getRTransformRef();
            int jopts = 0;
            if (this.sketchMode instanceof ChainSM && mcf.getAtomCount() > 2) {
                this.removeDuplicatedAtomsAndBondsInMol(mcf, mr);
                this.removeDuplicatedAtomsAndBondsInMol(this.flyingBondMol, mr);
            }
            MolJoin j = new MolJoin(mol, mcf, sr, mr, this.jointAtom, trot, jopts);
            MolJoin j2 = new MolJoin(mol, this.flyingBondMol, sr, mr, this.jointAtom, trot, jopts);
            MolAtom[] pri = j.getPrimary();
            MolAtom[] pri2 = j2.getPrimary();
            MolAtom[] atoms = mcf.getAtomArray();
            MolAtom a1 = atoms[0];
            MolAtom a2 = atoms[1];
            if (pri == null || pri.length == 2 && pri[1] == a1) {
                this.setCurfrag(new MDocument(this.flyingBondMol));
                mcf = this.flyingBondMol;
                j = j2;
                pri = pri2;
            }
            this.checkRgroupAttachmentpoints(mol);
            if (pri != null && pri.length > 2 && !MolJoin.canBeBound(pri[2])) {
                return false;
            }
            atoms = mcf.getAtomArray();
            if (mcf.getBondCount() < 1) {
                return false;
            }
            MolBond b = mcf.getBond(0);
            a1 = b.getAtom1();
            a2 = b.getAtom2();
            DPoint3 pa1 = a1.getLocation();
            DPoint3 pa2 = a2.getLocation();
            trot.transform(pa1);
            trot.transform(pa2);
            double lscr = pa1.distance(pa2);
            double dx1 = this.ptrX - pa1.x;
            double dy1 = this.ptrY - pa1.y;
            double drsq1 = dx1 * dx1 + dy1 * dy1;
            int connections = pri != null ? pri.length / 2 : 0;
            boolean bl = a2isjoin = connections != 0 && pri != null && (pri[1] == a2 || connections == 2 && pri[3] == a2);
            if (drsq1 > 0.25 * lscr || !this.dragged || !(this.sketchMode instanceof ChainSM) || mcf.getAtomCount() > 2) {
                // empty if block
            }
            if (connections == 0) {
                if (a1.getAtno() == 0) {
                    a1.setAtno(6);
                }
                if (a2.getAtno() == 0) {
                    a2.setAtno(6);
                    PointedObject po = this.getPointedObject();
                    if (!(!(drsq1 < sr * sr) || po != null && po instanceof AtomPO || this.sketchMode instanceof ChainSM && mcf.getAtomCount() > 2)) {
                        pa2.x -= lscr - Math.cos(0.5235987755982988) * lscr;
                        pa2.y += Math.sin(0.5235987755982988) * lscr;
                        this.getPainter().getInvRTransformRef().transform(pa2);
                        a2.setLocation(pa2);
                    }
                }
            } else {
                if (pri != null && pri[1] != a1 && (connections == 1 || pri[3] != a1) && a1.getAtno() == 0) {
                    a1.setAtno(6);
                }
                if (!a2isjoin && a2.getAtno() == 0) {
                    a2.setAtno(6);
                }
            }
            if (atoms.length > 2) {
                for (int i = 1; i < atoms.length; ++i) {
                    if (atoms[i].getAtno() != 0) continue;
                    atoms[i].setAtno(6);
                }
            }
            MolBond[] C = j.getCorrupt();
            boolean okay = true;
            if (C != null) {
                for (int i = 0; i < C.length; ++i) {
                    if (C[i] != b) continue;
                    okay = false;
                    break;
                }
            }
            if (okay && lscr > sr) {
                int i;
                int options = 4;
                MDocument scf = this.join(j, this.curfrag, options);
                if (scf != null) {
                    this.setCurfrag(scf);
                }
                this.restoreNonReactionIfPossible();
                for (i = 0; i < atoms.length; ++i) {
                    atoms[i].valenceCheck();
                }
                if (!j.isJoin(a1) && a1.getZ() == 0.0 && j.isJoin(a2)) {
                    a1.setZ(a2.getZ());
                }
                if (pri != null) {
                    for (i = 0; i < pri.length; ++i) {
                        MolAtom a = pri[i];
                        if (a == a1 || a == a2 || a.getParent() == mcf) continue;
                        a.setImplicitHcount(0);
                        a.valenceCheck();
                    }
                }
                this.ungroupSgroupOf(b);
                changed = true;
            }
        }
        if (mol.getDim() < 3 && this.isTransform3D()) {
            mol.setDim(3);
        }
        if (changed) {
            this.historize();
        }
        this.pntAB(false);
        this.clearCurfrag();
        this.curfragJoin = null;
        this.setPntbond(null);
        this.bondrawMode = false;
        if (this.atomBranchPiece != null) {
            this.atomBranchPiece.moveTo(this.getPointerPos());
            this.setPiece0(this.atomBranchPiece, null);
            this.atomBranchPiece = null;
        }
        return changed;
    }

    private void checkRgroupAttachmentpoints(MoleculeGraph molecule) {
        MolAtom[] atoms;
        if (this.flyingBondMol == null) {
            return;
        }
        int order = molecule.getMaxRgroupAttachmentPointOrder();
        for (MolAtom atom : atoms = this.flyingBondMol.getAtomArray()) {
            if (atom.getAtno() != 138 || atom.getRgroupAttachmentPointOrder() != -1) continue;
            atom.setRgroupAttachmentPointOrder(order + 1);
            ++order;
        }
    }

    void beginChainDrawing(MolAtom a1) {
        PointedObject po = this.getPointedObject();
        MolAtom a2 = (MolAtom)a1.clone();
        if (po != null && po instanceof AtomPO) {
            MolAtom a = ((AtomPO)po).getAtom();
            a1.setLocation(a.getLocation());
        }
        this.thisBondlen = 1.54;
        Molecule chainMol = BondSM.createBondMol(1, a1, a2);
        this.setCurfrag(new MDocument(chainMol));
        this.flyingBondMol = chainMol.cloneMolecule();
        this.bondrawMode = true;
        this.doChainDrawing();
    }

    public boolean doChainDrawing() {
        return this.doChainDrawing(false);
    }

    boolean doChainDrawing(boolean curvedchainTool) {
        DPoint3 p = this.getPointerPos();
        DPoint3 pprev = this.getPrevPointerPos();
        Molecule chainMol = (Molecule)this.curfrag.getMainMoleculeGraph();
        int n = chainMol.getAtomCount();
        CTransform3D trot = this.getPainter().getRTransformRef();
        CTransform3D tinvrot = this.getPainter().getInvRTransformRef();
        if (!curvedchainTool) {
            ChainSM.regenerateChain(chainMol, p, pprev, trot, tinvrot);
        } else {
            MoleculeGraph mol = this.getDocument().getMainMoleculeGraph();
            ChainSM.regenerateChain(mol, chainMol, p, pprev, trot, tinvrot);
        }
        if (chainMol.getAtomCount() == n) {
            for (int i = 0; i < n; ++i) {
                DPoint3 pi = chainMol.getAtom(i).getLocation();
                this.flyingBondMol.getAtom(i).setLocation(pi);
            }
        } else {
            this.flyingBondMol = chainMol.cloneMolecule();
        }
        return this.ptrX != this.prevPtrX || this.ptrY != this.prevPtrY;
    }

    public int endArrowDrawing(MRArrow polyline, DPoint3 startPoint, DPoint3 endPoint) {
        MoleculeGraph mol = this.getDocument().getMainMoleculeGraph();
        RxnMolecule rxmol = null;
        DPoint3[] pos = new DPoint3[]{startPoint, endPoint};
        if (mol instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)mol;
            Molecule m = rgmol.getRoot();
            if (m instanceof RxnMolecule) {
                rxmol = (RxnMolecule)m;
                rxmol.rebuildStructures(pos, rxmol.getReactionArrowType());
            } else {
                if (mol instanceof RgMolecule) {
                    mol = ((RgMolecule)mol).getRoot();
                }
                rxmol = RxnMolecule.createReaction(mol, pos);
                rxmol.setReactionArrow(polyline);
                rgmol.setRoot(rxmol);
            }
        } else if (mol instanceof RxnMolecule) {
            rxmol = (RxnMolecule)mol;
            int type = ((ArrowSM.Reaction)this.sketchMode).getType();
            rxmol.rebuildStructures(pos, type);
        } else {
            rxmol = RxnMolecule.createReaction(mol, pos);
            rxmol.setReactionArrow(polyline);
            rxmol.setReactionArrowType(((ArrowSM.Reaction)this.sketchMode).getType());
            this.document.setMainMoleculeGraph(rxmol);
        }
        return 2;
    }

    public boolean canArrangeCrossingBond(MolBond b, int how) {
        if (this.getMolDim() == 2) {
            MoleculeGraph m = this.getMol().getGraphUnion();
            if (how == ARRANGE_FRONT) {
                return MolEditor.hasCrossing(b, m, m.indexOf(b) + 1, m.getBondCount());
            }
            if (how == ARRANGE_BACK) {
                return MolEditor.hasCrossing(b, m, 0, m.indexOf(b));
            }
        }
        return false;
    }

    private static boolean hasCrossing(MolBond b, MoleculeGraph m, int start, int end) {
        for (int i = start; i < end; ++i) {
            MolBond bb = m.getBond(i);
            DPoint3 p = MolPainter.crossing(m, b, bb);
            if (p == null) continue;
            return true;
        }
        return false;
    }

    public void arrangeCrossingBond(MolBond bond, int how) {
        MoleculeUtil.arrangeCrossingBonds(bond, this.getMol(), how == ARRANGE_FRONT);
        this.historize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pntAB(boolean sel) {
        Molecule mol = this.getMol();
        double sr = this.stickdst * 1.54;
        boolean dirty = false;
        Object object = mol.getLock();
        synchronized (object) {
            boolean rc = this.canRotCurfrag;
            boolean mc = this.canMovCurfrag;
            double rf = this.rotateZPhi;
            double cfr = this.curfragR;
            double rox = this.rotO.x;
            double roy = this.rotO.y;
            double roz = this.rotO.z;
            PointedObject prevObject = this.getPointedObject();
            int nPrevSgroups = this.pntSgroups.length;
            this.setPointedObject(null);
            this.document.unhighlightAll();
            MObject pobj = null;
            MObject parent_pobj = null;
            MolAtom patom = null;
            MolBond pbond = null;
            MolAtom[] p2atoms = null;
            Sgroup psgroup = null;
            this.canMovCurfrag = false;
            this.canRotCurfrag = false;
            SelectUtil selectUtil = this.sketchMode.getSelectUtil();
            if (!(this.moveMode != 0 || selectUtil != null && selectUtil.isSelecting())) {
                CTransform3D trot = this.getPainter().getRTransformRef();
                MolAtom patom_nl = null;
                if (this.sketchMode.canPointToAtom()) {
                    MolAtom[] pa = this.sketchMode.getPointableAtoms(mol);
                    patom = MolJoin.findNearAtom(pa, this.ptrX, this.ptrY, sr, true, trot);
                    patom_nl = MolJoin.findNearAtom(pa, this.ptrX, this.ptrY, sr, false, trot);
                }
                if (patom_nl == null) {
                    Object[] g;
                    if (patom == null && this.sketchMode.canPointToBond()) {
                        MolBond[] pb = this.sketchMode.getPointableBonds(mol);
                        pbond = MolJoin.findNearBond(pb, this.ptrX, this.ptrY, sr, trot);
                    }
                    if (pbond == null && this.sketchMode.canPointToAtomPair()) {
                        MolAtom[][] pp = this.sketchMode.getPointableAtomPairs(mol);
                        double c2 = this.sketchMode.getPointedAtomPairMinDstRatio2();
                        MolAtom[] a2 = MolJoin.findNearAtomPair(pp, this.ptrX, this.ptrY, sr, c2, trot);
                        if (patom == null || a2 != null) {
                            patom = null;
                            p2atoms = a2;
                        }
                    }
                    if (patom == null && sel && !this.dragged && !this.getSelectionDoc().isEmpty() && (g = this.calcRotGeom(this.getSelectionDoc())) != null && g.length == 2) {
                        this.rotateZPhi = 0.0;
                        if (g[0] instanceof DPoint3 && !this.isAxisSet) {
                            DPoint3 p = (DPoint3)g[0];
                            this.rotO.x = p.x;
                            this.rotO.y = p.y;
                            this.rotO.z = p.z;
                            this.jointAtom = null;
                        } else if (g[0] instanceof MolAtom && !this.isAxisSet) {
                            MolAtom p = (MolAtom)g[0];
                            this.rotO.x = p.getX();
                            this.rotO.y = p.getY();
                            this.rotO.z = p.getZ();
                            this.jointAtom = p;
                        }
                        double dx = this.ptrX - this.rotO.x;
                        double dy = this.ptrY - this.rotO.y;
                        double rsq = Math.sqrt(dx * dx + dy * dy);
                        double Rsq = (Double)g[1];
                        this.curfragR = Math.sqrt(Rsq);
                        if (this.getTheSelectedMTextBox() == null) {
                            this.canMovCurfrag = rsq < 0.5 * Rsq;
                            boolean bl = this.canRotCurfrag = rsq < Rsq && !this.canMovCurfrag && this.canTransformStructure();
                        }
                        if (this.canRotCurfrag || this.canMovCurfrag) {
                            pbond = null;
                            p2atoms = null;
                        }
                    }
                }
                MObject focus = this.document.getFocus();
                if (this.sketchMode.canPointToMObject() && (focus == null || focus.isSelected())) {
                    double[] dist = new double[1];
                    pobj = this.findObjectAt(this.ptrX, this.ptrY, dist);
                    if (pobj != null && dist[0] != 0.0) {
                        MPoint o = this.findPointAt(pobj, this.ptrX, this.ptrY);
                        if (o != null && o.isTransformable()) {
                            parent_pobj = pobj;
                            pobj = o;
                        }
                        dirty = true;
                    }
                    List<MObject> rrList = this.findRoundedRectanglesPointerIn(this.ptrX, this.ptrY);
                    for (int i = rrList.size() - 1; i >= 0; --i) {
                        MObject po = rrList.get(i);
                        if (po == null) continue;
                        MPoint o = this.findPointAt(po, this.ptrX, this.ptrY);
                        if (o != null && o.isTransformable()) {
                            parent_pobj = po;
                            pobj = o;
                        }
                        dirty = true;
                    }
                }
                if (this.sketchMode.canPointToSgroup() && !this.canRotCurfrag && !this.canMovCurfrag) {
                    psgroup = this.findSgroupAt(this.ptrX, this.ptrY);
                }
            }
            if (!this.canRotCurfrag && this.moveMode != 2) {
                this.jointAtom = null;
            }
            if (pobj != null && pbond != null && (pobj instanceof MBracket || parent_pobj instanceof MBracket)) {
                pbond = null;
                psgroup = null;
            }
            PointedObject po = null;
            if (patom != null) {
                po = new AtomPO(patom);
            } else if (pbond != null) {
                po = new BondPO(pbond);
            } else if (p2atoms != null) {
                po = new AtomPairPO(p2atoms, this.sketchMode.getAtomPairLocationWeights());
            } else if (psgroup != null) {
                po = new SgroupPO(psgroup);
                if (this.isDataSgroupLabelPointed) {
                    ((SgroupPO)po).isDataLabelPointed = true;
                }
            } else if (pobj != null) {
                po = this.createMObjectPO(pobj);
                this.document.highlight(pobj);
                if (parent_pobj != null) {
                    if (this.isReactionArrowMidPoint(pobj)) {
                        po = this.createMObjectPO(parent_pobj);
                    }
                    this.document.highlight(parent_pobj);
                }
            }
            if (prevObject == null && po != null || prevObject != null && (po == null || prevObject.getContainedObject() != po.getContainedObject()) || nPrevSgroups != this.pntSgroups.length || rc != this.canRotCurfrag || mc != this.canMovCurfrag || rf != this.rotateZPhi || rox != this.rotO.x || roy != this.rotO.y || roz != this.rotO.z || cfr != this.curfragR) {
                dirty = true;
            }
            this.setPointedObject(po);
            this.setPntbond(po != null && po instanceof BondPO ? pbond : null);
        }
        return dirty;
    }

    private MObjectPO createMObjectPO(MObject mo) {
        return new MObjectPO(mo);
    }

    public void setFreePieceMap() {
        int map = this.findFreeAtomMap();
        this.piece.getAtom(0).setAtomMap(map);
        this.pieceOriginalObject.getAtom(0).setAtomMap(map);
        ((AtomSM)this.sketchMode).getAtom().setAtomMap(map);
    }

    public int findFreeAtomMap() {
        int i;
        Molecule mol = this.getMol();
        MoleculeGraph umol = mol.getGraphUnion();
        for (i = 0; i < this.atomAtomMaps.length; ++i) {
            this.atomAtomMaps[i] = 0;
        }
        for (i = 0; i < umol.getAtomCount(); ++i) {
            MolAtom a = umol.getAtom(i);
            int n = a.getAtomMap();
            this.atomAtomMaps[n] = this.atomAtomMaps[n] + 1;
        }
        for (i = 1; i < this.atomAtomMaps.length; ++i) {
            if (this.atomAtomMaps[i] != 0) continue;
            return i;
        }
        return 0;
    }

    public MTextBox getFocusedMTextBox() {
        MTextBox res;
        MObject mo = this.document.getFocus();
        if (mo != null && mo instanceof MTextBox && (res = (MTextBox)mo).isEditable()) {
            return res;
        }
        return null;
    }

    public MObject findObjectAt(double x, double y, double[] dist) {
        MDocument doc = this.getDocument();
        MObject draggedObj = doc.getDraggedObject();
        MObject closest = null;
        MObject closestNonDragged = null;
        double dmin = Double.MAX_VALUE;
        double dminNonDragged = Double.MAX_VALUE;
        CTransform3D trot = this.getPainter().getRTransformRef();
        List<MObject> list = doc.getAllObjects();
        for (int i = list.size() - 1; i >= 0; --i) {
            MObject o = list.get(i);
            double d = o.distanceFrom(x, y, trot);
            if (d < dmin && d < this.stickdst * 1.54) {
                dmin = d;
                closest = o;
                if (doc.getDraggedObject() != o) {
                    closestNonDragged = o;
                }
            }
            if (draggedObj == null || o == draggedObj || draggedObj.isChildOf(o) || !(d < dminNonDragged) || !(d < this.stickdst * 1.54)) continue;
            dminNonDragged = d;
            closestNonDragged = o;
        }
        if (dist != null) {
            dist[0] = dmin;
        }
        return closestNonDragged != null ? closestNonDragged : closest;
    }

    public List<MObject> findRoundedRectanglesPointerIn(double x, double y) {
        MDocument doc = this.getDocument();
        CTransform3D trot = this.getPainter().getRTransformRef();
        List<MObject> list = doc.getAllObjects();
        ArrayList<MObject> rectList = new ArrayList<MObject>();
        for (int i = list.size() - 1; i >= 0; --i) {
            MObject o = list.get(i);
            if (!(o instanceof MRoundedRectangle) || !o.containsPoint(new DPoint3(x, y, 0.0), trot)) continue;
            rectList.add(o);
        }
        return rectList;
    }

    public MObject getContainerMObject(MObject o) {
        MDocument doc = this.getDocument();
        List<MObject> allObjects = doc.getAllObjects();
        for (MObject actObj : allObjects) {
            if (!o.isChildOf(actObj)) continue;
            return actObj;
        }
        return o;
    }

    public boolean ungroupSgroupOfAPO(MolAtom a, boolean ungroupMC) {
        Molecule mol;
        Sgroup sg;
        MoleculeGraph parent = a.getParent();
        if (parent instanceof Molecule && (sg = (mol = (Molecule)parent).findSmallestSgroupContaining(a)) != null && sg.getType() == 1) {
            return this.ungroupSgroupOf(a, ungroupMC);
        }
        return false;
    }

    public boolean ungroupSgroupOf(MolAtom a, boolean ungroupMC) {
        MulticenterSgroup sg;
        Molecule mol = this.getMol();
        Sgroup[] removableSgroups = MolJoin.getRemovableSgroups(a, mol);
        if (removableSgroups != null) {
            MolJoin.ungroupSgroupOf(mol, removableSgroups);
        }
        if ((sg = mol.findContainingMulticenterSgroup(a)) != null && ungroupMC) {
            mol.ungroupSgroup(sg);
        }
        this.removeUngroupedSgroups();
        return removableSgroups != null;
    }

    public void ungroupSgroupOf(MolBond b) {
        MolAtom atom1 = b.getAtom1();
        MolAtom atom2 = b.getAtom2();
        this.ungroupSgroupOf(atom1, false);
        this.ungroupSgroupOf(atom2, false);
    }

    private void removeUngroupedSgroups() {
        Sgroup sg;
        Molecule mol = this.getMol();
        PointedObject po = this.getPointedObject();
        if (po != null && po instanceof SgroupPO && mol.indexOf(sg = ((SgroupPO)po).getSgroup()) < 0) {
            this.setPointedObject(null);
        }
        ArrayList<Sgroup> v = new ArrayList<Sgroup>();
        for (int i = 0; i < this.pntSgroups.length; ++i) {
            if (mol.indexOf(this.pntSgroups[i]) < 0) continue;
            v.add(this.pntSgroups[i]);
        }
        this.pntSgroups = new Sgroup[v.size()];
        v.toArray(this.pntSgroups);
    }

    public int[] findClosestObjectTo(MDocument doc, double x, double y) {
        double dmax = Double.MAX_VALUE;
        int k = 0;
        int l = 0;
        CTransform3D trot = this.getPainter().getRTransformRef();
        for (int i = doc.getObjectCount() - 1; i >= 0; --i) {
            MObject tempo = doc.getObject(i);
            int n = tempo instanceof MRoundedRectangle ? 8 : tempo.getPointRefCount();
            for (int j = 0; j < n; ++j) {
                MPoint p = tempo.getPointRef(j, trot);
                if (p instanceof MMidPoint) continue;
                DPoint3 pp = p.getLocation(trot);
                double dx = pp.x - x;
                double dy = pp.y - y;
                double dsq = dx * dx + dy * dy;
                if (!(dsq < dmax)) continue;
                k = j;
                l = i;
                dmax = dsq;
            }
        }
        int[] ind = new int[]{l, k};
        return ind;
    }

    MPoint findPointAt(MObject o, double x, double y) {
        double dmaxsq = this.stickdst * 1.54;
        dmaxsq *= dmaxsq;
        MPoint q = null;
        CTransform3D trot = this.getPainter().getRTransformRef();
        for (int i = 0; i < o.getPointRefCount(); ++i) {
            MPoint p = o.getPointRef(i, trot);
            DPoint3 pp = p.getLocation(trot);
            double dx = pp.x - x;
            double dy = pp.y - y;
            double dsq = dx * dx + dy * dy;
            if (!(dsq < dmaxsq)) continue;
            q = p;
            dmaxsq = dsq;
        }
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sgroup findSgroupAt(double x, double y) {
        this.isDataSgroupLabelPointed = false;
        Molecule mol = this.getMol();
        double smallestarea = Double.MAX_VALUE;
        Sgroup smallest = null;
        this.pntSgroupsV.clear();
        Object object = mol.getLock();
        synchronized (object) {
            DPoint3 p = new DPoint3();
            CTransform3D trot = this.getPainter().getRTransformRef();
            for (int i = 0; i < mol.getSgroupCount(); ++i) {
                DataSgroup dsg;
                SuperatomSgroup supsg;
                Sgroup sg = mol.getSgroup(i);
                if (!sg.isVisible() || sg instanceof SuperatomSgroup && mol.contains((supsg = (SuperatomSgroup)sg).getSuperAtom())) continue;
                if (sg instanceof DataSgroup && this.isInDataSgroupLabel(dsg = (DataSgroup)sg, x, y)) {
                    smallestarea = 0.0;
                    smallest = sg;
                    this.pntSgroupsV.add(sg);
                    this.isDataSgroupLabelPointed = true;
                }
                double minxi = Double.MAX_VALUE;
                double minyi = Double.MAX_VALUE;
                double maxxi = -1.7976931348623157E308;
                double maxyi = -1.7976931348623157E308;
                for (int j = 0; j < sg.getAtomCount(); ++j) {
                    MolAtom a = sg.getAtom(j);
                    a.getLocation(p);
                    trot.transform(p);
                    if (p.x < minxi) {
                        minxi = p.x;
                    }
                    if (p.y < minyi) {
                        minyi = p.y;
                    }
                    if (p.x > maxxi) {
                        maxxi = p.x;
                    }
                    if (!(p.y > maxyi)) continue;
                    maxyi = p.y;
                }
                double d = this.stickdst * 1.54;
                minxi -= d;
                minyi -= d;
                maxxi += d;
                maxyi += d;
                if (!(x > minxi) || !(x < maxxi) || !(y > minyi) || !(y < maxyi)) continue;
                this.pntSgroupsV.add(sg);
                double area = (maxxi - minxi) * (maxyi - minyi);
                if (!(area < smallestarea)) continue;
                smallestarea = area;
                smallest = sg;
            }
            this.pntSgroups = new Sgroup[this.pntSgroupsV.size()];
            this.pntSgroupsV.toArray(this.pntSgroups);
            Sgroup.sort(this.pntSgroups, 2);
            return smallest;
        }
    }

    public boolean isInDataSgroupLabel(DataSgroup dsg, double x, double y) {
        DPoint3 p = new DPoint3();
        boolean isInDsgLabel = false;
        Rectangle labelBounds = MolPainter.getDataLabelBounds(dsg, this.getPainter().getNormalFontMetrics());
        if (dsg.isDataDetached()) {
            p = dsg.getAbsoluteXY();
            if (this.isInThisDataSgroupLabel(p, labelBounds, x, y)) {
                isInDsgLabel = true;
            }
        } else {
            for (int j = 0; j < dsg.getAtomCount(); ++j) {
                MolAtom atom = dsg.getAtom(j);
                atom.getLocation(p);
                if (!this.isInThisDataSgroupLabel(p, labelBounds, x, y)) continue;
                isInDsgLabel = true;
            }
        }
        return isInDsgLabel;
    }

    private boolean isInThisDataSgroupLabel(DPoint3 p, Rectangle labelBounds, double x, double y) {
        CTransform3D trot = this.getPainter().getRTransformRef();
        trot.transform(p);
        double scale = this.getPainter().getScale() / 1.54;
        DPoint3 p1 = new DPoint3(p.x + (double)labelBounds.x / scale, p.y - (double)labelBounds.y / scale, 0.0);
        double p2x = p.x + (double)(labelBounds.x + labelBounds.width) / scale;
        double p2y = p.y - (double)(labelBounds.y + labelBounds.height) / scale;
        DPoint3 p2 = new DPoint3(p2x, p2y, 0.0);
        boolean insideLabel = p1.x < x && x < p2.x && p2.y < y && y < p1.y;
        return insideLabel;
    }

    public MolBond setBondFlags(MolBond oldb, int flags) {
        MolAtom a1 = oldb.getAtom1();
        MolAtom a2 = oldb.getAtom2();
        MolBond b = new MolBond(a1, a2, flags);
        Molecule mol = this.getMol();
        SelectionMolecule sel = this.getSelectionMolecule();
        mol.replaceBond(oldb, b);
        sel.replaceBond(oldb, b);
        return b;
    }

    private void regularize(MolAtom a1, MolAtom a2, double l, double phi) {
        DPoint3 pa1 = a1.getLocation();
        this.getPainter().getRTransformRef().transform(pa1);
        DPoint3 pa2 = new DPoint3(pa1.x + l * Math.cos(phi), pa1.y + l * Math.sin(phi), pa1.z);
        this.getPainter().getInvRTransformRef().transform(pa2);
        a2.setLocation(pa2);
    }

    private static double getInitialRotationAngle(MolAtom a0, MolAtom a1) {
        double[] largest0 = GeomUtil.getLargestBondAngle2D(a0);
        double beta0 = largest0[0] + largest0[1] / 2.0;
        double[] largest1 = GeomUtil.getLargestBondAngle2D(a1);
        double beta1 = largest1[0] + largest1[1] / 2.0;
        return Math.PI + beta0 - beta1;
    }

    public void restoreMolFromReaction() {
        Molecule m;
        Molecule mol = this.getMol();
        RxnMolecule rxmol = null;
        RgMolecule rgmol = null;
        if (mol instanceof RxnMolecule) {
            rxmol = (RxnMolecule)mol;
        } else if (mol instanceof RgMolecule && (m = (rgmol = (RgMolecule)mol).getRoot()) instanceof RxnMolecule) {
            rxmol = (RxnMolecule)m;
        }
        if (rxmol != null) {
            if (rxmol.isSingleStepReaction()) {
                int i;
                m = new Molecule();
                for (i = 0; i < rxmol.getProductCount(); ++i) {
                    m.fuse(rxmol.getProduct(i));
                }
                for (i = 0; i < rxmol.getAgentCount(); ++i) {
                    m.fuse(rxmol.getAgent(i));
                }
                for (i = 0; i < rxmol.getReactantCount(); ++i) {
                    m.fuse(rxmol.getReactant(i));
                }
                m = m.cloneMolecule();
                if (rgmol != null) {
                    rgmol.setRoot(m);
                } else {
                    this.document.setMainMoleculeGraph(m);
                }
            } else {
                rxmol.rebuildStructures();
            }
        }
    }

    public void simplifyToMolecule() {
        Molecule m;
        Molecule mol = this.getMol();
        RxnMolecule rxmol = null;
        RgMolecule rgmol = null;
        if (mol instanceof RxnMolecule) {
            rxmol = (RxnMolecule)mol;
        } else if (mol instanceof RgMolecule && (m = (rgmol = (RgMolecule)mol).getRoot()) instanceof RxnMolecule) {
            rxmol = (RxnMolecule)m;
        }
        if (rxmol != null && rxmol.isSingleStepReaction()) {
            m = rxmol.simplifyToMolecule();
            if (rgmol != null) {
                rgmol.setRoot(m);
            } else {
                this.document.setMainMoleculeGraph(m);
            }
        }
    }

    public void restoreNonReactionIfPossible() {
        Molecule m;
        Molecule mol = this.getMol();
        RxnMolecule rxmol = null;
        RgMolecule rgmol = null;
        if (mol instanceof RxnMolecule) {
            rxmol = (RxnMolecule)mol;
        } else if (mol instanceof RgMolecule && (m = (rgmol = (RgMolecule)mol).getRoot()) instanceof RxnMolecule) {
            rxmol = (RxnMolecule)m;
        }
        if (rxmol != null) {
            if (rxmol.isSingleStepReaction()) {
                if (rxmol.getReactantCount() == 0 && rxmol.getProductCount() == 0 && rxmol.getAgentCount() == 0 && rxmol.getReactionArrow(false) == null) {
                    m = rxmol.simplifyToMolecule();
                    if (rgmol != null) {
                        rgmol.setRoot(m);
                    } else {
                        this.document.setMainMoleculeGraph(m);
                    }
                }
            } else if (rxmol.getReactionSteps().size() == 1) {
                m = new Molecule();
                List<Molecule> frags = rxmol.getAllFragments();
                Iterator<Molecule> fIter = frags.iterator();
                while (fIter.hasNext()) {
                    m.fuse(fIter.next());
                }
                if (rgmol != null) {
                    rgmol.setRoot(m);
                } else {
                    this.document.setMainMoleculeGraph(m);
                }
            }
        }
    }

    public void setIdentityTransform() {
        this.getPainter().setIdentityTransform();
        this.transformMatrix.setIdentity();
    }

    static SelectionMolecule createSelectionMol(MoleculeGraph m) {
        if (m instanceof Molecule) {
            m = m.getGraphUnion();
        }
        SelectionMolecule sel = new SelectionMolecule();
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = m.getAtom(i);
            if (!a.isSelected()) continue;
            MolEditor.selectAtom(a, sel);
        }
        return sel;
    }

    static MSelectionDocument createSelectionDoc(MDocument doc) {
        SelectionMolecule smol = MolEditor.createSelectionMol(doc.getMainMoleculeGraph());
        return new MSelectionDocument(smol);
    }

    public boolean isTransform3D() {
        CTransform3D t = this.getPainter().getRTransformRef();
        return t.m02 != 0.0 || t.m12 != 0.0 || t.m20 != 0.0 || t.m21 != 0.0;
    }

    private void initTransient() {
        this.ptrHistLen = 0;
        this.ptrHist = new double[200];
        this.atomAtomMaps = new int[1024];
        this.transformMatrix = new CTransform3D();
        this.pntSgroups = new Sgroup[0];
        this.pntSgroupsV = new ArrayList<Sgroup>();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.deserializing = true;
        this.initTransient();
        this.deserializing = false;
    }

    public void createLinkNode(int cmd, int index, int val) {
        MolAtom linkAtom = null;
        MoleculeGraph umol = this.getMol().getGraphUnion();
        int linkAtomIdx = index;
        int[] outers = new int[]{-1, -1};
        boolean defaultOuters = false;
        int min = 1;
        int max = 1;
        if (index == -1) {
            SelectionMolecule selectionMol = this.getSelectionMolecule();
            linkAtom = this.getMiddleSelectionAtom();
            linkAtomIdx = umol.indexOf(linkAtom);
            int k = 0;
            for (int i = 0; i < selectionMol.getAtomCount() && k < 2; ++i) {
                MolAtom atom = selectionMol.getAtom(i);
                if (atom == linkAtom) continue;
                outers[k] = linkAtom.getLigandIndex(atom);
                ++k;
            }
        } else {
            defaultOuters = true;
            linkAtom = umol.getAtom(index);
        }
        switch (cmd) {
            case 28: {
                max = val;
                min = linkAtom.getMinRepetitions();
                break;
            }
            case 27: {
                max = linkAtom.getMaxRepetitions();
                min = val;
                break;
            }
        }
        boolean changed = false;
        if (linkAtom != null && defaultOuters && linkAtom.getBondCount() >= 2) {
            umol.setLinkNodeDefaultOuters(linkAtom);
            changed = true;
        } else {
            if (!umol.isValidLinkNode(linkAtomIdx, outers[0], outers[1])) {
                throw new IllegalArgumentException("Link node cannot be created from the specified configuration!");
            }
            if (linkAtom != null && linkAtom.getLinkNodeOuterAtom(0) != outers[0]) {
                linkAtom.setLinkNodeOuterAtom(0, outers[0]);
                changed = true;
            }
            if (linkAtom != null && linkAtom.getLinkNodeOuterAtom(1) != outers[1]) {
                linkAtom.setLinkNodeOuterAtom(1, outers[1]);
                changed = true;
            }
        }
        if (linkAtom != null && linkAtom.getMaxRepetitions() != val) {
            linkAtom.setMaxRepetitions(max);
            changed = true;
        }
        if (linkAtom != null && linkAtom.getMinRepetitions() != val) {
            linkAtom.setMinRepetitions(min);
            changed = true;
        }
        if (changed) {
            this.historize();
        }
    }

    public MolAtom getMiddleSelectionAtom() {
        SelectionMolecule selectionMol = this.getSelectionMolecule();
        MolAtom linkAtom = null;
        for (int i = 0; i < selectionMol.getAtomCount(); ++i) {
            MolAtom linkAtomCandidate = selectionMol.getAtom(i);
            boolean isMiddleAtom = true;
            for (int i1 = 0; i1 < selectionMol.getAtomCount(); ++i1) {
                MolAtom atom = selectionMol.getAtom(i1);
                if (atom == linkAtomCandidate || atom.isBoundTo(linkAtomCandidate)) continue;
                isMiddleAtom = false;
                break;
            }
            if (!isMiddleAtom) continue;
            linkAtom = linkAtomCandidate;
            break;
        }
        return linkAtom;
    }

    public void setDataSgroupLabelMoving(boolean b) {
        this.dataSgroupLabelMoving = b;
    }

    public boolean isDataSgroupLabelMoving() {
        return this.dataSgroupLabelMoving;
    }

    public boolean moveDataSgroupLabel() {
        DPoint3 dptr = this.getPointerPosDiff();
        if (dptr.x == 0.0 && dptr.y == 0.0) {
            return false;
        }
        DPoint3 o = this.dataSgroupObject.getAbsoluteXY();
        o.x += dptr.x;
        o.y += dptr.y;
        o.z += dptr.z;
        this.dataSgroupObject.setAbsoluteXY(o);
        return true;
    }

    public DataSgroup getDataSgroupObject() {
        return this.dataSgroupObject;
    }

    public void setDataSgroupObject(DataSgroup dataSgroupObject) {
        this.dataSgroupObject = dataSgroupObject;
    }

    public void updateMultipage(Dimension size) {
        if (this.isMultipageEnabled()) {
            this.getPainter().updateMultipage(this.document.getPageSettings(), size);
        }
    }

    public double getHeightFitScale(Dimension size) {
        if (this.isMultipageEnabled()) {
            return this.getPainter().getHeightFitScale(size, this.document);
        }
        return 1.54;
    }

    public DPoint3 getSelectedMultipageCell() {
        if (this.isMultipageEnabled()) {
            PageSettings ps = this.document.getPageSettings();
            return this.getPainter().getSelectedMultipageCell(ps);
        }
        return new DPoint3(0.0, 0.0, 0.0);
    }

    public double getWidthFitScale(Dimension size) {
        if (this.isMultipageEnabled()) {
            return this.getPainter().getWidthFitScale(size, this.document);
        }
        return 1.54;
    }

    public Dimension getMultipageCellBounds() {
        Dimension bounds = new Dimension(0, 0);
        if (this.isMultipageEnabled()) {
            PageSettings ps = this.document.getPageSettings();
            return this.getPainter().getMultipageCellBounds(ps);
        }
        return bounds;
    }

    public Rectangle calcMultipageBoundingRectangle() {
        PageSettings ps = this.document.getPageSettings();
        Rectangle t = this.calcMolBoundingRectangle();
        if (ps.getColumnCount() == 0 || ps.getRowCount() == 0) {
            return t;
        }
        Point corner = this.getCorner();
        DPoint3 point1 = new DPoint3(ps.getUpperLeftPoint().x, ps.getUpperLeftPoint().y, 0.0);
        DPoint3 point2 = new DPoint3(ps.getUpperLeftPoint().x + (double)ps.getColumnCount() * ps.getWidth(), ps.getUpperLeftPoint().y + (double)ps.getRowCount() * ps.getHeight(), 0.0);
        this.getPainter().calcGP(point1);
        this.getPainter().calcGP(point2);
        int xmin = (int)Math.round(point1.x + (double)corner.x);
        int width = (int)Math.round(point2.x - point1.x);
        int ymin = (int)Math.round(point1.y + (double)corner.y);
        int height = (int)Math.round(point2.y - point1.y);
        int xmax = Math.max(xmin + width, t.x + t.width);
        int ymax = Math.max(ymin + height, t.y + t.height);
        xmin = Math.min(xmin, t.x);
        ymin = Math.min(ymin, t.y);
        return new Rectangle(xmin, ymin, Math.abs(xmax - xmin), Math.abs(ymax - ymin));
    }

    public boolean isMultipageEnabled() {
        if (this.document == null) {
            return false;
        }
        return this.document.getPageSettings().isMultiPageEnabled();
    }

    public void mergeBrackets() {
        ArrayList<MBracket> brackets = this.getBrackets();
        if (brackets.size() == 2) {
            Sgroup sg = this.findContainingSgroup(brackets.get(0));
            RepeatingUnitSgroup rsg = (RepeatingUnitSgroup)sg;
            MolBond[] xbonds = rsg.findCrossingBonds();
            MBracket br1 = brackets.get(0);
            MBracket br2 = brackets.get(1);
            MolBond[] crs1 = GeomUtil.getCrossingBonds(xbonds, br1.getPoint(0).getLocation(), br1.getPoint(3).getLocation(), true);
            MolBond[] crs2 = GeomUtil.getCrossingBonds(xbonds, br2.getPoint(0).getLocation(), br2.getPoint(3).getLocation(), true);
            if (crs1.length == 1 && crs2.length == 1) {
                rsg.mergeBrackets(crs1[0], crs2[0]);
                rsg.removeObject(br1);
                rsg.removeObject(br2);
                DrawingUtil.generateLadderBrackets(rsg, crs1[0], crs2[0], br1.getType());
            }
        }
        this.unselect();
        this.historize();
    }

    public void createMulticenter() {
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        Molecule p = (Molecule)sel.getAtom(0).getParent();
        if (this.isMulticenterCreationPossible()) {
            MulticenterSgroup sg = new MulticenterSgroup(p);
            this.addToSgroupHierarchy(p, sg, null);
            for (int i = 0; i < sel.getAtomCount(); ++i) {
                MolAtom a = sel.getAtom(i);
                if (a.getAtno() == 137) continue;
                p.setSgroupParent(a, sg, true);
            }
            sg.addCentralAtom();
        }
        this.unselect();
        this.historize();
    }

    public void addMarkushBond() {
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        Molecule p = (Molecule)sel.getAtom(0).getParent();
        if (this.isMulticenterCreationPossible()) {
            MulticenterSgroup sg = new MulticenterSgroup(p);
            this.addToSgroupHierarchy(p, sg, null);
            for (int i = 0; i < sel.getAtomCount(); ++i) {
                MolAtom a = sel.getAtom(i);
                if (a.getAtno() == 137) continue;
                p.setSgroupParent(a, sg, true);
            }
            GroupUtil.addMarkushBond(sg);
        }
        this.historize();
    }

    public void alignNameTextBox(Graphics2D g, MDocument doc) {
        if (doc == null) {
            return;
        }
        MoleculeGraph molg = doc.getMainMoleculeGraph();
        if (molg != null && molg instanceof Molecule) {
            Molecule mol = (Molecule)molg;
            for (int i = doc.getObjectCount() - 1; i >= 0; --i) {
                if (!(doc.getObject(i) instanceof MNameTextBox) || this.nameTextBoxAligned) continue;
                MNameTextBox textBox = (MNameTextBox)doc.getObject(i);
                this.getPainter().alignNameBox(g, mol, textBox);
                this.nameTextBoxAligned = true;
            }
        }
    }

    private MolBond findOutgoingBond() {
        if (this.getMolSelection().isEmpty()) {
            return null;
        }
        MolBond result = null;
        HashSet<MolAtom> atoms = new HashSet<MolAtom>(Arrays.asList(this.getSelectionDocument().getMainMoleculeGraph().getAtomArray()));
        for (MolAtom atom : atoms) {
            for (int i = 0; i < atom.getBondCount(); ++i) {
                MolBond b = atom.getBond(i);
                if (atoms.contains(b.getAtom1()) && atoms.contains(b.getAtom2())) continue;
                if (result == null) {
                    result = b;
                    continue;
                }
                return null;
            }
        }
        return result;
    }

    public void invokeSelectionChangedEvent() {
        boolean hasSelection;
        boolean bl = hasSelection = !this.getSelectionDoc().isEmpty();
        if (this.hasChanged() && hasSelection || this.hadSelection != hasSelection) {
            String s = hasSelection ? "selected" : "unselected";
            this.hadSelection = hasSelection;
            if (hasSelection) {
                this.getSelectionDoc().selectAllObjects(true);
            }
            this.getSketchCanvas().callback("fireSelectionPropertyChange", s);
        }
    }

    public boolean isReactionArrowMidPoint(MObject o) {
        MPolyline parentLine;
        boolean isRMidPoint = false;
        if (o instanceof MMidPoint && (parentLine = ((MMidPoint)o).getParentLine()) != null) {
            MDocument doc = this.getDocument();
            MoleculeGraph docMol = doc.getMainMoleculeGraph();
            if (docMol instanceof RgMolecule) {
                docMol = ((RgMolecule)docMol).getRoot();
            }
            isRMidPoint = parentLine instanceof MRArrow;
        }
        return isRMidPoint;
    }

    public boolean canTransformStructure() {
        if (!this.hasSelection()) {
            return true;
        }
        List<MolAtom> al = this.getStructureJoinAtoms(this.getSelectionDoc());
        int na = al.size();
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        int fragCount = sel.getFragCount(1);
        if (fragCount > 1) {
            return na == 0;
        }
        return na <= 1;
    }

    public boolean can3DRotateStructure() {
        if (!this.hasSelection()) {
            return false;
        }
        List<MolAtom> al = this.getStructureJoinAtoms(this.getSelectionDoc());
        int na = al.size();
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        int fragCount = sel.getFragCount(1);
        if (fragCount > 1) {
            return na == 0;
        }
        return na <= 2;
    }

    public boolean can3DRotateGroup() {
        if (!this.hasSelection()) {
            return false;
        }
        MoleculeGraph sel = this.getSelectionMoleculeGraph();
        int fragCount = sel.getFragCount(1);
        if (fragCount > 1) {
            return false;
        }
        List<MolAtom> al = this.getStructureJoinAtoms(this.getSelectionDoc());
        int na = al.size();
        return na == 1 || na == 2;
    }

    public List<MolAtom> getSelectedStructureJoinAtoms() {
        return this.getStructureJoinAtoms(this.getSelectionDocument());
    }

    public List<MolAtom> getStructureJoinAtoms(MDocument doc) {
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        MoleculeGraph molg = doc.getMainMoleculeGraph();
        for (int j = 0; j < molg.getAtomCount(); ++j) {
            MolAtom a = molg.getAtom(j);
            for (int k = a.getBondCount() - 1; k >= 0; --k) {
                if (molg.contains(a.getLigand(k))) continue;
                atoms.add(a);
                k = 0;
            }
        }
        return atoms;
    }

    public void setRotationOrigoPoint(DPoint3 p) {
        this.rotO = p;
    }

    public DPoint3 getRotationOrigoPoint() {
        return this.rotO;
    }

    public void setRotationAxisPoint(DPoint3 p) {
        this.rotAxisPoint = p;
    }

    public DPoint3 getRotationAxisPoint() {
        return this.rotAxisPoint;
    }

    public int setRotationAxisPoint() {
        if (this.isAxisSet) {
            return 0;
        }
        if (this.getSelectionDoc() != null) {
            List<MolAtom> al = this.getStructureJoinAtoms(this.getSelectionDoc());
            int na = al.size();
            if (na == 1) {
                this.rotO = al.get(0).getLocation();
                int nb = this.setRotAxisPoint(this.getSelectionDoc(), al.get(0));
                if (nb >= 3) {
                    return -1;
                }
            }
            if (na == 2) {
                this.rotO = al.get(0).getLocation();
                this.rotAxisPoint = al.get(1).getLocation();
            }
            return na;
        }
        return 0;
    }

    private int setRotAxisPoint(MDocument doc, MolAtom a) {
        MoleculeGraph molg = doc.getMainMoleculeGraph();
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        for (int k = a.getBondCount() - 1; k >= 0; --k) {
            if (molg.contains(a.getLigand(k))) continue;
            bonds.add(a.getBond(k));
        }
        int nb = bonds.size();
        if (nb == 1) {
            MolAtom oa = ((MolBond)bonds.get(0)).getOtherAtom(a);
            this.rotAxisPoint = oa.getLocation();
        } else if (nb == 2) {
            double d1;
            MolAtom oa0 = ((MolBond)bonds.get(0)).getOtherAtom(a);
            MolAtom oa1 = ((MolBond)bonds.get(1)).getOtherAtom(a);
            DPoint3 pa = a.getLocation();
            DPoint3 pa0 = oa0.getLocation();
            DPoint3 pa1 = oa1.getLocation();
            double d0 = pa.distance(pa0);
            if (d0 != (d1 = pa.distance(pa1))) {
                double p1x = pa.x + (pa1.x - pa.x) * d0 / d1;
                double p1y = pa.y + (pa1.y - pa.y) * d0 / d1;
                double p1z = pa.z + (pa1.z - pa.z) * d0 / d1;
                pa1.set(new DPoint3(p1x, p1y, p1z));
            }
            this.rotAxisPoint = new DPoint3((pa0.x + pa1.x) / 2.0, (pa0.y + pa1.y) / 2.0, (pa0.z + pa1.z) / 2.0);
        }
        return nb;
    }

    public boolean canFragmentPlanedIn3D() {
        if (!this.hasSelection()) {
            return false;
        }
        MolAtom[] aa = this.getSelectionDocument().getMainMoleculeGraph().getAtomArray();
        if (aa.length != 3) {
            return false;
        }
        MoleculeGraph molg = this.getMol().getGraphUnion();
        int[] fragIds = molg.getFragIds(1);
        int ind1 = molg.indexOf(aa[0]);
        int ind2 = molg.indexOf(aa[1]);
        int ind3 = molg.indexOf(aa[2]);
        return fragIds[ind1] == fragIds[ind2] && fragIds[ind2] == fragIds[ind3];
    }

    private boolean plane3DFragment() {
        CTransform3D t = new CTransform3D();
        MolAtom[] aa = this.getSelectionMoleculeGraph().getAtomArray();
        MoleculeGraph umol = this.getMol().getGraphUnion();
        SelectionMolecule frag = new SelectionMolecule();
        umol.findFrag(umol.indexOf(aa[0]), 1, frag);
        CTransform3D tinv = this.getPainter().getRTransform();
        DPoint3[] p = new DPoint3[3];
        double minz = Double.MAX_VALUE;
        int mini = 0;
        for (int i = 0; i < 3; ++i) {
            p[i] = aa[i].getLocation();
            tinv.transform(p[i]);
            if (!(Math.abs(p[i].z) < minz)) continue;
            minz = p[i].z;
            mini = i;
        }
        t.setTranslation(0.0, 0.0, -minz);
        CTransform3D t2 = this.getPainter().getInvRTransform();
        t2.mul(t);
        t2.mul(this.getPainter().getRTransformRef());
        frag.transform(t2);
        p[0] = aa[mini].getLocation();
        tinv.transform(p[0]);
        int ind1 = mini != 0 ? 0 : 1;
        p[1] = aa[ind1].getLocation();
        tinv.transform(p[1]);
        double phi = Math.atan2(p[1].z - p[0].z, p[1].x - p[0].x);
        if (phi > 1.5707963267948966) {
            phi -= Math.PI;
        } else if (phi < -1.5707963267948966) {
            phi += Math.PI;
        }
        CTransform3D t1 = new CTransform3D();
        t1.setRotation(0.0, 1.0, 0.0, phi);
        t1.setRotationCenter(p[0]);
        t2 = this.getPainter().getInvRTransform();
        t2.mul(t1);
        t2.mul(this.getPainter().getRTransformRef());
        frag.transform(t2);
        p[0] = aa[mini].getLocation();
        tinv.transform(p[0]);
        p[1] = aa[ind1].getLocation();
        tinv.transform(p[1]);
        double alpha = Math.atan2(p[0].y - p[1].y, p[0].x - p[1].x);
        t.setIdentity();
        t.setRotation(0.0, 0.0, 1.0, -alpha);
        t.setRotationCenter(p[0]);
        t2 = this.getPainter().getInvRTransform();
        t2.mul(t);
        t2.mul(this.getPainter().getRTransformRef());
        frag.transform(t2);
        p[0] = aa[mini].getLocation();
        tinv.transform(p[0]);
        int ind2 = mini == 2 ? 1 : 2;
        p[2] = aa[ind2].getLocation();
        tinv.transform(p[2]);
        phi = Math.atan2(p[2].z - p[0].z, p[2].y - p[0].y);
        if (phi > 1.5707963267948966) {
            phi -= Math.PI;
        } else if (phi < -1.5707963267948966) {
            phi += Math.PI;
        }
        t1.setIdentity();
        t1.setRotation(1.0, 0.0, 0.0, -phi);
        t1.setRotationCenter(p[0]);
        t2 = this.getPainter().getInvRTransform();
        t2.mul(t1);
        t2.mul(this.getPainter().getRTransformRef());
        frag.transform(t2);
        t.setIdentity();
        t.setRotation(0.0, 0.0, 1.0, alpha);
        t.setRotationCenter(p[0]);
        t2 = this.getPainter().getInvRTransform();
        t2.mul(t);
        t2.mul(this.getPainter().getRTransformRef());
        frag.transform(t2);
        return true;
    }

    public boolean canMirror(int cmd) {
        switch (cmd) {
            case 18: 
            case 19: 
            case 32: {
                return this.canTransformStructure();
            }
            case 33: {
                return this.canMirrorSelection();
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean canMirrorSelection() {
        if (!this.hasSelection()) {
            return false;
        }
        SelectionMolecule sel = this.getSelectionMolecule();
        if (sel.getFragCount(1) != 1) {
            return false;
        }
        return this.findOutgoingBond() != null;
    }

    private boolean mirrorSelection() {
        MolAtom[] plane;
        SelectionMolecule sel = this.getSelectionMolecule();
        if (this.createMirrorPlane(sel, plane = new MolAtom[3])) {
            Mirror.mirror((MoleculeGraph)sel, plane);
            return true;
        }
        return false;
    }

    private boolean createMirrorPlane(SelectionMolecule sel, MolAtom[] plane) {
        MolAtom selatom;
        MolBond bond = this.findOutgoingBond();
        if (bond == null) {
            return false;
        }
        plane[0] = bond.getAtom1();
        plane[1] = bond.getAtom2();
        MolAtom molAtom = sel.contains(plane[0]) ? plane[0] : (selatom = sel.contains(plane[1]) ? plane[1] : null);
        if (selatom == null) {
            return false;
        }
        for (int i = selatom.getBondCount(); i > 0; --i) {
            MolBond b = selatom.getBond(i - 1);
            if (b == null || b == bond) continue;
            plane[2] = (MolAtom)b.getOtherAtom(selatom).clone();
            if (!bond.isCollinear(plane[2])) continue;
            plane[2] = null;
        }
        if (plane[2] == null) {
            HashSet<MolAtom> atoms = new HashSet<MolAtom>(Arrays.asList(sel.getAtomArray()));
            for (MolAtom atom : atoms) {
                if (bond.isCollinear(atom)) continue;
                plane[2] = (MolAtom)atom.clone();
            }
        }
        if (plane[2] != null) {
            MoleculeGraph m = new MoleculeGraph();
            m.add(plane[2]);
            Rotate.rotate(m, plane[0].getLocation(), plane[1].getLocation(), 1.5707963267948966);
            return true;
        }
        return false;
    }

    public boolean canFlipSelection() {
        if (!this.hasSelection()) {
            return false;
        }
        return this.findOutgoingBond() != null;
    }

    private boolean flipSelection() {
        int i;
        MolBond bond = this.findOutgoingBond();
        if (bond == null) {
            return false;
        }
        MoleculeGraph molecule = this.getDocument().getMainMoleculeGraph();
        CTransform3D rotation = CleanUtil.createRotationAboutBond(bond, Math.PI);
        SelectionMolecule sel = new SelectionMolecule();
        for (i = 0; i < this.getSelectionMolecule().getAtomCount(); ++i) {
            sel.add(this.getSelectionMolecule().getAtom(i));
        }
        for (i = 0; i < this.getSelectionMolecule().getBondCount(); ++i) {
            sel.add(this.getSelectionMolecule().getBond(i));
        }
        sel.transform(rotation);
        molecule.setDim(molecule.getDim());
        return true;
    }

    public Sgroup getExtraSgroup(MolAtom atom) {
        Molecule mol = this.getMol();
        Sgroup hsg = null;
        if (atom.getAtno() == 137) {
            MulticenterSgroup sg;
            hsg = sg = mol.findContainingMulticenterSgroup(atom);
        } else {
            Sgroup psg;
            Sgroup sg = mol.findSmallestSgroupContaining(atom);
            if (sg != null && (psg = sg.getParentSgroup()) instanceof SuperatomSgroup) {
                if (sg.getType() == 14) {
                    if (psg.containsAllAtomsOf(sg) && psg.indexOf(((MulticenterSgroup)sg).getCentralAtom()) > -1) {
                        hsg = sg.getParentSgroup();
                    }
                } else if (!(sg instanceof Expandable) && sg.containsAllAtomsOf(psg)) {
                    hsg = sg.getParentSgroup();
                }
            }
        }
        return hsg;
    }

    public void updateMolecule() {
        Molecule mol = this.getMol();
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            SgroupUpdate.adjustSgroupContentToBrackets(mol, mol.getSgroup(i));
        }
    }

    public void setToAlignNameTextBox() {
        this.nameTextBoxAligned = false;
    }

    public CallbackIface getCanvas() {
        return this.getSketchCanvas();
    }

    private boolean doDirectedMerge() {
        SelectionMolecule fixed = new SelectionMolecule();
        SelectionMolecule fragment = new SelectionMolecule();
        Vector<MolAtom[]> atomPairs = this.getAssignments(fixed, fragment, true);
        if (atomPairs.size() > 0) {
            return this.doDirectedMerge(fixed, fragment, atomPairs);
        }
        return false;
    }

    private boolean doDirectedMerge(MoleculeGraph fixed, MoleculeGraph fragment, Vector<MolAtom[]> atomPairs) {
        Molecule molg = this.getMol();
        if (atomPairs.size() == 1) {
            MolAtom a0 = atomPairs.get(0)[0];
            MolAtom a1 = atomPairs.get(0)[1];
            DPoint3 p0 = a0.getLocation();
            DPoint3 p1 = a1.getLocation();
            DPoint3 dptr = new DPoint3(p0.x - p1.x, p0.y - p1.y, p0.z - p1.z);
            CTransform3D tr = new CTransform3D();
            tr.setTranslation(dptr);
            this.curfrag = fragment.getDocument();
            if (this.curfrag == null) {
                this.curfrag = new MDocument(fragment);
            }
            this.curfrag.transform(tr, 0, this.getPainter().getRTransformRef());
            molg.mergeAtoms(a1, a0);
            this.selectFragment(this.curfrag);
        } else if (atomPairs.size() > 1) {
            this.curfrag = fragment.getDocument();
            if (this.curfrag == null) {
                this.curfrag = new MDocument(fragment);
            }
            double d = DirectedMerge.align(fixed, this.curfrag.getMainMoleculeGraph(), atomPairs);
            double sr = this.stickdst * 1.54;
            double mr = this.mergedst * 1.54;
            if (atomPairs.size() == 2) {
                boolean aromatized = this.prepareJoinForMerge(fixed, fragment);
                MolAtom a0 = atomPairs.get(0)[0];
                MolAtom a1 = atomPairs.get(0)[1];
                this.rotO = a0.getLocation();
                molg.mergeAtoms(a1, a0);
                a0 = atomPairs.get(1)[0];
                a1 = atomPairs.get(1)[1];
                this.rotAxisPoint = a0.getLocation();
                this.isAxisSet = true;
                molg.mergeAtoms(a1, a0);
                MolAtom a = molg.findAtomClone(a1);
                a.setLocation(a0.getLocation());
                if (!aromatized) {
                    molg.dearomatize();
                }
                this.selectFragment(this.curfrag);
            } else if (atomPairs.size() == 3) {
                if (d < mr) {
                    MolJoin j = new MolJoin(molg, this.curfrag.getMainMoleculeGraph(), sr, mr, null, this.getPainter().getRTransformRef(), 40);
                    SelectionMolecule sj = j.join(this.curfrag.getMainMoleculeGraph(), 0);
                    if (sj == null) {
                        this.setDocument(this.history.getDocument(), true);
                        this.clearCurfrag();
                        return false;
                    }
                } else {
                    boolean aromatized = this.prepareJoinForMerge(fixed, fragment);
                    MolAtom a00 = atomPairs.get(0)[0];
                    MolAtom a01 = atomPairs.get(0)[1];
                    molg.mergeAtoms(a01, a00);
                    MolAtom a0 = atomPairs.get(1)[0];
                    MolAtom a1 = atomPairs.get(1)[1];
                    molg.mergeAtoms(a1, a0);
                    MolAtom a = molg.findAtomClone(a1);
                    a.setLocation(a0.getLocation());
                    this.rotO = a00.getLocation();
                    this.rotAxisPoint = a0.getLocation();
                    this.isAxisSet = true;
                    if (!aromatized) {
                        molg.dearomatize();
                    }
                    this.selectFragment(this.curfrag);
                }
            } else {
                this.setDocument(this.history.getDocument(), true);
                this.clearCurfrag();
                return false;
            }
        }
        return atomPairs.size() >= 1 && atomPairs.size() <= 3;
    }

    private boolean prepareJoinForMerge(MoleculeGraph fixed, MoleculeGraph fragment) {
        boolean isAromatic = false;
        for (int i = 0; i < fixed.getBondCount() && !isAromatic; ++i) {
            if (fixed.getBond(i).getType() != 4) continue;
            isAromatic = true;
        }
        if (!isAromatic) {
            fixed.aromatize();
        }
        fragment.aromatize();
        return isAromatic;
    }

    private void selectFragment(MDocument fragDocument) {
        if (fragDocument != null && !fragDocument.isEmpty()) {
            this.clearSelection();
            MoleculeGraph selmol = this.getSelectionMoleculeGraph();
            MoleculeGraph m = fragDocument.getMainMoleculeGraph();
            int na = m.getAtomCount();
            for (int j = 0; j < na; ++j) {
                MolEditor.selectAtom(m.getAtom(j), selmol);
            }
            this.invokeSelectionChangedEvent();
        }
    }

    public Vector<MolAtom[]> getAssignments(SelectionMolecule from, SelectionMolecule to, boolean remove) {
        Vector<MolAtom[]> atomPairs = new Vector<MolAtom[]>();
        MDocument doc = this.getMol().getDocument();
        Iterator<MObject> iterator = doc.getAllObjects().iterator();
        ArrayList<MAssigner> toRemove = new ArrayList<MAssigner>();
        while (iterator.hasNext()) {
            MObject object = iterator.next();
            if (!(object instanceof MAssigner)) continue;
            toRemove.add((MAssigner)object);
            MolAtom[] atomPair = null;
            for (int i = object.getPointCount() - 1; i >= 0; --i) {
                MolAtom[] atoms;
                MPoint p = object.getPoint(i);
                if (!(p instanceof MAtomSetPoint) || (atoms = ((MAtomSetPoint)p).getAtoms()).length != 1) continue;
                if (atomPair == null) {
                    atomPair = new MolAtom[2];
                    atomPair[0] = atoms[0];
                    continue;
                }
                atomPair[1] = atoms[0];
            }
            if (atomPair == null) continue;
            atomPairs.add(atomPair);
        }
        if (atomPairs.size() > 0) {
            MoleculeGraph molecule = ((MolAtom[])atomPairs.get(0))[0].getParent();
            molecule.findFrag(molecule.indexOf(atomPairs.get(0)[0]), 1, from);
            molecule.findFrag(molecule.indexOf(atomPairs.get(0)[1]), 1, to);
        }
        if (remove) {
            Iterator arrows = toRemove.iterator();
            while (arrows.hasNext()) {
                doc.removeObject((MObject)arrows.next());
            }
        }
        return atomPairs;
    }

    public boolean isDirectedMergeEnabled() {
        MDocument doc = this.getMol().getDocument();
        Iterator<MObject> iterator = doc.getAllObjects().iterator();
        int asno = 0;
        while (iterator.hasNext()) {
            MPolyline l;
            MObject object = iterator.next();
            if (!(object instanceof MPolyline) || !((l = (MPolyline)object) instanceof MAssigner)) continue;
            ++asno;
        }
        return asno > 0 && asno < 4;
    }

    public void setDeleteRemovesTerminalAtoms(boolean deleteRemovesTerminalAtoms) {
        this.deleteRemovesTerminalAtoms = deleteRemovesTerminalAtoms;
    }

    public boolean isDeleteRemovesTerminalAtoms() {
        return this.deleteRemovesTerminalAtoms;
    }

    public void addRgroupAttachment(MolAtom atom) {
        CallbackIface c = this.loadModule("AtomActions", null);
        if (c != null) {
            c.callback("rAttachmentBranch", atom);
        }
        this.historize();
    }

    public void setRgroupAttachmentPointOrder(MolAtom atom, int order) {
        GroupUtil.changeAttachmentPointOrder(atom, order);
        this.historize();
    }

    private void setAtomSelectionMode(int atomSelectionMode) {
        if (this.atomSelectionMode == atomSelectionMode) {
            return;
        }
        if (!this.isInAtomSelectionMode()) {
            this.prevCurfrag = this.getSelectionDoc().cloneDocument();
            this.clearSelection();
        }
        this.atomSelectionMode = atomSelectionMode;
    }

    private int getMaxSelectedAtomCount() {
        switch (this.atomSelectionMode) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    boolean isInAtomSelectionMode() {
        return this.atomSelectionMode != 0;
    }

    boolean canEndAtomSelectionMode() {
        return this.getMaxSelectedAtomCount() == this.getSelectionMolecule().getAtomCount();
    }

    void addToAtomSelection(MolAtom ... atoms) {
        if (atoms.length + this.getSelectionMolecule().getAtomCount() > this.getMaxSelectedAtomCount()) {
            return;
        }
        for (MolAtom a : atoms) {
            MolEditor.selectAtom(a, this.getSelectionMolecule());
        }
        this.getDocument().setObjectContainingSelection(null);
        this.getSelectionDocument().setObjectContainingSelection(null);
        this.clearCurfrag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endAtomSelectionMode() {
        if (this.atomSelectionMode == 0) {
            return;
        }
        Object object = this.getMol().getLock();
        synchronized (object) {
            switch (this.atomSelectionMode) {
                case 2: {
                    this.endAxisSelection();
                    break;
                }
                case 1: {
                    this.endCenterSelection();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.setAtomSelectionMode(0);
    }

    private void endCenterSelection() {
        MolAtom[] aa = this.getSelectionMolecule().getAtomArray();
        this.fusePrevCurf();
        Mirror.mirror((MoleculeGraph)this.getSelectionMolecule(), aa[0]);
    }

    private void endAxisSelection() {
        MolAtom[] aa = this.getSelectionMolecule().getAtomArray();
        this.setRotationOrigoPoint(aa[0].getLocation());
        this.setRotationAxisPoint(aa[1].getLocation());
        this.fusePrevCurf();
        this.setMoveMode(3, true);
        this.setActualRotate3dPhiX_Y(false);
    }

    private void fusePrevCurf() {
        MDocument prevCurf = this.prevCurfrag;
        this.unselect();
        MoleculeGraph prevsel = prevCurf.getMainMoleculeGraph();
        this.getSelectionMolecule().fuse(prevsel);
        this.setCurfrag(prevCurf);
        this.select();
    }

    private boolean invertSelection(boolean arbitary) {
        if (arbitary) {
            this.setAtomSelectionMode(1);
        } else {
            MoleculeGraph[] fragments;
            MoleculeGraph[] moleculeGraphArray;
            if (this.getSelectionMolecule().getFragCount(1) > 1) {
                moleculeGraphArray = this.getSelectionMolecule().findFrags(SelectionMolecule.class, 1);
            } else {
                MoleculeGraph[] moleculeGraphArray2 = new MoleculeGraph[1];
                moleculeGraphArray = moleculeGraphArray2;
                moleculeGraphArray2[0] = this.getSelectionMolecule();
            }
            for (MoleculeGraph fragment : fragments = moleculeGraphArray) {
                Mirror.mirror(fragment);
            }
        }
        return arbitary;
    }

    public void changeLigandOrder(MolAtom atom, MolBond bond, int value) {
        if (atom == null || bond == null) {
            return;
        }
        if (this.indexOf(atom) == -1 || atom.indexOf(bond) == -1) {
            return;
        }
        if (atom.getLigandOrder(bond.getOtherAtom(atom)) == value || value < 1 || value > atom.getBondCount()) {
            return;
        }
        GroupUtil.changeLigandOrder(bond, atom, value);
        this.historize();
    }

    public boolean canAlign(int cmd) {
        switch (cmd) {
            case 36: 
            case 37: {
                return this.getSelectionMolecule().getFragCount(2) + this.getSelectionDoc().getObjectCount() - 1 > 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean canDistribute(int cmd) {
        switch (cmd) {
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return this.getSelectionMolecule().getFragCount(2) + this.getSelectionDoc().getObjectCount() - 1 > 2;
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean alignObjects(int cmd) {
        MoleculeGraph[] fragments;
        if (this.getSelectionMolecule() == null || cmd != 36 && cmd != 37 && cmd != 40 && cmd != 41) {
            return false;
        }
        boolean horizontally = cmd == 36 || cmd == 40;
        MoleculeGraph mol = this.getMol();
        if (mol instanceof RgMolecule) {
            mol = ((RgMolecule)mol).getGraphUnion();
        }
        for (MoleculeGraph frag : fragments = this.getSelectionMolecule().findFrags(SelectionMolecule.class, 2)) {
            int i = mol.indexOf(frag.getAtom(0));
            mol.findFrag(i, 2, frag);
        }
        List<MObject> objects = this.getSelectionDoc().getAllObjects();
        Molecule[] agents = null;
        boolean hasAgent = false;
        boolean hasReactArrow = false;
        DPoint3[] arrowPoints = new DPoint3[2];
        mol = this.getMol();
        RxnMolecule rxnMol = RxnMolecule.getReaction(mol);
        if (rxnMol != null) {
            for (MObject mo : objects) {
                if (!(mo instanceof MRArrow)) continue;
                hasReactArrow = true;
                arrowPoints[0] = mo.getPoint(0).getLocation(this.getPainter().getRTransformRef());
                arrowPoints[1] = mo.getPoint(1).getLocation(this.getPainter().getRTransformRef());
            }
            agents = rxnMol.getAgents();
            if (agents.length > 0 && hasReactArrow) {
                hasAgent = true;
            }
        }
        double minCoord = Double.MAX_VALUE;
        double maxCoord = -1.7976931348623157E308;
        ArrayList<MoleculeGraph> selAgents = new ArrayList<MoleculeGraph>();
        ArrayList<MObject> selAgentText = new ArrayList<MObject>();
        for (MoleculeGraph fragment : fragments) {
            if (!hasAgent || rxnMol == null || rxnMol.getType(fragment) != 2) {
                double centerCoord;
                double[] minmax = this.calcFragmentMinMaxCoord(fragment, !horizontally);
                DPoint3 p = fragment.calcCenter();
                this.getPainter().getRTransformRef().transform(p);
                double d = centerCoord = horizontally ? p.y : p.x;
                if (centerCoord > (minmax[0] + minmax[1]) / 2.0) {
                    minmax[1] = minmax[0] + 2.0 * (centerCoord - minmax[0]);
                } else {
                    minmax[0] = minmax[1] - 2.0 * (minmax[1] - centerCoord);
                }
                minCoord = Math.min(minmax[0], minCoord);
                maxCoord = Math.max(minmax[1], maxCoord);
                continue;
            }
            selAgents.add(fragment);
        }
        for (MObject mobj : objects) {
            if (mobj instanceof MChemicalStruct) continue;
            DPoint3 p = new DPoint3();
            mobj.calcCenter(p, this.getPainter().getRTransformRef());
            if (!(mobj instanceof MTextBox) || !hasReactArrow || RxnMolecule.determineType(p.x, p.y, p.z, arrowPoints) != 2) {
                double maxC;
                double minC;
                double centerC;
                double[] xyminm = new double[4];
                xyminm[1] = Double.MAX_VALUE;
                xyminm[0] = Double.MAX_VALUE;
                xyminm[3] = -1.7976931348623157E308;
                xyminm[2] = -1.7976931348623157E308;
                mobj.updateBoundingRect(xyminm, this.getPainter().getRTransformRef());
                if (horizontally) {
                    centerC = p.y;
                    minC = xyminm[1];
                    maxC = xyminm[3];
                } else {
                    centerC = p.x;
                    minC = xyminm[0];
                    maxC = xyminm[2];
                }
                if (centerC > (minC + maxC) / 2.0) {
                    maxC = minC + 2.0 * (centerC - minC);
                } else {
                    minC = maxC - 2.0 * (maxC - centerC);
                }
                minCoord = Math.min(minC, minCoord);
                maxCoord = Math.max(maxC, maxCoord);
                continue;
            }
            selAgentText.add(mobj);
        }
        if (fragments.length - selAgents.size() + objects.size() - selAgentText.size() - 1 < 2) {
            return false;
        }
        double avCoord = (maxCoord + minCoord) / 2.0;
        CTransform3D ttrans = new CTransform3D();
        for (MoleculeGraph fragment : fragments) {
            if (selAgents.contains(fragment)) continue;
            DPoint3 p = fragment.calcCenter();
            this.getPainter().getRTransformRef().transform(p);
            ttrans.setIdentity();
            if (horizontally) {
                ttrans.setTranslation(0.0, avCoord - p.y, 0.0);
            } else {
                ttrans.setTranslation(avCoord - p.x, 0.0, 0.0);
            }
            CTransform3D t2 = this.getPainter().getInvRTransform();
            t2.mul(ttrans);
            t2.mul(this.getPainter().getRTransformRef());
            ttrans = t2;
            fragment.transform(ttrans);
        }
        for (MObject mobj : objects) {
            if (mobj instanceof MChemicalStruct || selAgentText.contains(mobj)) continue;
            DPoint3 p = new DPoint3();
            mobj.calcCenter(p, this.getPainter().getRTransformRef());
            ttrans.setIdentity();
            if (horizontally) {
                ttrans.setTranslation(0.0, avCoord - p.y, 0.0);
            } else {
                ttrans.setTranslation(avCoord - p.x, 0.0, 0.0);
            }
            CTransform3D t2 = this.getPainter().getInvRTransform();
            t2.mul(ttrans);
            t2.mul(this.getPainter().getRTransformRef());
            ttrans = t2;
            if (mobj instanceof MRArrow) {
                for (MoleculeGraph agent : selAgents) {
                    agent.transform(ttrans);
                }
                for (MObject mo : selAgentText) {
                    mo.transform(ttrans, 0, this.getPainter().getRTransformRef());
                }
            }
            mobj.transform(ttrans, 0, this.getPainter().getRTransformRef());
        }
        return true;
    }

    private double[] calcFragmentMinMaxCoord(MoleculeGraph fragment, boolean horizontally) {
        Rectangle rect = this.getPainter().getBoundsFor(new MoleculeGraph[]{fragment}, this.getPainter().getScale());
        DPoint3 minP = this.getPainter().calcMolP((int)rect.getMinX(), (int)rect.getMinY());
        this.getPainter().getRTransformRef().transform(minP);
        DPoint3 maxP = this.getPainter().calcMolP((int)rect.getMaxX(), (int)rect.getMaxY());
        this.getPainter().getRTransformRef().transform(maxP);
        double min = horizontally ? minP.x : maxP.y;
        double max = horizontally ? maxP.x : minP.y;
        return new double[]{min, max};
    }

    private boolean distributeObjects(int cmd) {
        MoleculeGraph[] fragments;
        if (this.getSelectionMolecule() == null || cmd != 38 && cmd != 39 && cmd != 40 && cmd != 41) {
            return false;
        }
        boolean horizontally = cmd == 38 || cmd == 40;
        MoleculeGraph mol = this.getMol();
        if (mol instanceof RgMolecule) {
            mol = ((RgMolecule)mol).getGraphUnion();
        }
        for (MoleculeGraph frag : fragments = this.getSelectionMolecule().findFrags(SelectionMolecule.class, 2)) {
            int i = mol.indexOf(frag.getAtom(0));
            mol.findFrag(i, 2, frag);
        }
        List<MObject> mobjects = this.getSelectionDoc().getAllObjects();
        Molecule[] agents = null;
        boolean hasAgent = false;
        boolean hasReactArrow = false;
        DPoint3[] arrowPoints = new DPoint3[2];
        mol = this.getMol();
        RxnMolecule rxnMol = RxnMolecule.getReaction(mol);
        if (rxnMol != null) {
            for (MObject mo : mobjects) {
                if (!(mo instanceof MRArrow)) continue;
                hasReactArrow = true;
                arrowPoints[0] = mo.getPoint(0).getLocation(this.getPainter().getRTransformRef());
                arrowPoints[1] = mo.getPoint(1).getLocation(this.getPainter().getRTransformRef());
            }
            agents = rxnMol.getAgents();
            if (agents.length > 0 && hasReactArrow) {
                hasAgent = true;
            }
        }
        int n = agents != null && hasAgent ? fragments.length + mobjects.size() - 1 - agents.length : fragments.length + mobjects.size() - 1;
        Vector<MyObjectDataMap> objdatas = new Vector<MyObjectDataMap>(n);
        ArrayList<MoleculeGraph> selAgents = new ArrayList<MoleculeGraph>();
        ArrayList<MObject> selAgentText = new ArrayList<MObject>();
        double minCoord = Double.MAX_VALUE;
        double maxCoord = -1.7976931348623157E308;
        for (MoleculeGraph fragment : fragments) {
            if (!hasAgent || rxnMol == null || rxnMol.getType(fragment) != 2) {
                DPoint3 p = fragment.calcCenter();
                this.getPainter().getRTransformRef().transform(p);
                double[] minmax = this.calcFragmentMinMaxCoord(fragment, horizontally);
                if (horizontally) {
                    objdatas.add(new MyObjectDataMap(p.x, minmax[1] - minmax[0], p.x - minmax[0], fragment));
                } else {
                    objdatas.add(new MyObjectDataMap(p.y, minmax[1] - minmax[0], p.y - minmax[0], fragment));
                }
                minCoord = Math.min(minmax[0], minCoord);
                maxCoord = Math.max(minmax[1], maxCoord);
                continue;
            }
            selAgents.add(fragment);
        }
        for (MObject mobj : mobjects) {
            if (mobj instanceof MChemicalStruct) continue;
            DPoint3 p = new DPoint3();
            mobj.calcCenter(p, this.getPainter().getRTransformRef());
            if (!(mobj instanceof MTextBox) || !hasReactArrow || RxnMolecule.determineType(p.x, p.y, p.z, arrowPoints) != 2) {
                double[] xyminm = new double[4];
                xyminm[1] = Double.MAX_VALUE;
                xyminm[0] = Double.MAX_VALUE;
                xyminm[3] = -1.7976931348623157E308;
                xyminm[2] = -1.7976931348623157E308;
                mobj.updateBoundingRect(xyminm, this.getPainter().getRTransformRef());
                if (horizontally) {
                    objdatas.add(new MyObjectDataMap(p.x, xyminm[2] - xyminm[0], p.x - xyminm[0], mobj));
                } else {
                    objdatas.add(new MyObjectDataMap(p.y, xyminm[3] - xyminm[1], p.y - xyminm[1], mobj));
                }
                minCoord = horizontally ? Math.min(xyminm[0], minCoord) : Math.min(xyminm[1], minCoord);
                maxCoord = horizontally ? Math.max(xyminm[2], maxCoord) : Math.max(xyminm[3], maxCoord);
                continue;
            }
            selAgentText.add(mobj);
        }
        if ((n -= selAgentText.size()) != objdatas.size() || n < 3) {
            return false;
        }
        Collections.sort(objdatas, new Comparator<MyObjectDataMap>(){

            @Override
            public int compare(MyObjectDataMap o1, MyObjectDataMap o2) {
                if (o1.center <= o2.center) {
                    return -1;
                }
                if (o1.center > o2.center) {
                    return 1;
                }
                throw new IllegalArgumentException("centers equal at sorting");
            }
        });
        double space = maxCoord - minCoord;
        for (MyObjectDataMap odata : objdatas) {
            space -= odata.width;
        }
        space /= (double)(n - 1);
        double ncenter = ((MyObjectDataMap)objdatas.firstElement()).center;
        for (int i = 1; i < n - 1; ++i) {
            MyObjectDataMap odata = (MyObjectDataMap)objdatas.elementAt(i);
            ncenter += ((MyObjectDataMap)objdatas.elementAt((int)(i - 1))).width - ((MyObjectDataMap)objdatas.elementAt((int)(i - 1))).part1 + space + odata.part1;
            CTransform3D ttrans = new CTransform3D();
            if (horizontally) {
                ttrans.setTranslation(ncenter - odata.center, 0.0, 0.0);
            } else {
                ttrans.setTranslation(0.0, ncenter - odata.center, 0.0);
            }
            CTransform3D t2 = this.getPainter().getInvRTransform();
            t2.mul(ttrans);
            t2.mul(this.getPainter().getRTransformRef());
            ttrans = t2;
            if (odata.myObject instanceof MoleculeGraph) {
                MoleculeGraph molg = (MoleculeGraph)odata.myObject;
                molg.transform(ttrans);
                continue;
            }
            if (!(odata.myObject instanceof MObject)) continue;
            MObject mobj = (MObject)odata.myObject;
            if (mobj instanceof MRArrow) {
                for (MoleculeGraph agent : selAgents) {
                    agent.transform(ttrans);
                }
                for (MObject mo : selAgentText) {
                    mo.transform(ttrans, 0, this.getPainter().getRTransformRef());
                }
            }
            mobj.transform(ttrans, 0, this.getPainter().getRTransformRef());
        }
        return true;
    }

    private boolean alignAndDistributeObjects(int cmd) {
        return this.alignObjects(cmd) && this.distributeObjects(cmd);
    }

    private void clearSelection() {
        this.getSelectionDoc().clear();
    }

    private CallbackIface getSketchCanvas() {
        return this.sketchCanvas;
    }

    private void setSketchCanvas(CallbackIface sketchCanvas) {
        this.sketchCanvas = sketchCanvas;
    }

    private MSelectionDocument getSelectionDoc() {
        return this.selectionDoc;
    }

    private void setSelectionDoc(MSelectionDocument selectionDoc) {
        this.selectionDoc = selectionDoc;
        this.setNewKeyboardMotion(true);
    }

    public boolean isNewKeyboardMotion() {
        return this.newKeyboardMotion;
    }

    public void setNewKeyboardMotion(boolean newKeyboardMotion) {
        this.newKeyboardMotion = newKeyboardMotion;
    }

    private static class MyObjectDataMap {
        double center;
        double width;
        double part1;
        Object myObject;

        public MyObjectDataMap(double center, double width, double part1, Object myObject) {
            this.center = center;
            this.width = width;
            this.part1 = part1;
            this.myObject = myObject;
        }
    }
}

