/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.sketch.BondMerger;
import chemaxon.marvin.sketch.JoinPointFilter;
import chemaxon.marvin.sketch.OwnMultiCenterFilter;
import chemaxon.marvin.sketch.modules.SgroupUpdate;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MolJoin
implements Serializable {
    private static final long serialVersionUID = 1880834186820654343L;
    public static final int AROMATIC = 1;
    public static final int AUTOH = 2;
    public static final int BOND = 4;
    public static final int LOCAL_MERGE = 8;
    public static final int TEMPLATE = 16;
    public static final int SIMPLE_MERGE = 32;
    public static final String PRIMARY = "primary";
    public static final String SECONDARY = "secondary";
    private Molecule that;
    private MoleculeGraph other;
    private MoleculeGraph tother = null;
    private List<MolAtom> atoms = new ArrayList<MolAtom>();
    private List<MolBond> bonds = new ArrayList<MolBond>();
    private MolAtom[] pri;
    private MolAtom[] sec;
    private MolBond[] corrupt;
    private double mergedst;
    private int theFindOptions;
    private static final int CMD_SUM = 0;
    private static final int CMD_MIN = 1;
    public static final int SKIP_H = 1;

    public MolJoin(Molecule that, MoleculeGraph other, double stickdst, double mergedst, MolAtom joint, CTransform3D trot) {
        this(that, other, stickdst, mergedst, joint, trot, other.getAtomCount() > 1 ? 1 : 0);
    }

    public MolJoin(Molecule that, MoleculeGraph other, double stickdst, double mergedst, MolAtom joint, CTransform3D trot, int opts) {
        List<Object> S = new ArrayList();
        this.that = that;
        this.other = other;
        this.mergedst = mergedst;
        this.theFindOptions = opts;
        this.priJ(stickdst, joint, trot);
        if (this.pri == null) {
            this.tother = other;
            MoleculeGraph u = that.getGraphUnion();
            this.atoms = MolJoin.getAtomList(u);
            this.bonds = MolJoin.getBondList(u);
            for (int i = this.atoms.size() - 1; i >= 0; --i) {
                MolAtom a = this.atoms.get(i);
                if (this.canMerge(a, other)) continue;
                this.atoms.remove(i);
            }
        } else {
            BondMerger bondMerger;
            MolAtom j1 = this.pri[0];
            MolAtom j1m = this.pri[1];
            if (this.pri.length == 4) {
                MolAtom j2 = this.pri[2];
                MolAtom j2m = this.pri[3];
                bondMerger = new BondMerger(new MolAtom[]{j1, j2}, new MolAtom[]{j1m, j2m}, trot);
            } else {
                bondMerger = new BondMerger(j1, j1m, trot);
            }
            S = this.secJ(bondMerger);
            for (int i = 0; i < this.pri.length; ++i) {
                S.add(this.pri[i]);
            }
        }
        ArrayList<MolBond> C = new ArrayList<MolBond>();
        MoleculeGraph utother = this.tother.getGraphUnion();
        MoleculeGraph uother = other.getGraphUnion();
        this.corruption(MolJoin.getAtomList(utother), this.bonds, MolJoin.getAtomList(uother), this.bonds, C, S);
        this.corruption(this.atoms, MolJoin.getBondList(utother), this.atoms, MolJoin.getBondList(uother), C, S);
        int n = C.size();
        if (n != 0) {
            this.corrupt = new MolBond[n];
            C.toArray(this.corrupt);
        }
    }

    private void setPrimary(MolAtom j1, MolAtom j1m, MolAtom j2, MolAtom j2m, double d) {
        boolean is2JoinPossible;
        boolean is1JoinPossible = j1 != null && j1m != null && this.checkRgroupConnections(j1, j1m) && (!this.inSameFragment(j1, j1m) || this.allowJoin(j1, j1m, d));
        boolean bl = is2JoinPossible = j2 != null && j2m != null && this.checkRgroupConnections(j1, j1m) && (!this.inSameFragment(j2, j2m) || this.allowJoin(j2, j2m, d));
        if (is1JoinPossible && is2JoinPossible) {
            this.pri = new MolAtom[4];
            this.pri[0] = j1;
            this.pri[1] = j1m;
            this.pri[2] = j2;
            this.pri[3] = j2m;
            return;
        }
        if (is1JoinPossible) {
            this.pri = new MolAtom[2];
            this.pri[0] = j1;
            this.pri[1] = j1m;
            return;
        }
        if (is2JoinPossible) {
            this.pri = new MolAtom[2];
            this.pri[0] = j2;
            this.pri[1] = j2m;
            return;
        }
    }

    private boolean checkRgroupConnections(MolAtom atom1, MolAtom atom2) {
        if (atom1.getRgroupAttachmentPointOrder() != -1 && atom2.getRgroupAttachmentPointOrder() != -1 && (atom1.getAtno() == 138 || atom2.getAtno() == 138)) {
            return atom1.getBondCount() + atom2.getBondCount() < 2;
        }
        return true;
    }

    private List<MolAtom> merge(SelectionMolecule sel, MoleculeGraph activeFrag, JoinPointFilter ... filters) {
        ArrayList<MolAtom> Vc = new ArrayList<MolAtom>();
        for (int i = 0; i < 2; ++i) {
            MolBond b;
            int j;
            MolAtom[] p;
            MolAtom[] molAtomArray = p = i == 0 ? this.pri : this.sec;
            if (p == null) continue;
            if (i == 0 && !this.inSameFragment(p[0], p[1])) {
                MoleculeGraph uo = this.other.getGraphUnion();
                MoleculeGraph ut = this.tother.getGraphUnion();
                for (j = 0; j < uo.getAtomCount(); ++j) {
                    MolAtom t = ut.getAtom(j);
                    MolAtom o = uo.getAtom(j);
                    o.setLocation(t.getLocation());
                }
            }
            if (this.other.getAtomCount() == 2 && this.other.getBondCount() == 1 && sel.getAtomCount() == 2 && sel.getBondCount() == 1 && p.length == 4 && p[1].getAtno() == 0 && p[3].getAtno() == 0) {
                b = this.other.getBond(0);
                MolBond bb = new MolBond(p[0], p[2], b.getFlags());
                sel.removeAll();
                j = this.that.indexOf(bb);
                if (j < 0) {
                    this.that.add(bb);
                } else {
                    this.that.setBond(j, bb);
                }
                MolAtom a1 = bb.getAtom1();
                MolAtom a2 = bb.getAtom2();
                if (!Vc.contains(a1)) {
                    Vc.add(a1);
                }
                if (!Vc.contains(a2)) {
                    Vc.add(a2);
                }
                if (MolJoin.isSgroupRemovable(bb, this.that)) {
                    MolJoin.ungroupSgroupOf(bb, this.that);
                }
                sel.add(bb.getAtom1());
                sel.add(bb.getAtom2());
                sel.add(bb);
                continue;
            }
            if (this.other.getAtomCount() == 2 && this.other.getBondCount() == 1 && sel.getAtomCount() == 2 && sel.getBondCount() == 1 && p.length == 2 && p[0].getAttach() != 0 && p[1].getAtno() == 0 && !this.that.contains(this.other.getBond(0).getOtherAtom(p[1]))) {
                b = this.other.getBond(0);
                MolAtom a2 = this.other.getBond(0).getOtherAtom(p[1]);
                this.other.removeBond(b);
                sel.removeAll();
                MolBond bb = new MolBond(p[0], a2, b.getFlags());
                this.that.add(a2);
                this.that.add(bb);
                continue;
            }
            for (int j2 = 0; j2 < p.length; j2 += 2) {
                Sgroup[] removableSgroups;
                boolean possibleCrossing;
                MolAtom a0 = p[j2];
                MolAtom a1 = p[j2 + 1];
                boolean valid = true;
                for (JoinPointFilter filter : filters) {
                    if (filter.isValidJoin(a0, a1)) continue;
                    valid = false;
                    break;
                }
                if (!valid) continue;
                MolAtom a = this.merge(a0, a1, activeFrag);
                if (a0.getAtno() == 137 && a1.getAtno() == 137) {
                    MolAtom old = a == a0 ? a1 : a0;
                    MulticenterSgroup mcg = this.that.findContainingMulticenterSgroup(a);
                    MulticenterSgroup oldMcg = this.that.findContainingMulticenterSgroup(old);
                    for (int k = 0; k < oldMcg.getAtomCount(); ++k) {
                        mcg.add(oldMcg.getAtom(k));
                    }
                    this.that.ungroupSgroup(oldMcg);
                }
                if (a0 != a1) {
                    MolAtom olda = a == a0 ? a1 : a0;
                    sel.removeAtom(olda);
                    if (!sel.contains(a)) {
                        sel.add(a);
                    }
                    for (int k = 0; k < a.getBondCount(); ++k) {
                        MolBond b2 = a.getBond(k);
                        if (sel.contains(b2) || !sel.contains(b2.getOtherAtom(a))) continue;
                        sel.add(b2);
                    }
                }
                Sgroup sg = this.that.findSmallestSgroupContaining(a);
                if (!Vc.contains(a)) {
                    Vc.add(a);
                }
                boolean bl = possibleCrossing = sg != null && sg.getType() == 0 && ((SuperatomSgroup)sg).isFreeLegalAttachAtom(a);
                if (possibleCrossing || (removableSgroups = MolJoin.getRemovableSgroups(a, this.that)) == null || a0 == a1 && p.length == 2 && this.sec == null) continue;
                MolJoin.ungroupSgroupOf(this.that, removableSgroups);
            }
        }
        return Vc;
    }

    private List<MolAtom> mergeTemplate(SelectionMolecule sel, MoleculeGraph activeFrag) {
        ArrayList<MolAtom> Vc = new ArrayList<MolAtom>();
        for (int i = 0; i < 2; ++i) {
            MolBond b;
            int j;
            MolAtom[] p;
            MolAtom[] molAtomArray = p = i == 0 ? this.pri : this.sec;
            if (p == null) continue;
            if (i == 0) {
                MoleculeGraph uo = this.other.getGraphUnion();
                MoleculeGraph ut = this.tother.getGraphUnion();
                for (j = 0; j < uo.getAtomCount(); ++j) {
                    MolAtom t = ut.getAtom(j);
                    MolAtom o = uo.getAtom(j);
                    o.setLocation(t.getLocation());
                }
            }
            if (this.other.getAtomCount() == 2 && this.other.getBondCount() == 1 && sel.getAtomCount() == 2 && sel.getBondCount() == 1 && p.length == 4 && p[1].getAtno() == 0 && p[3].getAtno() == 0) {
                b = this.other.getBond(0);
                MolBond bb = new MolBond(p[0], p[2], b.getFlags());
                sel.removeAll();
                j = this.that.indexOf(bb);
                if (j < 0) {
                    this.that.add(bb);
                } else {
                    this.that.setBond(j, bb);
                }
                MolAtom a1 = bb.getAtom1();
                MolAtom a2 = bb.getAtom2();
                if (!Vc.contains(a1)) {
                    Vc.add(a1);
                }
                if (!Vc.contains(a2)) {
                    Vc.add(a2);
                }
                if (MolJoin.isSgroupRemovable(bb, this.that)) {
                    MolJoin.ungroupSgroupOf(bb, this.that);
                }
                sel.add(bb.getAtom1());
                sel.add(bb.getAtom2());
                sel.add(bb);
                continue;
            }
            if (this.other.getAtomCount() == 2 && this.other.getBondCount() == 1 && sel.getAtomCount() == 2 && sel.getBondCount() == 1 && p.length == 2 && p[0].getAttach() != 0 && p[1].getAtno() == 0 && !this.that.contains(this.other.getBond(0).getOtherAtom(p[1]))) {
                b = this.other.getBond(0);
                MolAtom a2 = this.other.getBond(0).getOtherAtom(p[1]);
                this.other.removeBond(b);
                sel.removeAll();
                MolBond bb = new MolBond(p[0], a2, b.getFlags());
                this.that.add(a2);
                this.that.add(bb);
                continue;
            }
            for (int j2 = 0; j2 < p.length; j2 += 2) {
                Sgroup[] removableSgroups;
                MolAtom a0 = p[j2];
                MolAtom a1 = p[j2 + 1];
                MolAtom a = this.merge(a0, a1, (MoleculeGraph)activeFrag.clone());
                if (a0 != a1) {
                    MolAtom olda = a == a0 ? a1 : a0;
                    sel.removeAtom(olda);
                    if (!sel.contains(a)) {
                        sel.add(a);
                    }
                    for (int k = 0; k < a.getBondCount(); ++k) {
                        MolBond b2 = a.getBond(k);
                        if (sel.contains(b2) || !sel.contains(b2.getOtherAtom(a))) continue;
                        sel.add(b2);
                    }
                }
                if (!Vc.contains(a)) {
                    Vc.add(a);
                }
                if ((removableSgroups = MolJoin.getRemovableSgroups(a, this.that)) == null || a0 == a1 && p.length == 2 && this.sec == null) continue;
                MolJoin.ungroupSgroupOf(this.that, removableSgroups);
            }
        }
        return Vc;
    }

    private void mergeToSgroupRecursion(MolAtom a, Molecule mol, Sgroup sg) {
        for (int k = 0; k < a.getBondCount(); ++k) {
            MolAtom otherAtom;
            MolBond b = a.getBond(k);
            if (sg.isBracketCrossingBond(b)) continue;
            MolAtom molAtom = otherAtom = a == b.getAtom1() ? b.getAtom2() : b.getAtom1();
            if (otherAtom instanceof SgroupAtom) {
                sg.addChildSgroup(((SgroupAtom)otherAtom).getSgroup());
            }
            if (mol.findSgroupContaining(otherAtom) != null) continue;
            mol.setSgroupParent(otherAtom, sg, true);
            Sgroup psg = sg;
            while ((psg = psg.getParentSgroup()) != null) {
                mol.setSgroupParent(otherAtom, psg, true);
            }
            this.mergeToSgroupRecursion(otherAtom, mol, sg);
        }
    }

    private void mergeToSgroup(MolAtom a, Molecule mol, Sgroup sg, int options) {
        if (sg != null && (options & 8) == 0 && (SgroupUpdate.isSgroupToExtendToSubgraph(sg.getType()) || SgroupUpdate.isSgroupToExtendToWholeFragments(sg.getType()) || sg.getType() == 2)) {
            this.mergeToSgroupRecursion(a, mol, sg);
            if (SgroupUpdate.isSgroupToExtendToWholeFragments(sg.getType())) {
                CleanUtil.generateBracketCoords(sg, sg.getBrackets().get(0).getType());
            }
        }
    }

    public static Sgroup[] getRemovableSgroups(MolAtom a, Molecule mol) {
        Sgroup sg = mol.findSmallestSgroupContaining(a);
        if (sg != null) {
            ArrayList<Sgroup> removableSgroups = new ArrayList<Sgroup>();
            for (Sgroup psg = sg; psg != null && psg.indexOf(a) >= 0; psg = psg.getParentSgroup()) {
                if (!MolJoin.isRemovable(psg, a)) continue;
                removableSgroups.add(psg);
            }
            if (removableSgroups.size() == 0) {
                return null;
            }
            Sgroup[] sgroups = new Sgroup[removableSgroups.size()];
            removableSgroups.toArray(sgroups);
            return sgroups;
        }
        return null;
    }

    private static boolean isRemovable(Sgroup sgroup, MolAtom a) {
        if (sgroup.getType() == 0 && a.getAttach() > 0) {
            SuperatomSgroup ssg = (SuperatomSgroup)sgroup;
            int numConnections = ssg.getExternalConnections(a);
            int allowedConnections = 0;
            switch (a.getAttach()) {
                case 1: 
                case 2: {
                    allowedConnections = 1;
                    break;
                }
                case 3: {
                    allowedConnections = 2;
                    break;
                }
                default: {
                    allowedConnections = 0;
                }
            }
            return sgroup.isRemovable() && numConnections > allowedConnections;
        }
        return sgroup.isRemovable();
    }

    public static boolean isSgroupRemovable(MolBond b, Molecule mol) {
        Sgroup sg1 = mol.findSgroupContaining(b.getAtom1());
        Sgroup sg2 = mol.findSgroupContaining(b.getAtom2());
        return !(sg1 != null && !sg1.isRemovable() || sg2 != null && !sg2.isRemovable());
    }

    private static void merge0(MolAtom that, MolAtom a) {
        String valueString;
        if (a == null || a == that) {
            return;
        }
        int atno = that.getAtno();
        int aatno = a.getAtno();
        int amap = a.getAtomMap();
        boolean mappable = amap == 0 || that.isMappable();
        that.setLocation(a.getLocation());
        that.setImplicitHcount(0);
        if (aatno == 209 || aatno == 210) {
            if (mappable) {
                that.setAtomMap(amap);
            }
            return;
        }
        if (mappable && that.getAtomMap() == 0) {
            that.setAtomMap(amap);
        }
        String querystr = that.getQuerystr();
        String aquerystr = a.getQuerystr();
        boolean hasqprops = that.hasQProps();
        if (aatno == 131 && aquerystr != null && a.getBondCount() == 0) {
            aatno = 0;
        }
        if (querystr != null) {
            querystr = that.getQuerystr();
        }
        if (aquerystr != null) {
            aquerystr = a.getQuerystr();
        }
        if (!(that instanceof SgroupAtom)) {
            MolJoin.mergeElectronShellProperties(that, a);
        }
        if (aatno != 0) {
            that.clearQProps();
        }
        MolJoin.addPropsOf(that, a);
        String aaliasstr = a.getAliasstr();
        if (aaliasstr != null && aaliasstr.length() != 0) {
            that.setAliasstr(aaliasstr);
        }
        if ((valueString = a.getExtraLabel()) != null && valueString.length() != 0) {
            that.setExtraLabel(valueString);
        }
        if (that.getAttach() == 0) {
            that.setAttach(a.getAttach());
        }
        if (aatno != 0) {
            that.setAtno(aatno);
            that.setRgroup(a.getRgroup());
            that.setMassno(a.getMassno());
            that.setList(a.getList());
        }
        if (querystr == null && aquerystr != null && (aatno == 0 && a.getCharge() == 0 && !a.hasQProps() && a.getBondCount() == 0 || atno == 0 && !hasqprops)) {
            that.setQuerystr(aquerystr);
        }
        int astgrp = a.getStereoGroupType();
        if (aatno == 0 && astgrp != 0) {
            int n = a.getStereoGroupNumber();
            if (that.getStereoGroupType() == astgrp && that.getStereoGroupNumber() == n) {
                that.setStereoGroupType(0);
                that.setStereoGroupNumber(1);
            } else {
                that.setStereoGroupType(astgrp);
                that.setStereoGroupNumber(n);
            }
        }
    }

    static void mergeElectronShellProperties(MolAtom that, MolAtom a) {
        int atno = that.getAtno();
        int aatno = a.getAtno();
        int acharge = a.getCharge();
        int delta = aatno == 134 ? 0 : that.getCharge();
        int arad = a.getRadical();
        boolean aCanBeProp = aatno == 0 && a.getBondCount() == 0;
        boolean aIsChargeProp = aCanBeProp && !a.hasQProps() && a.getValenceProp() == 0 && arad == 0 && acharge != 0;
        boolean aIsQProp = aCanBeProp && a.hasQProps() && a.getValenceProp() == 0 && arad == 0 && acharge == 0;
        boolean aIsValenceProp = aCanBeProp && !a.hasQProps() && a.getValenceProp() == 0 && arad == 0 && acharge == 0;
        that.setCharge(acharge + delta);
        if (!(acharge != 0 || aIsChargeProp || aIsQProp || aIsValenceProp || a.getElectronProp() == -2)) {
            int lonePairs = that.getElectronProp();
            if (a.getElectronProp() == -1) {
                int lp = that.getElectronProp() == -3 ? 0 : that.getElectronProp();
                lonePairs = (lp + 1) % 5;
            } else if (a.getElectronProp() >= 0) {
                lonePairs = a.getElectronProp();
            }
            that.setElectronProp(lonePairs);
        }
        if (!(acharge != 0 || aIsChargeProp || aIsQProp || aIsValenceProp)) {
            if (a.getElectronProp() == -2) {
                that.setRadical((that.getRadical() + 1) % 2);
            } else if (a.getElectronProp() == -4) {
                if (that.getRadicalCount() == 2) {
                    that.setRadical(11);
                } else {
                    that.setRadical((that.getRadicalCount() + 1) % 5);
                }
            } else if (a.getElectronProp() == -3 || aatno != 0) {
                that.setRadical(arad);
            }
        }
        int fixc = (that.getFlags() | a.getFlags()) & 0x10000;
        if (atno != 0 && aatno != 0 && !that.isQuery() && !a.isQuery()) {
            fixc = 0;
        }
        that.setFlags(fixc, 65536);
    }

    private static void addPropsOf(MolAtom that, MolAtom a) {
        MolJoin.chprop("H", a, that, 0);
        MolJoin.chprop("v", a, that, 0);
        MolJoin.chprop("X", a, that, 0);
        MolJoin.chprop("R", a, that, 0);
        MolJoin.chprop("r", a, that, 1);
        MolJoin.chprop("rb", a, that, 0);
        MolJoin.chprop("s", a, that, 0);
        MolJoin.chprop("D", a, that, 0);
        MolJoin.chprop("h", a, that, 0);
        int arom = that.getQueryAromaticity();
        int aarom = a.getQueryAromaticity();
        if (arom == 0) {
            that.setQueryAromaticity(aarom);
        } else if (aarom == 1 && a.getAtno() == 0) {
            that.incQueryAromaticity();
        }
        int unsat = a.getQPropAsInt("u");
        if (unsat != -1) {
            int unsaat = that.getQPropAsInt("u");
            unsaat = unsaat == -1 ? unsat : -1;
            that.setQProp("u", unsaat);
        }
    }

    private static void chprop(String name, MolAtom a, MolAtom that, int cmd) {
        int aprop;
        boolean vprop = name.equals("v");
        int n = aprop = vprop ? a.getValenceProp() : a.getQPropAsInt(name);
        if (aprop == 255) {
            if (vprop) {
                that.decValenceProp();
            } else {
                that.decQProp(name);
            }
        } else if (aprop == 257) {
            if (vprop) {
                that.incValenceProp();
            } else {
                that.incQProp(name);
            }
        } else if (aprop == 256) {
            that.setQProp(name, 256);
        } else if (aprop != -1 && a.getAtno() == 0) {
            if (vprop) {
                that.setValenceProp(aprop);
            } else {
                that.setQProp(name, aprop);
            }
        } else if (aprop >= 0) {
            int prop = vprop ? that.getValenceProp() : that.getQPropAsInt(name);
            int[] minmax = vprop ? that.getValencePropMinMax() : that.getQPropMinMax(name);
            int max = minmax[1];
            if (cmd == 0) {
                if (prop < 0) {
                    prop = 0;
                }
                if ((prop += aprop) > max) {
                    prop = max;
                }
            } else if (cmd == 1) {
                if (prop < 0 || prop < aprop) {
                    prop = aprop;
                }
            } else {
                prop = aprop;
            }
            if (vprop) {
                that.setValenceProp(prop);
            } else {
                that.setQProp(name, prop);
            }
        } else if (aprop == -2) {
            that.setQProp(name, -2);
        }
    }

    public MolAtom[] getPrimary() {
        return this.pri;
    }

    public MolAtom[] getSecondary() {
        return this.sec;
    }

    public boolean isJoin(MolAtom a) {
        int i;
        if (this.pri != null) {
            for (i = 0; i < this.pri.length; ++i) {
                if (this.pri[i] != a) continue;
                return true;
            }
        }
        if (this.sec != null) {
            for (i = 0; i < this.sec.length; ++i) {
                if (this.sec[i] != a) continue;
                return true;
            }
        }
        return false;
    }

    public MolBond[] getCorrupt() {
        return this.corrupt;
    }

    private void priJ(double d, MolAtom joint, CTransform3D trot) {
        int i;
        MolAtom j1 = null;
        MolAtom j1m = null;
        double[] R = new double[]{d};
        MoleculeGraph uthat = this.that.getGraphUnion();
        MoleculeGraph uother = this.other.getGraphUnion();
        int na = uthat.getAtomCount();
        boolean atomic = na <= 1 || uother.getAtomCount() <= 1;
        DPoint3 pa = new DPoint3();
        DPoint3 paa = new DPoint3();
        for (i = 0; i < na; ++i) {
            MolAtom a = uthat.getAtom(i);
            a.getLocation(pa);
            trot.transform(pa);
            if (this.isSkipped(a) || this.other.contains(a)) continue;
            MolAtom am = MolJoin.findNearAtom(this.other.getAtomArray(), pa.x, pa.y, R, atomic, trot, this.theFindOptions);
            if (am != null && !MolJoin.canBeReplacedBy(am, a)) {
                am = null;
            }
            if (R[0] > d) {
                R[0] = d;
            }
            if (am == null && atomic) {
                for (int j = 0; j < uother.getAtomCount(); ++j) {
                    MolAtom aa = uother.getAtom(j);
                    aa.getLocation(paa);
                    trot.transform(paa);
                    if (!a.insideLabel(paa.x, paa.y) || !MolJoin.canBeReplacedBy(aa, a)) continue;
                    am = aa;
                    break;
                }
            }
            if (am != null) {
                j1 = a;
                j1m = am;
            }
            this.atoms.add(a);
        }
        for (i = 0; i < uthat.getBondCount(); ++i) {
            MolBond b = uthat.getBond(i);
            if (this.other.contains(b)) continue;
            this.bonds.add(b);
        }
        if (joint != null) {
            j1 = j1m = joint;
        }
        if (j1 != null) {
            MolAtom j2 = null;
            MolAtom j2m = null;
            R[0] = d;
            DPoint3 pam = new DPoint3();
            for (int i2 = 0; i2 < j1m.getBondCount(); ++i2) {
                MolAtom am = j1m.getLigand(i2);
                if (this.isSkipped(am) || !this.other.contains(am) || am instanceof SgroupAtom) continue;
                am.getLocation(pam);
                trot.transform(pam);
                for (MolAtom a : this.atoms) {
                    boolean isSimpleMerge;
                    if (!this.canMerge(a, this.other)) continue;
                    boolean near = MolJoin.isNearIn2D(a, pam.x, pam.y, R, trot) || atomic && a.insideLabel(pam.x, pam.y);
                    boolean bl = isSimpleMerge = (this.theFindOptions & 0x20) != 0;
                    if (a == j1 || a == j1m || a == am || !near || a.getBondTo(j1) != null || isSimpleMerge) continue;
                    j2 = a;
                    j2m = am;
                }
            }
            this.setPrimary(j1, j1m, j2, j2m, d);
        } else {
            ArrayList<MolBond> bvec = new ArrayList<MolBond>();
            for (int i3 = 0; i3 < uthat.getBondCount(); ++i3) {
                MolBond b = uthat.getBond(i3);
                MolAtom a1 = b.getAtom1();
                MolAtom a2 = b.getAtom2();
                if (this.canMerge(a1, this.other) || this.canMerge(a2, this.other) || this.other.contains(a1) || this.other.contains(a2)) continue;
                bvec.add(b);
            }
            MolAtom jm = null;
            MolBond jb = null;
            R[0] = d;
            DPoint3 pam = new DPoint3();
            for (int i4 = 0; i4 < uother.getAtomCount(); ++i4) {
                MolAtom am = uother.getAtom(i4);
                am.getLocation(pam);
                trot.transform(pam);
                MolBond[] bonds = new MolBond[bvec.size()];
                bvec.toArray(bonds);
                MolBond bm = MolJoin.findNearBond(bonds, pam.x, pam.y, R, trot, this.theFindOptions);
                if (bm == null) continue;
                jm = am;
                jb = bm;
            }
            if (jm != null) {
                MolAtom a1 = jb.getAtom1();
                MolAtom a2 = jb.getAtom2();
                DPoint3 pa1 = a1.getLocation();
                DPoint3 pa2 = a2.getLocation();
                DPoint3 pjm = jm.getLocation();
                trot.transform(pa1);
                trot.transform(pa2);
                trot.transform(pjm);
                double dx1 = pa1.x - pjm.x;
                double dy1 = pa1.y - pjm.y;
                double dx2 = pa2.x - pjm.x;
                double dy2 = pa2.y - pjm.y;
                this.setPrimary(dx1 * dx1 + dy1 * dy1 < dx2 * dx2 + dy2 * dy2 ? a1 : a2, jm, null, null, d);
            }
        }
    }

    private boolean allowJoin(MolAtom a, MolAtom am, double d) {
        if (am.getParent() != null && am.getParent().getAtomCount() == 1) {
            return true;
        }
        return a.getLocation().distance(am.getLocation()) < d;
    }

    private List<MolAtom> secJ(BondMerger bondMerger) {
        double d = this.mergedst * this.mergedst;
        if (this.pri != null) {
            this.atoms.remove(this.pri[0]);
            if (this.pri.length == 4) {
                this.atoms.remove(this.pri[2]);
                if (this.other.contains(new MolBond(this.pri[1], this.pri[3]))) {
                    this.bonds.remove(new MolBond(this.pri[0], this.pri[2]));
                }
            }
        }
        ArrayList<MolAtom> S = new ArrayList<MolAtom>();
        this.tother = (MoleculeGraph)this.other.clone();
        if (!this.other.isBond()) {
            CTransform3D t = bondMerger.getTransform();
            this.tother.transform(t);
        }
        MoleculeGraph uother = this.other.getGraphUnion();
        MoleculeGraph utother = this.tother.getGraphUnion();
        DPoint3 p = new DPoint3();
        for (int i = 0; i < utother.getAtomCount(); ++i) {
            MolAtom o;
            MolAtom t = utother.getAtom(i);
            if (this.isSkipped(t) || (o = uother.getAtom(i)) instanceof SgroupAtom) continue;
            if (this.pri != null) {
                if (o == this.pri[1]) {
                    this.pri[0].getLocation(p);
                    t.setLocation(p);
                } else if (this.pri.length == 4 && o == this.pri[3]) {
                    this.pri[2].getLocation(p);
                    t.setLocation(p);
                }
            }
            if (this.pri != null && (this.pri[0] == o || this.pri.length >= 4 && this.pri[2] == o)) continue;
            for (int j = this.atoms.size() - 1; j >= 0; --j) {
                double dz;
                double dy;
                MolAtom a = this.atoms.get(j);
                if (this.isSkipped(a)) continue;
                if (a == o) {
                    this.atoms.remove(j);
                    continue;
                }
                double dx = t.getX() - a.getX();
                if (!(dx * dx + (dy = t.getY() - a.getY()) * dy + (dz = t.getZ() - a.getZ()) * dz < d)) continue;
                t.setLocation(a.getLocation());
                S.add(a);
                S.add(o);
                this.atoms.remove(j);
            }
        }
        int n = S.size();
        if (n != 0) {
            this.sec = new MolAtom[n];
            S.toArray(this.sec);
        }
        return S;
    }

    private boolean isSkipped(MolAtom a) {
        return (this.theFindOptions & 1) != 0 && a.getAtno() == 1;
    }

    private boolean isExtraJoinAllowed(MolBond b) {
        if (b.getAtom1().getAtno() == 137 || b.getAtom2().getAtno() == 137) {
            return true;
        }
        return this.pri != null && this.pri.length == 4 && (this.pri[0].getAtno() == 137 || this.pri[2].getAtno() == 137);
    }

    private void corruption(List<MolAtom> ac1, List<MolBond> bc2, List<MolAtom> aorig, List<MolBond> borig, List<MolBond> bcout, List<MolAtom> skip) {
        double[] R = new double[1];
        DPoint3 pa1 = new DPoint3();
        for (int i = 0; i < ac1.size(); ++i) {
            MolAtom a1 = ac1.get(i);
            MolAtom a = aorig.get(i);
            a1.getLocation(pa1);
            if (a1.getAtno() == 1 || a1.getAtno() == 137 || skip.contains(a)) continue;
            for (int j = 0; j < bc2.size(); ++j) {
                MolBond b = borig.get(j);
                if (b.getAtom1() == a || b.getAtom2() == a || this.isSkipped(b.getAtom1()) || this.isSkipped(b.getAtom2())) continue;
                R[0] = this.mergedst;
                MolBond bb = bc2.get(j);
                if (!MolJoin.isNearIn3D(bb.getAtom1(), bb.getAtom2(), pa1.x, pa1.y, pa1.z, R, 1.0) || bcout.contains(b) || this.other.contains(b.getAtom1()) && this.other.contains(b.getAtom2()) && this.other.contains(a) || this.isExtraJoinAllowed(b)) continue;
                bcout.add(b);
            }
        }
    }

    public ArrayList<MolAtom> getFilteredJoinPoints(String joinPoints, JoinPointFilter ... filters) {
        ArrayList<MolAtom> result = new ArrayList<MolAtom>();
        int n = 0;
        MolAtom[] atomPairs = null;
        if (joinPoints == PRIMARY) {
            atomPairs = this.getPrimary();
        } else if (joinPoints == SECONDARY) {
            atomPairs = this.getSecondary();
        }
        if (atomPairs != null) {
            n = atomPairs.length;
        }
        for (int i = 0; i < n; i += 2) {
            MolAtom a1 = atomPairs[i];
            MolAtom a2 = atomPairs[i + 1];
            boolean valid = true;
            for (JoinPointFilter filter : filters) {
                if (filter.isValidJoin(a1, a2)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            result.add(a1);
            result.add(a2);
        }
        return result;
    }

    static void ungroupSgroupOf(MolBond b, Molecule mol) {
        if (MolJoin.isSgroupRemovable(b, mol)) {
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            Sgroup sg1 = mol.findSgroupContaining(a1);
            Sgroup sg2 = mol.findSgroupContaining(a2);
            if (sg1 != null || sg2 != null) {
                if (sg1 == sg2 || sg1 != null && a1.getAttach() == 0) {
                    mol.ungroupSgroup(sg1);
                } else if (sg2 != null && a2.getAttach() == 0) {
                    mol.ungroupSgroup(sg2);
                }
            }
        }
    }

    static boolean ungroupSgroupOf(Molecule mol, Sgroup[] removableSgroups) {
        if (removableSgroups != null) {
            for (int i = 0; i < removableSgroups.length; ++i) {
                Molecule parent = removableSgroups[i].getParentMolecule();
                parent.ungroupSgroup(parent.indexOf(removableSgroups[i]), 0);
            }
            return true;
        }
        return false;
    }

    private void specifyEndgroupIfNeeded(MolAtom aa, MolAtom a) {
        MoleculeGraph p;
        if (aa != null && aa.getSymbol() != null && aa.getSymbol().equals("*") && (p = aa.getParent()) instanceof Molecule) {
            Molecule mol = (Molecule)p;
            for (int i = 0; i < mol.getSgroupCount(); ++i) {
                RepeatingUnitSgroup sg;
                if (!(mol.getSgroup(i) instanceof RepeatingUnitSgroup) || !(sg = (RepeatingUnitSgroup)mol.getSgroup(i)).isStarAtom(aa)) continue;
                aa.setAtno(a.getAtno());
            }
        }
    }

    private MolAtom merge(MolAtom aa, MolAtom a, MoleculeGraph sel) {
        if (aa != null && aa != a) {
            MolAtom tmp;
            int atno = a.getAtno();
            this.specifyEndgroupIfNeeded(aa, a);
            if (a instanceof SgroupAtom) {
                this.that.mergeAtoms(a, aa);
                this.other.removeAtom(aa);
                MolJoin.replaceAtom(aa, a, sel);
            } else if (aa instanceof SgroupAtom && a.getBondCount() != 0) {
                if (MolJoin.canBeReplacedBy(aa, a)) {
                    tmp = aa;
                    aa = a;
                    a = tmp;
                } else if (a.getAtno() == 0) {
                    a.setAtno(6);
                }
                this.that.mergeAtoms(a, aa);
                this.other.removeAtom(aa);
                MolJoin.replaceAtom(aa, a, sel);
            } else {
                if ((atno == 0 || atno == 131 && a.getQuerystr() != null || atno >= 200 && atno <= 215) && a.getBondCount() == 0) {
                    MolJoin.merge0(aa, a);
                    MolJoin.replaceAtom(a, aa, sel);
                    return aa;
                }
                if (this.isAttachmentPointChanged(atno, aa, a)) {
                    MolJoin.replaceAtom(a, aa, sel);
                    return aa;
                }
                if (aa.getAtno() == 137) {
                    if (a.getBondCount() == 1) {
                        DPoint3 origin = a.getLocation();
                        MolAtom other = a.getBond(0).getOtherAtom(a);
                        DPoint3 position = other.getLocation();
                        position.x += (position.x - origin.x) * 0.5;
                        position.y += (position.y - origin.y) * 0.5;
                        position.z += (position.z - origin.z) * 0.5;
                        other.setLocation(position);
                    }
                    tmp = aa;
                    aa = a;
                    a = tmp;
                }
                if (a.getAtno() == 0) {
                    MolJoin.merge0(a, aa);
                }
                a.twicesumbonds(false, false);
                this.replace(a, aa, sel);
            }
            MoleculeGraph uthat = this.that.getGraphUnion();
            block0: for (int i = uthat.getBondCount() - 1; i >= 0; --i) {
                MolBond b = uthat.getBond(i);
                boolean r = false;
                if (b.getAtom1() == b.getAtom2()) {
                    r = true;
                } else if (b.getAtom1() == a || b.getAtom2() == a) {
                    for (int j = 0; j < a.getBondCount(); ++j) {
                        if (a.getBond(j) == b) continue block0;
                    }
                    r = true;
                }
                if (!r) continue;
                this.that.removeBond(b);
                this.other.removeBond(b);
            }
            MoleculeGraph uother = this.other.getGraphUnion();
            for (int i = uother.getBondCount() - 1; i >= 0; --i) {
                MolBond b = uother.getBond(i);
                if (b.getAtom1() != b.getAtom2()) continue;
                this.other.removeBond(b);
            }
            return a;
        }
        return aa;
    }

    private boolean isAttachmentPointChanged(int atno, MolAtom aa, MolAtom a) {
        boolean rgatomJoin = atno == 134 && this.other.isAtom() && this.that instanceof RgMolecule && ((RgMolecule)this.that).rgroupIdOf(aa) == a.getRgroup();
        boolean attachmentAdded = this.other.isAtom() && a.getAtno() == 138 && a.getRgroupAttachmentPointOrder() == -1;
        return rgatomJoin || attachmentAdded;
    }

    private boolean inSameFragment(MolAtom a1, MolAtom a2) {
        SelectionMolecule fragment = new SelectionMolecule();
        this.findFragment(fragment, a1);
        return fragment.contains(a2);
    }

    private void findFragment(SelectionMolecule fragment, MolAtom a1) {
        fragment.add(a1);
        for (int i = 0; i < a1.getBondCount(); ++i) {
            if (fragment.indexOf(a1.getBond(i).getOtherAtom(a1)) != -1) continue;
            this.findFragment(fragment, a1.getBond(i).getOtherAtom(a1));
        }
    }

    private void replace(MolAtom a1, MolAtom a2, MoleculeGraph sel) {
        DPoint3 location = a2.getLocation();
        boolean inSameFragment = this.inSameFragment(a1, a2);
        this.that.mergeAtoms(a1, a2);
        this.other.removeAtom(a2);
        MolJoin.replaceAtom(a2, a1, sel);
        if (inSameFragment) {
            a1.setLocation(location);
        }
    }

    public SelectionMolecule join(MoleculeGraph curfrag, int options) {
        List<MolAtom> tocheck;
        MDocument doc = this.that.getDocument();
        MDocument curfragdoc = curfrag.getDocument();
        SelectionMolecule scurfrag = curfrag instanceof Molecule ? ((Molecule)curfrag).newSelectionMolecule() : new SelectionMolecule();
        if (curfragdoc != null) {
            if (doc == null) {
                doc = new MDocument(this.that);
            }
            if (scurfrag.getDocument() == null) {
                MSelectionDocument scrufragDoc = new MSelectionDocument(scurfrag);
                assert (scurfrag.getDocument() == scrufragDoc);
            }
        }
        MolJoin.fuseDoc(curfrag, scurfrag);
        MoleculeGraph activeFrag = this.getActiveFrag();
        boolean aromatized1 = false;
        boolean aromatized2 = false;
        HashMap<MolBond, Integer> savedBonds = new HashMap<MolBond, Integer>();
        MolJoin.saveBondOrders(activeFrag, savedBonds);
        MolJoin.saveBondOrders(curfrag, savedBonds);
        if (activeFrag.getAtomCount() > 0 && (options & 1) != 0) {
            if (MolJoin.isAromatic(curfrag)) {
                aromatized1 = !MolJoin.isAromatic(activeFrag);
            } else if (curfrag.getAtomCount() > 2 && curfrag.getBondCount() > 2) {
                MoleculeGraph mm = (MoleculeGraph)curfrag.clone();
                mm.aromatize();
                aromatized2 = MolJoin.isAromatic(mm);
                if (aromatized2) {
                    boolean bl = aromatized1 = !MolJoin.isAromatic(activeFrag);
                }
            }
        }
        if (aromatized1) {
            activeFrag.aromatize(4);
        }
        if (aromatized2) {
            curfrag.aromatize(4);
        }
        boolean unconnectedPart = (tocheck = options == 16 ? this.mergeTemplate(scurfrag, activeFrag) : this.merge(scurfrag, activeFrag, new OwnMultiCenterFilter(this.that))).size() == 0 && (doc != null && curfragdoc != null ? doc.contains(curfragdoc) : this.that.contains(curfrag));
        MoleculeGraph ucurfrag = curfrag.getGraphUnion();
        int naCurfrag = ucurfrag.getAtomCount();
        int nbCurfrag = ucurfrag.getBondCount();
        MoleculeGraph uthat = this.that.getGraphUnion();
        int naOrig = uthat.getAtomCount();
        int nbOrig = uthat.getBondCount();
        if (unconnectedPart) {
            activeFrag = ucurfrag;
        } else {
            MolJoin.fuseDoc(scurfrag, this.that);
            for (MolAtom a : tocheck) {
                Sgroup sg = this.that.findSmallestSgroupContaining(a);
                this.mergeToSgroup(a, this.that, sg, options);
            }
            activeFrag = activeFrag.getAtomCount() > 0 ? MolJoin.getConnectedPart(this.that, activeFrag.getAtom(0)) : ucurfrag;
        }
        if (!unconnectedPart) {
            MolAtom a;
            ArrayList<MolAtom> topropcheck = new ArrayList<MolAtom>();
            for (int i = ucurfrag.getAtomCount() - 1; i >= 0; --i) {
                a = ucurfrag.getAtom(i);
                if (a.getQProp("R") == null && a.getQProp("r") == null || tocheck.contains(a)) continue;
                topropcheck.add(a);
            }
            if (aromatized1) {
                activeFrag.dearomatize();
                if (MolJoin.isAromatic(activeFrag)) {
                    MolJoin.restoreBondOrders(activeFrag, savedBonds);
                }
            }
            boolean hydr_enabled = true;
            if (curfrag instanceof Molecule && ((Molecule)curfrag).countExpandableContractableSgroups() != 0 || this.that.countExpandableContractableSgroups() != 0) {
                hydr_enabled = false;
            }
            if (curfrag.getBondCount() == 1 && curfrag.getAtomCount() == 2) {
                MolAtom a1 = curfrag.getAtom(0);
                MolAtom a2 = curfrag.getAtom(1);
                hydr_enabled &= a1.getAtno() != 1 && a2.getAtno() != 1;
            } else if (curfrag.getAtomCount() == 1) {
                a = curfrag.getAtom(0);
                int atno = a.getAtno();
                hydr_enabled &= atno >= 1 && atno < 200;
            }
            MolAtom[] hlist = this.listExplicitHAtoms(tocheck.iterator(), curfrag);
            MolAtom[] alist = this.listAtomsForExplicitHAdding(tocheck.iterator());
            uthat = this.that.getGraphUnion();
            int numAtoms = uthat.getAtomCount();
            if (hydr_enabled) {
                for (int i = 0; i < hlist.length; ++i) {
                    curfrag.removeAtom(hlist[i]);
                    scurfrag.removeAtom(hlist[i]);
                }
            }
            MolJoin.addNeighbors(tocheck);
            for (MolAtom a2 : tocheck) {
                a2.valenceCheck();
            }
            if (hydr_enabled && (uthat.getAtomCount() != numAtoms || (options & 2) != 0)) {
                this.that.addExplicitHydrogens(0, alist);
            }
            Iterator<MolAtom> it = topropcheck.iterator();
            while (it.hasNext()) {
                it.next().qpropCheck();
            }
        }
        ucurfrag = curfrag.getGraphUnion();
        for (int i = 0; i < ucurfrag.getBondCount(); ++i) {
            if (ucurfrag.getBond(i).getType() == 0) continue;
            this.that.setProperty("anyBondsFromCoords", null);
            break;
        }
        if ((uthat = this.that.getGraphUnion()).getAtomCount() != naOrig + naCurfrag || uthat.getBondCount() != nbOrig + nbCurfrag) {
            curfrag.removeAll();
        }
        return tocheck.size() > 0 ? scurfrag : null;
    }

    private static void addNeighbors(List<MolAtom> l) {
        int n = l.size();
        for (int j = 0; j < n; ++j) {
            MolAtom a = l.get(j);
            for (int k = 0; k < a.getBondCount(); ++k) {
                MolAtom aa = a.getLigand(k);
                if (l.contains(aa)) continue;
                l.add(aa);
            }
        }
    }

    private MolAtom[] listExplicitHAtoms(Iterator<MolAtom> it, MoleculeGraph curfrag) {
        MolAtom a2;
        MolAtom a1;
        MolAtom curH = null;
        if (curfrag.isAtom() && this.other.isAtom() && (a1 = curfrag.getAtom(0)) == (a2 = this.other.getAtom(0)) && a1.getAtno() == 1) {
            curH = curfrag.getAtom(0);
        }
        ArrayList<MolAtom> list = new ArrayList<MolAtom>();
        while (it.hasNext()) {
            MolAtom a = it.next();
            int atno = a.getAtno();
            if (atno == 1 && a != curH && a.getBondCount() == 1 && a.getBond(0).getOtherAtom(a).getAtno() != 1) {
                list.add(a);
                continue;
            }
            if (atno == 1) continue;
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolAtom aj = a.getLigand(j);
                if (aj.getAtno() != 1) continue;
                list.add(aj);
            }
        }
        MolAtom[] atoms = new MolAtom[list.size()];
        list.toArray(atoms);
        return atoms;
    }

    private MolAtom[] listAtomsForExplicitHAdding(Iterator<MolAtom> it) {
        ArrayList<MolAtom> list = new ArrayList<MolAtom>();
        while (it.hasNext()) {
            MolAtom a = it.next();
            int atno = a.getAtno();
            if (atno == 1 && a.getBondCount() == 1 && a.getBond(0).getOtherAtom(a).getAtno() != 1) {
                list.add(a.getBond(0).getOtherAtom(a));
                continue;
            }
            if (atno == 1) continue;
            list.add(a);
        }
        MolAtom[] atoms = new MolAtom[list.size()];
        list.toArray(atoms);
        return atoms;
    }

    static boolean canBeReplacedBy(MolAtom a, MolAtom aa) {
        if (aa != null && a instanceof SgroupAtom) {
            SgroupAtom sa = (SgroupAtom)a;
            SuperatomSgroup sg = sa.getSgroup();
            MolAtom[] attach = sg.getFreeLegalAttachAtoms();
            return aa.getBondCount() <= attach.length;
        }
        return true;
    }

    static boolean canJoinByBond(MolAtom sga, MolAtom toa) {
        if (toa != null && sga instanceof SgroupAtom) {
            SgroupAtom sa = (SgroupAtom)sga;
            SuperatomSgroup sg = sa.getSgroup();
            MolAtom[] attach = sg.getFreeLegalAttachAtoms();
            if (attach.length == 0) {
                return false;
            }
            if (toa instanceof SgroupAtom) {
                SgroupAtom stoa = (SgroupAtom)toa;
                SuperatomSgroup sgtoa = stoa.getSgroup();
                MolAtom[] attachtoa = sgtoa.getFreeLegalAttachAtoms();
                return attachtoa.length > 0;
            }
            return toa.getImplicitHcount() > 0;
        }
        return true;
    }

    static boolean canBeSproutTo(MolAtom a, MolAtom aa) {
        if (aa.getBondCount() > 1 && !(aa instanceof SgroupAtom) && a instanceof SgroupAtom) {
            SgroupAtom sa = (SgroupAtom)a;
            SuperatomSgroup sg = sa.getSgroup();
            MolAtom[] attach = sg.getFreeLegalAttachAtoms();
            return attach.length == 1;
        }
        return false;
    }

    static boolean canBeSpiroTo(MolAtom sga, MolAtom toa) {
        if (sga instanceof SgroupAtom) {
            SgroupAtom sa = (SgroupAtom)sga;
            SuperatomSgroup sg = sa.getSgroup();
            MolAtom[] attach = sg.getFreeLegalAttachAtoms();
            if (toa.getBondCount() == 1) {
                return attach.length == 1;
            }
        }
        return false;
    }

    private boolean canMerge(MolAtom atom, MoleculeGraph other) {
        if (atom instanceof SgroupAtom) {
            return other.isBond() && MolJoin.canBeBound(atom);
        }
        return !this.isSkipped(atom);
    }

    public static boolean canBeBound(MolAtom atom) {
        if (atom instanceof SgroupAtom) {
            SgroupAtom sa = (SgroupAtom)atom;
            SuperatomSgroup sg = sa.getSgroup();
            MolAtom[] attach = sg.getFreeLegalAttachAtoms();
            return attach.length != 0;
        }
        if (atom.getAtno() == 138) {
            return atom.getBondCount() == 0;
        }
        return true;
    }

    private static MolAtom findNearAtom(MolAtom[] atoms, double x, double y, double[] rmax, boolean l, CTransform3D trot, int opts) {
        double min = Double.MAX_VALUE;
        MolAtom closest = null;
        for (int i = atoms.length - 1; i >= 0; --i) {
            double r;
            MolAtom a = atoms[i];
            if ((opts & 1) != 0 && a.getAtno() == 1 || !((r = MolJoin.distance2D(a, x, y, trot)) < min)) continue;
            closest = a;
            min = r;
        }
        if (min <= rmax[0] || l && closest != null && closest.insideLabel(x, y)) {
            rmax[0] = min;
            return closest;
        }
        return null;
    }

    public static MolAtom findNearAtom(MolAtom[] atoms, double x, double y, double d, boolean l, CTransform3D trot) {
        double[] R = new double[]{d};
        return MolJoin.findNearAtom(atoms, x, y, R, l, trot, 0);
    }

    private static MolBond findNearBond(MolBond[] bonds, double x, double y, double[] rmax, CTransform3D trot, int opts) {
        MolBond bn = null;
        for (int i = 0; i < bonds.length; ++i) {
            MolBond b = bonds[i];
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            if ((opts & 1) != 0 && (a1.getAtno() == 1 || a2.getAtno() == 1) || !MolJoin.isNearIn2D(a1, a2, x, y, rmax, 1.0, trot)) continue;
            bn = b;
        }
        return bn;
    }

    public static MolBond findNearBond(MolBond[] bonds, double x, double y, double d, CTransform3D trot) {
        double[] R = new double[]{d};
        return MolJoin.findNearBond(bonds, x, y, R, trot, 0);
    }

    public static MolAtom[] findNearAtomPair(MolAtom[][] pairs, double x, double y, double d, double c2, CTransform3D trot) {
        double[] R = new double[]{d};
        return MolJoin.findNearAtomPair(pairs, x, y, R, c2, trot);
    }

    private static MolAtom[] findNearAtomPair(MolAtom[][] pairs, double x, double y, double[] rmax, double c2, CTransform3D trot) {
        MolAtom[] a = null;
        for (int i = 0; i < pairs.length; ++i) {
            if (!MolJoin.isNearIn2D(pairs[i][0], pairs[i][1], x, y, rmax, c2, trot)) continue;
            a = new MolAtom[]{pairs[i][0], pairs[i][1]};
        }
        return a;
    }

    private static boolean isNearIn2D(MolAtom a, double x, double y, double[] rmax, CTransform3D trot) {
        double r = MolJoin.distance2D(a, x, y, trot);
        if (r < rmax[0]) {
            rmax[0] = r;
            return true;
        }
        return false;
    }

    private static boolean isNearIn3D(MolAtom a, double x, double y, double z, double[] rmax) {
        double r = MolJoin.distance3D(a, x, y, z);
        if (r < rmax[0]) {
            rmax[0] = r;
            return true;
        }
        return false;
    }

    private static boolean isNearIn2D(MolAtom a1, MolAtom a2, double x, double y, double[] rmax, double c2, CTransform3D trot) {
        DPoint3 pa1 = a1.getLocation();
        DPoint3 pa2 = a2.getLocation();
        trot.transform(pa1);
        trot.transform(pa2);
        double dx12 = pa2.x - pa1.x;
        double dy12 = pa2.y - pa1.y;
        double dr12 = Math.sqrt(dx12 * dx12 + dy12 * dy12);
        if (dr12 < 1.0E-8) {
            return MolJoin.isNearIn2D(a1, x, y, rmax, trot);
        }
        double dx2 = pa2.x - x;
        double dy2 = pa2.y - y;
        double dr2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
        if (dr12 >= 1.54 && dr2 > dr12 * c2) {
            return false;
        }
        double dx = x - pa1.x;
        double dy = y - pa1.y;
        double l = (dx12 * dx + dy12 * dy) / dr12;
        if (l > 0.0 && l < dr12) {
            double r = (dy12 * dx - dx12 * dy) / dr12;
            if (r < 0.0) {
                r = -r;
            }
            if (r < rmax[0]) {
                rmax[0] = r;
                return true;
            }
        }
        return false;
    }

    private static boolean isNearIn3D(MolAtom a1, MolAtom a2, double x, double y, double z, double[] rmax, double c2) {
        double rz;
        double ry;
        double rx;
        double r;
        double dz;
        double dy;
        double dy2;
        double dx12 = a2.getX() - a1.getX();
        double dy12 = a2.getY() - a1.getY();
        double dz12 = a2.getZ() - a1.getZ();
        double dr12 = Math.sqrt(dx12 * dx12 + dy12 * dy12);
        if (dr12 < 1.0E-8) {
            return MolJoin.isNearIn3D(a1, x, y, z, rmax);
        }
        double dx2 = a2.getX() - x;
        double dr2 = Math.sqrt(dx2 * dx2 + (dy2 = a2.getY() - y) * dy2);
        if (dr2 > dr12 * c2) {
            return false;
        }
        double dx = x - a1.getX();
        double l = (dx12 * dx + dy12 * (dy = y - a1.getY()) + dz12 * (dz = z - a1.getZ())) / dr12;
        if (l > 0.0 && l < dr12 && (r = Math.sqrt((rx = (dz12 * dy - dy12 * dz) / dr12) * rx + (ry = (dx12 * dz - dz12 * dx) / dr12) * ry + (rz = (dy12 * dx - dx12 * dy) / dr12) * rz)) < rmax[0]) {
            rmax[0] = r;
            return true;
        }
        return false;
    }

    private static double distance2D(MolAtom a, double x, double y, CTransform3D trot) {
        DPoint3 p = a.getLocation();
        trot.transform(p);
        double dx = p.x - x;
        double dy = p.y - y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static double distance3D(MolAtom a, double x, double y, double z) {
        double dx = a.getX() - x;
        double dy = a.getY() - y;
        double dz = a.getZ() - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private MoleculeGraph getActiveFrag() {
        int i;
        SelectionMolecule frag = new SelectionMolecule();
        MoleculeGraph u = this.that.getGraphUnion();
        if (this.pri != null) {
            for (i = 0; i < this.pri.length; ++i) {
                int j = u.indexOf(this.pri[i]);
                if (j < 0) continue;
                u.findFrag(j, frag);
            }
            for (i = frag.getAtomCount() - 1; i >= 0; --i) {
                MolAtom a = frag.getAtom(i);
                if (!this.other.contains(a)) continue;
                frag.removeAtom(i);
            }
        }
        if (this.sec != null) {
            for (i = 0; i < this.sec.length; ++i) {
                int j = u.indexOf(this.sec[i]);
                if (j < 0) continue;
                u.findFrag(j, frag);
            }
        }
        return frag;
    }

    private static MoleculeGraph getConnectedPart(MoleculeGraph m, MolAtom a) {
        SelectionMolecule frag = new SelectionMolecule();
        MoleculeGraph u = m.getGraphUnion();
        int i = u.indexOf(a);
        if (i >= 0) {
            u.findFrag(i, frag);
        }
        return frag;
    }

    private static boolean isAromatic(MoleculeGraph m) {
        MoleculeGraph u = m.getGraphUnion();
        for (int i = 0; i < u.getBondCount(); ++i) {
            if (u.getBond(i).getType() != 4) continue;
            return true;
        }
        return false;
    }

    private static void saveBondOrders(MoleculeGraph m, Map<MolBond, Integer> h) {
        MoleculeGraph u = m.getGraphUnion();
        for (int i = 0; i < u.getBondCount(); ++i) {
            MolBond b = u.getBond(i);
            h.put(b, new Integer(b.getType()));
        }
    }

    private static void restoreBondOrders(MoleculeGraph m, Map<MolBond, Integer> h) {
        MoleculeGraph u = m.getGraphUnion();
        for (int i = 0; i < u.getBondCount(); ++i) {
            MolBond b = u.getBond(i);
            Integer k = h.get(b);
            if (k == null) continue;
            b.setType(k);
        }
    }

    private static void replaceAtom(MolAtom a, MolAtom aa, MoleculeGraph sel) {
        int i = sel.indexOf(a);
        if (i >= 0 && !sel.contains(aa)) {
            sel.setAtom(i, aa);
        }
    }

    private static void fuseDoc(MoleculeGraph m1, MoleculeGraph m2) {
        MDocument m1doc = m1.getDocument();
        MDocument m2doc = m2.getDocument();
        if (m1doc != null) {
            int i;
            ArrayList<Integer> added = new ArrayList<Integer>();
            for (i = 0; i < m1doc.getObjectCount(); ++i) {
                MObject mo = m1doc.getObject(i);
                if (mo instanceof MChemicalStruct && ((MChemicalStruct)mo).getMoleculeGraph() == m1 || mo.isInternalSelectable()) continue;
                if (!m2doc.contains(mo)) {
                    m2doc.addObject(mo);
                }
                added.add(new Integer(i));
            }
            for (i = added.size() - 1; i >= 0; --i) {
                int k = (Integer)added.get(i);
                m1doc.removeObject(k);
            }
        }
        m2.fuse(m1);
    }

    private static List<MolAtom> getAtomList(MoleculeGraph m) {
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        Collections.addAll(atoms, m.getAtomArray());
        return atoms;
    }

    private static List<MolBond> getBondList(MoleculeGraph m) {
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        Collections.addAll(bonds, m.getBondArray());
        return bonds;
    }

    public double getMergedst() {
        return this.mergedst;
    }

    public Molecule getThatMolecule() {
        return this.that;
    }
}

