/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.sketch.JoinPointFilter;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.MulticenterSgroup;

public class OwnMultiCenterFilter
implements JoinPointFilter {
    private Molecule mol;

    public OwnMultiCenterFilter(Molecule mol) {
        this.mol = mol;
    }

    @Override
    public boolean isValidJoin(MolAtom a0, MolAtom a1) {
        if (this.mol != null) {
            return !this.isOwnMultiCenter(a0, a1);
        }
        return false;
    }

    private boolean isOwnMultiCenter(MolAtom a0, MolAtom a1) {
        return a0.getAtno() == 137 && this.findMultiCenterConnectedAtom(a0, a1) || a1.getAtno() == 137 && this.findMultiCenterConnectedAtom(a1, a0);
    }

    private boolean findMultiCenterConnectedAtom(MolAtom multiCenter, MolAtom atomToFind) {
        MulticenterSgroup group = this.mol.findContainingMulticenterSgroup(multiCenter);
        return group.hasAtom(atomToFind);
    }
}

