/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.paint.internal.AtomLabeller;
import chemaxon.marvin.paint.internal.LinePainter;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.MolJoin;
import chemaxon.marvin.sketch.OwnMultiCenterFilter;
import chemaxon.marvin.sketch.SelectUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class SketchMode
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 511717688630484043L;
    private transient MolEditor medit = null;

    protected SketchMode() {
    }

    protected SketchMode(MolEditor e) {
        this.initSketchMode(e);
    }

    protected SketchMode(SketchMode so) {
        this.medit = so.medit;
    }

    public void initSketchMode(MolEditor e) {
        this.medit = e;
    }

    public void setNotifiy() {
    }

    public MolEditor getEditor() {
        return this.medit;
    }

    public abstract boolean containedObjectEquals(SketchMode var1);

    public abstract Object clone();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.containedObjectEquals((SketchMode)obj);
    }

    public Molecule getMol() {
        return null;
    }

    public void setMol(Molecule m) {
        throw new RuntimeException("setting the molecule is not supported for " + this.getClass());
    }

    public MolAtom[] getPointableAtoms(Molecule m) {
        return m.getAtomArray();
    }

    public boolean canPointToAtom() {
        return false;
    }

    public boolean canPointToBond() {
        return false;
    }

    public boolean canPointToSgroup() {
        return false;
    }

    public MolBond[] getPointableBonds(Molecule m) {
        return m.getBondArray();
    }

    public boolean canPointToAtomPair() {
        return false;
    }

    public double getPointedAtomPairMinDstRatio2() {
        return 1.0;
    }

    public double[] getAtomPairLocationWeights() {
        return null;
    }

    public MolAtom[][] getPointableAtomPairs(Molecule m) {
        return new MolAtom[0][];
    }

    public boolean canPointToMObject() {
        return false;
    }

    public boolean isCurrentJoinHighlighted() {
        return true;
    }

    public boolean isRubber() {
        return false;
    }

    public boolean isSelector() {
        return false;
    }

    public SelectUtil getSelectUtil() {
        return null;
    }

    public void moveTo(DPoint3 o) {
    }

    public abstract int buttonDown(boolean var1, int var2);

    public abstract int buttonUp(int var1, boolean var2);

    public abstract boolean pointerMove(int var1);

    public abstract boolean pointerDrag(int var1);

    public abstract boolean pointerCopyDrag(int var1);

    public int modkeyChange(int mod) {
        return 0;
    }

    public void reset() {
    }

    public void hilitJoins(MolJoin j, MolPainter p, double sr, Graphics2D g) {
        OwnMultiCenterFilter filter = new OwnMultiCenterFilter(j.getThatMolecule());
        this.highLightAtomPairs(j.getFilteredJoinPoints("primary", filter), sr, p, g);
        this.highLightAtomPairs(j.getFilteredJoinPoints("secondary", filter), j.getMergedst(), p, g);
        this.highLightCorrupted(j, p, g);
    }

    public boolean willBranchAtButtonPress() {
        return false;
    }

    public void paintTemps1(Graphics2D g) {
    }

    public void prepareMolPaint() {
    }

    public boolean isTemporaryObjectPaintingNeeded() {
        return false;
    }

    public void paintTemporaryObject(Graphics2D g) {
    }

    public boolean isFloatingObjectPainted() {
        return !this.isTemporaryObjectPaintingNeeded();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeObject(this.medit);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        this.medit = (MolEditor)ois.readObject();
    }

    private void highLightAtomPairs(ArrayList<MolAtom> atomPairs, double distance, MolPainter painter, Graphics2D g) {
        if (atomPairs == null) {
            return;
        }
        g.setColor(painter.getColors().getHighlightColor());
        for (int i = 0; i < atomPairs.size(); i += 2) {
            MolAtom a1 = atomPairs.get(i);
            MolAtom a2 = atomPairs.get(i + 1);
            DPoint3 p1 = a1.getLocation();
            DPoint3 p2 = a2.getLocation();
            painter.ringAround(p1, p2, distance, g);
            painter.calcGP(p1);
            painter.calcGP(p2);
            g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
        }
    }

    private void highLightCorrupted(MolJoin join, MolPainter painter, Graphics2D g) {
        MolAtom a;
        int n;
        Molecule mol = join.getThatMolecule();
        painter.recalcScreenCoords(mol);
        g.setColor(painter.getColors().getCorruptedColor());
        int n2 = n = join.getCorrupt() != null ? join.getCorrupt().length : 0;
        if (mol.isAtom() && ((a = mol.getAtom(0)).getAtno() >= 200 || a.isQProp())) {
            return;
        }
        MolPainterCommon common = painter.getCommon();
        AtomLabeller alabeller = new AtomLabeller(common);
        alabeller.setMol(mol);
        LinePainter lpainter = new LinePainter(common, painter.getColors(), painter.getLineThickness(), painter.getLineThicknessAsInt());
        for (int i = 0; i < n; ++i) {
            MolBond b = join.getCorrupt()[i];
            if (!mol.contains(b)) continue;
            painter.bondLine(g, lpainter, mol, b, 3, alabeller, mol.getDocument(), 0, null);
        }
    }
}

