/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.sketch.AbstractSelectSM;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;

public class StructureSelectSM
extends AbstractSelectSM {
    public StructureSelectSM(MolEditor e) {
        super(e);
    }

    public StructureSelectSM(StructureSelectSM so) {
        super(so);
    }

    @Override
    protected void beginSelection() {
        this.getSelectUtil().beginRectangleSelection();
    }

    @Override
    protected int endSelection(int modifiers) {
        super.endSelection(modifiers);
        this.clearSelection();
        return 1;
    }

    @Override
    public void setNotifiy() {
        super.setNotifiy();
        this.clearSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSelection() {
        Object object = this.getEditor().getMol().getLock();
        synchronized (object) {
            Molecule mol = this.getEditor().getMol();
            MoleculeGraph[] tmp = mol.getGraphUnion().findFrags(SelectionMolecule.class);
            SelectionMolecule[] frags = new SelectionMolecule[tmp.length];
            System.arraycopy(tmp, 0, frags, 0, tmp.length);
            for (int i = 0; i < frags.length; ++i) {
                if (!this.isPartiallySelected(frags[i])) continue;
                this.clearSelection(frags[i]);
            }
        }
    }

    private void clearSelection(SelectionMolecule fragment) {
        MolAtom[] atoms = fragment.getAtomArray();
        for (int j = 0; j < atoms.length; ++j) {
            this.getEditor().unselectAtom(atoms[j]);
        }
    }

    private boolean isPartiallySelected(SelectionMolecule fragment) {
        boolean hasSelected = false;
        boolean hasUnselected = false;
        for (int i = 0; i < fragment.getAtomCount(); ++i) {
            boolean selected = this.getEditor().getSelectionMolecule().indexOf(fragment.getAtom(i)) != -1;
            hasSelected = hasSelected || selected;
            boolean bl = hasUnselected = hasUnselected || !selected;
            if (hasSelected && hasUnselected) break;
        }
        return hasSelected && hasUnselected;
    }

    @Override
    protected boolean isSelecting() {
        return this.getSelectUtil().selRect != null;
    }

    @Override
    protected void handleButtonRelease(int modifiers) {
        if (this.isShiftButton1(modifiers) || this.getEditor().getPointedObject() instanceof SgroupPO) {
            super.handleButtonRelease(modifiers);
        } else {
            this.selectFragment();
        }
    }

    @Override
    protected void buttonDownOnAtom(MolAtom a, int modifiers) {
        if (this.isShiftButton1(modifiers)) {
            this.selectFragment();
        } else {
            super.buttonDownOnAtom(a, modifiers);
        }
    }

    @Override
    protected void buttonDownOnBond(MolBond b, int modifiers) {
        if (this.isShiftButton1(modifiers)) {
            this.selectFragment();
        } else {
            super.buttonDownOnBond(b, modifiers);
        }
    }

    @Override
    protected void buttonDownOnSgroup(Sgroup sg, int modifiers, boolean isDataLabelPointed, boolean dblClick) {
        super.buttonDownOnSgroup(sg, modifiers, isDataLabelPointed, dblClick);
    }

    protected void handleDoubleClick(int modifiers) {
    }

    @Override
    public Object clone() {
        return new StructureSelectSM(this);
    }

    private boolean isShiftButton1(int modifiers) {
        return modifiers == 17;
    }
}

