/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;

public class AtomMapper
implements CallbackIface {
    private MolEditor medit = null;
    private MarvinModule autoMapper = null;
    private static int mappingMethod = 27;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("init")) {
            this.medit = (MolEditor)arg;
        } else {
            if (method.equals("mapAtoms")) {
                int cmd = (Integer)arg;
                boolean changed = cmd == 25 ? this.mapAtoms() : this.unmapAtoms();
                return changed;
            }
            if (method.equals("atomMappingMethod")) {
                mappingMethod = (Integer)arg;
            }
        }
        return null;
    }

    private boolean mapAtoms() {
        Molecule mol = this.medit.getMol();
        MoleculeGraph sel = null;
        if (this.medit.hasSelection()) {
            MSelectionDocument seldoc = this.medit.getSelectionDocument();
            sel = seldoc.getMainMoleculeGraph();
        }
        Molecule refmol = sel != null ? mol : null;
        return this.mapReaction(mol, refmol);
    }

    private boolean unmapAtoms() {
        boolean changed = false;
        Molecule mol = null;
        if (this.medit.hasSelection()) {
            MSelectionDocument seldoc = this.medit.getSelectionDocument();
            MoleculeGraph sel = seldoc.getMainMoleculeGraph();
            mol = new Molecule();
            sel.clonelesscopy(mol);
        } else {
            mol = this.medit.getMol();
        }
        mol.setGUIContracted(false);
        changed = this.unmapAtoms(mol);
        mol.setGUIContracted(true);
        changed = this.unmapAtoms(mol) || changed;
        return changed;
    }

    private boolean unmapAtoms(Molecule mol) {
        boolean changed = false;
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom ma = mol.getAtom(i);
            if (ma.getAtomMap() == 0) continue;
            ma.setAtomMap(0);
            changed = true;
        }
        return changed |= this.unmapSgroupSuperatoms(mol);
    }

    private boolean unmapSgroupSuperatoms(Molecule mol) {
        boolean changed = false;
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            SgroupAtom a;
            Sgroup sg = mol.getSgroup(i);
            if (!(sg instanceof SuperatomSgroup) || (a = ((SuperatomSgroup)sg).getSuperAtom()).getAtomMap() == 0) continue;
            a.setAtomMap(0);
            changed = true;
        }
        return changed;
    }

    private boolean mapReaction(Molecule mol, Molecule refmol) {
        if (this.autoMapper == null) {
            this.autoMapper = (MarvinModule)MarvinModule.load("AutoMapper", null);
        }
        this.setMappingMethod();
        if (refmol != null) {
            for (int i = refmol.getAtomCount() - 1; i >= 0; --i) {
                int map = refmol.getAtom(i).getAtomMap();
                if (map == 0) continue;
                this.autoMapper.modfunc(new Object[]{"setForbiddenMap", new Integer(map)});
            }
        }
        if (this.autoMapper.modfunc(new Object[]{"map", mol}) != null) {
            return true;
        }
        this.medit.internalError(new Exception("Could not map molecule."));
        return false;
    }

    private void setMappingMethod() {
        String s = null;
        switch (mappingMethod) {
            case 27: {
                s = "Complete";
                break;
            }
            case 28: {
                s = "Changing";
                break;
            }
            case 29: {
                s = "Matching";
            }
        }
        this.autoMapper.modfunc(new Object[]{"setOption", "MappingStyle", s});
    }
}

