/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.modules.RectangleSM;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MEllipse;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class EllipseSM
extends RectangleSM {
    private transient MEllipse ellipse;

    public EllipseSM() {
        this(new MEllipse());
        this.ellipse = (MEllipse)this.getMObject();
    }

    public EllipseSM(EllipseSM so) {
        super(so);
        this.ellipse = (MEllipse)this.getMObject();
    }

    protected EllipseSM(MEllipse r) {
        super(r);
        this.ellipse = r;
    }

    @Override
    public void initMObject(MObject o) {
        super.initMObject(o);
        this.ellipse = (MEllipse)o;
    }

    @Override
    public void reset() {
        super.reset();
    }

    public MEllipse getEllipse() {
        return this.ellipse;
    }

    @Override
    public Object clone() {
        return new EllipseSM(this);
    }

    protected MEllipse newEllipse() {
        MEllipse e = (MEllipse)this.ellipse.clone();
        if ((e.getTOption() & 1) != 0) {
            e.transformTo2D();
        }
        return e;
    }

    @Override
    public void paintTemporaryObject(Graphics2D g) {
        MolEditor med = this.getEditor();
        MolPainter painter = med.getPainter();
        DPoint3 p1 = this.startPoint.getLocation();
        DPoint3 p2 = this.getEndPoint().getLocation();
        if (this.squareMode) {
            this.calcSquareEndPoint(p1, p2);
        }
        painter.calcGP(p1);
        painter.calcGP(p2);
        double x0 = (p1.x + p2.x) / 2.0;
        double y0 = (p1.y + p2.y) / 2.0;
        double rx = Math.abs(p2.x - p1.x) / 2.0;
        double ry = Math.abs(p2.y - p1.y) / 2.0;
        g.setColor(painter.getColors().getForeground());
        g.draw(new Ellipse2D.Double(x0 - rx, y0 - ry, 2.0 * rx, 2.0 * ry));
    }

    @Override
    public int modkeyChange(int mod) {
        MolEditor med = this.getEditor();
        int oldmod = med.getModifiers();
        if ((mod & 1) == 0 && (oldmod & 1) != 0) {
            this.squareMode = false;
            return 1;
        }
        if ((mod & 1) != 0 && (oldmod & 1) == 0) {
            this.squareMode = true;
            return 1;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        DPoint3 p;
        oos.writeByte(0);
        int f = 0;
        if (this.startPoint != null) {
            f |= 2;
        }
        if (this.clickPoint != null) {
            f |= 4;
        }
        oos.writeInt(f);
        if ((f & 2) != 0) {
            p = this.startPoint.getLocation();
            oos.writeDouble(p.x);
            oos.writeDouble(p.y);
            oos.writeDouble(p.z);
        }
        if ((f & 4) != 0) {
            p = this.clickPoint.getLocation();
            oos.writeDouble(p.x);
            oos.writeDouble(p.y);
            oos.writeDouble(p.z);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        double z;
        double y;
        double x;
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        int f = ois.readInt();
        if ((f & 2) != 0) {
            x = ois.readDouble();
            y = ois.readDouble();
            z = ois.readDouble();
            this.startPoint = new MPoint(x, y, z);
        } else {
            this.startPoint = null;
        }
        if ((f & 4) != 0) {
            x = ois.readDouble();
            y = ois.readDouble();
            z = ois.readDouble();
            this.clickPoint = new MPoint(x, y, z);
        } else {
            this.clickPoint = null;
        }
        this.ellipse = (MEllipse)this.getMObject();
    }
}

