/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.graphics.MPolylinePainter;
import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.MObjectPO;
import chemaxon.marvin.sketch.MObjectSM;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.modules.ArrowSM;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRArrow;
import chemaxon.struc.graphics.MRectanglePoint;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LineSM
extends MObjectSM {
    private static final long serialVersionUID = -3027378722557760362L;
    public static final int POLYLINE = 1;
    public static final int RECT8_START = 2;
    public static final int RECT8_END = 4;
    private transient int flags;
    protected transient MPoint startPoint = null;
    private transient boolean polylineAdded = false;
    private transient MPoint clickPoint = null;
    protected transient MPolyline polyline = null;
    protected transient boolean cursorMoved = false;
    protected transient MObject draggedObject = null;
    protected boolean shiftPressed = false;

    public LineSM() {
        this(new MPolyline(), 0);
    }

    public LineSM(String opt) {
        this(new MPolyline(), 0);
        if (opt.equals("RECT8_ONLY")) {
            this.setFlags(6, 6);
        }
    }

    public LineSM(int f) {
        this(new MPolyline(), f);
    }

    public LineSM(LineSM so) {
        super(so);
        this.flags = so.flags;
        this.startPoint = so.startPoint != null ? (MPoint)so.startPoint.clone() : null;
        this.clickPoint = so.clickPoint != null ? (MPoint)so.clickPoint.clone() : null;
        this.cursorMoved = so.cursorMoved;
        this.polylineAdded = so.polylineAdded;
        this.polyline = (MPolyline)this.getMObject();
    }

    protected LineSM(MPolyline line, int f) {
        super(null, line);
        this.polyline = line;
        this.flags = f;
    }

    @Override
    public void initMObject(MObject o) {
        super.initMObject(o);
        this.polyline = (MPolyline)o;
    }

    public void setFlag(int f) {
        this.flags |= f;
    }

    public void setFlags(int f, int mask) {
        this.flags = this.flags & ~mask | f & mask;
    }

    @Override
    public void reset() {
        super.reset();
        this.setStartPoint(null);
        this.clickPoint = null;
        this.polylineAdded = false;
        this.cursorMoved = false;
        this.draggedObject = null;
    }

    public MPolyline getPolyline() {
        return this.polyline;
    }

    @Override
    public Object clone() {
        return new LineSM(this);
    }

    @Override
    public boolean canPointToAtom() {
        return this.draggedObject == null;
    }

    @Override
    public boolean canPointToBond() {
        return this.draggedObject == null;
    }

    @Override
    public boolean canPointToMObject() {
        return this.draggedObject == null;
    }

    @Override
    public int buttonDown(boolean dblClick, int modifiers) {
        RgMolecule mo;
        Molecule mor;
        MPoint p;
        int ret = 0;
        this.shiftPressed = (modifiers & 1) != 0;
        MolEditor medit = this.getEditor();
        this.clickPoint = p = medit.getMPointerPos(false);
        MDocument doc = medit.getDocument();
        PointedObject po = medit.getPointedObject();
        if ((po == null || !(po instanceof AtomPO)) && doc.getMainMoleculeGraph() instanceof RgMolecule && (mor = (mo = (RgMolecule)doc.getMainMoleculeGraph()).getRoot()) instanceof RxnMolecule) {
            RxnMolecule rmor = (RxnMolecule)mor;
            MRArrow ao = rmor.getReactionArrow(false);
            SketchMode sm = medit.getSketchMode();
            if (ao != null && ao instanceof MRArrow && sm instanceof ArrowSM && !(sm instanceof ArrowSM.Regular) && !(sm instanceof ArrowSM.TwoHeaded)) {
                return ret;
            }
        }
        if (dblClick) {
            this.setStartPoint(null);
            this.polylineAdded = false;
        } else if (this.startPoint == null) {
            if (this.isValidStartPoint(p)) {
                this.setStartPoint(p);
            }
        } else {
            p = this.getEndPoint();
            if (!p.equals(this.startPoint) && this.isValidEndPoint(p)) {
                MPolyline l;
                if (po == null && (modifiers & 1) == 0) {
                    this.calcPointTo15DegreesLine(p);
                }
                if ((this.flags & 1) != 0) {
                    if (this.polylineAdded) {
                        int i = doc.getObjectCount() - 1;
                        MPolyline l2 = (MPolyline)doc.getObject(i);
                        doc.setObject(this.createPolyline(l2, p), i);
                    } else {
                        l = this.createLine(this.startPoint, p);
                        this.addObject(l);
                        this.polylineAdded = true;
                    }
                    if (this.isValidStartPoint(p)) {
                        this.setStartPoint(p);
                    }
                } else {
                    l = this.createLine(this.startPoint, p);
                    this.addObject(l);
                    this.setStartPoint(null);
                }
                medit.historize();
                ret = 2;
            }
        }
        return ret;
    }

    @Override
    public int buttonUp(int modifiers, boolean doHist) {
        MolEditor medit = this.getEditor();
        MPoint p = medit.getMPointerPos(false);
        if (this.startPoint != null && this.clickPoint != null) {
            if (this.cursorMoved && p.equals(this.clickPoint)) {
                this.reset();
                return 0;
            }
            if ((this.flags & 1) == 0 && !(p = this.getEndPoint()).equals(this.startPoint) && this.isValidEndPoint(p)) {
                PointedObject po = medit.getPointedObject();
                if (po == null && (modifiers & 1) == 0) {
                    this.calcPointTo15DegreesLine(p);
                }
                MPolyline l = this.createLine(this.startPoint, p);
                boolean skip = false;
                if (l != null && !(l instanceof MRArrow)) {
                    skip = this.addObject(l);
                }
                this.setStartPoint(null);
                if (!skip) {
                    medit.historize();
                }
                return 2;
            }
        } else if (this.draggedObject != null) {
            this.draggedObject = null;
            medit.historize();
            return 2;
        }
        return 0;
    }

    private void calcPointTo15DegreesLine(MPoint p) {
        DPoint3 p1 = this.startPoint.getLocation();
        DPoint3 p2 = p.getLocation();
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        double f = dx != 0.0 || dy != 0.0 ? Math.atan2(dy, dx) : 0.0;
        double df = 0.2617993877991494;
        double phi = (double)Math.round(f / df) * df;
        CTransform3D t = new CTransform3D();
        t.setRotation(0.0, 0.0, 1.0, phi - f);
        t.setRotationCenter(p1);
        CTransform3D t2 = this.getEditor().getPainter().getInvRTransform();
        t2.mul(t);
        t2.mul(this.getEditor().getPainter().getRTransformRef());
        t2.setRotationCenter(p1);
        t2.transform(p2);
        p.setLocation(p2, null);
    }

    protected boolean addObject(MPolyline l) {
        MolEditor medit = this.getEditor();
        if (l == null) {
            return true;
        }
        for (int i = 0; i < l.getPointCount(); ++i) {
            MPoint p = l.getPoint(i);
            if (!(p instanceof MAtomSetPoint)) continue;
            MolAtom[] atoms = ((MAtomSetPoint)p).getAtoms();
            for (int j = 0; j < atoms.length; ++j) {
                medit.ungroupSgroupOf(atoms[j], false);
            }
        }
        MDocument doc = medit.getDocument();
        doc.addObject(l);
        return false;
    }

    protected MPoint getStartPoint() {
        return this.startPoint;
    }

    protected void setStartPoint(MPoint p) {
        this.cursorMoved = false;
        this.startPoint = p;
    }

    @Override
    public boolean pointerMove(int modifiers) {
        this.cursorMoved = true;
        this.shiftPressed = (modifiers & 1) != 0;
        return this.startPoint != null;
    }

    @Override
    public boolean pointerDrag(int modifiers) {
        PointedObject po;
        this.cursorMoved = true;
        boolean bl = this.shiftPressed = (modifiers & 1) != 0;
        if (this.startPoint != null) {
            return true;
        }
        MolEditor ed = this.getEditor();
        if (this.draggedObject == null && (po = ed.getPointedObject()) != null && po instanceof MObjectPO) {
            this.draggedObject = ((MObjectPO)po).getMObject();
        }
        if (this.draggedObject != null) {
            DPoint3 dpos = ed.getPointerPosDiff();
            CTransform3D T = new CTransform3D();
            T.setTranslation(dpos);
            this.draggedObject.transform(T, 1, ed.getPainter().getRTransformRef());
            return true;
        }
        return false;
    }

    @Override
    public boolean pointerCopyDrag(int modifiers) {
        return true;
    }

    @Override
    public boolean isTemporaryObjectPaintingNeeded() {
        return this.startPoint != null;
    }

    @Override
    public void paintTemporaryObject(Graphics2D g) {
        MolEditor medit = this.getEditor();
        MolPainter painter = medit.getPainter();
        DPoint3 p1 = this.startPoint.getLocation();
        DPoint3 p2 = this.getEndPoint().getLocation();
        PointedObject po = medit.getPointedObject();
        if (!this.shiftPressed && po == null) {
            double dx = p1.x - p2.x;
            double dy = p1.y - p2.y;
            double f = dx != 0.0 || dy != 0.0 ? Math.atan2(dy, dx) : 0.0;
            double df = 0.2617993877991494;
            double phi = (double)Math.round(f / df) * df;
            CTransform3D t = new CTransform3D();
            t.setRotation(0.0, 0.0, 1.0, phi - f);
            t.setRotationCenter(p1);
            CTransform3D t2 = painter.getInvRTransform();
            t2.mul(t);
            t2.mul(painter.getRTransformRef());
            t2.setRotationCenter(p1);
            t2.transform(p2);
        }
        CTransform3D t = painter.getTransformMatrix();
        MPolyline l = new MPolyline(new MPoint(p1), new MPoint(p2));
        if (this.polyline != null) {
            this.polyline.copyProperties(l);
        }
        MPolylinePainter mpp = new MPolylinePainter();
        mpp.paint(l, g, t, 0, painter.getColors().getForeground(), null, null);
    }

    protected MPoint getEndPoint() {
        return this.getEditor().getMPointerPos(false);
    }

    protected MPolyline createPolyline(MPolyline l, MPoint p) {
        return new MPolyline(l, p);
    }

    protected MPolyline createLine(MPoint p1, MPoint p2) {
        MPolyline l = new MPolyline(p1, p2);
        this.initLine(l);
        return l;
    }

    protected void initLine(MPolyline l) {
        if (this.polyline != null) {
            this.polyline.copyProperties(l);
        }
    }

    protected boolean isValidStartPoint(MPoint p) {
        return (this.flags & 2) == 0 || p instanceof MRectanglePoint;
    }

    protected boolean isValidEndPoint(MPoint p) {
        return (this.flags & 4) == 0 || p instanceof MRectanglePoint;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeInt(this.flags);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        this.flags = ois.readInt();
        this.polyline = (MPolyline)this.getMObject();
    }
}

