/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

public class MObjectDoubleProp {
    public static final int REAL = 0;
    public static final int NONNEGATIVE = 1;
    public static final int POSITIVE = 2;
    private String actionCommand;
    private int meditCommand;
    private Double value;
    private double defaultValue;
    private double defaultValueToSet;
    private int allowedValues;
    private boolean valueSet;

    public MObjectDoubleProp(String cmd, int medcmd, Double v, double defv, double defv2set, int allowed) {
        this.actionCommand = cmd;
        this.meditCommand = medcmd;
        this.value = v;
        this.defaultValue = defv;
        this.defaultValueToSet = defv2set;
        this.allowedValues = allowed;
        this.valueSet = false;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public int getMolEditorCommand() {
        return this.meditCommand;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public Double getValue() {
        return this.value;
    }

    public boolean isSet() {
        return this.valueSet;
    }

    public double getDefaultValueToSet() {
        return this.defaultValueToSet;
    }

    public void setDefault() {
        this.value = null;
        this.valueSet = true;
    }

    public void setValue(String s) throws IllegalArgumentException {
        double v;
        try {
            v = Double.valueOf(s);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("\"" + s + "\" is not a real number");
        }
        if (this.allowedValues == 1 && v < 0.0) {
            throw new IllegalArgumentException("\"" + s + "\" is not a nonnegative number");
        }
        if (this.allowedValues == 2 && v <= 0.0) {
            throw new IllegalArgumentException("\"" + s + "\" is not a positive number");
        }
        if (this.value == null && v != this.defaultValue || this.value != null && this.value != v) {
            this.valueSet = true;
            this.value = new Double(v);
        }
    }
}

