/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.sketch.MObjectSM;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MRectangle;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RectangleSM
extends MObjectSM {
    private static final long serialVersionUID = 7651042804024754357L;
    protected transient MPoint startPoint = null;
    protected transient MPoint clickPoint = null;
    private transient MRectangle rectangle;
    protected boolean squareMode = false;

    public RectangleSM() {
        this(new MRectangle());
    }

    public RectangleSM(RectangleSM so) {
        super(so);
        this.startPoint = so.startPoint != null ? (MPoint)so.startPoint.clone() : null;
        this.clickPoint = so.clickPoint != null ? (MPoint)so.clickPoint.clone() : null;
        this.rectangle = (MRectangle)this.getMObject();
    }

    protected RectangleSM(MRectangle r) {
        super(null, r);
        this.rectangle = r;
    }

    @Override
    public void initMObject(MObject o) {
        super.initMObject(o);
        this.rectangle = (MRectangle)o;
    }

    @Override
    public void reset() {
        super.reset();
        this.startPoint = null;
        this.clickPoint = null;
        this.squareMode = false;
    }

    public MRectangle getRectangle() {
        return this.rectangle;
    }

    @Override
    public Object clone() {
        return new RectangleSM(this);
    }

    @Override
    public int buttonDown(boolean dblClick, int modifiers) {
        MPoint p;
        int ret = 0;
        MolEditor med = this.getEditor();
        this.clickPoint = p = med.getMPointerPos(false);
        if (dblClick) {
            this.startPoint = null;
        } else if (this.startPoint == null) {
            this.startPoint = p;
        } else {
            p = this.getEndPoint();
            if (!p.equals(this.startPoint)) {
                if (this.squareMode) {
                    CTransform3D trot = med.getPainter().getTransformMatrix();
                    DPoint3 p1 = this.startPoint.getLocation(trot);
                    DPoint3 p2 = p.getLocation(trot);
                    this.calcSquareEndPoint(p1, p2);
                    p.setLocation(p2, trot);
                }
                this.setCorners(this.startPoint, p);
                this.addObject(this.newRectangle());
                this.startPoint = null;
                med.historize();
                ret = 2;
            }
        }
        return ret;
    }

    @Override
    public int buttonUp(int modifiers, boolean doHist) {
        MolEditor med = this.getEditor();
        MPoint p = med.getMPointerPos(false);
        if (this.startPoint != null && this.clickPoint != null && !p.equals(this.clickPoint) && (p = this.getEndPoint()).distanceFrom(this.startPoint.getLocation().x, this.startPoint.getLocation().y) > 1.0) {
            if (this.squareMode) {
                CTransform3D trot = med.getPainter().getTransformMatrix();
                DPoint3 p1 = this.startPoint.getLocation(trot);
                DPoint3 p2 = p.getLocation(trot);
                this.calcSquareEndPoint(p1, p2);
                p.setLocation(p2, trot);
            }
            this.setCorners(this.startPoint, p);
            this.addObject(this.newRectangle());
            this.startPoint = null;
            med.historize();
            this.updateStructure(med);
            return 2;
        }
        return 0;
    }

    private void updateStructure(MolEditor med) {
        Molecule mol = med.getMol();
        if (!(this.rectangle instanceof MBracket)) {
            return;
        }
        Sgroup sg = med.findContainingSgroup((MBracket)this.rectangle);
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            if (!this.rectangle.containsAtom(atom) || sg.indexOf(atom) == -1) continue;
            sg.add(atom);
        }
    }

    protected void addObject(MObject o) {
        MolEditor med = this.getEditor();
        MDocument doc = med.getDocument();
        doc.addObject(o);
    }

    protected MRectangle newRectangle() {
        MRectangle r = (MRectangle)this.rectangle.clone();
        if ((r.getTOption() & 1) != 0) {
            r.transformTo2D();
        }
        return r;
    }

    protected void setCorners(MPoint p1, MPoint p2) {
        double ymax;
        double ymin;
        double xmax;
        double xmin;
        MolPainter painter = this.getEditor().getPainter();
        CTransform3D trot = painter.getRTransform();
        DPoint3 pp1 = p1.getLocation();
        DPoint3 pp2 = p2.getLocation();
        trot.transform(pp1);
        trot.transform(pp2);
        double x1 = pp1.x;
        double y1 = pp1.y;
        double x2 = pp2.x;
        double y2 = pp2.y;
        double z = (pp1.z + pp2.z) / 2.0;
        if (x1 < x2) {
            xmin = x1;
            xmax = x2;
        } else {
            xmin = x2;
            xmax = x1;
        }
        if (y1 < y2) {
            ymin = y1;
            ymax = y2;
        } else {
            ymin = y2;
            ymax = y1;
        }
        pp1.x = xmin;
        pp1.y = ymax;
        pp1.z = z;
        pp2.x = xmax;
        pp2.y = ymax;
        pp2.z = z;
        DPoint3 pp3 = new DPoint3(xmax, ymin, z);
        DPoint3 pp4 = new DPoint3(xmin, ymin, z);
        MPoint[] points = new MPoint[]{new MPoint(pp1), new MPoint(pp2), new MPoint(pp3), new MPoint(pp4)};
        painter.getInvRTransform(trot);
        for (int i = 0; i < points.length; ++i) {
            points[i].transform(trot, 0, painter.getRTransformRef());
        }
        this.rectangle.setPoints(points);
    }

    @Override
    public boolean pointerMove(int modifiers) {
        return this.startPoint != null;
    }

    @Override
    public boolean pointerDrag(int modifiers) {
        return this.startPoint != null;
    }

    @Override
    public boolean pointerCopyDrag(int modifiers) {
        return true;
    }

    @Override
    public boolean isTemporaryObjectPaintingNeeded() {
        return this.startPoint != null;
    }

    @Override
    public void paintTemporaryObject(Graphics2D g) {
        MolEditor med = this.getEditor();
        MolPainter painter = med.getPainter();
        DPoint3 p1 = this.startPoint.getLocation();
        DPoint3 p2 = this.getEndPoint().getLocation();
        if (this.squareMode) {
            this.calcSquareEndPoint(p1, p2);
        }
        painter.calcGP(p1);
        painter.calcGP(p2);
        int x1 = (int)Math.round(p1.x);
        int y1 = (int)Math.round(p1.y);
        int x2 = (int)Math.round(p2.x);
        int y2 = (int)Math.round(p2.y);
        g.setColor(painter.getColors().getForeground());
        g.drawLine(x1, y1, x2, y1);
        g.drawLine(x2, y1, x2, y2);
        g.drawLine(x2, y2, x1, y2);
        g.drawLine(x1, y2, x1, y1);
    }

    protected MPoint getEndPoint() {
        MObject mo;
        MolEditor med = this.getEditor();
        Object o = med.getObjectAtPointer();
        MObject mObject = mo = o != null && o instanceof MObject ? (MObject)o : null;
        if (mo != null && mo instanceof MPoint) {
            return (MPoint)mo;
        }
        return med.getMPointerPos(false);
    }

    @Override
    public int modkeyChange(int mod) {
        MolEditor med = this.getEditor();
        int oldmod = med.getModifiers();
        if ((mod & 1) == 0 && (oldmod & 1) != 0) {
            this.squareMode = false;
            return 1;
        }
        if ((mod & 1) != 0 && (oldmod & 1) == 0) {
            this.squareMode = true;
            return 1;
        }
        return 0;
    }

    protected void calcSquareEndPoint(DPoint3 p1, DPoint3 p2) {
        double dy;
        double dx = Math.abs(p1.x - p2.x);
        if (dx < (dy = Math.abs(p1.y - p2.y))) {
            p2.y = p1.y < p2.y ? (p2.y -= dy - dx) : (p2.y += dy - dx);
        } else if (dx > dy) {
            p2.x = p1.x < p2.x ? (p2.x += dy - dx) : (p2.x -= dy - dx);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        DPoint3 p;
        oos.writeByte(0);
        int f = 0;
        if (this.startPoint != null) {
            f |= 2;
        }
        if (this.clickPoint != null) {
            f |= 4;
        }
        oos.writeInt(f);
        if ((f & 2) != 0) {
            p = this.startPoint.getLocation();
            oos.writeDouble(p.x);
            oos.writeDouble(p.y);
            oos.writeDouble(p.z);
        }
        if ((f & 4) != 0) {
            p = this.clickPoint.getLocation();
            oos.writeDouble(p.x);
            oos.writeDouble(p.y);
            oos.writeDouble(p.z);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        double z;
        double y;
        double x;
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        int f = ois.readInt();
        if ((f & 2) != 0) {
            x = ois.readDouble();
            y = ois.readDouble();
            z = ois.readDouble();
            this.startPoint = new MPoint(x, y, z);
        } else {
            this.startPoint = null;
        }
        if ((f & 4) != 0) {
            x = ois.readDouble();
            y = ois.readDouble();
            z = ois.readDouble();
            this.clickPoint = new MPoint(x, y, z);
        } else {
            this.clickPoint = null;
        }
        this.rectangle = (MRectangle)this.getMObject();
    }
}

