/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.modules.RectangleSM;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MRoundedRectangle;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RoundedRectangleSM
extends RectangleSM {
    private transient MRoundedRectangle rrectangle;

    public RoundedRectangleSM() {
        this(new MRoundedRectangle());
        this.rrectangle = (MRoundedRectangle)this.getMObject();
    }

    public RoundedRectangleSM(RoundedRectangleSM so) {
        super(so);
        this.rrectangle = (MRoundedRectangle)this.getMObject();
    }

    protected RoundedRectangleSM(MRoundedRectangle r) {
        super(r);
        this.rrectangle = r;
    }

    @Override
    public void initMObject(MObject o) {
        super.initMObject(o);
        this.rrectangle = (MRoundedRectangle)o;
    }

    @Override
    public MRoundedRectangle getRectangle() {
        return this.rrectangle;
    }

    @Override
    public Object clone() {
        return new RoundedRectangleSM(this);
    }

    protected MRoundedRectangle newRoundedRectangle() {
        MRoundedRectangle rr = (MRoundedRectangle)this.rrectangle.clone();
        if ((rr.getTOption() & 1) != 0) {
            rr.transformTo2D();
        }
        return rr;
    }

    @Override
    public void paintTemporaryObject(Graphics2D g) {
        MolEditor med = this.getEditor();
        MolPainter painter = med.getPainter();
        DPoint3 p1 = this.startPoint.getLocation();
        DPoint3 p2 = this.getEndPoint().getLocation();
        if (this.squareMode) {
            this.calcSquareEndPoint(p1, p2);
        }
        painter.calcGP(p1);
        painter.calcGP(p2);
        double w = Math.abs(p2.x - p1.x);
        double h = Math.abs(p2.y - p1.y);
        double s = painter.getTransformMatrix().getScale();
        double aw = Math.abs(w * s / 100.0);
        double ah = Math.abs(h * s / 100.0);
        this.rrectangle.setCornersRadius(aw / 50.0, ah / 50.0);
        g.setColor(painter.getColors().getForeground());
        g.draw(new RoundRectangle2D.Double(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), w, h, aw, ah));
    }

    @Override
    public int modkeyChange(int mod) {
        MolEditor med = this.getEditor();
        int oldmod = med.getModifiers();
        if ((mod & 1) == 0 && (oldmod & 1) != 0) {
            this.squareMode = false;
            return 1;
        }
        if ((mod & 1) != 0 && (oldmod & 1) == 0) {
            this.squareMode = true;
            return 1;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        DPoint3 p;
        oos.writeByte(0);
        int f = 0;
        if (this.startPoint != null) {
            f |= 2;
        }
        if (this.clickPoint != null) {
            f |= 4;
        }
        oos.writeInt(f);
        if ((f & 2) != 0) {
            p = this.startPoint.getLocation();
            oos.writeDouble(p.x);
            oos.writeDouble(p.y);
            oos.writeDouble(p.z);
        }
        if ((f & 4) != 0) {
            p = this.clickPoint.getLocation();
            oos.writeDouble(p.x);
            oos.writeDouble(p.y);
            oos.writeDouble(p.z);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        double z;
        double y;
        double x;
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        int f = ois.readInt();
        if ((f & 2) != 0) {
            x = ois.readDouble();
            y = ois.readDouble();
            z = ois.readDouble();
            this.startPoint = new MPoint(x, y, z);
        } else {
            this.startPoint = null;
        }
        if ((f & 4) != 0) {
            x = ois.readDouble();
            y = ois.readDouble();
            z = ois.readDouble();
            this.clickPoint = new MPoint(x, y, z);
        } else {
            this.clickPoint = null;
        }
        this.rrectangle = (MRoundedRectangle)this.getMObject();
    }
}

