/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.core.util.GeomUtil;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SgroupUpdate {
    private SgroupUpdate() {
    }

    private static ArrayList<Sgroup> selectContainedSgroups(MoleculeGraph sgroupGraph, MSelectionDocument selectionDoc, Molecule molecule) {
        int nSgroups = molecule.getSgroupCount();
        ArrayList<Sgroup> addedSgroups = null;
        for (int i = 0; i < nSgroups; ++i) {
            Sgroup sgToAdd = molecule.getSgroup(i);
            SelectionMolecule sgToAddGraph = sgToAdd.getSgroupGraph();
            if (!sgroupGraph.contains(sgToAddGraph) || sgToAddGraph.contains(sgroupGraph) || sgToAdd.isTotalSelected(sgroupGraph)) continue;
            if (addedSgroups == null) {
                addedSgroups = new ArrayList<Sgroup>();
            }
            addedSgroups.add(sgToAdd);
            if (sgToAdd.getBracketCount() == 0) continue;
            ArrayList<MBracket> brackets = sgToAdd.getBrackets();
            for (int k = 0; k < brackets.size(); ++k) {
                selectionDoc.addObject(brackets.get(k));
                brackets.get(k).setSelected(true);
            }
        }
        return addedSgroups;
    }

    public static ArrayList<Sgroup> extendSgroupSelectionToWholeFragments(MoleculeGraph sgroupGraph, MSelectionDocument selectionDoc, Molecule molecule) {
        MoleculeGraph umol = molecule.getGraphUnion();
        for (int i = 0; i < sgroupGraph.getAtomCount(); ++i) {
            umol.findFrag(umol.indexOf(sgroupGraph.getAtom(i)), sgroupGraph);
        }
        return SgroupUpdate.selectContainedSgroups(sgroupGraph, selectionDoc, molecule);
    }

    public static ArrayList<Sgroup> extendSgroupSelectionToSubgraph(MoleculeGraph sgroupGraph, MSelectionDocument selectionDoc, Molecule molecule) {
        Sgroup sg = new Sgroup(null, 12);
        sg.setSgroupGraph((SelectionMolecule)sgroupGraph);
        CleanUtil.generateBracketCoords(sg, 12, false);
        SgroupUpdate.adjustSgroupContentToSimpleBrackets(molecule, sg, false);
        return SgroupUpdate.selectContainedSgroups(sgroupGraph, selectionDoc, molecule);
    }

    public static boolean isSgroupToExtendToWholeFragments(int type) {
        return type == 3 || type == 4 || type == 13 || type == 9 || type == 8;
    }

    public static boolean isSgroupToExtendToSubgraph(int type) {
        return type == 1 || type == 12;
    }

    private static void cleanSgroupContent(Molecule molecule, Sgroup sgroup) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            molecule.setSgroupParent(molecule.getAtom(i), sgroup, false);
        }
    }

    private static void addConnectionGraphToSgroup(Molecule molecule, Sgroup sgroup, List<MolAtom> sgroupAtoms, List<MolAtom> leavingAtoms, boolean alsoInMolecule) {
        while (!sgroupAtoms.isEmpty() && leavingAtoms.size() > 0) {
            MolAtom[] ligands;
            MolAtom atom = sgroupAtoms.remove(sgroupAtoms.size() - 1);
            if (leavingAtoms.contains(atom)) continue;
            if (!sgroup.hasAtom(atom)) {
                if (alsoInMolecule) {
                    molecule.setSgroupParent(atom, sgroup, true);
                } else {
                    sgroup.add(atom);
                }
            }
            for (MolAtom ligand : ligands = atom.getLigands()) {
                if (sgroupAtoms.contains(ligand) || sgroup.hasAtom(ligand)) continue;
                sgroupAtoms.add(ligand);
            }
        }
    }

    private static boolean findConnectionForAtom(MolAtom atom, MolAtom otherAtom, List<MolAtom> crossingBondAtoms, List<MolAtom> atomsInside, List<MolAtom> atomsOutside) {
        MolAtom[] ligands;
        ArrayList<MolAtom> connectedAtoms = new ArrayList<MolAtom>();
        for (MolAtom ligand : ligands = atom.getLigands()) {
            if (ligand == otherAtom) continue;
            connectedAtoms.add(ligand);
        }
        ArrayList<MolAtom> checkedAtoms = new ArrayList<MolAtom>();
        checkedAtoms.add(atom);
        boolean foundOne = false;
        while (!connectedAtoms.isEmpty() && !foundOne) {
            MolAtom[] ligs;
            MolAtom a = (MolAtom)connectedAtoms.remove(connectedAtoms.size() - 1);
            checkedAtoms.add(a);
            foundOne = a != otherAtom && crossingBondAtoms.contains(a);
            if (foundOne) continue;
            for (MolAtom ligand : ligs = a.getLigands()) {
                if (checkedAtoms.contains(ligand)) continue;
                connectedAtoms.add(ligand);
            }
        }
        if (foundOne) {
            atomsInside.addAll(checkedAtoms);
            atomsOutside.add(otherAtom);
        }
        return foundOne;
    }

    private static void checkAtomsFromBracketPosition(MolBond crossingBond, List<MBracket> brackets, MolBond[][] crossingBonds, List<MolAtom> atomsInside, List<MolAtom> atomsOutside) {
        int bracketIndex = -1;
        for (int i = 0; i < crossingBonds.length && bracketIndex == -1; ++i) {
            for (int j = 0; j < crossingBonds[i].length && bracketIndex == -1; ++j) {
                if (crossingBonds[i][j] != crossingBond) continue;
                bracketIndex = i;
            }
        }
        MBracket bracket = brackets.get(bracketIndex);
        DPoint3 p1 = bracket.getPoint(0).getLocation();
        DPoint3 p2 = bracket.getPoint(3).getLocation();
        double a = (p2.y - p1.y) / (p2.x - p1.x);
        double b = p1.y - a * p1.x;
        int sideCount = 0;
        for (int i = 0; i < brackets.size(); ++i) {
            if (bracketIndex == i || crossingBonds[i].length == 0) continue;
            MBracket otherBracket = brackets.get(i);
            DPoint3 otherP1 = otherBracket.getPoint(0).getLocation();
            DPoint3 otherP2 = otherBracket.getPoint(1).getLocation();
            if (otherP1.y > a * otherP1.x + b && otherP2.y > a * otherP2.x + b) {
                --sideCount;
                continue;
            }
            if (!(otherP1.y < a * otherP1.x + b) || !(otherP2.y < a * otherP2.x + b)) continue;
            ++sideCount;
        }
        int side = sideCount < 0 ? -1 : 1;
        MolAtom atom1 = crossingBond.getAtom1();
        MolAtom atom2 = crossingBond.getAtom2();
        DPoint3 atom1Pos = atom1.getLocation();
        if ((double)side * (a * atom1Pos.x + b - atom1Pos.y) > 0.0) {
            atomsInside.add(atom1);
            atomsOutside.add(atom2);
        } else {
            atomsOutside.add(atom1);
            atomsInside.add(atom2);
        }
    }

    private static boolean isBracketOrientedToAtom(MBracket bracket, MolAtom atom) {
        DPoint3 p1 = bracket.getPoint(0).getLocation();
        DPoint3 p2 = bracket.getPoint(3).getLocation();
        DPoint3 bracketEnd = bracket.getPoint(2).getLocation();
        DPoint3 atomPos = atom.getLocation();
        double a = (p2.y - p1.y) / (p2.x - p1.x);
        double b = p1.y - a * p1.x;
        return (a * bracketEnd.x + b - bracketEnd.y) * (a * atomPos.x + b - atomPos.y) > 0.0;
    }

    private static void checkCrossingBondAtoms(Sgroup sgroup, MolBond[][] crossingBonds, List<MolAtom> atomsInside, List<MolAtom> atomsOutside) {
        int j;
        int i;
        ArrayList<MolAtom> crossingBondAtoms = new ArrayList<MolAtom>();
        for (i = 0; i < crossingBonds.length; ++i) {
            for (j = 0; j < crossingBonds[i].length; ++j) {
                crossingBondAtoms.add(crossingBonds[i][j].getAtom1());
                crossingBondAtoms.add(crossingBonds[i][j].getAtom2());
            }
        }
        for (i = 0; i < crossingBonds.length; ++i) {
            for (j = 0; j < crossingBonds[i].length; ++j) {
                MolAtom atom1 = crossingBonds[i][j].getAtom1();
                MolAtom atom2 = crossingBonds[i][j].getAtom2();
                if (atomsInside.contains(atom1) && !atomsOutside.contains(atom2)) {
                    atomsOutside.add(atom2);
                    continue;
                }
                if (atomsInside.contains(atom2) && !atomsOutside.contains(atom1)) {
                    atomsOutside.add(atom1);
                    continue;
                }
                if (sgroup.hasAtom(atom2) && !sgroup.hasAtom(atom1)) {
                    MolAtom swap = atom1;
                    atom1 = atom2;
                    atom2 = swap;
                }
                if (SgroupUpdate.findConnectionForAtom(atom1, atom2, crossingBondAtoms, atomsInside, atomsOutside) || SgroupUpdate.findConnectionForAtom(atom2, atom1, crossingBondAtoms, atomsInside, atomsOutside)) continue;
                SgroupUpdate.checkAtomsFromBracketPosition(crossingBonds[i][j], sgroup.getBrackets(), crossingBonds, atomsInside, atomsOutside);
            }
        }
    }

    private static void findCrossingBonds(Molecule molecule, Sgroup sgroup, List<MolAtom> atomsInside, List<MolAtom> atomsOutside) {
        int i;
        ArrayList<MBracket> brackets = sgroup.getBrackets();
        MolBond[][] crossingBonds = new MolBond[brackets.size()][];
        int crossingBondCount = 0;
        for (i = 0; i < brackets.size(); ++i) {
            MBracket bracket = (MBracket)brackets.get(i);
            DPoint3 p1 = bracket.getPoint(0).getLocation();
            DPoint3 p2 = bracket.getPoint(3).getLocation();
            crossingBonds[i] = GeomUtil.getCrossingBonds(molecule.getBondArray(), p1, p2, true);
            crossingBondCount += crossingBonds[i].length;
        }
        if (crossingBondCount == 0) {
            return;
        }
        if (crossingBondCount == 1) {
            for (i = 0; i < crossingBonds.length && crossingBonds[i].length == 0; ++i) {
            }
            MolAtom atom1 = crossingBonds[i][0].getAtom1();
            MolAtom atom2 = crossingBonds[i][0].getAtom2();
            if (SgroupUpdate.isBracketOrientedToAtom((MBracket)brackets.get(i), atom1)) {
                atomsInside.add(atom1);
                atomsOutside.add(atom2);
            } else {
                atomsOutside.add(atom1);
                atomsInside.add(atom2);
            }
            return;
        }
        SgroupUpdate.checkCrossingBondAtoms(sgroup, crossingBonds, atomsInside, atomsOutside);
    }

    private static boolean adjustSgroupContentToPolymerBrackets(Molecule molecule, Sgroup sgroup) throws IllegalArgumentException {
        ArrayList<MBracket> brackets = sgroup.getBrackets();
        for (MBracket bracket : brackets) {
            if (bracket.getBracketOrientation() != 5) continue;
            throw new IllegalArgumentException("Illegal brackets: double S-group bracket where should be single.");
        }
        MolAtom[] originalAtoms = sgroup.getAtomArray();
        ArrayList<MolAtom> leavingAtoms = new ArrayList<MolAtom>();
        ArrayList<MolAtom> sgroupAtoms = new ArrayList<MolAtom>();
        SgroupUpdate.findCrossingBonds(molecule, sgroup, sgroupAtoms, leavingAtoms);
        SgroupUpdate.cleanSgroupContent(molecule, sgroup);
        SgroupUpdate.addConnectionGraphToSgroup(molecule, sgroup, sgroupAtoms, leavingAtoms, true);
        MolAtom[] atoms = sgroup.getAtomArray();
        return originalAtoms.length != atoms.length || !Arrays.asList(originalAtoms).containsAll(Arrays.asList(atoms));
    }

    private static void setSgroupByBracketContent(Molecule mol, MBracket bracket, Sgroup sg) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            DPoint3 location = atom.getLocation();
            if (bracket.enclosesPoint(location.x, location.y) && !sg.hasAtom(atom)) {
                mol.setSgroupParent(atom, sg, true);
                continue;
            }
            if (bracket.enclosesPoint(location.x, location.y) || !sg.hasAtom(atom)) continue;
            mol.setSgroupParent(atom, sg, false);
        }
    }

    private static boolean adjustSgroupContentToSimpleBrackets(Molecule molecule, Sgroup sgroup, boolean alsoInMolecule) throws IllegalArgumentException {
        MBracket bracket = sgroup.getBrackets().get(0);
        if (bracket.getBracketOrientation() == 4) {
            throw new IllegalArgumentException("Illegal brackets: no pair for a single bracket.");
        }
        MolAtom[] originalAtoms = sgroup.getAtomArray();
        if (alsoInMolecule) {
            SgroupUpdate.setSgroupByBracketContent(molecule, bracket, sgroup);
        }
        MolBond[] head = GeomUtil.getCrossingBonds(molecule.getBondArray(), bracket.getPoint(0).getLocation(), bracket.getPoint(3).getLocation(), true);
        MolBond[] tail = GeomUtil.getCrossingBonds(molecule.getBondArray(), bracket.getPoint(1).getLocation(), bracket.getPoint(2).getLocation(), true);
        ArrayList<MolAtom> leavingAtoms = new ArrayList<MolAtom>();
        for (MolBond bond : head) {
            if (sgroup.hasAtom(bond.getAtom1())) {
                leavingAtoms.add(bond.getAtom2());
                continue;
            }
            leavingAtoms.add(bond.getAtom1());
        }
        for (MolBond bond : tail) {
            if (sgroup.hasAtom(bond.getAtom1())) {
                leavingAtoms.add(bond.getAtom2());
                continue;
            }
            leavingAtoms.add(bond.getAtom1());
        }
        ArrayList<MolAtom> sgroupAtoms = new ArrayList<MolAtom>(Arrays.asList(sgroup.getAtomArray()));
        SgroupUpdate.addConnectionGraphToSgroup(molecule, sgroup, sgroupAtoms, leavingAtoms, alsoInMolecule);
        MolAtom[] atoms = sgroup.getAtomArray();
        return originalAtoms.length != atoms.length || !Arrays.asList(originalAtoms).containsAll(Arrays.asList(atoms));
    }

    public static boolean adjustSgroupContentToBrackets(Molecule molecule, Sgroup sgroup) throws IllegalArgumentException {
        int bracketCount = sgroup.getBracketCount();
        if (bracketCount == 0) {
            return false;
        }
        if (bracketCount == 1) {
            return SgroupUpdate.adjustSgroupContentToSimpleBrackets(molecule, sgroup, true);
        }
        return SgroupUpdate.adjustSgroupContentToPolymerBrackets(molecule, sgroup);
    }
}

