/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import chemaxon.marvin.paint.internal.GraphicsPainter;
import chemaxon.marvin.paint.internal.GraphicsPresentationChooser;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import javax.swing.Icon;

public class MolIcon
implements Icon,
Serializable {
    private static final long serialVersionUID = -4256190830063435603L;
    private MObject mObject = null;
    private MDocument document = null;
    private MolPainter molPainter = null;
    private int iconWidth = 0;
    private int iconHeight = 0;
    private GraphicsPresentationChooser grPres;

    public MolIcon(int w, int h) {
        this.iconWidth = w;
        this.iconHeight = h;
    }

    public MolIcon(Molecule m, MolPainter p, int w, int h) {
        this(w, h);
        this.document = new MDocument(m.cloneMolecule());
        this.molPainter = p;
    }

    public MolIcon(MObject mo, int w, int h) {
        this(w, h);
        this.mObject = mo;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.translate(x, y);
        if (this.document != null) {
            this.molPainter.paintDocument((Graphics2D)g, this.document, null);
        } else if (this.mObject != null) {
            CTransform3D t = new CTransform3D();
            t.setIdentity();
            if (this.grPres == null) {
                this.grPres = new GraphicsPresentationChooser();
            }
            GraphicsPainter gp = this.grPres.getGraphicsPainter(this.mObject.getClass());
            gp.paint(this.mObject, (Graphics2D)g, t, 1, Color.black, null, null);
        }
        g.translate(-x, -y);
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }
}

