/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.uif.builder.SimpleModuleConfiguration;
import chemaxon.marvin.uif.builder.impl.action.ActionSet;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.module.ConfigurationException;
import chemaxon.marvin.uif.module.ConfigurationProvider;
import chemaxon.marvin.uif.module.ModuleConfiguration;
import chemaxon.marvin.uif.module.support.DefaultGUIRegistry;
import chemaxon.marvin.uif.util.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;

public class SimpleConfigurationProvider
extends ConfigurationProvider {
    @Override
    public ModuleConfiguration getConfiguration(Class<?> clazz, String resource, String actionsResource) throws ConfigurationException {
        return new SimpleModuleConfiguration(SimpleConfigurationProvider.read(clazz, DefaultGUIRegistry.class, resource), SimpleConfigurationProvider.read(clazz, ActionSet.class, actionsResource));
    }

    @Override
    public GUIRegistry getRegistry(Class<?> clazz, String resource) throws ConfigurationException {
        return SimpleConfigurationProvider.read(clazz, DefaultGUIRegistry.class, resource);
    }

    private static <E> E read(Class<?> clazz, Class<E> target, String name) throws ConfigurationException {
        if (target != GUIRegistry.class && !name.endsWith(".ser")) {
            try {
                return SimpleConfigurationProvider.readImpl(clazz, target, name + ".ser");
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return SimpleConfigurationProvider.readImpl(clazz, target, name);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <E> E readImpl(Class<?> clazz, Class<E> target, String name) throws ConfigurationException {
        E e;
        InputStream is = null;
        ObjectInputStream ois = null;
        try {
            is = SimpleConfigurationProvider.getStream(clazz, name);
            if (is == null) {
                throw new ConfigurationException("Missing resource: " + name);
            }
            Utils.VersionedInputStream vis = new Utils.VersionedInputStream(is);
            ois = new ObjectInputStream(vis);
            Object result = null;
            if (vis.getVersion() != -1) {
                result = target.newInstance();
                ((Externalizable)result).readExternal(ois);
            } else {
                result = ois.readObject();
            }
            e = target.cast(result);
        }
        catch (InstantiationException e2) {
            try {
                throw new ConfigurationException(e2);
                catch (IllegalAccessException e3) {
                    throw new ConfigurationException(e3);
                }
                catch (MalformedURLException e4) {
                    throw new ConfigurationException(e4);
                }
                catch (IOException e5) {
                    throw new ConfigurationException(e5);
                }
                catch (ClassNotFoundException e6) {
                    throw new ConfigurationException("Invalid resource", e6);
                }
                catch (ClassCastException e7) {
                    throw new ConfigurationException("Invalid resource", e7);
                }
            }
            catch (Throwable throwable) {
                Utils.close(ois);
                Utils.close(is);
                throw throwable;
            }
        }
        Utils.close(ois);
        Utils.close(is);
        return e;
    }

    private static InputStream getStream(Class<?> clazz, String resource) {
        InputStream result = BasicEnvironment.getResourceAsStream(clazz, resource);
        if (result == null) {
            result = Utils.getInputStream(resource);
        }
        return result;
    }
}

